/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.service;

import com.jinfonet.util.JDLog;
import com.jinfonet.web.beans.ParameterInfoImpl;
import com.jinfonet.web.beans.ReportParameter;
import com.jinfonet.web.beans.ReportParameterImpl;
import com.jinfonet.web.modules.component.service.util.TemplateKit;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import jet.connect.DbValue;
import jet.exception.ParseFormulaFailedException;
import jet.formula.ParamDesc;
import jet.formula.formulaExecutor.ExecFormulaFailedException;
import jet.parameter.UserInput;
import jet.server.util.ParamUtil;
import jet.webreport.beans.FieldValue;
import jet.webreport.beans.Parameter;

public final class ParameterKit {
    public static Parameter getParameter(ParamDesc paramDesc, Locale locale, long l, boolean bl) {
        TimeZone timeZone = TimeZone.getDefault();
        ReportParameterImpl reportParameterImpl = (ReportParameterImpl)TemplateKit.makeReportParameter(paramDesc, locale, timeZone, bl);
        Parameter parameter = new Parameter(paramDesc.getName());
        parameter.setDataType(paramDesc.getType());
        parameter.setSqlType(ParameterInfoImpl.mapSqlType(paramDesc.getType()));
        parameter.setFormatPattern(paramDesc.getLocalizedUserFormat(locale));
        parameter.setUserFormat(paramDesc.getFormat());
        String string = paramDesc.getPrompt();
        parameter.setPrompt(string);
        if (string != null && string.trim().length() > 0) {
            parameter.setDispName(string);
        }
        parameter.setAllowTypeIn(paramDesc.isAllowTypeIn());
        parameter.setAllSelected(paramDesc.isAllSelected());
        parameter.setAllowAll(paramDesc.isAllowAll());
        int n = paramDesc.isRequired() ? 1 : 0;
        n |= ParameterKit.getIsOnlySelect(paramDesc) ? 2 : 0;
        n |= paramDesc.isReferedBy() ? 4 : 0;
        parameter.setMask(n |= paramDesc.isMultipleValue() ? 8 : 0);
        ParameterKit.ReportParameterImpl2Parameter4Values(reportParameterImpl, parameter);
        if (reportParameterImpl.isCascading()) {
            parameter.setCascadingInfo(paramDesc.getChainID(), reportParameterImpl.getPrevCascadingName(), reportParameterImpl.getNextCascadingName());
        }
        parameter.setBindColumn(paramDesc.getBeColumn() == 4);
        parameter.setIsAnonymous(reportParameterImpl.isAnonymous());
        return parameter;
    }

    static void ReportParameterImpl2Parameter4Values(ReportParameter reportParameter, Parameter parameter) {
        if (JDLog.isTrace((int)4)) {
            JDLog.trace((int)4, (Object)"--ParameterKit ReportParameterImpl2Parameter4Values...");
            JDLog.trace((int)4, (Object)("ReportParameter=" + reportParameter));
        }
        List list = reportParameter.getAvailableValues();
        List list2 = reportParameter.getAvailableDispValues();
        int n = list == null ? 0 : list.size();
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>(n);
        for (int i = 0; i < n; ++i) {
            FieldValue fieldValue = new FieldValue();
            fieldValue.setMultiRealValue(new String[]{(String)list.get(i)});
            fieldValue.setMultiDispValue(new String[]{(String)list2.get(i)});
            arrayList.add(fieldValue);
        }
        parameter.setAvailableValues(arrayList);
        if (reportParameter.allowMultiple() && parameter.isAllowAll() && parameter.isAll()) {
            parameter.setRealValues(new String[]{""});
            parameter.setDispValues(new String[]{""});
        } else {
            List list3 = reportParameter.getCurrentValues();
            int n2 = list3 == null ? 0 : list3.size();
            String[] stringArray = new String[n2];
            String[] stringArray2 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = (String)list3.get(i);
                int n3 = n == 0 ? -1 : list.indexOf(stringArray[i]);
                stringArray2[i] = n3 < 0 ? stringArray[i] : (String)list2.get(n3);
                if (!JDLog.isTrace((int)4)) continue;
                JDLog.trace((int)4, (Object)("disVal=" + stringArray2[i] + " : rval=" + stringArray[i]));
            }
            parameter.setDispValues(stringArray2);
            parameter.setRealValues(stringArray);
        }
        if (JDLog.isTrace((int)4)) {
            JDLog.trace((int)4, (Object)"--ParameterKit ReportParameterImpl2Parameter4Values end");
        }
    }

    public static String getRealValue(ParamDesc paramDesc, Locale locale, long l) {
        DbValue dbValue = paramDesc.getValue();
        if (ParameterKit.isDynamicDate(paramDesc)) {
            dbValue = paramDesc.getDynamicValue(l, locale);
        }
        String string = null;
        if (paramDesc.getBeColumn() == 4) {
            string = paramDesc.getDisplayValue(dbValue, locale);
        } else {
            UserInput userInput;
            string = paramDesc.getDisplayValue(dbValue, locale);
            if (dbValue instanceof UserInput && (userInput = (UserInput)dbValue).isExpression()) {
                string = TemplateKit.convertUserInputRealValue(userInput);
            }
        }
        return string;
    }

    public static boolean isDynamicDate(ParamDesc paramDesc) {
        return paramDesc.isUseCurrentDate() || paramDesc.isUseCurrentDateWhenBlank();
    }

    public static boolean getIsOnlySelect(ParamDesc paramDesc) {
        return paramDesc.IsParameters() || paramDesc.isColumn();
    }

    public static boolean isDateExp(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        boolean bl = false;
        try {
            bl = ParamUtil.parseExpression(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static String getDateStrByExp(String string, String string2, Locale locale) throws ExecFormulaFailedException, ParseFormulaFailedException, ParseException {
        String string3 = ParamUtil.evalExpressionValue(string, string2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        Date date = simpleDateFormat.parse(string3);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2, locale);
        return simpleDateFormat2.format(date);
    }
}

