/*
 * Decompiled with CFR 0.152.
 */
package jet.webreport.service;

import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.api.objectmanager.ObjectManager;
import com.jinfonet.api.objectmanager.ResourceWrapper;
import com.jinfonet.resstore.MemoryStore;
import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.util.JDLog;
import com.jinfonet.util.JRLog;
import com.jinfonet.web.modules.resource.service.util.ReportSetProviderImpl;
import com.jinfonet.web.util.FileUtil;
import com.jinfonet.web.util.Tools;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.controls.JetObject;
import jet.cs.CSUtil;
import jet.dataengine.api.DSException;
import jet.dataservice.api.JDataService;
import jet.jetc.ReadFailureException;
import jet.reportLogic.objectLogic.ObjectLogicFactory;
import jet.reportLogic.objectLogic.ReportLogic;
import jet.reportset.JetRptReport;
import jet.reportset.JetRptReportSet;
import jet.rptservice.api.design.DesignService;
import jet.rptservice.api.exception.JRScheduleException;
import jet.rptservice.design.ReportInformation;
import jet.rptservice.design.ReportRst;
import jet.rptservice.pub.PrincipalAttributes;
import jet.rptservice.util.ReportTools;
import jet.server.api.CatalogVersionRecord;
import jet.server.api.PathInfo;
import jet.server.api.RptServerException;
import jet.server.api.exception.NoPrivilegeException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.ExResourceManager;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.http.JRHttpRptServer;
import jet.server.service.ManagedService;
import jet.server.service.ServiceSummary;
import jet.universe.JetUUniverse;
import jet.web.dhtml.DHTMLConstant;
import jet.web.dhtml.ParamDescTool;
import jet.webreport.service.CatalogKeyImpl;
import jet.webreport.service.CatalogLoader;
import jet.webreport.service.CatalogWrapper;
import jet.webreport.service.ResourceObject;

public final class ResourceKit {
    public static final String DHTML_FOLDER = "webos";
    public static final String LCLINKRPT = "LCLINKRPT";
    private static ExResourceManager CATALOG_PATH = null;
    private static ObjectManager CATALOG_VER_NUM = null;
    private static Hashtable SEDU = null;
    private static String Z;

    public static void setResourceManager(ExResourceManager exResourceManager) {
        CATALOG_PATH = exResourceManager;
    }

    public static String getReportRealPath(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        if (string2 == null) {
            return null;
        }
        n = n == 0 ? -1 : n;
        return CATALOG_PATH.getReportVersion(string, string2, n).getRealPath();
    }

    public static String getCatalogRealPath(String string, String string2, int n) throws NoPrivilegeException, UnknownResource {
        if (string2 == null) {
            return null;
        }
        n = n == 0 ? -1 : n;
        return CATALOG_PATH.getCatalogVersion(string, string2, n).getRealPath();
    }

    public static String getCatalogPath(String string, String string2) throws RptServerException {
        if (string2 == null) {
            return null;
        }
        return CATALOG_PATH.getPathInfo(string, string2).getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTempPath() {
        if (Z != null) {
            return Z;
        }
        Class<ResourceKit> clazz = ResourceKit.class;
        synchronized (ResourceKit.class) {
            if (Z != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return Z;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(CATALOG_PATH.getTempDir());
            stringBuffer.append(DHTML_FOLDER);
            stringBuffer.append(File.separator);
            Z = stringBuffer.toString();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Z;
        }
    }

    public static String getResultTempPath(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        String string5 = File.separator;
        stringBuffer.append(ResourceKit.getTempPath()).append(string2).append(string5).append(string3).append(string5).append(string4).append(string5);
        return stringBuffer.toString();
    }

    public static String getCatalogByReport(String string, String string2) throws Exception {
        PathInfo pathInfo = CATALOG_PATH.getPathInfo(string, string2);
        if (!pathInfo.isReport()) {
            throw new UnknownResource(string2);
        }
        if (pathInfo.isEnableLinkedCatalog()) {
            String string3 = null;
            string3 = !pathInfo.isUseInherited() ? pathInfo.getLinkedCatalog() : CATALOG_PATH.getInheritedLinkedCatalog(string, string2);
            return string3;
        }
        Vector<PathInfo> vector = CATALOG_PATH.getCatalogsInPath(string, pathInfo.getParentPath());
        if (vector != null && vector.size() > 0) {
            return vector.elementAt(0).getPath();
        }
        throw new UnknownResource(string2);
    }

    private static SaveInfo CATALOG_PATH(boolean bl, boolean bl2, String string, String string2, String string3, String string4, String string5, int n) throws NoPrivilegeException, UnknownResource {
        SaveInfo saveInfo = new SaveInfo();
        saveInfo.isNewReport = bl;
        saveInfo.overwrite = bl2;
        saveInfo.nodeName = string5;
        if (saveInfo.isNewReport) {
            if (!bl2) {
                saveInfo.srcPath = CATALOG_PATH.getArchivePath(string2) + File.separator;
                saveInfo.srcRealFile = saveInfo.srcPath + string5;
            } else {
                saveInfo.srcRealFile = ResourceKit.getReportRealPath(string2, string4 + string5, n);
            }
        } else {
            saveInfo.srcPath = FileUtil.getFilePath((String)string);
            saveInfo.srcRealFile = bl2 ? ResourceKit.getReportRealPath(string2, string3, n) : ResourceKit.getReportRealPath(string2, string, n);
            saveInfo.sameFolder = string.equals(string3) || saveInfo.srcPath.equals(string4);
        }
        saveInfo.srcRealPath = FileUtil.getFilePath((String)saveInfo.srcRealFile);
        return saveInfo;
    }

    public static void deployReport(String string, String string2, String string3, String string4, int n, String string5, int n2, boolean bl, Map map) throws Exception {
        DesignService designService = (DesignService)map.get("DesignService");
        String string6 = (String)map.get("rptset_id");
        String string7 = (String)map.get("check_savefilter");
        boolean bl2 = "true".equals(string7);
        String string8 = (String)map.get("check_savesort");
        boolean bl3 = "true".equals(string8);
        String string9 = (String)map.get("check_overwrite");
        boolean bl4 = "true".equals(string9);
        String string10 = "false";
        String string11 = FileUtil.getFileName((String)string2);
        String string12 = FileUtil.getFilePath((String)string2);
        PathInfo pathInfo = CATALOG_PATH.getPathInfo(string, string12);
        boolean bl5 = pathInfo.isDynamic();
        SaveInfo saveInfo = ResourceKit.CATALOG_PATH(string4 == null, bl4, string4, string, string2, string12, string11, n);
        boolean bl6 = saveInfo.sameFolder;
        String string13 = null;
        string13 = bl5 ? pathInfo.getRealPath() + File.separator + saveInfo.nodeName : (bl4 ? saveInfo.srcRealFile : saveInfo.srcRealPath + Tools.getUniqueID() + saveInfo.nodeName);
        designService.saveAs(string6, bl2, bl3, string13);
        Properties properties = new Properties();
        properties.setProperty("jrs.node_type", String.valueOf(0));
        properties.setProperty("jrs.node_name", string11);
        properties.setProperty("jrs.deploy_from_file", string13);
        properties.setProperty("jrs.node_desc", string3);
        properties.setProperty("jrs.report_from_adhoc", string10);
        String string14 = "false";
        String string15 = "true";
        if (string5 != null && string5.trim().length() > 0) {
            properties.setProperty("jrs.catalog", string5);
            n2 = n2 == 0 ? -1 : n2;
            properties.setProperty("jrs.cat_version", String.valueOf(n2));
            if (bl && !bl5) {
                string14 = "true";
                string15 = "false";
                properties.setProperty("jrs.linked.catalog", string5);
            } else if (!bl6 && !string2.endsWith(".clx")) {
                String string16 = FileUtil.getFileName((String)string5);
                if (bl5) {
                    String string17;
                    String string18 = ResourceKit.getCatalogRealPath(string, string5, n2);
                    if (!string18.equals(string17 = pathInfo.getRealPath() + File.separator + string16)) {
                        FileUtil.copyFile((String)string18, (String)string17);
                    }
                } else {
                    String string19 = string12 + string16;
                    ResourceKit.deployCatalog(string, string19, "", string5, n2, map);
                }
            }
        }
        properties.setProperty("jrs.enable.linked.catalog", string14);
        properties.setProperty("jrs.is.use.inherited", string15);
        if (!bl5 && !bl4) {
            CATALOG_PATH.addResource(string, string12, properties, null);
            properties.put("jrs.node_status", String.valueOf(1));
            properties.setProperty("jrs.enable_nls", String.valueOf(true));
            CATALOG_PATH.setNodeProperties(string, string2, properties, null);
            new File(string13).delete();
        }
    }

    public static void deployCatalog(String string, String string2, String string3, String string4, int n, Map map) throws Exception {
        Properties properties = new Properties();
        String string5 = FileUtil.getFilePath((String)string2);
        properties.setProperty("jrs.node_type", String.valueOf(2));
        String string6 = FileUtil.getFileName((String)string2);
        properties.setProperty("jrs.node_name", string6);
        String string7 = ResourceKit.getCatalogRealPath(string, string4, n);
        properties.setProperty("jrs.deploy_from_file", string7);
        properties.setProperty("jrs.node_desc", string3);
        CATALOG_PATH.addResource(string, string5, properties, null);
    }

    public static CatalogKeyImpl getCatalogKey(String string, int n, boolean bl, String string2, String string3) {
        CatalogKeyImpl catalogKeyImpl = (CatalogKeyImpl)SEDU.get(string3);
        if (catalogKeyImpl == null) {
            long l = 0L;
            if (bl) {
                File file = new File(string);
                if (file.exists()) {
                    l = file.lastModified();
                }
            } else {
                try {
                    CatalogVersionRecord catalogVersionRecord = CATALOG_PATH.getCatalogVersion(string2, string, n);
                    n = catalogVersionRecord.getVersionNumber();
                    l = new File(catalogVersionRecord.getRealPath()).lastModified();
                }
                catch (NoPrivilegeException noPrivilegeException) {
                }
                catch (UnknownResource unknownResource) {
                    // empty catch block
                }
            }
            return new CatalogKeyImpl(string, n, l);
        }
        return catalogKeyImpl;
    }

    public static CatalogWrapper getCatalog(String string, int n, boolean bl, String string2, String string3) {
        CatalogKeyImpl catalogKeyImpl = ResourceKit.getCatalogKey(string, n, bl, string2, string3);
        ResourceWrapper resourceWrapper = new ResourceObject(catalogKeyImpl, string, n, bl);
        resourceWrapper.setLoader(new CatalogLoader());
        resourceWrapper.putDependentInfo("dep.user", string2);
        resourceWrapper.putDependentInfo("dep.type", "catalog");
        try {
            resourceWrapper = CATALOG_VER_NUM.get(resourceWrapper);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JetUUniverse jetUUniverse = (JetUUniverse)resourceWrapper.getObject();
        String string4 = CSUtil.parsePrincipalDisplayName(string2)[0];
        JDataService jDataService = ResourceKit.getDataService(string4);
        CatalogKey catalogKey = jDataService.registCatalog((CatalogKey)catalogKeyImpl, jetUUniverse);
        SEDU.put(string3, catalogKey);
        return new CatalogWrapper(catalogKeyImpl.getID(), jetUUniverse, catalogKey);
    }

    public static int getLastVersion(String string, boolean bl, String string2) {
        if (bl) {
            return -1;
        }
        int n = -1;
        try {
            n = CATALOG_PATH.getLatestVersionNumber(string, string2);
        }
        catch (UnknownResource unknownResource) {
            // empty catch block
        }
        return n;
    }

    public static void putOpenRptDependentInfo(String string, int n, String string2, boolean bl, String string3, Hashtable hashtable) {
        String string4 = CSUtil.parsePrincipalDisplayName(string2)[0];
        JDataService jDataService = ResourceKit.getDataService(string4);
        CatalogWrapper catalogWrapper = ResourceKit.getCatalog(string, n, bl, string2, string3);
        PrincipalAttributes principalAttributes = new PrincipalAttributes((JetObject)catalogWrapper.catalog);
        principalAttributes.setDiskPath(catalogWrapper.catalog.getFullFileName());
        principalAttributes.setServerPath(string);
        hashtable.put("catalog", principalAttributes);
        hashtable.put("catalog_key", catalogWrapper.regID);
        hashtable.put("data_service", jDataService);
    }

    public static JDataService getDataService(String string) {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        List list = ((JRRptServer)((Object)httpRptServer)).getServiceManager().listServices(string, "jet.dataservice.api.JDataService");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ManagedService managedService = (ManagedService)list.get(i);
            ServiceSummary serviceSummary = managedService.getSummary();
            if (serviceSummary != null) continue;
            return (JDataService)managedService;
        }
        return null;
    }

    public static void unRegisterCatalog(String string, String string2) {
        CatalogKey catalogKey = (CatalogKey)SEDU.remove(string);
        try {
            if (catalogKey != null) {
                String string3 = CSUtil.parsePrincipalDisplayName(string2)[0];
                ResourceKit.getDataService(string3).unregistCatalog(catalogKey);
            }
        }
        catch (DSException dSException) {
            // empty catch block
        }
    }

    public static ReportRst openReport(DesignService designService, Hashtable hashtable, String string, String string2, String string3) {
        ResourceKit.prepareOpenReport(designService, hashtable, string, string2, string3);
        Object v = hashtable.get("catalog");
        JetUUniverse jetUUniverse = v == null ? null : (JetUUniverse)((PrincipalAttributes)v).getPrincipal();
        String string4 = (String)hashtable.get(LCLINKRPT);
        ReportSetProviderImpl reportSetProviderImpl = null;
        reportSetProviderImpl = string4 == null ? new ReportSetProviderImpl(string3, string2, jetUUniverse) : new ReportSetProviderImpl(jetUUniverse, string4, string2);
        hashtable.put("rpt_set_provider", reportSetProviderImpl);
        hashtable.put("resource_store", com.jinfonet.web.modules.resource.service.util.ResourceKit.getResourceStoreByUser(string2));
        ParamDescTool.extractParams(hashtable);
        return designService.openReport(hashtable);
    }

    public static void prepareOpenReport(DesignService designService, Hashtable hashtable, String string, String string2, String string3) {
        if (hashtable.get("catalog") == null) {
            String string4 = (String)hashtable.get(DHTMLConstant.CATALOG_PATH);
            if (string4 != null) {
                if (string4.indexOf(58) != -1) {
                    throw new RuntimeException("Open report error, incorrect catalog path [ " + string4 + "].");
                }
                String string5 = (String)hashtable.get(DHTMLConstant.CATALOG_VER_NUM);
                int n = -1;
                try {
                    n = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                n = n == -1 ? ResourceKit.getLastVersion(string4, false, string2) : n;
                hashtable.remove(DHTMLConstant.CATALOG_PATH);
                ResourceKit.putOpenRptDependentInfo(string4, n, string2, false, string, hashtable);
            } else {
                String string6 = (String)hashtable.get("jrs.catalog");
                if (string6 != null) {
                    int n = ResourceKit.getLastVersion(string6, false, string2);
                    ResourceKit.putOpenRptDependentInfo(string6, n, string2, false, string, hashtable);
                }
            }
        }
    }

    public static JetUUniverse getPreparedCatalog(DesignService designService, Hashtable hashtable, String string, String string2, String string3) {
        ResourceKit.prepareOpenReport(designService, hashtable, string, string3, null);
        PrincipalAttributes principalAttributes = (PrincipalAttributes)hashtable.get("catalog");
        JetUUniverse jetUUniverse = null;
        if (principalAttributes != null) {
            jetUUniverse = (JetUUniverse)principalAttributes.getPrincipal();
        } else {
            try {
                jetUUniverse = designService.getUniverse(string, string2, null);
            }
            catch (JRScheduleException jRScheduleException) {
                if (JDLog.isError((int)2)) {
                    JDLog.error((int)2, null, (Throwable)jRScheduleException);
                }
                return null;
            }
        }
        return jetUUniverse;
    }

    public static Hashtable getReportSheetInfo(String string, JetUUniverse jetUUniverse, MemoryStore memoryStore) {
        Hashtable<String, ReportInformation> hashtable = new Hashtable<String, ReportInformation>();
        JetRptReportSet jetRptReportSet = null;
        try {
            jetRptReportSet = ReportTools.loadReportSet((String)string, null, (boolean)true, (JetUUniverse)jetUUniverse, (MemoryStore)memoryStore);
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            JRLog.error((int)1, (Object)"", (Throwable)resourceNotFoundException);
            JRLog.trace((int)4, (Throwable)resourceNotFoundException);
            return null;
        }
        catch (ResourceLoadException resourceLoadException) {
            JRLog.error((int)1, (Object)"", (Throwable)resourceLoadException);
            JRLog.trace((int)4, (Throwable)resourceLoadException);
            return null;
        }
        catch (ReadFailureException readFailureException) {
            JRLog.error((int)1, (Object)"", (Throwable)readFailureException);
            JRLog.trace((int)4, (Throwable)readFailureException);
            return null;
        }
        ReportLogic reportLogic = ObjectLogicFactory.getReportLogic();
        String[] stringArray = jetRptReportSet.getAllReportsName();
        for (int i = 0; i < stringArray.length; ++i) {
            JetRptReport jetRptReport = jetRptReportSet.getReport(stringArray[i]);
            ReportInformation reportInformation = new ReportInformation(jetRptReport.getInstName());
            reportInformation.setRptDisplayName(jetRptReport.getDisplayName());
            reportInformation.setStatus(jetRptReport.getStatus());
            reportInformation.setBurstingReport(reportLogic.isBurstingReport(jetRptReport));
            hashtable.put(stringArray[i], reportInformation);
        }
        jetRptReportSet.free();
        return hashtable;
    }

    static {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer();
        try {
            CATALOG_PATH = (ExResourceManager)httpRptServer.getResourceManager();
            if (httpRptServer instanceof JRHttpRptServer) {
                CATALOG_VER_NUM = ((JRHttpRptServer)httpRptServer).getObjectManager();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SEDU = new Hashtable();
        Z = null;
    }

    static class SaveInfo {
        boolean isNewReport;
        boolean overwrite;
        boolean sameFolder;
        String nodeName;
        String srcPath;
        String srcRealFile;
        String srcRealPath;

        SaveInfo() {
        }
    }
}

