/*
 * Decompiled with CFR 0.152.
 */
package server.servlet.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.util.HtmlEncoder;
import jet.server.util.ServerUtil;
import server.servlet.http.HttpRequest;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServer;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.MessageBytes;

public class HttpServerHandler
extends HttpServerHandlerBase {
    private String I = null;
    private String SEDU = null;

    protected HttpServerHandler(HttpServer httpServer) {
        super(httpServer);
        this.I = httpServer.getJRServlet().getJspPath();
        this.SEDU = httpServer.getServerPorps().getProperty("web.dhtml_jsp_path");
    }

    @Override
    protected void service(HttpRequest httpRequest, HttpResponse httpResponse) throws ServletException, IOException {
        String string;
        MessageBytes messageBytes = httpRequest.getRequestPath();
        String string2 = this.parsePath(messageBytes, httpRequest);
        ServiceLogger.logDebug(6680040, string2, 6);
        String string3 = string = "application/x-jreport-deploy-cuscontrol".equalsIgnoreCase(httpRequest.getContentType()) ? string2 : this.getValidPath(string2);
        if (ServerEnv.isVirtualLicence() && ServerEnv.checkExpired() != null && (string == null || !string.endsWith(".gif") && !string.endsWith(".css"))) {
            string = "/jinfonet/expired.jsp";
        }
        if (string == null) {
            httpResponse.sendError(404, "The requested resource (" + messageBytes.toString() + ") is not available.");
            return;
        }
        string2 = string;
        httpRequest.setServletPath(string2);
        if (string2.startsWith("/jradmin") || string2.startsWith("/admin")) {
            httpResponse.sendError(403, "Please use http admin server port " + this.server.adminport + " to access it!");
            return;
        }
        if (string2.toLowerCase().indexOf("<script>") != -1 || string2.toLowerCase().indexOf("%3cscript%3e") != -1 || string2.toLowerCase().indexOf("javascript:") != -1 || string2.toLowerCase().indexOf("vbscript:") != -1) {
            httpResponse.sendError(404, "File not found!");
            return;
        }
        boolean bl = false;
        Properties properties = ((HttpServer)this.server).getMappings();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            String string5 = (String)properties.get(string4);
            if (string4.startsWith(".")) {
                block14: {
                    if (!string2.toLowerCase().endsWith(string4.toLowerCase())) continue;
                    if (string4.equals(".jsp") && !new File(this.server.getRealPath(string2)).exists()) {
                        httpResponse.sendError(404, "File not found: " + HtmlEncoder.encode(string2));
                        return;
                    }
                    Servlet servlet = ((HttpServer)this.server).getServlet(string5);
                    if (servlet == null) {
                        httpResponse.sendError(404, "Cannot load servlet " + string5 + " for serving request");
                        return;
                    }
                    try {
                        servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                    }
                    catch (ServletException servletException) {
                        String string6 = servletException.getMessage();
                        if (string6 == null || string6.indexOf("can't mix text and binary input") >= 0) break block14;
                        throw servletException;
                    }
                }
                bl = true;
                break;
            }
            if (!string2.startsWith(string4) || string2.startsWith(this.SEDU)) continue;
            Servlet servlet = null;
            String string7 = string2.substring(string4.length());
            if (string7.length() == 0 || string7.charAt(0) == '/' || string7.charAt(0) == '\\') {
                servlet = ((HttpServer)this.server).getServlet(string5);
            }
            if (servlet == null) {
                httpResponse.sendError(404, "Cannot load servlet " + string5 + " for serving request");
                return;
            }
            httpRequest.setServletPath(string4);
            String string8 = string2.substring(string4.length());
            if (string8.equals("") || string8.equals("/")) {
                string8 = null;
            }
            httpRequest.setPathInfo(string8);
            servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            bl = true;
            break;
        }
        if (!bl) {
            this.I(httpRequest, httpResponse, string2);
        }
    }

    private void I(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        Object object;
        ServiceLogger.logDebug(6680041, string, 6);
        if (string == null || string.equals("") || string.equals("/")) {
            string = "/index.htm";
        }
        String string2 = string;
        String string3 = "";
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string3 = string2.substring(n);
        }
        String[] stringArray = ServerEnv.getMimeTypeTable().getMimeTypeAndEncoding(string3);
        httpServletResponse.setContentType(stringArray[0]);
        if (stringArray[1] != null) {
            httpServletResponse.setHeader("Content-Encoding", stringArray[1]);
        }
        try {
            if (string.endsWith("/") || string.endsWith(File.separator) || string.startsWith("/..") || string.endsWith(".jsp.bak")) {
                httpServletResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (string.indexOf("<script>") > 0 || string.indexOf("javascript:") > 0) {
                httpServletResponse.sendError(404, "File not found!");
                return;
            }
            object = new File(this.server.getRealPath(string));
            if (((File)object).isDirectory()) {
                httpServletResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (ServerUtil.isFileNotModified((File)object, httpServletRequest, httpServletResponse)) {
                HttpSession httpSession = httpServletRequest.getSession(false);
                String string4 = httpSession == null ? null : httpSession.getId();
                ServiceLogger.logAccessSuccessEvent(ServerEnv.getActiveRealm(), httpServletRequest.getRemoteUser(), string4, 5680042, string, 5);
                return;
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        httpServletResponse.setStatus(200);
        object = httpServletResponse.getOutputStream();
        InputStream inputStream = this.server.getResourceAsStream(string);
        if (inputStream == null) {
            httpServletResponse.sendError(404, "File " + string + " not found!");
            return;
        }
        httpServletResponse.setContentLength(inputStream.available());
        byte[] byArray = new byte[8192];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                ((OutputStream)object).write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
            inputStream.close();
            ((OutputStream)object).close();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        String string5 = httpSession == null ? null : httpSession.getId();
        ServiceLogger.logAccessSuccessEvent(ServerEnv.getActiveRealm(), httpServletRequest.getRemoteUser(), string5, 5680043, string, 6);
    }
}

