/*
 * Decompiled with CFR 0.152.
 */
package barcode.linearBarcode;

import barcode.linearBarcode.Barcode128;
import barcode.linearBarcode.Barcode39;
import barcode.linearBarcode.BarcodeCodabar;
import barcode.linearBarcode.BarcodeEAN13;
import barcode.linearBarcode.BarcodeEAN8;
import barcode.linearBarcode.BarcodeObject;
import barcode.linearBarcode.BarcodeUPCA;
import barcode.linearBarcode.BarcodeUPCE;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public class BarcodeConstraints
extends JComponent {
    private int SEDU;
    private String calculateWidth = new String();
    private String init = new String();
    protected BarcodeObject[] barcodes;
    public boolean runtime = true;
    private String locate;
    public short barHeight = (short)72;
    private int paint = 1;
    private float rotate;
    private String setBar128Type;
    private Color I;
    private Color Z;
    private boolean C;
    private boolean B = true;
    private int D;
    private int F;
    private int J;
    private int S;
    private int A;
    private Font E;
    private int G;
    private int H;
    private short K;
    private short L;
    private int M = 2;
    private int N;
    private boolean O = true;
    private int P;
    private int Q;
    private int R = 3;
    private Graphics g;
    private int T = 2;
    private boolean U;
    private int V;
    private double W;
    private Dimension X = new Dimension();
    private float Y = 1.0f;
    private boolean i;

    public BarcodeConstraints() {
    }

    public BarcodeConstraints(int n, String string) {
        this.SEDU = n;
        this.init = string;
        this.init();
    }

    public void locate() {
        this.P = this.getBounds().width / 2;
        this.Q = this.getBounds().height / 2;
    }

    public void init() {
        this.W = (double)this.V * Math.PI / 180.0;
        this.barcodes = new BarcodeObject[1];
        this.SEDU(this.SEDU, this.init);
        this.locate();
    }

    private void SEDU(int n, String string) {
        switch (n) {
            case 6: {
                this.barcodes[0] = new BarcodeCodabar(this);
                break;
            }
            case 5: {
                this.barcodes[0] = new Barcode128(this);
                break;
            }
            case 4: {
                this.barcodes[0] = new Barcode39(this);
                break;
            }
            case 2: {
                this.barcodes[0] = new BarcodeEAN13(this);
                break;
            }
            case 3: {
                this.barcodes[0] = new BarcodeEAN8(this);
                break;
            }
            case 1: {
                this.barcodes[0] = new BarcodeUPCE(this);
                break;
            }
            case 0: {
                this.barcodes[0] = new BarcodeUPCA(this);
                break;
            }
            case 7: {
                this.barcodes[0] = new Barcode128(this);
                this.setBar128Type(0);
                break;
            }
            case 8: {
                this.barcodes[0] = new Barcode128(this);
                this.setBar128Type(1);
                break;
            }
            case 9: {
                this.barcodes[0] = new Barcode128(this);
                this.setBar128Type(2);
            }
        }
        this.barcodes[0].init();
    }

    public void paint(Graphics2D graphics2D) {
        this.init();
        graphics2D.rotate(this.W);
        this.barcodes[0].paint(graphics2D);
        graphics2D.rotate(-this.W);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.paint(graphics2D);
    }

    public void calculateWidth() {
        this.init();
        this.barcodes[0].calculateWidth();
    }

    public void calculateWidth(Graphics graphics) {
        this.init();
        this.barcodes[0].calculateWidth((Graphics2D)graphics);
    }

    public void setType(int n) {
        this.SEDU = n;
    }

    public int getType() {
        return this.SEDU;
    }

    public void setBodeCodeData(String string) {
        this.init = string;
    }

    public String getBodeCodeData() {
        return this.init;
    }

    public Object clone() {
        return null;
    }

    public void updateProperties() {
    }

    public void updateBounds() {
    }

    public void setBarOrientation(int n) {
        this.V = n;
    }

    public int getBarOrientation() {
        return this.V;
    }

    public void setBarHRFont(Font font) {
        this.E = font;
    }

    public Font getBarHRFont() {
        return this.E;
    }

    public void setBar128Type(int n) {
        this.R = n;
    }

    public int getBar128Type() {
        return this.R;
    }

    public void setBarCheckEnable(boolean bl) {
        this.B = bl;
    }

    public boolean getBarCheckEnable() {
        return this.B;
    }

    public void setBarNarrowWidth(short s) {
        this.paint = s;
    }

    public short getBarNarrowWidth() {
        return (short)this.paint;
    }

    public void setBarMessage(String string) {
        this.init = string;
    }

    public String getBarMessage() {
        return this.init;
    }

    public void setBarQuietZone(short s) {
        this.K = s;
        this.L = s;
    }

    public short getBarQuietZone() {
        return this.K;
    }

    public void setBarRatio(float f) {
        this.M = (int)f;
    }

    public float getBarRatio() {
        return this.M;
    }

    public void setBarScaleMode(int n) {
        this.T = n;
    }

    public int getBarScaleMode() {
        return this.T;
    }

    public void setBarSupplement(String string) {
        this.setBar128Type = string;
    }

    public String getBarSupplement() {
        return this.setBar128Type;
    }

    public void setBarSymbology(int n) {
        this.SEDU = n;
    }

    public int getBarSymbology() {
        return this.SEDU;
    }

    public void setBarHeight(short s) {
        this.barHeight = s;
    }

    public short getBarHeight() {
        return this.barHeight;
    }

    public void setBarHRDisplay(boolean bl) {
        this.O = bl;
    }

    public boolean getBarHRDisplay() {
        return this.O;
    }

    public void setBarTransparent(boolean bl) {
        this.U = bl;
    }

    public boolean getBarTransparent() {
        return this.U;
    }

    @Override
    public void setBackground(Color color) {
        this.I = color;
    }

    @Override
    public Color getBackground() {
        return this.I;
    }

    @Override
    public void setForeground(Color color) {
        this.Z = color;
    }

    @Override
    public Color getForeground() {
        return this.Z;
    }

    public void setCenterXY(int n, int n2) {
        this.P = n;
        this.Q = n2;
    }

    public int getCenterX() {
        return this.P;
    }

    public int getCenterY() {
        return this.Q;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.X;
    }

    public void setBarDimension(Dimension dimension) {
        this.X = dimension;
    }

    public void setUnit(float f) {
        this.Y = f / 100.0f;
    }

    public float getUnit() {
        return this.Y;
    }

    public void setIsExportToPDF(boolean bl) {
        this.i = bl;
    }

    public boolean getIsExportToPDF() {
        return this.i;
    }
}

