/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartComponent;
import chart.ChartObject;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartGradientLabelProperty;
import chart.properties.ChartLegendProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class ChartGradientLabel
extends ChartComponent {
    public static final int BOTTOM = 0;
    float iconW;
    float iconH;
    float iconX;
    float iconY;
    String startLabel;
    String endLabel;
    Color startColor;
    Color endColor;
    Color zeroClr;
    int labelPos;
    boolean wrap;
    ChartTextStyle labelSty;
    ChartTextStyle titleSty;
    double startValue;
    double endValue;
    Object startValueObj;
    Object endValueObj;
    float startLblX;
    float startLblY;
    float endLblX;
    float endLblY;
    boolean isInit = false;
    float gap = 4.0f;
    float igap = 4.0f;
    ChartLegendProperties properties;
    int maxWidth = -1;
    int maxHeight = -1;
    ChartGradientLabelProperty labelProp;
    int maxLabelWidth = -1;
    float txtHGap = 20.0f;
    float txtVGap;
    boolean zeroFillWhite;
    String label;
    float labelX;
    float labelY;
    boolean noStartColor = false;
    Color[] bettwenColors;
    float[] bettwenFracs;
    boolean wrapText = false;

    public ChartGradientLabel(ChartLegendProperties chartLegendProperties, ChartGradientLabelProperty chartGradientLabelProperty) {
        this.properties = chartLegendProperties;
        this.labelProp = chartGradientLabelProperty;
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        return this;
    }

    @Override
    public void init() {
        this.background = null;
        this.gap = this.properties.getLabelVSpacing();
        this.labelSty = (ChartTextStyle)this.labelProp.getLabelStyle().clone();
        this.labelSty.setRotation(0.0);
        this.titleSty = (ChartTextStyle)this.labelProp.getTitleStyle().clone();
        this.titleSty.setRotation(0.0);
        this.iconW = this.labelProp.getIconWidth();
        this.iconH = this.labelProp.getIconHeight();
        this.startColor = this.labelProp.getStartColor();
        this.startColor = this.abs();
        this.endColor = this.SEDU();
        this.zeroClr = this.labelProp.getZeroUseColor();
        this.bettwenColors = this.labelProp.getInnerColors();
        this.bettwenFracs = this.labelProp.getInnerFracts();
        this.noStartColor = this.labelProp.getStartColor() == null;
        this.startValueObj = this.labelProp.getStartValue();
        this.endValueObj = this.labelProp.getEndValue();
        this.startLabel = this.labelProp.getStartLabel();
        this.endLabel = this.labelProp.getEndLabel();
        this.startValue = this.startValueObj != null && this.startValueObj instanceof Number ? ((Number)this.startValueObj).doubleValue() : (this.startValueObj != null && this.startValueObj instanceof Date ? (double)((Date)this.startValueObj).getTime() : 0.0);
        if (this.endValueObj != null && this.endValueObj instanceof Number) {
            this.endValue = ((Number)this.endValueObj).doubleValue();
        } else if (this.endValueObj != null && this.endValueObj instanceof Date) {
            this.endValue = ((Date)this.endValueObj).getTime();
        }
        if (this.endValue < this.startValue) {
            this.endValue = this.startValue;
        }
        if (this.startLabel == null) {
            this.startLabel = this.startValueObj != null && this.startValueObj instanceof Number && this.properties.getValueFormat() != null ? this.properties.getValueFormat().filter(this.startValueObj) : (this.startValueObj != null && this.properties.getLegendFilter() != null ? this.properties.getLegendFilter().filter(this.startValueObj) : (this.startValueObj != null ? this.startValueObj.toString() : "" + this.startValue));
        }
        if (this.endLabel == null) {
            this.endLabel = this.endValueObj != null && this.endValueObj instanceof Number && this.properties.getValueFormat() != null ? this.properties.getValueFormat().filter(this.endValueObj) : (this.endValueObj != null && this.properties.getLegendFilter() != null ? this.properties.getLegendFilter().filter(this.endValueObj) : (this.endValueObj != null ? this.endValueObj.toString() : "" + this.endValue));
        }
        this.zeroFillWhite = this.labelProp.getMapZeroToWhite();
        this.wrap = this.labelProp.getWrap();
        this.txtVGap = this.properties.getLabelStyle().getIconTextGap();
        this.label = this.labelProp.getLabel();
    }

    private Color SEDU() {
        return this.labelProp.getEndColor();
    }

    private Color abs() {
        if (this.labelProp.getStartColor() == null) {
            return new Color(255, 255, 255);
        }
        return this.labelProp.getStartColor();
    }

    @Override
    public void locate() {
        this.add();
    }

    private void add() {
        if (this.labelPos == 0) {
            ChartTextStyle chartTextStyle = (ChartTextStyle)this.labelSty.clone();
            ChartTextStyle chartTextStyle2 = (ChartTextStyle)this.titleSty.clone();
            Rectangle2D rectangle2D = chartTextStyle.getDimension(this.startLabel);
            Rectangle2D rectangle2D2 = chartTextStyle.getDimension(this.endLabel);
            float f = this.txtHGap;
            float f2 = this.txtVGap;
            float f3 = 0.0f;
            if (this.label != null && !this.label.equals("")) {
                f3 = (float)chartTextStyle2.getDimension(this.label).getHeight();
                f3 += f2;
            }
            rectangle2D2 = chartTextStyle.getDimension(this.endLabel);
            rectangle2D = chartTextStyle.getDimension(this.startLabel);
            Rectangle2D rectangle2D3 = chartTextStyle2.getDimension(this.label);
            float f4 = (float)(rectangle2D.getWidth() + rectangle2D2.getWidth());
            float f5 = (float)chartTextStyle2.getDimension(this.label).getWidth() + 2.0f + this.gap;
            f5 = f5 < f4 ? (f4 += 12.0f) : f5;
            this.labelX = 1.0f;
            this.labelY = 1.0f;
            if (f3 > 0.0f) {
                this.labelY += f3 - f2;
                this.iconY = this.labelY + f2;
            } else {
                this.iconY = this.labelY;
            }
            this.startLblX = this.iconX = 1.0f;
            this.endLblX = this.iconW + 4.0f >= f4 ? (float)((double)(this.iconX + this.iconW) - (rectangle2D2.getWidth() + 1.0)) : (float)((double)(f4 - 4.0f) - rectangle2D2.getWidth());
            this.startLblY = this.iconY + this.iconH + f2;
            this.startLblY = (float)((double)this.startLblY + rectangle2D.getHeight());
            this.endLblY = this.iconY + this.iconH + f2;
            this.endLblY = (float)((double)this.endLblY + rectangle2D2.getHeight());
            float f6 = 0.0f;
            float f7 = 0.0f;
            f6 += this.iconW + 4.0f;
            f7 += this.iconH + 4.0f;
            f7 += f2;
            f7 = (float)((double)(f7 += f3) + (rectangle2D.getHeight() > rectangle2D2.getHeight() ? rectangle2D.getHeight() : rectangle2D2.getHeight()));
            float f8 = f6 = f6 < f5 ? f5 : f6;
            if (this.maxWidth > 0) {
                float f9 = f6 = f6 > (float)this.maxWidth ? (float)this.maxWidth : f6;
            }
            if (this.maxHeight > 0) {
                f7 = f7 > (float)this.maxHeight ? (float)this.maxHeight : f7;
            }
            this.setSize((int)f6, (int)f7);
            if (this.wrap && this.maxWidth > 0) {
                Rectangle2D rectangle2D4 = chartTextStyle2.getDimension(this.label);
                float f10 = (float)rectangle2D4.getHeight();
                if (f5 > (float)this.maxWidth) {
                    ChartTextStyle chartTextStyle3 = (ChartTextStyle)this.labelSty.clone();
                    chartTextStyle3.setRotation(0.0);
                    chartTextStyle3.setWordWrapWidth(this.maxWidth);
                    chartTextStyle3.setWordWrapper(true);
                    Rectangle2D rectangle2D5 = chartTextStyle3.getDimension(this.label);
                    float f11 = (float)(rectangle2D5.getHeight() - rectangle2D4.getHeight());
                    if (f11 > 0.0f) {
                        f7 = (f7 += f11) > (float)this.maxHeight ? (float)this.maxHeight : f7;
                        this.wrapText = true;
                        this.iconY += f11;
                        this.startLblY += f11;
                        this.endLblY += f11;
                        this.setSize((int)f6, (int)f7);
                    }
                } else {
                    this.wrapText = false;
                }
            } else {
                this.wrapText = false;
            }
        }
    }

    private void append() {
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Object object;
        Object object2;
        super.paint(graphics2D);
        Rectangle2D.Float float_ = null;
        Object var3_3 = null;
        float f = this.igap;
        float f2 = this.properties.getLabelStyle().getIcon().getPen().getPenWidth();
        float f3 = this.iconH;
        float f4 = this.iconX;
        float f5 = this.iconY;
        float f6 = this.iconW;
        float f7 = this.iconH;
        f6 = f6 < 0.0f ? 0.0f : f6;
        f7 = f7 < 0.0f ? 0.0f : f7;
        float_ = new Rectangle2D.Float(f4, f5, f6, f7);
        if (float_ != null && float_.getWidth() > 0.0 && float_.getHeight() > 0.0 && this.labelProp.getEndColor() != null && this.labelProp.getStartColor() != null) {
            object2 = null;
            object = new Point2D.Float(float_.x, 0.0f);
            Point2D.Float float_2 = new Point2D.Float(float_.x + float_.width, 0.0f);
            Color[] colorArray = null;
            float[] fArray2 = null;
            if (this.bettwenColors != null && this.bettwenFracs != null) {
                int n = this.bettwenColors.length;
                n = n < this.bettwenFracs.length ? this.bettwenFracs.length : n;
                colorArray = new Color[n + 2];
                fArray2 = new float[n + 2];
                for (int i = 0; i < n; ++i) {
                    colorArray[i + 1] = this.bettwenColors[i];
                    fArray2[i + 1] = this.bettwenFracs[i];
                }
                colorArray[0] = this.startColor;
                colorArray[colorArray.length - 1] = this.endColor;
                fArray2[0] = 0.0f;
                fArray2[fArray2.length - 1] = 1.0f;
                object2 = new LinearGradientPaint((Point2D)object, float_2, fArray2, colorArray);
            } else if (this.startValue < 0.0 && this.endValue > 0.0 && this.zeroFillWhite) {
                colorArray = new Color[]{this.startColor, new Color(255, 255, 255), this.endColor};
                if (this.zeroFillWhite && this.zeroClr != null) {
                    colorArray[1] = new Color(this.zeroClr.getRed(), this.zeroClr.getGreen(), this.zeroClr.getBlue());
                }
                fArray2 = new float[2];
                double d = Math.abs(this.endValue - this.startValue);
                d = d == 0.0 ? 1.0 : d;
                fArray2 = new float[3];
                fArray2 = new float[3];
                fArray2[0] = 0.0f;
                fArray2[1] = (float)(-this.startValue / d);
                fArray2[1] = (float)((double)fArray2[1] >= 0.95 ? 0.95 : (double)fArray2[1]);
                fArray2[1] = (float)((double)fArray2[1] <= 0.05 ? 0.05 : (double)fArray2[1]);
                fArray2[2] = 1.0f;
                object2 = new LinearGradientPaint((Point2D)object, float_2, fArray2, colorArray);
            } else if (this.startValue == 0.0 && this.endValue > 0.0 && this.zeroFillWhite) {
                colorArray = new Color[]{this.startColor, this.endColor};
                fArray2 = new float[2];
                double d = Math.abs(this.endValue - this.startValue);
                d = d == 0.0 ? 1.0 : d;
                fArray2[0] = 0.0f;
                fArray2[1] = 1.0f;
                object2 = new LinearGradientPaint((Point2D)object, float_2, fArray2, colorArray);
            } else {
                colorArray = new Color[]{this.startColor, this.endColor};
                fArray2 = new float[2];
                double d = Math.abs(this.endValue - this.startValue);
                d = d == 0.0 ? 1.0 : d;
                fArray2[0] = 0.0f;
                fArray2[1] = 1.0f;
                object2 = new LinearGradientPaint((Point2D)object, float_2, fArray2, colorArray);
            }
            graphics2D.setPaint((Paint)object2);
            graphics2D.fill(float_);
            Rectangle2D.Float float_3 = new Rectangle2D.Float(float_.x + f2 / 2.0f, float_.y + f2 / 2.0f, float_.width - f2, float_.height + f2);
            ChartPenStyle chartPenStyle = (ChartPenStyle)this.properties.getLabelStyle().getIcon().getPen().clone();
            chartPenStyle.draw(graphics2D, float_3);
        }
        if (this.wrapText) {
            object2 = null;
            if (this.properties.getIsTruncate()) {
                object = (Graphics2D)graphics2D.create();
                ((Graphics)object).clipRect((int)this.iconX, 0, (int)(this.iconW + 1.0f), this.maxHeight);
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).drawText((Graphics2D)object, this.startLabel, this.startLblX, this.startLblY);
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).drawText((Graphics2D)object, this.endLabel, this.endLblX, this.endLblY);
            } else {
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).drawText(graphics2D, this.startLabel, this.startLblX, this.startLblY);
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).drawText(graphics2D, this.endLabel, this.endLblX, this.endLblY);
            }
        } else {
            object2 = null;
            if (this.properties.getIsTruncate()) {
                object = (Graphics2D)graphics2D.create();
                ((Graphics)object).clipRect((int)this.iconX, 0, (int)(this.iconW + 1.0f), this.maxHeight);
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).drawText((Graphics2D)object, this.startLabel, this.startLblX, this.startLblY);
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).drawText((Graphics2D)object, this.endLabel, this.endLblX, this.endLblY);
            } else {
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).drawText(graphics2D, this.startLabel, this.startLblX, this.startLblY);
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).drawText(graphics2D, this.endLabel, this.endLblX, this.endLblY);
            }
        }
        if (this.label != null && !this.label.equals("")) {
            if (!this.wrapText) {
                object2 = (ChartTextStyle)this.titleSty.clone();
                ((ChartTextStyle)object2).drawText(graphics2D, this.label, this.labelX, this.labelY);
            } else {
                object2 = (ChartTextStyle)this.labelSty.clone();
                ((ChartTextStyle)object2).setRotation(0.0);
                ((ChartTextStyle)object2).setWordWrapWidth(this.maxWidth);
                ((ChartTextStyle)object2).setWordWrapper(true);
                ((ChartTextStyle)object2).drawText(graphics2D, this.label, this.labelX, this.labelY);
            }
        }
    }

    public void setStartValue(Object object) {
        this.startValueObj = object;
    }

    public void setEndValue(Object object) {
        this.endValueObj = object;
    }

    public void setStartColor(Color color) {
        this.startColor = color;
    }

    public void setEndColor(Color color) {
        this.endColor = color;
    }

    public static Color getReverseColor(Color color) {
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue());
        float f = 0.155f * (float)color2.getRed() + 202.4f;
        float f2 = 0.155f * (float)color2.getGreen() + 202.4f;
        float f3 = 0.155f * (float)color2.getBlue() + 202.4f;
        f = Math.round(f);
        f2 = Math.round(f2);
        f3 = Math.round(f3);
        f = f > 255.0f ? 255.0f : f;
        f2 = f2 > 255.0f ? 255.0f : f2;
        f3 = f3 > 255.0f ? 255.0f : f3;
        return new Color((int)f, (int)f2, (int)f3);
    }

    public void setLabelPosition(int n) {
        this.labelPos = n;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
    }

    public void setStartLabel(String string) {
        this.startLabel = string;
    }

    public void setEndLabel(String string) {
        this.endLabel = string;
    }

    public void setProperties(ChartLegendProperties chartLegendProperties) {
        this.properties = chartLegendProperties;
    }

    public void setMaxWidth(float f) {
        if (f < 0.0f) {
            this.maxWidth = 0;
            return;
        }
        this.maxWidth = (int)f;
    }

    public void setMaxHeight(float f) {
        this.maxHeight = (int)f;
    }

    public static Color getMidColor(int[] nArray, int[] nArray2, float f) {
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        f2 = (float)nArray[0] + f * (float)(nArray2[0] - nArray[0]);
        f3 = (float)nArray[1] + f * (float)(nArray2[1] - nArray[1]);
        f4 = (float)nArray[2] + f * (float)(nArray2[2] - nArray[2]);
        f2 = f2 < 0.0f ? 0.0f : f2;
        f2 = f2 > 255.0f ? 255.0f : f2;
        f3 = f3 < 0.0f ? 0.0f : f3;
        f3 = f3 > 255.0f ? 255.0f : f3;
        f4 = f4 < 0.0f ? 0.0f : f4;
        f4 = f4 > 255.0f ? 255.0f : f4;
        return new Color((int)f2, (int)f3, (int)f4);
    }

    public static List createProperty(ChartLegendProperties chartLegendProperties) {
        Vector<ChartGradientLabelProperty> vector = new Vector<ChartGradientLabelProperty>();
        Color color = null;
        Color color2 = new Color(68, 126, 3);
        Date date = new Date();
        Date date2 = new Date();
        date.setYear(110);
        date2.setYear(112);
        for (int i = 0; i < 4; ++i) {
            ChartGradientLabelProperty chartGradientLabelProperty = new ChartGradientLabelProperty();
            chartGradientLabelProperty.setStartColor(color);
            chartGradientLabelProperty.setEndColor(color2);
            chartGradientLabelProperty.setStartValue(date);
            chartGradientLabelProperty.setEndValue(date2);
            chartGradientLabelProperty.setIconWidth(135);
            chartGradientLabelProperty.setIconHeight(35);
            chartGradientLabelProperty.setWrap(true);
            chartGradientLabelProperty.setStartValue(new Float(-32000.0f));
            chartGradientLabelProperty.setEndValue(new Float(170000.0f));
            chartGradientLabelProperty.setLabel("Sum_ColorBy");
            chartGradientLabelProperty.setStartLabel("2010-USA-111199900");
            chartGradientLabelProperty.setEndLabel("2010-CHINA-3311199900K");
            vector.add(chartGradientLabelProperty);
            ChartTextStyle chartTextStyle = new ChartTextStyle("Serief", 25, 1);
            chartTextStyle.setFontColor(new ChartColorPattern(new Color(10, 10, 10)));
            chartGradientLabelProperty.setTitleStyle(chartTextStyle);
            ChartTextStyle chartTextStyle2 = new ChartTextStyle("Arial", 12, 1);
            chartTextStyle2.setFontColor(new ChartColorPattern(new Color(90, 90, 90)));
            chartGradientLabelProperty.setLabelStyle(chartTextStyle2);
        }
        return vector;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabel() {
        return this.label;
    }
}

