/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartComponent;
import chart.ChartCoordinatePaper;
import chart.ChartDefinition;
import chart.ChartEnv;
import chart.ChartLabel;
import chart.ChartLayoutManager;
import chart.ChartLegend;
import chart.ChartObject;
import chart.ChartPropertyValues;
import chart.ChartRenderInfo;
import chart.ChartScrollBar;
import chart.ChartShowValueConditionControl;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DMotionPanel;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DSimplePaper;
import chart.chart3d.Chart3DPaper;
import chart.data.Chart1DDataSet;
import chart.data.Chart2DDataSet;
import chart.data.Chart3DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartBackground;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartLineStyle;
import chart.properties.ChartCoordinatePaperProperties;
import chart.properties.ChartLegendProperties;
import chart.properties.ChartPlatformProperties;
import chart.util.ChartRenderTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ChartPlatform
extends ChartComponent {
    private ChartDataSetModel COLORLENGTH;
    private ChartPlatformProperties COMPONENT_MARGIN;
    private boolean D;
    private ChartFillPattern[] DEFAULTCOLORS;
    private List GAP_BETWEEN_COMPNENT;
    private ChartFillPattern[] KEY_ANTIALIASING;
    private int SEDU;
    private List VALUE_ANTIALIAS_ON;
    private ChartCoordinatePaper add;
    private ChartLegend allIsIntegerData;
    private boolean allLineArea;
    private boolean append;
    private boolean calculateMaxSize = true;
    private boolean calculatePlatformRect = true;
    public static final int gap = 10;
    public static final int GAP = 0;
    private ChartDefinition calculateSimplePeperArea;
    private ChartRenderInfo calculateTitleAutoPos;
    private Rectangle calculateWHRate = null;
    private List clear;
    private int clipRect = 0;
    private ChartCoordinatePaper clone = null;
    private Chart2DMotionPanel conditionIndexList = null;
    private boolean contains = false;
    private int create = 0;
    private int createLegendScroll = 10;
    private boolean createMotion = true;
    private float[] createScrollChartPaper = null;
    private Vector createStaticLabelSmartShowInfo;
    private Vector custommerConstant;
    private int cutRectangle;
    private boolean depthEnable = false;
    public boolean ispaint = false;
    List orgLinepts;
    public int resolution;
    Shape orgLine = null;
    private boolean dispose = true;
    ChartShowValueConditionControl control = new ChartShowValueConditionControl();

    public ChartPlatform() {
        this.calculateSimplePeperArea = null;
        this.COLORLENGTH = null;
        this.COMPONENT_MARGIN = null;
    }

    public ChartPlatform(ChartDefinition chartDefinition, ChartDataSetModel chartDataSetModel, ChartPlatformProperties chartPlatformProperties) {
        this.calculateSimplePeperArea = chartDefinition;
        this.COLORLENGTH = chartDataSetModel;
        this.COMPONENT_MARGIN = chartPlatformProperties;
    }

    @Override
    public void init() {
        int n;
        this.SEDU = 0;
        this.VALUE_ANTIALIAS_ON = this.COLORLENGTH.getChartDataSets();
        ChartDataSet chartDataSet = null;
        block5: for (n = 0; n < this.VALUE_ANTIALIAS_ON.size(); ++n) {
            chartDataSet = (ChartDataSet)this.VALUE_ANTIALIAS_ON.get(n);
            int n2 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
            if (this.COLORLENGTH.isOneGroupForBar() && !this.COLORLENGTH.isTurnedXZ()) {
                this.SEDU += chartDataSet.getCategorySize();
                continue;
            }
            switch (n2) {
                case 4: {
                    this.SEDU += chartDataSet.getCategorySize();
                    continue block5;
                }
                case 10: {
                    continue block5;
                }
                case 11: {
                    this.SEDU += chartDataSet.getCategorySize();
                    continue block5;
                }
                default: {
                    this.SEDU += chartDataSet.getSeriesSize();
                }
            }
        }
        this.createStaticLabelSmartShowInfo(this.VALUE_ANTIALIAS_ON.size());
        this.COMPONENT_MARGIN();
        this.calculateMaxSize();
        this.initScrollChart();
        this.depthEnable = this.contains;
        this.clear = new ArrayList();
        for (n = this.children.size() - 1; n >= 0; --n) {
            ChartComponent chartComponent = (ChartComponent)this.children.get(n);
            if (chartComponent instanceof ChartCoordinatePaper) {
                this.add = (ChartCoordinatePaper)chartComponent;
                this.createScrollChartPaper(this.add);
                this.createMotion(this.add);
            } else if (chartComponent instanceof ChartLegend) {
                this.allIsIntegerData = (ChartLegend)chartComponent;
                this.createLegendScroll(this.allIsIntegerData);
            } else if (chartComponent instanceof ChartLabel) {
                this.clear.add(chartComponent);
                ((ChartLabel)chartComponent).setTitle(true);
            }
            chartComponent.init();
        }
        this.setBindedLineStyleList();
        if (this.add != null) {
            this.contains = this.contains && this.add.getProperties().getAxisXProperties().getScrollableChart();
        }
    }

    void createMotion(ChartCoordinatePaper chartCoordinatePaper) {
        boolean bl = !this.getChartDefinition().isComboChart() && this.getChartDefinition().isMotionChart() && (ChartTypeInfo.getPrimType(this.getChartDefinition().getChartDataSetInfos()[0].getChartType()) == 0 || ChartTypeInfo.getPrimType(this.getChartDefinition().getChartDataSetInfos()[0].getChartType()) == 9 || ChartTypeInfo.getPrimType(this.getChartDefinition().getChartDataSetInfos()[0].getChartType()) == 1);
        bl = false;
        if (bl) {
            this.conditionIndexList = new Chart2DMotionPanel(this, (Chart2DPaper)chartCoordinatePaper);
            if (ChartTypeInfo.getPrimType(this.getChartDefinition().getChartDataSetInfos()[0].getChartType()) == 9) {
                this.conditionIndexList.getMotionControl().setIsShowChoice(true);
                if (this.add.getProperties().getGraphProperties().getShowMotionBubble()) {
                    this.conditionIndexList.getMotionControl().setIsShowBubbleChoice(true);
                }
                if (this.add.getProperties().getGraphProperties().getShowMotionLine()) {
                    this.conditionIndexList.getMotionControl().setIsShowLineChoice(true);
                }
            }
            this.conditionIndexList.getMotionControl().setMotionSpeed(this.add.getProperties().getGraphProperties().getMotionControlSpeed());
            this.children.add(this.conditionIndexList);
        }
    }

    void createScrollChartPaper(ChartCoordinatePaper chartCoordinatePaper) {
        int n = this.COLORLENGTH.getCategoryCount();
        if (n == 0) {
            n = 1;
        }
        if (this.isScrollChart() && this.add.getProperties().getAxisXProperties().getScrollableChart() && this.add instanceof Chart2DPaper) {
            ChartCoordinatePaperProperties chartCoordinatePaperProperties = new ChartCoordinatePaperProperties();
            this.clone = new Chart2DSimplePaper(this, this.add, chartCoordinatePaperProperties);
            ((Chart2DSimplePaper)this.clone).dupGraphProperties(this.add.getProperties());
            this.clone.init();
            this.children.add(this.clone);
            int n2 = this.add.getProperties().getAxisXProperties().getScrollableVisibleValue();
            if (!(this.getScrollbarInfo() != null || this.add.getProperties().getAxisXProperties().getUnitProperties().getUseConstantInterva() && this.isConstantData())) {
                if (n2 <= n && n2 > 0) {
                    this.createLegendScroll = n2;
                    float f = 0.0f;
                    float f2 = (float)this.createLegendScroll / (float)n;
                    this.setScrollbarInfo(new float[]{f, f2});
                } else if (n2 <= 0) {
                    this.setScrollbarInfo(new float[]{0.0f, (float)this.createLegendScroll / (float)n});
                } else if (n2 > n) {
                    this.setScrollbarInfo(new float[]{0.0f, 1.0f});
                    this.createLegendScroll = n;
                }
            }
        } else if (this.isScrollChart() && this.add instanceof Chart2DPaper) {
            if (this.getScrollbarInfo() == null) {
                this.setScrollbarInfo(new float[]{0.0f, 1.0f});
                this.createLegendScroll = n;
            }
        } else {
            this.setScrollbarInfo(new float[]{0.0f, 1.0f});
            this.createLegendScroll = n;
        }
    }

    void createLegendScroll(ChartLegend chartLegend) {
        if (chartLegend != null && chartLegend.getProperties().getIsScroll()) {
            ChartScrollBar chartScrollBar = new ChartScrollBar(chartLegend, 0);
            chartLegend.setScrollBar(chartScrollBar);
        }
    }

    void initScrollChart() {
        int n = -1;
        boolean bl = false;
        if (this.calculateTitleAutoPos.is3DEffect) {
            return;
        }
        if (this.calculateTitleAutoPos.primLayer != null) {
            n = this.calculateTitleAutoPos.primLayer.getCoordinateType();
            switch (n) {
                case 1: 
                case 2: {
                    if (this.COLORLENGTH.getCategoryCount() >= 1) {
                        this.contains = true;
                    }
                    if (n != 2) break;
                    bl = true;
                    break;
                }
                case 6: {
                    this.contains = false;
                }
            }
            if (this.contains && this.calculateTitleAutoPos.secLayer != null) {
                n = this.calculateTitleAutoPos.secLayer.getCoordinateType();
                if (bl && n != 2) {
                    this.contains = false;
                }
                if (!bl && n == 2) {
                    this.contains = false;
                }
            }
        } else if (this.calculateTitleAutoPos.secLayer != null) {
            n = this.calculateTitleAutoPos.secLayer.getCoordinateType();
            switch (n) {
                case 1: 
                case 2: 
                case 6: {
                    if (this.COLORLENGTH.getCategoryCount() < 1) break;
                    this.contains = true;
                }
            }
        }
    }

    public void setPatterns() {
        ChartFillPattern[] chartFillPatternArray = this.COMPONENT_MARGIN.getPatterns();
        this.DEFAULTCOLORS = new ChartFillPattern[this.SEDU];
        if (chartFillPatternArray != null) {
            if (chartFillPatternArray.length > 0) {
                for (int i = 0; i < this.SEDU; ++i) {
                    this.DEFAULTCOLORS[i] = chartFillPatternArray[i % chartFillPatternArray.length];
                }
            }
        } else {
            for (int i = 0; i < this.SEDU; ++i) {
                this.DEFAULTCOLORS[i] = new ChartColorPattern(new Color(ChartPropertyValues.DEFAULTCOLORS[i % ChartPropertyValues.COLORLENGTH]));
            }
        }
        this.COMPONENT_MARGIN.setPatterns(this.DEFAULTCOLORS);
    }

    public void setBindedLineStyleList() {
        boolean bl = false;
        int n = 0;
        block3: for (int i = 0; i < this.VALUE_ANTIALIAS_ON.size(); ++i) {
            ArrayList arrayList = new ArrayList();
            ChartDataSet chartDataSet = (ChartDataSet)this.VALUE_ANTIALIAS_ON.get(i);
            List list = chartDataSet.getLegendSeriesLabels();
            int n2 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
            if (this.COLORLENGTH.isOneGroupForBar() && !this.COLORLENGTH.isTurnedXZ()) continue;
            switch (n2) {
                case 2: {
                    Hashtable<Integer, ChartLineStyle> hashtable = this.add.getProperties().getGraphProperties().getBindedLineStyle();
                    if (hashtable == null) {
                        hashtable = new Hashtable<Integer, ChartLineStyle>();
                        this.add.getProperties().getGraphProperties().setBindedLineStyle(hashtable);
                    }
                    for (int j = 0; j < chartDataSet.getSeriesSize(); ++j) {
                        String string = null;
                        if (list != null && list.size() > 0 && j < list.size()) {
                            string = String.valueOf(list.get(j));
                        }
                        ChartLineStyle chartLineStyle = null;
                        if (string != null) {
                            chartLineStyle = this.COLORLENGTH(string);
                        }
                        if (chartLineStyle == null) continue;
                        hashtable.put(new Integer(j + n), chartLineStyle);
                    }
                    n += chartDataSet.getSeriesSize();
                    continue block3;
                }
            }
        }
    }

    private ChartLineStyle COLORLENGTH(String string) {
        if (this.COMPONENT_MARGIN.getBindedPatterns() == null) {
            return null;
        }
        return (ChartLineStyle)this.COMPONENT_MARGIN.getBindedLineStyles().get(string);
    }

    private void COMPONENT_MARGIN() {
        this.D = this.COMPONENT_MARGIN.isAntiAliasing();
        this.setBackground(this.COMPONENT_MARGIN.getBackground());
        this.D();
        this.setPatterns();
        this.splitPattern();
    }

    private void D() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            ChartLegendProperties chartLegendProperties;
            ChartComponent chartComponent = (ChartComponent)this.children.get(i);
            if (!(chartComponent instanceof ChartLegend) || !(chartLegendProperties = ((ChartLegend)chartComponent).getProperties()).getUseColorByLegend()) continue;
            this.SEDU = chartLegendProperties.getColorByProperty().getIconFillPatterns().size();
        }
    }

    public void splitPattern() {
        this.GAP_BETWEEN_COMPNENT = new ArrayList();
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = this.VALUE_ANTIALIAS_ON.size();
        if (this.COLORLENGTH.getMotionChartGroupNames() != null) {
            n3 = 1;
        }
        for (int i = 0; i < n3; ++i) {
            int n4;
            ChartFillPattern chartFillPattern;
            ArrayList<ChartFillPattern> arrayList = new ArrayList<ChartFillPattern>();
            ChartDataSet chartDataSet = (ChartDataSet)this.VALUE_ANTIALIAS_ON.get(i);
            int n5 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
            if (this.COLORLENGTH.isOneGroupForBar() && !this.COLORLENGTH.isTurnedXZ()) {
                for (int j = 0; j < chartDataSet.getCategorySize(); ++j) {
                    String string = String.valueOf(chartDataSet.getChartDataSetModel().getCategoryName(j));
                    ChartFillPattern chartFillPattern2 = null;
                    if (string != null) {
                        chartFillPattern2 = this.DEFAULTCOLORS(string);
                    }
                    if (chartFillPattern2 != null) {
                        this.DEFAULTCOLORS[j + n2] = chartFillPattern2;
                    }
                    chartFillPattern = this.DEFAULTCOLORS[j + n2];
                    arrayList.add(chartFillPattern);
                }
                n2 += chartDataSet.getCategorySize();
            } else {
                switch (n5) {
                    case 4: {
                        for (int j = 0; j < chartDataSet.getCategorySize(); ++j) {
                            String string = String.valueOf(chartDataSet.getChartDataSetModel().getCategoryName(j));
                            ChartFillPattern chartFillPattern3 = null;
                            if (string != null) {
                                chartFillPattern3 = this.DEFAULTCOLORS(string);
                            }
                            if (chartFillPattern3 != null) {
                                this.DEFAULTCOLORS[j + n2] = chartFillPattern3;
                            }
                            chartFillPattern = this.DEFAULTCOLORS[n2 + j];
                            arrayList.add(chartFillPattern);
                        }
                        n2 += chartDataSet.getCategorySize();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        for (int j = 0; j < chartDataSet.getCategorySize(); ++j) {
                            String string = String.valueOf(chartDataSet.getChartDataSetModel().getCategoryName(j));
                            ChartFillPattern chartFillPattern4 = null;
                            if (string != null) {
                                chartFillPattern4 = this.DEFAULTCOLORS(string);
                            }
                            if (chartFillPattern4 != null) {
                                this.DEFAULTCOLORS[j + n2] = chartFillPattern4;
                            }
                            chartFillPattern = this.DEFAULTCOLORS[j + n2];
                            arrayList.add(chartFillPattern);
                        }
                        n2 += chartDataSet.getCategorySize();
                        break;
                    }
                    default: {
                        int n6;
                        List list = chartDataSet.getLegendSeriesLabels();
                        int n7 = 0;
                        n4 = 0;
                        boolean bl2 = false;
                        for (n6 = 0; n6 < chartDataSet.getSeriesSize(); ++n6) {
                            String string = null;
                            if (chartDataSet.getLegendSeriesLabels() != null && chartDataSet.getLegendSeriesLabels().size() > 0 && n6 < list.size()) {
                                string = String.valueOf(list.get(n6));
                            }
                            ChartFillPattern chartFillPattern5 = null;
                            if (string != null) {
                                chartFillPattern5 = this.DEFAULTCOLORS(string);
                            }
                            if (chartFillPattern5 != null) {
                                this.DEFAULTCOLORS[(n6 + n2) % this.DEFAULTCOLORS.length] = chartFillPattern5;
                            }
                            chartFillPattern = this.DEFAULTCOLORS[(n2 + n7) % this.DEFAULTCOLORS.length];
                            arrayList.add(chartFillPattern);
                            if (chartDataSet.getCondition(n6, 0) == null || chartDataSet.getCondition(n6, 0) != null && chartDataSet.getCondition((int)n6, (int)0).conditionIndexList == null || n5 == 2 && chartDataSet.getCondition(n6, 0) != null && chartDataSet.getCondition((int)n6, (int)0).lineConditionIndexList == null) {
                                ++n7;
                                ++n4;
                                continue;
                            }
                            bl2 = true;
                        }
                        if (n5 == 0) {
                            n6 = ChartTypeInfo.getSubType(chartDataSet.getChartDataSetInfo().getChartType());
                            int n8 = ChartTypeInfo.getEffect(chartDataSet.getChartDataSetInfo().getChartType());
                            if (n6 == 0 && n8 == 0 && ((Chart1DDataSet)chartDataSet).getDispleyLabelIndex() != null) {
                                n = ((Chart1DDataSet)chartDataSet).getDispleyLabelIndex().size();
                            }
                            n2 -= n;
                        }
                        if (!bl2) {
                            n2 += chartDataSet.getSeriesSize();
                            break;
                        }
                        n2 += n4;
                    }
                }
            }
            if (this.COLORLENGTH.getMotionChartGroupNames() != null) {
                for (int j = 0; j < this.VALUE_ANTIALIAS_ON.size(); ++j) {
                    ArrayList arrayList2 = new ArrayList();
                    for (n4 = 0; n4 < arrayList.size(); ++n4) {
                        arrayList2.add(arrayList.get(n4));
                    }
                    this.GAP_BETWEEN_COMPNENT.add(arrayList2);
                }
                continue;
            }
            this.GAP_BETWEEN_COMPNENT.add(arrayList);
        }
    }

    private ChartFillPattern DEFAULTCOLORS(String string) {
        if (this.COMPONENT_MARGIN.getBindedPatterns() == null) {
            return null;
        }
        return (ChartFillPattern)this.COMPONENT_MARGIN.getBindedPatterns().get(string);
    }

    @Override
    public synchronized void locate() {
        Object object;
        int n;
        int n2 = this.COMPONENT_MARGIN.getBackground().getBorderStyle();
        int n3 = n = n2 == 0 ? 0 : (int)this.COMPONENT_MARGIN.getBackground().getPen().getPenWidth();
        if (this.calculateSimplePeperArea.isORGChart() && n2 == 0) {
            n = ChartEnv.GAP_BETWEEN_COMPNENT;
        }
        int n4 = this.width - 2 * n;
        int n5 = this.height - 2 * n;
        this.calculateWHRate = new Rectangle(n, n, n4, n5);
        int n6 = this.clear.size();
        for (int i = 0; i < n6; ++i) {
            object = (ChartLabel)this.clear.get(i);
            int n7 = ((ChartLabel)object).getTitleType();
            if (n7 == 1) {
                this.calculateWHRate = this.VALUE_ANTIALIAS_ON((ChartLabel)object, this.calculateWHRate);
                continue;
            }
            if (n7 == 0) {
                this.calculateWHRate = this.add((ChartLabel)object, this.calculateWHRate);
                continue;
            }
            this.allIsIntegerData((ChartLabel)object, this.calculateWHRate);
        }
        Rectangle rectangle = (Rectangle)this.calculateWHRate.clone();
        if (this.conditionIndexList != null) {
            rectangle = ChartLayoutManager.calculatePlatformRect(rectangle, new Rectangle(0, 0, 1, 57), 2);
            object = new Rectangle();
            ((Rectangle)object).setBounds(rectangle.x, rectangle.y + rectangle.height, rectangle.width, 57);
            this.conditionIndexList.setBounds((Rectangle)object);
        }
        if (this.clone != null) {
            object = this.calculateSimplePeperArea(rectangle);
            if (this.getScrollbarInfo() == null) {
                if (this.add.getAxisX1() != null && this.add.getAxisX1().getScrollInfo() != null) {
                    this.setScrollbarInfo(this.add.getAxisX1().getScrollInfo());
                } else if (this.add instanceof Chart2DPaper && ((Chart2DPaper)this.add).getAxisX2() != null && ((Chart2DPaper)this.add).getAxisX2().getScrollInfo() != null) {
                    this.setScrollbarInfo(((Chart2DPaper)this.add).getAxisX2().getScrollInfo());
                } else {
                    this.setScrollbarInfo(new float[]{0.0f, 0.0f});
                }
            }
            this.background(this.clone, (Rectangle)object);
            rectangle = ((Chart2DSimplePaper)this.clone).isBench() ? ChartLayoutManager.calculatePlatformRect(rectangle, (Rectangle)object, 1) : ChartLayoutManager.calculatePlatformRect(rectangle, (Rectangle)object, 2);
        }
        this.calculateWHRate = rectangle;
        if (this.allIsIntegerData != null) {
            this.allIsIntegerData.setIsExpand(this.dispose);
            this.allIsIntegerData.calculateWHRate();
            this.allIsIntegerData.calculateMaxSize();
        }
        object = (Rectangle)rectangle.clone();
        Rectangle rectangle2 = this.SEDU(this.calculateWHRate);
        if (this.add.getBounds() != null && this.add.getBounds().width == 0 && this.add.getBounds().height == 0) {
            ChartLayoutManager.restrictRect((Rectangle)object, rectangle2);
        }
        this.background(this.add, rectangle2);
        this.append(this.allIsIntegerData);
        this.allLineArea(this.add.getGraphArea());
    }

    Rectangle calculateSimplePeperArea(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = (Rectangle)rectangle.clone();
        boolean bl = ((Chart2DSimplePaper)this.clone).isBench();
        float f = this.add.getProperties().getAxisXProperties().getDisplayAreaPercent();
        f /= 100.0f;
        int n4 = rectangle3.x;
        if (!bl) {
            n3 = (int)((float)rectangle3.height * f);
            n2 = rectangle3.width;
            n = rectangle3.y + rectangle3.height - n3;
        } else {
            n3 = rectangle3.height;
            n2 = (int)((float)rectangle3.width * f);
            n = rectangle3.y;
        }
        rectangle2.x = n4;
        rectangle2.y = n;
        rectangle2.width = n2;
        rectangle2.height = n3;
        return rectangle2;
    }

    private void GAP_BETWEEN_COMPNENT(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (n3 <= 6 || n4 <= 6) {
            return;
        }
        rectangle.x = n + 3;
        rectangle.y = n2 + 3;
        rectangle.width = n3 - 6;
        rectangle.height = n4 - 6;
    }

    private Rectangle KEY_ANTIALIASING(Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = new Rectangle();
        rectangle3.x = rectangle.x;
        rectangle3.y = rectangle.y + (int)((double)rectangle.height * 0.8) - 20;
        rectangle3.width = rectangle.width;
        rectangle3.height = (int)((double)rectangle.height * 0.2);
        return rectangle3;
    }

    private Rectangle SEDU(Rectangle rectangle) {
        Rectangle rectangle2;
        block22: {
            Rectangle rectangle3;
            Rectangle rectangle4;
            block20: {
                block21: {
                    int n;
                    rectangle2 = new Rectangle();
                    float[] fArray2 = new float[2];
                    rectangle4 = this.add.getBounds();
                    rectangle3 = (Rectangle)rectangle.clone();
                    float[] fArray3 = null;
                    float f = this.add.getProperties().getBackground().getPen().getPenWidth();
                    if (!this.COMPONENT_MARGIN.isShowLegend()) break block20;
                    if (this.allIsIntegerData == null || !this.COMPONENT_MARGIN.isShowLegend()) break block21;
                    fArray2 = this.allIsIntegerData.getWHRate();
                    switch (this.allIsIntegerData.getPreferredPlacement()) {
                        case 2: 
                        case 4: {
                            rectangle2.setSize((int)((float)rectangle3.width * (1.0f - fArray2[0]) - f - (float)ChartEnv.COMPONENT_MARGIN), (int)((float)(rectangle3.height - 2 * ChartEnv.COMPONENT_MARGIN) - f));
                            fArray3 = this.allIsIntegerData.getExtraSize((float)rectangle.width * 0.25f, rectangle.height);
                            if (!(fArray3[0] >= 1.0f)) break;
                            float[] fArray4 = this.allIsIntegerData.getFullSize();
                            n = rectangle2.width;
                            int n2 = rectangle2.height;
                            n = (int)((float)rectangle3.width - fArray4[0] - (float)(2 * ChartEnv.COMPONENT_MARGIN) - f);
                            rectangle2.setSize(n, n2);
                            break;
                        }
                        case 1: 
                        case 3: {
                            rectangle2.setSize(rectangle3.width - 2 * ChartEnv.COMPONENT_MARGIN, (int)((float)rectangle3.height * (1.0f - fArray2[1]) - (float)(2 * ChartEnv.COMPONENT_MARGIN) - f));
                            fArray3 = this.allIsIntegerData.getExtraSize(rectangle.width, (float)rectangle.height * 0.25f);
                            if (!(fArray3[1] >= 1.0f)) break;
                            float[] fArray4 = this.allIsIntegerData.getFullSize();
                            n = rectangle2.width;
                            int n2 = rectangle2.height;
                            n2 = (int)((float)n2 + fArray3[1]);
                            rectangle2.setSize(n, n2);
                            break;
                        }
                        default: {
                            if (this.add.x <= 0 && this.add.y <= 0 && this.add.height <= 0 && this.add.width <= 0) {
                                rectangle2.setSize((int)((float)(rectangle3.width * 3) / 4.0f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT)), (int)((float)(rectangle3.height * 15) / 16.0f - (float)(2 * ChartEnv.GAP_BETWEEN_COMPNENT)));
                                break;
                            }
                            rectangle2.setRect(this.add.x, this.add.y, this.add.width, this.add.height);
                        }
                    }
                    int n3 = (int)rectangle2.getSize().getWidth();
                    n = (int)rectangle2.getSize().getHeight();
                    switch (this.allIsIntegerData.getPreferredPlacement()) {
                        case 2: {
                            rectangle2.setLocation((int)((float)(rectangle3.x + ChartEnv.COMPONENT_MARGIN) + f / 2.0f), rectangle3.y + ChartEnv.COMPONENT_MARGIN);
                            fArray3 = this.allIsIntegerData.getExtraSize((float)rectangle.width * 0.25f, rectangle.height);
                            if (fArray3[0] >= 1.0f) {
                                float[] fArray5 = this.allIsIntegerData.getFullSize();
                                int n4 = rectangle2.x;
                                int n5 = rectangle2.y;
                                n4 = (int)((float)n4 - fArray5[0] / 2.0f);
                                break;
                            }
                            break block22;
                        }
                        case 4: {
                            rectangle2.setLocation((int)((float)rectangle3.x + (float)rectangle3.width * fArray2[0]), rectangle3.y + ChartEnv.COMPONENT_MARGIN);
                            fArray3 = this.allIsIntegerData.getExtraSize((float)rectangle.width * 0.25f, rectangle.height);
                            if (fArray3[0] >= 1.0f) {
                                float[] fArray6 = this.allIsIntegerData.getFullSize();
                                int n6 = rectangle2.x;
                                int n7 = rectangle2.y;
                                n6 = (int)((float)rectangle.x + fArray6[0] + f / 2.0f + (float)ChartEnv.COMPONENT_MARGIN);
                                rectangle2.setLocation(n6, n7);
                                break;
                            }
                            break block22;
                        }
                        case 1: {
                            rectangle2.setLocation(rectangle3.x + ChartEnv.COMPONENT_MARGIN, (int)((float)rectangle3.y + (float)rectangle3.height * fArray2[1] + (float)ChartEnv.COMPONENT_MARGIN));
                            fArray3 = this.allIsIntegerData.getExtraSize(rectangle.width, (float)rectangle.height * 0.25f);
                            if (fArray3[1] >= 1.0f) {
                                float[] fArray7 = this.allIsIntegerData.getFullSize();
                                int n8 = rectangle2.x;
                                int n9 = rectangle2.y;
                                n9 = (int)((float)n9 - fArray3[1]);
                                rectangle2.setLocation(n8, n9);
                                break;
                            }
                            break block22;
                        }
                        case 3: {
                            rectangle2.setLocation(rectangle3.x + ChartEnv.COMPONENT_MARGIN, rectangle3.y + ChartEnv.COMPONENT_MARGIN);
                            fArray3 = this.allIsIntegerData.getExtraSize(rectangle.width, (float)rectangle.height * 0.25f);
                            if (fArray3[1] >= 1.0f) {
                                float[] fArray8 = this.allIsIntegerData.getFullSize();
                                int n10 = rectangle2.x;
                                int n11 = rectangle2.y;
                                rectangle2.setLocation(n10, n11);
                                break;
                            }
                            break block22;
                        }
                        default: {
                            if (this.add.x <= 0 && this.add.y <= 0 && this.add.height <= 0 && this.add.width <= 0) {
                                rectangle2.setLocation((int)((float)rectangle3.x + ((float)(rectangle3.width * 3) / 4.0f - (float)n3) / 2.0f + (float)ChartEnv.GAP_BETWEEN_COMPNENT), rectangle3.y + (rectangle3.height - n) / 2 + ChartEnv.GAP_BETWEEN_COMPNENT);
                                break;
                            }
                            rectangle2.setRect(this.add.x, this.add.y, this.add.width, this.add.height);
                            break;
                        }
                    }
                    break block22;
                }
                rectangle2.setLocation(rectangle3.x + 10, rectangle3.y + 10);
                rectangle2.setSize(rectangle3.width - 20, rectangle3.height - 20);
                break block22;
            }
            if (!this.calculateSimplePeperArea.isSparklineChart()) {
                Rectangle rectangle5 = this.add.getBounds();
                if (rectangle4.width == 0 && rectangle4.height == 0) {
                    rectangle2.setRect(0.0, 0.0, rectangle3.width, rectangle3.height);
                } else {
                    rectangle2.setRect(this.add.x, this.add.y, this.add.width, this.add.height);
                }
            } else {
                rectangle2.setRect(0.0, 0.0, rectangle3.width, rectangle3.height);
            }
        }
        return rectangle2;
    }

    private Rectangle VALUE_ANTIALIAS_ON(ChartLabel chartLabel, Rectangle rectangle) {
        if (chartLabel.x <= 0 && chartLabel.y <= 0 || chartLabel.isAutoTitle()) {
            chartLabel.setIsAutoTitle(true);
            Rectangle rectangle2 = ChartRenderTools.calculateTitleAutoPos(rectangle, chartLabel, 0);
            chartLabel.setBounds(rectangle2);
            chartLabel.setBackground(new ChartBackground(Color.red));
            chartLabel.locate();
            return ChartRenderTools.cutRectangle(rectangle, rectangle2, 0);
        }
        chartLabel.locate();
        return rectangle;
    }

    private Rectangle add(ChartLabel chartLabel, Rectangle rectangle) {
        chartLabel.locate();
        return rectangle;
    }

    private Rectangle allIsIntegerData(ChartLabel chartLabel, Rectangle rectangle) {
        if (chartLabel.x <= 0 && chartLabel.y <= 0) {
            int n = chartLabel.getTitleType();
            Rectangle rectangle2 = null;
            Rectangle rectangle3 = null;
            switch (n) {
                case 2: {
                    rectangle2 = ChartRenderTools.calculateTitleAutoPos(rectangle, chartLabel, 2);
                    chartLabel.setBounds(0, 0, rectangle2.width, rectangle2.height);
                    rectangle3 = ChartRenderTools.cutRectangle(rectangle, rectangle2, 2);
                    break;
                }
                case 3: {
                    rectangle2 = ChartRenderTools.calculateTitleAutoPos(rectangle, chartLabel, 3);
                    chartLabel.setBounds(0, 0, rectangle2.width, rectangle2.height);
                    rectangle3 = ChartRenderTools.cutRectangle(rectangle, rectangle2, 3);
                    break;
                }
                case 4: {
                    rectangle2 = ChartRenderTools.calculateTitleAutoPos(rectangle, chartLabel, 1);
                    chartLabel.setBounds(0, 0, rectangle2.width, rectangle2.height);
                    rectangle3 = ChartRenderTools.cutRectangle(rectangle, rectangle2, 1);
                }
            }
            return rectangle3;
        }
        chartLabel.locate();
        return rectangle;
    }

    private void allLineArea(Rectangle rectangle) {
        for (int i = 0; i < this.clear.size(); ++i) {
            ChartLabel chartLabel = (ChartLabel)this.clear.get(i);
            if (chartLabel.x <= 0 && chartLabel.y <= 0) {
                int n = chartLabel.getTitleType();
                switch (n) {
                    case 2: {
                        int n2 = this.add.height + chartLabel.height + this.add.y > this.calculateWHRate.y + this.calculateWHRate.height ? this.calculateWHRate.y + this.calculateWHRate.height - chartLabel.height : this.add.y + this.add.height;
                        chartLabel.setLocation(this.add.x + rectangle.x + (rectangle.width - chartLabel.width) / 2, n2);
                        break;
                    }
                    case 3: {
                        int n3 = this.add.x - chartLabel.width < 0 ? 0 : this.add.x - chartLabel.width;
                        chartLabel.setLocation(n3, this.add.y + rectangle.y + (rectangle.height - chartLabel.height) / 2);
                        break;
                    }
                    case 4: {
                        int n3 = this.add.width + chartLabel.width + this.add.x > this.calculateWHRate.x + this.calculateWHRate.width ? this.calculateWHRate.x + this.calculateWHRate.width - chartLabel.width : this.add.x + this.add.width;
                        chartLabel.setLocation(n3, this.add.y + rectangle.y + (rectangle.height - chartLabel.height) / 2);
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
            }
            chartLabel.locate();
        }
    }

    private void append(ChartLegend chartLegend) {
        if (chartLegend != null) {
            if (this.COMPONENT_MARGIN.isShowLegend()) {
                chartLegend.paperBounds = this.add.getBounds();
                chartLegend.locate();
            } else {
                chartLegend.setBounds(0, 0, 0, 0);
            }
        }
    }

    private void background(ChartCoordinatePaper chartCoordinatePaper, Rectangle rectangle) {
        if (this.getChartDefinition().isORGChart()) {
            // empty if block
        }
        chartCoordinatePaper.setBounds(rectangle);
        chartCoordinatePaper.locate();
    }

    @Override
    public synchronized void paint(Graphics2D graphics2D) {
        Object object = null;
        this.background = this.COMPONENT_MARGIN.getBackground();
        if (this.D) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paint(graphics2D);
        this.drawOrgLine(graphics2D);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
        this.ispaint = true;
    }

    void drawOrgLine(Graphics2D graphics2D) {
        if (this.add != null && this.add.getProperties() != null) {
            Rectangle rectangle = this.add.getBounds();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            if (this.add.getProperties().getBackground().getPen() != null) {
                int n5 = (int)this.add.getProperties().getBackground().getPen().getPenWidth();
                n += n5;
                n2 += n5;
                n3 -= 2 * n5;
                n4 -= 2 * n5;
            }
            graphics2D2.clipRect(n, n2, n3, n4);
            ChartRenderTools.drawChartLine(this.add.getProperties().getLineProperties(), graphics2D2, this.orgLinepts, this.resolution);
        }
    }

    public void setOrgLine(Shape shape) {
        this.orgLine = shape;
    }

    public void setOrgLinePoints(List list) {
        this.orgLinepts = list;
    }

    @Override
    protected void paintBorder(Graphics2D graphics2D) {
    }

    public boolean getLegendRelocated() {
        return this.allLineArea;
    }

    public boolean getShowLegend() {
        return this.append;
    }

    public List getFillPatterns() {
        return this.GAP_BETWEEN_COMPNENT;
    }

    public List getFillPatternByList(int n) {
        return (List)this.GAP_BETWEEN_COMPNENT.get(n);
    }

    public ChartFillPattern[] getFillPatternByArarry(int n) {
        List list = this.getFillPatternByList(n);
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            chartFillPatternArray[i] = (ChartFillPattern)list.get(i);
        }
        return chartFillPatternArray;
    }

    public ChartFillPattern[] getFillPatternsForLegend() {
        return this.DEFAULTCOLORS;
    }

    public ChartFillPattern getFillPatternForLegend(int n) {
        if (this.COLORLENGTH.isOneGroupForBar() && !this.COLORLENGTH.isTurnedXZ() && this.add != null && !this.add.getProperties().getGraphProperties().isVaryColorbyValues()) {
            return this.DEFAULTCOLORS[0];
        }
        ChartDataSet chartDataSet = null;
        for (int i = 0; i < this.VALUE_ANTIALIAS_ON.size(); ++i) {
            chartDataSet = (ChartDataSet)this.VALUE_ANTIALIAS_ON.get(i);
            int n2 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
            if (n2 != 11 || this.add.getProperties().getGraphProperties().isVaryColorbyValues()) continue;
            return this.DEFAULTCOLORS[0];
        }
        return this.DEFAULTCOLORS[n];
    }

    public void setAutoLayoutPaper(boolean bl) {
        this.calculatePlatformRect = bl;
    }

    public void setAutoLayoutLegend(boolean bl) {
        this.calculateMaxSize = bl;
    }

    public void setProperties(ChartPlatformProperties chartPlatformProperties) {
        this.COMPONENT_MARGIN = chartPlatformProperties;
    }

    public ChartPlatformProperties getProperties() {
        return this.COMPONENT_MARGIN;
    }

    public List getSurfaceLegendLabels() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        ChartNumericAxis chartNumericAxis = this.add.getAxisY1();
        int n = chartNumericAxis.getNumOfTick();
        double d = chartNumericAxis.getTickPace();
        double d2 = chartNumericAxis.getLabelStartValue();
        boolean[] blArray = chartNumericAxis.surfacePatternIncrea();
        if (blArray[0]) {
            string = d2 - d + "~" + d2;
            arrayList.add(string);
        }
        if (blArray[1]) {
            ++n;
        }
        for (int i = 0; i < n; ++i) {
            String string2 = String.valueOf(d2 + (double)i * d);
            String string3 = String.valueOf(d2 + (double)(i + 1) * d);
            string = string2 + "~" + string3;
            arrayList.add(string);
        }
        return arrayList;
    }

    public ChartLegend getChartLegend() {
        return this.allIsIntegerData;
    }

    protected void setChartLegend(ChartLegend chartLegend) {
        this.allIsIntegerData = chartLegend;
    }

    public ChartCoordinatePaper getChartCoordinatePaper() {
        return this.add;
    }

    protected void setChartCoordinatePaper(ChartCoordinatePaper chartCoordinatePaper) {
        this.add = chartCoordinatePaper;
    }

    public ChartDataSetModel getDataSetModel() {
        return this.COLORLENGTH;
    }

    public void setDataSetModel(ChartDataSetModel chartDataSetModel) {
        this.COLORLENGTH = chartDataSetModel;
    }

    public ChartFillPattern[] getChartFillPatternForSurface(Chart3DPaper chart3DPaper) {
        ChartNumericAxis chartNumericAxis = chart3DPaper.getAxisY1();
        int n = chartNumericAxis.getNumOfTick();
        boolean[] blArray = chartNumericAxis.surfacePatternIncrea();
        if (blArray[0]) {
            ++n;
        }
        if (blArray[1]) {
            ++n;
        }
        this.KEY_ANTIALIASING = new ChartFillPattern[n];
        for (int i = 0; i < n; ++i) {
            this.KEY_ANTIALIASING[i] = i > this.DEFAULTCOLORS.length - 1 ? new ChartColorPattern(new Color(ChartPropertyValues.DEFAULTCOLORS[i % ChartPropertyValues.COLORLENGTH])) : this.DEFAULTCOLORS[i];
        }
        this.COMPONENT_MARGIN.setPatterns(this.KEY_ANTIALIASING);
        return this.KEY_ANTIALIASING;
    }

    public ChartFillPattern getChartFillPatternForSurface(int n) {
        return this.KEY_ANTIALIASING[n];
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        if (rectangle.contains(n, n2)) {
            return this;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public ChartDefinition getChartDefinition() {
        return this.calculateSimplePeperArea;
    }

    public void setChartDefinition(ChartDefinition chartDefinition) {
        this.calculateSimplePeperArea = chartDefinition;
    }

    private void calculateMaxSize() {
        this.calculateTitleAutoPos = new ChartRenderInfo();
        ChartDefinition chartDefinition = this.getChartDefinition();
        chartDefinition.getCoordinateInfo(this.calculateTitleAutoPos);
        ArrayList<ChartDataSet> arrayList = new ArrayList<ChartDataSet>();
        ArrayList<ChartDataSet> arrayList2 = new ArrayList<ChartDataSet>();
        block4: for (int i = 0; i < this.VALUE_ANTIALIAS_ON.size(); ++i) {
            ChartDataSet chartDataSet = (ChartDataSet)this.VALUE_ANTIALIAS_ON.get(i);
            switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                case 0: {
                    arrayList.add(chartDataSet);
                    continue block4;
                }
                case 1: {
                    arrayList2.add(chartDataSet);
                }
            }
        }
        this.calculatePlatformRect(this.calculateTitleAutoPos, this.calculateTitleAutoPos.primLayer, arrayList);
        this.calculatePlatformRect(this.calculateTitleAutoPos, this.calculateTitleAutoPos.secLayer, arrayList2);
        this.calculateTitleAutoPos.xAxisLineUnit = this.calculateTitleAutoPos.primLayer != null && this.calculateTitleAutoPos.secLayer == null && this.calculateTitleAutoPos.primLayer.allLineArea || this.calculateTitleAutoPos.secLayer != null && this.calculateTitleAutoPos.primLayer == null && this.calculateTitleAutoPos.secLayer.allLineArea;
        this.calculateTitleAutoPos.setHasLegend(this.COMPONENT_MARGIN.isShowLegend());
    }

    private void calculatePlatformRect(ChartRenderInfo chartRenderInfo, ChartRenderInfo.ChartLayerRenderInfo chartLayerRenderInfo, List list) {
        ChartDataSet chartDataSet = null;
        double d = chartRenderInfo.xMin;
        double d2 = chartRenderInfo.xMax;
        if (chartLayerRenderInfo != null) {
            double d3 = 0.0;
            double d4 = 0.0;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = false;
            boolean bl6 = false;
            block15: for (int i = 0; i < list.size(); ++i) {
                chartDataSet = (ChartDataSet)list.get(i);
                if (bl && !chartDataSet.isIntegerData()) {
                    bl = false;
                }
                int n = chartDataSet.getChartDataSetInfo().getChartType();
                int n2 = ChartTypeInfo.getPrimType(n);
                int n3 = ChartTypeInfo.getSubType(n);
                int n4 = ChartTypeInfo.getSeriesType(n);
                switch (n2) {
                    case 0: {
                        bl3 = false;
                        bl4 = false;
                        break;
                    }
                    case 1: {
                        bl2 = false;
                        bl4 = false;
                        break;
                    }
                    case 2: 
                    case 3: {
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                    case 9: {
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                        bl5 = true;
                        break;
                    }
                    case 11: {
                        bl2 = false;
                        bl4 = false;
                        break;
                    }
                    default: {
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                    }
                }
                switch (n3) {
                    case 256: {
                        bl6 = true;
                    }
                }
                switch (n4) {
                    case 65536: {
                        double d5 = ((Chart2DDataSet)chartDataSet).getXMin();
                        double d6 = ((Chart2DDataSet)chartDataSet).getXMax();
                        d = d < d5 ? d : d5;
                        d2 = d2 > d6 ? d2 : d6;
                        d5 = ((Chart2DDataSet)chartDataSet).getYMin();
                        d6 = ((Chart2DDataSet)chartDataSet).getYMax();
                        d3 = d3 < d5 ? d3 : d5;
                        d4 = d4 > d6 ? d4 : d6;
                        continue block15;
                    }
                    case 131072: {
                        double d5 = ((Chart3DDataSet)chartDataSet).getXMin();
                        double d6 = ((Chart3DDataSet)chartDataSet).getXMax();
                        d = d < d5 ? d : d5;
                        d2 = d2 > d6 ? d2 : d6;
                        d5 = ((Chart3DDataSet)chartDataSet).getYMin();
                        d6 = ((Chart3DDataSet)chartDataSet).getYMax();
                        d3 = d3 < d5 ? d3 : d5;
                        d4 = d4 > d6 ? d4 : d6;
                        continue block15;
                    }
                    case 0: 
                    case 196608: {
                        double d5 = chartDataSet.getMin();
                        double d6 = chartDataSet.getMax();
                        d3 = d3 < d5 ? d3 : d5;
                        d4 = d4 > d6 ? d4 : d6;
                    }
                }
            }
            chartLayerRenderInfo.yMin = d3;
            chartLayerRenderInfo.yMax = d4;
            chartLayerRenderInfo.allIsIntegerData = bl;
            chartLayerRenderInfo.depthEnable = bl2 || bl3;
            chartLayerRenderInfo.allLineArea = bl4;
            chartLayerRenderInfo.hasBubble = bl5;
            chartLayerRenderInfo.hasPercent = bl6;
            if (!bl3) {
                this.createMotion = false;
            }
        }
        chartRenderInfo.xMin = chartRenderInfo.xMin < d ? chartRenderInfo.xMin : d;
        chartRenderInfo.xMax = chartRenderInfo.xMax > d2 ? chartRenderInfo.xMax : d2;
    }

    public ChartRenderInfo getChartRenderInfo() {
        return this.calculateTitleAutoPos;
    }

    public Rectangle getGraphisRect() {
        if (this.calculateWHRate == null) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        return this.calculateWHRate;
    }

    public boolean isSameRes(int n) {
        return this.clipRect == n;
    }

    public void setRes(int n) {
        this.clipRect = n;
    }

    public int showScrollLabelCount() {
        return this.createLegendScroll - this.create;
    }

    public int showScrollLabelStart() {
        if (this.add != null && this.add.getAxisX1() != null && this.add.getAxisX1().custommerConstant()) {
            return 0;
        }
        return this.create < 0 ? 0 : this.create;
    }

    public int showScrollLabelEnd() {
        return this.createLegendScroll > this.COLORLENGTH.getCategoryCount() ? this.COLORLENGTH.getCategoryCount() : this.createLegendScroll;
    }

    public int getMousePosition(int n, int n2) {
        int n3 = -1;
        if (this.clone != null) {
            int n4 = n - this.clone.getBounds().x;
            int n5 = n2 - this.clone.getBounds().y;
            n3 = ((Chart2DSimplePaper)this.clone).getMousePositionInScrollbar(n4, n5);
        }
        return n3;
    }

    public void setMoveLenght(float f, float f2) {
        if (this.clone != null) {
            ((Chart2DSimplePaper)this.clone).setMoveLength(f, f2);
        }
    }

    public Chart2DSimplePaper getSimplePaper() {
        return (Chart2DSimplePaper)this.clone;
    }

    public boolean canUseBenchScrollbar() {
        return this.createMotion;
    }

    public void setScrollbarInfo(float[] fArray2) {
        if (fArray2 != null && fArray2.length == 2) {
            if (fArray2[0] < 0.0f || fArray2[1] > 1.0f || fArray2[1] < fArray2[0]) {
                if (fArray2[0] < 0.0f) {
                    fArray2[0] = 0.0f;
                }
                if (fArray2[1] > 1.0f) {
                    fArray2[1] = 1.0f;
                }
            }
            int[] nArray = null;
            if (!this.isConstantData()) {
                nArray = this.getScrollDatePosition(fArray2);
                if (nArray == null) {
                    return;
                }
                if (nArray[0] < 0 || nArray[1] > this.COLORLENGTH.getCategoryCount()) {
                    return;
                }
                this.create = nArray[0];
                this.createLegendScroll = nArray[1];
                if (nArray != null) {
                    this.createScrollChartPaper = fArray2;
                }
            } else {
                this.createScrollChartPaper = fArray2;
            }
        }
    }

    public float[] getScrollbarInfo() {
        if (this.createScrollChartPaper == null) {
            // empty if block
        }
        return this.createScrollChartPaper;
    }

    public int[] getDataPosition() {
        int[] nArray = new int[2];
        float f = 0.0f;
        if (this.clone != null) {
            f = (1.0f - this.clone.getProperties().getGraphProperties().getBarWidth()) / 2.0f;
        }
        if (!this.isConstantData()) {
            nArray[0] = (int)(this.createScrollChartPaper[0] * (float)this.COLORLENGTH.getCategoryCount() + f);
            nArray[1] = (int)(this.createScrollChartPaper[1] * (float)this.COLORLENGTH.getCategoryCount() + (1.0f - f));
        } else {
            nArray[0] = 0;
            nArray[1] = this.COLORLENGTH.getCategoryCount();
        }
        nArray[1] = nArray[1] >= this.COLORLENGTH.getCategoryCount() ? this.COLORLENGTH.getCategoryCount() : nArray[1];
        int n = nArray[0] = nArray[0] < 0 ? 0 : nArray[0];
        if (nArray[1] - nArray[0] < 1) {
            if (nArray[1] < this.COLORLENGTH.getCategoryCount()) {
                nArray[1] = nArray[1] + 1;
            } else if (nArray[0] > 0) {
                nArray[0] = nArray[0] - 1;
            }
        }
        return nArray;
    }

    protected int[] getScrollDatePosition(float[] fArray2) {
        int[] nArray = new int[]{(int)(fArray2[0] * (float)this.COLORLENGTH.getCategoryCount()), (int)(fArray2[1] * (float)this.COLORLENGTH.getCategoryCount())};
        nArray[1] = nArray[1] >= this.COLORLENGTH.getCategoryCount() ? this.COLORLENGTH.getCategoryCount() : nArray[1];
        int n = nArray[0] = nArray[0] < 0 ? 0 : nArray[0];
        if (this.COLORLENGTH.getCategoryCount() <= 1) {
            nArray[0] = 0;
            nArray[1] = 1;
        } else {
            if (this.createLegendScroll - this.create == 1 && nArray[1] - nArray[0] < 1) {
                return null;
            }
            if (nArray[1] - nArray[0] <= 0 && nArray[0] < this.COLORLENGTH.getCategoryCount()) {
                nArray[1] = nArray[0] + 1;
            }
        }
        return nArray;
    }

    public boolean isScrollChart() {
        return this.contains && this.conditionIndexList == null;
    }

    public void setScrollEndPosition(int n) {
        if (n < 1 || n > this.COLORLENGTH.getCategoryCount()) {
            return;
        }
        this.createLegendScroll = n;
    }

    public ChartShowValueConditionControl getShowValueConditions() {
        return this.control;
    }

    public void setShowValueConditions(ChartShowValueConditionControl chartShowValueConditionControl) {
        this.control = chartShowValueConditionControl;
    }

    public Vector getChartLabelShowInfo() {
        return this.createStaticLabelSmartShowInfo;
    }

    public Vector getChartLabelRotateInfo() {
        return this.custommerConstant;
    }

    public void createStaticLabelSmartShowInfo(int n) {
        int n2;
        if (this.createStaticLabelSmartShowInfo == null) {
            this.createStaticLabelSmartShowInfo = new Vector();
        }
        this.createStaticLabelSmartShowInfo.clear();
        for (n2 = 0; n2 < n; ++n2) {
            this.createStaticLabelSmartShowInfo.add(null);
        }
        if (this.custommerConstant == null) {
            this.custommerConstant = new Vector();
        }
        this.custommerConstant.clear();
        for (n2 = 0; n2 < n; ++n2) {
            this.custommerConstant.add(new Boolean(false));
        }
    }

    public List getLEDLegendLabels() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Vector vector = this.add.getProperties().getGraphProperties().getIndicatorRangeNames();
        String string = this.add.getProperties().getGraphProperties().getIndicatorOtherName();
        if (this.COLORLENGTH.getValueSqlType() != 1) {
            int n = vector.size() > 2 ? vector.size() - 2 : 0;
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.get(i + 2);
                arrayList.add(string2);
            }
            arrayList.add(string);
        } else {
            for (int i = 0; i < 2; ++i) {
                String string3 = (String)vector.get(i);
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public ChartFillPattern[] getLEDLegendFills() {
        ChartFillPattern[] chartFillPatternArray = this.add.getProperties().getGraphProperties().getIndicatorColors();
        int n = 0;
        ChartFillPattern[] chartFillPatternArray2 = null;
        if (this.COLORLENGTH.getValueSqlType() != 1) {
            if (chartFillPatternArray != null && chartFillPatternArray.length > 2) {
                n = chartFillPatternArray.length - 2;
            }
            chartFillPatternArray2 = new ChartFillPattern[n + 1];
            for (int i = 0; i < n; ++i) {
                chartFillPatternArray2[i] = chartFillPatternArray[i + 2];
            }
            chartFillPatternArray2[n] = this.add.getProperties().getGraphProperties().getIndicatorOtherColor();
        } else {
            chartFillPatternArray2 = new ChartFillPattern[2];
            for (int i = 0; i < 2; ++i) {
                chartFillPatternArray2[i] = chartFillPatternArray[i];
            }
        }
        return chartFillPatternArray2;
    }

    public boolean isLEDChart() {
        boolean bl = false;
        ChartDataSet chartDataSet = null;
        for (int i = 0; i < this.VALUE_ANTIALIAS_ON.size(); ++i) {
            chartDataSet = (ChartDataSet)this.VALUE_ANTIALIAS_ON.get(i);
            int n = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
            if (n != 13) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int getLegendLabelStart() {
        return this.cutRectangle;
    }

    public void setLegendLabelStart(int n) {
        if (n >= 0) {
            this.cutRectangle = n;
        }
    }

    protected boolean isConstantData() {
        List list;
        if (this.add != null && this.add.getProperties().getAxisXProperties().getUnitProperties().getUseConstantInterva() && (list = this.COLORLENGTH.getCategoryNames()) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null || !(list.get(i) instanceof Number) && !(list.get(i) instanceof Date)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSupportScrollChart() {
        return this.depthEnable;
    }

    public void setIsExpandLegend(boolean bl) {
        this.dispose = bl;
    }

    public boolean isExpandLegend() {
        return this.dispose;
    }

    public int getAxisXSkipNumber() {
        if (this.add.getAxisX1() != null) {
            int n = this.add.getAxisX1().getTickSkipNum();
            return n >= 0 ? n : 0;
        }
        return 0;
    }

    public int getAxisYSkipNumber() {
        if (this.add.getAxisY1() != null) {
            int n = this.add.getAxisY1().getTickSkipNum();
            return n >= 0 ? n : 0;
        }
        return 0;
    }

    public int getAxisX2SkipNumber() {
        if (this.add instanceof Chart2DPaper && ((Chart2DPaper)this.add).getAxisX2() != null) {
            int n = ((Chart2DPaper)this.add).getAxisX2().getTickSkipNum();
            return n >= 0 ? n : 0;
        }
        return 0;
    }

    public int getAxisY2SkipNumber() {
        if (this.add instanceof Chart2DPaper && ((Chart2DPaper)this.add).getAxisY2() != null) {
            int n = ((Chart2DPaper)this.add).getAxisY2().getTickSkipNum();
            return n >= 0 ? n : 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintLegendAndLabel(Graphics2D graphics2D) {
        Object object = null;
        if (this.D) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.width == 0 || this.height == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        if (this.needRelocate) {
            this.locate();
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            if (!(this.children.get(i) instanceof ChartLegend) && !(this.children.get(i) instanceof ChartLabel)) continue;
            ChartComponent chartComponent = (ChartComponent)this.children.get(i);
            Rectangle rectangle = chartComponent.getBounds();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            try {
                chartComponent.paint(graphics2D2);
                continue;
            }
            finally {
                graphics2D2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintNoLegendAndLabel(Graphics2D graphics2D) {
        Object object = null;
        this.background = this.COMPONENT_MARGIN.getBackground();
        if (this.D) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.width == 0 || this.height == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        if (this.needRelocate) {
            this.locate();
        }
        if (this.background != null) {
            this.background.paintBackground(graphics2D, rectangle);
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            if (this.children.get(i) instanceof ChartLegend || this.children.get(i) instanceof ChartLabel) continue;
            ChartComponent chartComponent = (ChartComponent)this.children.get(i);
            Rectangle rectangle2 = chartComponent.getBounds();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            try {
                chartComponent.paint(graphics2D2);
                continue;
            }
            finally {
                graphics2D2.dispose();
            }
        }
        this.paintBorder(graphics2D);
        this.drawOrgLine(graphics2D);
        if (object != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
        this.ispaint = true;
    }
}

