/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartComponent;
import chart.ChartLegend;
import chart.ChartObject;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class ChartScrollBar
extends ChartComponent {
    Rectangle bounds;
    ChartComponent component;
    int pos;
    float start = 0.0f;
    float percent = 0.0f;

    public ChartScrollBar(ChartComponent chartComponent, int n) {
        this.component = chartComponent;
        this.pos = n;
    }

    @Override
    public void init() {
    }

    @Override
    public void locate() {
        if (this.component == null) {
            return;
        }
        Rectangle rectangle = this.component.getBounds();
        if (this.bounds == null) {
            this.bounds = new Rectangle();
        }
        if (this.component instanceof ChartLegend && ((ChartLegend)this.component).isExpand()) {
            this.bounds.setLocation(rectangle.width - 16, 1);
        } else {
            this.bounds.setLocation(rectangle.width - 16, 1);
        }
        this.bounds.setSize(16, rectangle.height - 2 < 0 ? 1 : rectangle.height - 2);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.bounds == null) {
            return;
        }
        ChartRenderTools.drawLegendScrButton(graphics2D, new Rectangle(this.bounds.x, this.bounds.y, 16, this.bounds.height), this.start, this.percent);
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        if (this.getBounds().contains(n, n2)) {
            return this;
        }
        return null;
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.bounds;
    }

    public void setStatus(float f, float f2) {
        this.start = f;
        this.percent = f2;
    }
}

