/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.ChartObject;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartWallProperties;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class ChartWall
extends ChartObject {
    protected ChartPenStyle pen;
    protected ChartFillPattern pattern;
    protected Point2D.Float[] point = new Point2D.Float[4];
    protected GeneralPath path = new GeneralPath();
    protected boolean showWall = true;
    protected boolean select;
    protected Point2D.Float[][] boundFillPoint;
    private GeneralPath F;
    private ChartWallProperties SEDU;
    private ChartFillPattern closePath;

    public ChartWall() {
        this.pen = new ChartPenStyle("Solid Line");
        this.pattern = new ChartColorPattern("Grey");
        this.point = new Point2D.Float[4];
        this.F = new GeneralPath();
    }

    public ChartWall(Point2D.Float[] floatArray) {
        this.pen = new ChartPenStyle("Solid Line");
        this.pattern = new ChartColorPattern("Grey");
        this.point = floatArray;
        this.F = new GeneralPath();
        this.closePath = new ChartColorPattern("Red");
    }

    public ChartWall(Point2D.Float[] floatArray, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern) {
        this.pen = chartPenStyle;
        this.pattern = chartFillPattern;
        this.point = floatArray;
        this.F = new GeneralPath();
        this.closePath = new ChartColorPattern("Red");
    }

    public void draw(Graphics2D graphics2D) {
        if (this.point == null) {
            return;
        }
        for (int i = 0; i < this.point.length; ++i) {
            if (this.point[i] != null) continue;
            return;
        }
        this.path.reset();
        this.path.moveTo(this.point[0].x, this.point[0].y);
        this.path.lineTo(this.point[1].x, this.point[1].y);
        this.path.lineTo(this.point[2].x, this.point[2].y);
        this.path.lineTo(this.point[3].x, this.point[3].y);
        this.path.closePath();
        this.pattern = this.SEDU.getPattern1();
        if (this.pattern != null) {
            this.pattern.fill(graphics2D, this.path);
        }
        this.pen = this.SEDU.getBorder();
        if (this.pen != null) {
            this.pen.draw(graphics2D, this.path);
        }
        this.F();
    }

    private void F() {
        this.F.reset();
        this.F.moveTo(this.point[0].x, this.point[0].y);
        this.F.lineTo(this.point[1].x, this.point[1].y);
        this.F.lineTo(this.point[2].x, this.point[2].y);
        this.F.lineTo(this.point[3].x, this.point[3].y);
        this.F.closePath();
    }

    public void drawSides(Graphics2D graphics2D) {
        if (this.point == null) {
            return;
        }
        for (int i = 0; i < this.point.length; ++i) {
            if (this.point[i] != null) continue;
            return;
        }
        this.path.reset();
        this.path.moveTo(this.point[0].x, this.point[0].y);
        this.path.lineTo(this.point[1].x, this.point[1].y);
        this.path.lineTo(this.point[2].x, this.point[2].y);
        this.path.lineTo(this.point[3].x, this.point[3].y);
        this.path.closePath();
        this.pen = this.SEDU.getBorder();
        if (this.pen != null) {
            this.pen.draw(graphics2D, this.path);
        }
        this.F();
    }

    public void setPoint(Point2D.Float[] floatArray) {
        this.point = floatArray;
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.pen = chartPenStyle;
    }

    public void setPattern(ChartFillPattern chartFillPattern) {
        this.pattern = chartFillPattern;
    }

    public ChartPenStyle getPen() {
        return this.pen;
    }

    public ChartFillPattern getPattern() {
        return this.pattern;
    }

    public boolean contains(float f, float f2) {
        return false;
    }

    public void setBoundFillPoint(Point2D.Float[][] floatArray) {
        this.boundFillPoint = floatArray;
    }

    public void boundFill(Graphics2D graphics2D) {
        if (this.boundFillPoint == null) {
            return;
        }
        Point2D.Float[] floatArray = new Point2D.Float[4];
        this.path.reset();
        for (int i = 0; i < this.boundFillPoint.length; ++i) {
            if (this.boundFillPoint[i] == null) {
                return;
            }
            for (int j = 0; j < this.boundFillPoint[i].length; ++j) {
                if (this.boundFillPoint[i][j] != null) continue;
                return;
            }
            floatArray = this.boundFillPoint[i];
            this.path.moveTo(floatArray[0].x, floatArray[0].y);
            this.path.lineTo(floatArray[1].x, floatArray[1].y);
            this.path.lineTo(floatArray[2].x, floatArray[2].y);
            this.path.lineTo(floatArray[3].x, floatArray[3].y);
        }
        this.path.closePath();
        if (this.pattern != null) {
            this.pattern.fill(graphics2D, this.path);
            if (this.pen != null) {
                this.pen.draw(graphics2D, this.path);
            }
        }
    }

    public boolean searchSelectedWall(int n, int n2) {
        return this.F.contains(n, n2);
    }

    public Shape getSelectedAreaPath() {
        return this.F;
    }

    @Override
    public void init() {
    }

    @Override
    public void locate() {
    }

    @Override
    public void paint(Graphics2D graphics2D) {
    }

    public void setProperties(ChartWallProperties chartWallProperties) {
        this.SEDU = chartWallProperties;
    }

    public ChartWallProperties getProperties() {
        return this.SEDU;
    }
}

