/*
 * Decompiled with CFR 0.152.
 */
package chart.axis;

import chart.ChartLabelBase;
import chart.axis.ChartAxis;
import chart.data.ChartDataFilter;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartAxisProperties;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;

public class ChartCategoryAxis
extends ChartAxis {
    List labels;
    Vector dimValue;
    protected ChartDataFilter subFilter;
    boolean isLineUnit;
    boolean isCusConst;
    boolean resetLabel;
    Object[] vmx;
    double[] vm;
    double minUnit;
    int cusValueType;
    boolean useCusConst;
    ChartDataFilter minorFilter;
    int constantDataType = 0;
    float tickScale = 1.0f;
    float[] scrollInfo;
    List orgCategory = null;

    public ChartCategoryAxis(ChartAxisProperties chartAxisProperties, List list) {
        super(chartAxisProperties);
        this.labels = list;
        this.orgCategory = list;
    }

    @Override
    public void init() {
        if (this.labels == null) {
            return;
        }
        if (this.labN == -1) {
            this.labN = this.labels.size();
        }
        if (this.vm == null) {
            this.vm = new double[2];
        }
        this.minorFilter = !this.properties.getMajorTickMarkProperties().getCorrelateLabelFormat() ? this.getProperties().getMinorDataFilter() : this.filter;
        this.initCusConstAxis();
        this.majorTextStyle = (ChartTextStyle)this.properties.getMajorTickMarkProperties().getTickMarkLabel().clone();
        if (!this.getProperties().getMinorTickMarkProperties().getCorrelateLabel()) {
            this.minorTextStyle = (ChartTextStyle)this.getProperties().getMinorTickMarkProperties().getTickMarkLabel().clone();
        } else {
            this.minorTextStyle = (ChartTextStyle)this.majorTextStyle.clone();
            this.getProperties().getMinorTickMarkProperties().setAutoRotate(this.getProperties().IsLabelFontAutomaticOrientation());
        }
        this.correlatedMinorLabel = this.custommerConstant() && !this.getProperties().getMinorTickMarkProperties().getCorrelateLabel();
        this.correlatedMajorTickMark = this.custommerConstant() && this.getProperties().getMajorTickMarkProperties().getCorrelateTickMark();
        boolean bl = this.correlatedMinorTickMark = this.custommerConstant() && this.getProperties().getMinorTickMarkProperties().getCorrelateTickMark();
        if (!this.isCusConst) {
            this.paintingLabels = new ChartLabelBase[this.labels.size()];
            for (int i = 0; i < this.labels.size(); ++i) {
                String string = this.labels.get(i) == null ? "" : (this.filter != null ? this.filter.filter(this.labels.get(i), i) : this.labels.get(i).toString());
                if (!this.properties.getMajorTickMarkProperties().getAutoRotate() && this.properties.getLabelTextStyle().getRotation() != 0.0) {
                    this.rotation = this.formatAngle(this.properties.getLabelTextStyle().getRotation());
                }
                this.paintingLabels[i] = new ChartLabelBase(string);
                this.paintingLabels[i].setChartTextStyle(this.majorTextStyle);
            }
        } else {
            if (!this.properties.getMajorTickMarkProperties().getAutoRotate() && this.properties.getLabelTextStyle().getRotation() != 0.0) {
                this.rotation = this.formatAngle(this.properties.getLabelTextStyle().getRotation());
            }
            if (!this.properties.getMinorTickMarkProperties().getAutoRotate() && this.properties.getMinorTickMarkProperties().getTickMarkLabel().getRotation() != 0.0) {
                this.monirrotation = this.formatAngle(this.properties.getMinorTickMarkProperties().getTickMarkLabel().getRotation());
            }
            this.initLabel();
        }
        this.initedLabelStyle = true;
        if (this.custommerConstant()) {
            this.isLineUnit = true;
        }
        super.init();
    }

    protected void initLabel() {
        SimpleDateFormat simpleDateFormat = null;
        if (this.constantDataType == 1) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else if (this.constantDataType == 2) {
            simpleDateFormat = new SimpleDateFormat("hh:mm:ss a");
        } else if (this.constantDataType == 3) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a");
        }
        int n = 1;
        this.paintingLabels = new ChartLabelBase[this.labels.size()];
        for (int i = 0; i < this.labels.size(); i += n) {
            String string = !this.properties.getMinorTickMarkProperties().getShowMarkLabels() && this.minorTickNumber > 0 && (i + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) != 0 ? "" : (!this.properties.getMinorTickMarkProperties().getAutoLabelNumber() && this.minorTickNumber > 0 && (i + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) > this.properties.getMinorTickMarkProperties().getLabelNumber() ? "" : (this.labels.get(i) == null ? "" : (this.labels.get(i) instanceof java.util.Date ? (!this.properties.getMinorTickMarkProperties().getCorrelateLabelFormat() && this.minorTickNumber > 0 && (i + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) != 0 ? (this.minorFilter != null ? this.minorFilter.filter(this.labels.get(i), i) : (simpleDateFormat != null ? simpleDateFormat.format(this.labels.get(i)) : this.labels.get(i).toString())) : (this.filter != null ? this.filter.filter(this.labels.get(i), i) : (simpleDateFormat != null ? simpleDateFormat.format(this.labels.get(i)) : this.labels.get(i).toString()))) : (!this.properties.getMinorTickMarkProperties().getCorrelateLabelFormat() && this.minorTickNumber > 0 && (i + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) != 0 ? (this.minorFilter != null ? this.minorFilter.filter(this.labels.get(i), i) : this.labels.get(i).toString()) : (this.filter != null ? this.filter.filter(this.labels.get(i), i) : this.labels.get(i).toString())))));
            this.paintingLabels[i] = new ChartLabelBase(string);
            if (this.scrollTickmarkIdx > 0 && this.correlatedMinorLabel && this.minorTickNumber > 0) {
                if ((i + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) != 0) {
                    this.paintingLabels[i].setChartTextStyle(this.minorTextStyle);
                    continue;
                }
                this.paintingLabels[i].setChartTextStyle(this.majorTextStyle);
                continue;
            }
            if (this.correlatedMinorLabel && this.minorTickNumber > 0) {
                if (i % (this.minorTickNumber + 1) != 0) {
                    this.paintingLabels[i].setChartTextStyle(this.minorTextStyle);
                    continue;
                }
                this.paintingLabels[i].setChartTextStyle(this.majorTextStyle);
                continue;
            }
            this.paintingLabels[i].setChartTextStyle(this.majorTextStyle);
        }
    }

    protected void initCusConstAxis() {
        this.isCusConst = this.getProperties().getUnitProperties().getUseConstantInterva() && this.useCusConst;
        if (!this.isCusConst) {
            return;
        }
        this.isCusConst = false;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.labels.size(); ++i) {
            if (this.labels.get(i) == null) continue;
            if (this.labels.get(i) instanceof java.util.Date) {
                arrayList.add(this.labels.get(i));
                this.isCusConst = true;
                continue;
            }
            if (this.labels.get(i) instanceof Number) {
                arrayList.add(this.labels.get(i));
                this.isCusConst = true;
                continue;
            }
            this.isCusConst = false;
            break;
        }
        if (!this.isCusConst) {
            return;
        }
        if (this.resetLabel) {
            return;
        }
        if (this.vmx == null) {
            this.vmx = new Object[2];
        }
        if (arrayList.size() <= 0) {
            this.isCusConst = false;
            return;
        }
        Object[] objectArray = arrayList.toArray();
        Arrays.sort(objectArray);
        this.vmx[0] = objectArray[0];
        this.vmx[1] = objectArray[objectArray.length - 1];
        if (objectArray[0] instanceof java.util.Date) {
            this.vmx[0] = new java.util.Date(((java.util.Date)objectArray[0]).getTime());
            this.vmx[1] = new java.util.Date(((java.util.Date)objectArray[objectArray.length - 1]).getTime());
            this.constantDataType = objectArray[0] instanceof Date ? 1 : (objectArray[0] instanceof Timestamp ? 3 : 2);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            boolean bl = this.getProperties().getUnitProperties().getAutoStart();
            boolean bl2 = this.getProperties().getUnitProperties().getAutoEnd();
            boolean bl3 = this.getProperties().getUnitProperties().getAutoMajorUnit();
            boolean bl4 = this.getProperties().getUnitProperties().getAutoMinorUnit();
            int[] nArray = null;
            if (!bl) {
                ((java.util.Date)this.vmx[0]).setTime(this.getProperties().getUnitProperties().getStartTime());
            }
            if (!bl2) {
                ((java.util.Date)this.vmx[1]).setTime(this.getProperties().getUnitProperties().getEndTime());
            }
            if (((java.util.Date)this.vmx[1]).getTime() <= ((java.util.Date)this.vmx[0]).getTime()) {
                ((java.util.Date)this.vmx[1]).setTime(((java.util.Date)this.vmx[0]).getTime() + 1000L);
            }
            if (bl3) {
                nArray = this.getTimeUnit(((java.util.Date)this.vmx[1]).getTime() - ((java.util.Date)this.vmx[0]).getTime());
                n3 = nArray[0];
                n = nArray[1];
            } else {
                n = this.getProperties().getUnitProperties().getMajorUnitInt();
                n3 = this.getProperties().getUnitProperties().getMajorUnitDateType();
            }
            int n5 = n = n < 1 ? 1 : n;
            if (bl4 || this.properties.getUnitProperties().getMinorUnitInt() <= 0) {
                nArray = this.getMinorTimeUnit(n3, n);
                n4 = nArray[0];
                n2 = nArray[1];
            } else {
                n2 = this.getProperties().getUnitProperties().getMinorUnitInt();
                n4 = this.getProperties().getUnitProperties().getMinorUnitDateType();
            }
            int n6 = n2 = n2 < 1 ? 1 : n2;
            if (this.firstIni) {
                float f = this.getAxisLength();
                if (f > 0.0f) {
                    f /= this.minTickDis;
                    long l = this.D(((java.util.Date)this.vmx[1]).getTime() - ((java.util.Date)this.vmx[0]).getTime(), this.getTime(n3, n));
                    l = l < 0L ? 0L : l;
                    int n7 = (int)((float)l / (f *= 10.0f));
                    int n8 = n7 = n7 < 1 ? 1 : n7;
                    if (n7 > 1) {
                        this.firstSkip = n7;
                    }
                }
                this.firstIni = false;
            }
            if (this.skipTickN >= 1 || this.firstSkip >= 1) {
                int n9 = this.skipTickN;
                if (this.skipTickN >= 1 && this.firstSkip >= 1) {
                    n9 *= this.firstSkip;
                } else if (this.skipTickN < 1 && this.firstSkip >= 1) {
                    n9 = this.firstSkip;
                }
                int n10 = (int)(this.getTime(n3, n) / this.getTime(n4, n2)) - 1;
                n10 = n10 < 0 ? 0 : n10;
                n10 = n9 / (n10 + 1);
                if (n10 > 1) {
                    n = n10 * n;
                }
                n2 = n * 2;
                n4 = n3;
            }
            if (bl2) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime((java.util.Date)this.vmx[0]);
                block31: while (gregorianCalendar.getTime().before((java.util.Date)this.vmx[1])) {
                    switch (n3) {
                        case 0: {
                            ((Calendar)gregorianCalendar).add(1, n);
                            continue block31;
                        }
                        case 1: {
                            ((Calendar)gregorianCalendar).add(2, 3 * n);
                            continue block31;
                        }
                        case 2: {
                            ((Calendar)gregorianCalendar).add(2, n);
                            continue block31;
                        }
                        case 3: {
                            ((Calendar)gregorianCalendar).add(10, 168 * n);
                            continue block31;
                        }
                        case 4: {
                            ((Calendar)gregorianCalendar).add(10, 24 * n);
                            continue block31;
                        }
                        case 5: {
                            ((Calendar)gregorianCalendar).add(10, n);
                            continue block31;
                        }
                        case 6: {
                            ((Calendar)gregorianCalendar).add(12, n);
                            continue block31;
                        }
                        case 7: {
                            ((Calendar)gregorianCalendar).add(13, n);
                            continue block31;
                        }
                    }
                    ((Calendar)gregorianCalendar).add(2, n);
                }
                this.vmx[1] = gregorianCalendar.getTime();
            }
            for (int i = 0; i < objectArray.length - 1; ++i) {
                if (objectArray[i] == null || objectArray[i + 1] == null || !(objectArray[i] instanceof java.util.Date) || !(objectArray[i + 1] instanceof java.util.Date)) continue;
                this.minUnit = i == 0 ? (double)(((java.util.Date)objectArray[i + 1]).getTime() - ((java.util.Date)objectArray[i]).getTime()) : (this.minUnit < (double)(((java.util.Date)objectArray[i + 1]).getTime() - ((java.util.Date)objectArray[i]).getTime()) ? this.minUnit : (double)(((java.util.Date)objectArray[i + 1]).getTime() - ((java.util.Date)objectArray[i]).getTime()));
            }
            ArrayList<java.util.Date> arrayList2 = new ArrayList<java.util.Date>();
            this.minorTickNumber = 0;
            this.minorTickNumber = (int)(this.getTime(n3, n) / this.getTime(n4, n2)) - 1;
            int n11 = this.minorTickNumber = this.minorTickNumber < 0 ? 0 : this.minorTickNumber;
            if (this.skipTickN >= 1 || this.firstSkip >= 1) {
                this.minorTickNumber = 0;
            }
            int n12 = this.minorTickNumber;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Object var15_31 = null;
            Calendar calendar = null;
            gregorianCalendar.setTime((java.util.Date)this.vmx[0]);
            arrayList2.add(gregorianCalendar.getTime());
            while (gregorianCalendar.getTime().before((java.util.Date)this.vmx[1]) || arrayList2.size() <= 1) {
                calendar = (Calendar)((Calendar)gregorianCalendar).clone();
                switch (n3) {
                    case 0: {
                        ((Calendar)gregorianCalendar).add(1, n);
                        break;
                    }
                    case 1: {
                        ((Calendar)gregorianCalendar).add(2, 3 * n);
                        break;
                    }
                    case 2: {
                        ((Calendar)gregorianCalendar).add(2, n);
                        break;
                    }
                    case 3: {
                        ((Calendar)gregorianCalendar).add(10, 168 * n);
                        break;
                    }
                    case 4: {
                        ((Calendar)gregorianCalendar).add(10, 24 * n);
                        break;
                    }
                    case 5: {
                        ((Calendar)gregorianCalendar).add(10, n);
                        break;
                    }
                    case 6: {
                        ((Calendar)gregorianCalendar).add(12, n);
                        break;
                    }
                    case 7: {
                        ((Calendar)gregorianCalendar).add(13, n);
                        break;
                    }
                    default: {
                        ((Calendar)gregorianCalendar).add(2, n);
                    }
                }
                if (n12 >= 1) {
                    for (int i = 1; i <= n12 && calendar.getTime().before((java.util.Date)this.vmx[1]); ++i) {
                        switch (n4) {
                            case 0: {
                                calendar.add(1, n2);
                                break;
                            }
                            case 1: {
                                calendar.add(2, 3 * n2);
                                break;
                            }
                            case 2: {
                                calendar.add(2, n2);
                                break;
                            }
                            case 3: {
                                calendar.add(10, 168 * n2);
                                break;
                            }
                            case 4: {
                                calendar.add(10, 24 * n2);
                                break;
                            }
                            case 5: {
                                calendar.add(10, n2);
                                break;
                            }
                            case 6: {
                                calendar.add(12, n2);
                                break;
                            }
                            case 7: {
                                calendar.add(13, n2);
                                break;
                            }
                        }
                        if (this.properties.getMinorTickMarkProperties().getShowMarkLabels() && this.properties.getMinorTickMarkProperties().getAutoLabelNumber()) {
                            arrayList2.add(calendar.getTime());
                            continue;
                        }
                        if (this.properties.getMinorTickMarkProperties().getShowMarkLabels() && this.properties.getMinorTickMarkProperties().getLabelNumber() > 0 && i <= this.properties.getMinorTickMarkProperties().getLabelNumber()) {
                            arrayList2.add(calendar.getTime());
                            continue;
                        }
                        arrayList2.add(calendar.getTime());
                    }
                }
                arrayList2.add(gregorianCalendar.getTime());
            }
            this.cusValueType = 1;
            double[] dArray = new double[]{((java.util.Date)this.vmx[0]).getTime(), ((java.util.Date)this.vmx[1]).getTime()};
            this.F(objectArray, this.vmx);
            List list = this.calculateScrollLabels(arrayList2, this.scrollInfo, dArray);
            if (this.scrollInfo != null) {
                this.vmx[0] = new java.util.Date((long)(dArray[0] + (double)this.scrollInfo[0] * (dArray[1] - dArray[0])));
                this.vmx[1] = new java.util.Date((long)(dArray[0] + (double)this.scrollInfo[1] * (dArray[1] - dArray[0])));
            }
            this.vm[0] = ((java.util.Date)this.vmx[0]).getTime();
            this.vm[1] = ((java.util.Date)this.vmx[1]).getTime();
            this.minUnit /= this.vm[1] - this.vm[0];
            this.minUnit /= 2.0;
            this.labels = list;
            this.resetLabel = true;
        } else if (this.vmx[0] instanceof Number) {
            int n;
            float f = 0.0f;
            float f2 = 0.0f;
            boolean bl = this.getProperties().getUnitProperties().getAutoMajorUnit();
            boolean bl5 = this.getProperties().getUnitProperties().getAutoMinorUnit();
            double d = 0.0;
            double d2 = 0.0;
            boolean bl6 = this.getProperties().getUnitProperties().getAutoStart();
            boolean bl7 = this.getProperties().getUnitProperties().getAutoEnd();
            if (!bl) {
                f = this.getProperties().getUnitProperties().getMajorUnitFloat();
            }
            if (bl || f <= 0.0f) {
                f = (float)this.getNumberUnit(d2 - d);
            }
            if (bl5) {
                f2 = (float)this.getNumberUnit(f);
            }
            if (!bl5 || f2 <= 0.0f) {
                f2 = this.getProperties().getUnitProperties().getMinorUnitFloat();
            }
            d = bl6 ? ((Number)this.vmx[0]).doubleValue() : this.getProperties().getUnitProperties().getStartValue();
            if (!bl7) {
                d2 = this.getProperties().getUnitProperties().getEndValue();
            }
            if (bl7 || d2 <= d) {
                for (d2 = d; d2 <= d || d2 < ((Number)this.vmx[1]).doubleValue(); d2 += (double)f) {
                }
            }
            this.vmx[0] = new Double(d);
            this.vmx[1] = new Double(d2);
            Number number = null;
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == null || !(objectArray[n] instanceof Number)) continue;
                number = (Number)objectArray[n];
                break;
            }
            for (n = 0; n < objectArray.length - 1; ++n) {
                if (objectArray[n] == null || objectArray[n + 1] == null || !(objectArray[n] instanceof Number) || !(objectArray[n + 1] instanceof Number)) continue;
                this.minUnit = n == 0 ? (double)((Number)objectArray[n + 1]).floatValue() - ((Number)objectArray[n]).doubleValue() : (this.minUnit < ((Number)objectArray[n + 1]).doubleValue() - ((Number)objectArray[n]).doubleValue() ? this.minUnit : ((Number)objectArray[n + 1]).doubleValue() - ((Number)objectArray[n]).doubleValue());
            }
            if (this.firstIni) {
                float f3 = this.getAxisLength();
                if (f3 > 0.0f) {
                    f3 /= this.minTickDis;
                    long l = this.D(((Number)this.vmx[1]).floatValue() - ((Number)this.vmx[0]).floatValue(), f);
                    l = l < 0L ? 0L : l;
                    int n13 = (int)((float)l / (f3 *= 10.0f));
                    int n14 = n13 = n13 < 1 ? 1 : n13;
                    if (n13 > 1) {
                        this.firstSkip = n13;
                    }
                }
                this.firstIni = false;
            }
            if (this.skipTickN >= 1 || this.firstSkip >= 1) {
                int n15 = this.skipTickN;
                if (this.skipTickN >= 1 && this.firstSkip >= 1) {
                    n15 *= this.firstSkip;
                } else if (this.skipTickN < 1 && this.firstSkip >= 1) {
                    n15 = this.firstSkip;
                }
                int n16 = (int)(f / f2) - 1;
                n16 = n16 < 0 ? 0 : n16;
                n16 = n15 / (n16 + 1);
                if (n16 > 1) {
                    f = (float)n16 * f;
                }
                f2 = f * 2.0f;
            }
            ArrayList<Number> arrayList3 = new ArrayList<Number>();
            this.minorTickNumber = 0;
            this.minorTickNumber = (int)(f / f2) - 1;
            int n17 = this.minorTickNumber = this.minorTickNumber < 0 ? 0 : this.minorTickNumber;
            if (this.skipTickN >= 1 || this.firstSkip >= 1) {
                this.minorTickNumber = 0;
            }
            int n18 = this.minorTickNumber;
            double d3 = ((Number)this.vmx[0]).doubleValue();
            double d4 = ((Number)this.vmx[1]).doubleValue();
            arrayList3.add(this.getNumberData(number, d3));
            while (d3 < d4 || arrayList3.size() <= 1) {
                if (n18 >= 1) {
                    for (int i = 1; i <= n18; ++i) {
                        if (this.properties.getMinorTickMarkProperties().getShowMarkLabels() && this.properties.getMinorTickMarkProperties().getAutoLabelNumber()) {
                            arrayList3.add(this.getNumberData(number, d3 + (double)(f * (float)i / (float)(n18 + 1))));
                            continue;
                        }
                        if (this.properties.getMinorTickMarkProperties().getShowMarkLabels() && this.properties.getMinorTickMarkProperties().getLabelNumber() > 0 && i <= this.properties.getMinorTickMarkProperties().getLabelNumber()) {
                            arrayList3.add(this.getNumberData(number, d3 + (double)(f * (float)i / (float)(n18 + 1))));
                            continue;
                        }
                        arrayList3.add(this.getNumberData(number, d3 + (double)(f * (float)i / (float)(n18 + 1))));
                    }
                }
                arrayList3.add(this.getNumberData(number, d3 += (double)f));
            }
            this.cusValueType = 2;
            double[] dArray = new double[]{((Number)this.vmx[0]).doubleValue(), ((Number)this.vmx[1]).doubleValue()};
            this.F(objectArray, this.vmx);
            List list = this.calculateScrollLabels(arrayList3, this.scrollInfo, dArray);
            if (this.scrollInfo != null) {
                this.vmx[0] = new Double(dArray[0] + (double)this.scrollInfo[0] * (dArray[1] - dArray[0]));
                this.vmx[1] = new Double(dArray[0] + (double)this.scrollInfo[1] * (dArray[1] - dArray[0]));
            }
            this.vm[0] = ((Number)this.vmx[0]).doubleValue();
            this.vm[1] = ((Number)this.vmx[1]).doubleValue();
            this.minUnit /= this.vm[1] - this.vm[0];
            this.minUnit /= 2.0;
            this.labels = list;
            this.resetLabel = true;
        }
    }

    private long D(double d, double d2) {
        if (d2 == 0.0) {
            return -1L;
        }
        long l = 0L;
        l = (long)(d / d2);
        return l;
    }

    Number getNumberData(Number number, double d) {
        Number number2 = null;
        number2 = number != null ? (Number)(number instanceof Integer ? (Number)(d == (double)((int)d) ? (Number)new Integer((int)d) : (Number)new Float(d)) : (Number)(number instanceof Long ? (Number)(d == (double)((long)d) ? (Number)new Long((long)d) : (Number)new Double(d)) : (Number)(number instanceof Double ? (Number)new Double(d) : (Number)(number instanceof BigDecimal ? new BigDecimal(d) : new Float(d))))) : (Number)new Float(d);
        return number2;
    }

    protected int[] getTimeUnit(long l) {
        int n = 0;
        int n2 = 1;
        long l2 = 1L;
        long[] lArray = new long[]{31536000000L, 7776000000L, 2592000000L, 86400000L, 3600000L, 60000L, 1000L};
        if (l > lArray[0] * 3L) {
            n = 0;
            n2 = (int)(l / lArray[0]);
            n2 = (n2 = this.getNumberUnit(n2)) < 1 ? 1 : n2;
        } else if (l > lArray[1] * 4L) {
            n = 1;
            n2 = 1;
        } else if (l > lArray[2] * 2L) {
            n = 2;
            n2 = 1;
        } else if (l > lArray[3]) {
            n = 4;
            n2 = 1;
        } else if (l > lArray[4]) {
            n = 5;
            n2 = (int)(l / lArray[4]);
            n2 = (n2 /= 10) < 1 ? 1 : n2;
        } else if (l > lArray[5]) {
            n = 6;
            n2 = (int)(l / lArray[5]);
            n2 = (n2 /= 10) < 1 ? 1 : n2;
        } else {
            n = 7;
            n2 = (int)(l / lArray[6]);
            n2 = (n2 /= 10) <= 1 ? 1 : 5;
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    int[] getMinorTimeUnit(int n, int n2) {
        int n3 = -1;
        int n4 = 1;
        switch (n) {
            case 0: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = this.getNumberUnit(n2);
                    break;
                }
                n3 = 2;
                n4 = 2;
                break;
            }
            case 1: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = this.getNumberUnit(n2);
                    break;
                }
                n3 = 2;
                n4 = 1;
                break;
            }
            case 2: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = this.getNumberUnit(n2);
                    break;
                }
                n3 = 2;
                n4 = 1;
                break;
            }
            case 3: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = this.getNumberUnit(n2);
                    break;
                }
                n3 = 4;
                n4 = 1;
                break;
            }
            case 4: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = this.getNumberUnit(n2);
                    break;
                }
                n3 = 4;
                n4 = 1;
                break;
            }
            case 5: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = this.getNumberUnit(n2);
                    break;
                }
                n3 = 6;
                n4 = 30;
                break;
            }
            case 6: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = this.getNumberUnit(n2);
                    break;
                }
                n3 = 7;
                n4 = 30;
                break;
            }
            case 7: {
                if (n2 > 1) {
                    n3 = n;
                    n4 = this.getNumberUnit(n2);
                    break;
                }
                n3 = 7;
                n4 = 1;
                break;
            }
        }
        n3 = n3 == -1 ? 0 : n3;
        int[] nArray = new int[]{n3, n4};
        return nArray;
    }

    long getTime(int n, int n2) {
        long[] lArray = new long[]{31536000000L, 7776000000L, 2592000000L, 86400000L, 3600000L, 60000L, 1000L};
        switch (n) {
            case 0: {
                return (long)n2 * lArray[0];
            }
            case 1: {
                return (long)n2 * lArray[1];
            }
            case 2: {
                return (long)n2 * lArray[2];
            }
            case 3: {
                return (long)n2 * lArray[3] * 7L;
            }
            case 4: {
                return (long)n2 * lArray[3];
            }
            case 5: {
                return (long)n2 * lArray[4];
            }
            case 6: {
                return (long)n2 * lArray[5];
            }
            case 7: {
                return (long)n2 * lArray[6];
            }
        }
        return 1L;
    }

    double getNumberUnit(double d) {
        double d2 = 1.0;
        if (d > 0.0) {
            double d3;
            double d4 = 1.0;
            for (d3 = d; d3 > 10.0; d3 /= 10.0) {
                d4 *= 10.0;
            }
            if (d3 > 5.0) {
                d4 *= 2.0;
            }
            d2 *= d4;
        }
        return d2;
    }

    int getNumberUnit(int n) {
        int n2 = 1;
        if (n > 0) {
            int n3 = n;
            int n4 = 1;
            while (n3 > 50) {
                n4 = (int)((float)n4 * 10.0f);
                n3 = (int)((float)n3 / 10.0f);
            }
            if (n3 > 20) {
                n4 *= 5;
            } else if (n3 > 10) {
                n4 *= 2;
            }
            n2 *= n4;
        }
        return n2;
    }

    protected java.util.Date getEndDate(java.util.Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        switch (n) {
            case 0: {
                gregorianCalendar.set(2, 11);
                gregorianCalendar.set(5, 31);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 1: {
                gregorianCalendar.set(2, 11);
                gregorianCalendar.set(5, 31);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 2: {
                ((Calendar)gregorianCalendar).add(2, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 3: {
                ((Calendar)gregorianCalendar).add(5, 7);
                gregorianCalendar.set(7, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 4: {
                ((Calendar)gregorianCalendar).add(5, 7);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 5: {
                ((Calendar)gregorianCalendar).add(11, 1);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 6: {
                ((Calendar)gregorianCalendar).add(12, 1);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 7: {
                ((Calendar)gregorianCalendar).add(13, 1);
                gregorianCalendar.set(14, 0);
                break;
            }
        }
        return gregorianCalendar.getTime();
    }

    protected java.util.Date getStartDate(java.util.Date date, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        switch (n) {
            case 0: {
                gregorianCalendar.set(2, 0);
                gregorianCalendar.set(5, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 1: {
                gregorianCalendar.set(2, gregorianCalendar.get(2) / 3 * 3);
                gregorianCalendar.set(5, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 2: {
                gregorianCalendar.set(5, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 3: {
                gregorianCalendar.set(7, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 4: {
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 5: {
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 6: {
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                break;
            }
            case 7: {
                gregorianCalendar.set(14, 0);
                break;
            }
        }
        return gregorianCalendar.getTime();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.position == 0) {
            return;
        }
        this.locate();
        this.drawAxis(graphics2D, this.axisPoint);
        if (this.properties.isShowTickMarkLabels()) {
            this.drawLabels(graphics2D);
        }
        if (!this.isCusConst) {
            this.drawTickmarks(graphics2D);
        } else {
            this.drawConstantTickmarks(graphics2D, this.majorTickMarkPoint, this.numOfTicks);
        }
    }

    protected void drawConstantTickmarks(Graphics2D graphics2D, float[][] fArray2, int n) {
        if (fArray2 == null || fArray2.length == 0) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float[] fArray3 = new float[2];
        float f5 = this.getAxisAngle();
        f5 = (float)((double)f5 + 1.5707963267948966);
        f5 = (float)((double)f5 - ((double)f5 > Math.PI * 2 ? Math.PI * 2 : 0.0));
        float f6 = (float)Math.cos(f5);
        float f7 = (float)Math.sin(f5);
        ChartPenStyle chartPenStyle = !this.properties.getMajorTickMarkProperties().getCorrelateTickMark() ? (ChartPenStyle)this.properties.getTickMarkPen().clone() : (ChartPenStyle)this.properties.getAxisPen().clone();
        ChartPenStyle chartPenStyle2 = !this.properties.getMinorTickMarkProperties().getCorrelateTickMark() ? (ChartPenStyle)this.properties.getMinorTickMarkProperties().getTickMarkPen().clone() : (ChartPenStyle)this.properties.getAxisPen().clone();
        ChartPenStyle chartPenStyle3 = null;
        int n2 = this.properties.getTickMarkType();
        int n3 = this.properties.getMinorTickMarkProperties().getTickMarkType();
        float f8 = this.properties.getTickMarkLength();
        float f9 = this.properties.getMinorTickMarkProperties().getTickMarkLength();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            float f10;
            int n4;
            if ((i + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) == 0) {
                chartPenStyle3 = chartPenStyle;
                n4 = n2;
                f10 = f8;
            } else {
                chartPenStyle3 = chartPenStyle2;
                n4 = n3;
                f10 = f9;
            }
            fArray3[0] = fArray2[i][0];
            fArray3[1] = fArray2[i][1];
            generalPath.reset();
            switch (n4) {
                case 1: {
                    f = fArray3[0] + (float)Math.round(f6 * f10);
                    f2 = fArray3[1] - (float)Math.round(f7 * f10);
                    generalPath.moveTo(f, f2);
                    generalPath.lineTo(fArray3[0], fArray3[1]);
                    break;
                }
                case 2: {
                    f = fArray3[0] - (float)Math.round(f6 * f10);
                    f2 = fArray3[1] + (float)Math.round(f7 * f10);
                    generalPath.moveTo(f, f2);
                    generalPath.lineTo(fArray3[0], fArray3[1]);
                    break;
                }
                case 3: {
                    f = fArray3[0] - (float)Math.round(f6 * (f10 + 1.0f) / 2.0f);
                    f2 = fArray3[1] + (float)Math.round(f7 * (f10 + 1.0f) / 2.0f);
                    f3 = fArray3[0] + (float)Math.round(f6 * (f10 + 1.0f) / 2.0f);
                    f4 = fArray3[1] - (float)Math.round(f7 * (f10 + 1.0f) / 2.0f);
                    generalPath.moveTo(f, f2);
                    generalPath.lineTo(f3, f4);
                    break;
                }
                case 0: {
                    break;
                }
            }
            chartPenStyle3.draw(graphics2D, generalPath);
        }
    }

    protected void drawTickmarks(Graphics2D graphics2D) {
        if (this.properties.getTickMarkType() != 0) {
            this.drawTickMark(graphics2D, this.properties.getTickMarkPen(), this.majorTickMarkPoint, this.properties.getTickMarkLength(), this.properties.getTickMarkType(), this.numOfTicks, false);
        }
        if (this.drawMinorTick && this.properties.getMinorTickMarkType() != 0) {
            this.drawTickMark(graphics2D, this.properties.getTickMarkPen(), this.minorTickMarkPoint, this.properties.getMinorTickMarkLength(), this.properties.getMinorTickMarkType(), this.numOfTicks - 1, true);
        }
    }

    protected void drawTickMark(Graphics2D graphics2D, ChartPenStyle chartPenStyle, float[][] fArray2, float f, int n, int n2, boolean bl) {
        if (fArray2 == null || fArray2.length == 0) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float[] fArray3 = new float[2];
        float f6 = this.getAxisAngle();
        f6 = (float)((double)f6 + 1.5707963267948966);
        f6 = (float)((double)f6 - ((double)f6 > Math.PI * 2 ? Math.PI * 2 : 0.0));
        float f7 = (float)Math.cos(f6);
        float f8 = (float)Math.sin(f6);
        boolean bl2 = bl ? this.properties.getMinorTickMarkProperties().getCorrelateTickMark() : this.properties.getMajorTickMarkProperties().getCorrelateTickMark();
        ChartPenStyle chartPenStyle2 = null;
        ChartPenStyle chartPenStyle3 = (ChartPenStyle)chartPenStyle.clone();
        chartPenStyle2 = bl2 ? (ChartPenStyle)this.properties.getAxisPen().clone() : (bl ? (ChartPenStyle)this.properties.getMinorTickMarkProperties().getTickMarkPen().clone() : (ChartPenStyle)this.properties.getMajorTickMarkProperties().getTickMarkPen().clone());
        boolean bl3 = false;
        for (int i = 0; i < n2; ++i) {
            float f9 = f;
            fArray3[0] = fArray2[i][0];
            fArray3[1] = fArray2[i][1];
            generalPath.reset();
            switch (n) {
                case 1: {
                    f2 = fArray3[0] + (float)Math.round(f7 * f9);
                    f3 = fArray3[1] - (float)Math.round(f8 * f9);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(fArray3[0], fArray3[1]);
                    break;
                }
                case 2: {
                    f2 = fArray3[0] - (float)Math.round(f7 * f9);
                    f3 = fArray3[1] + (float)Math.round(f8 * f9);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(fArray3[0], fArray3[1]);
                    break;
                }
                case 3: {
                    f2 = fArray3[0] - (float)Math.round(f7 * (f9 + 1.0f) / 2.0f);
                    f3 = fArray3[1] + (float)Math.round(f8 * (f9 + 1.0f) / 2.0f);
                    f4 = fArray3[0] + (float)Math.round(f7 * (f9 + 1.0f) / 2.0f);
                    f5 = fArray3[1] - (float)Math.round(f8 * (f9 + 1.0f) / 2.0f);
                    generalPath.moveTo(f2, f3);
                    generalPath.lineTo(f4, f5);
                    break;
                }
                case 0: {
                    break;
                }
            }
            chartPenStyle2.draw(graphics2D, generalPath);
        }
    }

    @Override
    public float getZeroPosition(float f) {
        return 0.0f;
    }

    @Override
    public float getUnit(float f) {
        if (this.scrollInfo != null && this.custommerConstant()) {
            return f;
        }
        float f2 = 0.0f;
        float f3 = f;
        if (this.custommerConstant() && this.unScroll) {
            f3 *= this.tickScale;
        }
        if (this.custommerConstant()) {
            return f;
        }
        f2 = this.labN > 0 ? (this.isLineUnit ? (this.labN == 1 ? f3 : f3 / (float)(this.labN - 1)) : f3 / (float)this.labN) : f3 / 2.0f;
        return f2;
    }

    @Override
    public void setIsLineUnit(boolean bl) {
        if (this.custommerConstant()) {
            return;
        }
        this.isLineUnit = bl;
    }

    @Override
    public float[][] getLabelsPosition() {
        return null;
    }

    public boolean isLineUnit() {
        return this.isLineUnit;
    }

    public void setDimValue(Vector vector) {
        this.dimValue = vector;
    }

    @Override
    public String[] getLabelsForHtml() {
        String[] stringArray = null;
        if (this.dimValue == null) {
            if (this.labels != null) {
                int n = this.properties.getMajorTickMarkProperties().getAutoLabelNumber() || this.properties.getNumOfLabels() > this.labels.size() ? this.labels.size() : this.properties.getNumOfLabels();
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = this.labels.get(i) == null ? null : this.labels.get(i).toString();
                }
            }
        } else {
            int n = this.properties.getMajorTickMarkProperties().getAutoLabelNumber() || this.properties.getNumOfLabels() > this.dimValue.size() ? this.dimValue.size() : this.properties.getNumOfLabels();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.dimValue.get(i) == null ? null : this.dimValue.get(i).toString();
            }
        }
        this.dimValue = null;
        return stringArray;
    }

    @Override
    public void locate() {
        super.locate();
    }

    @Override
    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public float getLabelUnit(float f) {
        return this.getUnit(f);
    }

    @Override
    public void setMajorTickMarkPoint(float[][] fArray2) {
        super.setMajorTickMarkPoint(fArray2);
    }

    @Override
    public boolean custommerConstant() {
        return this.isCusConst;
    }

    @Override
    public float getMinUnit(float f) {
        if (this.scrollInfo != null) {
            return (float)((double)f * this.minUnit);
        }
        float f2 = (float)((double)f * this.minUnit);
        f2 = this.isLineUnit() ? (f2 *= (float)(this.labels.size() - 1)) : (f2 *= (float)this.labels.size());
        f2 = f2 < 3.0f ? 3.0f : f2;
        f2 = f2 > f ? f : f2;
        return f2;
    }

    @Override
    public float getX(Object object, float f) {
        double d = 0.0;
        if (this.vm != null && object != null) {
            if (object instanceof java.util.Date) {
                d = ((java.util.Date)object).getTime();
                if (d > this.vm[1]) {
                    d = this.vm[1];
                }
                if (d < this.vm[0]) {
                    d = this.vm[0];
                }
                d = (d - this.vm[0]) / (this.vm[1] - this.vm[0]);
                d *= (double)f;
            }
            if (object instanceof Number) {
                d = ((Number)object).floatValue();
                if (d > this.vm[1]) {
                    d = this.vm[1];
                }
                if (d < this.vm[0]) {
                    d = this.vm[0];
                }
                d = (d - this.vm[0]) / (this.vm[1] - this.vm[0]);
                d *= (double)f;
            }
        }
        return (float)d;
    }

    @Override
    public float getLineX(Object object, float f) {
        double d = 0.0;
        if (object != null) {
            if (object instanceof java.util.Date) {
                d = ((java.util.Date)object).getTime();
            } else if (object instanceof Number) {
                d = ((Number)object).doubleValue();
            }
            d = (d - this.vm[0]) / (this.vm[1] - this.vm[0]);
            d *= (double)f;
        }
        return (float)d;
    }

    @Override
    public boolean lessMin(Object object) {
        if (object != null && (object instanceof java.util.Date || object instanceof Number)) {
            double d = object instanceof java.util.Date ? (double)((java.util.Date)object).getTime() : (double)((Number)object).floatValue();
            return d <= this.vm[0] || d - this.vm[0] < this.minUnit * (this.vm[1] - this.vm[0]);
        }
        return false;
    }

    @Override
    public boolean largeMax(Object object) {
        if (object != null && (object instanceof java.util.Date || object instanceof Number)) {
            double d = object instanceof java.util.Date ? (double)((java.util.Date)object).getTime() : (double)((Number)object).floatValue();
            return d >= this.vm[1] || this.vm[1] - d < this.minUnit * (this.vm[1] - this.vm[0]);
        }
        return false;
    }

    @Override
    public void setUseCustommerConstant(boolean bl) {
        this.useCusConst = bl;
    }

    @Override
    public boolean getAutoOritention(float f) {
        if (this.labelAutoRotate) {
            return true;
        }
        float f2 = f;
        if (this.isScroll() && this.custommerConstant() && this.labels != null) {
            f2 /= (float)(this.labels.size() + 1);
        } else if (this.minorTickNumber >= 1 && !this.properties.getMinorTickMarkProperties().getShowMarkLabels()) {
            f2 *= (float)(this.minorTickNumber + 1);
        }
        boolean bl = false;
        float[] fArray2 = new float[this.paintingLabelsLength];
        for (int i = 0; i < this.paintingLabelsLength; ++i) {
            Rectangle2D.Float float_ = !this.initedLabelStyle ? (Rectangle2D.Float)this.textStyle.getZeroRotationDimension(this.paintingLabels[i].getLabelText()) : (Rectangle2D.Float)this.paintingLabels[i].getChartTextStyle().getZeroRotationDimension(this.paintingLabels[i].getLabelText());
            fArray2[i] = float_.width;
            if (!(fArray2[i] > f2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void setRotation(double d) {
        if (this.textStyle != null && this.properties.IsLabelFontAutomaticOrientation()) {
            this.textStyle.setRotation(d);
        }
        if (this.minorTextStyle != null && this.getProperties().getMinorTickMarkProperties().getAutoRotate()) {
            this.minorTextStyle.setRotation(d);
        }
    }

    @Override
    public int getTimeBaseUnit() {
        return 0;
    }

    @Override
    public int getTimeUnit() {
        return 1;
    }

    @Override
    public void setLabelAutoRotate(boolean bl) {
        this.labelAutoRotate = bl;
        if (!bl) {
            double d;
            if (this.minorTextStyle != null) {
                d = !this.getProperties().getMinorTickMarkProperties().getCorrelateLabel() ? this.formatAngle(this.getProperties().getMinorTickMarkProperties().getTickMarkLabel().getRotation()) : this.formatAngle(this.getProperties().getMajorTickMarkProperties().getTickMarkLabel().getRotation());
                if (!this.getProperties().getMinorTickMarkProperties().getAutoRotate()) {
                    this.minorTextStyle.setRotation(d);
                    this.monirrotation = d;
                } else {
                    this.minorTextStyle.setRotation(0.0);
                    this.monirrotation = 0.0;
                }
            }
            if (this.majorTextStyle != null || this.textStyle != null) {
                d = this.formatAngle(this.getProperties().getMajorTickMarkProperties().getTickMarkLabel().getRotation());
                if (!this.getProperties().IsLabelFontAutomaticOrientation()) {
                    if (this.majorTextStyle != null) {
                        this.majorTextStyle.setRotation(d);
                    }
                    if (this.textStyle != null) {
                        this.textStyle.setRotation(d);
                    }
                    this.rotation = d;
                } else {
                    if (this.majorTextStyle != null) {
                        this.majorTextStyle.setRotation(0.0);
                    }
                    if (this.textStyle != null) {
                        this.textStyle.setRotation(0.0);
                    }
                    this.rotation = 0.0;
                }
            }
            return;
        }
        if (this.labelAutoRotate && this.properties.IsLabelFontAutomaticOrientation() && this.textStyle != null) {
            this.textStyle.setRotation(-0.5235987755982988);
            this.properties.getLabelTextStyle().setRotation(-0.5235987755982988);
            if (this.majorTextStyle != null) {
                this.majorTextStyle.setRotation(-0.5235987755982988);
            }
            this.rotation = -0.5235987755982988;
        }
        if (this.minorTextStyle != null && this.labelAutoRotate && (this.correlatedMinorLabel && this.getProperties().getMinorTickMarkProperties().getAutoRotate() || !this.correlatedMinorLabel && this.getProperties().getMajorTickMarkProperties().getAutoRotate())) {
            this.minorTextStyle.setRotation(this.formatAngle(-0.5235987755982988));
            this.monirrotation = -0.5235987755982988;
        }
    }

    @Override
    public Object[] getConstantStartEnd() {
        return this.vmx;
    }

    @Override
    public void setScrollInfo(float[] fArray2) {
        this.scrollInfo = fArray2;
    }

    @Override
    public float[] getScrollInfo() {
        return this.scrollInfo;
    }

    @Override
    public boolean isScroll() {
        return this.scrollInfo != null;
    }

    List calculateScrollLabels(List list, float[] fArray2, double[] dArray) {
        ArrayList arrayList = new ArrayList();
        this.scrollTickmarkIdx = -1;
        if (list != null && fArray2 != null && dArray != null) {
            Object e;
            int n;
            double d = Math.abs(fArray2[1] - fArray2[0]);
            double d2 = dArray[1] - dArray[0];
            double d3 = 0.0;
            double d4 = dArray[0] + d2 * (double)fArray2[0];
            double d5 = dArray[0] + d2 * (double)fArray2[1];
            for (n = 0; n < list.size(); ++n) {
                e = list.get(n);
                if (e == null) continue;
                if (e instanceof java.util.Date) {
                    d3 = ((java.util.Date)e).getTime();
                    if (!(d3 >= d4) || !(d3 <= d5)) continue;
                    arrayList.add(e);
                    if (this.scrollTickmarkIdx != -1) continue;
                    this.scrollTickmarkIdx = n;
                    continue;
                }
                if (!(e instanceof Number) || !((d3 = ((Number)e).doubleValue()) >= d4) || !(d3 <= d5)) continue;
                arrayList.add(e);
                if (this.scrollTickmarkIdx == -1) {
                    this.scrollTickmarkIdx = n;
                }
                if (this.scrollTickmarkIdx != -1) continue;
                this.scrollTickmarkIdx = n;
            }
            this.tickmarkValue = new double[arrayList.size() == 0 ? 1 : arrayList.size()];
            for (n = 0; n < arrayList.size(); ++n) {
                e = arrayList.get(n);
                if (e instanceof java.util.Date) {
                    d3 = ((java.util.Date)e).getTime();
                    this.tickmarkValue[n] = (d3 - d4) / (d5 - d4);
                    continue;
                }
                if (!(e instanceof Number)) continue;
                d3 = ((Number)e).doubleValue();
                this.tickmarkValue[n] = (d3 - d4) / (d5 - d4);
            }
        } else {
            if (list != null) {
                arrayList.add(list.get(0));
            }
            this.tickmarkValue = new double[2];
            this.tickmarkValue[1] = 1.0;
            this.tickmarkValue[0] = 0.0;
            this.scrollTickmarkIdx = 0;
        }
        return arrayList;
    }

    public float getAxisLength(float f) {
        if (this.scrollInfo != null) {
            // empty if block
        }
        return f;
    }

    String getFormatedLabel(int n) {
        if (this.labels == null) {
            return "";
        }
        if (n < 0 || n >= this.labels.size()) {
            return "";
        }
        String string = null;
        if (!this.custommerConstant()) {
            string = this.labels.get(n) == null ? "" : (this.filter != null ? this.filter.filter(this.labels.get(n), n) : this.labels.get(n).toString());
        } else {
            if (this.labels.get(n) == null) {
                return "";
            }
            ChartDataFilter chartDataFilter = null;
            chartDataFilter = !this.properties.getMinorTickMarkProperties().getCorrelateLabelFormat() && this.minorTickNumber > 0 && (n + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) != 0 ? this.minorFilter : this.filter;
            if (this.labels.get(n) instanceof java.util.Date) {
                if (chartDataFilter != null) {
                    string = chartDataFilter.filter(this.labels.get(n));
                } else {
                    SimpleDateFormat simpleDateFormat = null;
                    simpleDateFormat = this.constantDataType == 1 ? new SimpleDateFormat("yyyy-MM-dd") : (this.constantDataType == 2 ? new SimpleDateFormat("hh:mm:ss a") : (this.constantDataType == 3 ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a") : new SimpleDateFormat("yyyy-MM-dd")));
                    string = simpleDateFormat.format((java.util.Date)this.labels.get(n));
                }
            } else {
                string = this.labels.get(n) instanceof Number ? (chartDataFilter != null ? chartDataFilter.filter(this.labels.get(n)) : this.labels.get(n).toString()) : this.labels.get(n).toString();
            }
        }
        return string;
    }

    @Override
    public double getBottomAxisFristLabelWidht() {
        if (this.labels == null) {
            return 0.0;
        }
        if (this.labels.size() == 0) {
            return 0.0;
        }
        double d = 0.0;
        ChartTextStyle chartTextStyle = null;
        chartTextStyle = !this.custommerConstant() ? this.textStyle : (!this.properties.getMinorTickMarkProperties().getCorrelateLabelFormat() && this.minorTickNumber > 0 && (0 + this.scrollTickmarkIdx) % (this.minorTickNumber + 1) != 0 ? this.minorTextStyle : this.textStyle);
        d = chartTextStyle.getDimension(this.getFormatedLabel(0)).getWidth();
        double d2 = this.formatAngle(chartTextStyle.getRotation());
        if (d2 != 0.0) {
            if (d2 > 0.0 && d2 <= 1.5707963267948966 || d2 >= Math.PI && d2 < 4.71238898038469) {
                return 0.0;
            }
            return d * 2.0;
        }
        this.getAxisLength();
        return d;
    }

    @Override
    public double getBottomAxisLastLabelWidht() {
        if (this.labels == null) {
            return 0.0;
        }
        if (this.labels.size() == 0) {
            return 0.0;
        }
        double d = 0.0;
        ChartTextStyle chartTextStyle = null;
        int n = this.tickmarkValue == null ? this.labels.size() - 1 : this.tickmarkValue.length - 1;
        boolean bl = false;
        boolean bl2 = false;
        if (!this.custommerConstant()) {
            chartTextStyle = this.textStyle;
            bl2 = this.properties.getMajorTickMarkProperties().getAutoRotate();
            bl = this.isLineUnit;
        } else {
            bl = true;
            if (!this.properties.getMinorTickMarkProperties().getCorrelateLabelFormat() && this.minorTickNumber > 0 && n % (this.minorTickNumber + 1) != 0) {
                chartTextStyle = this.minorTextStyle;
                bl2 = this.properties.getMinorTickMarkProperties().getAutoRotate();
            } else {
                chartTextStyle = this.textStyle;
                bl2 = this.properties.getMajorTickMarkProperties().getAutoRotate();
            }
        }
        d = chartTextStyle.getDimension(this.getFormatedLabel(n)).getWidth();
        double d2 = this.formatAngle(chartTextStyle.getRotation());
        if (!bl2 && bl && d2 > 0.0 && d2 < 1.5707963267948966) {
            return d * 2.0;
        }
        return d;
    }

    @Override
    public Dimension getMaxDimensionOfLabels() {
        Dimension dimension = new Dimension();
        if (this.labels == null) {
            return dimension;
        }
        if (this.labels.size() == 0) {
            return dimension;
        }
        ChartTextStyle chartTextStyle = null;
        ChartTextStyle chartTextStyle2 = null;
        if (!this.custommerConstant()) {
            chartTextStyle = this.textStyle;
            chartTextStyle2 = this.textStyle;
        } else if (!this.properties.getMinorTickMarkProperties().getCorrelateLabelFormat() && this.minorTickNumber > 0) {
            chartTextStyle = this.textStyle;
            chartTextStyle2 = this.minorTextStyle;
        } else {
            chartTextStyle = this.textStyle;
            chartTextStyle2 = this.textStyle;
        }
        int n = 0;
        int n2 = this.tickmarkValue == null ? this.labels.size() : n + this.tickmarkValue.length;
        int n3 = 0;
        int n4 = 0;
        Rectangle2D rectangle2D = null;
        for (int i = n; i < n2; ++i) {
            rectangle2D = !this.properties.getMinorTickMarkProperties().getCorrelateLabelFormat() && this.minorTickNumber > 0 && i % (this.minorTickNumber + 1) != 0 ? chartTextStyle2.getDimension(this.getFormatedLabel(i)) : chartTextStyle.getDimension(this.getFormatedLabel(i));
            if (rectangle2D.getWidth() > (double)n3) {
                n3 = (int)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() > (double)n4)) continue;
            n4 = (int)rectangle2D.getHeight();
        }
        dimension.width = n3;
        dimension.height = n4;
        return dimension;
    }

    private void F(Object[] objectArray, Object[] objectArray2) {
        if (this.properties.getScrollableChart() && this.scrollInfo == null && objectArray != null && objectArray.length > 0 && objectArray2 != null && objectArray2.length > 0) {
            int n = 0;
            n = this.properties.getScrollableVisibleValue();
            n = n <= 0 ? 1 : n;
            this.scrollInfo = new float[2];
            if (objectArray2[0] instanceof java.util.Date) {
                n = n > objectArray.length ? objectArray.length - 1 : n - 1;
                java.util.Date date = (java.util.Date)objectArray[n];
                double d = date.getTime();
                double d2 = ((java.util.Date)objectArray2[1]).getTime() - ((java.util.Date)objectArray2[0]).getTime();
                if (d2 == 0.0) {
                    this.scrollInfo[0] = 0.0f;
                    this.scrollInfo[1] = 1.0f;
                    return;
                }
                d = (d = (d - (double)((java.util.Date)objectArray2[0]).getTime()) / d2) > 1.0 ? 1.0 : d;
                d = d < 0.0 ? 0.0 : d;
                this.scrollInfo[0] = 0.0f;
                this.scrollInfo[1] = (float)d;
                return;
            }
            if (objectArray2[0] instanceof Number) {
                n = n > objectArray.length ? objectArray.length - 1 : n - 1;
                Number number = (Number)objectArray[n];
                double d = number.doubleValue();
                double d3 = ((Number)objectArray2[1]).doubleValue() - ((Number)objectArray2[0]).doubleValue();
                d = (d - ((Number)objectArray2[0]).doubleValue()) / d3;
                if (d3 == 0.0) {
                    this.scrollInfo[0] = 0.0f;
                    this.scrollInfo[1] = 1.0f;
                    return;
                }
                d = d > 1.0 ? 1.0 : d;
                d = d < 0.0 ? 0.0 : d;
                this.scrollInfo[0] = 0.0f;
                this.scrollInfo[1] = (float)d;
                return;
            }
        }
    }

    @Override
    public void setTickSkipNum() {
        this.resetLabel = false;
        float f = 0.0f;
        if (this.skipTickN >= 1) {
            return;
        }
        if (!this.custommerConstant()) {
            float f2 = f = this.labels.size() > 1 ? this.length / (float)(this.labels.size() - 1) : this.length;
            if (f < this.minTickDis) {
                this.skipTickN = this.minTickDis / f > (float)((int)(this.minTickDis / f)) ? (int)(this.minTickDis / f) + 1 : (int)(this.minTickDis / f);
                this.skipTickN = this.skipTickN > this.labels.size() - 1 ? this.labels.size() - 1 : this.skipTickN;
            }
            this.drawMinorTick = !(this.minTickDis > f / 2.0f);
            List list = this.labels;
            if (this.skipTickN >= 1) {
                this.labels = new ArrayList();
                for (int i = 0; i < list.size(); i += this.skipTickN + 1) {
                    this.labels.add(list.get(i));
                }
            }
        } else {
            this.resetLabel = false;
            int n = this.labels.size();
            float f3 = (float)(this.tickmarkValue[this.tickmarkValue.length - 1] - this.tickmarkValue[0]);
            f3 = this.length * f3;
            float f4 = f = n > 1 ? f3 / (float)(n - 1) : f3;
            if (f < this.minTickDis) {
                int n2 = this.skipTickN = this.minTickDis / f > (float)((int)(this.minTickDis / f)) ? (int)(this.minTickDis / f) + 1 : (int)(this.minTickDis / f);
            }
            if (this.skipTickN > 1) {
                this.labels = this.orgCategory;
            }
        }
        if (this.skipTickN < 1) {
            return;
        }
        this.init();
    }

    public boolean showLastTickmark() {
        if (this.orgCategory != null && this.skipTickN >= 1) {
            return (this.orgCategory.size() + 1) % (this.skipTickN + 1) == 0;
        }
        return true;
    }

    @Override
    public int getTickSkipNum() {
        return this.skipTickN;
    }

    public List getLabelList() {
        return this.labels;
    }

    @Override
    public float getAxisTopMargin() {
        if (this.position == 1) {
            float f = 0.0f;
            f = this.getAxisWithTickLength();
            return f += (float)this.getMaxDimensionOfLabels().height;
        }
        boolean bl = this.isLineUnit();
        boolean bl2 = this.custommerConstant();
        if (!bl2) {
            if ((this.position == 2 || this.position == 4) && this.paintingLabels != null && this.paintingLabels.length > 0 && this.paintingLabels[this.paintingLabels.length - 1] != null && this.textStyle != null) {
                int n;
                ChartTextStyle chartTextStyle;
                double d = this.labelAutoRotate ? -0.5 : this.orignRotate;
                float f = 0.0f;
                if (this.position == 2 && d > 0.0) {
                    if (bl) {
                        chartTextStyle = (ChartTextStyle)this.paintingLabels[this.paintingLabels.length - 1].getChartTextStyle().clone();
                        f = (float)chartTextStyle.getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getHeight();
                    } else {
                        chartTextStyle = (ChartTextStyle)this.paintingLabels[this.paintingLabels.length - 1].getChartTextStyle().clone();
                        f = (float)chartTextStyle.getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getHeight();
                        n = this.paintingLabels.length;
                        n = this.skipTickN > 0 ? n * this.skipTickN : n;
                        f -= this.length / (float)n;
                    }
                }
                if (this.position == 4 && d < 0.0) {
                    if (bl) {
                        chartTextStyle = (ChartTextStyle)this.paintingLabels[this.paintingLabels.length - 1].getChartTextStyle().clone();
                        f = (float)chartTextStyle.getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getHeight();
                    } else {
                        chartTextStyle = (ChartTextStyle)this.paintingLabels[this.paintingLabels.length - 1].getChartTextStyle().clone();
                        f = (float)chartTextStyle.getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getHeight();
                        n = this.paintingLabels.length;
                        n = this.skipTickN > 0 ? n * this.skipTickN : n;
                        f -= this.length / (float)n;
                    }
                }
                return f;
            }
        } else if (bl2 && this.tickmarkValue != null && this.tickmarkValue.length > 0) {
            float f = 0.0f;
            if ((this.position == 2 || this.position == 4) && this.paintingLabels != null && this.paintingLabels.length > 0 && this.paintingLabels[this.paintingLabels.length - 1] != null) {
                boolean bl3;
                double d = this.labelAutoRotate ? -0.5 : this.orignRotate;
                boolean bl4 = bl3 = d > 0.0 && this.position == 2 || d < 0.0 && this.position == 4;
                if (bl3) {
                    ChartTextStyle chartTextStyle = (ChartTextStyle)this.paintingLabels[this.paintingLabels.length - 1].getChartTextStyle().clone();
                    f = (float)chartTextStyle.getDimension(this.paintingLabels[this.paintingLabels.length - 1].getLabelText()).getHeight();
                    return f;
                }
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public float getAxisBottomMargin() {
        if (this.position == 3) {
            float f = 0.0f;
            f = this.getAxisWithTickLength();
            return f += (float)this.getMaxDimensionOfLabels().height;
        }
        boolean bl = this.isLineUnit();
        boolean bl2 = this.custommerConstant();
        if (!bl2) {
            if ((this.position == 2 || this.position == 4) && this.paintingLabels != null && this.paintingLabels.length > 0 && this.paintingLabels[0] != null) {
                double d = this.labelAutoRotate ? -0.5 : this.orignRotate;
                boolean bl3 = d < 0.0 && this.position == 2 || d > 0.0 && this.position == 4;
                float f = 0.0f;
                if (bl3) {
                    if (bl) {
                        ChartTextStyle chartTextStyle = (ChartTextStyle)this.paintingLabels[0].getChartTextStyle().clone();
                        f = (float)chartTextStyle.getDimension(this.paintingLabels[0].getLabelText()).getHeight();
                    } else {
                        ChartTextStyle chartTextStyle = (ChartTextStyle)this.paintingLabels[0].getChartTextStyle().clone();
                        f = (float)chartTextStyle.getDimension(this.paintingLabels[0].getLabelText()).getHeight();
                        int n = this.paintingLabels.length;
                        n = this.skipTickN > 0 ? n * this.skipTickN : n;
                        f -= this.length / (float)n;
                    }
                }
                return f;
            }
            return 0.0f;
        }
        if (bl2 && this.tickmarkValue != null && this.tickmarkValue.length > 0) {
            float f = 0.0f;
            if ((this.position == 2 || this.position == 4) && this.paintingLabels != null && this.paintingLabels.length > 0 && this.paintingLabels[0] != null) {
                boolean bl4;
                double d = this.labelAutoRotate ? -0.5 : this.orignRotate;
                boolean bl5 = bl4 = d < 0.0 && this.position == 2 || d > 0.0 && this.position == 4;
                if (bl4) {
                    ChartTextStyle chartTextStyle = (ChartTextStyle)this.paintingLabels[0].getChartTextStyle().clone();
                    f = (float)chartTextStyle.getDimension(this.paintingLabels[0].getLabelText()).getHeight();
                    return f;
                }
            }
            return 0.0f;
        }
        return 0.0f;
    }
}

