/*
 * Decompiled with CFR 0.152.
 */
package chart.axis;

import chart.ChartLabelBase;
import chart.axis.ChartAxis;
import chart.axis.ChartNumericRadarAxis;
import chart.properties.ChartAxisProperties;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartMath;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class ChartNumericAxis
extends ChartAxis {
    private double IsLabelFontAutomaticOrientation;
    private double SEDU;
    private double abs;
    private int ceil;
    private float floor;
    private boolean format;
    private double getAxisIncrement;
    private double getChartTextStyle;
    private boolean getDigitalScale;
    private boolean getFilters;
    private boolean getLabelStartValue = false;
    private boolean getLabelText = false;
    private boolean getLabelTextStyle = false;
    private boolean[] getMax;
    private float getMaxValue;
    private boolean getMin = false;
    private boolean getMinValue = false;
    double rmin = 0.0;
    double rmax = 0.0;
    int rTickNum = 0;

    public ChartNumericAxis(ChartAxisProperties chartAxisProperties, double d, double d2) {
        super(chartAxisProperties);
        this.IsLabelFontAutomaticOrientation = d;
        this.SEDU = d2;
    }

    @Override
    public void init() {
        this.validInfinity();
        if (this.skipTickN >= 1) {
            int n = this.skipTickN;
            this.rmax = this.SEDU;
            this.rmin = this.IsLabelFontAutomaticOrientation;
            this.rTickNum = this.ceil;
        }
        this.IsLabelFontAutomaticOrientation();
        this.filter();
        super.init();
    }

    private void IsLabelFontAutomaticOrientation() {
        ChartNumericAxisProperties chartNumericAxisProperties = (ChartNumericAxisProperties)this.properties;
        this.floor = (float)chartNumericAxisProperties.getLabelStartValue();
        this.format = chartNumericAxisProperties.isUseLabelStartValue();
        this.getAxisIncrement = chartNumericAxisProperties.getMinValue();
        this.getChartTextStyle = chartNumericAxisProperties.getMaxValue();
        if (this.getAxisIncrement > this.getChartTextStyle) {
            this.getChartTextStyle = chartNumericAxisProperties.getMinValue();
            this.getAxisIncrement = chartNumericAxisProperties.getMaxValue();
        }
        this.getDigitalScale = this.getAxisIncrement == 0.0;
        this.getFilters = this.getChartTextStyle == 0.0;
        this.abs = chartNumericAxisProperties.getAxisIncrement();
        this.ceil = chartNumericAxisProperties.getNumOfTickMarks();
        if (this.filter != null && this.filter.isLogScale()) {
            this.abs = 1.0;
            this.ceil = -1;
            this.getAxisIncrement = this.getAxisIncrement > 0.0 ? ChartMath.log10(this.getAxisIncrement) : 0.0;
            double d = this.getChartTextStyle = this.getChartTextStyle > 0.0 ? ChartMath.log10(this.getChartTextStyle) : 0.0;
        }
        this.SEDU = this.getFilters ? (this.SEDU < 0.0 ? 0.0 : this.SEDU) : this.getChartTextStyle;
        this.IsLabelFontAutomaticOrientation = this.getDigitalScale ? (this.IsLabelFontAutomaticOrientation > 0.0 ? 0.0 : this.IsLabelFontAutomaticOrientation) : this.getAxisIncrement;
        if (Math.abs(this.SEDU - this.IsLabelFontAutomaticOrientation) < Double.MIN_VALUE) {
            if (Math.abs(this.IsLabelFontAutomaticOrientation) < Double.MIN_VALUE) {
                this.SEDU = this.IsLabelFontAutomaticOrientation + 100.0;
            } else {
                this.SEDU = Math.max(0.0, this.IsLabelFontAutomaticOrientation);
                this.IsLabelFontAutomaticOrientation = Math.min(0.0, this.IsLabelFontAutomaticOrientation);
            }
            this.getFilters = true;
            this.getDigitalScale = true;
        }
        if (this.skipTickN >= 1) {
            int n = this.skipTickN;
            this.ceil = this.rTickNum;
            this.SEDU = this.rmax;
            this.IsLabelFontAutomaticOrientation = this.rmin;
            this.abs = (this.SEDU - this.IsLabelFontAutomaticOrientation) / (double)this.ceil;
            this.abs *= (double)n;
            this.ceil = (int)Math.ceil((this.SEDU - this.IsLabelFontAutomaticOrientation) / this.abs);
            return;
        }
        if (this.ceil <= 0) {
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            if (this.abs <= 0.0 || this.abs > this.SEDU - this.IsLabelFontAutomaticOrientation) {
                this.abs = this.abs(this.IsLabelFontAutomaticOrientation, this.SEDU);
                bl = true;
            }
            if (this.IsLabelFontAutomaticOrientation < 0.0 && this.SEDU > 0.0) {
                double d;
                if (this.getDigitalScale) {
                    n = (int)Math.ceil(-this.IsLabelFontAutomaticOrientation / this.abs);
                    if (this.getLabelStartValue && ((d = -this.IsLabelFontAutomaticOrientation % this.abs) > this.abs * 9.0 / 10.0 || d == 0.0)) {
                        ++n;
                    }
                } else {
                    n = (int)Math.floor(-this.IsLabelFontAutomaticOrientation / this.abs);
                    if (-this.IsLabelFontAutomaticOrientation / this.abs % 1.0 > 0.99999) {
                        ++n;
                    }
                }
                this.IsLabelFontAutomaticOrientation = -this.abs * (double)n;
                if (this.getFilters) {
                    n2 = (int)Math.ceil(this.SEDU / this.abs);
                    if (this.getLabelStartValue && ((d = this.SEDU % this.abs) > this.abs * 9.0 / 10.0 || d == 0.0)) {
                        ++n2;
                    }
                } else {
                    n2 = (int)Math.floor(this.SEDU / this.abs);
                    if (this.SEDU / this.abs % 1.0 > 0.99999) {
                        ++n2;
                    }
                }
                this.SEDU = this.abs * (double)n2;
                this.ceil = n + n2;
            } else if (this.SEDU <= 0.0) {
                if (this.getDigitalScale) {
                    double d;
                    this.ceil = (int)Math.ceil((this.SEDU - this.IsLabelFontAutomaticOrientation) / this.abs);
                    if (this.getLabelStartValue && ((d = (this.SEDU - this.IsLabelFontAutomaticOrientation) % this.abs) > this.abs * 9.0 / 10.0 || d == 0.0) && this.ceil < Integer.MAX_VALUE && !this.getLabelText) {
                        ++this.ceil;
                    }
                } else {
                    this.ceil = (int)Math.floor((this.SEDU - this.IsLabelFontAutomaticOrientation) / this.abs);
                    if ((this.SEDU - this.IsLabelFontAutomaticOrientation) / this.abs % 1.0 > 0.99999 && this.ceil < Integer.MAX_VALUE) {
                        ++this.ceil;
                    }
                }
                if (this instanceof ChartNumericRadarAxis) {
                    this.ceil -= this.ceil / 2;
                }
                this.IsLabelFontAutomaticOrientation = this.SEDU - this.abs * (double)this.ceil;
                if (this.getDigitalScale) {
                    this.SEDU += this.abs;
                    if (this.ceil < Integer.MAX_VALUE) {
                        ++this.ceil;
                    }
                }
            } else if (this.IsLabelFontAutomaticOrientation >= 0.0) {
                if (this.getFilters) {
                    double d;
                    this.ceil = (int)Math.ceil((this.SEDU - this.IsLabelFontAutomaticOrientation) / this.abs);
                    if (this.getLabelStartValue && ((d = (this.SEDU - this.IsLabelFontAutomaticOrientation) % this.abs) > this.abs * 9.0 / 10.0 || d == 0.0) && this.ceil < Integer.MAX_VALUE && !this.getLabelText) {
                        ++this.ceil;
                    }
                    this.SEDU = this.IsLabelFontAutomaticOrientation + this.abs * (double)this.ceil;
                    if (this instanceof ChartNumericRadarAxis) {
                        if (this.ceil % 2 == 0) {
                            this.ceil -= this.ceil / 2;
                            this.abs *= 2.0;
                        } else {
                            this.SEDU += this.abs;
                            this.ceil = (this.ceil + 1) / 2;
                            this.abs = (this.SEDU - this.IsLabelFontAutomaticOrientation) / (double)this.ceil;
                        }
                    }
                } else {
                    this.ceil = (int)Math.floor((this.SEDU - this.IsLabelFontAutomaticOrientation) / this.abs);
                    if (this.ceil == 0) {
                        this.ceil = 2;
                        this.abs = this.SEDU;
                    }
                    if ((this.SEDU - this.IsLabelFontAutomaticOrientation) / this.abs % 1.0 > 0.99999 && this.ceil < Integer.MAX_VALUE) {
                        ++this.ceil;
                    }
                    this.SEDU = this.IsLabelFontAutomaticOrientation + this.abs * (double)this.ceil;
                }
            }
            if (this.getLabelTextStyle && this.SEDU - this.IsLabelFontAutomaticOrientation < 4.0 && this.abs - 1.0 < Double.MIN_VALUE && bl) {
                if (this.getDigitalScale && this.getFilters) {
                    this.ceil = 4;
                    this.SEDU = Math.ceil(this.IsLabelFontAutomaticOrientation) + (double)this.ceil;
                } else if (this.SEDU - this.IsLabelFontAutomaticOrientation > 2.0) {
                    this.ceil = (int)Math.floor(this.SEDU - this.IsLabelFontAutomaticOrientation);
                    this.IsLabelFontAutomaticOrientation = Math.ceil(this.IsLabelFontAutomaticOrientation);
                }
            }
        } else {
            if (this.IsLabelFontAutomaticOrientation < 0.0 && this.SEDU > 0.0) {
                this.SEDU = this.getFilters ? this.ceil(this.SEDU, true) : this.SEDU;
                this.IsLabelFontAutomaticOrientation = this.getDigitalScale ? this.ceil(this.IsLabelFontAutomaticOrientation, true) : this.IsLabelFontAutomaticOrientation;
            } else if (this.IsLabelFontAutomaticOrientation >= 0.0) {
                this.SEDU = this.getFilters ? this.ceil(this.SEDU, true) : this.SEDU;
                this.IsLabelFontAutomaticOrientation = this.getDigitalScale ? this.ceil(this.IsLabelFontAutomaticOrientation, false) : this.IsLabelFontAutomaticOrientation;
            } else if (this.SEDU <= 0.0) {
                this.SEDU = this.getFilters ? this.ceil(this.SEDU, false) : this.SEDU;
                this.IsLabelFontAutomaticOrientation = this.getDigitalScale ? this.ceil(this.IsLabelFontAutomaticOrientation, true) : this.IsLabelFontAutomaticOrientation;
            }
            this.abs = (this.SEDU - this.IsLabelFontAutomaticOrientation) / (double)this.ceil;
        }
        this.validInfinity();
        if (this.getMinValue || this.getMin) {
            this.SEDU();
            return;
        }
    }

    private void SEDU() {
        this.IsLabelFontAutomaticOrientation = -3.4028234663852886E38;
        this.SEDU = 3.4028234663852886E38;
        this.ceil = 3;
        this.abs = 3.4028234663852886E38;
    }

    private double abs(double d, double d2) {
        double d3;
        double d4 = 1.0;
        double d5 = 2.0;
        double d6 = 5.0;
        double d7 = d2 - d;
        if (Math.abs(d7) < Double.MIN_VALUE) {
            d7 = 100.0;
        }
        if (d7 > Double.MAX_VALUE) {
            d7 = Double.MAX_VALUE;
        }
        if (d7 > 5.0) {
            while (d7 >= d4 * 8.0) {
                d4 *= 10.0;
            }
            while (d7 >= d5 * 8.0) {
                d5 *= 10.0;
            }
            while (d7 >= d6 * 8.0) {
                d6 *= 10.0;
            }
            d3 = d4;
            d3 = d3 < d5 ? d3 : d5;
            d3 = d3 < d6 ? d3 : d6;
        } else {
            while (d7 <= d4 * 3.99999) {
                d4 /= 10.0;
            }
            while (d7 <= d5 * 3.99999) {
                d5 /= 10.0;
            }
            while (d7 <= d6 * 3.99999) {
                d6 /= 10.0;
            }
            d3 = d4;
            d3 = d3 > d5 ? d3 : d5;
            double d8 = d3 = d3 > d6 ? d3 : d6;
        }
        if (this.getLabelTextStyle && d2 - d < 4.0) {
            if (this.getDigitalScale || this.getFilters) {
                d3 = 1.0;
            } else if (d2 - d > 2.0) {
                d3 = 1.0;
            }
        }
        return d3;
    }

    private double ceil(double d, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        if (d < 0.0) {
            d = Math.abs(d);
            bl3 = true;
        }
        boolean bl4 = bl2 = d >= 1.0;
        if (d != 0.0) {
            int n = 0;
            while (bl2 ? d >= 10.0 : d < 1.0) {
                d *= bl2 ? (double)0.1f : 10.0;
                ++n;
            }
            int n2 = (int)Math.round(d);
            if (d > (double)n2) {
                d = bl ? (double)((float)n2 + 1.0f) : (double)n2;
            } else if (d < (double)n2) {
                d = bl ? (double)n2 : (double)((float)n2 - 1.0f);
            }
            d *= Math.pow(bl2 ? 10.0f : 0.1f, n);
        }
        return bl3 ? -d : d;
    }

    private void filter() {
        if (this.ceil >= 100) {
            this.ceil = 100;
            this.abs = (this.SEDU - this.IsLabelFontAutomaticOrientation) / (double)this.ceil;
        }
        if (this.ceil == 0) {
            this.paintingLabels = null;
            return;
        }
        ChartNumericAxisProperties chartNumericAxisProperties = (ChartNumericAxisProperties)this.properties;
        this.paintingLabels = new ChartLabelBase[this.ceil + 1];
        double d = 0.0;
        this.getMax = new boolean[2];
        DecimalFormat decimalFormat = new DecimalFormat();
        if (this.getMin || this.getMinValue) {
            this.paintingLabels = new ChartLabelBase[this.ceil + 1];
            for (int i = 0; i <= this.ceil; ++i) {
                String string;
                if (i == 0) {
                    this.getMaxValue = (float)d;
                    string = "-Infinity";
                } else {
                    string = i == 1 ? (this.filter != null && this.filter.getFilters().size() != 0 ? this.filter.filter(new Double(0.0), i) : String.valueOf(decimalFormat.format(0L))) : "Infinity";
                }
                this.paintingLabels[i] = new ChartLabelBase(string);
                this.paintingLabels[i].setChartTextStyle(chartNumericAxisProperties.getLabelTextStyle());
                if (this.getDigitalScale && this.getFilters) continue;
                if (i == 0) {
                    boolean bl = this.getMax[0] = d != this.getAxisIncrement;
                }
                if (i != this.ceil) continue;
                this.getMax[1] = d != this.getChartTextStyle;
            }
        } else {
            for (int i = 0; i <= this.ceil; ++i) {
                String string;
                d = this.IsLabelFontAutomaticOrientation + (double)i * this.abs;
                if (this.filter != null && this.filter.getFilters().size() != 0) {
                    string = this.filter.filter(new Double(d), i);
                } else {
                    decimalFormat.setMinimumFractionDigits(this.getDigitalScale(d));
                    string = String.valueOf(decimalFormat.format(d));
                }
                this.paintingLabels[i] = new ChartLabelBase(string);
                this.paintingLabels[i].setChartTextStyle(chartNumericAxisProperties.getLabelTextStyle());
                if (this.format && (float)d < this.floor) {
                    this.paintingLabels[i].setLabelText("");
                }
                if (i == 0) {
                    this.getMaxValue = (float)d;
                }
                if (this.getDigitalScale && this.getFilters) continue;
                if (i == 0) {
                    this.getMax[0] = ChartMath.isEquals(d, this.getAxisIncrement);
                }
                if (i != this.ceil) continue;
                this.getMax[1] = ChartMath.isEquals(d, this.getChartTextStyle);
            }
        }
    }

    int getDigitalScale(double d) {
        int n;
        double d2 = d - (double)((long)d);
        if (d2 == 0.0) {
            return 0;
        }
        d2 = Math.round(d2 * 1000000.0);
        for (n = 7; n >= 0 && ChartMath.isEquals(d2, (double)((long)d2)) && !ChartMath.isEquals(0.0, d2); --n) {
            d2 /= 10.0;
        }
        return n;
    }

    void validInfinity() {
        this.getMin = this.IsLabelFontAutomaticOrientation <= -3.4028234663852886E38;
        this.getMinValue = this.SEDU >= 3.4028234663852886E38;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
    }

    public double getMax() {
        return this.getFilters ? this.SEDU : this.getChartTextStyle;
    }

    public double getMin() {
        return this.getDigitalScale ? this.IsLabelFontAutomaticOrientation : this.getAxisIncrement;
    }

    public double getLabelStartValue() {
        return this.IsLabelFontAutomaticOrientation;
    }

    public double getLabelEndValue() {
        return this.SEDU;
    }

    public double getTickPace() {
        return this.abs;
    }

    public int getNumOfTick() {
        return this.ceil;
    }

    @Override
    public float getZeroPosition(float f) {
        float f2 = this.getUnit(f);
        double d = this.getMin() * (double)f2;
        return -((float)d);
    }

    @Override
    public float getUnit(float f) {
        double d = (double)f / (this.getMax() - this.getMin());
        return (float)Math.abs(d);
    }

    public boolean isAutoExpand() {
        return this.getLabelStartValue;
    }

    public void setAutoExpand(boolean bl) {
        this.getLabelStartValue = bl;
    }

    @Override
    public float[][] getLabelsPosition() {
        return null;
    }

    public void setIsBubble(boolean bl) {
        this.getLabelText = bl;
    }

    public boolean[] surfacePatternIncrea() {
        return this.getMax;
    }

    public float getFristLabel() {
        return this.getMaxValue;
    }

    public void setIntegerIncrement(boolean bl) {
        this.getLabelTextStyle = bl;
    }

    public boolean isIntegerIncrement() {
        return this.getLabelTextStyle;
    }

    @Override
    public void locate() {
        super.locate();
    }

    @Override
    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public String[] getLabelsForHtml() {
        String[] stringArray = null;
        if (this.paintingLabels != null && this.paintingLabels.length > 0) {
            int n = this.paintingLabels.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = this.paintingLabels[i].getLabelText();
            }
        }
        return stringArray;
    }

    @Override
    public float getLabelUnit(float f) {
        float f2 = f;
        if (this.ceil > 0) {
            if (this.ceil == 1) {
                return f2;
            }
            f2 /= (float)(this.ceil - 1);
        }
        return f2;
    }

    @Override
    public boolean getAutoOritention(float f) {
        if (this.properties.IsLabelFontAutomaticOrientation()) {
            boolean bl = false;
            float f2 = 0.0f;
            for (int i = 0; i < this.paintingLabelsLength; ++i) {
                Rectangle2D rectangle2D = !this.initedLabelStyle ? this.textStyle.getZeroRotationDimension(this.paintingLabels[i].getLabelText()) : this.paintingLabels[i].getChartTextStyle().getZeroRotationDimension(this.paintingLabels[i].getLabelText());
                f2 = (float)rectangle2D.getWidth();
                if (!(f2 > f)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return false;
    }

    @Override
    public void setTickSkipNum() {
        float f = 0.0f;
        if (this.skipTickN >= 1) {
            return;
        }
        if (this.ceil >= 2) {
            f = this.length / (float)(this.ceil - 1);
            if (f < this.minTickDis) {
                int n = this.skipTickN = this.minTickDis / f > (float)((int)(this.minTickDis / f)) ? (int)(this.minTickDis / f) + 1 : (int)(this.minTickDis / f);
            }
            if (this.skipTickN < 1) {
                return;
            }
            this.init();
        }
    }

    @Override
    public int getTickSkipNum() {
        return this.skipTickN;
    }
}

