/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

public class Chart2DMatrix {
    float xx = 1.0f;
    float xy;
    float xo;
    float yx;
    float yy = 1.0f;
    float yo;
    float hx;
    float hy;
    float hh = 1.0f;

    public void shift(float f, float f2) {
        this.xo += f;
        this.yo += f2;
    }

    public void scale(float f, float f2) {
        this.xx *= f;
        this.xy *= f;
        this.xo *= f;
        this.yx *= f2;
        this.yy *= f2;
        this.yo *= f2;
    }

    public void rotate(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.yx * f + this.xx * f2;
        float f4 = this.yy * f + this.xy * f2;
        float f5 = this.yo * f + this.xo * f2;
        float f6 = this.xx * f - this.yx * f2;
        float f7 = this.xy * f - this.yy * f2;
        float f8 = this.xo * f - this.yo * f2;
        this.yo = f5;
        this.yx = f3;
        this.yy = f4;
        this.xo = f8;
        this.xx = f6;
        this.xy = f7;
    }

    public void compositeTransformation(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        f5 = (float)((double)f5 * (Math.PI / 180));
        float f8 = (float)Math.cos(f5);
        float f9 = (float)Math.sin(f5);
        this.xx = f3 * f8;
        this.xy = -f4 * f9;
        this.xo = f6 * (1.0f - f3 * f8) + f7 * f4 * f9 + f;
        this.yx = f3 * f9;
        this.yy = f4 * f8;
        this.yo = f7 * (1.0f - f4 * f8) + f6 * f3 * f9 + f2;
    }

    public void mul(Chart2DMatrix chart2DMatrix) {
        float f = this.xx * chart2DMatrix.xx + this.yx * chart2DMatrix.xy;
        float f2 = this.xy * chart2DMatrix.xx + this.yy * chart2DMatrix.xy;
        float f3 = this.xo * chart2DMatrix.xx + this.yo * chart2DMatrix.xy + chart2DMatrix.xo;
        float f4 = this.xx * chart2DMatrix.yx + this.yx * chart2DMatrix.yy;
        float f5 = this.xy * chart2DMatrix.yx + this.yy * chart2DMatrix.yy;
        float f6 = this.xo * chart2DMatrix.yx + this.yo * chart2DMatrix.yy + chart2DMatrix.yo;
        this.xx = f;
        this.xy = f2;
        this.xo = f3;
        this.yx = f4;
        this.yy = f5;
        this.yo = f6;
    }

    public void bench1() {
        this.xx = 0.0f;
        this.xy = 1.0f;
        this.xo = 0.0f;
        this.yx = -1.0f;
        this.yy = 0.0f;
        this.yo = 0.0f;
        this.hx = 0.0f;
        this.hy = 0.0f;
        this.hh = 1.0f;
    }

    public void bench2() {
        this.xx = 0.0f;
        this.xy = -1.0f;
        this.xo = 0.0f;
        this.yx = 1.0f;
        this.yy = 0.0f;
        this.yo = 0.0f;
        this.hx = 0.0f;
        this.hy = 0.0f;
        this.hh = 1.0f;
    }

    public void xmirror() {
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xo = 0.0f;
        this.yx = 0.0f;
        this.yy = -1.0f;
        this.yo = 0.0f;
        this.hx = 0.0f;
        this.hy = 0.0f;
        this.hh = 1.0f;
    }

    public void unit() {
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xo = 0.0f;
        this.yx = 0.0f;
        this.yy = 1.0f;
        this.yo = 0.0f;
        this.hx = 0.0f;
        this.hy = 0.0f;
        this.hh = 1.0f;
    }

    public void transform(float[][] fArray2, float[][] fArray3) {
        if (fArray3.length < fArray2.length) {
            fArray3 = new float[fArray2.length][2];
        }
        for (int i = 0; i < fArray2.length; ++i) {
            float f = fArray2[i][0] * this.xx + fArray2[i][1] * this.xy + this.xo;
            float f2 = fArray2[i][0] * this.yx + fArray2[i][1] * this.yy + this.yo;
            fArray3[i][0] = f;
            fArray3[i][1] = f2;
        }
    }
}

