/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartCoordinatePaper;
import chart.ChartDefinition;
import chart.ChartEnv;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.ChartRenderInfo;
import chart.ChartWall;
import chart.GridLine;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.axis.ChartNumericRadarAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPieLayer;
import chart.chart2d.Chart2DRadarLayer;
import chart.chart2d.Chart2DSimplePaper;
import chart.chart2d.Graph2DAreaA;
import chart.chart2d.Graph2DAreaP;
import chart.chart2d.Graph2DAreaSt;
import chart.chart2d.Graph2DBar;
import chart.chart2d.Graph2DBarP;
import chart.chart2d.Graph2DBarSi;
import chart.chart2d.Graph2DBarSt;
import chart.chart2d.Graph2DBubble;
import chart.chart2d.Graph2DBullet;
import chart.chart2d.Graph2DGuageBalls;
import chart.chart2d.Graph2DGuageBars;
import chart.chart2d.Graph2DGuageDials;
import chart.chart2d.Graph2DJoint;
import chart.chart2d.Graph2DLED;
import chart.chart2d.Graph2DLine;
import chart.chart2d.Graph2DLineA;
import chart.chart2d.Graph2DLineP;
import chart.chart2d.Graph2DLineSt;
import chart.chart2d.Graph2DMeanLine;
import chart.chart2d.Graph2DPie;
import chart.chart2d.Graph2DRadar;
import chart.chart2d.Graph2DScatterL;
import chart.chart2d.Graph2DScatterN;
import chart.chart2d.Graph2DScatterS;
import chart.chart2d.Graph2DStockHLC;
import chart.chart2d.Graph2DStockOC;
import chart.chart2d.Graph2DStockOHLC;
import chart.data.Chart1DDataSet;
import chart.data.Chart2DDataSet;
import chart.data.Chart3DDataSet;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartDataUsedInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartShadow;
import chart.properties.ChartCoordinatePaperProperties;
import chart.util.ChartRenderTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class Chart2DPaper
extends ChartCoordinatePaper {
    public static final int GRAPH_POSITION_AUTO = 0;
    public static final int GRAPH_POSITION_KEEPCENTER = 1;
    ChartPlatform platform;
    public ChartDataSetModel model;
    List datasets;
    ChartAxis axisX1;
    ChartAxis axisX2;
    ChartAxis axisY1;
    ChartAxis axisY2;
    protected ChartWall wall = null;
    protected GridLine gridX1 = null;
    protected GridLine gridY1 = null;
    protected GridLine gridX2 = null;
    protected GridLine gridY2 = null;
    protected GridLine gridZ = null;
    Chart2DLayer primLayer;
    Chart2DLayer secLayer;
    Chart2DLayer wallLayer;
    Chart2DObject[] charts;
    Chart2DObject[] meanLines;
    protected Rectangle graphArea;
    private ChartAxis D = null;
    private ChartAxis IsLabelFontAutomaticOrientation = null;
    private ChartAxis IsShowAxisYLabelTips = null;
    private ChartAxis IsShowLabelTips = null;
    private float OLD_PAPER_MARGINE;
    private int[] PLATFORM_PAPER_MARGINE;
    private String SEDU = null;
    private List add;
    private List after;
    private ChartRenderInfo allIsIntegerData;
    private int allLineArea = -1;
    private BufferedImage append = null;
    private int axisX = 0;
    private boolean axisY = false;
    int[] constantIndex;
    String[] valuesName;
    private int before = 0;
    private int black = 0;
    public Vector lineChartSizeInfo;
    public int lineChartStartIndex = 0;
    public int selectedLineIndex = -1;
    public int[] selectedBulletIndex;
    private boolean calculateAxisPlot = true;
    private boolean calculateGraphArea = false;
    private boolean calculateMinMax = false;
    private boolean calculatePercentMinMaxPercentOfCategory = false;
    private Chart2DObject clone = null;
    private boolean contains;
    private boolean convertUnitToPixel;
    private boolean createGraphics = false;
    private boolean custommerConstant = false;

    public Chart2DPaper(ChartPlatform chartPlatform, ChartCoordinatePaperProperties chartCoordinatePaperProperties) {
        this.platform = chartPlatform;
        this.properties = chartCoordinatePaperProperties;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        this.background = this.properties.getBackground();
        super.paint(graphics2D);
        if (this.wallLayer != null) {
            this.wallLayer.paintWall(graphics2D, this.wall);
        }
        if (this.append != null) {
            this.D(graphics2D);
            ChartShadow.drawShadow(graphics2D, this.append, 3, 2);
        }
        if (this.primLayer != null) {
            this.primLayer.paintGrid(graphics2D);
        }
        if (this.secLayer != null) {
            this.secLayer.paintGrid(graphics2D);
        }
        if (this.clone != null) {
            this.clone.paint(graphics2D);
        }
        if (this.properties.isReversePaintingOrder()) {
            for (n = this.charts.length - 1; n >= 0; --n) {
                if (this.createGraphics && n != this.charts.length - 1) continue;
                this.charts[n].paint(graphics2D);
            }
            if (this.primLayer != null) {
                this.primLayer.paintAxis(graphics2D);
            }
            if (this.secLayer != null) {
                this.secLayer.paintAxis(graphics2D);
            }
        } else {
            for (n = 0; n < this.charts.length; ++n) {
                if (this.createGraphics && n != this.charts.length - 1) continue;
                this.charts[n].paint(graphics2D);
            }
            if (this.primLayer != null) {
                this.primLayer.paintAxis(graphics2D);
            }
            if (this.secLayer != null) {
                this.secLayer.paintAxis(graphics2D);
            }
        }
        n = 0;
        if (this.axisX1 != null && this.axisX1.custommerConstant()) {
            n = 1;
        }
        if (this.append() && n == 0) {
            if (this.meanLines != null && this.properties.getGraphProperties().isShowMeanLine()) {
                for (int i = 0; i < this.meanLines.length; ++i) {
                    if (this.meanLines[i] == null) continue;
                    this.meanLines[i].paint(graphics2D);
                }
            }
            if (this.wallLayer != null) {
                this.wallLayer.paintThresholdLine(graphics2D);
            }
        }
        this.allIsIntegerData(graphics2D);
        super.paintBorder(graphics2D);
    }

    private void D(Graphics2D graphics2D) {
        int n;
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (this.properties.isReversePaintingOrder()) {
            for (n = this.charts.length - 1; n >= 0; --n) {
                for (int i = 0; i < this.model.getSeriesCount(); ++i) {
                    generalPath.append(this.charts[n].getShapeBySeries(i), false);
                }
            }
        } else {
            for (n = 0; n < this.charts.length; ++n) {
                for (int i = 0; i < this.model.getSeriesCount(); ++i) {
                    generalPath.append(this.charts[n].getShapeBySeries(i), false);
                }
            }
        }
        Graphics2D graphics2D2 = this.append.createGraphics();
        graphics2D2.setColor(new Color(0.0f, 0.0f, 0.0f, 0.55f));
        graphics2D2.fill(generalPath);
        graphics2D2.draw(generalPath);
    }

    void initScrollChart() {
        this.calculateMinMax = this.platform.isSupportScrollChart() && !(this instanceof Chart2DSimplePaper) && this instanceof Chart2DPaper;
        this.calculateMinMax = this.calculateMinMax && this.platform.getScrollbarInfo() != null;
    }

    @Override
    public void init() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.model = this.platform.getDataSetModel();
        this.datasets = this.model.getChartDataSets();
        this.valuesName = this.model.getValuesName();
        this.initScrollChart();
        ChartDataSet chartDataSet = null;
        this.add = new ArrayList();
        this.after = new ArrayList();
        boolean bl = false;
        this.contains = false;
        for (int i = 0; i < this.datasets.size(); ++i) {
            chartDataSet = (ChartDataSet)this.datasets.get(i);
            switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                case 0: {
                    this.add.add(chartDataSet);
                    break;
                }
                case 1: {
                    this.after.add(chartDataSet);
                }
            }
            if (chartDataSet instanceof Chart3DDataSet) {
                this.axisY = ((Chart3DDataSet)chartDataSet).isUseCategoryAsX();
            }
            if (ChartTypeInfo.getPrimType(((ChartDataSet)this.datasets.get(i)).getChartDataSetInfo().getChartType()) != 1) continue;
            this.contains = true;
        }
        if (this.axisY) {
            boolean bl2 = this.axisY = !this.platform.getChartDefinition().isComboChart();
        }
        if (this.isScrollChart() && this.getProperties().getAxisYProperties().isAutoScaleYAxis() && this.getProperties().getAxisXProperties().getScrollableChart()) {
            int[] nArray = new int[]{this.platform.showScrollLabelStart(), this.platform.showScrollLabelEnd()};
            if (this.constantIndex != null) {
                chartDataSet.setScrollIndex(this.constantIndex);
            } else {
                chartDataSet.setScrollIndex(nArray);
            }
            if (chartDataSet instanceof Chart1DDataSet) {
                ((Chart1DDataSet)chartDataSet).calculateMinMax();
            }
        }
        this.IsLabelFontAutomaticOrientation();
        this.IsShowLabelTips();
        this.setConstantFilterName();
        Chart2DLayer chart2DLayer = null;
        if (this.model.getMotionChartGroupNames() == null) {
            this.charts = new Chart2DObject[this.datasets.size()];
            this.axisX = 0;
            if (this.properties.isReversePaintingOrder()) {
                for (n5 = this.charts.length - 1; n5 >= 0; --n5) {
                    chartDataSet = (ChartDataSet)this.datasets.get(n5);
                    if (this.platform.getChartDefinition().supportRealtimeChart()) {
                        // empty if block
                    }
                    switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                        case 0: {
                            chart2DLayer = this.primLayer;
                            ++this.axisX;
                            break;
                        }
                        case 1: {
                            chart2DLayer = this.secLayer;
                            ++this.axisX;
                        }
                    }
                    this.charts[n5] = this.PLATFORM_PAPER_MARGINE(chartDataSet, chart2DLayer, this.axisX);
                    if (ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType()) != 10) {
                        this.lineChartStartIndex += chartDataSet.getSeriesSize();
                    }
                    this.charts[n5].setChartFillPatters(this.platform.getFillPatternByArarry(n5));
                }
            } else {
                for (n5 = 0; n5 < this.charts.length; ++n5) {
                    chartDataSet = (ChartDataSet)this.datasets.get(n5);
                    if (this.platform.getChartDefinition().supportRealtimeChart()) {
                        // empty if block
                    }
                    switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                        case 0: {
                            chart2DLayer = this.primLayer;
                            ++this.axisX;
                            break;
                        }
                        case 1: {
                            chart2DLayer = this.secLayer;
                            ++this.axisX;
                        }
                    }
                    this.charts[n5] = this.PLATFORM_PAPER_MARGINE(chartDataSet, chart2DLayer, this.axisX);
                    if (ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType()) != 10) {
                        this.lineChartStartIndex += chartDataSet.getSeriesSize();
                    }
                    this.charts[n5].setChartFillPatters(this.platform.getFillPatternByArarry(n5));
                }
            }
            for (n5 = 0; n5 < this.charts.length; ++n5) {
                this.charts[n5].setDataSetIndex(n5);
            }
        } else {
            chartDataSet = (ChartDataSet)this.datasets.get(0);
            n5 = chartDataSet.getChartDataSetInfo().getChartType();
            n4 = ChartTypeInfo.getPrimType(n5);
            n3 = ChartTypeInfo.getSubType(n5);
            if (n4 == 9 && this.model.getShowMotionHistory()) {
                bl = true;
                this.createGraphics = this.properties.getGraphProperties().getShowMotionLine() && !this.properties.getGraphProperties().getShowMotionBubble();
                n2 = this.model.getMotionFieldIndex();
                this.charts = new Chart2DObject[n2 + 1];
                for (n = 0; n <= n2; ++n) {
                    chartDataSet = (ChartDataSet)this.datasets.get(n);
                    if (this.platform.getChartDefinition().supportRealtimeChart()) {
                        // empty if block
                    }
                    switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                        case 0: {
                            chart2DLayer = this.primLayer;
                            ++this.axisX;
                            break;
                        }
                        case 1: {
                            chart2DLayer = this.secLayer;
                            ++this.axisX;
                        }
                    }
                    this.charts[n] = this.PLATFORM_PAPER_MARGINE(chartDataSet, chart2DLayer, this.axisX);
                    if (ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType()) != 10) {
                        this.lineChartStartIndex += chartDataSet.getSeriesSize();
                    }
                    this.charts[n].setChartFillPatters(this.platform.getFillPatternByArarry(n));
                }
            } else if (n4 == 0 || n4 == 9) {
                this.charts = new Chart2DObject[1];
                chartDataSet = (ChartDataSet)this.datasets.get(0);
                if (this.platform.getChartDefinition().supportRealtimeChart()) {
                    // empty if block
                }
                switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                    case 0: {
                        chart2DLayer = this.primLayer;
                        ++this.axisX;
                        break;
                    }
                    case 1: {
                        chart2DLayer = this.secLayer;
                        ++this.axisX;
                    }
                }
                this.charts[0] = this.PLATFORM_PAPER_MARGINE(chartDataSet, chart2DLayer, this.axisX);
                if (ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType()) != 10) {
                    this.lineChartStartIndex += chartDataSet.getSeriesSize();
                }
                this.charts[0].setChartFillPatters(this.platform.getFillPatternByArarry(0));
                if (this.getProperties().getGraphProperties().getShowMotionBubble() && n4 == 9) {
                    bl = true;
                }
            } else {
                this.charts = new Chart2DObject[1];
                chartDataSet = (ChartDataSet)this.datasets.get(0);
                if (this.platform.getChartDefinition().supportRealtimeChart()) {
                    // empty if block
                }
                switch (chartDataSet.getChartDataSetInfo().getAxisInfo()) {
                    case 0: {
                        chart2DLayer = this.primLayer;
                        ++this.axisX;
                        break;
                    }
                    case 1: {
                        chart2DLayer = this.secLayer;
                        ++this.axisX;
                    }
                }
                this.charts[0] = this.PLATFORM_PAPER_MARGINE(chartDataSet, chart2DLayer, this.axisX);
                if (ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType()) != 10) {
                    this.lineChartStartIndex += chartDataSet.getSeriesSize();
                }
                this.charts[0].setChartFillPatters(this.platform.getFillPatternByArarry(0));
            }
            if (this.charts != null && this.charts.length > 0) {
                this.charts[0].setDataSetIndex(0);
            }
        }
        if (this.properties.getGraphProperties().isShowMeanLine()) {
            n5 = 1;
            if (this.model.getMotionChartGroupNames() == null) {
                n5 = Math.min(this.charts.length, this.datasets.size());
            }
            this.meanLines = new Chart2DObject[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                chartDataSet = (ChartDataSet)this.datasets.get(n4);
                n3 = chartDataSet.getChartDataSetInfo().getChartType();
                n2 = ChartTypeInfo.getPrimType(n3);
                int n6 = n = chartDataSet.getChartDataSetInfo().getAxisInfo() == 1 ? 1 : 0;
                if (n2 != 3 && n2 != 0 && n2 != 1 && n2 != 2) continue;
                float f = 0.0f;
                f = n5 > 1 || n2 == 0 || n2 == 1 ? 0.5f : 0.0f;
                boolean bl3 = false;
                if (n2 == 1) {
                    bl3 = true;
                }
                this.meanLines[n4] = n != 0 ? new Graph2DMeanLine(chartDataSet, this, this.secLayer, bl3, false, f) : new Graph2DMeanLine(chartDataSet, this, this.primLayer, bl3, true, f);
            }
        }
        this.axisX();
        if (this.model.getMotionChartGroupNames() != null && bl && this.getProperties().getGraphProperties().getShowMotionLine()) {
            this.clone = new Graph2DJoint((ChartDataSet)this.datasets.get(0), this, chart2DLayer);
            this.clone.setChartFillPatters(this.platform.getFillPatternByArarry(0));
            ((Graph2DJoint)this.clone).setDrawLine(true);
            ((Graph2DBubble)this.charts[this.charts.length - 1]).setIsDarkFill(true);
        }
    }

    private void IsLabelFontAutomaticOrientation() {
        this.allIsIntegerData = new ChartRenderInfo();
        ChartDefinition chartDefinition = this.platform.getChartDefinition();
        chartDefinition.getCoordinateInfo(this.allIsIntegerData);
        this.IsShowAxisYLabelTips(this.allIsIntegerData, this.allIsIntegerData.primLayer, this.add, false);
        this.IsShowAxisYLabelTips(this.allIsIntegerData, this.allIsIntegerData.secLayer, this.after, true);
        if (this.allIsIntegerData.primLayer != null) {
            this.allIsIntegerData.primLayer.depthEnable = this.calculateAxisPlot;
        }
        if (this.allIsIntegerData.secLayer != null) {
            this.allIsIntegerData.secLayer.depthEnable = this.calculateAxisPlot;
        }
        this.allIsIntegerData.xAxisLineUnit = this.allIsIntegerData.primLayer != null && this.allIsIntegerData.secLayer == null && this.allIsIntegerData.primLayer.allLineArea || this.allIsIntegerData.secLayer != null && this.allIsIntegerData.primLayer == null && this.allIsIntegerData.secLayer.allLineArea;
    }

    private void IsShowAxisYLabelTips(ChartRenderInfo chartRenderInfo, ChartRenderInfo.ChartLayerRenderInfo chartLayerRenderInfo, List list, boolean bl) {
        ChartDataSet chartDataSet = null;
        boolean bl2 = false;
        double d = chartRenderInfo.xMin;
        double d2 = chartRenderInfo.xMax;
        if (chartLayerRenderInfo != null) {
            int n;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            boolean bl6 = true;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            block16: for (n = 0; n < list.size(); ++n) {
                chartDataSet = (ChartDataSet)list.get(n);
                if (bl3 && !chartDataSet.isIntegerData()) {
                    bl3 = false;
                }
                int n2 = chartDataSet.getChartDataSetInfo().getChartType();
                int n3 = ChartTypeInfo.getPrimType(n2);
                int n4 = ChartTypeInfo.getSubType(n2);
                int n5 = ChartTypeInfo.getSeriesType(n2);
                switch (n3) {
                    case 0: {
                        bl5 = false;
                        bl6 = false;
                        bl2 = true;
                        break;
                    }
                    case 1: {
                        bl4 = false;
                        bl6 = false;
                        bl2 = true;
                        break;
                    }
                    case 2: 
                    case 3: {
                        bl4 = false;
                        bl5 = false;
                        bl2 = true;
                        break;
                    }
                    case 5: {
                        bl4 = false;
                        bl5 = false;
                        bl6 = false;
                        bl2 = true;
                        break;
                    }
                    case 9: {
                        bl4 = false;
                        bl5 = false;
                        bl6 = false;
                        bl7 = true;
                        break;
                    }
                    case 11: {
                        if (this.properties.getGraphProperties().getIsHorizontal()) {
                            bl4 = false;
                            bl6 = false;
                        } else {
                            bl5 = false;
                            bl6 = false;
                        }
                        bl9 = true;
                        bl2 = true;
                        break;
                    }
                    default: {
                        bl4 = false;
                        bl5 = false;
                        bl6 = false;
                    }
                }
                switch (n4) {
                    case 256: {
                        bl8 = true;
                    }
                }
                switch (n5) {
                    case 65536: {
                        double d7 = ((Chart2DDataSet)chartDataSet).getXMin();
                        double d8 = ((Chart2DDataSet)chartDataSet).getXMax();
                        d = d < d7 ? d : d7;
                        d2 = d2 > d8 ? d2 : d8;
                        d7 = ((Chart2DDataSet)chartDataSet).getYMin();
                        d8 = ((Chart2DDataSet)chartDataSet).getYMax();
                        d3 = d3 < d7 ? d3 : d7;
                        double d9 = d4 = d4 > d8 ? d4 : d8;
                        if (n3 != 10) continue block16;
                        d3 = chartDataSet.getMin();
                        d4 = chartDataSet.getMax();
                        continue block16;
                    }
                    case 131072: {
                        double d7 = ((Chart3DDataSet)chartDataSet).getXMin();
                        double d8 = ((Chart3DDataSet)chartDataSet).getXMax();
                        d = d < d7 ? d : d7;
                        d2 = d2 > d8 ? d2 : d8;
                        d7 = ((Chart3DDataSet)chartDataSet).getYMin();
                        d8 = ((Chart3DDataSet)chartDataSet).getYMax();
                        d3 = d3 < d7 ? d3 : d7;
                        d4 = d4 > d8 ? d4 : d8;
                        d7 = ((Chart3DDataSet)chartDataSet).getZMin();
                        d8 = ((Chart3DDataSet)chartDataSet).getZMax();
                        d5 = d5 < d7 ? d5 : d7;
                        double d10 = d6 = d6 > d8 ? d6 : d8;
                        if (n3 != 10) continue block16;
                        d3 = chartDataSet.getMin();
                        d4 = chartDataSet.getMax();
                        continue block16;
                    }
                    case 0: 
                    case 196608: {
                        double d8;
                        double d7;
                        boolean bl10 = false;
                        bl10 = bl ? this.properties.getAxisY2Properties().getIsShowPercent() : this.properties.getAxisYProperties().getIsShowPercent();
                        if (!bl10 || !bl2) {
                            d7 = chartDataSet.getMin();
                            d8 = chartDataSet.getMax();
                        } else {
                            d7 = ((Chart1DDataSet)chartDataSet).calculatePercentMinMaxPercentOfCategory()[0];
                            d8 = ((Chart1DDataSet)chartDataSet).calculatePercentMinMaxPercentOfCategory()[1];
                            bl8 = true;
                        }
                        d3 = d3 < d7 ? d3 : d7;
                        d4 = d4 > d8 ? d4 : d8;
                    }
                }
            }
            chartLayerRenderInfo.yMin = d3;
            chartLayerRenderInfo.yMax = d4;
            chartLayerRenderInfo.yMin = chartLayerRenderInfo.yMin < -3.4028234663852886E38 ? -3.4028234663852886E38 : chartLayerRenderInfo.yMin;
            chartLayerRenderInfo.yMax = chartLayerRenderInfo.yMax > 3.4028234663852886E38 ? 3.4028234663852886E38 : chartLayerRenderInfo.yMax;
            chartLayerRenderInfo.yMax = chartLayerRenderInfo.yMax < chartLayerRenderInfo.yMin ? chartLayerRenderInfo.yMin : chartLayerRenderInfo.yMax;
            chartRenderInfo.zMin = d5;
            chartRenderInfo.zMax = d6;
            chartLayerRenderInfo.allIsIntegerData = bl3;
            if (!bl9) {
                boolean bl11 = chartLayerRenderInfo.depthEnable = bl4 || bl5;
            }
            if (!bl) {
                this.calculateAxisPlot = !bl9;
                this.calculateGraphArea = bl5;
            } else {
                this.calculateAxisPlot = bl5 ? this.calculateGraphArea : !this.calculateGraphArea;
            }
            chartLayerRenderInfo.allLineArea = bl6;
            chartLayerRenderInfo.hasBubble = bl7;
            chartLayerRenderInfo.hasPercent = bl8;
            int n6 = n = this.platform.getChartDefinition().isMotionChart() && this.model.getMotionChartDataCubeList() != null ? 1 : 0;
            if (n != 0) {
                double d11 = this.model.getMinX();
                double d12 = this.model.getMaxX();
                double d13 = this.model.getMinY();
                double d14 = this.model.getMaxY();
                double d15 = this.model.getMinZ();
                double d16 = this.model.getMaxZ();
                chartRenderInfo.xMax = chartRenderInfo.xMax < d12 ? d12 : chartRenderInfo.xMax;
                chartRenderInfo.zMax = chartRenderInfo.zMax < d16 ? d16 : chartRenderInfo.zMax;
                chartLayerRenderInfo.yMax = chartLayerRenderInfo.yMax < d14 ? d14 : chartLayerRenderInfo.yMax;
                chartRenderInfo.xMin = chartRenderInfo.xMin > d11 ? d11 : chartRenderInfo.xMin;
                chartRenderInfo.zMin = chartRenderInfo.zMin > d15 ? d15 : chartRenderInfo.zMin;
                chartLayerRenderInfo.yMin = chartLayerRenderInfo.yMin > d13 ? d13 : chartLayerRenderInfo.yMin;
            }
        }
        chartRenderInfo.xMin = chartRenderInfo.xMin < d ? chartRenderInfo.xMin : d;
        chartRenderInfo.xMax = chartRenderInfo.xMax > d2 ? chartRenderInfo.xMax : d2;
    }

    private void IsShowLabelTips() {
        Object[] objectArray;
        ChartDataFilter chartDataFilter;
        String string;
        Vector<Object[]> vector;
        boolean bl;
        this.primLayer = null;
        this.secLayer = null;
        this.gridX1 = new GridLine();
        this.gridX2 = new GridLine();
        this.gridY1 = new GridLine();
        this.gridY2 = new GridLine();
        this.gridZ = new GridLine();
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.allIsIntegerData.primLayer != null) {
            switch (this.allIsIntegerData.primLayer.getCoordinateType()) {
                case 3: {
                    this.axisX1 = new ChartNumericAxis(this.properties.getAxisXProperties(), this.allIsIntegerData.xMin, this.allIsIntegerData.xMax);
                    this.axisY1 = new ChartNumericAxis(this.properties.getAxisYProperties(), this.allIsIntegerData.primLayer.yMin, this.allIsIntegerData.primLayer.yMax);
                    ((ChartNumericAxis)this.axisX1).setAutoExpand(true);
                    ((ChartNumericAxis)this.axisY1).setAutoExpand(true);
                    if (this.allIsIntegerData.primLayer.hasBubble || this.allIsIntegerData.secLayer != null && this.allIsIntegerData.secLayer.hasBubble) {
                        ((ChartNumericAxis)this.axisX1).setIsBubble(true);
                        ((ChartNumericAxis)this.axisY1).setIsBubble(true);
                        ((ChartNumericAxis)this.axisX1).setAutoExpand(false);
                        ((ChartNumericAxis)this.axisY1).setAutoExpand(false);
                    }
                    if (!this.allIsIntegerData.primLayer.hasBubble || !this.axisY) break;
                    this.axisX1 = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames());
                    break;
                }
                case 0: 
                case 8: 
                case 9: 
                case 14: {
                    this.axisX1 = null;
                    this.axisY1 = null;
                    break;
                }
                case 4: {
                    this.axisY1 = new ChartNumericRadarAxis(this.properties.getAxisYProperties(), this.allIsIntegerData.primLayer.yMin, this.allIsIntegerData.primLayer.yMax, this.model.getCategoryNames(), this.properties.getAxisXProperties().getLabelTextStyle());
                    ((ChartNumericRadarAxis)this.axisY1).setIsShowRadarColumnName(this.properties.getGraphProperties().isRadarIsShowColumnName());
                    bl2 = true;
                    break;
                }
                case 5: {
                    this.axisX1 = null;
                    this.axisY1 = new ChartNumericAxis(this.properties.getAxisYProperties(), this.allIsIntegerData.primLayer.yMin, this.allIsIntegerData.primLayer.yMax);
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    if (this instanceof Chart2DSimplePaper || !this.isScrollChart()) {
                        this.axisX1 = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames());
                    } else if (!(this instanceof Chart2DSimplePaper) && this.platform.isSupportScrollChart() && this.properties.getAxisXProperties().getUnitProperties().getUseConstantInterva() && this.isConstantCategory(this.model.getCategoryNames())) {
                        this.axisX1 = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames());
                        bl3 = true;
                    } else {
                        this.axisX1 = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames().subList(this.platform.showScrollLabelStart(), this.platform.showScrollLabelEnd()));
                        bl3 = true;
                    }
                    if (this instanceof Chart2DSimplePaper) {
                        this.axisX1.unScroll = false;
                    }
                    this.axisY1 = new ChartNumericAxis(this.properties.getAxisYProperties(), this.allIsIntegerData.primLayer.yMin, this.allIsIntegerData.primLayer.yMax);
                    bl2 = true;
                    if (this.allIsIntegerData.primLayer.hasPercent) break;
                    ((ChartNumericAxis)this.axisY1).setAutoExpand(true);
                    ((ChartNumericAxis)this.axisY1).setIntegerIncrement(this.allIsIntegerData.primLayer.allIsIntegerData);
                }
            }
            if (this.axisX1 != null) {
                this.axisX1.setFilter(this.model.getCategoryFilter());
                if (this.model.isSwapGroup() && this.axisX1.getFilter() != null) {
                    this.axisX1.getFilter().setUsedCategory(false);
                    this.axisX1.getFilter().setUsedSeries(true);
                }
                this.axisX1.setShow(this.properties.isShowAxisX());
                this.axisX1.setUseCustommerConstant(this.isCustommerConstantAxis(this.add));
                if (bl3 && !(this instanceof Chart2DSimplePaper)) {
                    this.axisX1.setScrollInfo(this.platform.getScrollbarInfo());
                }
                this.axisX1.setMaxRange(this.getBounds());
                this.axisX1.setMinTickmarkDis(ChartRenderTools.convertUnitToPixel(this.platform.getProperties().getMinTickMarkerSpace(), this.platform.resolution));
                this.axisX1.init();
            }
            if (this.axisY1 != null) {
                this.axisY1.setFilter(this.model.getPrimFilter());
                this.axisY1.setShow(this.properties.isShowAxisY());
                if (this.axisY1 instanceof ChartNumericRadarAxis) {
                    ((ChartNumericRadarAxis)this.axisY1).setCategoryFilter(this.model.getCategoryFilter());
                }
                bl = false;
                if (this.model.getPrimFilter() != null && this.model.getPrimFilter().usedFormat()) {
                    bl = true;
                }
                if (!bl && this.properties.getAxisYProperties().getIsShowPercent() && bl2) {
                    vector = new Vector<Object[]>();
                    string = "10.00%";
                    chartDataFilter = new ChartDataFilter();
                    objectArray = new Object[]{new Integer(Integer.valueOf(string.substring(0, 1))), string.substring(1)};
                    vector.add(objectArray);
                    chartDataFilter.setFilters(vector);
                    this.axisY1.setFilter(chartDataFilter);
                }
                this.axisY1.setMinTickmarkDis(ChartRenderTools.convertUnitToPixel(this.platform.getProperties().getMinTickMarkerSpace(), this.platform.resolution));
                this.axisY1.init();
            }
            switch (this.allIsIntegerData.primLayer.getCoordinateType()) {
                case 4: {
                    this.primLayer = new Chart2DRadarLayer(this);
                    break;
                }
                case 0: 
                case 5: 
                case 8: 
                case 9: 
                case 14: {
                    this.primLayer = new Chart2DPieLayer(this);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    this.primLayer = new Chart2DLayer(this);
                }
            }
            this.primLayer.setAxisX(this.axisX1);
            this.primLayer.setAxisY(this.axisY1);
            this.primLayer.init();
            this.primLayer.setChartCount(this.datasets.size());
        }
        if (this.allIsIntegerData.secLayer != null) {
            bl2 = false;
            bl3 = false;
            switch (this.allIsIntegerData.secLayer.getCoordinateType()) {
                case 3: {
                    this.axisX2 = new ChartNumericAxis(this.properties.getAxisXProperties(), this.allIsIntegerData.xMin, this.allIsIntegerData.xMax);
                    this.axisY2 = new ChartNumericAxis(this.properties.getAxisY2Properties(), this.allIsIntegerData.secLayer.yMin, this.allIsIntegerData.secLayer.yMax);
                    ((ChartNumericAxis)this.axisX2).setAutoExpand(true);
                    ((ChartNumericAxis)this.axisY2).setAutoExpand(true);
                    if (this.allIsIntegerData.secLayer.hasBubble) {
                        ((ChartNumericAxis)this.axisX2).setIsBubble(true);
                        ((ChartNumericAxis)this.axisY2).setIsBubble(true);
                        ((ChartNumericAxis)this.axisX2).setAutoExpand(false);
                        ((ChartNumericAxis)this.axisY2).setAutoExpand(false);
                    }
                    if (this.primLayer == null || !this.allIsIntegerData.primLayer.hasBubble) break;
                    ((ChartNumericAxis)this.axisX2).setIsBubble(true);
                    ((ChartNumericAxis)this.axisY2).setIsBubble(true);
                    break;
                }
                case 0: 
                case 8: {
                    this.axisX2 = null;
                    this.axisY2 = null;
                    break;
                }
                case 4: {
                    this.axisX2 = null;
                    this.axisY2 = new ChartNumericAxis(this.properties.getAxisYProperties(), this.allIsIntegerData.secLayer.yMin, this.allIsIntegerData.secLayer.yMax);
                    bl2 = true;
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    if (this instanceof Chart2DSimplePaper || !this.isScrollChart() && !this.platform.isScrollChart()) {
                        this.axisX2 = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames());
                    } else if (!(this instanceof Chart2DSimplePaper) && this.platform.isSupportScrollChart() && this.properties.getAxisXProperties().getUnitProperties().getUseConstantInterva() && this.isConstantCategory(this.model.getCategoryNames())) {
                        this.axisX2 = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames());
                        bl3 = true;
                    } else {
                        this.axisX2 = new ChartCategoryAxis(this.properties.getAxisXProperties(), this.model.getCategoryNames().subList(this.platform.showScrollLabelStart(), this.platform.showScrollLabelEnd()));
                    }
                    this.axisY2 = new ChartNumericAxis(this.properties.getAxisY2Properties(), this.allIsIntegerData.secLayer.yMin, this.allIsIntegerData.secLayer.yMax);
                    if (!this.allIsIntegerData.secLayer.hasPercent) {
                        ((ChartNumericAxis)this.axisY2).setAutoExpand(true);
                        ((ChartNumericAxis)this.axisY2).setIntegerIncrement(this.allIsIntegerData.secLayer.allIsIntegerData);
                    }
                    bl2 = true;
                }
            }
            if (this.axisX2 != null) {
                this.axisX2.setFilter(this.model.getCategoryFilter());
                this.axisX2.setShow(this.properties.isShowAxisX());
                this.axisX2.setUseCustommerConstant(this.isCustommerConstantAxis(this.after));
                if (bl3 && !(this instanceof Chart2DSimplePaper)) {
                    this.axisX2.setScrollInfo(this.platform.getScrollbarInfo());
                }
                this.axisX2.setMinTickmarkDis(ChartRenderTools.convertUnitToPixel(this.platform.getProperties().getMinTickMarkerSpace(), this.platform.resolution));
                this.axisX2.init();
            }
            if (this.axisY2 != null) {
                this.axisY2.setFilter(this.model.getSecFilter());
                this.axisY2.setShow(this.properties.isShowAxisY2());
                bl = false;
                if (this.model.getSecFilter() != null && this.model.getSecFilter().usedFormat()) {
                    bl = true;
                }
                if (!bl && this.properties.getAxisY2Properties().getIsShowPercent() && bl2) {
                    vector = new Vector();
                    string = "10.00%";
                    chartDataFilter = new ChartDataFilter();
                    objectArray = new Object[]{new Integer(Integer.valueOf(string.substring(0, 1))), string.substring(1)};
                    vector.add(objectArray);
                    chartDataFilter.setFilters(vector);
                    this.axisY2.setFilter(chartDataFilter);
                }
                this.axisY2.setMinTickmarkDis(ChartRenderTools.convertUnitToPixel(this.platform.getProperties().getMinTickMarkerSpace(), this.platform.resolution));
                this.axisY2.init();
            }
            this.secLayer = new Chart2DLayer(this);
            this.secLayer.setAxisX(this.axisX2);
            this.secLayer.setAxisY(this.axisY2);
            this.secLayer.init();
            this.secLayer.setChartCount(this.datasets.size());
        }
        if (this.allIsIntegerData.primLayer != null && this.allIsIntegerData.primLayer.isHasWall()) {
            this.wallLayer = this.primLayer;
        } else if (this.allIsIntegerData.secLayer != null && this.allIsIntegerData.secLayer.isHasWall()) {
            this.wallLayer = this.secLayer;
        }
        if (this.wallLayer != null) {
            this.wall = new ChartWall();
            this.wall.setProperties(this.properties.getWallProperties());
            if (this.primLayer == null || this.secLayer == null) {
                if (this.primLayer != null) {
                    if (this.allIsIntegerData.primLayer.getCoordinateType() == 2 || this.allIsIntegerData.primLayer.getCoordinateType() == 6 && this.properties.getGraphProperties().getIsHorizontal()) {
                        this.D = null;
                        this.IsShowAxisYLabelTips = this.axisX1;
                        this.IsLabelFontAutomaticOrientation = this.axisY1;
                        this.IsShowLabelTips = null;
                    } else if (this.allIsIntegerData.primLayer.getCoordinateType() == 1 || this.allIsIntegerData.primLayer.getCoordinateType() == 3 || this.allIsIntegerData.primLayer.getCoordinateType() == 6 && !this.properties.getGraphProperties().getIsHorizontal()) {
                        this.D = null;
                        this.IsShowAxisYLabelTips = this.axisY1;
                        this.IsLabelFontAutomaticOrientation = this.axisX1;
                        this.IsShowLabelTips = null;
                    }
                } else if (this.allIsIntegerData.secLayer.getCoordinateType() == 2) {
                    this.D = null;
                    this.IsShowAxisYLabelTips = null;
                    this.IsLabelFontAutomaticOrientation = this.axisY2;
                    this.IsShowLabelTips = this.axisX2;
                } else {
                    this.D = null;
                    this.IsShowAxisYLabelTips = null;
                    this.IsLabelFontAutomaticOrientation = this.axisX2;
                    this.IsShowLabelTips = this.axisY2;
                }
            } else if (this.allIsIntegerData.primLayer.getCoordinateType() == 2) {
                if (this.allIsIntegerData.secLayer.getCoordinateType() == 2) {
                    this.D = this.axisY1;
                    this.IsShowAxisYLabelTips = this.axisX1;
                    this.IsLabelFontAutomaticOrientation = this.axisY2;
                    this.IsShowLabelTips = null;
                } else {
                    this.D = this.axisY1;
                    this.IsShowAxisYLabelTips = this.axisX1;
                    this.IsLabelFontAutomaticOrientation = this.axisX2;
                    this.IsShowLabelTips = this.axisY2;
                }
            } else if (this.allIsIntegerData.secLayer.getCoordinateType() == 2) {
                this.D = this.axisY2;
                this.IsShowAxisYLabelTips = this.axisY1;
                this.IsLabelFontAutomaticOrientation = this.axisX1;
                this.IsShowLabelTips = this.axisX2;
            } else {
                this.D = null;
                this.IsShowAxisYLabelTips = this.axisY1;
                this.IsLabelFontAutomaticOrientation = this.axisX1;
                this.IsShowLabelTips = this.axisY2;
            }
        }
    }

    public void calculateGraphArea() {
        int n;
        int n2;
        int n3;
        Rectangle rectangle = super.getBounds();
        Rectangle rectangle2 = super.getCoreArea();
        int n4 = rectangle2.y;
        int n5 = rectangle2.x;
        int n6 = rectangle.width - rectangle2.x - rectangle2.width;
        int n7 = rectangle.height - rectangle2.y - rectangle2.height;
        n4 = (int)((float)n4 + this.properties.getTopMargin());
        n5 = (int)((float)n5 + this.properties.getLeftMargin());
        n6 = (int)((float)n6 + this.properties.getRightMargin());
        n7 = (int)((float)n7 + this.properties.getBottomMargin());
        if (!(this instanceof Chart2DSimplePaper)) {
            if (this.wallLayer != null) {
                int n8;
                n3 = 1;
                double d = 0.0;
                double d2 = 0.0;
                if (n3 != 0 && this.IsLabelFontAutomaticOrientation != null && this.IsLabelFontAutomaticOrientation.isShow() && this.IsLabelFontAutomaticOrientation.getProperties().isShowTickMarkLabels()) {
                    d = this.IsLabelFontAutomaticOrientation.getBottomAxisFristLabelWidht() / 2.0;
                    d2 = this.IsLabelFontAutomaticOrientation.getBottomAxisLastLabelWidht() / 2.0;
                    n2 = 0;
                    n = 0;
                    if (this.charts != null) {
                        n = this.charts.length;
                    }
                    for (n8 = 0; n8 < n; ++n8) {
                        if (!(this.allIsIntegerData.primLayer != null && this.allIsIntegerData.primLayer.getCoordinateType() == 2 || this.charts[n8] instanceof Graph2DBullet && this.properties.getGraphProperties().getIsHorizontal()) && (this.allIsIntegerData.primLayer == null || this.allIsIntegerData.primLayer.getCoordinateType() != 3)) continue;
                        n2 = 1;
                    }
                    if (this.axisX1 != null && n2 == 0) {
                        double d3 = this.axisX1.getProperties().getLabelTextStyle().getRotation() * 180.0 / Math.PI;
                        boolean bl = this.axisX1.getProperties().labelOnTickmark();
                        if (this.axisX1.getProperties().IsLabelFontAutomaticOrientation() && this.custommerConstant) {
                            d2 = 0.0;
                        } else if (-90.0 < d3 && d3 < 0.0) {
                            d2 = 0.0;
                        }
                        if (!bl && this.axisX1.getProperties().IsLabelFontAutomaticOrientation()) {
                            d2 = 0.0;
                        }
                    }
                }
                if (this.properties.getGraphPosition() == 1) {
                    if (this.D != null && this.D.isShow()) {
                        this.D.setAxisPosition(1);
                        if (this.D.getProperties().isShowTickMarkLabels()) {
                            n4 += this.D.getAxisWithTickLength() + this.D.getMaxDimensionOfLabels().height + ChartEnv.OLD_PAPER_MARGINE;
                        }
                    }
                    if (this.IsLabelFontAutomaticOrientation != null && this.IsLabelFontAutomaticOrientation.isShow()) {
                        this.IsLabelFontAutomaticOrientation.setAxisPosition(3);
                        if (this.IsLabelFontAutomaticOrientation.getProperties().isShowTickMarkLabels()) {
                            n7 += this.IsLabelFontAutomaticOrientation.getAxisWithTickLength() + this.IsLabelFontAutomaticOrientation.getMaxDimensionOfLabels().height + ChartEnv.OLD_PAPER_MARGINE;
                        }
                    }
                    if (this.IsShowAxisYLabelTips != null) {
                        this.IsShowAxisYLabelTips.setAxisPosition(2);
                        if (this.IsShowAxisYLabelTips.isShow() && this.IsShowAxisYLabelTips.getProperties().isShowTickMarkLabels()) {
                            double d4 = this.IsShowAxisYLabelTips.getAxisWithTickLength() + this.IsShowAxisYLabelTips.getMaxDimensionOfLabels().width;
                            if (d4 < d) {
                                d4 = d;
                            }
                            n5 = (int)((double)n5 + (d4 + (double)ChartEnv.OLD_PAPER_MARGINE));
                        }
                    } else {
                        n5 = (int)((double)n5 + d);
                    }
                    if (this.IsShowLabelTips != null) {
                        this.IsShowLabelTips.setAxisPosition(4);
                        if (this.IsShowLabelTips.isShow() && this.IsShowLabelTips.getProperties().isShowTickMarkLabels()) {
                            double d5 = this.IsShowLabelTips.getAxisWithTickLength() + this.IsShowLabelTips.getMaxDimensionOfLabels().width;
                            if (d5 < d2) {
                                d5 = d2;
                            }
                            n6 = (int)((double)n6 + (d5 + (double)ChartEnv.OLD_PAPER_MARGINE));
                        }
                    } else {
                        n6 = (int)((double)n6 + d2);
                    }
                    if (n4 > n7) {
                        n7 = n4;
                    } else {
                        n4 = n7;
                    }
                    if (n5 > n6) {
                        n6 = n5;
                    } else {
                        n5 = n6;
                    }
                } else {
                    int n9;
                    if (this.D != null) {
                        if (this.D.isShow()) {
                            this.D.setAxisPosition(1);
                            if (this.D.getProperties().isShowTickMarkLabels()) {
                                n4 += this.D.getAxisWithTickLength();
                                n4 += this.D.getMaxDimensionOfLabels().height;
                            }
                        }
                        if (this.properties.getGraphProperties().getDepth() > 0.0f && this.primLayer == null && this.allIsIntegerData.secLayer.depthEnable && this.properties.getGraphProperties().isUseDepth()) {
                            n4 = (int)((float)n4 + this.properties.getGraphProperties().getDepth());
                        }
                    }
                    if (this.IsShowAxisYLabelTips != null) {
                        if (this.IsShowAxisYLabelTips.isShow()) {
                            this.IsShowAxisYLabelTips.setAxisPosition(2);
                            double d6 = 0.0;
                            if (this.IsShowAxisYLabelTips.getProperties().isShowTickMarkLabels()) {
                                d6 = this.IsShowAxisYLabelTips.getAxisWithTickLength();
                                d6 += (double)this.IsShowAxisYLabelTips.getMaxDimensionOfLabels().width;
                            }
                            if (d6 < d) {
                                d6 = d;
                            }
                            n5 = (int)((double)n5 + d6);
                            n8 = (int)this.IsShowAxisYLabelTips.getAxisTopMargin();
                            if ((this.allIsIntegerData.primLayer.getCoordinateType() == 2 || this.allIsIntegerData.primLayer.getCoordinateType() == 6) && this.axisX1 != null) {
                                float f = 0.0f;
                                double d7 = this.axisX1.getProperties().getLabelTextStyle().getRotation() * 180.0 / Math.PI;
                                boolean bl = this.axisX1.getProperties().labelOnTickmark();
                                if (bl && !this.custommerConstant && -90.0 == d7) {
                                    f = (float)this.IsShowAxisYLabelTips.getMaxDimensionOfLabels().height / 2.0f;
                                }
                                n8 = (int)((float)n8 + f);
                            }
                            if (n4 < n8) {
                                n4 = n8;
                            }
                            if (n7 < (n9 = (int)this.IsShowAxisYLabelTips.getAxisBottomMargin())) {
                                n7 = n9;
                            }
                        } else {
                            n5 = (int)((double)n5 + d);
                        }
                        if (this.properties.getGraphProperties().getDepth() > 0.0f && (this.allIsIntegerData.primLayer.depthEnable && this.properties.getGraphProperties().isUseDepth() || this.secLayer != null && this.allIsIntegerData.secLayer.depthEnable)) {
                            n5 = (int)((float)n5 + this.properties.getGraphProperties().getDepth());
                        }
                    } else {
                        n5 = (int)((double)n5 + d);
                    }
                    if (this.IsLabelFontAutomaticOrientation != null) {
                        if (this.IsLabelFontAutomaticOrientation.isShow()) {
                            this.IsLabelFontAutomaticOrientation.setAxisPosition(3);
                            if (this.IsLabelFontAutomaticOrientation.getProperties().isShowTickMarkLabels()) {
                                n7 += this.IsLabelFontAutomaticOrientation.getAxisWithTickLength();
                                n7 += this.IsLabelFontAutomaticOrientation.getMaxDimensionOfLabels().height;
                            }
                        }
                        if (this.properties.getGraphProperties().getDepth() > 0.0f && this.properties.getGraphProperties().isUseDepth() && (this.primLayer != null && this.allIsIntegerData.primLayer.depthEnable || this.secLayer != null && this.allIsIntegerData.secLayer.depthEnable)) {
                            n7 = (int)((float)n7 + this.properties.getGraphProperties().getDepth());
                        }
                    }
                    if (this.IsShowLabelTips != null) {
                        if (this.IsShowLabelTips.isShow()) {
                            this.IsShowLabelTips.setAxisPosition(4);
                            double d8 = 0.0;
                            if (this.IsShowLabelTips.getProperties().isShowTickMarkLabels()) {
                                d8 = this.IsShowLabelTips.getAxisWithTickLength();
                                d8 += (double)this.IsShowLabelTips.getMaxDimensionOfLabels().width;
                            }
                            if (d8 < d2) {
                                d8 = d2;
                            }
                            n6 = (int)((double)n6 + d8);
                            n8 = (int)this.IsShowLabelTips.getAxisTopMargin();
                            if (n4 < n8) {
                                n4 = n8;
                            }
                            if (n7 < (n9 = (int)this.IsShowLabelTips.getAxisBottomMargin())) {
                                n7 = n9;
                            }
                        } else {
                            n6 = (int)((double)n6 + d2);
                        }
                        if (this.properties.getGraphProperties().getDepth() > 0.0f && this.primLayer == null && this.allIsIntegerData.secLayer.depthEnable && this.properties.getGraphProperties().isUseDepth()) {
                            n6 = (int)((float)n6 + this.properties.getGraphProperties().getDepth());
                        }
                    } else {
                        n6 = (int)((double)n6 + d2);
                    }
                }
            } else if (this.charts != null && this.charts.length > 0 && this.charts[0] instanceof Graph2DRadar) {
                n4 = rectangle2.y;
                n5 = rectangle2.x;
                n6 = rectangle.width - rectangle2.x - rectangle2.width;
                n7 = rectangle.height - rectangle2.y - rectangle2.height;
                ((ChartNumericRadarAxis)this.axisY1).setIsShowRadarColumnName(this.properties.getGraphProperties().isRadarIsShowColumnName());
            }
        }
        n3 = n5;
        int n10 = n4;
        int n11 = rectangle.width - n5 - n6;
        int n12 = rectangle.height - n4 - n7;
        n3 = n3 > 0 ? n3 : 0;
        n3 = n3 > rectangle.width ? rectangle.width - ChartEnv.PLATFORM_PAPER_MARGINE : n3;
        n10 = n10 > 0 ? n10 : 0;
        n11 = n11 > 0 ? n11 : 0;
        n12 = n12 > 0 ? n12 : 0;
        ChartDataSet chartDataSet = null;
        for (n2 = 0; n2 < this.datasets.size(); ++n2) {
            chartDataSet = (ChartDataSet)this.datasets.get(n2);
            n = chartDataSet.getChartDataSetInfo().getChartType();
            if (!ChartTypeInfo.isSparkLineChart(n)) continue;
            n3 = 0;
            n10 = 0;
            n11 = rectangle.width;
            n12 = rectangle.height;
            break;
        }
        this.graphArea = new Rectangle(n3, n10, n11, n12);
    }

    @Override
    public void locate() {
        this.calculateAxisPlot();
        this.setConstantFilterName();
        this.before = 0;
        this.calculateGraphArea();
        this.OLD_PAPER_MARGINE();
        if (this.properties.isShadowContents()) {
            this.append = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        }
        boolean bl = false;
        if (this.primLayer != null || this.secLayer != null) {
            if (this.primLayer != null) {
                if (this.primLayer.axisX != null) {
                    if (this.primLayer.getAutoOritention(true)) {
                        this.primLayer.axisX.setLabelAutoRotate(true);
                        bl = true;
                        this.custommerConstant = true;
                    } else {
                        this.primLayer.axisX.setLabelAutoRotate(false);
                        this.custommerConstant = false;
                    }
                    if (this.primLayer.axisX.getProperties().IsLabelFontAutomaticOrientation()) {
                        bl = true;
                    } else if (this.primLayer.axisX.getProperties().getLabelTextStyle().getWordWrapper()) {
                        bl = true;
                    }
                }
                if (this.primLayer.axisY != null) {
                    if (this.primLayer.getAutoOritention(false)) {
                        this.primLayer.axisY.setLabelAutoRotate(true);
                        bl = true;
                    } else {
                        this.primLayer.axisY.setLabelAutoRotate(false);
                    }
                    if (this.primLayer.axisY.getProperties().IsLabelFontAutomaticOrientation()) {
                        bl = true;
                    } else if (this.primLayer.axisY.getProperties().getLabelTextStyle().getWordWrapper()) {
                        bl = true;
                    }
                }
            }
            if (this.secLayer != null) {
                if (this.secLayer.axisX != null) {
                    if (this.secLayer.getAutoOritention(true)) {
                        this.secLayer.axisX.setLabelAutoRotate(true);
                        bl = true;
                    } else {
                        this.secLayer.axisX.setLabelAutoRotate(false);
                    }
                    if (this.secLayer.axisX.getProperties().IsLabelFontAutomaticOrientation()) {
                        bl = true;
                    } else if (this.secLayer.axisX.getProperties().getLabelTextStyle().getWordWrapper()) {
                        bl = true;
                    }
                }
                if (this.secLayer.axisY != null) {
                    if (this.secLayer.getAutoOritention(false)) {
                        bl = true;
                    }
                    if (this.secLayer.axisY.getProperties().IsLabelFontAutomaticOrientation()) {
                        bl = true;
                    } else if (this.secLayer.axisY.getProperties().getLabelTextStyle().getWordWrapper()) {
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            this.calculateGraphArea();
            this.OLD_PAPER_MARGINE();
        }
        if (this.meanLines != null) {
            for (int i = 0; i < this.meanLines.length; ++i) {
                if (this.meanLines[i] == null) continue;
                ((Graph2DMeanLine)this.meanLines[i]).setPercent(ChartTypeInfo.getSubType(this.model.getChartDataSet(i).getChartDataSetInfo().getChartType()) == 256);
                this.meanLines[i].init();
                this.meanLines[i].locate();
            }
        }
        int[] nArray = this.properties.getValueLabelPositionList();
        int[] nArray2 = this.properties.getValueLabelSmartShow();
        int n = 0;
        this.black = 0;
        for (int i = 0; i < this.charts.length; ++i) {
            if (nArray != null && nArray.length > 0 && i < nArray.length) {
                this.charts[i].setValueLabelPosition(nArray[i]);
            }
            if (nArray2 != null && i < nArray2.length) {
                this.charts[i].setValueLabelSmartPosition(nArray2[i]);
            }
            if (this.charts[i] instanceof Graph2DBar) {
                float f = this.properties.getGraphProperties().getBarWidth();
                if (this.allLineArea((Graph2DBar)this.charts[i])) {
                    for (int j = 0; j < n; ++j) {
                        f *= 0.8f;
                    }
                    if (this.model.getMotionChartGroupNames() == null) {
                        ++n;
                    }
                }
                ((Graph2DBar)this.charts[i]).setBarWidth(f);
            }
            if (this.isScrollChart()) {
                if (this.axisX1 != null && this.axisX1.custommerConstant()) {
                    this.charts[i].setScrollLabelCount(this.platform.getDataSetModel().getCategoryCount());
                } else if (this.axisX2 != null && this.axisX2.custommerConstant()) {
                    this.charts[i].setScrollLabelCount(this.platform.getDataSetModel().getCategoryCount());
                } else {
                    this.charts[i].setScrollLabelCount(this.platform.showScrollLabelEnd() - this.platform.showScrollLabelStart());
                }
            }
            this.charts[i].init();
            if (this.charts[i] instanceof Graph2DLine) {
                ((Graph2DLine)this.charts[i]).setAreaPatterns(this.properties.getGraphProperties().getAreaPatternList(), this.before);
                this.before = ((Graph2DLine)this.charts[i]).getStartIndex();
                ((Graph2DLine)this.charts[i]).setLineStyleList(this.properties.getGraphProperties().getLineStyles(), this.black, this.properties.getGraphProperties().getBindedLineStyle());
                this.black = ((Graph2DLine)this.charts[i]).getLineStyleStartIndex();
            }
            this.charts[i].locate();
        }
        if (this.clone != null) {
            this.clone.init();
            this.clone.locate();
        }
    }

    void calculateAxisPlot() {
        this.calculateGraphArea();
        boolean bl = false;
        if (this.primLayer != null) {
            this.primLayer.setTransformParam(super.getBounds(), this.graphArea, this.properties.getScaleX(), this.properties.getScaleY());
        }
        if (this.secLayer != null) {
            this.secLayer.setTransformParam(super.getBounds(), this.graphArea, this.properties.getScaleX(), this.properties.getScaleY());
        }
        if (this.primLayer != null || this.secLayer != null) {
            if (this.primLayer != null) {
                if (this.primLayer.axisX != null) {
                    if (this.primLayer.getAutoOritention(true)) {
                        this.primLayer.axisX.setLabelAutoRotate(true);
                        bl = true;
                        this.custommerConstant = true;
                    } else {
                        this.primLayer.axisX.setLabelAutoRotate(false);
                        this.custommerConstant = false;
                    }
                    if (this.primLayer.axisX.getProperties().IsLabelFontAutomaticOrientation()) {
                        bl = true;
                    } else if (this.primLayer.axisX.getProperties().getLabelTextStyle().getWordWrapper()) {
                        bl = true;
                    }
                }
                if (this.primLayer.axisY != null) {
                    if (this.primLayer.getAutoOritention(false)) {
                        this.primLayer.axisY.setLabelAutoRotate(true);
                        bl = true;
                    } else {
                        this.primLayer.axisY.setLabelAutoRotate(false);
                    }
                    if (this.primLayer.axisY.getProperties().IsLabelFontAutomaticOrientation()) {
                        bl = true;
                    } else if (this.primLayer.axisY.getProperties().getLabelTextStyle().getWordWrapper()) {
                        bl = true;
                    }
                }
            }
            if (this.secLayer != null) {
                if (this.secLayer.axisX != null) {
                    if (this.secLayer.getAutoOritention(true)) {
                        this.secLayer.axisX.setLabelAutoRotate(true);
                        bl = true;
                    } else {
                        this.secLayer.axisX.setLabelAutoRotate(false);
                    }
                    if (this.secLayer.axisX.getProperties().IsLabelFontAutomaticOrientation()) {
                        bl = true;
                    } else if (this.secLayer.axisX.getProperties().getLabelTextStyle().getWordWrapper()) {
                        bl = true;
                    }
                }
                if (this.secLayer.axisY != null) {
                    if (this.secLayer.getAutoOritention(false)) {
                        bl = true;
                    }
                    if (this.secLayer.axisY.getProperties().IsLabelFontAutomaticOrientation()) {
                        bl = true;
                    } else if (this.secLayer.axisY.getProperties().getLabelTextStyle().getWordWrapper()) {
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            this.calculateGraphArea();
        }
        if (this.D != null) {
            this.D.setLength(this.getAxisLength(this.D, this.graphArea));
            this.D.setTickSkipNum();
        }
        if (this.IsLabelFontAutomaticOrientation != null) {
            this.IsLabelFontAutomaticOrientation.setLength(this.getAxisLength(this.IsLabelFontAutomaticOrientation, this.graphArea));
            this.IsLabelFontAutomaticOrientation.setTickSkipNum();
        }
        if (this.IsShowAxisYLabelTips != null) {
            this.IsShowAxisYLabelTips.setLength(this.getAxisLength(this.IsShowAxisYLabelTips, this.graphArea));
            this.IsShowAxisYLabelTips.setTickSkipNum();
        }
        if (this.IsShowLabelTips != null) {
            this.IsShowLabelTips.setLength(this.getAxisLength(this.IsShowLabelTips, this.graphArea));
            this.IsShowLabelTips.setTickSkipNum();
        }
    }

    float getAxisLength(ChartAxis chartAxis, Rectangle rectangle) {
        if (chartAxis == null || rectangle == null) {
            return -1.0f;
        }
        float f = -1.0f;
        switch (chartAxis.getAxisPosition()) {
            case 2: 
            case 4: {
                f = this.properties.getScaleY() * (float)rectangle.height;
                break;
            }
            case 1: 
            case 3: {
                f = this.properties.getScaleX() * (float)rectangle.width;
                break;
            }
        }
        return f;
    }

    private void OLD_PAPER_MARGINE() {
        if (this.primLayer == null || this.secLayer == null) {
            boolean bl = this.isSupportLabelOnTickmark();
            if (this.primLayer != null && this.allIsIntegerData != null && this.allIsIntegerData.primLayer != null) {
                this.primLayer.setTransformParam(super.getBounds(), this.graphArea, this.properties.getScaleX(), this.properties.getScaleY());
                if (this.allIsIntegerData.primLayer.getCoordinateType() == 2 || this.allIsIntegerData.primLayer.getCoordinateType() == 6 && this.properties.getGraphProperties().getIsHorizontal()) {
                    this.primLayer.setAxisYPosition(0);
                    this.primLayer.transformBench0();
                    ((ChartCategoryAxis)this.axisX1).setAxisPosition(2);
                    ((ChartNumericAxis)this.axisY1).setAxisPosition(3);
                } else if (this.allIsIntegerData.primLayer.getCoordinateType() == 4) {
                    this.primLayer.transformRadar();
                    ((ChartNumericAxis)this.axisY1).setAxisPosition(4);
                } else {
                    this.primLayer.transformNormal();
                    if (this.axisX1 != null) {
                        if (this.allIsIntegerData.primLayer.getCoordinateType() == 3 || this.allIsIntegerData.primLayer.hasBubble) {
                            this.axisX1.setAxisPosition(3);
                        } else {
                            ((ChartCategoryAxis)this.axisX1).setAxisPosition(3);
                        }
                    }
                    if (this.axisY1 != null) {
                        ((ChartNumericAxis)this.axisY1).setAxisPosition(2);
                    }
                }
                if (this.allIsIntegerData.primLayer.allLineArea && this.primLayer.useDepth() && this.axisX1 != null) {
                    this.axisX1.setIsLineUnit(true);
                }
                if (bl && this.axisX1 != null && this.axisX1.getProperties().getPositionAxis() == 0 && !this.properties.getGraphProperties().isUseDepth() && this.axisX1 != null) {
                    this.axisX1.setIsLineUnit(true);
                }
                if (this.axisX1 != null && this.allIsIntegerData.primLayer.hasBubble && this.axisY) {
                    this.axisX1.setIsLineUnit(true);
                }
                if (this.allIsIntegerData.primLayer.depthEnable) {
                    this.primLayer.setDepth((int)this.properties.getGraphProperties().getDepth());
                    this.primLayer.setDepthDirection(this.properties.getGraphProperties().getDepthDirection());
                    this.primLayer.setUseDepth(this.properties.getGraphProperties().isUseDepth());
                }
                this.primLayer.setAxisYPosition(this.properties.getAxisYProperties().getPlacement());
                this.primLayer.setAxisXPosition(this.properties.getAxisXProperties().getPlacement());
                this.primLayer.setShowCategoryAndSeries(this.properties.isShowCategoryAndSeries());
                this.primLayer.locate();
                if (this.primLayer.isDepth()) {
                    if (this.axisX1 != null) {
                        this.axisX1.setDepth(this.primLayer.isDepth());
                    }
                    if (this.axisY1 != null) {
                        this.axisY1.setDepth(this.primLayer.isDepth());
                    }
                }
            } else {
                this.secLayer.setTransformParam(super.getBounds(), this.graphArea, this.properties.getScaleX(), this.properties.getScaleY());
                this.secLayer.setShowCategoryAndSeries(this.properties.isShowCategoryAndSeries());
                if (this.allIsIntegerData.secLayer.getCoordinateType() == 2) {
                    this.secLayer.transformBench2();
                    ((ChartCategoryAxis)this.axisX2).setAxisPosition(4);
                    ((ChartNumericAxis)this.axisY2).setAxisPosition(3);
                } else {
                    this.secLayer.setAxisYPosition(2);
                    this.secLayer.transformNormal();
                    if (this.axisX2 != null) {
                        if (this.allIsIntegerData.secLayer.getCoordinateType() == 3 || this.allIsIntegerData.secLayer.hasBubble) {
                            ((ChartNumericAxis)this.axisX2).setAxisPosition(3);
                        } else {
                            ((ChartCategoryAxis)this.axisX2).setAxisPosition(3);
                        }
                    }
                    ((ChartNumericAxis)this.axisY2).setAxisPosition(4);
                }
                if (this.allIsIntegerData.secLayer.allLineArea && this.secLayer.useDepth()) {
                    this.axisX2.setIsLineUnit(true);
                }
                if (bl && this.axisX2.getProperties().getPositionAxis() == 0 && !this.secLayer.isDepth() && !this.properties.getGraphProperties().isUseDepth()) {
                    this.axisX2.setIsLineUnit(true);
                }
                if (this.allIsIntegerData.secLayer.depthEnable) {
                    this.secLayer.setDepth((int)this.properties.getGraphProperties().getDepth());
                    this.secLayer.setDepthDirection(this.properties.getGraphProperties().getDepthDirection());
                    this.secLayer.setUseDepth(this.properties.getGraphProperties().isUseDepth());
                }
                this.secLayer.locate();
                if (this.secLayer.isDepth()) {
                    if (this.axisX2 != null) {
                        this.axisX2.setDepth(this.secLayer.isDepth());
                    }
                    this.axisY2.setDepth(this.secLayer.isDepth());
                }
            }
        } else {
            this.primLayer.setShowCategoryAndSeries(this.properties.isShowCategoryAndSeries());
            this.secLayer.setShowCategoryAndSeries(this.properties.isShowCategoryAndSeries());
            if (this.axisX1 != null && this.isSupportLabelOnTickmark() && this.axisX1.getProperties().getPositionAxis() == 0 && !this.properties.getGraphProperties().isUseDepth() && this.axisX1 != null) {
                this.axisX1.setIsLineUnit(true);
            }
            if (this.axisX2 != null && this.isSupportLabelOnTickmark() && this.axisX2.getProperties().getPositionAxis() == 0 && !this.properties.getGraphProperties().isUseDepth() && this.axisX2 != null) {
                this.axisX2.setIsLineUnit(true);
            }
            this.primLayer.setTransformParam(super.getBounds(), this.graphArea, this.properties.getScaleX(), this.properties.getScaleY());
            this.secLayer.setTransformParam(super.getBounds(), this.graphArea, this.properties.getScaleX(), this.properties.getScaleY());
            if (this.allIsIntegerData.primLayer.getCoordinateType() == 2) {
                this.primLayer.setCombo(true);
                this.primLayer.transformBench1();
                ((ChartCategoryAxis)this.axisX1).setAxisPosition(2);
                ((ChartNumericAxis)this.axisY1).setAxisPosition(1);
                if (this.allIsIntegerData.secLayer.getCoordinateType() == 2) {
                    this.secLayer.setCombo(true);
                    this.secLayer.setAxisYPosition(2);
                    this.secLayer.transformBench1();
                    this.axisX2 = null;
                    ((ChartNumericAxis)this.axisY2).setAxisPosition(3);
                } else {
                    this.secLayer.setAxisYPosition(2);
                    this.secLayer.transformNormal();
                    if (this.axisX2 != null) {
                        if (this.allIsIntegerData.secLayer.getCoordinateType() == 3 || this.allIsIntegerData.secLayer.hasBubble) {
                            ((ChartNumericAxis)this.axisX2).setAxisPosition(3);
                        } else {
                            ((ChartCategoryAxis)this.axisX2).setAxisPosition(3);
                        }
                    }
                    ((ChartNumericAxis)this.axisY2).setAxisPosition(4);
                }
            } else {
                this.primLayer.transformNormal();
                if (this.allIsIntegerData.primLayer.getCoordinateType() == 3 || this.allIsIntegerData.primLayer.hasBubble) {
                    ((ChartNumericAxis)this.axisX1).setAxisPosition(3);
                } else {
                    ((ChartCategoryAxis)this.axisX1).setAxisPosition(3);
                }
                ((ChartNumericAxis)this.axisY1).setAxisPosition(2);
                if (this.allIsIntegerData.secLayer.getCoordinateType() == 2) {
                    this.secLayer.setAxisYPosition(2);
                    this.secLayer.transformBench2();
                    ((ChartCategoryAxis)this.axisX2).setAxisPosition(4);
                    ((ChartNumericAxis)this.axisY2).setAxisPosition(1);
                } else {
                    this.primLayer.setAxisXPosition(this.properties.getAxisXProperties().getPlacement());
                    this.primLayer.setAxisYPosition(this.properties.getAxisYProperties().getPlacement());
                    this.secLayer.setAxisYPosition(2);
                    this.secLayer.transformNormal();
                    if (this.allIsIntegerData.secLayer.getCoordinateType() == 3 || this.allIsIntegerData.secLayer.hasBubble) {
                        ((ChartNumericAxis)this.axisX2).setAxisPosition(3);
                        this.secLayer.setAxisXPosition(this.properties.getAxisXProperties().getPlacement());
                    } else {
                        this.axisX2 = null;
                    }
                    ((ChartNumericAxis)this.axisY2).setAxisPosition(4);
                }
            }
            if (this.axisX2 != null && this.allIsIntegerData.primLayer.getCoordinateType() == 3) {
                this.axisX2.setShow(false);
            }
            if (this.allIsIntegerData.primLayer.depthEnable) {
                this.primLayer.setDepth((int)this.properties.getGraphProperties().getDepth());
                this.primLayer.setDepthDirection(this.properties.getGraphProperties().getDepthDirection());
                this.primLayer.setUseDepth(this.properties.getGraphProperties().isUseDepth());
            }
            if (this.allIsIntegerData.secLayer.depthEnable) {
                this.secLayer.setDepth((int)this.properties.getGraphProperties().getDepth());
                this.secLayer.setDepthDirection(this.properties.getGraphProperties().getDepthDirection());
                this.secLayer.setUseDepth(this.properties.getGraphProperties().isUseDepth());
            }
            this.primLayer.locate();
            this.secLayer.locate();
            if (this.allIsIntegerData.secLayer.getCoordinateType() == 2 && this.allIsIntegerData.primLayer.getCoordinateType() == 2) {
                if (this.primLayer.isDepth() || this.secLayer.isDepth()) {
                    this.primLayer.resetDepthPos(0.0f, 0.0f);
                }
            } else if (this.primLayer.isDepth() || this.secLayer.isDepth()) {
                this.secLayer.resetDepthPos(0.0f, 0.0f);
            }
            if (this.primLayer.isDepth() || this.secLayer.isDepth()) {
                if (this.axisX1 != null) {
                    this.axisX1.setDepth(this.primLayer.isDepth());
                }
                if (this.axisX2 != null) {
                    this.axisX2.setDepth(this.primLayer.isDepth());
                }
                if (this.axisY1 != null) {
                    this.axisY1.setDepth(this.primLayer.isDepth());
                }
                if (this.axisY2 != null) {
                    this.axisY2.setDepth(this.primLayer.isDepth());
                }
            }
        }
    }

    private Chart2DObject PLATFORM_PAPER_MARGINE(ChartDataSet chartDataSet, Chart2DLayer chart2DLayer, int n) {
        Chart2DObject chart2DObject = null;
        int n2 = chartDataSet.getChartDataSetInfo().getChartType();
        int n3 = ChartTypeInfo.getPrimType(n2);
        int n4 = ChartTypeInfo.getSubType(n2);
        switch (n3) {
            case 0: {
                switch (n4) {
                    case 256: {
                        chart2DObject = new Graph2DBarP(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 512: {
                        chart2DObject = new Graph2DBarSi(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 0: {
                        chart2DObject = new Graph2DBarSt(chartDataSet, this, chart2DLayer, n);
                    }
                }
                break;
            }
            case 1: {
                switch (n4) {
                    case 256: {
                        chart2DObject = new Graph2DBarP(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 512: {
                        chart2DObject = new Graph2DBarSi(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 0: {
                        chart2DObject = new Graph2DBarSt(chartDataSet, this, chart2DLayer, n);
                    }
                }
                break;
            }
            case 2: {
                int n5 = chartDataSet.getSeriesSize();
                int[] nArray = new int[]{this.lineChartStartIndex, n5};
                if (this.lineChartSizeInfo == null) {
                    this.lineChartSizeInfo = new Vector();
                }
                this.lineChartSizeInfo.add(nArray);
                switch (n4) {
                    case 0: {
                        chart2DObject = new Graph2DLineSt(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DLineP(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 768: {
                        chart2DObject = new Graph2DLineA(chartDataSet, this, chart2DLayer, n);
                    }
                }
                break;
            }
            case 3: {
                switch (n4) {
                    case 0: {
                        chart2DObject = new Graph2DAreaSt(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DAreaP(chartDataSet, this, chart2DLayer, n);
                        break;
                    }
                    case 768: {
                        chart2DObject = new Graph2DAreaA(chartDataSet, this, chart2DLayer, n);
                    }
                }
                break;
            }
            case 4: {
                switch (n4) {
                    case 0: {
                        chart2DObject = new Graph2DPie(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DPie(chartDataSet, this, chart2DLayer);
                        ((Graph2DPie)chart2DObject).setIsDonut(true);
                    }
                }
                break;
            }
            case 10: {
                switch (n4) {
                    case 512: {
                        chart2DObject = new Graph2DStockOC(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DStockHLC(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 0: {
                        chart2DObject = new Graph2DStockOHLC(chartDataSet, this, chart2DLayer);
                    }
                }
                break;
            }
            case 5: {
                chart2DObject = new Graph2DRadar(chartDataSet, this, chart2DLayer);
                break;
            }
            case 9: {
                chart2DObject = new Graph2DBubble(chartDataSet, this, chart2DLayer);
                break;
            }
            case 8: {
                switch (n4) {
                    case 0: {
                        chart2DObject = new Graph2DScatterN(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 512: {
                        chart2DObject = new Graph2DScatterS(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DScatterL(chartDataSet, this, chart2DLayer);
                    }
                }
                break;
            }
            case 6: {
                switch (n4) {
                    case 512: {
                        chart2DObject = new Graph2DGuageBalls(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 0: {
                        chart2DObject = new Graph2DGuageDials(chartDataSet, this, chart2DLayer);
                        break;
                    }
                    case 256: {
                        chart2DObject = new Graph2DGuageBars(chartDataSet, this, chart2DLayer);
                    }
                }
                break;
            }
            case 11: {
                chart2DObject = new Graph2DBullet(chartDataSet, this, chart2DLayer);
                break;
            }
            case 13: {
                chart2DObject = new Graph2DLED(chartDataSet, this, chart2DLayer);
            }
        }
        return chart2DObject;
    }

    private String SEDU(int n, int n2) {
        String string;
        if (this.primLayer != null && this.axisX1 != null && (string = this.primLayer.searchAxisXLabel(n, n2)) != null) {
            return string;
        }
        if (this.secLayer != null && this.axisX2 != null && (string = this.secLayer.searchAxisXLabel(n, n2)) != null) {
            return string;
        }
        return null;
    }

    private String add(int n, int n2) {
        String string;
        if (this.primLayer != null) {
            String string2 = string = this.axisX1 != null && this.axisX1.getProperties().IsShowLabelTips() ? this.axisX1.searchAxisLabel(n, n2) : null;
            if (string != null) {
                this.SEDU = string;
                return string;
            }
            this.SEDU = null;
            String string3 = string = this.axisY1 != null && this.axisY1.getProperties().IsShowLabelTips() ? this.axisY1.searchAxisLabel(n, n2) : null;
            if (string != null && this.primLayer.IsShowAxisYLabelTips()) {
                return string;
            }
        }
        if (this.secLayer != null) {
            String string4 = string = this.axisX2 != null && this.axisX2.getProperties().IsShowLabelTips() ? this.axisX2.searchAxisLabel(n, n2) : null;
            if (string != null) {
                this.SEDU = string;
                return string;
            }
            this.SEDU = null;
            String string5 = string = this.axisY2 != null && this.axisY2.getProperties().IsShowLabelTips() ? this.axisY2.searchAxisLabel(n, n2) : null;
            if (string != null) {
                return string;
            }
        }
        return null;
    }

    @Override
    public String[] getHintValue(int n, int n2) {
        int n3;
        this.PLATFORM_PAPER_MARGINE = null;
        String[] stringArray = null;
        int n4 = this.charts.length;
        if (this.properties.isReversePaintingOrder()) {
            for (n3 = 0; n3 < n4; ++n3) {
                stringArray = this.charts[n3].search(n, n2);
                if (stringArray == null) continue;
                this.PLATFORM_PAPER_MARGINE = this.charts[n3].drilldown;
                break;
            }
        } else {
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                stringArray = this.charts[n3].search(n, n2);
                if (stringArray == null) continue;
                this.PLATFORM_PAPER_MARGINE = this.charts[n3].drilldown;
                break;
            }
        }
        if (this.properties.isShowTips()) {
            if (stringArray != null) {
                return stringArray;
            }
        } else {
            stringArray = null;
        }
        String string = null;
        string = this.add(n, n2);
        if (string != null) {
            stringArray = new String[]{this.add(n, n2)};
            return stringArray;
        }
        return stringArray;
    }

    public void searchSelectedLineIndex(int n, int n2) {
        block4: {
            this.selectedLineIndex = -1;
            if (this.charts == null) break block4;
            if (this.properties.isReversePaintingOrder()) {
                for (int i = 0; i < this.charts.length; ++i) {
                    int n3;
                    if (!(this.charts[i] instanceof Graph2DLine) || (n3 = ((Graph2DLine)this.charts[i]).searchIndex(n, n2)) == -1) continue;
                    this.selectedLineIndex = n3;
                    return;
                }
            } else {
                for (int i = this.charts.length - 1; i >= 0; --i) {
                    int n4;
                    if (!(this.charts[i] instanceof Graph2DLine) || (n4 = ((Graph2DLine)this.charts[i]).searchIndex(n, n2)) == -1) continue;
                    this.selectedLineIndex = n4;
                    return;
                }
            }
        }
    }

    private void after(int n, int n2) {
        if (this.charts != null) {
            for (int i = 0; i < this.charts.length; ++i) {
                if (!(this.charts[i] instanceof Graph2DBullet)) continue;
                this.selectedBulletIndex = new int[3];
                this.selectedBulletIndex = ((Graph2DBullet)this.charts[i]).searchBulletBar(n, n2);
            }
        }
    }

    @Override
    public void searchSelectedSeriesIndex(int n, int n2) {
        block4: {
            this.selectedSeriesIndex = -1;
            this.searchSelectedLineIndex(n, n2);
            this.after(n, n2);
            if (this.charts == null) break block4;
            if (this.properties.isReversePaintingOrder()) {
                for (int i = 0; i < this.charts.length; ++i) {
                    int n3 = this.charts[i].searchSeries(n, n2);
                    if (n3 == -1) continue;
                    this.selectedSeriesIndex = n3;
                    this.allLineArea = i;
                    return;
                }
            } else {
                for (int i = this.charts.length - 1; i >= 0; --i) {
                    int n4 = this.charts[i].searchSeries(n, n2);
                    if (n4 == -1) continue;
                    this.selectedSeriesIndex = n4;
                    this.allLineArea = i;
                    return;
                }
            }
        }
    }

    public String getSelectShowValue(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        this.searchSelectedSeriesIndex(n -= this.getBounds().x, n2 -= this.getBounds().y);
        if (this.selectedSeriesIndex != -1 && this.model.getValuesName() != null) {
            if (this.model.getSeriesNames() != null) {
                int n3 = this.selectedSeriesIndex / this.model.getSeriesNames().size();
                if (this.allLineArea > 0) {
                    n3 += this.allLineArea;
                }
                return this.model.getValuesName()[n3 % this.model.getValuesName().length];
            }
            return this.model.getValuesName()[this.selectedSeriesIndex * this.model.getValuesName().length];
        }
        return null;
    }

    public String[] getSelectOrginShowValue(int n, int n2) {
        if (!this.contains(n, n2)) {
            return null;
        }
        int n3 = n - this.getBounds().x;
        int n4 = n2 - this.getBounds().y;
        this.searchSelectedSeriesIndex(n3, n4);
        if (this.selectedSeriesIndex != -1 && this.model.getValuesName() != null) {
            if (this.model.getSeriesNames() != null) {
                int n5 = this.selectedSeriesIndex / this.model.getSeriesNames().size();
                if (this.allLineArea > 0) {
                    for (int i = 0; i < this.allLineArea; ++i) {
                        int n6 = this.charts[i].getChartDataSet().getShowValueEndIndex();
                        n5 += (n6 -= this.charts[i].getChartDataSet().getShowValueBeginIndex());
                    }
                }
                return this.model.getOrignValuesName(n5);
            }
            return this.model.getOrignValuesName(this.selectedSeriesIndex);
        }
        return null;
    }

    public ChartPlatform getChartPlatform() {
        return this.platform;
    }

    public ChartDataSetInfo[] getDataSetInfos() {
        return this.model.getDatasetInfos();
    }

    @Override
    public ChartNumericAxis getAxisY1() {
        return (ChartNumericAxis)this.axisY1;
    }

    @Override
    public ChartAxis getAxisX1() {
        return this.axisX1;
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        if (n >= 0 && n < this.charts.length) {
            return this.charts[n].getItemShapes();
        }
        return null;
    }

    @Override
    public void setXDimValue(Vector vector) {
        ((ChartCategoryAxis)this.axisX1).setDimValue(vector);
    }

    @Override
    public void setZDimValue(Vector vector) {
    }

    @Override
    public String[] getXLabels() {
        if (this.axisX1 == null) {
            return null;
        }
        return ((ChartCategoryAxis)this.axisX1).getLabelsForHtml();
    }

    @Override
    public String[] getYLabels() {
        if (this.axisY1 == null) {
            return null;
        }
        return ((ChartNumericAxis)this.axisY1).getLabelsForHtml();
    }

    @Override
    public String[] getY2Labels() {
        if (this.axisY2 == null) {
            return null;
        }
        return ((ChartNumericAxis)this.axisY2).getLabelsForHtml();
    }

    @Override
    public String[] getZLabels() {
        return null;
    }

    @Override
    public Shape[] getAxisYShapes() {
        if (this.axisY1 == null) {
            return null;
        }
        return this.axisY1.getAxisShapes();
    }

    @Override
    public Shape[] getAxisY2Shapes() {
        if (this.axisY2 == null) {
            return null;
        }
        return this.axisY2.getAxisShapes();
    }

    @Override
    public Shape[] getAxisXShapes() {
        if (this.axisX1 == null) {
            return null;
        }
        return this.axisX1.getAxisShapes();
    }

    @Override
    public int getAxisXLabelStep() {
        if (this.axisX1 == null) {
            return 1;
        }
        return this.axisX1.getAixsLabelStep();
    }

    @Override
    public Shape[] getAxisZShapes() {
        return null;
    }

    @Override
    public String getXDim() {
        return this.SEDU;
    }

    @Override
    public int[] getDrilldown() {
        return this.PLATFORM_PAPER_MARGINE;
    }

    public float getMeanLineStartX() {
        return this.OLD_PAPER_MARGINE;
    }

    @Override
    public String[] getDrilldownGroup() {
        String[] stringArray = new String[2];
        if (this.PLATFORM_PAPER_MARGINE != null) {
            if (this.model.isTurnedXZ()) {
                stringArray[0] = null;
                stringArray[1] = this.model.getSeriesName(this.PLATFORM_PAPER_MARGINE[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.PLATFORM_PAPER_MARGINE[0] % this.model.getSeriesCount()).toString());
            } else {
                stringArray[0] = this.model.getSeriesName(this.PLATFORM_PAPER_MARGINE[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.PLATFORM_PAPER_MARGINE[0] % this.model.getSeriesCount()).toString());
                stringArray[1] = this.model.getCategoryName(this.PLATFORM_PAPER_MARGINE[1]) == null ? null : this.model.getCategoryName(this.PLATFORM_PAPER_MARGINE[1]).toString();
            }
        }
        return stringArray;
    }

    public int formatLineNode(int n, int n2) {
        int n3 = 9;
        n3 = n2 == 0 ? n : n2;
        return n3;
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    private void allIsIntegerData(Graphics2D graphics2D) {
        if (this.axisX1 != null && this.axisX1.getStatus() == 1) {
            Line2D line2D = this.axisX1.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.axisX2 != null && this.axisX2.getStatus() == 1) {
            Line2D line2D = this.axisX2.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.axisY1 != null && this.axisY1.getStatus() == 1) {
            ChartDataSet chartDataSet = (ChartDataSet)this.add.get(0);
            int n = chartDataSet.getChartDataSetInfo().getChartType();
            int n2 = ChartTypeInfo.getPrimType(n);
            int n3 = ChartTypeInfo.getSubType(n);
            if (n2 == 5) {
                Line2D[] line2DArray = ((ChartNumericRadarAxis)this.axisY1).getRadarAxisAreaPath();
                for (int i = 0; i < line2DArray.length; ++i) {
                    ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[i]);
                }
            } else if (n2 == 6) {
                if (n3 == 256) {
                    Line2D[] line2DArray = ((Graph2DGuageBars)this.charts[0]).getAxisYShape();
                    for (int i = 0; i < line2DArray.length; ++i) {
                        ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[i]);
                    }
                } else if (n3 == 0) {
                    Shape[][] shapeArray = ((Graph2DGuageDials)this.charts[0]).getAxisPaths();
                    for (int i = 0; i < shapeArray.length; ++i) {
                        for (int j = 0; j < shapeArray[0].length; ++j) {
                            ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[i][j]);
                        }
                    }
                }
            } else {
                Line2D line2D = this.axisY1.getAxisAreaPath();
                ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            }
            return;
        }
        if (this.axisY2 != null && this.axisY2.getStatus() == 1) {
            Line2D line2D = this.axisY2.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.gridX1 != null && this.gridX1.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            Shape[] shapeArray = null;
            shapeArray = this.charts[0] instanceof Graph2DGuageBalls ? ((Graph2DGuageBalls)this.charts[0]).getVerticalGrid() : this.primLayer.getGridXPath();
            for (int i = 0; i < shapeArray.length; ++i) {
                ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[i]);
            }
            return;
        }
        if (this.gridZ != null && this.gridZ.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            Shape[] shapeArray = null;
            if (this.charts[0] instanceof Graph2DGuageBalls) {
                shapeArray = ((Graph2DGuageBalls)this.charts[0]).getHorizonalGrid();
            }
            int n = 0;
            if (shapeArray != null) {
                n = shapeArray.length;
            }
            for (int i = 0; i < n; ++i) {
                ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[i]);
            }
            return;
        }
        if (this.gridY1 != null && this.gridY1.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            ChartDataSet chartDataSet = (ChartDataSet)this.add.get(0);
            int n = chartDataSet.getChartDataSetInfo().getChartType();
            int n4 = ChartTypeInfo.getPrimType(n);
            int n5 = ChartTypeInfo.getSubType(n);
            if (n4 == 6) {
                if (n5 != 256 && n5 == 0) {
                    Shape[][] shapeArray = ((Graph2DGuageDials)this.charts[0]).getGridPath();
                    for (int i = 0; i < shapeArray.length; ++i) {
                        for (int j = 0; j < shapeArray[0].length; ++j) {
                            ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[i][j]);
                        }
                    }
                }
            } else {
                Line2D[] line2DArray = this.primLayer.getGridYPath();
                for (int i = 0; i < line2DArray.length; ++i) {
                    ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[i]);
                }
            }
            return;
        }
        if (this.gridX2 != null && this.gridX2.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            ChartPenStyle chartPenStyle = this.gridX2.getAxis().getProperties().getGridPen();
            Line2D[] line2DArray = this.secLayer.getGridXPath();
            for (int i = 0; i < line2DArray.length; ++i) {
                ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[i]);
            }
            return;
        }
        if (this.gridY2 != null && this.gridY2.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            ChartPenStyle chartPenStyle = this.gridY2.getAxis().getProperties().getGridPen();
            Line2D[] line2DArray = this.secLayer.getGridYPath();
            for (int i = 0; i < line2DArray.length; ++i) {
                ChartGraphicsUtil.drawSelectedShape(graphics2D, line2DArray[i]);
            }
            return;
        }
        if (this.wall != null && this.wall.getStatus() == 1 && this.selectedSeriesIndex == -1) {
            ChartPenStyle chartPenStyle = new ChartPenStyle(0, new ChartColorPattern(Color.black));
            GeneralPath generalPath = this.wallLayer.getWallPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.selectedSeriesIndex != -1 && this.charts[this.allLineArea].getStatus() == 1) {
            if (this.charts[this.allLineArea] instanceof Graph2DPie) {
                Shape[][] shapeArray = ((Graph2DPie)this.charts[this.allLineArea]).getItemShapesForDesigner();
                for (int i = 0; i < shapeArray.length; ++i) {
                    ChartGraphicsUtil.drawSelectedShape(graphics2D, shapeArray[i][this.selectedSeriesIndex]);
                }
            } else {
                Shape shape = this.charts[this.allLineArea].getShapeBySeries(this.selectedSeriesIndex);
                ChartGraphicsUtil.drawSelectedShape(graphics2D, shape);
            }
        }
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        this.selectedSeriesIndex = -1;
        if (this.contains(n, n2)) {
            this.searchSelectedSeriesIndex(n -= this.getBounds().x, n2 -= this.getBounds().y);
            if (this.primLayer != null) {
                if (this.axisX1 != null && this.primLayer.searchAxisX(n, n2)) {
                    this.axisX1.setType("x1");
                    return this.axisX1;
                }
                if (this.axisY1 != null && this.primLayer.searchAxisY(n, n2)) {
                    this.axisY1.setType("y1");
                    return this.axisY1;
                }
                if (this.allLineArea != -1 && this.selectedSeriesIndex != -1) {
                    if (this.charts[this.allLineArea] instanceof Graph2DPie) {
                        ((Graph2DPie)this.charts[0]).setSelectedObjectIndex(this.allLineArea);
                        ((Graph2DPie)this.charts[0]).setSelectedSeriesIndex(this.selectedSeriesIndex);
                    }
                    return this.charts[this.allLineArea];
                }
                if (this.charts[0] instanceof Graph2DPie) {
                    ((Graph2DPie)this.charts[0]).setSelectedObjectIndex(-1);
                } else if (this.charts[0] instanceof Graph2DGuageBars) {
                    if (((Graph2DGuageBars)this.charts[0]).searchAxisY(n, n2)) {
                        this.axisY1.setType("y1");
                        return this.axisY1;
                    }
                } else if (this.charts[0] instanceof Graph2DGuageDials) {
                    if (((Graph2DGuageDials)this.charts[0]).searchGrid(n, n2)) {
                        this.gridY1.setType("y1");
                        return this.gridY1;
                    }
                    if (((Graph2DGuageDials)this.charts[0]).searchAxis(n, n2)) {
                        this.axisY1.setType("y1");
                        return this.axisY1;
                    }
                } else if (this.charts[0] instanceof Graph2DGuageBalls) {
                    if (((Graph2DGuageBalls)this.charts[0]).searchHorizonalGrid(n, n2)) {
                        this.gridZ.setType("z");
                        return this.gridZ;
                    }
                    if (((Graph2DGuageBalls)this.charts[0]).searchVerticalGrid(n, n2)) {
                        this.gridX1.setType("x1");
                        return this.gridX1;
                    }
                }
                if (this.gridX1 != null && this.primLayer.searchGridX(n, n2)) {
                    this.gridX1.setType("x1");
                    this.gridX1.setAxis(this.axisX1);
                    return this.gridX1;
                }
                if (this.gridY1 != null && this.primLayer.searchGridY(n, n2)) {
                    this.gridY1.setType("y1");
                    this.gridY1.setAxis(this.axisY1);
                    return this.gridY1;
                }
            }
            if (this.secLayer != null) {
                if (this.axisX2 != null && this.secLayer.searchAxisX(n, n2)) {
                    this.axisX2.setType("x2");
                    return this.axisX2;
                }
                if (this.axisY2 != null && this.secLayer.searchAxisY(n, n2)) {
                    this.axisY2.setType("y2");
                    return this.axisY2;
                }
                if (this.allLineArea != -1 && this.selectedSeriesIndex != -1) {
                    return this.charts[this.allLineArea];
                }
                if (this.gridX2 != null && this.secLayer.searchGridX(n, n2)) {
                    this.gridX2.setType("x2");
                    this.gridX2.setAxis(this.axisX2);
                    return this.gridX2;
                }
                if (this.gridY2 != null && this.secLayer.searchGridY(n, n2)) {
                    this.gridY2.setType("y2");
                    this.gridY2.setAxis(this.axisY2);
                    return this.gridY2;
                }
            }
            if (this.wallLayer != null && this.wallLayer.searchWall(n, n2)) {
                return this.wall;
            }
            return this;
        }
        return null;
    }

    @Override
    public Vector getChartObjects() {
        if (this.charts.length == 0) {
            return null;
        }
        Vector<ChartObject> vector = new Vector<ChartObject>();
        vector.add(this);
        if (this.axisX1 != null) {
            this.axisX1.setType("x1");
            vector.add(this.axisX1);
        }
        if (this.axisX2 != null) {
            this.axisX2.setType("x2");
            vector.add(this.axisX2);
        }
        if (this.axisY1 != null && !(this.charts[0] instanceof Graph2DGuageBalls)) {
            this.axisY1.setType("y1");
            vector.add(this.axisY1);
        }
        if (this.axisY2 != null) {
            this.axisY2.setType("y2");
            vector.add(this.axisY2);
        }
        if (this.axisX1 != null && this.gridX1 != null) {
            this.gridX1.setType("x1");
            vector.add(this.gridX1);
        }
        if (this.axisX2 != null && this.gridX2 != null) {
            this.gridX2.setType("x2");
            vector.add(this.gridX2);
        }
        if (this.axisY1 != null && this.gridY1 != null && !(this.charts[0] instanceof Graph2DGuageBalls) && !(this.charts[0] instanceof Graph2DGuageBars)) {
            this.gridY1.setType("y1");
            vector.add(this.gridY1);
        }
        if (this.axisY2 != null && this.gridY2 != null) {
            this.gridY2.setType("y2");
            vector.add(this.gridY2);
        }
        if (this.charts[0] instanceof Graph2DGuageBalls && this.gridX1 != null) {
            this.gridX1.setType("x1");
            vector.add(this.gridX1);
        }
        if (this.charts[0] instanceof Graph2DGuageBalls && this.gridZ != null) {
            this.gridZ.setType("z");
            vector.add(this.gridZ);
        }
        if (this.wall != null) {
            this.wall.setType("xy");
            vector.add(this.wall);
        }
        return vector;
    }

    @Override
    public Rectangle getGraphArea() {
        return this.graphArea;
    }

    public int getLineLegendIconDescent(ChartDataSet chartDataSet) {
        int n = chartDataSet.getDataSetIndex();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += ((ChartDataSet)this.datasets.get(i)).getLegendSeriesLabels().size();
        }
        return n2;
    }

    private boolean allLineArea(Graph2DBar graph2DBar) {
        return graph2DBar.getChartDataSet().getSeriesSize() == 1;
    }

    private boolean append() {
        for (int i = 0; i < this.datasets.size(); ++i) {
            ChartDataSetInfo chartDataSetInfo = ((ChartDataSet)this.datasets.get(i)).getChartDataSetInfo();
            int n = chartDataSetInfo.getChartType();
            int n2 = ChartTypeInfo.getPrimType(n);
            if (n2 != 9 && n2 != 8 && n2 != 10 && n2 != 11) continue;
            return false;
        }
        return true;
    }

    private void axisX() {
        int n = this.charts.length;
        for (int i = 0; i < n; ++i) {
            ChartDataSet chartDataSet = (ChartDataSet)this.datasets.get(i);
            int n2 = chartDataSet.getChartDataSetInfo().getChartType();
            int n3 = ChartTypeInfo.getPrimType(n2);
            if (n3 != 3 && n3 != 0 && n3 != 1 && n3 != 2 && n3 != 11) continue;
            this.calculatePercentMinMaxPercentOfCategory = true;
            return;
        }
        this.calculatePercentMinMaxPercentOfCategory = false;
    }

    public boolean canUseDepth() {
        return this.calculateAxisPlot;
    }

    @Override
    public Vector getLineChartSizeInfo() {
        return this.lineChartSizeInfo;
    }

    public boolean isSupportLabelOnTickmark() {
        return this.calculatePercentMinMaxPercentOfCategory;
    }

    public boolean isScrollChart() {
        return this.calculateMinMax;
    }

    public boolean hasBench() {
        return this.contains;
    }

    public boolean isLabelOnTickMark() {
        return this.convertUnitToPixel;
    }

    public boolean useScrollChart() {
        return this.getProperties().getAxisXProperties().getScrollableChart();
    }

    @Override
    public int getSelectShowValueAxisType(int n, int n2) {
        if (this.contains(n, n2)) {
            this.searchSelectedSeriesIndex(n - this.getBounds().x, n2 - this.getBounds().y);
            if (this.allLineArea >= 0 && this.allLineArea < this.datasets.size()) {
                return ((ChartDataSet)this.datasets.get(this.allLineArea)).getChartDataSetInfo().getAxisInfo();
            }
        }
        return 0;
    }

    public ChartRenderInfo getRenderInfo() {
        return this.allIsIntegerData;
    }

    protected boolean isCustommerConstantAxis(List list) {
        boolean bl = false;
        if (list != null && list.size() >= 1) {
            for (int i = 0; i < list.size(); ++i) {
                ChartDataSet chartDataSet = (ChartDataSet)list.get(i);
                int n = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
                int n2 = ChartTypeInfo.getEffect(chartDataSet.getChartDataSetInfo().getChartType());
                if (n2 != 0 || n != 0 && n != 1 && n != 2 && n != 3) {
                    bl = false;
                    break;
                }
                bl = true;
                if (!chartDataSet.isNullData()) continue;
                bl = false;
            }
        }
        return bl;
    }

    public Vector getCharts() {
        Vector<Chart2DObject> vector = new Vector<Chart2DObject>();
        if (this.charts != null) {
            for (int i = 0; i < this.charts.length; ++i) {
                vector.add(this.charts[i]);
            }
        }
        return vector;
    }

    boolean isConstantCategory(List list) {
        if (list != null && list.size() > 0) {
            if (list.get(0) instanceof Number) {
                return true;
            }
            if (list.get(0) instanceof Date) {
                return true;
            }
        }
        return false;
    }

    void setConstantFilterName() {
        Object e;
        int n;
        int n2;
        List list;
        Object[] objectArray;
        if (this.constantIndex != null && !this.isScrollChart()) {
            return;
        }
        if (this.getAxisX1() != null && this.getAxisX1().getConstantStartEnd() != null) {
            objectArray = this.getAxisX1().getConstantStartEnd();
            list = this.getChartPlatform().getDataSetModel().getCategoryNames();
            n2 = list.size();
            if (this.isScrollChart()) {
                // empty if block
            }
            if (objectArray[0] instanceof Number) {
                this.constantIndex = new int[]{-1, -1};
                for (n = 0; n < n2; ++n) {
                    e = list.get(n);
                    if (!(e instanceof Number) || !(((Number)e).floatValue() >= ((Number)objectArray[0]).floatValue())) continue;
                    this.constantIndex[0] = n;
                    break;
                }
                this.constantIndex[1] = this.constantIndex[0];
                for (n = n2 - 1; n >= 0; --n) {
                    e = list.get(n);
                    if (!(e instanceof Number) || !(((Number)e).floatValue() <= ((Number)objectArray[1]).floatValue())) continue;
                    this.constantIndex[1] = n;
                    break;
                }
            } else if (objectArray[0] instanceof Date) {
                this.constantIndex = new int[]{-1, -1};
                for (n = 0; n < n2; ++n) {
                    e = list.get(n);
                    if (!(e instanceof Date) || ((Date)e).before((Date)objectArray[0])) continue;
                    this.constantIndex[0] = n;
                    break;
                }
                this.constantIndex[1] = this.constantIndex[0];
                for (n = n2 - 1; n >= 0; --n) {
                    e = list.get(n);
                    if (!(e instanceof Date) || ((Date)e).after((Date)objectArray[1])) continue;
                    this.constantIndex[1] = n;
                    break;
                }
            }
            if (this.constantIndex != null && (this.constantIndex[0] == -1 || this.constantIndex[1] == -1)) {
                this.constantIndex = null;
            }
        }
        if (this.getAxisX2() != null && this.getAxisX2().getConstantStartEnd() != null) {
            objectArray = this.getAxisX2().getConstantStartEnd();
            list = this.getChartPlatform().getDataSetModel().getCategoryNames();
            n2 = list.size();
            if (this.isScrollChart()) {
                // empty if block
            }
            if (objectArray[0] instanceof Number) {
                this.constantIndex = new int[]{-1, -1};
                for (n = 0; n < n2; ++n) {
                    e = list.get(n);
                    if (!(e instanceof Number) || !(((Number)e).floatValue() >= ((Number)objectArray[0]).floatValue())) continue;
                    this.constantIndex[0] = n;
                    break;
                }
                this.constantIndex[1] = this.constantIndex[0];
                for (n = n2 - 1; n >= 0; --n) {
                    e = list.get(n);
                    if (!(e instanceof Number) || !(((Number)e).floatValue() <= ((Number)objectArray[1]).floatValue())) continue;
                    this.constantIndex[1] = n;
                    break;
                }
            } else if (objectArray[0] instanceof Date) {
                this.constantIndex = new int[]{-1, -1};
                for (n = 0; n < n2; ++n) {
                    e = list.get(n);
                    if (!(e instanceof Date) || ((Date)e).before((Date)objectArray[0])) continue;
                    this.constantIndex[0] = n;
                    break;
                }
                this.constantIndex[1] = this.constantIndex[0];
                for (n = n2 - 1; n >= 0; --n) {
                    e = list.get(n);
                    if (!(e instanceof Date) || ((Date)e).after((Date)objectArray[1])) continue;
                    this.constantIndex[1] = n;
                    break;
                }
            }
            if (this.constantIndex != null && (this.constantIndex[0] == -1 || this.constantIndex[1] == -1)) {
                this.constantIndex = null;
            }
        }
    }

    @Override
    public int[] getFilterConstant() {
        if (this.constantIndex != null) {
            return this.constantIndex;
        }
        return super.getFilterConstant();
    }

    public ChartNumericAxis getAxisY2() {
        return (ChartNumericAxis)this.axisY2;
    }

    public ChartAxis getAxisX2() {
        return this.axisX2;
    }

    public Rectangle getScaledGraphArea() {
        if (this.graphArea != null && this.properties != null) {
            float f = this.properties.getScaleX();
            float f2 = this.properties.getScaleY();
            Rectangle rectangle = (Rectangle)this.graphArea.clone();
            int n = (int)((float)rectangle.width * (1.0f - f) / 2.0f);
            int n2 = (int)((float)rectangle.height * (1.0f - f2) / 2.0f);
            rectangle.x += n;
            rectangle.width -= 2 * n;
            rectangle.y += n2;
            rectangle.height -= 2 * n2;
            return rectangle;
        }
        return this.graphArea;
    }

    @Override
    public int[] getLinkInfo(int n, int n2) {
        int n3;
        int n4;
        int[] nArray = null;
        int n5 = this.charts.length;
        if (this.properties.isReversePaintingOrder()) {
            for (n4 = 0; n4 < n5; ++n4) {
                nArray = this.charts[n4].searchLinkInfo(n, n2);
                if (nArray == null || nArray[0] == -1 && nArray[1] == -1 && nArray[2] == -1) continue;
                return nArray;
            }
        } else {
            for (n4 = n5 - 1; n4 >= 0; --n4) {
                nArray = this.charts[n4].searchLinkInfo(n, n2);
                if (nArray == null || nArray[0] == -1 && nArray[1] == -1 && nArray[2] == -1) continue;
                return nArray;
            }
        }
        n4 = -1;
        n4 = this.axisX1(n, n2);
        if (n4 != -1 && this.platform.getShowValueConditions().getXLink() != null && (nArray = n4 < (n3 = this.platform.getShowValueConditions().getXLink().size()) ? ((ChartDataUsedInfo)this.platform.getShowValueConditions().getXLink().get(n4)).getChartLinkInfo() : ((ChartDataUsedInfo)this.platform.getShowValueConditions().getXLink().get(n3 - 1)).getChartLinkInfo()) != null && (nArray[0] != -1 || nArray[1] != -1 || nArray[2] != -1)) {
            return nArray;
        }
        return nArray;
    }

    private int axisX1(int n, int n2) {
        int n3 = -1;
        if (this.primLayer != null) {
            if (this.axisX1 != null && this.axisX1.custommerConstant()) {
                return n3;
            }
            int n4 = n3 = this.axisX1 != null ? this.axisX1.searchAxisLabelIndex(n, n2) : -1;
        }
        if (this.secLayer != null) {
            if (this.axisX2 != null && this.axisX2.custommerConstant()) {
                return n3;
            }
            int n5 = n3 = this.axisX2 != null ? this.axisX2.searchAxisLabelIndex(n, n2) : -1;
        }
        if (n3 != -1 && this.platform != null) {
            n3 += this.platform.showScrollLabelStart();
        }
        return n3;
    }
}

