/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartCoordinatePaper;
import chart.ChartLabelBase;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DSimplePaper;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.graphics.ChartBackground;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartLabelProperties;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.plaf.basic.BasicArrowButton;

public class Chart2DScrollbar
extends Chart2DObject {
    protected float[][] vertex;
    protected float[][] tVertex;
    protected float unitX;
    protected float unitY;
    protected Rectangle rec = null;
    protected float[][] scrollVertex;
    protected GeneralPath scrollPath = new GeneralPath();
    protected float[][] lScrollVertex;
    protected float[][] rScrollVertex;
    protected Rectangle lScrollPath = null;
    protected Rectangle rScrollPath = null;
    float leftLength;
    float rightLength;
    boolean init = false;
    boolean locate = false;
    ChartBackground leftIcon;
    ChartBackground rightIcon;
    ChartBackground scrollbar;
    boolean isbench;
    int iconWidth = 7;
    int iconHeight = 20;
    protected float[][] leftMoveIcon;
    protected float[][] rightMoveIcon;
    protected GeneralPath leftMoveIconP = new GeneralPath();
    protected GeneralPath rightMoveIconP = new GeneralPath();
    protected static final int MOVEICONTYPE_TRIANGLE = 0;
    protected static final int MOVEICONTYPE_RECTANGLE = 1;
    protected ChartLabelBase startLbl;
    protected ChartLabelBase endLbl;
    protected float[] startLblPos;
    protected float[] endLblPos;
    protected Rectangle lRect;
    protected Rectangle rRect;
    protected int mouseX = -1;
    protected int mouseY = -1;
    protected ChartGradientPattern iconFill;
    protected ChartDataFilter labelFilter = null;
    protected ChartColorPattern spareLineC = null;
    protected ChartTextStyle textSty = null;
    private boolean SEDU = false;
    float[] scrollInfo = null;

    public Chart2DScrollbar(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        if (!this.init) {
            this.vertex = new float[4][2];
            this.tVertex = new float[4][2];
            this.scrollVertex = new float[4][2];
            this.lScrollVertex = new float[4][2];
            this.rScrollVertex = new float[4][2];
            this.initIconFillColor();
            this.leftIcon = new ChartBackground();
            this.rightIcon = new ChartBackground();
            this.leftIcon.setPattern(this.iconFill);
            this.rightIcon.setPattern(this.iconFill);
            ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(90, 90, 90));
            chartColorPattern.setAlpha(0.3f);
            this.leftIcon.setBorderColor(chartColorPattern);
            this.leftIcon.setBorderStyle(1);
            this.rightIcon.setBorderStyle(1);
            this.scrollbar = new ChartBackground(null);
            this.rightIcon.setBorderColor(chartColorPattern);
            this.scrollbar.setBorderStyle(2);
            this.leftMoveIcon = new float[3][2];
            this.rightMoveIcon = new float[3][2];
            this.init = true;
            this.SEDU();
            this.startLblPos = new float[2];
            this.endLblPos = new float[2];
            this.lRect = new Rectangle();
            this.rRect = new Rectangle();
            this.lScrollPath = new Rectangle();
            this.rScrollPath = new Rectangle();
            this.spareLineC = new ChartColorPattern(new Color(186, 186, 186));
        }
    }

    void initIconFillColor() {
        if (this.iconFill != null) {
            return;
        }
        if (!this.isbench) {
            ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(241, 241, 241));
            ChartColorPattern chartColorPattern2 = new ChartColorPattern(new Color(182, 182, 182));
            Point2D.Float float_ = new Point2D.Float(0.14f, 0.05f);
            Point2D.Float float_2 = new Point2D.Float(0.86f, 0.95f);
            this.iconFill = new ChartGradientPattern(1, true, chartColorPattern, float_, chartColorPattern2, float_2);
        } else {
            ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(241, 241, 241));
            ChartColorPattern chartColorPattern3 = new ChartColorPattern(new Color(182, 182, 182));
            Point2D.Float float_ = new Point2D.Float(0.14f, 0.14f);
            Point2D.Float float_3 = new Point2D.Float(0.86f, 0.86f);
            this.iconFill = new ChartGradientPattern(1, true, chartColorPattern3, float_, chartColorPattern, float_3);
        }
    }

    private void SEDU() {
        ChartLabelProperties chartLabelProperties = new ChartLabelProperties();
        ChartLabelProperties chartLabelProperties2 = new ChartLabelProperties();
        ChartTextStyle chartTextStyle = new ChartTextStyle();
        ChartTextStyle chartTextStyle2 = new ChartTextStyle();
        chartTextStyle.setFontSize(10);
        chartTextStyle.setFontColor(new ChartColorPattern(new Color(0, 0, 0)));
        chartTextStyle2.setFontSize(10);
        chartTextStyle2.setFontColor(new ChartColorPattern(new Color(0, 0, 0)));
        chartLabelProperties.setTextStyle(chartTextStyle);
        chartLabelProperties2.setTextStyle(chartTextStyle2);
        this.startLbl = new ChartLabelBase("", chartLabelProperties);
        this.endLbl = new ChartLabelBase("", chartLabelProperties2);
    }

    protected void resetLabelTextStyle() {
        if (this.textSty != null && this.startLbl != null && this.endLbl != null) {
            ChartTextStyle chartTextStyle = (ChartTextStyle)this.textSty.clone();
            if (chartTextStyle.getFontName() != null) {
                this.startLbl.getChartTextStyle().setFontName(chartTextStyle.getFontName());
                this.endLbl.getChartTextStyle().setFontName(chartTextStyle.getFontName());
            }
            if (chartTextStyle.getFontColor() != null) {
                this.startLbl.getChartTextStyle().setFontColor(chartTextStyle.getFontColor());
                this.endLbl.getChartTextStyle().setFontColor(chartTextStyle.getFontColor());
            }
        }
    }

    public void setScrollInfo(float[] fArray2) {
        if (fArray2 == null || this.vertex == null) {
            return;
        }
        if (fArray2.length == 2) {
            float f = fArray2[0];
            float f2 = fArray2[1];
            f = f < 0.0f ? 0.0f : f;
            f = f > 1.0f ? 1.0f : f;
            f2 = f2 > 1.0f ? 1.0f : f2;
            float f3 = f2 = f2 < 0.0f ? 0.0f : f2;
            if (f > f2) {
                f += f2;
                f2 = f - f2;
                f -= f2;
            }
            if (this.scrollInfo == null) {
                this.scrollInfo = new float[2];
            }
            this.scrollInfo[0] = f;
            this.scrollInfo[1] = f2;
            this.SEDU = true;
        }
    }

    public void setBounds(Rectangle rectangle) {
        if (!this.locate) {
            this.rec = rectangle;
            this.vertex[0][0] = 0.0f;
            this.vertex[0][1] = 0.0f;
            this.vertex[1][0] = rectangle.width;
            this.vertex[1][1] = 0.0f;
            this.vertex[2][0] = rectangle.width;
            this.vertex[2][1] = rectangle.height;
            this.vertex[3][0] = 0.0f;
            this.vertex[3][1] = rectangle.height;
            float[] fArray2 = this.paper.platform.getScrollbarInfo();
            float f = 0.0f;
            if (fArray2 != null) {
                f = fArray2[1] - fArray2[0];
            }
            f = f < 0.0f ? 0.0f : f;
            f = f > 1.0f ? 1.0f : f;
            float f2 = 0.0f;
            float f3 = 1.0f;
            if (!this.isbench) {
                int n = (int)((float)rectangle.width * f);
                if (this.paper.getChartPlatform().getScrollbarInfo() != null) {
                    f2 = fArray2[0] * (float)rectangle.width;
                    n = (int)(f * (float)rectangle.width);
                }
                this.scrollVertex[0][0] = 0.0f + f2;
                this.scrollVertex[0][1] = 2.0f;
                this.scrollVertex[1][0] = this.scrollVertex[0][0] + (float)n;
                this.scrollVertex[1][1] = 2.0f;
                this.scrollVertex[2][0] = this.scrollVertex[0][0] + (float)n;
                this.scrollVertex[2][1] = this.vertex[2][1] - 2.0f;
                this.scrollVertex[3][0] = this.scrollVertex[0][0];
                this.scrollVertex[3][1] = this.vertex[2][1] - 2.0f;
            } else {
                int n = (int)((float)rectangle.height * f);
                if (fArray2 != null) {
                    f2 = (1.0f - fArray2[0]) * (float)rectangle.height;
                    n = (int)(f * (float)rectangle.height);
                }
                this.scrollVertex[1][1] = f2;
                this.scrollVertex[1][0] = 0.0f;
                this.scrollVertex[0][1] = this.scrollVertex[1][1] - (float)n;
                this.scrollVertex[0][0] = 0.0f;
                this.scrollVertex[2][1] = f2;
                this.scrollVertex[2][0] = rectangle.width;
                this.scrollVertex[3][1] = this.scrollVertex[2][1] - (float)n;
                this.scrollVertex[3][0] = rectangle.width;
            }
            this.locate = true;
        }
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        if (this.scrollVertex != null) {
            if (!this.isbench) {
                float_.x = this.scrollVertex[0][0] < this.scrollVertex[2][0] ? this.scrollVertex[0][0] : this.scrollVertex[2][0];
                float_.y = this.scrollVertex[0][1] < this.scrollVertex[2][1] ? this.scrollVertex[0][1] : this.scrollVertex[2][1];
                float_.width = Math.abs(this.scrollVertex[0][0] - this.scrollVertex[2][0]);
                float_.height = Math.abs(this.scrollVertex[0][1] - this.scrollVertex[2][1]);
            } else {
                float_.x = this.scrollVertex[0][0] < this.scrollVertex[2][0] ? this.scrollVertex[0][0] : this.scrollVertex[2][0];
                float_.y = this.scrollVertex[0][1] < this.scrollVertex[2][1] ? this.scrollVertex[0][1] : this.scrollVertex[2][1];
                float_.width = Math.abs(this.scrollVertex[0][0] - this.scrollVertex[2][0]);
                float_.height = Math.abs(this.scrollVertex[0][1] - this.scrollVertex[2][1]);
            }
        }
        return float_;
    }

    @Override
    Shape[][] getItemShapes() {
        return null;
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public String[] search(int n, int n2) {
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    @Override
    public void locate() {
        this.layer.transform(this.vertex, this.tVertex);
        this.scrollPath.reset();
        if (this.SEDU && this.scrollInfo != null) {
            if (!this.isbench) {
                this.scrollVertex[0][0] = this.vertex[0][0] + Math.abs(this.vertex[2][0] - this.vertex[0][0]) * this.scrollInfo[0];
                this.scrollVertex[0][1] = this.scrollVertex[0][1];
                this.scrollVertex[1][0] = this.vertex[0][0] + Math.abs(this.vertex[2][0] - this.vertex[0][0]) * this.scrollInfo[1];
                this.scrollVertex[1][1] = this.scrollVertex[1][1];
                this.scrollVertex[2][0] = this.vertex[0][0] + Math.abs(this.vertex[2][0] - this.vertex[0][0]) * this.scrollInfo[1];
                this.scrollVertex[2][1] = this.scrollVertex[2][1];
                this.scrollVertex[3][0] = this.vertex[0][0] + Math.abs(this.vertex[2][0] - this.vertex[0][0]) * this.scrollInfo[0];
                this.scrollVertex[3][1] = this.scrollVertex[3][1];
                this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
                this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
                this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
                this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
                this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
                this.scrollPath.closePath();
            } else {
                this.scrollVertex[0][1] = this.vertex[2][1] - Math.abs(this.vertex[2][1] - this.vertex[0][1]) * this.scrollInfo[1];
                this.scrollVertex[1][1] = this.vertex[2][1] - Math.abs(this.vertex[2][1] - this.vertex[0][1]) * this.scrollInfo[0];
                this.scrollVertex[2][1] = this.vertex[2][1] - Math.abs(this.vertex[2][1] - this.vertex[0][1]) * this.scrollInfo[0];
                this.scrollVertex[3][1] = this.vertex[2][1] - Math.abs(this.vertex[2][1] - this.vertex[0][1]) * this.scrollInfo[1];
                if (this.scrollVertex[0][1] > this.vertex[2][1]) {
                    this.scrollVertex[0][1] = this.vertex[2][1];
                    this.scrollVertex[3][1] = this.scrollVertex[0][1];
                }
                if (this.scrollVertex[0][1] < this.vertex[0][1]) {
                    this.scrollVertex[0][1] = this.vertex[0][1];
                    this.scrollVertex[3][1] = this.scrollVertex[0][1];
                }
                if (this.scrollVertex[1][1] > this.vertex[2][1]) {
                    this.scrollVertex[1][1] = this.vertex[2][1];
                    this.scrollVertex[2][1] = this.scrollVertex[1][1];
                }
                if (this.scrollVertex[1][1] < this.vertex[0][1]) {
                    this.scrollVertex[1][1] = this.vertex[0][1];
                    this.scrollVertex[2][1] = this.scrollVertex[1][1];
                }
                this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
                this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
                this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
                this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
                this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
                this.scrollPath.closePath();
            }
            this.SEDU = false;
        } else if (!this.isbench) {
            this.scrollVertex[0][0] = this.scrollVertex[0][0] + this.leftLength < this.vertex[0][0] ? this.vertex[0][0] : this.scrollVertex[0][0] + this.leftLength;
            this.scrollVertex[0][1] = this.scrollVertex[0][1];
            this.scrollVertex[1][0] = this.scrollVertex[1][0] + this.rightLength;
            this.scrollVertex[1][0] = this.scrollVertex[1][0] > this.vertex[2][0] ? this.vertex[2][0] : this.scrollVertex[1][0];
            this.scrollVertex[1][1] = this.scrollVertex[1][1];
            this.scrollVertex[2][0] = this.scrollVertex[2][0] + this.rightLength;
            this.scrollVertex[2][0] = this.scrollVertex[2][0] > this.vertex[2][0] ? this.vertex[2][0] : this.scrollVertex[2][0];
            this.scrollVertex[2][1] = this.scrollVertex[2][1];
            this.scrollVertex[3][0] = this.scrollVertex[3][0] + this.leftLength < this.vertex[0][0] ? this.vertex[0][0] : this.scrollVertex[3][0] + this.leftLength;
            this.scrollVertex[3][1] = this.scrollVertex[3][1];
            this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
            this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
            this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
            this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.closePath();
        } else {
            this.scrollVertex[0][1] = this.scrollVertex[0][1] + this.leftLength < this.vertex[0][1] ? this.vertex[0][1] : this.scrollVertex[0][1] + this.leftLength;
            this.scrollVertex[0][0] = this.scrollVertex[0][0];
            this.scrollVertex[1][1] = this.scrollVertex[1][1] + this.rightLength;
            this.scrollVertex[1][1] = this.scrollVertex[1][1] > this.vertex[2][1] ? this.vertex[2][1] : this.scrollVertex[1][1];
            this.scrollVertex[1][0] = this.scrollVertex[1][0];
            this.scrollVertex[2][1] = this.scrollVertex[2][1] + this.rightLength;
            this.scrollVertex[2][1] = this.scrollVertex[2][1] > this.vertex[2][1] ? this.vertex[2][1] : this.scrollVertex[2][1];
            this.scrollVertex[2][0] = this.scrollVertex[2][0];
            this.scrollVertex[3][1] = this.scrollVertex[3][1] + this.leftLength < this.vertex[0][1] ? this.vertex[0][1] : this.scrollVertex[3][1] + this.leftLength;
            this.scrollVertex[3][0] = this.scrollVertex[3][0];
            this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
            this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
            this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
            this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.closePath();
        }
        this.contains();
        this.abs();
        this.locateLabel();
    }

    private void abs() {
        if (this.lRect == null || this.rRect == null) {
            return;
        }
        this.leftMoveIconP.reset();
        this.rightMoveIconP.reset();
        if (!this.isbench) {
            this.leftMoveIconP.moveTo(this.lRect.x + 2, this.lRect.y + this.lRect.height / 2);
            this.leftMoveIconP.lineTo(this.lRect.x + this.lRect.width - 2, this.lRect.y + this.lRect.height / 2 + this.lRect.height / 5);
            this.leftMoveIconP.lineTo(this.lRect.x + this.lRect.width - 2, this.lRect.y + this.lRect.height / 2 - this.lRect.height / 5);
            this.leftMoveIconP.closePath();
            this.rightMoveIconP.moveTo(this.rRect.x + this.rRect.width - 2, this.rRect.y + this.rRect.height / 2);
            this.rightMoveIconP.lineTo(this.rRect.x + 2, this.rRect.y + this.rRect.height / 2 - this.rRect.height / 5);
            this.rightMoveIconP.lineTo(this.rRect.x + 2, this.rRect.y + this.rRect.height / 2 + this.rRect.height / 5);
            this.rightMoveIconP.closePath();
        } else {
            this.leftMoveIconP.moveTo(this.lRect.x + this.lRect.width / 2, this.lRect.y + this.lRect.height - 2);
            this.leftMoveIconP.lineTo(this.lRect.x + this.lRect.width / 2 - this.lRect.width / 5, this.lRect.y + 2);
            this.leftMoveIconP.lineTo(this.lRect.x + this.lRect.width / 2 + this.lRect.width / 5, this.lRect.y + 2);
            this.leftMoveIconP.closePath();
            this.rightMoveIconP.moveTo(this.rRect.x + this.rRect.width / 2, this.rRect.y + 2);
            this.rightMoveIconP.lineTo(this.rRect.x + this.lRect.width / 2 - this.lRect.width / 5, this.rRect.y + this.rRect.height - 2);
            this.rightMoveIconP.lineTo(this.rRect.x + this.lRect.width / 2 + this.lRect.width / 5, this.rRect.y + this.rRect.height - 2);
            this.rightMoveIconP.closePath();
        }
    }

    private float[][] black(float f, float f2, int n, int n2, int n3, boolean bl, boolean bl2) {
        float[][] fArray2 = null;
        switch (n) {
            case 0: {
                fArray2 = new float[3][2];
                if (bl) {
                    if (!bl2) {
                        fArray2[0][0] = f + (float)(n2 / 2);
                        fArray2[0][1] = f2 - (float)((double)n2 / Math.sqrt(3.0));
                        fArray2[1][0] = f + (float)(n2 / 2);
                        fArray2[1][1] = f2 + (float)((double)n2 / Math.sqrt(3.0));
                        fArray2[2][0] = f - (float)(n2 / 2);
                        fArray2[2][1] = f2;
                        break;
                    }
                    fArray2[0][0] = f;
                    fArray2[0][1] = f2 - (float)(n2 / 2);
                    fArray2[1][0] = f + (float)((double)n2 / Math.sqrt(3.0));
                    fArray2[1][1] = f2 + (float)(n2 / 2);
                    fArray2[2][0] = f - (float)((double)n2 / Math.sqrt(3.0));
                    fArray2[2][1] = f2 + (float)(n2 / 2);
                    break;
                }
                if (!bl2) {
                    fArray2[0][0] = f - (float)(n2 / 2);
                    fArray2[0][1] = f2 - (float)((double)n2 / Math.sqrt(3.0));
                    fArray2[1][0] = f - (float)(n2 / 2);
                    fArray2[1][1] = f2 + (float)((double)n2 / Math.sqrt(3.0));
                    fArray2[2][0] = f + (float)(n2 / 2);
                    fArray2[2][1] = f2;
                    break;
                }
                fArray2[0][0] = f;
                fArray2[0][1] = f2 + (float)(n2 / 2);
                fArray2[1][0] = f + (float)((double)n2 / Math.sqrt(3.0));
                fArray2[1][1] = f2 - (float)(n2 / 2);
                fArray2[2][0] = f - (float)((double)n2 / Math.sqrt(3.0));
                fArray2[2][1] = f2 - (float)(n2 / 2);
                break;
            }
            case 1: {
                fArray2 = new float[4][2];
                fArray2[0][0] = f - (float)(n2 / 2);
                fArray2[0][1] = f2 - (float)(n3 / 2);
                fArray2[1][0] = f + (float)(n2 / 2);
                fArray2[1][1] = f2 - (float)(n3 / 2);
                fArray2[2][0] = f + (float)(n2 / 2);
                fArray2[2][1] = f2 + (float)(n3 / 2);
                fArray2[3][0] = f - (float)(n2 / 2);
                fArray2[3][1] = f2 + (float)(n3 / 2);
                break;
            }
        }
        return fArray2;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.custommerConstant(graphics2D);
        this.clone(graphics2D);
        this.paintLabel(graphics2D);
    }

    private void clone(Graphics2D graphics2D) {
        if (this.lRect != null && this.rRect != null) {
            BasicArrowButton basicArrowButton = null;
            BasicArrowButton basicArrowButton2 = null;
            if (!this.isbench) {
                basicArrowButton = new BasicArrowButton(7);
                basicArrowButton2 = new BasicArrowButton(3);
            } else {
                basicArrowButton = new BasicArrowButton(5);
                basicArrowButton2 = new BasicArrowButton(1);
            }
            basicArrowButton.setBounds(0, 0, this.lRect.width, this.lRect.height);
            basicArrowButton2.setBounds(0, 0, this.rRect.width, this.rRect.height);
            basicArrowButton.updateUI();
            basicArrowButton2.updateUI();
            try {
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(this.lRect.x, this.lRect.y, this.lRect.width + 2, this.lRect.height + 2);
                basicArrowButton.paint(graphics2D2);
                graphics2D2 = (Graphics2D)graphics2D.create(this.rRect.x, this.rRect.y, this.rRect.width + 2, this.rRect.height + 2);
                basicArrowButton2.paint(graphics2D2);
            }
            catch (Exception exception) {
                this.leftIcon.paintBackground(graphics2D, this.lRect);
                this.rightIcon.paintBackground(graphics2D, this.rRect);
            }
        }
    }

    private void closePath(Graphics2D graphics2D) {
        graphics2D.setColor(new Color(64, 64, 64));
        graphics2D.fill(this.leftMoveIconP);
        graphics2D.fill(this.rightMoveIconP);
    }

    private void contains() {
        if (this.scrollVertex == null) {
            return;
        }
        if (!this.isbench) {
            int n = (int)Math.abs(this.scrollVertex[3][1] - this.scrollVertex[0][1]);
            n = (n = (int)((float)(n - 15) * 0.5f)) > this.iconHeight ? this.iconHeight : n;
            int n2 = (int)((Math.abs(this.scrollVertex[3][1] - this.scrollVertex[0][1]) - 15.0f - (float)n) / 2.0f);
            this.lRect.x = (int)this.scrollVertex[0][0] - this.iconWidth / 2;
            this.lRect.y = (int)this.scrollVertex[0][1] + n2;
            this.lRect.width = this.iconWidth;
            this.lRect.height = n;
            this.rRect.x = (int)this.scrollVertex[1][0] - this.iconWidth / 2;
            this.rRect.y = (int)this.scrollVertex[1][1] + n2;
            this.rRect.width = this.iconWidth;
            this.rRect.height = n;
        } else {
            int n = (int)Math.abs(this.scrollVertex[3][0] - this.scrollVertex[0][0]);
            n = (n = (int)((float)(n - 15) * 0.5f)) > this.iconHeight ? this.iconHeight : n;
            int n3 = (int)((Math.abs(this.scrollVertex[3][0] - this.scrollVertex[0][0]) - 15.0f - (float)n) / 2.0f);
            this.lRect.x = (int)this.scrollVertex[0][0] + 15 + n3;
            this.lRect.y = (int)this.scrollVertex[1][1] - this.iconWidth / 2;
            this.lRect.width = n;
            this.lRect.height = this.iconWidth;
            this.rRect.x = (int)this.scrollVertex[0][0] + 15 + n3;
            this.rRect.y = (int)this.scrollVertex[0][1] - this.iconWidth / 2;
            this.rRect.width = n;
            this.rRect.height = this.iconWidth;
        }
        this.create();
    }

    private void create() {
        if (!this.isbench) {
            this.lScrollPath.x = this.lRect.x;
            this.lScrollPath.y = this.lRect.y;
            this.lScrollPath.width = this.lRect.width;
            this.lScrollPath.height = this.lRect.height;
            this.rScrollPath.x = this.rRect.x;
            this.rScrollPath.y = this.rRect.y;
            this.rScrollPath.width = this.rRect.width;
            this.rScrollPath.height = this.rRect.height;
        } else {
            this.lScrollPath.x = this.rRect.x;
            this.lScrollPath.y = this.rRect.y;
            this.lScrollPath.width = this.rRect.width;
            this.lScrollPath.height = this.rRect.height;
            this.rScrollPath.x = this.lRect.x;
            this.rScrollPath.y = this.lRect.y;
            this.rScrollPath.width = this.lRect.width;
            this.rScrollPath.height = this.lRect.height;
        }
    }

    private void custommerConstant(Graphics2D graphics2D) {
        if (this.scrollVertex != null) {
            ChartColorPattern chartColorPattern = new ChartColorPattern(Color.black);
            chartColorPattern.setAlpha(0.5f);
            ChartPenStyle chartPenStyle = new ChartPenStyle(chartColorPattern);
            chartPenStyle.setPenWidth(1.0f);
            if (!this.isbench) {
                chartPenStyle.draw(graphics2D, new Line2D.Float((int)this.scrollVertex[1][0], (int)this.scrollVertex[1][1], (int)this.scrollVertex[2][0], (int)this.scrollVertex[2][1] - 15));
                chartPenStyle.draw(graphics2D, new Line2D.Float((int)this.scrollVertex[0][0], (int)this.scrollVertex[0][1], (int)this.scrollVertex[3][0], (int)this.scrollVertex[3][1] - 15));
            } else {
                chartPenStyle.draw(graphics2D, new Line2D.Float((int)this.scrollVertex[1][0] + 15, (int)this.scrollVertex[1][1], (int)this.scrollVertex[2][0], (int)this.scrollVertex[2][1]));
                chartPenStyle.draw(graphics2D, new Line2D.Float((int)this.scrollVertex[0][0] + 15, (int)this.scrollVertex[0][1], (int)this.scrollVertex[3][0], (int)this.scrollVertex[3][1]));
            }
        }
    }

    public int getPosition(int n, int n2) {
        if (!this.isbench) {
            return this.getPositionOfBar(n, n2);
        }
        return this.getPositionOfBench(n, n2);
    }

    int getPositionOfBar(int n, int n2) {
        if (this.rScrollPath.contains(n, n2)) {
            return 1;
        }
        if (this.lScrollPath.contains(n, n2)) {
            return 0;
        }
        if (this.scrollPath.contains(n, n2)) {
            return 2;
        }
        return -1;
    }

    int getPositionOfBench(int n, int n2) {
        if (this.lScrollPath.contains(n, n2)) {
            return 0;
        }
        if (this.rScrollPath.contains(n, n2)) {
            return 1;
        }
        if (this.scrollPath.contains(n, n2)) {
            return 2;
        }
        return -1;
    }

    public void setMoveLength(float f, float f2) {
        this.leftLength = f;
        this.rightLength = f2;
    }

    public float[] getStartAndEndP() {
        float[] fArray2 = new float[2];
        if (!this.isbench) {
            fArray2[0] = this.scrollVertex[0][0] / (float)this.rec.width;
            fArray2[1] = this.scrollVertex[1][0] / (float)this.rec.width;
        } else {
            fArray2[1] = ((float)this.rec.height - this.scrollVertex[0][1]) / (float)this.rec.height;
            fArray2[0] = ((float)this.rec.height - this.scrollVertex[1][1]) / (float)this.rec.height;
        }
        return fArray2;
    }

    public void setIsBench(boolean bl) {
        this.isbench = bl;
    }

    public void setLocate(boolean bl) {
        this.locate = bl;
    }

    void locateLabel() {
        Object object;
        Object object2;
        Object object3 = null;
        Object object4 = null;
        ChartCoordinatePaper chartCoordinatePaper = this.paper.platform.getChartCoordinatePaper();
        ChartAxis chartAxis = chartCoordinatePaper.getAxisX1();
        if (chartAxis == null && chartCoordinatePaper instanceof Chart2DPaper) {
            chartAxis = ((Chart2DPaper)chartCoordinatePaper).getAxisX2();
        }
        if (chartAxis != null && chartAxis instanceof ChartCategoryAxis && chartAxis.custommerConstant()) {
            String string;
            object2 = null;
            if (chartAxis != null && chartAxis instanceof ChartCategoryAxis && chartAxis.custommerConstant()) {
                object2 = chartAxis.getConstantStartEnd();
            }
            object3 = object2 != null ? (Object)object2[0] : null;
            Object object5 = object4 = object2 != null ? (Object)object2[1] : null;
            if (object3 != null) {
                string = null;
                if (this.labelFilter != null) {
                    string = this.labelFilter.filter(object3);
                } else if (object3 instanceof Timestamp && this.labelFilter == null) {
                    object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a");
                    string = ((Format)object).format(object3);
                } else if (object3 instanceof Date && this.labelFilter == null) {
                    object = new SimpleDateFormat("yyyy-MM-dd");
                    string = ((Format)object).format(object3);
                } else if (object3 instanceof Time && this.labelFilter == null) {
                    object = new SimpleDateFormat("HH:mm:ss a");
                    string = ((Format)object).format(object3);
                } else if (object3 instanceof Number && this.labelFilter == null) {
                    object = new DecimalFormat("0.00");
                    string = ((Format)object).format(object3);
                } else {
                    string = object3.toString();
                }
                this.startLbl.setLabelText(string);
            }
            if (object4 != null) {
                string = null;
                if (this.labelFilter != null) {
                    string = this.labelFilter.filter(object4);
                } else if (object4 instanceof Timestamp && this.labelFilter == null) {
                    object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss a");
                    string = ((Format)object).format(object4);
                } else if (object4 instanceof Date && this.labelFilter == null) {
                    object = new SimpleDateFormat("yyyy-MM-dd");
                    string = ((Format)object).format(object4);
                } else if (object4 instanceof Time && this.labelFilter == null) {
                    object = new SimpleDateFormat("HH:mm:ss a");
                    string = ((Format)object).format(object4);
                } else if (object4 instanceof Number && this.labelFilter == null) {
                    object = new DecimalFormat("0.00");
                    string = ((Format)object).format(object4);
                } else {
                    string = object4.toString();
                }
                this.endLbl.setLabelText(string);
            }
        } else {
            object2 = new int[]{this.paper.getChartPlatform().showScrollLabelStart(), this.paper.getChartPlatform().showScrollLabelEnd() - 1};
            int n = this.paper.model.getCategoryCount();
            if (object2[0] < 0) {
                object2[0] = 0;
            }
            if (object2[1] < 0) {
                object2[1] = 0;
            }
            if (object2[0] >= n) {
                object2[0] = n - 1;
            }
            if (object2[1] >= n) {
                object2[1] = n - 1;
            }
            object3 = this.paper.model.getCategoryName(object2[0]);
            object4 = this.paper.model.getCategoryName((int)object2[1]);
            if (object3 != null) {
                object = null;
                object = this.labelFilter != null ? this.labelFilter.filter(object3, ((Chart2DSimplePaper)this.paper).getDatePosition()[0]) : object3.toString();
                this.startLbl.setLabelText((String)object);
            }
            if (object4 != null) {
                object = null;
                object = this.labelFilter != null ? this.labelFilter.filter(object4, ((Chart2DSimplePaper)this.paper).getDatePosition()[1] > 0 ? ((Chart2DSimplePaper)this.paper).getDatePosition()[1] - 1 : 0) : object4.toString();
                this.endLbl.setLabelText((String)object);
            }
        }
        object2 = null;
        object2 = !this.isbench ? (Object)this.startLbl.getChartTextStyle() : (Object)this.endLbl.getChartTextStyle();
        if (!this.isbench) {
            float f = Math.abs(this.scrollVertex[0][0] - this.scrollVertex[2][0]);
            float f2 = (float)((ChartTextStyle)object2).getDimension(this.startLbl.getLabelText()).getWidth();
            float f3 = (float)((ChartTextStyle)object2).getDimension(this.endLbl.getLabelText()).getWidth();
            f3 += (float)(((ChartTextStyle)object2).getFontSize() / 3);
            float f4 = (float)((double)this.paper.getHeight() - ((ChartTextStyle)object2).getDimension(this.startLbl.getLabelText()).getHeight()) - 6.0f;
            float f5 = Math.abs(this.vertex[0][0] - this.vertex[2][0]);
            float f6 = (float)((ChartTextStyle)object2).getDimension("  ").getWidth();
            this.startLblPos[0] = this.scrollVertex[0][0] - f2 / 2.0f;
            if (f2 / 2.0f > f / 2.0f - f6) {
                this.startLblPos[0] = this.startLblPos[0] - (f2 / 2.0f - (f / 2.0f - f6));
            }
            this.startLblPos[0] = this.startLblPos[0] < 0.0f ? 0.0f : this.startLblPos[0];
            this.endLblPos[0] = this.scrollVertex[2][0] - f3 / 2.0f;
            if (this.endLblPos[0] < this.startLblPos[0] + f2 + f6) {
                this.endLblPos[0] = this.endLblPos[0] + (this.startLblPos[0] + f2 + f6 - this.endLblPos[0]);
            }
            if (this.endLblPos[0] + f3 > f5) {
                this.endLblPos[0] = this.endLblPos[0] - (this.endLblPos[0] + f3 - f5);
                if (this.startLblPos[0] + f2 + f6 > this.endLblPos[0]) {
                    this.startLblPos[0] = this.startLblPos[0] - (this.startLblPos[0] + f2 + f6 - this.endLblPos[0]);
                }
            }
            this.startLblPos[1] = f4;
            this.endLblPos[1] = f4;
        } else {
            this.startLbl.getChartTextStyle().setRotation(1.5707963267948966);
            this.endLbl.getChartTextStyle().setRotation(1.5707963267948966);
            float f = Math.abs(this.scrollVertex[0][1] - this.scrollVertex[2][1]);
            float f7 = 6.0f;
            float f8 = (float)((ChartTextStyle)object2).getDimension(this.startLbl.getLabelText()).getHeight();
            float f9 = (float)((ChartTextStyle)object2).getDimension(this.endLbl.getLabelText()).getHeight();
            float f10 = Math.abs(this.vertex[0][1] - this.vertex[2][1]);
            float f11 = (float)((ChartTextStyle)object2).getDimension("  ").getWidth();
            this.startLblPos[1] = this.scrollVertex[1][1] - (f8 += (float)(((ChartTextStyle)object2).getFontSize() / 3)) / 2.0f;
            if (f8 / 2.0f > f / 2.0f - f11) {
                this.startLblPos[1] = this.startLblPos[1] + (f8 / 2.0f - (f / 2.0f - f11));
            }
            this.startLblPos[1] = this.startLblPos[1] + f8 > f10 ? this.startLblPos[1] - (this.startLblPos[1] + f8 - f10) : this.startLblPos[1];
            this.endLblPos[1] = this.scrollVertex[0][1] - f9 / 2.0f;
            if (this.endLblPos[1] + f9 + f11 > this.startLblPos[1]) {
                this.endLblPos[1] = this.endLblPos[1] - (this.endLblPos[1] + f9 + f11 - this.startLblPos[1]);
            }
            if (this.endLblPos[1] < 0.0f) {
                this.endLblPos[1] = this.endLblPos[1] + (0.0f - this.endLblPos[1]);
                if (this.startLblPos[1] < this.endLblPos[1] + f9) {
                    this.startLblPos[1] = this.endLblPos[1] + f9 + f11;
                }
            }
            this.startLblPos[0] = f7;
            this.endLblPos[0] = f7;
        }
    }

    void paintLabel(Graphics2D graphics2D) {
        this.startLbl.paint(graphics2D, this.startLblPos[0], this.startLblPos[1]);
        this.endLbl.paint(graphics2D, this.endLblPos[0], this.endLblPos[1]);
    }

    public void setMouseLoc(int n, int n2) {
        this.mouseX = n - this.paper.getBounds().x;
        this.mouseY = n2 - this.paper.getBounds().y;
    }

    public boolean isOutBounds(float f, float f2) {
        return !this.isbench ? this.scrollVertex[0][0] + f < this.vertex[0][0] || this.scrollVertex[1][0] + f2 > this.vertex[1][0] || this.scrollVertex[1][0] + f2 - (this.scrollVertex[0][0] + f) < 7.0f : this.scrollVertex[0][1] + f < this.vertex[0][1] || this.scrollVertex[1][1] + f2 > this.vertex[2][1] || this.scrollVertex[1][1] + f2 - (this.scrollVertex[0][1] + f) < 7.0f;
    }

    public void setLabelFilter(ChartDataFilter chartDataFilter) {
        this.labelFilter = chartDataFilter;
    }

    public Rectangle getLeftButtonBounds() {
        return this.lRect;
    }

    public Rectangle getRightButtonBounds() {
        return this.rRect;
    }

    public void setLabelTextStyle(ChartTextStyle chartTextStyle) {
        this.textSty = chartTextStyle;
        this.resetLabelTextStyle();
    }

    @Override
    public void relocate() {
        float f;
        if (!this.locate) {
            return;
        }
        float[] fArray2 = this.paper.platform.getScrollbarInfo();
        float f2 = f = !this.isbench ? Math.abs(this.vertex[0][0] - this.vertex[2][0]) : Math.abs(this.vertex[0][1] - this.vertex[2][1]);
        if (!this.isbench) {
            this.scrollVertex[0][0] = this.vertex[0][0] + fArray2[0] * f;
            this.scrollVertex[1][0] = this.vertex[0][0] + fArray2[1] * f;
            this.scrollVertex[2][0] = this.vertex[0][0] + fArray2[1] * f;
            this.scrollVertex[3][0] = this.vertex[0][0] + fArray2[0] * f;
            if (this.scrollPath == null) {
                this.scrollPath = new GeneralPath();
            }
            this.scrollPath.reset();
            this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
            this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
            this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
            this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.closePath();
        } else {
            this.scrollVertex[0][1] = this.vertex[3][1] - fArray2[1] * f;
            this.scrollVertex[1][1] = this.vertex[3][1] - fArray2[0] * f;
            this.scrollVertex[2][1] = this.vertex[3][1] - fArray2[0] * f;
            this.scrollVertex[3][1] = this.vertex[3][1] - fArray2[1] * f;
            if (this.scrollPath == null) {
                this.scrollPath = new GeneralPath();
            }
            this.scrollPath.reset();
            this.scrollPath.moveTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.lineTo(this.scrollVertex[1][0], this.scrollVertex[1][1]);
            this.scrollPath.lineTo(this.scrollVertex[2][0], this.scrollVertex[2][1]);
            this.scrollPath.lineTo(this.scrollVertex[3][0], this.scrollVertex[3][1]);
            this.scrollPath.lineTo(this.scrollVertex[0][0], this.scrollVertex[0][1]);
            this.scrollPath.closePath();
        }
        this.create();
        this.contains();
        this.locateLabel();
        this.abs();
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        return null;
    }
}

