/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartCoordinatePaper;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DScrollbar;
import chart.data.ChartDataSet;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartAxisProperties;
import chart.properties.ChartCoordinatePaperProperties;
import chart.properties.ChartNodeProperties;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class Chart2DSimplePaper
extends Chart2DPaper {
    Chart2DScrollbar scrollbar = null;
    ChartCoordinatePaper paper;
    boolean isBench = false;
    Rectangle[] underLines;
    private Stroke I;
    private ChartColorPattern SEDU;
    protected BufferedImage img = null;
    protected ChartColorPattern fillH = null;
    protected boolean showChartInScroll = false;
    private boolean add = false;
    private static ChartColorPattern black = new ChartColorPattern(new Color(189, 189, 189));

    public Chart2DSimplePaper(ChartPlatform chartPlatform, ChartCoordinatePaper chartCoordinatePaper, ChartCoordinatePaperProperties chartCoordinatePaperProperties) {
        super(chartPlatform, chartCoordinatePaperProperties);
        this.paper = chartCoordinatePaper;
        this.setDefalutValue();
    }

    @Override
    public void init() {
        super.init();
        if (this.primLayer != null) {
            this.scrollbar = new Chart2DScrollbar(null, this, this.primLayer);
        } else if (this.secLayer != null) {
            this.scrollbar = new Chart2DScrollbar(null, this, this.secLayer);
        }
        this.scrollbar.init();
        this.scrollbar.setScrollLabelCount(this.platform.showScrollLabelCount());
        this.scrollbar.setIsBench(this.isBench);
        this.scrollbar.setLabelFilter(this.platform.getDataSetModel().getCategoryFilter());
        if (this.underLines == null) {
            this.underLines = new Rectangle[2];
            this.underLines[0] = new Rectangle();
            this.underLines[1] = new Rectangle();
        }
        if (this.fillH == null) {
            this.fillH = new ChartColorPattern(new Color(255, 171, 63));
            this.fillH.setAlpha(0.7f);
        }
        if (this.SEDU == null) {
            this.SEDU = new ChartColorPattern(Color.black);
            this.SEDU.setAlpha(0.75f);
        }
    }

    public void setDefalutValue() {
        this.black(this.platform.getDataSetModel().getChartDataSets());
        if (!this.isBench) {
            this.properties.setBottomMargin(15.0f);
            this.properties.setLeftMargin(0.0f);
            this.properties.setTopMargin(2.0f);
            this.properties.setRightMargin(0.0f);
        } else {
            this.properties.setLeftMargin(15.0f);
            this.properties.setBottomMargin(0.0f);
            this.properties.setTopMargin(0.0f);
            this.properties.setRightMargin(2.0f);
        }
        this.properties.setShowAxisX(false);
        this.properties.setShowAxisY(false);
        this.properties.setShowAxisY2(false);
        this.properties.getAxisXProperties().setPositionAxis(1);
        this.properties.getGraphProperties().setBulletDataSize("1;1;1");
        ChartFillPattern[] chartFillPatternArray = new ChartFillPattern[]{new ChartColorPattern(new Color(127, 127, 127)), new ChartColorPattern(new Color(178, 178, 178)), new ChartColorPattern(new Color(204, 204, 204))};
        ChartFillPattern[] chartFillPatternArray2 = new ChartFillPattern[]{new ChartColorPattern(new Color(0, 0, 0))};
        this.properties.getGraphProperties().setQualitativeRangesColorList(chartFillPatternArray);
        this.properties.getGraphProperties().setComparativeMeasureColorList(chartFillPatternArray2);
        this.properties.getGraphProperties().setQualitativeRangesWidth(80);
        this.properties.getGraphProperties().setComparativeMeasureWidth(70);
        this.properties.getGraphProperties().setSpecialFeatureMeasureWidth(50);
        this.properties.getGraphProperties().setIsHorizontal(this.paper.getProperties().getGraphProperties().getIsHorizontal());
        this.properties.getGraphProperties().setContour(false);
        this.properties.setReversePaintingOrder(this.paper.getProperties().isReversePaintingOrder());
        this.properties.getGraphProperties().setVaryColorbyValues(this.paper.getProperties().getGraphProperties().isVaryColorbyValues());
        this.properties.getGraphProperties().setStockLineColor(this.paper.getProperties().getGraphProperties().getStockLineColor());
        this.properties.getGraphProperties().setStockUpBarColor(this.paper.getProperties().getGraphProperties().getStockUpBarColor());
        this.properties.getGraphProperties().setStockDownBarColor(this.paper.getProperties().getGraphProperties().getStockDownBarColor());
        this.properties.getAxisXProperties().setUnitProperties(this.paper.getProperties().getAxisXProperties().getUnitProperties().dup());
        this.properties.getGraphProperties().setBarWidth(this.paper.getProperties().getGraphProperties().getBarWidth());
        this.properties.getGraphProperties().setBarGap(this.paper.getProperties().getGraphProperties().getBarGap());
        this.properties.setIsIgnoreNullValue(this.paper.getProperties().isIgnoreNullValue());
    }

    @Override
    public void locate() {
        ChartAxisProperties chartAxisProperties;
        if (!this.add) {
            super.locate();
            this.add();
            this.properties.getGraphProperties().setContour(false);
            if (this.paper != null && this.paper.getAxisX1() != null) {
                this.scrollbar.setLabelTextStyle(this.paper.getAxisX1().getProperties().getLabelTextStyle());
            }
            this.add = true;
        }
        this.scrollbar.setBounds(new Rectangle(0, 0, super.getWidth(), super.getHeight()));
        this.scrollbar.locate();
        this.showChartInScroll = this.paper != null && this.paper.getAxisX1() != null && this.paper.getAxisX1().getProperties() != null ? (chartAxisProperties = this.paper.getAxisX1().getProperties()).getIsShowChartInScroll() : false;
        if (!this.showChartInScroll && this.paper instanceof Chart2DPaper) {
            this.showChartInScroll = this.paper != null && ((Chart2DPaper)this.paper).getAxisX2() != null && ((Chart2DPaper)this.paper).getAxisX2().getProperties() != null ? (chartAxisProperties = ((Chart2DPaper)this.paper).getAxisX2().getProperties()).getIsShowChartInScroll() : false;
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.SEDU(graphics2D);
        if (this.showChartInScroll) {
            if (this.properties.isReversePaintingOrder()) {
                for (int i = this.charts.length - 1; i >= 0; --i) {
                    this.charts[i].paint(graphics2D);
                }
            } else {
                for (int i = 0; i < this.charts.length; ++i) {
                    this.charts[i].paint(graphics2D);
                }
            }
        }
        if (this.scrollbar != null && this.scrollbar.scrollVertex != null) {
            this.I(graphics2D, this.scrollbar.scrollVertex);
        }
        if (this.scrollbar != null) {
            this.scrollbar.paint(graphics2D);
        }
    }

    private void I(Graphics2D graphics2D, float[][] fArray2) {
        if (fArray2 != null && this.fillH != null) {
            GeneralPath generalPath = new GeneralPath();
            if (!this.isBench) {
                generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
                generalPath.lineTo(fArray2[1][0], fArray2[1][1]);
                generalPath.lineTo(fArray2[2][0], fArray2[2][1] - 12.0f);
                generalPath.lineTo(fArray2[3][0], fArray2[3][1] - 12.0f);
            } else {
                generalPath.moveTo(fArray2[0][0] + 15.0f, fArray2[0][1]);
                generalPath.lineTo(fArray2[1][0] + 15.0f, fArray2[1][1]);
                generalPath.lineTo(fArray2[2][0], fArray2[2][1]);
                generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
            }
            generalPath.closePath();
            this.fillH.fill(graphics2D, generalPath);
        }
    }

    private void SEDU(Graphics2D graphics2D) {
        if (this.underLines != null && this.SEDU != null) {
            ChartPenStyle chartPenStyle = new ChartPenStyle(this.SEDU);
            chartPenStyle.setPenWidth(1.0f);
            chartPenStyle.draw(graphics2D, this.underLines[1]);
        }
    }

    private void add() {
        if (this.underLines != null) {
            if (!this.isBench) {
                this.underLines[0].x = 0;
                this.underLines[0].y = this.getBounds().height - 2;
                this.underLines[0].width = this.getBounds().width;
                this.underLines[0].height = 1;
                this.underLines[1].x = 0;
                this.underLines[1].y = 0;
                this.underLines[1].width = this.getBounds().width;
                this.underLines[1].height = 1;
            } else {
                this.underLines[0].x = 0;
                this.underLines[0].y = 0;
                this.underLines[0].width = 1;
                this.underLines[0].height = this.getBounds().height;
                this.underLines[1].x = this.getBounds().width - 2;
                this.underLines[1].y = 0;
                this.underLines[1].width = 1;
                this.underLines[1].height = this.getBounds().height;
            }
        }
    }

    private void black(List list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ChartDataSet chartDataSet = (ChartDataSet)list.get(i);
            int n = chartDataSet.getChartDataSetInfo().getChartType();
            int n2 = ChartTypeInfo.getPrimType(n);
            if (n2 != 1 && n2 != 11) continue;
            this.isBench = true;
            if (n2 == 11) {
                this.isBench = this.paper.getProperties().getGraphProperties().getIsHorizontal();
            }
            return;
        }
    }

    public int getMousePositionInScrollbar(int n, int n2) {
        return this.scrollbar.getPosition(n, n2);
    }

    public void setMoveLength(float f, float f2) {
        this.scrollbar.setMoveLength(f, f2);
    }

    public int[] getDatePosition() {
        int[] nArray = new int[2];
        float f = (1.0f - this.getProperties().getGraphProperties().getBarWidth()) / 2.0f;
        nArray[0] = (int)(this.scrollbar.getStartAndEndP()[0] * (float)this.model.getCategoryCount() + f);
        nArray[1] = (int)(this.scrollbar.getStartAndEndP()[1] * (float)this.model.getCategoryCount() + (1.0f - f));
        nArray[1] = nArray[1] >= this.model.getCategoryCount() ? this.model.getCategoryCount() : nArray[1];
        int n = nArray[0] = nArray[0] < 0 ? 0 : nArray[0];
        if (nArray[1] - nArray[0] < 1) {
            if (nArray[1] < this.model.getCategoryCount()) {
                nArray[1] = nArray[1] + 1;
            } else if (nArray[0] > 0) {
                nArray[0] = nArray[0] - 1;
            }
        }
        return nArray;
    }

    public void setShowIndex() {
        ChartCoordinatePaper chartCoordinatePaper = this.platform.getChartCoordinatePaper();
        if (chartCoordinatePaper instanceof Chart2DPaper && (((Chart2DPaper)chartCoordinatePaper).getAxisX1() != null && !((Chart2DPaper)chartCoordinatePaper).getAxisX1().custommerConstant() || ((Chart2DPaper)chartCoordinatePaper).getAxisX2() != null && !((Chart2DPaper)chartCoordinatePaper).getAxisX2().custommerConstant())) {
            int n = this.platform.getDataSetModel().getCategoryCount();
            n = n <= 0 ? 1 : n;
            float[] fArray2 = this.scrollbar.getStartAndEndP();
            float f = n;
            float f2 = (1.0f - this.getProperties().getGraphProperties().getBarWidth()) / 2.0f;
            if (fArray2[1] % (f = 1.0f / f) >= (f2 /= f)) {
                fArray2[1] = fArray2[1] - fArray2[1] % f;
                fArray2[1] = fArray2[1] + f;
            }
            this.platform.setScrollbarInfo(fArray2);
        } else {
            this.platform.setScrollbarInfo(this.scrollbar.getStartAndEndP());
        }
    }

    public void dupGraphProperties(ChartCoordinatePaperProperties chartCoordinatePaperProperties) {
        this.getProperties().getGraphProperties().setContour(chartCoordinatePaperProperties.getGraphProperties().isContour());
        ChartNodeProperties chartNodeProperties = new ChartNodeProperties();
        chartNodeProperties.setShapeStyle(9);
        ArrayList<ChartNodeProperties> arrayList = new ArrayList<ChartNodeProperties>();
        arrayList.add(chartNodeProperties);
        this.getProperties().getGraphProperties().setLineNodeList(arrayList);
        this.getProperties().getGraphProperties().setAreaPatternList(chartCoordinatePaperProperties.getGraphProperties().getAreaPatternList());
        this.getProperties().getGraphProperties().setLineStyleList(chartCoordinatePaperProperties.getGraphProperties().getLineStyleList());
    }

    @Override
    public void calculateGraphArea() {
        super.calculateGraphArea();
        Rectangle rectangle = super.getBounds();
        if (this.graphArea != null) {
            if (!this.isBench) {
                this.graphArea.width = rectangle.width;
            } else {
                this.graphArea.height = rectangle.height;
            }
        }
    }

    public boolean isBench() {
        return this.isBench;
    }

    public float[] getStartAndEndP() {
        return this.scrollbar.getStartAndEndP();
    }

    public Chart2DScrollbar getScrollbar() {
        return this.scrollbar;
    }

    @Override
    public String[] getHintValue(int n, int n2) {
        return null;
    }

    @Override
    public void searchSelectedLineIndex(int n, int n2) {
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        return null;
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        return null;
    }

    @Override
    public int[] getDrilldown() {
        return null;
    }

    @Override
    public String[] getDrilldownGroup() {
        return null;
    }

    @Override
    public boolean canUseDepth() {
        return false;
    }

    public static ChartColorPattern getDownLightColor() {
        return black;
    }
}

