/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.data.Chart3DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class Graph2DBubble
extends Chart2DObject {
    private Shape[] SEDU;
    private Shape[][] add;
    private ChartPenStyle append;
    private float availableValue;
    private float availableValueX;
    private int contains;
    private int draw;
    private int drawBubble;
    private int fill;
    private float floatValue;
    private float get;
    private float[][] get3DEffectFill;
    private float[][] getAxisX;
    private float[] getBounds2D;
    private float[] getCategoryName;
    private float[][] getCategoryNames;
    private float getCategoryNmae;
    private double getCategorySize;
    private String[][][] getChartLink;
    private boolean getChartLinkInfo = true;
    private boolean getCondition = false;

    Graph2DBubble(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        int n;
        int n2;
        super.init();
        this.append = this.objectProperties.getContourPen();
        this.contains = this.dataset.getSeriesSize();
        this.draw = this.dataset.getCategorySize();
        this.floatValue = this.layer.getXUnit();
        this.get = this.layer.getYUnit();
        this.getBounds2D = new float[this.contains * this.draw];
        this.getCategoryName = new float[this.contains * this.draw];
        this.get3DEffectFill = new float[this.contains * this.draw][2];
        this.getAxisX = new float[this.contains * this.draw][2];
        this.getCategoryNames = new float[this.contains * this.draw][2];
        this.add = new Shape[this.contains][this.draw];
        this.SEDU = new Shape[this.contains];
        this.getChartLink = new String[this.contains][this.draw][3];
        for (int i = 0; i < this.contains; ++i) {
            for (int j = 0; j < this.draw; ++j) {
                this.add[i][j] = new GeneralPath();
            }
            this.SEDU[i] = new GeneralPath();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.contains; ++n2) {
            for (n = 0; n < this.draw; ++n) {
                Number number = ((Chart3DDataSet)this.dataset).getX(n2, n);
                if (this.layer.isShowCategoryAndSeries()) {
                    this.getChartLink[n2][n] = this.hintLabelShowCategoryAndSeries(5, n2, n, number);
                } else {
                    String[] stringArray = ((Chart3DDataSet)this.dataset).getValueNames();
                    if (number != null) {
                        this.getCategoryNames[n2 * this.draw + n][0] = number.floatValue();
                        if (stringArray.length % 2 == 0) {
                            stringBuffer.append(this.paper.model.getCategoryNmae());
                            stringBuffer.append(" : ");
                            if (((Chart3DDataSet)this.dataset).isUseCategoryAsX()) {
                                Object e = this.paper.model.getCategoryNames().get(n);
                                if (e != null) {
                                    stringBuffer.append(e.toString());
                                }
                            } else {
                                stringBuffer.append(this.dataset.getFormatedHintValue(number));
                            }
                        } else {
                            stringBuffer.append(stringArray[0]);
                            stringBuffer.append(" : ");
                            stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        }
                        this.getChartLink[n2][n][0] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                    if ((number = ((Chart3DDataSet)this.dataset).getY(n2, n)) != null) {
                        this.getCategoryNames[n2 * this.draw + n][1] = number.floatValue();
                        int n3 = n2 / this.paper.model.getSeriesCount();
                        n3 = stringArray.length % 2 == 0 ? (n3 *= 2) : n3 * 2 + 1;
                        n3 = n3 < 0 ? 0 : n3;
                        n3 = n3 >= stringArray.length ? stringArray.length - 1 : n3;
                        stringBuffer.append(stringArray[n3]);
                        stringBuffer.append(" : ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.getChartLink[n2][n][1] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                    if ((number = ((Chart3DDataSet)this.dataset).getZ(n2, n)) != null) {
                        this.getBounds2D[n2 * this.draw + n] = number.floatValue();
                        int n4 = n2 / this.paper.model.getSeriesCount();
                        n4 = stringArray.length % 2 == 0 ? n4 * 2 + 1 : n4 * 2 + 2;
                        n4 = n4 < 0 ? 0 : n4;
                        n4 = n4 >= stringArray.length ? stringArray.length - 1 : n4;
                        stringBuffer.append(stringArray[n4]);
                        stringBuffer.append(" : ");
                        stringBuffer.append(this.dataset.getFormatedHintValue(number));
                        this.getChartLink[n2][n][2] = stringBuffer.toString();
                        stringBuffer.setLength(0);
                    }
                }
                this.getCategoryNmae = this.getCategoryNmae < this.getBounds2D[n2 * this.draw + n] ? this.getBounds2D[n2 * this.draw + n] : this.getCategoryNmae;
            }
        }
        this.getCategoryNmae = this.getCategoryNmae >= (float)this.paper.getRenderInfo().zMax ? this.getCategoryNmae : (float)this.paper.getRenderInfo().zMax;
        n2 = 0;
        if (this.layer.getAxisX() instanceof ChartNumericAxis) {
            this.availableValue = (float)((ChartNumericAxis)this.layer.getAxisX()).getMax();
            this.availableValueX = (float)((ChartNumericAxis)this.layer.getAxisX()).getMin();
            this.getCategorySize = ((ChartNumericAxis)this.layer.getAxisX()).getTickPace();
        } else {
            this.getCategorySize = this.layer.getAxisX().getUnit(this.paper.getGraphArea().width);
            n2 = 1;
        }
        this.getChartLinkInfo = this.paper.getProperties().getGraphProperties().getCutBubble();
        for (n = 0; n < this.contains; ++n) {
            for (int i = 0; i < this.draw; ++i) {
                this.get3DEffectFill[n * this.draw + i][0] = n2 == 0 ? this.floatValue * this.layer.availableValueX(this.getCategoryNames[n * this.draw + i][0]) : this.floatValue * (float)i;
                this.get3DEffectFill[n * this.draw + i][1] = this.get * this.layer.availableValue(this.getCategoryNames[n * this.draw + i][1]);
                if (this.getCategoryNmae == 0.0f) {
                    this.getCategoryNmae = 1.0f;
                }
                this.getCategoryName[n * this.draw + i] = n2 == 0 ? (float)((double)(this.getBounds2D[n * this.draw + i] / this.getCategoryNmae) * this.getCategorySize * (double)this.layer.getAxisX().getUnit(this.paper.getGraphArea().width)) : (float)((double)(this.getBounds2D[n * this.draw + i] / this.getCategoryNmae) * this.getCategorySize);
                if (!(this.getCategoryName[n * this.draw + i] < 6.0f)) continue;
                this.getCategoryName[n * this.draw + i] = 6.0f;
            }
        }
    }

    @Override
    public void locate() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.contains; ++n2) {
            for (n = 0; n < this.draw; ++n) {
                ((GeneralPath)this.add[n2][n]).reset();
            }
            ((GeneralPath)this.SEDU[n2]).reset();
        }
        this.layer.transform(this.get3DEffectFill, this.getAxisX);
        for (n2 = 0; n2 < this.contains; ++n2) {
            for (n = 0; n < this.draw; ++n) {
                if (((Chart3DDataSet)this.dataset).getX(n2, n) == null || ((Chart3DDataSet)this.dataset).getY(n2, n) == null || ((Chart3DDataSet)this.dataset).getZ(n2, n) == null || this.getCategoryName[n2 * this.draw + n] < 0.0f) continue;
                this.add[n2][n] = new GeneralPath(new Arc2D.Double(this.getAxisX[n2 * this.draw + n][0] - (float)((int)this.getCategoryName[n2 * this.draw + n]) / 2.0f, this.getAxisX[this.draw * n2 + n][1] - this.getCategoryName[n2 * this.draw + n] / 2.0f, this.getCategoryName[n2 * this.draw + n], this.getCategoryName[n2 * this.draw + n], 0.0, 360.0, 0));
                ((GeneralPath)this.SEDU[n2]).append(this.add[n2][n], false);
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.contains; ++i) {
            this.drawBubble(graphics2D, i);
        }
    }

    public void drawBubble(Graphics2D graphics2D, int n) {
        boolean bl = true;
        if (this.seriesPattern[n] != null) {
            for (int i = 0; i < this.draw; ++i) {
                ChartGradientPattern chartGradientPattern;
                if (this.getCondition) {
                    if (this.objectProperties.isUse3DEffect()) {
                        chartGradientPattern = ChartGraphicsUtil.get3DEffectFill(ChartRenderTools.highLight(this.seriesPattern[n], -30));
                        chartGradientPattern.fill(graphics2D, !this.getChartLinkInfo ? this.add[n][i] : this.getCutShapeXY(this.add[n][i]));
                        bl = false;
                        continue;
                    }
                    ChartRenderTools.highLight(this.seriesPattern[n], -20).fill(graphics2D, !this.getChartLinkInfo ? this.add[n][i] : this.getCutShapeXY(this.add[n][i]));
                    continue;
                }
                if (this.objectProperties.isUse3DEffect()) {
                    chartGradientPattern = ChartGraphicsUtil.get3DEffectFill(this.seriesPattern[n]);
                    chartGradientPattern.fill(graphics2D, !this.getChartLinkInfo ? this.add[n][i] : this.getCutShapeXY(this.add[n][i]));
                    bl = false;
                    continue;
                }
                this.seriesPattern[n].fill(graphics2D, !this.getChartLinkInfo ? this.add[n][i] : this.getCutShapeXY(this.add[n][i]));
            }
        }
        if (this.objectProperties.isContour() && bl) {
            this.append.draw(graphics2D, !this.getChartLinkInfo ? this.SEDU[n] : this.getCutShapeXY(this.SEDU[n]));
        }
    }

    Area getCutShapeXY(Shape shape) {
        if (shape == null) {
            return null;
        }
        Area area = new Area(shape);
        area.intersect(new Area(this.paper.getGraphArea()));
        return area;
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.SEDU[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.add[n][n2];
    }

    @Override
    public Shape[][] getItemShapes() {
        return this.add;
    }

    public Shape[][] getLimitedItemShapes() {
        if (this.add != null && this.add.length > 0 && this.add[0] != null && this.add[0].length > 1 && this.getBounds2D != null) {
            int n = 0;
            Shape[][] shapeArray = new GeneralPath[this.add.length][this.add[0].length];
            Area area = new Area();
            for (int i = this.add.length - 1; i >= 0; --i) {
                for (int j = this.add[0].length - 1; j >= 0; --j) {
                    if (this.add[i][j] == null) continue;
                    Rectangle2D rectangle2D = this.add[i][j].getBounds2D();
                    rectangle2D.setRect(rectangle2D.getX() + 1.0, rectangle2D.getY() + 1.0, rectangle2D.getWidth() - 2.0, rectangle2D.getHeight() - 2.0);
                    if (area.contains(rectangle2D)) continue;
                    shapeArray[i][j] = (GeneralPath)this.add[i][j];
                    area.add(new Area(rectangle2D));
                    ++n;
                }
            }
            return shapeArray;
        }
        return this.add;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = this.contains - 1; i >= 0; --i) {
            for (int j = this.draw - 1; j >= 0; --j) {
                if (!this.add[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.getChartLink[i][j];
            }
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.SEDU.length; ++i) {
            if (!this.SEDU[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public String[] hintLabelShowCategoryAndSeries(int n, int n2, int n3, Number number) {
        int n4;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[n];
        if (this.paper.model.getSeriesN() != null) {
            stringBuffer.append(this.paper.model.getSeriesN() + ": ");
            stringBuffer.append(this.dataset.getFormatedHintSeriesValue(this.paper.model.getSeriesNames().get(n2 % this.paper.model.getSeriesNames().size()), n2 % this.paper.model.getSeriesNames().size()));
            stringArray[0] = stringBuffer.toString();
            stringBuffer.setLength(0);
        } else {
            stringArray[0] = "";
            stringBuffer.setLength(0);
        }
        if (this.paper.model.getCategoryNmae() != null) {
            stringBuffer.append(this.paper.model.getCategoryNmae());
            object = this.paper.model.getCategoryName(n3);
            if (object != null) {
                stringBuffer.append(" : ");
                stringBuffer.append(this.dataset.getFormatedHintCategoryValue(this.paper.model.getCategoryName(n3), n3));
            }
            stringArray[1] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        object = ((Chart3DDataSet)this.dataset).getValueNames();
        if (((Chart3DDataSet)this.dataset).isUseCategoryAsX()) {
            Object e = this.paper.model.getCategoryNames().get(n3);
            if (e != null) {
                stringBuffer.append(this.paper.model.getCategoryNmae() == null ? "X" : this.paper.model.getCategoryNmae());
                stringBuffer.append(" : ");
                stringBuffer.append(e.toString());
                stringArray[2] = stringBuffer.toString();
                stringBuffer.setLength(0);
            }
            if (number != null) {
                this.getCategoryNames[n2 * this.draw + n3][0] = number.floatValue();
            }
        } else if (number != null) {
            this.getCategoryNames[n2 * this.draw + n3][0] = number.floatValue();
            if (((String[])object).length % 2 == 0) {
                Object e = this.paper.model.getCategoryNames().get(n3);
                if (e != null) {
                    stringBuffer.append(this.paper.model.getCategoryNmae() == null ? "X" : this.paper.model.getCategoryNmae());
                    stringBuffer.append(" : ");
                    stringBuffer.append(e.toString());
                }
            } else {
                n4 = 0;
                stringBuffer.append(object[n4]);
                stringBuffer.append(" : ");
                stringBuffer.append(number.toString());
            }
            stringArray[2] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        number = ((Chart3DDataSet)this.dataset).getY(n2, n3);
        if (number != null) {
            this.getCategoryNames[n2 * this.draw + n3][1] = number.floatValue();
            if (((String[])object).length % 2 == 0) {
                n4 = n2 / this.paper.model.getSeriesCount();
                n4 *= 2;
            } else {
                n4 = n2 / this.paper.model.getSeriesCount();
                n4 = n4 * 2 + 1;
            }
            stringBuffer.append(object[n4]);
            stringBuffer.append(" : ");
            stringBuffer.append(number.toString());
            stringArray[3] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if ((number = ((Chart3DDataSet)this.dataset).getZ(n2, n3)) != null) {
            this.getBounds2D[n2 * this.draw + n3] = number.floatValue();
            if (((String[])object).length % 2 == 0) {
                n4 = n2 / this.paper.model.getSeriesCount();
                n4 = n4 * 2 + 1;
            } else {
                n4 = n2 / this.paper.model.getSeriesCount();
                n4 = n4 * 2 + 2;
            }
            stringBuffer.append(object[n4]);
            stringBuffer.append(" : ");
            stringBuffer.append(number.toString());
            stringArray[4] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        return stringArray;
    }

    public boolean getIsCutByXYArea() {
        return this.getChartLinkInfo;
    }

    public void setIsCutByXYArea(boolean bl) {
        this.getChartLinkInfo = bl;
    }

    public void setIsDarkFill(boolean bl) {
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        for (int i = this.contains - 1; i >= 0; --i) {
            for (int j = this.draw - 1; j >= 0; --j) {
                if (!this.add[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

