/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageBall;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTextStyle;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;

public class Graph2DGuageBalls
extends Chart2DObject {
    Graph2DGuageBall[][] children;
    ChartLabelBase[] categoryLabels;
    ChartLabelBase[] seriesLabels;
    String[][][] hintLabel;
    float[] valueMin;
    float[] valueMax;
    float[][] value;
    private Shape[] SEDU;
    private Shape[][] append;
    int row;
    int col;
    float[][] startX;
    float[][] startY;
    boolean[][] isNullValue;
    ChartGradientPattern[][] color;
    Color[] userColor;
    int unitWidth;
    int unitHeight;
    Line2D[] verticalGrid;
    Line2D[] horizonalGrid;
    float[][] categoryLabelsPos;
    float[][] seriesLabelsPos;
    float scaleX;
    float scaleY;

    Graph2DGuageBalls(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        super.init();
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.row = bl ? 3 : this.dataset.getSeriesSize();
        this.col = this.dataset.getCategorySize();
        if (this.row == 0 || this.col == 0) {
            return;
        }
        this.scaleX = this.paper.getProperties().getScaleX() == 1.0f ? 1.0f : this.paper.getProperties().getScaleX();
        this.scaleY = this.paper.getProperties().getScaleY() == 1.0f ? 1.0f : this.paper.getProperties().getScaleY();
        this.SEDU();
        this.append();
        this.categoryLabels();
        this.categoryLabelsPos();
        this.color();
        this.children = new Graph2DGuageBall[this.row][this.col];
        this.SEDU = new Shape[this.row];
        this.append = new Shape[this.row][this.col];
        this.startX = new float[this.row][this.col];
        this.startY = new float[this.row][this.col];
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.children[i][j] = new Graph2DGuageBall();
                this.children[i][j].setContour(this.objectProperties.isContour());
                this.children[i][j].setContourPen(this.objectProperties.getContourPen());
            }
        }
    }

    private void SEDU() {
        this.userColor = new Color[3];
        if (this.objectProperties.getGuagePatterns()[0] instanceof ChartColorPattern) {
            this.userColor[0] = ((ChartColorPattern)this.objectProperties.getGuagePatterns()[0]).getColor();
        } else if (this.objectProperties.getGuagePatterns()[0] instanceof ChartGradientPattern) {
            this.userColor[0] = ((ChartGradientPattern)this.objectProperties.getGuagePatterns()[0]).getStartColor().getColor();
        }
        if (this.objectProperties.getGuagePatterns()[1] instanceof ChartColorPattern) {
            this.userColor[1] = ((ChartColorPattern)this.objectProperties.getGuagePatterns()[1]).getColor();
        } else if (this.objectProperties.getGuagePatterns()[1] instanceof ChartGradientPattern) {
            this.userColor[1] = ((ChartGradientPattern)this.objectProperties.getGuagePatterns()[1]).getStartColor().getColor();
        }
        if (this.objectProperties.getGuagePatterns()[2] instanceof ChartColorPattern) {
            this.userColor[2] = ((ChartColorPattern)this.objectProperties.getGuagePatterns()[2]).getColor();
        } else if (this.objectProperties.getGuagePatterns()[2] instanceof ChartGradientPattern) {
            this.userColor[2] = ((ChartGradientPattern)this.objectProperties.getGuagePatterns()[2]).getStartColor().getColor();
        }
    }

    private void append() {
        int n;
        int n2;
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        String[] stringArray2 = this.dataset.getChartDataSetModel().getFilteredSeriesNames();
        if (stringArray != null) {
            n2 = stringArray.length;
            this.categoryLabels = new ChartLabelBase[n2];
            for (n = 0; n < n2; ++n) {
                this.categoryLabels[n] = new ChartLabelBase(stringArray[n]);
                this.categoryLabels[n].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
            }
        }
        if (stringArray2 != null) {
            n2 = stringArray2.length;
            this.seriesLabels = new ChartLabelBase[n2];
            for (n = 0; n < n2; ++n) {
                this.seriesLabels[n] = new ChartLabelBase(stringArray2[n]);
                this.seriesLabels[n].setChartTextStyle(this.paper.getProperties().getAxisZProperties().getLabelTextStyle());
            }
        }
    }

    private void categoryLabels() {
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.valueMin = new float[3];
        this.valueMax = new float[3];
        this.valueMin[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.valueMin[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.valueMin[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.valueMax[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.valueMax[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.valueMax[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        for (int i = 0; i < 3; ++i) {
            if (this.valueMin[i] > this.valueMax[i]) {
                float f3 = this.valueMin[i];
                this.valueMin[i] = this.valueMax[i];
                this.valueMax[i] = f3;
            }
            bl = this.valueMax[i] == this.valueMax[i] && this.valueMax[i] == 0.0f && bl;
        }
        if (bl) {
            float f4 = (f - f2) / 3.0f;
            for (int i = 0; i < 3; ++i) {
                this.valueMin[i] = f2 + (float)i * f4;
                this.valueMax[i] = this.valueMin[i] + f4;
            }
        }
    }

    private void categoryLabelsPos() {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.isNullValue = ((Chart1DDataSet)this.dataset).isNullValue();
        if (bl) {
            this.value = new float[1][this.col];
            this.hintLabel = new String[1][this.col][3];
            for (int i = 0; i < this.col; ++i) {
                if (this.isNullValue[0][i]) continue;
                Number number = ((Chart1DDataSet)this.dataset).getValue(0, i);
                this.value[0][i] = number.floatValue();
                if (this.layer.isShowCategoryAndSeries()) {
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    this.hintLabel[0][i] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(0, i);
                    continue;
                }
                this.hintLabel[0][i][0] = this.dataset.getFormatedHintValue(number);
            }
        } else {
            this.value = new float[this.row][this.col];
            this.hintLabel = new String[this.row][this.col][3];
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.col; ++j) {
                    if (this.isNullValue[i][j]) continue;
                    Number number = ((Chart1DDataSet)this.dataset).getValue(i, j);
                    this.value[i][j] = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.hintLabel[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                        continue;
                    }
                    this.hintLabel[i][j][0] = this.dataset.getFormatedHintValue(number);
                }
            }
        }
    }

    @Override
    public void locate() {
        this.col();
        this.children();
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.children[i][j].setArc((Arc2D)this.append[i][j]);
                this.children[i][j].setPattern(this.color[i][j]);
            }
        }
        this.drilldown();
        this.equals();
        this.draw();
        this.drawCategoryNames();
    }

    private void children() {
        int n;
        if (this.seriesLabels != null) {
            for (n = 0; n < this.seriesLabels.length; ++n) {
                this.seriesLabels[n].locate();
            }
        }
        if (this.categoryLabels != null) {
            for (n = 0; n < this.categoryLabels.length; ++n) {
                this.categoryLabels[n].locate();
            }
        }
    }

    private void col() {
        float f = this.objectProperties.getHorizonalMargin();
        float f2 = this.objectProperties.getVerticalMargin();
        this.unitWidth = (int)(((float)this.paper.getBounds().width * this.scaleX - f) / (float)this.col);
        this.unitHeight = (int)(((float)this.paper.getBounds().height * this.scaleY - f2) / (float)this.row);
        float f3 = (float)Math.min(this.unitWidth / 2, this.unitHeight / 2) * this.paper.getProperties().getGraphProperties().getRadiusRange();
        float f4 = (float)this.paper.getBounds().width * (1.0f - this.scaleX) / 2.0f;
        float f5 = (float)this.paper.getBounds().height * (1.0f - this.scaleY) / 2.0f;
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        for (int i = 0; i < this.row; ++i) {
            this.SEDU[i] = new GeneralPath();
            for (int j = 0; j < this.col; ++j) {
                if (bl ? this.isNullValue[0][j] : this.isNullValue[i][j]) continue;
                this.startX[i][j] = f4 + (float)(j * this.unitWidth) + (float)(this.unitWidth / 2) - f3 + f;
                this.startY[i][j] = f5 + (float)(i * this.unitHeight) + (float)(this.unitHeight / 2) - f3 + f2;
                this.append[i][j] = new Arc2D.Float(this.startX[i][j], this.startY[i][j], 2.0f * f3, 2.0f * f3, 0.0f, 360.0f, 0);
                ((GeneralPath)this.SEDU[i]).append(this.append[i][j], false);
            }
        }
    }

    private void color() {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.color = new ChartGradientPattern[this.row][this.col];
        if (bl) {
            this.contains();
        } else {
            this.dataset();
        }
    }

    private void contains() {
        for (int i = 0; i < this.col; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.value[0][i] > this.valueMin[j] && this.value[0][i] <= this.valueMax[j]) {
                    ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(255, 255, 255));
                    ChartColorPattern chartColorPattern2 = new ChartColorPattern(this.userColor[j]);
                    this.color[j][i] = new ChartGradientPattern(3);
                    this.color[j][i].setStartColor(chartColorPattern);
                    this.color[j][i].setEndColor(chartColorPattern2);
                    continue;
                }
                this.color[j][i] = new ChartGradientPattern(3);
                this.color[j][i].setStartColor(new ChartColorPattern(new Color(255, 255, 255)));
                this.color[j][i].setEndColor(new ChartColorPattern(new Color(0, 0, 0)));
            }
        }
    }

    private void dataset() {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                boolean bl = false;
                for (int k = 0; k < 3; ++k) {
                    if (!(this.value[i][j] > this.valueMin[k]) || !(this.value[i][j] <= this.valueMax[k])) continue;
                    ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(255, 255, 255));
                    ChartColorPattern chartColorPattern2 = new ChartColorPattern(this.userColor[k]);
                    this.color[i][j] = new ChartGradientPattern(3);
                    this.color[i][j].setStartColor(chartColorPattern);
                    this.color[i][j].setEndColor(chartColorPattern2);
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.color[i][j] = new ChartGradientPattern(3);
                this.color[i][j].setStartColor(new ChartColorPattern(new Color(255, 255, 255)));
                this.color[i][j].setEndColor(new ChartColorPattern(new Color(0, 0, 0)));
            }
        }
    }

    private void draw() {
        if (this.categoryLabels == null || this.categoryLabels.length == 0) {
            return;
        }
        float f = this.paper.getProperties().getGraphProperties().getHorizonalMargin();
        float f2 = this.paper.getProperties().getGraphProperties().getVerticalMargin();
        float f3 = (float)this.paper.getBounds().width * (1.0f - this.scaleX) / 2.0f;
        float f4 = (float)this.paper.getBounds().height * (1.0f - this.scaleY) / 2.0f;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisXProperties().getLabelTextStyle();
        this.categoryLabelsPos = new float[this.categoryLabels.length][2];
        for (int i = 0; i < this.categoryLabels.length; ++i) {
            if (this.categoryLabels[i] == null || this.categoryLabels[i].getLabelText().equals("")) continue;
            this.categoryLabels[i].locate();
            Dimension dimension = this.categoryLabels[i].getLabelBaseDimension();
            float f5 = (float)((double)(f3 + f + (float)(i * this.unitWidth)) + ((double)this.unitWidth - dimension.getWidth()) / 2.0);
            float f6 = f4 + (float)((double)f2 - dimension.getHeight()) / 2.0f;
            this.categoryLabelsPos[i][0] = f5;
            this.categoryLabelsPos[i][1] = f6;
        }
    }

    private void drawCategoryNames() {
        if (this.seriesLabels == null || this.seriesLabels.length == 0) {
            return;
        }
        float f = this.paper.getProperties().getGraphProperties().getHorizonalMargin();
        float f2 = this.paper.getProperties().getGraphProperties().getVerticalMargin();
        float f3 = (float)this.paper.getBounds().width * (1.0f - this.scaleX) / 2.0f;
        float f4 = (float)this.paper.getBounds().height * (1.0f - this.scaleY) / 2.0f;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisZProperties().getLabelTextStyle();
        this.seriesLabelsPos = new float[this.seriesLabels.length][2];
        for (int i = 0; i < this.seriesLabels.length; ++i) {
            if (this.seriesLabels[i] == null || this.seriesLabels[i].getLabelText().equals("")) continue;
            this.seriesLabels[i].locate();
            Dimension dimension = this.seriesLabels[i].getLabelBaseDimension();
            float f5 = (float)((double)f3 + ((double)f - dimension.getWidth()) / 2.0);
            float f6 = (float)((double)(f4 + f2 + (float)(i * this.unitHeight)) + ((double)this.unitHeight - dimension.getHeight()) / 2.0);
            this.seriesLabelsPos[i][0] = f5;
            this.seriesLabelsPos[i][1] = f6;
        }
    }

    private void drilldown() {
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            f = (float)this.paper.getBounds().width * (1.0f - this.scaleX) / 2.0f + (float)this.objectProperties.getHorizonalMargin();
            f2 = f + (float)(this.col * this.unitWidth);
        } else {
            f = (float)this.paper.getBounds().width * (1.0f - this.scaleX) / 2.0f;
            f2 = f + (float)this.objectProperties.getHorizonalMargin() + (float)(this.col * this.unitWidth);
        }
        float f3 = (float)this.paper.getBounds().height * (1.0f - this.scaleY) / 2.0f;
        float f4 = f3 + (float)this.objectProperties.getVerticalMargin() + (float)(this.row * this.unitHeight);
        this.horizonalGrid = new Line2D[this.row + 2];
        this.horizonalGrid[0] = new Line2D.Float(f, f3, f2, f3);
        for (int i = 0; i < this.row + 1; ++i) {
            float f5 = f3 + (float)(i * this.unitHeight) + (float)this.objectProperties.getVerticalMargin();
            this.horizonalGrid[i + 1] = new Line2D.Float(f, f5, f2, f5);
        }
    }

    private void equals() {
        float f = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f2 = f + (float)this.objectProperties.getHorizonalMargin() + (float)(this.col * this.unitWidth);
        float f3 = (float)this.paper.getBounds().height * (1.0f - this.scaleY) / 2.0f;
        float f4 = f3 + (float)this.objectProperties.getVerticalMargin() + (float)(this.row * this.unitHeight);
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            this.verticalGrid = new Line2D[this.col + 1];
            for (int i = 0; i < this.col + 1; ++i) {
                float f5 = f + (float)(i * this.unitWidth) + (float)this.objectProperties.getHorizonalMargin();
                this.verticalGrid[i] = new Line2D.Float(f5, f3, f5, f4);
            }
        } else {
            this.verticalGrid = new Line2D[this.col + 2];
            this.verticalGrid[0] = new Line2D.Float(f, f3, f, f4);
            for (int i = 0; i < this.col + 1; ++i) {
                float f6 = f + (float)(i * this.unitWidth) + (float)this.objectProperties.getHorizonalMargin();
                this.verticalGrid[i + 1] = new Line2D.Float(f6, f3, f6, f4);
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.children[i][j].paint(graphics2D);
            }
        }
        if (this.paper.getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            this.drawCategoryNames(graphics2D);
        }
        if (this.paper.getProperties().getAxisZProperties().isShowTickMarkLabels()) {
            this.floatValue(graphics2D);
        }
        if (this.paper.getProperties().getAxisZProperties().isShowGrid()) {
            this.get(graphics2D);
        }
        if (this.paper.getProperties().getAxisXProperties().isShowGrid()) {
            this.getAxisXProperties(graphics2D);
        }
    }

    public void drawCategoryNames(Graphics2D graphics2D) {
        if (this.categoryLabels == null || this.categoryLabels.length == 0) {
            return;
        }
        for (int i = 0; i < this.categoryLabels.length; ++i) {
            if (this.categoryLabels[i] == null || this.categoryLabels[i].getLabelText().equals("")) continue;
            this.categoryLabels[i].locate();
            this.categoryLabels[i].paint(graphics2D, this.categoryLabelsPos[i][0], this.categoryLabelsPos[i][1]);
        }
    }

    private void floatValue(Graphics2D graphics2D) {
        if (this.seriesLabels == null || this.seriesLabels.length == 0) {
            return;
        }
        for (int i = 0; i < this.seriesLabels.length; ++i) {
            if (this.seriesLabels[i] == null || this.seriesLabels[i].getLabelText().equals("")) continue;
            this.seriesLabels[i].locate();
            this.seriesLabels[i].paint(graphics2D, this.seriesLabelsPos[i][0], this.seriesLabelsPos[i][1]);
        }
    }

    private void get(Graphics2D graphics2D) {
        int n = this.horizonalGrid.length;
        for (int i = 0; i < n; ++i) {
            this.paper.getProperties().getAxisZProperties().getGridPen().draw(graphics2D, this.horizonalGrid[i]);
        }
    }

    private void getAxisXProperties(Graphics2D graphics2D) {
        int n = this.verticalGrid.length;
        for (int i = 0; i < n; ++i) {
            this.paper.getProperties().getAxisXProperties().getGridPen().draw(graphics2D, this.verticalGrid[i]);
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.append;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.SEDU[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.append[n][n2];
    }

    @Override
    public String[] search(int n, int n2) {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.drilldown = null;
        if (bl) {
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.col; ++j) {
                    if (this.append[i][j] == null || !this.append[i][j].contains(n, n2)) continue;
                    this.drilldown = new int[2];
                    this.drilldown[0] = i;
                    this.drilldown[1] = j;
                    return this.hintLabel[0][j];
                }
            }
        } else {
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.col; ++j) {
                    if (this.append[i][j] == null || !this.append[i][j].contains(n, n2)) continue;
                    this.drilldown = new int[2];
                    return this.hintLabel[i][j];
                }
            }
        }
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.row; ++i) {
            if (!this.SEDU[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public boolean searchHorizonalGrid(int n, int n2) {
        if (this.horizonalGrid == null || !this.paper.properties.getAxisZProperties().isShowGrid()) {
            return false;
        }
        int n3 = this.horizonalGrid.length;
        for (int i = 0; i < n3; ++i) {
            if (!this.horizonalGrid[i].intersects(n - 2, n2 - 2, 5.0, 5.0)) continue;
            return true;
        }
        return false;
    }

    public boolean searchVerticalGrid(int n, int n2) {
        if (this.verticalGrid == null || !this.paper.properties.getAxisXProperties().isShowGrid()) {
            return false;
        }
        int n3 = this.verticalGrid.length;
        for (int i = 0; i < n3; ++i) {
            if (!this.verticalGrid[i].intersects(n - 2, n2 - 2, 5.0, 5.0)) continue;
            return true;
        }
        return false;
    }

    public Shape[] getHorizonalGrid() {
        return this.horizonalGrid;
    }

    public Shape[] getVerticalGrid() {
        return this.verticalGrid;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.row / n5;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (this.append[i][j] == null || !this.append[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

