/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Graph2DGuageBars;
import chart.data.Chart1DDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Graph2DGuageBar {
    Graph2DGuageBars parent;
    ChartLabelBase categoryLabel;
    float startX;
    float startY;
    float textWidth = 0.0f;
    float textHeight = 0.0f;
    float tempWidth = 0.0f;
    float tempHeight = 0.0f;
    float barWidth;
    float barHeight = 0.0f;
    int ID = 0;
    float axisWidth = 0.0f;
    float axisHeight = 0.0f;
    float[][] majorTickPoint;
    float[][][] minorTickPoint;
    Shape[] itemShapes;
    float gap = 0.0f;
    Line2D axisLine = null;

    public Graph2DGuageBar(Graph2DGuageBars graph2DGuageBars, int n) {
        this.parent = graph2DGuageBars;
        this.ID = n;
    }

    public void locate() {
        float f = 0.25f;
        float f2 = 0.1f;
        float f3 = 0.3f;
        float f4 = 0.05f;
        float f5 = 0.3f;
        switch (this.parent.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.textHeight = this.parent.unitHeight * f;
                this.tempHeight = this.parent.unitHeight * f2;
                this.barHeight = this.parent.unitHeight * f3;
                this.gap = this.parent.unitHeight * f4;
                this.axisHeight = this.parent.unitHeight * f5;
                this.textWidth = this.parent.unitWidth;
                this.tempWidth = this.parent.unitWidth;
                this.barWidth = this.parent.unitWidth;
                this.axisWidth = this.parent.unitWidth;
                break;
            }
            case 1: {
                this.textWidth = this.parent.unitWidth * f;
                this.tempWidth = this.parent.unitWidth * f2;
                this.barWidth = this.parent.unitWidth * f3;
                this.gap = this.parent.unitWidth * f4;
                this.axisWidth = this.parent.unitWidth * f5;
                this.textHeight = this.parent.unitHeight;
                this.tempHeight = this.parent.unitHeight;
                this.barHeight = this.parent.unitHeight;
                this.axisHeight = this.parent.unitHeight;
            }
        }
        this.itemShapes = new Shape[this.parent.row];
        for (int i = 0; i < this.parent.row; ++i) {
            this.itemShapes[i] = new GeneralPath();
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.parent.getPaper().getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            this.barWidth(graphics2D);
        }
        switch (this.parent.getPaper().getProperties().getGraphProperties().getGaugeBarStyle()) {
            case 0: {
                this.fillTempPattern(graphics2D);
                this.fillValuePattern(graphics2D, true);
                break;
            }
            case 1: {
                this.fillTempPattern(graphics2D);
                this.fillValuePattern(graphics2D, false);
                break;
            }
            case 2: {
                this.fillBackPattern(graphics2D);
                break;
            }
        }
        if (this.parent.getPaper().getProperties().isShowAxisY()) {
            this.drawAxis(graphics2D);
        }
        this.categoryLabel(graphics2D);
    }

    public void drawAxis(Graphics2D graphics2D) {
        this.axisLine = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.parent.objectProperties.getGaugeBarLayout()) {
            case 0: {
                f = this.startX;
                f2 = this.startY + this.textHeight + this.tempHeight + this.barHeight + this.gap;
                f3 = this.startX + this.barWidth;
                f4 = f2;
                break;
            }
            case 1: {
                f = this.startX + this.textWidth + this.tempWidth + this.barWidth + this.gap;
                f2 = this.startY;
                f3 = f;
                f4 = this.startY + this.barHeight;
            }
        }
        this.axisLine.setLine(f, f2, f3, f4);
        this.parent.getPaper().getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, this.axisLine);
        this.abs(graphics2D);
        if (this.parent.getPaper().getProperties().getAxisYProperties().isShowTickMarkLabels()) {
            this.axisLine(graphics2D);
        }
    }

    private void ID(float[][] fArray2, float[][][] fArray3) {
        int n = ((ChartNumericAxis)this.parent.layer.getAxisY()).getNumOfTick();
        float f = this.barWidth / (float)n;
        float f2 = f / 5.0f;
        float f3 = this.startX;
        float f4 = this.startY + this.textHeight + this.tempHeight + this.barHeight + this.gap;
        for (int i = 0; i <= n; ++i) {
            fArray2[i][0] = f3 + (float)i * f;
            fArray2[i][1] = f4;
            if (i == n) continue;
            for (int j = 0; j < 4; ++j) {
                fArray3[i][j][0] = fArray2[i][0] + (float)j * f2;
                fArray3[i][j][1] = fArray2[i][1];
            }
        }
    }

    private void SEDU(float[][] fArray2, float[][][] fArray3) {
        int n = ((ChartNumericAxis)this.parent.layer.getAxisY()).getNumOfTick();
        float f = this.barHeight / (float)n;
        float f2 = f / 5.0f;
        float f3 = this.startX + this.textWidth + this.tempWidth + this.barWidth + this.gap;
        float f4 = this.startY;
        for (int i = 0; i <= n; ++i) {
            fArray2[i][0] = f3;
            fArray2[i][1] = f4 + (float)i * f;
            if (i == n) continue;
            for (int j = 0; j < 4; ++j) {
                fArray3[i][j][0] = f3;
                fArray3[i][j][1] = fArray2[i][1] + (float)j * f2;
            }
        }
    }

    private void abs(Graphics2D graphics2D) {
        int n = ((ChartNumericAxis)this.parent.layer.getAxisY()).getNumOfTick();
        this.majorTickPoint = new float[n + 1][2];
        this.minorTickPoint = new float[n][4][2];
        int n2 = this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        ChartPenStyle chartPenStyle = this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkPen();
        int n3 = (int)this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        int n4 = (int)this.parent.getPaper().getProperties().getAxisYProperties().getMinorTickMarkLength();
        int n5 = this.parent.getPaper().getProperties().getAxisYProperties().getMinorTickMarkType();
        switch (this.parent.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.ID(this.majorTickPoint, this.minorTickPoint);
                this.axisHeight(graphics2D, this.majorTickPoint, n2, chartPenStyle, n3);
                for (int i = 0; i < n; ++i) {
                    this.axisHeight(graphics2D, this.minorTickPoint[i], n5, chartPenStyle, n4);
                }
                break;
            }
            case 1: {
                this.SEDU(this.majorTickPoint, this.minorTickPoint);
                this.axisLabelInsect(graphics2D, this.majorTickPoint, n2, chartPenStyle, n3);
                for (int i = 0; i < n; ++i) {
                    this.axisLabelInsect(graphics2D, this.minorTickPoint[i], n5, chartPenStyle, n4);
                }
                break;
            }
        }
    }

    private void axisHeight(Graphics2D graphics2D, float[][] fArray2, int n, ChartPenStyle chartPenStyle, int n2) {
        int n3 = fArray2.length;
        Line2D.Float float_ = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n3; ++i) {
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    f = fArray2[i][0];
                    f2 = fArray2[i][1];
                    f3 = fArray2[i][0];
                    f4 = fArray2[i][1] - (float)n2;
                    break;
                }
                case 1: {
                    f = fArray2[i][0];
                    f2 = fArray2[i][1];
                    f3 = fArray2[i][0];
                    f4 = fArray2[i][1] + (float)n2;
                    break;
                }
                case 3: {
                    f = fArray2[i][0];
                    f2 = fArray2[i][1] - (float)n2;
                    f3 = fArray2[i][0];
                    f4 = fArray2[i][1] + (float)n2;
                }
            }
            ((Line2D)float_).setLine(f, f2, f3, f4);
            chartPenStyle.draw(graphics2D, float_);
        }
    }

    private void axisLabelInsect(Graphics2D graphics2D, float[][] fArray2, int n, ChartPenStyle chartPenStyle, int n2) {
        int n3 = fArray2.length;
        Line2D.Float float_ = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    f = fArray2[i][0];
                    f2 = fArray2[i][1];
                    f3 = fArray2[i][0] - (float)n2;
                    f4 = fArray2[i][1];
                    break;
                }
                case 1: {
                    f = fArray2[i][0];
                    f2 = fArray2[i][1];
                    f3 = fArray2[i][0] + (float)n2;
                    f4 = fArray2[i][1];
                    break;
                }
                case 3: {
                    f = fArray2[i][0] - (float)n2;
                    f2 = fArray2[i][1];
                    f3 = fArray2[i][0] + (float)n2;
                    f4 = fArray2[i][1];
                }
            }
            ((Line2D)float_).setLine(f, f2, f3, f4);
            chartPenStyle.draw(graphics2D, float_);
        }
    }

    private void axisLine(Graphics2D graphics2D) {
        String[] stringArray = ((ChartNumericAxis)this.parent.layer.axisY).getLabels();
        int n = stringArray.length;
        ChartTextStyle chartTextStyle = this.parent.getPaper().getProperties().getAxisYProperties().getLabelTextStyle();
        float f = 0.0f;
        float f2 = 0.0f;
        float[][] fArray2 = new float[n][2];
        switch (this.parent.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.axisWidth(graphics2D, this.majorTickPoint, chartTextStyle, fArray2, stringArray);
                break;
            }
            case 1: {
                this.axisY(graphics2D, this.majorTickPoint, chartTextStyle, fArray2, stringArray);
            }
        }
        this.barHeight(graphics2D, chartTextStyle, fArray2, stringArray);
    }

    private void axisWidth(Graphics2D graphics2D, float[][] fArray2, ChartTextStyle chartTextStyle, float[][] fArray3, String[] stringArray) {
        int n = stringArray.length;
        int n2 = this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        int n3 = 0;
        int n4 = (int)this.parent.getPaper().getProperties().getAxisYProperties().getLabelAxisGap();
        if (n2 == 1) {
            n3 = (int)this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        } else if (n2 == 3) {
            n3 = (int)this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkLength() / 2;
        }
        for (int i = 0; i < n; ++i) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(graphics2D, stringArray[i]);
            fArray3[i][0] = (float)((double)fArray2[i][0] - rectangle2D.getWidth() / 2.0);
            fArray3[i][1] = fArray2[i][1] + (float)n3 + (float)n4;
        }
    }

    private void axisY(Graphics2D graphics2D, float[][] fArray2, ChartTextStyle chartTextStyle, float[][] fArray3, String[] stringArray) {
        int n = stringArray.length;
        int n2 = this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        int n3 = 0;
        int n4 = (int)this.parent.getPaper().getProperties().getAxisYProperties().getLabelAxisGap();
        if (n2 == 1) {
            n3 = (int)this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        } else if (n2 == 3) {
            n3 = (int)this.parent.getPaper().getProperties().getAxisYProperties().getTickMarkLength() / 2;
        }
        for (int i = 0; i < n; ++i) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(graphics2D, stringArray[i]);
            fArray3[i][0] = fArray2[i][0] + (float)n3 + (float)n4;
            fArray3[i][1] = (float)((double)fArray2[i][1] - rectangle2D.getHeight() / 2.0);
        }
    }

    private void barHeight(Graphics2D graphics2D, ChartTextStyle chartTextStyle, float[][] fArray2, String[] stringArray) {
        int n = stringArray.length;
        switch (this.parent.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                if (this.parent.getPaper().getProperties().getAxisYProperties().isBestEffort()) {
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0 && this.axisLabelInsect(chartTextStyle, Math.abs(fArray2[n2][0] - fArray2[i][0]), stringArray[n2], stringArray[i])) continue;
                        ChartLabelBase chartLabelBase = new ChartLabelBase(stringArray[i]);
                        chartLabelBase.setChartTextStyle(chartTextStyle);
                        chartLabelBase.paint(graphics2D, fArray2[i][0], fArray2[i][1]);
                        n2 = i;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        ChartLabelBase chartLabelBase = new ChartLabelBase(stringArray[i]);
                        chartLabelBase.setChartTextStyle(chartTextStyle);
                        chartLabelBase.paint(graphics2D, fArray2[i][0], fArray2[i][1]);
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n; ++i) {
                    ChartLabelBase chartLabelBase = new ChartLabelBase(stringArray[n - i - 1]);
                    chartLabelBase.setChartTextStyle(chartTextStyle);
                    chartLabelBase.paint(graphics2D, fArray2[i][0], fArray2[i][1]);
                }
                break;
            }
        }
    }

    boolean axisLabelInsect(ChartTextStyle chartTextStyle, float f, String string, String string2) {
        ChartTextStyle chartTextStyle2;
        float f2;
        boolean bl = false;
        if (chartTextStyle != null && string != null && string2 != null && (f2 = (float)(chartTextStyle2 = (ChartTextStyle)chartTextStyle.clone()).getDimension(string).getWidth()) > f) {
            return true;
        }
        return bl;
    }

    private void barWidth(Graphics2D graphics2D) {
        if (this.categoryLabel != null) {
            Rectangle2D rectangle2D = this.parent.getPaper().getProperties().getAxisXProperties().getLabelTextStyle().getDimension(graphics2D, this.categoryLabel.getLabelText());
            this.textWidth = (float)rectangle2D.getWidth();
            this.textHeight = (float)rectangle2D.getHeight();
            if (this.parent.getPaper().getProperties().getGraphProperties().getGaugeBarLayout() == 1) {
                this.textWidth = (float)rectangle2D.getHeight();
                this.textHeight = (float)rectangle2D.getWidth();
            }
            float f = 0.0f;
            float f2 = 0.0f;
            switch (this.parent.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
                case 0: {
                    f = this.startX + (this.parent.unitWidth - this.textWidth) / 2.0f;
                    f2 = this.startY;
                    this.categoryLabel.paint(graphics2D, f, f2);
                    break;
                }
                case 1: {
                    f = this.startX;
                    f2 = this.startY + (this.parent.unitHeight - this.textHeight) / 2.0f;
                    graphics2D.rotate(1.5707963267948966, f, f2);
                    this.categoryLabel.paint(graphics2D, f, f2);
                    graphics2D.rotate(-1.5707963267948966, f, f2);
                }
            }
        }
    }

    private void categoryLabel(Graphics2D graphics2D) {
        switch (this.parent.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.categoryMaxValue(graphics2D);
                break;
            }
            case 1: {
                this.clone(graphics2D);
            }
        }
    }

    private void categoryMaxValue(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        float[][] fArray2 = new float[4][2];
        float f = this.startX;
        float f2 = this.startY + this.textHeight + this.tempHeight + this.gap;
        for (int i = 0; i < this.parent.row; ++i) {
            if (((Chart1DDataSet)this.parent.dataset).getValue(i, this.ID) == null || this.parent.value[i][this.ID] > this.parent.maxValue || this.parent.value[i][this.ID] < this.parent.minValue) continue;
            fArray2[0][0] = f + this.parent.unitWidth * ((this.parent.value[i][this.ID] - this.parent.minValue) / (this.parent.maxValue - this.parent.minValue));
            fArray2[0][1] = f2 + 12.0f;
            fArray2[1][0] = fArray2[0][0] - 6.0f;
            fArray2[1][1] = f2 + this.parent.getPaper().getProperties().getAxisYProperties().getAxisPen().getPenWidth();
            fArray2[2][0] = fArray2[1][0] + 12.0f;
            fArray2[2][1] = fArray2[1][1];
            fArray2[3][0] = fArray2[0][0];
            fArray2[3][1] = this.startY + this.textHeight + this.tempHeight + this.barHeight + this.gap;
            ((GeneralPath)this.itemShapes[i]).reset();
            ((GeneralPath)this.itemShapes[i]).moveTo(fArray2[0][0], fArray2[0][1]);
            ((GeneralPath)this.itemShapes[i]).lineTo(fArray2[1][0], fArray2[1][1]);
            ((GeneralPath)this.itemShapes[i]).lineTo(fArray2[2][0], fArray2[2][1]);
            ((GeneralPath)this.itemShapes[i]).lineTo(fArray2[0][0], fArray2[0][1]);
            if (this.parent.objectProperties.isContour()) {
                this.parent.objectProperties.getContourPen().draw(graphics2D, this.itemShapes[i]);
            }
            if (this.parent.getSeriesPattern()[i] != null) {
                this.parent.getSeriesPattern()[i].fill(graphics2D, this.itemShapes[i]);
            }
            generalPath.reset();
            generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
            generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
            if (!this.parent.objectProperties.isContour()) continue;
            this.parent.objectProperties.getContourPen().draw(graphics2D, generalPath);
        }
    }

    private void clone(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        float[][] fArray2 = new float[4][2];
        float f = this.startX + this.textWidth + this.tempWidth + this.gap;
        float f2 = this.startY;
        for (int i = 0; i < this.parent.row; ++i) {
            if (((Chart1DDataSet)this.parent.dataset).getValue(i, this.ID) == null || this.parent.value[i][this.ID] > this.parent.maxValue || this.parent.value[i][this.ID] < this.parent.minValue) continue;
            fArray2[0][1] = f2 + this.parent.unitHeight * (1.0f - (this.parent.value[i][this.ID] - this.parent.minValue) / (this.parent.maxValue - this.parent.minValue));
            fArray2[0][0] = f + 12.0f;
            fArray2[1][0] = f + this.parent.getPaper().getProperties().getAxisYProperties().getAxisPen().getPenWidth();
            fArray2[1][1] = fArray2[0][1] - 6.0f;
            fArray2[2][0] = fArray2[1][0];
            fArray2[2][1] = fArray2[1][1] + 12.0f;
            fArray2[3][0] = f + this.barWidth;
            fArray2[3][1] = fArray2[0][1];
            ((GeneralPath)this.itemShapes[i]).reset();
            ((GeneralPath)this.itemShapes[i]).moveTo(fArray2[0][0], fArray2[0][1]);
            ((GeneralPath)this.itemShapes[i]).lineTo(fArray2[1][0], fArray2[1][1]);
            ((GeneralPath)this.itemShapes[i]).lineTo(fArray2[2][0], fArray2[2][1]);
            ((GeneralPath)this.itemShapes[i]).lineTo(fArray2[0][0], fArray2[0][1]);
            if (this.parent.getSeriesPattern()[i] != null) {
                this.parent.getSeriesPattern()[i].fill(graphics2D, this.itemShapes[i]);
            }
            if (this.parent.objectProperties.isContour()) {
                this.parent.objectProperties.getContourPen().draw(graphics2D, this.itemShapes[i]);
            }
            generalPath.reset();
            generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
            generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
            if (!this.parent.objectProperties.isContour()) continue;
            this.parent.objectProperties.getContourPen().draw(graphics2D, generalPath);
        }
    }

    public void fillTempPattern(Graphics2D graphics2D) {
        float f = 0.0f;
        float f2 = 0.0f;
        switch (this.parent.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                f = this.startX;
                f2 = this.startY + this.textHeight + this.gap / 2.0f;
                break;
            }
            case 1: {
                f = this.startX + this.textWidth + this.gap / 2.0f;
                f2 = this.startY;
            }
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, this.tempWidth, this.tempHeight);
        switch (this.parent.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.dataset(float_, graphics2D);
                break;
            }
            case 1: {
                this.draw(float_, graphics2D);
            }
        }
        this.parent.getPaper().getProperties().getGraphProperties().getGaugeBarPen().draw(graphics2D, float_);
    }

    private void dataset(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        ChartGradientPattern chartGradientPattern = new ChartGradientPattern(0);
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getHeight();
        float f4 = this.parent.valueMin[0] == this.parent.valueMin[1] ? 0.0f : (float)((double)(Math.abs(this.parent.valueMin[1] - this.parent.valueMin[0]) / (this.parent.maxValue - this.parent.minValue)) * rectangle2D.getWidth());
        float f5 = f + f4;
        float f6 = f2;
        float f7 = (float)rectangle2D.getHeight();
        float f8 = (float)(rectangle2D.getWidth() - (double)f4);
        ChartColorPattern[] chartColorPatternArray = new ChartColorPattern[3];
        if (this.parent.objectProperties.getGuagePatterns()[0] instanceof ChartColorPattern) {
            chartColorPatternArray[0] = (ChartColorPattern)this.parent.objectProperties.getGuagePatterns()[0];
        } else if (this.parent.objectProperties.getGuagePatterns()[0] instanceof ChartGradientPattern) {
            chartColorPatternArray[0] = ((ChartGradientPattern)this.parent.objectProperties.getGuagePatterns()[0]).getStartColor();
        }
        if (this.parent.objectProperties.getGuagePatterns()[1] instanceof ChartColorPattern) {
            chartColorPatternArray[1] = (ChartColorPattern)this.parent.objectProperties.getGuagePatterns()[1];
        } else if (this.parent.objectProperties.getGuagePatterns()[1] instanceof ChartGradientPattern) {
            chartColorPatternArray[1] = ((ChartGradientPattern)this.parent.objectProperties.getGuagePatterns()[1]).getStartColor();
        }
        if (this.parent.objectProperties.getGuagePatterns()[2] instanceof ChartColorPattern) {
            chartColorPatternArray[2] = (ChartColorPattern)this.parent.objectProperties.getGuagePatterns()[2];
        } else if (this.parent.objectProperties.getGuagePatterns()[2] instanceof ChartGradientPattern) {
            chartColorPatternArray[2] = ((ChartGradientPattern)this.parent.objectProperties.getGuagePatterns()[2]).getStartColor();
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f4, f3);
        if (chartColorPatternArray[0] != null && chartColorPatternArray[1] != null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[0]);
            chartGradientPattern.setEndColor(chartColorPatternArray[1]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_);
        } else if (chartColorPatternArray[0] == null && chartColorPatternArray[1] != null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[1]);
            chartGradientPattern.setEndColor(chartColorPatternArray[1]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_);
        } else if (chartColorPatternArray[0] != null && chartColorPatternArray[1] == null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[0]);
            chartGradientPattern.setEndColor(chartColorPatternArray[0]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_);
        }
        Rectangle2D.Float float_2 = new Rectangle2D.Float(f5, f6, f8, f7);
        if (chartColorPatternArray[1] != null && chartColorPatternArray[2] != null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[1]);
            chartGradientPattern.setEndColor(chartColorPatternArray[2]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_2);
        } else if (chartColorPatternArray[1] == null && chartColorPatternArray[2] != null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[2]);
            chartGradientPattern.setEndColor(chartColorPatternArray[2]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_2);
        } else if (chartColorPatternArray[1] != null && chartColorPatternArray[2] == null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[1]);
            chartGradientPattern.setEndColor(chartColorPatternArray[1]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_2);
        }
    }

    private void draw(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        ChartGradientPattern chartGradientPattern = new ChartGradientPattern(0);
        float f = (float)rectangle2D.getX();
        float f2 = this.parent.valueMin[0] == this.parent.valueMin[1] ? 0.0f : (float)((double)(Math.abs(this.parent.valueMin[1] - this.parent.valueMin[0]) / (this.parent.maxValue - this.parent.minValue)) * rectangle2D.getHeight());
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)(rectangle2D.getY() + rectangle2D.getHeight() - (double)f2);
        float f5 = (float)rectangle2D.getX();
        float f6 = (float)rectangle2D.getY();
        float f7 = (float)rectangle2D.getHeight() - f2;
        float f8 = (float)rectangle2D.getWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f4, f3, f2);
        chartGradientPattern.setStartColor(new ChartColorPattern(this.parent.objectProperties.getGaugeNormalColor()));
        chartGradientPattern.setEndColor(new ChartColorPattern(this.parent.objectProperties.getGaugeAlertColor()));
        chartGradientPattern.setStartPoint(new Point2D.Float(0.5f, 1.0f));
        chartGradientPattern.setEndPoint(new Point2D.Float(0.5f, 0.0f));
        chartGradientPattern.fill(graphics2D, float_);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(f5, f6, f8, f7);
        chartGradientPattern.setStartColor(new ChartColorPattern(this.parent.objectProperties.getGaugeAlertColor()));
        chartGradientPattern.setEndColor(new ChartColorPattern(this.parent.objectProperties.getGaugeErrorColor()));
        chartGradientPattern.setStartPoint(new Point2D.Float(0.5f, 1.0f));
        chartGradientPattern.setEndPoint(new Point2D.Float(0.5f, 0.0f));
        chartGradientPattern.fill(graphics2D, float_2);
    }

    public void fillValuePattern(Graphics2D graphics2D, boolean bl) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        switch (this.parent.objectProperties.getGaugeBarLayout()) {
            case 0: {
                f = this.startX;
                f2 = this.startY + this.textHeight + this.tempHeight + this.gap;
                break;
            }
            case 1: {
                f = this.startX + this.textWidth + this.tempWidth + this.gap;
                f2 = this.startY;
            }
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, this.barWidth, this.barHeight);
        if (bl) {
            switch (this.parent.objectProperties.getGaugeBarLayout()) {
                case 0: {
                    this.dataset(float_, graphics2D);
                    f3 = f + this.barWidth * (this.parent.categoryMaxValue[this.ID] - this.parent.valueMin[0]) / (this.parent.maxValue - this.parent.minValue);
                    f4 = f2;
                    f5 = this.barWidth - this.barWidth * (this.parent.categoryMaxValue[this.ID] - this.parent.valueMin[0]) / (this.parent.maxValue - this.parent.minValue);
                    f6 = this.barHeight;
                    break;
                }
                case 1: {
                    this.draw(float_, graphics2D);
                    f4 = f2;
                    f3 = f;
                    f6 = this.barHeight - this.barHeight * (this.parent.categoryMaxValue[this.ID] - this.parent.valueMin[0]) / (this.parent.maxValue - this.parent.minValue);
                    f5 = this.barWidth;
                }
            }
            Rectangle2D.Float float_2 = new Rectangle2D.Float(f3, f4, f5, f6);
            graphics2D.setColor(Color.white);
            graphics2D.fill(float_2);
        }
        this.parent.objectProperties.getGaugeBarPen().draw(graphics2D, float_);
    }

    public void fillBackPattern(Graphics2D graphics2D) {
    }

    public Shape getItemShapes(int n) {
        return this.itemShapes[n];
    }

    public void setStartX(float f) {
        this.startX = f;
    }

    public void setStartY(float f) {
        this.startY = f;
    }

    public void setCategoryLabel(ChartLabelBase chartLabelBase) {
        this.categoryLabel = chartLabelBase;
    }

    public Shape getAxisY1Shapes() {
        return this.axisLine;
    }
}

