/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageBar;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;

public class Graph2DGuageBars
extends Chart2DObject {
    Shape[] seriesShapes;
    Shape[][] itemShapes;
    int col;
    int row;
    Graph2DGuageBar[] children;
    float unitWidth;
    float unitHeight = 0.0f;
    float[] startX;
    float[] startY;
    String[][][] hintLabels;
    float[][] value;
    float[] categoryMaxValue;
    float[] valueMin;
    float[] valueMax;
    ChartLabelBase[] categoryLabels;
    float minValue;
    float maxValue;
    Line2D[] axisLineShapes;

    Graph2DGuageBars(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        int n;
        super.init();
        this.col = this.dataset.getCategorySize();
        this.row = this.dataset.getSeriesSize();
        this.children = new Graph2DGuageBar[this.col];
        this.seriesShapes = new Shape[this.row];
        this.itemShapes = new Shape[this.row][this.col];
        this.startX = new float[this.col];
        this.startY = new float[this.col];
        this.axisLineShapes = new Line2D[this.col];
        for (n = 0; n < this.row; ++n) {
            this.seriesShapes[n] = new GeneralPath();
        }
        for (n = 0; n < this.col; ++n) {
            this.children[n] = new Graph2DGuageBar(this, n);
        }
        this.SEDU();
        this.append();
        this.axisLineShapes();
    }

    private void SEDU() {
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        if (stringArray != null) {
            int n = stringArray.length;
            this.categoryLabels = new ChartLabelBase[n];
            for (int i = 0; i < n; ++i) {
                this.categoryLabels[i] = new ChartLabelBase(stringArray[i]);
                this.categoryLabels[i].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
                this.children[i].setCategoryLabel(this.categoryLabels[i]);
            }
        }
    }

    private void append() {
        int n;
        int n2;
        this.value = new float[this.row][this.col];
        this.categoryMaxValue = new float[this.col];
        this.hintLabels = new String[this.row][this.col][3];
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    this.value[n2][n] = 0.0f;
                    continue;
                }
                this.value[n2][n] = number.floatValue();
                if (this.layer.isShowCategoryAndSeries()) {
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    this.hintLabels[n2][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n2, n);
                    continue;
                }
                this.hintLabels[n2][n][0] = this.dataset.getFormatedHintValue(number);
            }
        }
        for (n2 = 0; n2 < this.col; ++n2) {
            this.categoryMaxValue[n2] = this.value[0][n2];
            for (n = 0; n < this.row; ++n) {
                if (!(this.value[n][n2] > this.categoryMaxValue[n2])) continue;
                this.categoryMaxValue[n2] = this.value[n][n2];
            }
        }
    }

    private void axisLineShapes() {
        int n;
        this.maxValue = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        this.minValue = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.valueMin = new float[3];
        this.valueMax = new float[3];
        this.valueMin[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.valueMin[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.valueMin[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.valueMax[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.valueMax[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.valueMax[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        for (n = 0; n < 3; ++n) {
            if (this.valueMin[n] > this.valueMax[n]) {
                float f = this.valueMin[n];
                this.valueMin[n] = this.valueMax[n];
                this.valueMax[n] = f;
            }
            bl = this.valueMax[n] == this.valueMax[n] && this.valueMax[n] == 0.0f && bl;
        }
        if (bl) {
            float f = (this.maxValue - this.minValue) / 3.0f;
            for (int i = 0; i < 3; ++i) {
                this.valueMin[i] = this.minValue + (float)i * f;
                this.valueMax[i] = this.valueMin[i] + f;
            }
        }
        for (n = 0; n < 3; ++n) {
            if (this.valueMin[n] < this.minValue) {
                this.valueMin[n] = this.minValue;
            }
            if (this.valueMin[n] > this.maxValue) {
                this.valueMin[n] = this.maxValue;
            }
            if (this.valueMax[n] < this.minValue) {
                this.valueMax[n] = this.minValue;
            }
            if (!(this.valueMax[n] > this.maxValue)) continue;
            this.valueMax[n] = this.maxValue;
        }
    }

    @Override
    public void locate() {
        switch (this.paper.getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.axisY();
                break;
            }
            case 1: {
                this.categoryLabels();
            }
        }
    }

    private void axisY() {
        this.unitWidth = (float)(this.paper.getBounds().getWidth() * (double)this.paper.getProperties().getScaleX()) - 10.0f;
        this.unitHeight = (float)(this.paper.getBounds().getHeight() * (double)this.paper.getProperties().getScaleY() - 10.0) / (float)this.col;
        float f = (float)this.paper.getBounds().getHeight() * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f + 5.0f;
        float f2 = (float)this.paper.getBounds().getWidth() * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f + 5.0f;
        float f3 = this.categoryMaxValue();
        f3 = f3 > f2 ? f3 : f2;
        f3 = f3 > this.unitWidth / 2.0f ? this.unitWidth / 2.0f : f3;
        float f4 = this.children();
        f4 = f4 > f2 ? f4 : f2;
        f2 = f3;
        this.unitWidth = (float)(this.paper.getBounds().getWidth() - (double)(f3 + f4));
        this.unitWidth = this.unitWidth < 0.0f ? 0.0f : this.unitWidth;
        for (int i = 0; i < this.col; ++i) {
            this.startX[i] = f2;
            this.startY[i] = f + (float)i * this.unitHeight;
            this.children[i].setStartX(this.startX[i]);
            this.children[i].setStartY(this.startY[i]);
            this.children[i].locate();
        }
    }

    private void categoryLabels() {
        this.unitHeight = (float)(this.paper.getBounds().getHeight() * (double)this.paper.getProperties().getScaleY() - 10.0);
        this.unitWidth = (float)(this.paper.getBounds().getWidth() * (double)this.paper.getProperties().getScaleX() - 10.0) / (float)this.col;
        float f = (float)this.paper.getBounds().getHeight() * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f + 5.0f;
        float f2 = (float)this.paper.getBounds().getWidth() * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f + 5.0f;
        for (int i = 0; i < this.col; ++i) {
            this.startY[i] = f;
            this.startX[i] = f2 + (float)i * this.unitWidth;
            this.children[i].setStartX(this.startX[i]);
            this.children[i].setStartY(this.startY[i]);
            this.children[i].locate();
        }
    }

    private float categoryMaxValue() {
        String[] stringArray;
        float f = 0.0f;
        String[] stringArray2 = stringArray = this.layer.axisY != null ? this.layer.axisY.getLabels() : null;
        if (stringArray != null && stringArray.length > 0 && this.objectProperties.getGaugeBarLayout() == 0) {
            f = (float)this.layer.axisY.getProperties().getLabelTextStyle().getDimension(stringArray[0]).getWidth();
        }
        return f / 2.0f;
    }

    private float children() {
        String[] stringArray;
        float f = 0.0f;
        String[] stringArray2 = stringArray = this.layer.axisY != null ? this.layer.axisY.getLabels() : null;
        if (stringArray != null && stringArray.length > 0 && this.objectProperties.getGaugeBarLayout() == 0) {
            f = (float)this.layer.axisY.getProperties().getLabelTextStyle().getDimension(stringArray[stringArray.length - 1]).getWidth();
        }
        return f / 2.0f;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        for (n = 0; n < this.col; ++n) {
            this.children[n].paint(graphics2D);
        }
        for (n = 0; n < this.row; ++n) {
            for (int i = 0; i < this.col; ++i) {
                this.itemShapes[n][i] = this.children[i].getItemShapes(n);
                ((GeneralPath)this.seriesShapes[n]).append(this.itemShapes[n][i], false);
            }
        }
        for (n = 0; n < this.col; ++n) {
            this.axisLineShapes[n] = (Line2D)this.children[n].getAxisY1Shapes();
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.seriesShapes[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (this.itemShapes[i][j] == null || !this.itemShapes[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.hintLabels[i][j];
            }
        }
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        int n3 = this.seriesShapes.length;
        for (int i = 0; i < this.row; ++i) {
            if (!this.seriesShapes[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public Chart2DPaper getPaper() {
        return this.paper;
    }

    public boolean searchAxisY(int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < this.col; ++i) {
            if (this.axisLineShapes[i] == null || !this.axisLineShapes[i].intersects(n - 5, n2 - 5, 10.0, 10.0)) continue;
            this.layer.axisY.setStatus(1);
            bl = true;
        }
        return bl;
    }

    public Line2D[] getAxisYShape() {
        return this.axisLineShapes;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.row / n5;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (this.itemShapes[i][j] == null || !this.itemShapes[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

