/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.axis.ChartAxisArrowStyle;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Graph2DGuageDials;
import chart.data.Chart1DDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;

public class Graph2DGuageDial {
    int id = 0;
    Graph2DGuageDials parent;
    ChartFillPattern[] gaugePatterns = new ChartFillPattern[3];

    Graph2DGuageDial(Graph2DGuageDials graph2DGuageDials, int n) {
        this.parent = graph2DGuageDials;
        this.id = n;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.parent.objectProperties.isGaugeDialCurveIsFill()) {
            this.getArrowPoint(graphics2D);
        }
        if (this.parent.paper.getProperties().isShowAxisY()) {
            this.gaugePatterns(graphics2D);
        }
        if (this.parent.paper.getProperties().getAxisYProperties().isShowGrid()) {
            this.getArrowLine(graphics2D);
        }
        this.fill(graphics2D);
        this.SEDU(graphics2D);
        this.draw(graphics2D);
        this.F(graphics2D);
    }

    private void F(Graphics2D graphics2D) {
        if (!this.parent.paper.getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            return;
        }
        ChartLabelBase chartLabelBase = this.parent.getCategoryLabel(this.id);
        if (chartLabelBase == null) {
            return;
        }
        float f = this.parent.getCategoryLabelsX(this.id);
        float f2 = this.parent.getCategoryLabelsY(this.id);
        chartLabelBase.locate();
        chartLabelBase.paint(graphics2D, f, f2);
    }

    private void SEDU(Graphics2D graphics2D) {
        ChartFillPattern[] chartFillPatternArray = this.parent.seriesPattern;
        int n = this.parent.row;
        float f = (float)((ChartNumericAxis)this.parent.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.parent.layer.getAxisY()).getMin();
        for (int i = 0; i < n; ++i) {
            if (((Chart1DDataSet)this.parent.dataset).getValue(i, this.id) == null || this.parent.value[i][this.id] > f || this.parent.value[i][this.id] < f2) continue;
            Shape shape = this.parent.getShapeByItem(i, this.id);
            this.dataset(graphics2D, shape, i, chartFillPatternArray[i]);
        }
    }

    private void dataset(Graphics2D graphics2D, Shape shape, int n, ChartFillPattern chartFillPattern) {
        if (shape == null) {
            return;
        }
        switch (this.parent.objectProperties.getGaugeDialLineStyle()) {
            case 0: 
            case 1: {
                if (chartFillPattern == null) break;
                chartFillPattern.fill(graphics2D, shape);
                if (!this.parent.objectProperties.isContour()) break;
                this.parent.objectProperties.getContourPen().draw(graphics2D, shape);
                break;
            }
            case 2: {
                Color color = null;
                ChartColorPattern chartColorPattern = null;
                if (this.parent.seriesPattern[n] == null) break;
                if (this.parent.seriesPattern[n] instanceof ChartColorPattern) {
                    chartColorPattern = (ChartColorPattern)this.parent.seriesPattern[n];
                    color = ((ChartColorPattern)this.parent.seriesPattern[n]).getColor();
                } else if (this.parent.seriesPattern[n] instanceof ChartGradientPattern) {
                    chartColorPattern = ((ChartGradientPattern)this.parent.seriesPattern[n]).getStartColor();
                    color = ((ChartGradientPattern)this.parent.seriesPattern[n]).getStartColor().getColor();
                } else if (this.parent.seriesPattern[n] instanceof ChartTexturePattern) {
                    chartColorPattern = ((ChartTexturePattern)this.parent.seriesPattern[n]).getForeground();
                    color = ((ChartTexturePattern)this.parent.seriesPattern[n]).getForeground().getColor();
                }
                ChartPenStyle chartPenStyle = new ChartPenStyle();
                chartPenStyle.setPenWidth(3.0f);
                chartPenStyle.setPenColor(chartColorPattern);
                if (this.parent.getArrowLine(n, this.id) != null) {
                    chartPenStyle.draw(graphics2D, this.parent.getArrowLine(n, this.id));
                }
                ChartAxisArrowStyle chartAxisArrowStyle = null;
                graphics2D.setColor(color);
                int n2 = (int)this.parent.getArrowPoint(n, this.id)[0];
                int n3 = (int)this.parent.getArrowPoint(n, this.id)[1];
                graphics2D.rotate(Math.PI * 2 + this.parent.getValueAngle(n, this.id) - 1.5707963267948966, n2, n3);
                switch (this.parent.objectProperties.getGaugeDialLineArrowStyle()) {
                    case 1: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(1);
                        break;
                    }
                    case 2: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(2);
                        break;
                    }
                    case 3: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(3);
                        break;
                    }
                    case 0: {
                        chartAxisArrowStyle = new ChartAxisArrowStyle(0);
                        break;
                    }
                }
                if (chartAxisArrowStyle != null) {
                    chartAxisArrowStyle.draw(graphics2D, n2, n3);
                }
                graphics2D.rotate(Math.PI * -2 - this.parent.getValueAngle(n, this.id) + 1.5707963267948966, n2, n3);
                break;
            }
        }
    }

    private void draw(Graphics2D graphics2D) {
        float f = this.parent.getCenterX(this.id);
        float f2 = this.parent.getCenterY(this.id);
        switch (this.parent.objectProperties.getGaugeDialLineStyle()) {
            case 0: 
            case 2: {
                Arc2D.Float float_ = new Arc2D.Float(f - this.parent.outerRadius / 10.0f, f2 - this.parent.outerRadius / 10.0f, this.parent.outerRadius / 5.0f, this.parent.outerRadius / 5.0f, 0.0f, 360.0f, 0);
                ChartGradientPattern chartGradientPattern = new ChartGradientPattern(3);
                chartGradientPattern.setStartColor(new ChartColorPattern(Color.white));
                chartGradientPattern.setEndColor(new ChartColorPattern(Color.gray));
                Point2D.Float float_2 = new Point2D.Float(0.3f, 0.3f);
                Point2D.Float float_3 = new Point2D.Float(1.0f, 1.0f);
                chartGradientPattern.setStartPoint(float_2);
                chartGradientPattern.setEndPoint(float_3);
                chartGradientPattern.fill(graphics2D, float_);
            }
        }
    }

    private void fill(Graphics2D graphics2D) {
        Shape shape = this.parent.getCurvePath(this.id);
        if (shape == null) {
            return;
        }
        this.parent.paper.getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, shape);
    }

    private void gaugePatterns(Graphics2D graphics2D) {
        Shape shape = this.parent.getAxisPaths(this.id);
        this.parent.paper.getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, shape);
        this.drawTickMark(graphics2D);
        if (this.parent.paper.getProperties().getAxisYProperties().isShowTickMarkLabels()) {
            this.getAlertArea(graphics2D);
        }
    }

    private void getAlertArea(Graphics2D graphics2D) {
        ChartLabelBase[] chartLabelBaseArray = this.parent.getLabels();
        if (chartLabelBaseArray == null) {
            return;
        }
        float[][] fArray2 = this.parent.getAxisLabelsPos(this.id);
        int n = chartLabelBaseArray.length;
        for (int i = 0; i < n; ++i) {
            chartLabelBaseArray[i].locate();
            chartLabelBaseArray[i].paint(graphics2D, fArray2[i][0], fArray2[i][1]);
        }
    }

    public void drawTickMark(Graphics2D graphics2D) {
        Shape[] shapeArray = this.parent.getTickPath(this.id);
        if (shapeArray == null) {
            return;
        }
        int n = shapeArray.length;
        for (int i = 0; i < n; ++i) {
            this.parent.paper.getProperties().getAxisYProperties().getTickMarkPen().draw(graphics2D, shapeArray[i]);
        }
    }

    private void getArrowLine(Graphics2D graphics2D) {
        Shape[] shapeArray = this.parent.getGridPath(this.id);
        if (shapeArray == null) {
            return;
        }
        int n = shapeArray.length;
        for (int i = 0; i < n; ++i) {
            this.parent.paper.getProperties().getAxisYProperties().getGridPen().draw(graphics2D, shapeArray[i]);
        }
    }

    private void getArrowPoint(Graphics2D graphics2D) {
        if (this.gaugePatterns[0] != null) {
            this.gaugePatterns[0].fill(graphics2D, this.parent.getNormalArea(this.id));
        }
        if (this.gaugePatterns[1] != null) {
            this.gaugePatterns[1].fill(graphics2D, this.parent.getAlertArea(this.id));
        }
        if (this.gaugePatterns[2] != null) {
            this.gaugePatterns[2].fill(graphics2D, this.parent.getErrorArea(this.id));
        }
    }

    public void setGaugePatterns(ChartFillPattern[] chartFillPatternArray) {
        this.gaugePatterns = chartFillPatternArray;
    }
}

