/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageDial;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartTextStyle;
import chart.util.ChartHintLabel;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class Graph2DGuageDials
extends Chart2DObject {
    private static final int SEDU = 10;
    private static final int abs = 3;
    private static final float append = 0.6f;
    private static final int axisY = 5;
    float[] valueMin;
    float[] valueMax;
    float[][] value;
    String[][][] hintLabels;
    Graph2DGuageDial[] children;
    int col;
    int row;
    float outerRadius;
    float[][] outer;
    float[][] centers;
    float[][][] axisLabelsPos;
    float[][] categoryLabelsPos;
    Shape[] curvePath;
    Shape[] seriesShapes;
    Shape[] axisPath;
    Shape[][] tickPaths;
    Shape[][] gridPath;
    Shape[][] curveFillArea;
    Shape[][] arrowPaths;
    float[][][] arrowPointer;
    Line2D[][] arrowLine;
    Arc2D[] circlePointer;
    Shape[][] itemShapes;
    ChartLabelBase[] categoryLabels;
    ChartLabelBase[] axisLabels;
    private float clone;
    private float contains;
    float arcExtent;
    float startAngle;
    float stopAngle;
    double[][] valueAngles;
    Shape[][] axisSelectedPaths;

    Graph2DGuageDials(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        super.init();
        this.row = this.dataset.getSeriesSize();
        this.col = this.dataset.getCategorySize();
        this.children = new Graph2DGuageDial[this.col];
        ChartFillPattern[] chartFillPatternArray = this.objectProperties.getGuagePatterns();
        for (int i = 0; i < this.col; ++i) {
            this.children[i] = new Graph2DGuageDial(this, i);
            this.children[i].setGaugePatterns(chartFillPatternArray);
        }
        this.valueAngles = new double[this.row][this.col];
        this.startAngle = this.objectProperties.getGaugeDialStartAngle();
        this.stopAngle = this.objectProperties.getGaugeDialStopAngle();
        this.arcExtent = this.stopAngle - this.startAngle;
        this.SEDU();
        this.arrowPaths();
        this.arrowLine();
        this.arrowPointer();
    }

    private void SEDU() {
        this.value = new float[this.row][this.col];
        this.hintLabels = new String[this.row][this.col][3];
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(i, j);
                if (number == null) {
                    this.value[i][j] = 0.0f;
                    continue;
                }
                this.value[i][j] = number.floatValue();
                if (this.layer.isShowCategoryAndSeries()) {
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    this.hintLabels[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                    continue;
                }
                this.hintLabels[i][j][0] = this.dataset.getFormatedHintValue(number);
            }
        }
    }

    @Override
    public void locate() {
        if (this.objectProperties.getGaugeDialStartAngle() >= 0.0f && this.objectProperties.getGaugeDialStartAngle() <= 180.0f && this.objectProperties.getGaugeDialStopAngle() >= 0.0f && this.objectProperties.getGaugeDialStopAngle() <= 180.0f) {
            this.append();
        } else {
            this.arcExtent();
        }
        this.axisLabelsPos();
        this.axisPath();
        this.categoryLabels();
        this.axisLabels();
        this.axisY();
        this.categoryLabelsPos();
        this.axisSelectedPaths();
    }

    private int[] abs() {
        int[] nArray = new int[2];
        float f = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f2 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f3 = Math.min(f, f2);
        float f4 = Math.max(f, f2);
        int n = 1;
        int n2 = 1;
        boolean bl = false;
        for (int i = 1; i <= this.col; ++i) {
            n = i;
            for (int j = 1; j <= (int)(f4 / (f3 / (float)n)); ++j) {
                if (n * j < this.col) continue;
                n2 = j;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (f >= f2) {
            nArray[0] = n;
            nArray[1] = n2;
        } else {
            nArray[0] = n2;
            nArray[1] = n;
        }
        return nArray;
    }

    private void append() {
        int[] nArray = this.abs();
        this.outer = new float[this.col][2];
        this.centers = new float[this.col][2];
        float f = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f2 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f3 = f2 / (float)nArray[0];
        float f4 = f / (float)nArray[1];
        float f5 = Math.min(f3 * 2.0f, f / (float)nArray[1]);
        float f6 = f5 / 2.0f;
        float f7 = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f8 = (float)this.paper.getBounds().height * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f;
        float f9 = f7 + (f4 - f5 * this.objectProperties.getRadiusRange()) / 2.0f;
        float f10 = f8 + (f3 - f6 * this.objectProperties.getRadiusRange()) / 2.0f;
        this.outerRadius = (int)(f6 * this.objectProperties.getRadiusRange());
        float f11 = this.centers(f6);
        if (f11 < this.outerRadius && this.layer.getAxisY().getProperties().getTickMarkType() == 1) {
            f9 += this.outerRadius - f11;
            f10 += this.outerRadius - f11;
            this.outerRadius = f11;
        }
        this.clone = this.objectProperties.getGaugeDialOuterInnerGap() > this.outerRadius ? this.outerRadius : this.objectProperties.getGaugeDialOuterInnerGap();
        this.contains = this.outerRadius - this.clone;
        for (int i = 0; i < this.col; ++i) {
            int n = i / nArray[1];
            int n2 = i % nArray[1];
            this.outer[i][0] = f9 + (float)n2 * f4;
            this.outer[i][1] = f10 + (float)n * f3;
            this.centers[i][0] = this.outer[i][0] + this.outerRadius;
            this.centers[i][1] = this.outer[i][1] + this.outerRadius;
        }
    }

    private void arcExtent() {
        float f;
        this.outer = new float[this.col][2];
        this.centers = new float[this.col][2];
        int[] nArray = this.abs();
        float f2 = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f3 = (float)this.paper.getBounds().height * this.paper.getProperties().getScaleY();
        float f4 = f = Math.min(f3 / (float)nArray[0], f2 / (float)nArray[1]);
        float f5 = f2 / (float)nArray[1];
        float f6 = f3 / (float)nArray[0];
        float f7 = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f8 = (float)this.paper.getBounds().height * (1.0f - this.paper.getProperties().getScaleY()) / 2.0f;
        float f9 = f7 + (f5 - f * this.objectProperties.getRadiusRange()) / 2.0f;
        float f10 = f8 + (f6 - f4 * this.objectProperties.getRadiusRange()) / 2.0f;
        this.outerRadius = (int)(f4 * this.objectProperties.getRadiusRange()) / 2;
        float f11 = this.centers(f4 / 2.0f);
        if (f11 < this.outerRadius && this.layer.getAxisY().getProperties().getTickMarkType() == 1) {
            f9 += this.outerRadius - f11;
            f10 += this.outerRadius - f11;
            this.outerRadius = f11;
        }
        this.clone = this.objectProperties.getGaugeDialOuterInnerGap() > this.outerRadius ? this.outerRadius : this.objectProperties.getGaugeDialOuterInnerGap();
        this.contains = this.outerRadius - this.clone;
        for (int i = 0; i < this.col; ++i) {
            int n = i / nArray[1];
            int n2 = i % nArray[1];
            this.outer[i][0] = f9 + (float)n2 * f5;
            this.outer[i][1] = f10 + (float)n * f6;
            this.centers[i][0] = this.outer[i][0] + this.outerRadius;
            this.centers[i][1] = this.outer[i][1] + this.outerRadius;
        }
    }

    private void arrowLine() {
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        if (stringArray != null) {
            int n = stringArray.length;
            this.categoryLabels = new ChartLabelBase[n];
            for (int i = 0; i < n; ++i) {
                this.categoryLabels[i] = new ChartLabelBase(stringArray[i]);
                this.categoryLabels[i].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
            }
        }
    }

    private void arrowPaths() {
        int n;
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.valueMin = new float[3];
        this.valueMax = new float[3];
        this.valueMin[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.valueMin[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.valueMin[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.valueMax[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.valueMax[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.valueMax[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        for (n = 0; n < 3; ++n) {
            if (this.valueMin[n] > this.valueMax[n]) {
                float f3 = this.valueMin[n];
                this.valueMin[n] = this.valueMax[n];
                this.valueMax[n] = f3;
            }
            bl = this.valueMax[n] == this.valueMax[n] && this.valueMax[n] == 0.0f && bl;
        }
        if (bl) {
            float f4 = (f - f2) / 3.0f;
            for (int i = 0; i < 3; ++i) {
                this.valueMin[i] = f2 + (float)i * f4;
                this.valueMax[i] = this.valueMin[i] + f4;
            }
        }
        for (n = 0; n < 3; ++n) {
            if (this.valueMin[n] < f2) {
                this.valueMin[n] = f2;
            }
            if (this.valueMin[n] > f) {
                this.valueMin[n] = f;
            }
            if (this.valueMax[n] < f2) {
                this.valueMax[n] = f2;
            }
            if (!(this.valueMax[n] > f)) continue;
            this.valueMax[n] = f;
        }
    }

    private void arrowPointer() {
        String[] stringArray = ((ChartNumericAxis)this.layer.axisY).getLabels();
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length;
        this.axisLabels = new ChartLabelBase[n];
        for (int i = 0; i < n; ++i) {
            this.axisLabels[i] = new ChartLabelBase(stringArray[n - i - 1]);
            this.axisLabels[i].setChartTextStyle(this.paper.getProperties().getAxisYProperties().getLabelTextStyle());
            this.axisLabels[i].locate();
        }
    }

    private void axisLabels() {
        if (this.categoryLabels == null) {
            return;
        }
        int n = this.categoryLabels.length;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisXProperties().getLabelTextStyle();
        this.categoryLabelsPos = new float[n][2];
        for (int i = 0; i < n; ++i) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(this.categoryLabels[i].getLabelText());
            if (this.objectProperties.getGaugeDialStartAngle() >= 0.0f && this.objectProperties.getGaugeDialStopAngle() <= 180.0f && this.objectProperties.getGaugeDialStopAngle() >= 0.0f && this.objectProperties.getGaugeDialStartAngle() <= 180.0f) {
                this.categoryLabelsPos[i][0] = (float)((double)this.centers[i][0] - rectangle2D.getWidth() / 2.0);
                this.categoryLabelsPos[i][1] = this.centers[i][1] + this.paper.getProperties().getAxisXProperties().getLabelAxisGap();
                continue;
            }
            this.categoryLabelsPos[i][0] = (float)((double)this.centers[i][0] - rectangle2D.getWidth() / 2.0);
            this.categoryLabelsPos[i][1] = (float)((double)this.centers[i][1] - rectangle2D.getHeight() / 2.0) + this.paper.getProperties().getAxisXProperties().getLabelAxisGap();
        }
    }

    private void axisLabelsPos() {
        this.axisPath = new Shape[this.col];
        switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
            case 0: 
            case 1: {
                this.axisSelectedPaths = new Shape[1][this.col];
                for (int i = 0; i < this.col; ++i) {
                    this.axisPath[i] = new Arc2D.Float(this.outer[i][0], this.outer[i][1], this.outerRadius * 2.0f, this.outerRadius * 2.0f, this.startAngle, this.arcExtent, 0);
                    this.axisSelectedPaths[0][i] = this.axisPath[i];
                }
                break;
            }
            case 2: {
                this.axisSelectedPaths = new Shape[1][this.col];
                for (int i = 0; i < this.col; ++i) {
                    this.axisPath[i] = new Arc2D.Float(this.outer[i][0] + this.clone, this.outer[i][1] + this.clone, this.contains * 2.0f, this.contains * 2.0f, this.startAngle, this.arcExtent, 0);
                    this.axisSelectedPaths[0][i] = this.axisPath[i];
                }
                break;
            }
            case 3: {
                this.axisSelectedPaths = new Shape[2][this.col];
                for (int i = 0; i < this.col; ++i) {
                    Arc2D.Float float_ = new Arc2D.Float(this.outer[i][0], this.outer[i][1], this.outerRadius * 2.0f, this.outerRadius * 2.0f, this.startAngle, this.arcExtent, 0);
                    Arc2D.Float float_2 = new Arc2D.Float(this.outer[i][0] + this.clone, this.outer[i][1] + this.clone, this.contains * 2.0f, this.contains * 2.0f, this.startAngle, this.arcExtent, 0);
                    this.axisPath[i] = new GeneralPath(float_);
                    ((GeneralPath)this.axisPath[i]).append(float_2, false);
                    this.axisSelectedPaths[0][i] = float_;
                    this.axisSelectedPaths[1][i] = float_2;
                }
                break;
            }
        }
    }

    private void axisPath() {
        int n = ((ChartNumericAxis)this.layer.getAxisY()).getNumOfTick();
        float f = this.paper.getProperties().getAxisYProperties().getTickMarkLength();
        float f2 = this.paper.getProperties().getAxisYProperties().getMinorTickMarkLength();
        float f3 = this.paper.getProperties().getAxisYProperties().getLabelAxisGap();
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisYProperties().getLabelTextStyle();
        float[][] fArray2 = new float[2][2];
        float[][] fArray3 = new float[2][2];
        this.tickPaths = new Shape[this.col][2 * n + 1];
        this.axisLabelsPos = new float[this.col][n + 1][2];
        for (int i = 0; i < this.col; ++i) {
            double d = (double)this.arcExtent / (2.0 * (double)n);
            block7: for (int j = 0; j < 2 * n + 1; ++j) {
                this.tickPaths[i][j] = new GeneralPath();
                double d2 = Math.cos((180.0 - (double)j * d - (double)this.startAngle) * Math.PI / 180.0);
                double d3 = Math.sin((180.0 - (double)j * d - (double)this.startAngle) * Math.PI / 180.0);
                switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
                    case 1: {
                        Cloneable cloneable;
                        if (j % 2 == 0) {
                            fArray2[0][0] = (float)((double)this.centers[i][0] - (double)(this.outerRadius + f) * d2);
                            fArray2[0][1] = (float)((double)this.centers[i][1] - (double)(this.outerRadius + f) * d3);
                            cloneable = this.axisLabels[j / 2].getLabelBaseDimension();
                            float f4 = (float)((double)this.centers[i][0] - (double)(this.outerRadius + f + f3) * d2);
                            float f5 = (float)((double)this.centers[i][1] - (double)(this.outerRadius + f + f3) * d3);
                            this.axisLabelsPos[i][j / 2][0] = Math.abs(d2) * 10.0 < 1.0 ? f4 - (float)(cloneable.width / 2) : (d2 > 0.0 ? f4 - (float)cloneable.width : f4);
                            this.axisLabelsPos[i][j / 2][1] = d3 >= 0.0 ? f5 - (float)cloneable.height : f5;
                        } else {
                            fArray2[0][0] = (float)((double)this.centers[i][0] - (double)(this.outerRadius + f2) * d2);
                            fArray2[0][1] = (float)((double)this.centers[i][1] - (double)(this.outerRadius + f2) * d3);
                        }
                        fArray2[1][0] = (float)((double)this.centers[i][0] - (double)this.outerRadius * d2);
                        fArray2[1][1] = (float)((double)this.centers[i][1] - (double)this.outerRadius * d3);
                        ((GeneralPath)this.tickPaths[i][j]).moveTo(fArray2[0][0], fArray2[0][1]);
                        ((GeneralPath)this.tickPaths[i][j]).lineTo(fArray2[1][0], fArray2[1][1]);
                        continue block7;
                    }
                    case 2: {
                        Cloneable cloneable;
                        if (j % 2 == 0) {
                            fArray3[0][0] = (float)((double)this.centers[i][0] - (double)(this.contains - f) * d2);
                            fArray3[0][1] = (float)((double)this.centers[i][1] - (double)(this.contains - f) * d3);
                            cloneable = this.axisLabels[j / 2].getLabelBaseDimension();
                            float f6 = (float)((double)this.centers[i][0] - (double)(this.contains - f - f3) * d2);
                            float f7 = (float)((double)this.centers[i][1] - (double)(this.contains - f - f3) * d3);
                            this.axisLabelsPos[i][j / 2][0] = Math.abs(d2 * 10.0) < 1.0 ? f6 - (float)(cloneable.width / 2) : (d2 > 0.0 ? f6 : f6 - (float)cloneable.width);
                            this.axisLabelsPos[i][j / 2][1] = Math.abs(d3 * 10.0) < 1.0 ? f7 - (float)cloneable.height : (d3 > 0.0 ? f7 : f7 - (float)cloneable.height);
                        } else {
                            fArray3[0][0] = (float)((double)this.centers[i][0] - (double)(this.contains - f2) * d2);
                            fArray3[0][1] = (float)((double)this.centers[i][1] - (double)(this.contains - f2) * d3);
                        }
                        fArray3[1][0] = (float)((double)this.centers[i][0] - (double)this.contains * d2);
                        fArray3[1][1] = (float)((double)this.centers[i][1] - (double)this.contains * d3);
                        ((GeneralPath)this.tickPaths[i][j]).moveTo(fArray3[0][0], fArray3[0][1]);
                        ((GeneralPath)this.tickPaths[i][j]).lineTo(fArray3[1][0], fArray3[1][1]);
                        continue block7;
                    }
                    case 3: {
                        Cloneable cloneable;
                        fArray2[0][0] = (float)((double)this.centers[i][0] - (double)this.outerRadius * d2);
                        fArray2[0][1] = (float)((double)this.centers[i][1] - (double)this.outerRadius * d3);
                        if (j % 2 == 0) {
                            fArray2[1][0] = (float)((double)this.centers[i][0] - (double)(this.outerRadius - f) * d2);
                            fArray2[1][1] = (float)((double)this.centers[i][1] - (double)(this.outerRadius - f) * d3);
                        } else {
                            fArray2[1][0] = (float)((double)this.centers[i][0] - (double)(this.outerRadius - f2) * d2);
                            fArray2[1][1] = (float)((double)this.centers[i][1] - (double)(this.outerRadius - f2) * d3);
                        }
                        fArray3[0][0] = (float)((double)this.centers[i][0] - (double)this.contains * d2);
                        fArray3[0][1] = (float)((double)this.centers[i][1] - (double)this.contains * d3);
                        if (j % 2 == 0) {
                            fArray3[1][0] = (float)((double)this.centers[i][0] - (double)(this.contains + f) * d2);
                            fArray3[1][1] = (float)((double)this.centers[i][1] - (double)(this.contains + f) * d3);
                        } else {
                            fArray3[1][0] = (float)((double)this.centers[i][0] - (double)(this.contains + f2) * d2);
                            fArray3[1][1] = (float)((double)this.centers[i][1] - (double)(this.contains + f2) * d3);
                        }
                        if (j % 2 == 0) {
                            cloneable = this.axisLabels[j / 2].getLabelBaseDimension();
                            float f8 = (float)((double)this.centers[i][0] - (double)((this.contains + this.outerRadius) / 2.0f) * d2);
                            float f9 = (float)((double)this.centers[i][1] - (double)((this.contains + this.outerRadius) / 2.0f) * d3);
                            if (Math.abs(d3 * 10.0) < 1.0) {
                                this.axisLabelsPos[i][j / 2][0] = f8 - (float)(cloneable.width / 2);
                                this.axisLabelsPos[i][j / 2][1] = f9 - (float)cloneable.height;
                            } else {
                                this.axisLabelsPos[i][j / 2][0] = f8 - (float)(cloneable.width / 2);
                                this.axisLabelsPos[i][j / 2][1] = f9 - (float)(cloneable.height / 2);
                            }
                        }
                        cloneable = new Line2D.Float(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1]);
                        Line2D.Float float_ = new Line2D.Float(fArray3[0][0], fArray3[0][1], fArray3[1][0], fArray3[1][1]);
                        this.tickPaths[i][j] = new GeneralPath((Shape)((Object)cloneable));
                        ((GeneralPath)this.tickPaths[i][j]).append(float_, false);
                        continue block7;
                    }
                    case 0: {
                        if (j % 2 != 0) continue block7;
                        Dimension dimension = this.axisLabels[j / 2].getLabelBaseDimension();
                        float f10 = (float)((double)this.centers[i][0] - (double)(this.outerRadius + f3) * d2);
                        float f11 = (float)((double)this.centers[i][1] - (double)(this.outerRadius + f3) * d3);
                        this.axisLabelsPos[i][j / 2][0] = Math.abs(d2) * 10.0 < 1.0 ? f10 - (float)(dimension.width / 2) : (d2 > 0.0 ? f10 - (float)dimension.width : f10);
                        if (d3 >= 0.0) {
                            this.axisLabelsPos[i][j / 2][1] = f11 - (float)dimension.height;
                            continue block7;
                        }
                        this.axisLabelsPos[i][j / 2][1] = f11;
                        continue block7;
                    }
                }
            }
        }
    }

    private void axisSelectedPaths() {
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        float[] fArray2 = new float[2];
        this.itemShapes = new Shape[this.row][this.col];
        this.seriesShapes = new Shape[this.row];
        this.arrowLine = new Line2D[this.row][this.col];
        this.circlePointer = new Arc2D[this.col];
        this.arrowPaths = new Shape[this.row][this.col];
        this.arrowPointer = new float[this.row][this.col][2];
        for (int i = 0; i < this.row; ++i) {
            this.seriesShapes[i] = new GeneralPath();
            for (int j = 0; j < this.col; ++j) {
                double d;
                this.itemShapes[i][j] = new GeneralPath();
                if (this.value[i][j] > f || this.value[i][j] < f2) continue;
                float f3 = 180.0f - this.startAngle - (float)((int)((f - this.value[i][j]) * this.arcExtent / (f - f2)));
                this.valueAngles[i][j] = d = (double)f3 * Math.PI / 180.0;
                double d2 = Math.cos(d);
                double d3 = Math.sin(d);
                fArray2[0] = this.centers[j][0] - (float)((int)((double)(this.outerRadius - this.clone / 5.0f) * d2));
                fArray2[1] = this.centers[j][1] - (float)((int)((double)(this.outerRadius - this.clone / 5.0f) * d3));
                switch (this.objectProperties.getGaugeDialLineStyle()) {
                    case 0: {
                        float f4 = this.outerRadius / 16.0f;
                        ((GeneralPath)this.itemShapes[i][j]).moveTo((float)((double)this.centers[j][0] - (double)f4 * d3), (float)((double)this.centers[j][1] + (double)f4 * d2));
                        ((GeneralPath)this.itemShapes[i][j]).lineTo((float)((double)this.centers[j][0] + (double)f4 * d3), (float)((double)this.centers[j][1] - (double)f4 * d2));
                        ((GeneralPath)this.itemShapes[i][j]).lineTo(fArray2[0], fArray2[1]);
                        ((GeneralPath)this.itemShapes[i][j]).lineTo((float)((double)this.centers[j][0] - (double)f4 * d3), (float)((double)this.centers[j][1] + (double)f4 * d2));
                        break;
                    }
                    case 1: {
                        double d4 = Math.cos(0.1308996938995747);
                        double d5 = Math.cos(d - 0.1308996938995747);
                        double d6 = Math.sin(d - 0.1308996938995747);
                        double d7 = (double)this.outerRadius / (5.0 * Math.cos(d4));
                        float f5 = (float)((double)this.centers[j][0] - d7 * d5);
                        float f6 = (float)((double)this.centers[j][1] - d7 * d6);
                        ((GeneralPath)this.itemShapes[i][j]).moveTo(this.centers[j][0], this.centers[j][1]);
                        ((GeneralPath)this.itemShapes[i][j]).lineTo(f5, f6);
                        ((GeneralPath)this.itemShapes[i][j]).lineTo(fArray2[0], fArray2[1]);
                        d5 = Math.cos(d + 0.1308996938995747);
                        d6 = Math.sin(d + 0.1308996938995747);
                        f5 = (float)((double)this.centers[j][0] - d7 * d5);
                        f6 = (float)((double)this.centers[j][1] - d7 * d6);
                        ((GeneralPath)this.itemShapes[i][j]).lineTo(f5, f6);
                        ((GeneralPath)this.itemShapes[i][j]).lineTo(this.centers[j][0], this.centers[j][1]);
                        break;
                    }
                    case 2: {
                        float f7 = (float)((double)this.centers[j][0] - (double)(this.outerRadius - 2.0f * this.clone / 5.0f) * d2);
                        float f8 = (float)((double)this.centers[j][1] - (double)(this.outerRadius - 2.0f * this.clone / 5.0f) * d3);
                        this.arrowPointer[i][j][0] = f7;
                        this.arrowPointer[i][j][1] = f8;
                        this.arrowLine[i][j] = new Line2D.Float((float)((double)this.centers[j][0] + (double)this.outerRadius * d2 / 6.0), (float)((double)this.centers[j][1] + (double)this.outerRadius * d3 / 6.0), f7, f8);
                        ((GeneralPath)this.itemShapes[i][j]).moveTo((float)((double)this.centers[j][0] + (double)this.outerRadius * d2 / 6.0), (float)((double)this.centers[j][1] + (double)this.outerRadius * d3 / 6.0));
                        ((GeneralPath)this.itemShapes[i][j]).lineTo(f7, f8);
                        this.arrowPaths[i][j] = new GeneralPath();
                        ((GeneralPath)this.arrowPaths[i][j]).moveTo(f7 - 5.0f, f8 + 5.0f);
                        ((GeneralPath)this.arrowPaths[i][j]).lineTo(f7 + 5.0f, f8 + 5.0f);
                        ((GeneralPath)this.arrowPaths[i][j]).lineTo(f7 + 5.0f, f8 - 5.0f);
                        ((GeneralPath)this.arrowPaths[i][j]).lineTo(f7 - 5.0f, f8 - 5.0f);
                        ((GeneralPath)this.arrowPaths[i][j]).lineTo(f7 - 5.0f, f8 + 5.0f);
                        ((GeneralPath)this.itemShapes[i][j]).append(this.arrowPaths[i][j], false);
                        this.circlePointer[j] = new Arc2D.Float(this.centers[j][0] - 5.0f, this.centers[j][1], 10.0f, 10.0f, 0.0f, 360.0f, 0);
                        break;
                    }
                }
                ((GeneralPath)this.seriesShapes[i]).append(this.itemShapes[i][j], false);
            }
        }
    }

    private void axisY() {
        this.curveFillArea = new Shape[this.col][3];
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.col; ++j) {
                float f3 = (this.valueMax[i] - f2) * this.arcExtent / (f - f2);
                float f4 = (this.valueMin[i] - f2) * this.arcExtent / (f - f2);
                float f5 = f3 - f4;
                float f6 = (f - this.valueMax[i]) * this.arcExtent / (f - f2) + this.startAngle;
                this.curveFillArea[j][i] = new Arc2D.Double(this.outer[j][0], this.outer[j][1], this.outerRadius * 2.0f, this.outerRadius * 2.0f, f6, f5, 2);
                Area area = new Area(this.curveFillArea[j][i]);
                Arc2D.Double double_ = new Arc2D.Double(this.outer[j][0] + this.clone, this.outer[j][1] + this.clone, (this.outerRadius - this.clone) * 2.0f, (this.outerRadius - this.clone) * 2.0f, -0.0, 360.0, 1);
                area.subtract(new Area(double_));
                this.curveFillArea[j][i] = area;
            }
        }
    }

    private void categoryLabels() {
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.gridPath = new Shape[this.col][4];
        for (int i = 0; i < this.col; ++i) {
            for (int j = 0; j < 4; ++j) {
                float f3;
                float f4;
                float f5;
                float f6;
                double d;
                if (j == 0) {
                    d = (double)(this.stopAngle - (this.valueMin[j] - f2) * this.arcExtent / (f - f2)) * Math.PI / 180.0;
                    f6 = (float)((double)this.centers[i][0] + (double)this.outerRadius * Math.cos(d));
                    f5 = (float)((double)this.centers[i][1] - (double)this.outerRadius * Math.sin(d));
                    f4 = (float)((double)this.centers[i][0] + (double)this.contains * Math.cos(d));
                    f3 = (float)((double)this.centers[i][1] - (double)this.contains * Math.sin(d));
                    this.gridPath[i][j] = new Line2D.Float(f6, f5, f4, f3);
                    continue;
                }
                d = (double)(this.stopAngle - (this.valueMax[j - 1] - f2) * this.arcExtent / (f - f2)) * Math.PI / 180.0;
                f6 = (float)((double)this.centers[i][0] + (double)this.outerRadius * Math.cos(d));
                f5 = (float)((double)this.centers[i][1] - (double)this.outerRadius * Math.sin(d));
                f4 = (float)((double)this.centers[i][0] + (double)this.contains * Math.cos(d));
                f3 = (float)((double)this.centers[i][1] - (double)this.contains * Math.sin(d));
                this.gridPath[i][j] = new Line2D.Float(f6, f5, f4, f3);
            }
        }
    }

    private void categoryLabelsPos() {
        float f = this.outerRadius - this.clone;
        this.curvePath = new Shape[this.col];
        block5: for (int i = 0; i < this.col; ++i) {
            float f2 = this.outer[i][0] + this.clone;
            float f3 = this.outer[i][1] + this.clone;
            switch (this.objectProperties.getGaugeDialCurveStyle()) {
                case 0: {
                    Arc2D.Float float_ = new Arc2D.Float(this.outer[i][0], this.outer[i][1], this.outerRadius * 2.0f, this.outerRadius * 2.0f, this.startAngle, this.arcExtent, 0);
                    Arc2D.Double double_ = new Arc2D.Double(f2, f3, f * 2.0f, f * 2.0f, this.startAngle, this.arcExtent, 0);
                    GeneralPath generalPath = new GeneralPath();
                    GeneralPath generalPath2 = new GeneralPath();
                    float f4 = this.centers[i][0] + (float)((double)this.outerRadius * Math.cos(Math.PI * (double)this.startAngle / 180.0));
                    float f5 = this.centers[i][1] - (float)((double)this.outerRadius * Math.sin(Math.PI * (double)this.startAngle / 180.0));
                    float f6 = this.centers[i][0] + (float)((double)f * Math.cos(Math.PI * (double)this.startAngle / 180.0));
                    float f7 = this.centers[i][1] - (float)((double)f * Math.sin(Math.PI * (double)this.startAngle / 180.0));
                    float f8 = this.centers[i][0] + (float)((double)this.outerRadius * Math.cos(Math.PI * (double)this.stopAngle / 180.0));
                    float f9 = this.centers[i][1] - (float)((double)this.outerRadius * Math.sin(Math.PI * (double)this.stopAngle / 180.0));
                    float f10 = this.centers[i][0] + (float)((double)f * Math.cos(Math.PI * (double)this.stopAngle / 180.0));
                    float f11 = this.centers[i][1] - (float)((double)f * Math.sin(Math.PI * (double)this.stopAngle / 180.0));
                    GeneralPath generalPath3 = new GeneralPath(double_);
                    GeneralPath generalPath4 = new GeneralPath(float_);
                    generalPath.moveTo(f4, f5);
                    generalPath.lineTo(f6, f7);
                    generalPath2.moveTo(f8, f9);
                    generalPath2.lineTo(f10, f11);
                    this.curvePath[i] = new GeneralPath();
                    ((GeneralPath)this.curvePath[i]).append(generalPath4, false);
                    ((GeneralPath)this.curvePath[i]).append(generalPath3, false);
                    ((GeneralPath)this.curvePath[i]).append(generalPath2, false);
                    ((GeneralPath)this.curvePath[i]).append(generalPath, false);
                    continue block5;
                }
                case 1: {
                    this.curvePath[i] = new Arc2D.Double((this.outer[i][0] + f2) / 2.0f, (this.outer[i][1] + f3) / 2.0f, ((double)f + (double)this.clone / 2.0) * 2.0, ((double)f + (double)this.clone / 2.0) * 2.0, this.startAngle, this.arcExtent, 0);
                    continue block5;
                }
                case 3: {
                    continue block5;
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.col; ++i) {
            this.children[i].paint(graphics2D);
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.seriesShapes[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (this.itemShapes[i][j] == null || !this.itemShapes[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.hintLabels[i][j];
            }
        }
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.row; ++i) {
            if (!this.seriesShapes[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public boolean searchGrid(int n, int n2) {
        for (int i = 0; i < this.col; ++i) {
            for (int j = 0; j < this.gridPath[0].length; ++j) {
                if (!this.gridPath[i][j].intersects(n - 2, n2 - 2, 5.0, 5.0)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean searchAxis(int n, int n2) {
        switch (this.paper.getProperties().getAxisYProperties().getTickMarkType()) {
            case 3: {
                for (int i = 0; i < this.col; ++i) {
                    Arc2D.Float float_ = new Arc2D.Float(this.outer[i][0] + 5.0f + this.clone, this.outer[i][1] + 5.0f + this.clone, 2.0f * (this.outerRadius - 5.0f - this.clone), 2.0f * (this.outerRadius - 5.0f - this.clone), this.startAngle, this.stopAngle, 0);
                    Arc2D.Float float_2 = new Arc2D.Float(this.outer[i][0] - 5.0f + this.clone, this.outer[i][1] - 5.0f + this.clone, 2.0f * (this.outerRadius + 5.0f - this.clone), 2.0f * (this.outerRadius + 5.0f - this.clone), this.startAngle, this.stopAngle, 0);
                    Arc2D.Float float_3 = new Arc2D.Float(this.outer[i][0] + 5.0f, this.outer[i][1] + 5.0f, 2.0f * (this.outerRadius - 5.0f), 2.0f * (this.outerRadius - 5.0f), this.startAngle, this.stopAngle, 0);
                    Arc2D.Float float_4 = new Arc2D.Float(this.outer[i][0] - 5.0f, this.outer[i][1] - 5.0f, 2.0f * (this.outerRadius + 5.0f), 2.0f * (this.outerRadius + 5.0f), this.startAngle, this.stopAngle, 0);
                    if ((float_.contains(n, n2) || !float_2.contains(n, n2)) && (float_3.contains(n, n2) || !float_4.contains(n, n2))) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.col; ++i) {
                    Arc2D.Float float_ = new Arc2D.Float(this.outer[i][0] + 5.0f + this.clone, this.outer[i][1] + 5.0f + this.clone, 2.0f * (this.outerRadius - 5.0f - this.clone), 2.0f * (this.outerRadius - 5.0f - this.clone), this.startAngle, this.stopAngle, 0);
                    Arc2D.Float float_5 = new Arc2D.Float(this.outer[i][0] - 5.0f + this.clone, this.outer[i][1] - 5.0f + this.clone, 2.0f * (this.outerRadius + 5.0f - this.clone), 2.0f * (this.outerRadius + 5.0f - this.clone), this.startAngle, this.stopAngle, 0);
                    if (float_.contains(n, n2) || !float_5.contains(n, n2)) continue;
                    return true;
                }
                break;
            }
            case 0: 
            case 1: {
                for (int i = 0; i < this.col; ++i) {
                    Arc2D.Float float_ = new Arc2D.Float(this.outer[i][0] + 5.0f, this.outer[i][1] + 5.0f, 2.0f * (this.outerRadius - 5.0f), 2.0f * (this.outerRadius - 5.0f), this.startAngle, this.stopAngle, 0);
                    Arc2D.Float float_6 = new Arc2D.Float(this.outer[i][0] - 5.0f, this.outer[i][1] - 5.0f, 2.0f * (this.outerRadius + 5.0f), 2.0f * (this.outerRadius + 5.0f), this.startAngle, this.stopAngle, 0);
                    if (float_.contains(n, n2) || !float_6.contains(n, n2)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public Shape getNormalArea(int n) {
        return this.curveFillArea[n][0];
    }

    public Shape getAlertArea(int n) {
        return this.curveFillArea[n][1];
    }

    public Shape getErrorArea(int n) {
        return this.curveFillArea[n][2];
    }

    public Shape getAxisPaths(int n) {
        return this.axisPath[n];
    }

    public Shape[][] getAxisPaths() {
        return this.axisSelectedPaths;
    }

    public Shape[] getTickPath(int n) {
        return this.tickPaths[n];
    }

    public Shape[] getGridPath(int n) {
        return this.gridPath[n];
    }

    public Shape[][] getGridPath() {
        return this.gridPath;
    }

    public ChartLabelBase[] getLabels() {
        return this.axisLabels;
    }

    public float[][] getAxisLabelsPos(int n) {
        return this.axisLabelsPos[n];
    }

    public Shape getCurvePath(int n) {
        return this.curvePath[n];
    }

    public ChartLabelBase getCategoryLabel(int n) {
        return this.categoryLabels[n];
    }

    public float getCategoryLabelsX(int n) {
        return this.categoryLabelsPos[n][0];
    }

    public float getCategoryLabelsY(int n) {
        return this.categoryLabelsPos[n][1];
    }

    public float getCenterX(int n) {
        return this.centers[n][0];
    }

    public float getCenterY(int n) {
        return this.centers[n][1];
    }

    public Line2D getArrowLine(int n, int n2) {
        return this.arrowLine[n][n2];
    }

    public Shape getArrowPath(int n, int n2) {
        return this.arrowPaths[n][n2];
    }

    public float[] getArrowPoint(int n, int n2) {
        return this.arrowPointer[n][n2];
    }

    public double getValueAngle(int n, int n2) {
        return this.valueAngles[n][n2];
    }

    public float getOuterInnerGap() {
        return this.clone;
    }

    private float centers(float f) {
        float f2;
        boolean bl = this.objectProperties.getGaugeDialStartAngle() >= 0.0f && this.objectProperties.getGaugeDialStartAngle() <= 180.0f && this.objectProperties.getGaugeDialStopAngle() >= 0.0f && this.objectProperties.getGaugeDialStopAngle() <= 180.0f;
        int[] nArray = this.abs();
        float f3 = (float)this.paper.getBounds().width * this.paper.getProperties().getScaleX();
        float f4 = f3 / (float)nArray[1];
        f4 /= 2.0f;
        float f5 = f;
        int n = ((ChartNumericAxis)this.layer.getAxisY()).getNumOfTick();
        float f6 = this.paper.getProperties().getAxisYProperties().getTickMarkLength();
        float f7 = this.paper.getProperties().getAxisYProperties().getLabelAxisGap();
        ChartTextStyle chartTextStyle = (ChartTextStyle)this.paper.getProperties().getAxisYProperties().getLabelTextStyle().clone();
        float f8 = this.objectProperties.getGaugeDialStartAngle();
        if (f8 > (f2 = this.objectProperties.getGaugeDialStopAngle())) {
            f2 = f8 + f2;
            f8 = f2 - f8;
            f2 -= f8;
        }
        String[] stringArray = ((ChartNumericAxis)this.layer.getAxisY()).getLabels();
        int n2 = 0;
        if (stringArray != null) {
            n2 = n < stringArray.length ? n : stringArray.length;
        }
        float f9 = 0.0f;
        float f10 = 0.0f;
        for (int i = 0; i < n2 && n > 0; ++i) {
            f10 = 0.0f;
            if (stringArray == null) continue;
            double d = Math.PI * 2 * (double)(f8 + (f2 - f8) * (float)i / (float)(360 * n));
            float f11 = (float)Math.cos(d);
            f10 += Math.abs(f11 * (f6 + f7));
            Rectangle2D rectangle2D = chartTextStyle.getDimension(stringArray[i]);
            float f12 = 0.0f;
            if (f11 > 0.0f) {
                f12 = (float)((double)(f11 * (f6 + f7 + f5)) + rectangle2D.getWidth());
                if (f12 > f4 && f11 != 0.0f) {
                    f10 += Math.abs((f12 - f4) / f11);
                }
            } else if (f11 < 0.0f && (f12 = (float)((double)(f11 * (f6 + f7)) - rectangle2D.getWidth())) < -f4 && f11 != 0.0f) {
                f10 += Math.abs((f12 + f4) / f11);
            }
            f9 = f9 < f10 ? f10 : f9;
        }
        f9 = f - f9;
        f9 = (f9 -= 3.0f) < 10.0f ? 10.0f : f9;
        return f9;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.row / n5;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (this.itemShapes[i][j] == null || !this.itemShapes[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    int n7 = 0;
                    n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

