/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.data.Chart3DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import chart.graphics.RoundGradientPaint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;

public class Graph2DJoint
extends Chart2DObject {
    int row;
    int col;
    float unitX;
    float unitY;
    private boolean SEDU = false;
    private float[][][] availableValue = null;
    private boolean[][] availableValueX = null;
    private int black = -1;

    public Graph2DJoint(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    @Override
    public String[] search(int n, int n2) {
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    @Override
    public void init() {
        this.row = this.dataset.getSeriesSize();
        this.col = this.dataset.getCategorySize();
        this.unitX = this.layer.getXUnit();
        this.unitY = this.layer.getYUnit();
        this.initLine();
    }

    @Override
    public void locate() {
        this.locateLine();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.drawLine(graphics2D);
    }

    public void setDrawLine(boolean bl) {
        this.SEDU = bl;
    }

    public void setJoinIndex(int n) {
        this.black = n;
    }

    void initLine() {
        if (this.SEDU && this.paper.model.getMotionChartGroupNames() != null) {
            int n = this.paper.model.getChartDataSets().size();
            n = this.paper.model.getMotionFieldIndex() + 1;
            if (this.black != -1) {
                n = this.black;
            }
            this.availableValue = new float[n][this.row * this.col][2];
            this.availableValueX = new boolean[n][this.row * this.col];
            boolean bl = this.layer.getAxisX() == null ? false : !(this.layer.getAxisX() instanceof ChartNumericAxis);
            Number number = null;
            for (int i = 0; i < n; ++i) {
                Chart3DDataSet chart3DDataSet = (Chart3DDataSet)this.paper.model.getChartDataSets().get(i);
                for (int j = 0; j < this.row; ++j) {
                    for (int k = 0; k < this.col; ++k) {
                        number = chart3DDataSet.getX(j, k);
                        this.availableValue[i][j * this.col + k][0] = !bl ? (number != null ? this.unitX * this.layer.availableValueX(number.floatValue()) : 0.0f) : this.unitX * (float)k;
                        this.availableValueX[i][j * this.col + k] = number != null;
                        number = chart3DDataSet.getY(j, k);
                        this.availableValueX[i][j * this.col + k] = this.availableValueX[i][j * this.col + k] && number != null;
                        this.availableValue[i][j * this.col + k][1] = number != null ? this.unitY * this.layer.availableValue(number.floatValue()) : 0.0f;
                        number = chart3DDataSet.getZ(j, k);
                        this.availableValueX[i][j * this.col + k] = this.availableValueX[i][j * this.col + k] && number != null;
                    }
                }
            }
        }
    }

    void locateLine() {
        if (this.availableValue != null) {
            for (int i = 0; i < this.availableValue.length; ++i) {
                float[][] fArray2 = new float[this.row * this.col][2];
                float[][] fArray3 = new float[this.row * this.col][2];
                for (int j = 0; j < this.row; ++j) {
                    for (int k = 0; k < this.col; ++k) {
                        fArray2[j * this.col + k][0] = this.availableValue[i][j * this.col + k][0];
                        fArray2[j * this.col + k][1] = this.availableValue[i][j * this.col + k][1];
                    }
                }
                this.layer.transform(fArray2, fArray3);
                this.availableValue[i] = fArray3;
            }
        }
    }

    void drawLine(Graphics2D graphics2D) {
        if (this.availableValue == null || this.availableValueX == null) {
            return;
        }
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setPenWidth(2.0f);
        chartPenStyle.setPenColor(new ChartColorPattern(Color.black));
        for (int i = 0; i < this.row; ++i) {
            if (this.seriesPattern[i] == null) continue;
            ChartColorPattern chartColorPattern = null;
            if (this.seriesPattern[i] instanceof ChartColorPattern) {
                chartColorPattern = (ChartColorPattern)this.seriesPattern[i];
            } else if (this.seriesPattern[i] instanceof ChartGradientPattern) {
                chartColorPattern = ((ChartGradientPattern)this.seriesPattern[i]).getEndColor();
            } else if (this.seriesPattern[i] instanceof RoundGradientPaint) {
                chartColorPattern = ((RoundGradientPaint)((Object)this.seriesPattern[i])).getBackgroundColor();
            } else if (this.seriesPattern[i] instanceof ChartTexturePattern) {
                chartColorPattern = ((ChartTexturePattern)this.seriesPattern[i]).getForeground();
            }
            if (chartColorPattern == null) continue;
            chartPenStyle.setPenColor(chartColorPattern);
            for (int j = 0; j < this.col; ++j) {
                int n = 0;
                for (int k = 0; k < this.availableValue.length; ++k) {
                    if (k == 0) continue;
                    if (this.availableValueX[k][i * this.col + j] && this.availableValueX[n][i * this.col + j]) {
                        Line2D.Float float_ = new Line2D.Float(this.availableValue[n][i * this.col + j][0], this.availableValue[n][i * this.col + j][1], this.availableValue[k][i * this.col + j][0], this.availableValue[k][i * this.col + j][1]);
                        chartPenStyle.draw(graphics2D, float_);
                    }
                    if (!this.availableValueX[k][i * this.col + j]) continue;
                    n = k;
                }
            }
        }
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        return null;
    }
}

