/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.ChartShowValueSubCondition;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DSimplePaper;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DLineP;
import chart.chart2d.Graph2DScatterCurve;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartLineStyle;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartShading;
import chart.graphics.ChartTexturePattern;
import chart.properties.ChartNodeProperties;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import com.jinfonet.util.JRLog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class Graph2DLine
extends Chart2DObject {
    protected Shape[] seriesShapes;
    protected Shape[] seriesAreaShapes;
    protected Shape[][] itemShapes;
    protected GeneralPath depthPath;
    protected GeneralPath noDepthPath;
    protected ChartPenStyle linePen;
    protected Graph2DLineNode[] lineNode;
    protected float startX;
    protected float unitX;
    protected float unitY;
    protected int row;
    protected int col;
    protected float[][] value;
    protected float depth;
    protected float depthH = 0.0f;
    protected float depthW = 0.0f;
    protected float startOffsetW = 0.0f;
    protected float startOffsetH = 0.0f;
    protected float offsetW = 0.0f;
    protected float offsetH = 0.0f;
    protected int offsetN = 1;
    protected float[][] point;
    protected float[][] tpoint;
    protected float[][] lastpoint;
    protected float[][] tlastpoint;
    protected float[] len;
    protected float[][] lines;
    protected float[][] tLines;
    protected Line2D[][] depthlines;
    protected int gap = 5;
    protected int[] nodeStyleList;
    protected boolean isLineUnit;
    private int[] HighLightPattern;
    private int SEDU;
    private String[][][] add;
    private double[] axisY;
    private ChartFillPattern[] clear;
    private int clipRect;
    private ChartLineStyle[] contains;
    private int cos;
    private float create;
    private int createStroke;
    private int custommerConstant;
    public boolean crossNullPoint = false;
    protected List lineShapes;
    protected List areaShapes;
    private Graph2DScatterCurve draw = new Graph2DScatterCurve();
    public int strindex = 0;

    Graph2DLine(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    Graph2DLine(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, int n) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.offsetN = n;
    }

    @Override
    public void init() {
        Object object;
        int n;
        super.init();
        this.crossNullPoint = this.paper.getProperties().isIgnoreNullValue();
        this.col = this.dataset.getCategorySize();
        this.row = this.dataset.getSeriesSize();
        int n2 = this.getShowColumn();
        this.value = new float[this.row][this.col];
        this.add = new String[this.row][n2][3];
        double d = Math.PI / 180 * (double)this.objectProperties.getDepthDirection();
        this.depth = this.objectProperties.getDepth() / (float)this.layer.getChartCount();
        this.startOffsetW = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.cos(d));
        this.startOffsetH = (float)((double)(this.depth * (float)(this.offsetN - 1)) * Math.sin(d));
        this.startOffsetW = this.startOffsetW < 0.0f ? 0.0f : this.startOffsetW;
        this.startOffsetH = this.startOffsetH < 0.0f ? 0.0f : this.startOffsetH;
        this.depth *= (float)this.offsetN;
        this.depthW = (float)((double)this.depth * Math.cos(d));
        this.depthH = (float)((double)this.depth * Math.sin(d));
        this.depthW = this.depthW < 0.0f ? 0.0f : this.depthW;
        this.depthH = this.depthH < 0.0f ? 0.0f : this.depthH;
        this.offsetW = this.depthW / (float)this.offsetN;
        this.offsetH = this.depthH / (float)this.offsetN;
        Object var4_3 = null;
        this.initValues();
        this.seriesAreaShapes = new Shape[this.row];
        this.seriesShapes = new Shape[this.row];
        this.itemShapes = new Shape[this.row][n2];
        this.depthPath = new GeneralPath();
        this.noDepthPath = new GeneralPath();
        for (int i = 0; i < this.row; ++i) {
            this.seriesShapes[i] = new GeneralPath();
            this.seriesAreaShapes[i] = new GeneralPath();
            for (n = 0; n < n2; ++n) {
                this.itemShapes[i][n] = new GeneralPath();
            }
        }
        if (this.linePen == null) {
            this.linePen = new ChartPenStyle();
        }
        List list = this.paper.getProperties().getGraphProperties().getLineNodeList();
        this.lineNode = new Graph2DLineNode[list.size()];
        for (n = 0; n < this.lineNode.length; ++n) {
            object = (ChartNodeProperties)list.get(n);
            this.lineNode[n] = new Graph2DLineNode();
            this.lineNode[n].setProperties((ChartNodeProperties)object);
        }
        if (this.paper.platform.getChartLegend() != null) {
            this.HighLightPattern = this.paper.platform.getChartLegend().getIconStyleList();
        }
        this.point = new float[n2][2];
        this.tpoint = new float[n2][2];
        this.lastpoint = new float[n2][2];
        this.tlastpoint = new float[n2][2];
        this.lines = new float[n2 * this.row][2];
        this.tLines = new float[n2 * this.row][2];
        this.depthlines = new Line2D[this.row][n2];
        this.unitX = this.layer.getXUnit();
        this.unitY = this.layer.getYUnit();
        this.linePen.setPenWidth((int)this.objectProperties.getLineThickness());
        this.isLineUnit = ((ChartCategoryAxis)this.layer.getAxisX()).isLineUnit();
        this.startX = this.isLineUnit ? 0.0f : this.unitX / 2.0f;
        this.lineShapes = new Vector();
        this.areaShapes = new Vector();
        for (n = 0; n < this.row; ++n) {
            object = new Vector();
            this.lineShapes.add(object);
            Vector vector = new Vector();
            this.areaShapes.add(vector);
        }
    }

    @Override
    public void locate() {
        int n;
        int n2 = this.getShowColumn();
        for (n = 0; n < this.row; ++n) {
            ((GeneralPath)this.seriesShapes[n]).reset();
            ((GeneralPath)this.seriesAreaShapes[n]).reset();
            for (int i = 0; i < n2; ++i) {
                ((GeneralPath)this.itemShapes[n][i]).reset();
            }
        }
        this.HighLightPattern();
        if (this.lineShapes != null) {
            for (n = 0; n < this.row; ++n) {
                ((List)this.lineShapes.get(n)).clear();
            }
        }
    }

    private void HighLightPattern() {
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.SEDU = this.paper.getLineLegendIconDescent(this.dataset);
        for (int i = 0; i < this.row; ++i) {
            this.linePen.setDashPattern(this.contains[i].getPenStyle().getDashPattern());
            this.linePen.setPenWidth(this.contains[i].getPenStyle().getPenWidth());
            this.linePen.setVariabledDash(true);
            if (this.contains[i].getCureType() > 0) {
                this.drawLine(graphics2D, i);
                continue;
            }
            this.drawCube(graphics2D, i);
        }
        if (this.valueLabelPosition != 0) {
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.tLines, 0, this.row, this.valueLabelPosition, this.axisY);
            if (this.layer.getAxisX() != null && this.layer.getAxisX().custommerConstant()) {
                graph2DStaticHint.setFilteredPaintColumn(this.paper.getFilterConstant());
            }
            if (!this.paper.isScrollChart()) {
                graph2DStaticHint.paint();
            } else {
                graph2DStaticHint.setColumnNumber(this.getShowColumn());
                graph2DStaticHint.paint();
            }
        }
    }

    public void drawCube(Graphics2D graphics2D, int n) {
        ChartColorPattern chartColorPattern = null;
        int n2 = this.getShowColumn();
        float[][] fArray2 = new float[n2][2];
        if (this.seriesPattern[n] != null) {
            int n3;
            chartColorPattern = this.seriesPattern[n] instanceof ChartColorPattern ? (ChartColorPattern)this.seriesPattern[n] : (this.seriesPattern[n] instanceof ChartGradientPattern ? ((ChartGradientPattern)this.seriesPattern[n]).getStartColor() : (this.seriesPattern[n] instanceof ChartTexturePattern ? ((ChartTexturePattern)this.seriesPattern[n]).getForeground() : new ChartColorPattern()));
            if (this.linePen.getDashPattern() == 9) {
                return;
            }
            Stroke stroke = graphics2D.getStroke();
            this.draw.col = this.col;
            if (this.linePen.getPenWidth() != 0.0f) {
                graphics2D.setStroke(this.linePen.createStroke());
                graphics2D.setColor(chartColorPattern.getColor());
                for (int i = 0; i < n2; ++i) {
                    fArray2[i][0] = this.tLines[n2 * n + i][0];
                    fArray2[i][1] = this.tLines[n2 * n + i][1];
                }
                this.draw.drawCurve(graphics2D, fArray2);
                graphics2D.setStroke(stroke);
            }
            float f = this.value[n][0];
            float f2 = this.value[n][0];
            for (n3 = 0; n3 < n2; ++n3) {
                float f3 = this.value[n][n3];
                f = this.SEDU(f, f3);
                f2 = this.add(f2, f3);
            }
            for (n3 = 0; n3 < this.getShowColumn(); ++n3) {
                if (((Chart1DDataSet)this.dataset).getValue(n, n3) == null) continue;
                if (this.HighLightPattern != null) {
                    // empty if block
                }
                if (this.lineNode.length <= 0) continue;
                this.lineNode[n % this.lineNode.length].setLoc((int)this.tLines[n2 * n + n3][0], (int)this.tLines[n2 * n + n3][1]);
                List list = this.paper.getProperties().getGraphProperties().getLineNodeList();
                ChartNodeProperties chartNodeProperties = (ChartNodeProperties)list.get(n % this.lineNode.length);
                float f4 = this.value[n][n3];
                if (f4 == f && chartNodeProperties.getCusHFill()) {
                    this.clear(graphics2D, this.lineNode[n % this.lineNode.length], new ChartColorPattern(chartNodeProperties.getHFillClr()));
                    continue;
                }
                if (f4 == f2 && chartNodeProperties.getCusLFill()) {
                    this.clear(graphics2D, this.lineNode[n % this.lineNode.length], new ChartColorPattern(chartNodeProperties.getLFillClr()));
                    continue;
                }
                this.lineNode[n % this.lineNode.length].drawNode(graphics2D);
            }
        }
    }

    private float SEDU(float f, float f2) {
        return f2 > f ? f2 : f;
    }

    private float add(float f, float f2) {
        return f2 > f ? f : f2;
    }

    public void drawLine(Graphics2D graphics2D, int n) {
        ChartFillPattern chartFillPattern;
        ChartColorPattern chartColorPattern = null;
        this.linePen.setPenColor(chartColorPattern);
        if (this.dataset.getCondition(n, 0) != null && this.dataset.getCondition(n, 0).getLineConditionIndexList() != null) {
            int n2 = this.getBeginIndex();
            int n3 = this.getShowColumn();
            Shape shape = null;
            for (int i = 0; i < n3; ++i) {
                Object object;
                Object object2;
                shape = null;
                ChartShowValueSubCondition chartShowValueSubCondition = ((Chart1DDataSet)this.dataset).getLineSubCondition(n, i + n2);
                if (this.areaShapes != null && i < ((List)this.areaShapes.get(n)).size()) {
                    shape = (Shape)((List)this.areaShapes.get(n)).get(i);
                }
                if (chartShowValueSubCondition != null && shape != null && chartShowValueSubCondition.getAreaFillColor() != null) {
                    if (this.layer != null && this.layer.getAxisX().custommerConstant()) {
                        object2 = (Graphics2D)graphics2D.create();
                        object = this.paper.getScaledGraphArea();
                        ((Graphics)object2).clipRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
                        chartShowValueSubCondition.getAreaFillColor().fill((Graphics2D)object2, shape);
                        continue;
                    }
                    chartShowValueSubCondition.getAreaFillColor().fill(graphics2D, shape);
                    continue;
                }
                if (chartShowValueSubCondition != null || shape == null || (object2 = this.dataset.getCondition(n, 0).getAreaOtherColor()) == null) continue;
                if (this.layer != null && this.layer.getAxisX().custommerConstant()) {
                    object = (Graphics2D)graphics2D.create();
                    Rectangle rectangle = this.paper.getScaledGraphArea();
                    ((Graphics)object).clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    object2.fill((Graphics2D)object, shape);
                    continue;
                }
                object2.fill(graphics2D, shape);
            }
        } else if (!this.layer.isDepth() && this.clear != null && this.clear.length > 0 && (chartFillPattern = this.clear[n]) != null) {
            if (this.layer.getAxisX().custommerConstant()) {
                Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
                Rectangle rectangle = this.paper.getScaledGraphArea();
                graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                chartFillPattern.fill(graphics2D2, this.seriesAreaShapes[n]);
            } else {
                chartFillPattern.fill(graphics2D, this.seriesAreaShapes[n]);
            }
        }
        if (this.layer.isDepth()) {
            this.drawDepthLine(graphics2D, n);
        } else {
            this.drawNoDepthLine(graphics2D, n);
            this.drawLineNodes(graphics2D, n);
        }
    }

    ChartColorPattern getSeriesColorByIndex(int n) {
        ChartColorPattern chartColorPattern = null;
        if (this.seriesPattern != null) {
            if (n < 0 || n >= this.seriesPattern.length) {
                return chartColorPattern;
            }
            if (this.seriesPattern[n] == null) {
                return chartColorPattern;
            }
            chartColorPattern = this.seriesPattern[n] instanceof ChartColorPattern ? (ChartColorPattern)this.seriesPattern[n] : (this.seriesPattern[n] instanceof ChartGradientPattern ? ((ChartGradientPattern)this.seriesPattern[n]).getStartColor() : (this.seriesPattern[n] instanceof ChartTexturePattern ? ((ChartTexturePattern)this.seriesPattern[n]).getForeground() : new ChartColorPattern()));
        }
        return chartColorPattern;
    }

    public void drawDepthLine(Graphics2D graphics2D, int n) {
        Cloneable cloneable;
        Graphics2D graphics2D2;
        if (this.seriesPattern == null) {
            return;
        }
        if (this.seriesPattern[n] == null) {
            return;
        }
        if (this.dataset.getCondition(n, 0) != null && this.dataset.getCondition(n, 0).getLineConditionIndexList() != null && !this.paper.getProperties().getGraphProperties().getUseNodeColor()) {
            this.axisY(graphics2D, n);
            return;
        }
        if (this.paper.getProperties().getGraphProperties().getUseNodeColor() && this.dataset.getCondition(n, 0) != null && this.dataset.getCondition(n, 0).getConditionIndexList() != null) {
            this.axisY(graphics2D, n);
            return;
        }
        if (!this.layer.getAxisX().custommerConstant()) {
            graphics2D2 = graphics2D;
        } else {
            graphics2D2 = (Graphics2D)graphics2D.create();
            cloneable = this.paper.getScaledGraphArea();
            graphics2D2.clipRect(((Rectangle)cloneable).x, ((Rectangle)cloneable).y, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
        }
        this.paper.getProperties();
        if (this.dataset.getCondition(n, 0) != null) {
            // empty if block
        }
        ChartColorPattern chartColorPattern = null;
        ChartColorPattern chartColorPattern2 = this.getSeriesColorByIndex(n);
        cloneable = ChartShading.HighLightPattern(this.seriesPattern[n], 20);
        if (this.paper.getProperties().getGraphProperties().getUseNodeColor()) {
            List list = this.paper.getProperties().getGraphProperties().getLineNodeList();
            if (list != null && list.size() > 0) {
                ChartNodeProperties chartNodeProperties = (ChartNodeProperties)list.get((n + this.strindex) % list.size());
                chartColorPattern2 = chartColorPattern = new ChartColorPattern(chartNodeProperties.getNFillClr());
            }
            if (chartColorPattern != null) {
                chartColorPattern.fill(graphics2D2, this.seriesShapes[n]);
            }
        } else {
            cloneable.fill(graphics2D2, this.seriesShapes[n]);
        }
        this.linePen.setPenColor(chartColorPattern2);
        int n2 = this.getBeginIndex();
        if (this.layer.getAxisX().custommerConstant()) {
            n2 = 0;
        }
        int n3 = this.getShowColumn();
        for (int i = 0; i < n3; ++i) {
            if (((Chart1DDataSet)this.dataset).getValue(n, i + n2) == null || !this.layer.isDepth() || this.depthlines[n][i] == null) continue;
            this.linePen.setPenWidth(1.0f);
            this.linePen.draw(graphics2D2, this.depthlines[n][i]);
        }
    }

    public void drawNoDepthLine(Graphics2D graphics2D, int n) {
        Object object;
        Object object2;
        if (!this.paper.getProperties().getGraphProperties().getUseNodeColor()) {
            if (this.dataset.getCondition(n, 0) != null && this.dataset.getCondition(n, 0).getLineConditionIndexList() != null) {
                this.axisY(graphics2D, n);
                return;
            }
        } else {
            if (this.dataset.getCondition(n, 0) != null && this.dataset.getCondition(n, 0).getLineConditionIndexList() != null) {
                this.axisY(graphics2D, n);
                return;
            }
            if (this.dataset.getCondition(n, 0) != null && this.dataset.getCondition(n, 0).getConditionIndexList() != null) {
                this.axisY(graphics2D, n);
                return;
            }
        }
        ChartColorPattern chartColorPattern = this.getSeriesColorByIndex(n);
        if (this.paper.getProperties().getGraphProperties().getUseNodeColor() && (object2 = this.paper.getProperties().getGraphProperties().getLineNodeList()) != null && object2.size() > 0) {
            object = (ChartNodeProperties)object2.get((n + this.strindex) % object2.size());
            chartColorPattern = new ChartColorPattern(((ChartNodeProperties)object).getNFillClr());
        }
        if (chartColorPattern == null) {
            return;
        }
        this.linePen.setPenColor(chartColorPattern);
        if (this.layer.getAxisX().custommerConstant()) {
            if (this.seriesShapes[n] != null) {
                object2 = (Graphics2D)graphics2D.create();
                object = this.paper.getScaledGraphArea();
                ((Graphics)object2).clipRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
                this.areaShapes((Graphics2D)object2, n);
            }
        } else {
            this.areaShapes(graphics2D, n);
        }
    }

    private void areaShapes(Graphics2D graphics2D, int n) {
        Graphics2D graphics2D2 = null;
        if (this.layer.getAxisX().custommerConstant()) {
            if (this.seriesShapes[n] != null) {
                graphics2D2 = (Graphics2D)graphics2D.create();
                Rectangle rectangle = this.paper.getScaledGraphArea();
                graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            graphics2D2 = graphics2D;
        }
        int n2 = this.getBeginIndex();
        int n3 = this.getShowColumn();
        int n4 = -1;
        for (int i = 0; i < n3 - 1; ++i) {
            if (!this.crossNullPoint && (((Chart1DDataSet)this.dataset).getOriginValue(n, i + n2) == null || ((Chart1DDataSet)this.dataset).getOriginValue(n, i + n2 + 1) == null)) continue;
            ++n4;
            GeneralPath generalPath = this.getLineShape(n, i);
            ChartPenStyle chartPenStyle = new ChartPenStyle();
            chartPenStyle.setPenWidth(this.linePen.getPenWidth());
            chartPenStyle.setDashPattern(this.linePen.getDashPattern());
            chartPenStyle.setPenColor(this.linePen.getPenColor());
            if (generalPath == null) continue;
            chartPenStyle.draw(graphics2D2, generalPath);
        }
    }

    private void axisY(Graphics2D graphics2D, int n) {
        Graphics2D graphics2D2 = null;
        if (this.layer.getAxisX().custommerConstant()) {
            if (this.seriesShapes[n] != null) {
                graphics2D2 = (Graphics2D)graphics2D.create();
                Rectangle rectangle = this.paper.getScaledGraphArea();
                graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            graphics2D2 = graphics2D;
        }
        int n2 = this.getBeginIndex();
        int n3 = this.getShowColumn();
        int n4 = -1;
        for (int i = 0; i < n3 - 1; ++i) {
            ChartFillPattern chartFillPattern;
            if (((Chart1DDataSet)this.dataset).getOriginValue(n, i + n2) == null || ((Chart1DDataSet)this.dataset).getOriginValue(n, i + n2 + 1) == null) continue;
            ++n4;
            GeneralPath generalPath = this.getLineShape(n, i);
            ChartPenStyle chartPenStyle = new ChartPenStyle();
            chartPenStyle.setPenWidth(this.linePen.getPenWidth());
            chartPenStyle.setDashPattern(this.linePen.getDashPattern());
            chartPenStyle.setPenColor(this.linePen.getPenColor());
            ChartShowValueSubCondition chartShowValueSubCondition = ((Chart1DDataSet)this.dataset).getLineSubCondition(n, i + n2);
            if (chartShowValueSubCondition != null) {
                chartPenStyle.setPenWidth(chartShowValueSubCondition.getLineWidth());
                chartPenStyle.setDashPattern(chartShowValueSubCondition.getLineStyle());
            }
            if (this.paper.getProperties().getGraphProperties().getUseNodeColor()) {
                chartShowValueSubCondition = ((Chart1DDataSet)this.dataset).getSubCondition(n, i + n2);
            }
            if (generalPath == null) continue;
            if (chartShowValueSubCondition == null) {
                if (this.paper.getProperties().getGraphProperties().getUseNodeColor()) {
                    chartFillPattern = this.getLineNodesColor(n, i);
                    chartPenStyle.setPenColor((ChartColorPattern)chartFillPattern);
                    if (this.dataset.getCondition(n, 0) != null && this.dataset.getCondition(n, 0).getLineConditionIndexList() != null) {
                        chartPenStyle.setPenWidth(this.dataset.getCondition(n, 0).getOtherLineWidth());
                        chartPenStyle.setDashPattern(this.dataset.getCondition(n, 0).getOtherLineStyle());
                    }
                    if (!this.layer.isDepth()) {
                        chartPenStyle.draw(graphics2D2, generalPath);
                        continue;
                    }
                    ChartColorPattern chartColorPattern = (ChartColorPattern)chartFillPattern;
                    chartColorPattern = (ChartColorPattern)ChartShading.HighLightPattern((ChartFillPattern)chartColorPattern, 20);
                    chartColorPattern.fill(graphics2D2, generalPath);
                    continue;
                }
                if (this.dataset.getCondition(n, 0) == null || this.dataset.getCondition(n, 0).getLineConditionIndexList() == null) continue;
                chartPenStyle.setPenColor((ChartColorPattern)this.dataset.getCondition(n, 0).getOtherLineColor());
                chartPenStyle.setPenWidth(this.dataset.getCondition(n, 0).getOtherLineWidth());
                chartPenStyle.setDashPattern(this.dataset.getCondition(n, 0).getOtherLineStyle());
                if (!this.layer.isDepth()) {
                    chartPenStyle.draw(graphics2D2, generalPath);
                    continue;
                }
                chartFillPattern = (ChartColorPattern)this.dataset.getCondition(n, 0).getOtherLineColor();
                chartFillPattern = (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, 20);
                ((ChartColorPattern)chartFillPattern).fill(graphics2D2, generalPath);
                continue;
            }
            if (chartShowValueSubCondition == null || chartShowValueSubCondition.getFillColor() == null) continue;
            chartPenStyle.setPenColor((ChartColorPattern)chartShowValueSubCondition.getFillColor());
            if (!this.layer.isDepth()) {
                chartPenStyle.draw(graphics2D2, generalPath);
                continue;
            }
            chartFillPattern = (ChartColorPattern)chartShowValueSubCondition.getFillColor();
            chartFillPattern = (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, 20);
            if (i >= 1) {
                // empty if block
            }
            ((ChartColorPattern)chartFillPattern).fill(graphics2D2, generalPath);
        }
    }

    public void drawLineNodes(Graphics2D graphics2D, int n) {
        float f;
        int n2;
        if (this.value == null || this.lineNode == null) {
            return;
        }
        int[] nArray = this.paper.getFilterConstant();
        int n3 = this.getBeginIndex();
        float f2 = -3.4028235E38f;
        float f3 = Float.MAX_VALUE;
        int n4 = this.getShowColumn();
        for (n2 = 0; n2 < n4; ++n2) {
            if (((Chart1DDataSet)this.dataset).getOriginValue(n, n2 + n3) == null) continue;
            f = this.value[n][n2];
            f2 = this.SEDU(f2, f);
            f3 = this.add(f3, f);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            Object object;
            if (((Chart1DDataSet)this.dataset).getOriginValue(n, n2 + n3) == null || nArray[0] >= 0 && (n2 + n3 < nArray[0] || n2 + n3 > nArray[1]) || this.lineNode.length <= 0) continue;
            this.lineNode[(n + this.strindex) % this.lineNode.length].setLoc((int)this.tLines[n4 * n + n2][0], (int)this.tLines[n4 * n + n2][1]);
            f = this.value[n][n2];
            List list = this.paper.getProperties().getGraphProperties().getLineNodeList();
            ChartNodeProperties chartNodeProperties = (ChartNodeProperties)list.get((n + this.strindex) % this.lineNode.length);
            boolean bl = this.isConditionFill(n, n2);
            if (bl) {
                ChartNodeProperties chartNodeProperties2;
                int n5;
                int n6 = 0;
                if (this.paper.isScrollChart()) {
                    n6 = this.paper.platform.showScrollLabelStart();
                }
                if (this.dataset.getSubCondition(n, n2 + n6) != null) {
                    if (this.dataset.getSubCondition(n, n2 + n6) == null || this.dataset.getSubCondition(n, n2 + n6).getNodeProperties() == null) continue;
                    object = new Graph2DLineNode();
                    int n7 = this.lineNode[(n + this.strindex) % this.lineNode.length].x;
                    n5 = this.lineNode[(n + this.strindex) % this.lineNode.length].y;
                    ((Graph2DLineNode)object).setLoc(n7, n5);
                    chartNodeProperties2 = this.dataset.getSubCondition(n, n2 + n6).getNodeProperties();
                    ((Graph2DLineNode)object).setProperties(chartNodeProperties);
                    if (!chartNodeProperties2.getCusNFill()) continue;
                    this.clipRect(graphics2D, (Graph2DLineNode)object, this.dataset.getSubCondition(n, n2 + n6).getFillColor());
                    continue;
                }
                if (this.dataset.getCondition(n, n2 + n6).getOtherNodeProperties() == null) continue;
                object = new Graph2DLineNode();
                int n8 = this.lineNode[(n + this.strindex) % this.lineNode.length].x;
                n5 = this.lineNode[(n + this.strindex) % this.lineNode.length].y;
                ((Graph2DLineNode)object).setLoc(n8, n5);
                chartNodeProperties2 = this.dataset.getCondition(n, n2 + n6).getOtherNodeProperties();
                ((Graph2DLineNode)object).setProperties(chartNodeProperties);
                if (!chartNodeProperties2.getCusNFill()) continue;
                this.clipRect(graphics2D, (Graph2DLineNode)object, this.dataset.getCondition(n, n2 + n6).getOtherColor());
                continue;
            }
            if (f == f3 && chartNodeProperties.getCusLFill()) {
                ChartColorPattern chartColorPattern = new ChartColorPattern(chartNodeProperties.getLFillClr());
                chartColorPattern.setAlpha(chartNodeProperties.getNFillClrTrans() / 100.0f);
                this.clear(graphics2D, this.lineNode[(n + this.strindex) % this.lineNode.length], chartColorPattern);
                if (!this.paper.getProperties().getGraphProperties().getUseNodeColor() || (object = this.getLineShape(n, n2)) == null) continue;
                ChartColorPattern chartColorPattern2 = this.linePen.getPenColor();
                this.linePen.setPenColor(chartColorPattern);
                this.linePen.draw(graphics2D, (Shape)object);
                this.linePen.setPenColor(chartColorPattern2);
                continue;
            }
            if (f == f2 && chartNodeProperties.getCusHFill()) {
                ChartColorPattern chartColorPattern = new ChartColorPattern(chartNodeProperties.getHFillClr());
                chartColorPattern.setAlpha(chartNodeProperties.getNFillClrTrans() / 100.0f);
                this.clear(graphics2D, this.lineNode[(n + this.strindex) % this.lineNode.length], chartColorPattern);
                if (!this.paper.getProperties().getGraphProperties().getUseNodeColor() || (object = this.getLineShape(n, n2)) == null) continue;
                ChartColorPattern chartColorPattern3 = this.linePen.getPenColor();
                this.linePen.setPenColor(chartColorPattern);
                this.linePen.draw(graphics2D, (Shape)object);
                this.linePen.setPenColor(chartColorPattern3);
                continue;
            }
            if (!chartNodeProperties.getCusNFill()) continue;
            ChartFillPattern chartFillPattern = this.lineNode[(n + this.strindex) % this.lineNode.length].getFillPattern();
            if (chartFillPattern != null && chartFillPattern instanceof ChartColorPattern && ((ChartColorPattern)chartFillPattern).isNoColor()) {
                this.lineNode[(n + this.strindex) % this.lineNode.length].setFillPattern(this.getSeriesColorByIndex(n));
            }
            this.lineNode[(n + this.strindex) % this.lineNode.length].drawNode(graphics2D);
            this.lineNode[(n + this.strindex) % this.lineNode.length].setFillPattern(chartFillPattern);
        }
    }

    public void drawAllNodes(Graphics2D graphics2D) {
        if (!this.layer.isDepth() && this.contains != null) {
            for (int i = 0; i < this.row; ++i) {
                if (this.contains[i].getCureType() <= 0) continue;
                this.drawLineNodes(graphics2D, i);
            }
        }
    }

    private void clear(Graphics2D graphics2D, Graph2DLineNode graph2DLineNode, ChartColorPattern chartColorPattern) {
        if (graph2DLineNode == null || chartColorPattern == null) {
            return;
        }
        ChartFillPattern chartFillPattern = graph2DLineNode.getFillPattern();
        graph2DLineNode.setFillPattern(chartColorPattern);
        graph2DLineNode.drawNode(graphics2D);
        graph2DLineNode.setFillPattern(chartFillPattern);
    }

    private void clipRect(Graphics2D graphics2D, Graph2DLineNode graph2DLineNode, ChartFillPattern chartFillPattern) {
        if (graph2DLineNode == null || chartFillPattern == null) {
            return;
        }
        ChartFillPattern chartFillPattern2 = graph2DLineNode.getFillPattern();
        graph2DLineNode.setFillPattern(chartFillPattern);
        graph2DLineNode.drawNode(graphics2D);
        graph2DLineNode.setFillPattern(chartFillPattern2);
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.seriesShapes[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    @Override
    public Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = this.row - 1; i >= 0; --i) {
            for (int j = 0; j < this.getShowColumn(); ++j) {
                if (!this.itemShapes[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.add[i][j];
            }
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.seriesShapes.length; ++i) {
            if (!this.seriesShapes[i].intersects(n, n2, 3.0, 3.0)) continue;
            return i;
        }
        return -1;
    }

    public void setAreaPatterns(ChartFillPattern[] chartFillPatternArray, int n) {
        if (this.clear != null) {
            return;
        }
        this.clear = new ChartFillPattern[this.row];
        for (int i = 0; i < this.row; ++i) {
            this.clear[i] = chartFillPatternArray[(n + i) % chartFillPatternArray.length];
        }
        this.clipRect = n + this.row;
    }

    public int getStartIndex() {
        return this.clipRect;
    }

    public int searchIndex(int n, int n2) {
        for (int i = 0; i < this.seriesShapes.length; ++i) {
            if (!this.seriesShapes[i].intersects(n, n2, 3.0, 3.0)) continue;
            return i + (this.clipRect + this.cos - this.row * 2) / 2;
        }
        return -1;
    }

    public void setLineStyleList(ChartLineStyle[] chartLineStyleArray, int n) {
        if (chartLineStyleArray.length == 0) {
            return;
        }
        this.contains = new ChartLineStyle[this.row];
        for (int i = 0; i < this.row; ++i) {
            this.contains[i] = chartLineStyleArray[(this.cos + i) % chartLineStyleArray.length];
        }
        this.cos += this.row;
    }

    public void setLineStyleList(ChartLineStyle[] chartLineStyleArray, int n, Map map) {
        if (chartLineStyleArray.length == 0) {
            return;
        }
        this.strindex = n;
        this.contains = new ChartLineStyle[this.row];
        for (int i = 0; i < this.row; ++i) {
            ChartLineStyle chartLineStyle = null;
            if (map != null) {
                chartLineStyle = (ChartLineStyle)map.get(n + i);
            }
            this.contains[i] = chartLineStyle != null ? chartLineStyle : chartLineStyleArray[(n + i) % chartLineStyleArray.length];
        }
        this.cos = n + this.row;
    }

    public int getLineStyleStartIndex() {
        return this.cos;
    }

    void initValues() {
        int n;
        boolean bl;
        int n2 = this.getShowColumn();
        Number number = null;
        float[] fArray2 = null;
        boolean bl2 = bl = ((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent() && !(this instanceof Graph2DLineP);
        if (bl) {
            if (this.dataset.getChartDataSetModel().isOneGroup()) {
                fArray2 = new float[this.row];
                for (n = 0; n < fArray2.length; ++n) {
                    fArray2[n] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfSeries(n);
                    fArray2[n] = fArray2[n] == 0.0f ? 1.0f : fArray2[n];
                }
            } else {
                fArray2 = new float[this.row];
                for (n = 0; n < fArray2.length; ++n) {
                    fArray2[n] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfSeries(n);
                    fArray2[n] = fArray2[n] == 0.0f ? 1.0f : fArray2[n];
                }
            }
        }
        if (!this.paper.isScrollChart()) {
            for (n = 0; n < this.row; ++n) {
                for (int i = 0; i < this.col; ++i) {
                    number = ((Chart1DDataSet)this.dataset).getValue(n, i);
                    this.value[n][i] = number == null ? 0.0f : (!bl ? number.floatValue() : number.floatValue() / fArray2[n]);
                }
            }
        } else {
            n = this.paper.platform.showScrollLabelStart();
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < n2; ++j) {
                    number = ((Chart1DDataSet)this.dataset).getValue(i, j + n);
                    this.value[i][j] = number == null ? 0.0f : (!bl ? number.floatValue() : number.floatValue() / fArray2[i]);
                }
            }
        }
        if (this.paper.getProperties().getGraphProperties().getValueLabelType() != 0 && this.valueLabelPosition != 0) {
            this.initSum();
        }
        this.initHints();
    }

    void initHints() {
        int n = this.getShowColumn();
        if (!this.paper.isScrollChart()) {
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < this.col; ++j) {
                    if (((Chart1DDataSet)this.dataset).getValue(i, j) == null) continue;
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.add[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                        continue;
                    }
                    this.add[i][j][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(i, j));
                }
            }
        } else {
            int n2 = this.paper.platform.showScrollLabelStart();
            for (int i = 0; i < this.row; ++i) {
                for (int j = 0; j < n; ++j) {
                    if (((Chart1DDataSet)this.dataset).getValue(i, j + n2) == null) continue;
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.add[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j + n2);
                        continue;
                    }
                    this.add[i][j][0] = this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(i, j + n2));
                }
            }
        }
    }

    void initSum() {
        Object var1_1 = null;
        this.axisY = new double[this.row];
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            this.axisY = new double[this.row];
            for (int i = 0; i < this.axisY.length; ++i) {
                this.axisY[i] = ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfSeries(i);
                this.axisY[i] = this.axisY[i] == 0.0 ? 1.0 : this.axisY[i];
            }
        } else {
            this.axisY = new double[this.row];
            for (int i = 0; i < this.axisY.length; ++i) {
                this.axisY[i] = ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfSeries(i);
                this.axisY[i] = this.axisY[i] == 0.0 ? 1.0 : this.axisY[i];
            }
        }
    }

    int getShowColumn() {
        if (this.paper.isScrollChart()) {
            return this.getScrollLabelCount();
        }
        return this.col;
    }

    protected int[] getLineSquence(float[] fArray2) {
        int[] nArray = null;
        if (fArray2 != null && fArray2.length > 1) {
            nArray = new int[fArray2.length];
            boolean[] blArray = new boolean[fArray2.length];
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = true;
            }
            float f = 0.0f;
            for (int i = 0; i < fArray2.length; ++i) {
                int n;
                nArray[i] = 0;
                if (i == 0) {
                    nArray[i] = 0;
                    f = fArray2[i];
                } else {
                    for (n = 0; n < fArray2.length; ++n) {
                        if (!blArray[n]) continue;
                        nArray[i] = n;
                        f = fArray2[n];
                        break;
                    }
                }
                for (n = 0; n < fArray2.length; ++n) {
                    if (!blArray[n] || !(f >= fArray2[n])) continue;
                    f = fArray2[n];
                    nArray[i] = n;
                }
                blArray[nArray[i]] = false;
                f = fArray2[nArray[i]];
            }
        }
        return nArray;
    }

    int getBeginIndex() {
        if (this.paper instanceof Chart2DSimplePaper) {
            return 0;
        }
        if (this.layer.getAxisX() != null && this.layer.getAxisX().custommerConstant()) {
            return 0;
        }
        return this.paper.platform.showScrollLabelStart();
    }

    protected int getNextColumnIndex(Chart1DDataSet chart1DDataSet, int n, int n2, int n3) {
        int n4 = -1;
        if (chart1DDataSet.getValue(n, n2) == null) {
            return n2;
        }
        for (int i = n2 + 1; i < n3; ++i) {
            if (chart1DDataSet.getValue(n, i) == null) continue;
            n4 = i;
            break;
        }
        return n4;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.row / n5;
        for (int i = this.row - 1; i >= 0; --i) {
            for (int j = 0; j < this.getShowColumn(); ++j) {
                if (!this.itemShapes[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }

    GeneralPath getLineShape(int n, int n2) {
        GeneralPath generalPath;
        block3: {
            generalPath = null;
            if (this.lineShapes != null && this.lineShapes.size() > n && ((List)this.lineShapes.get(n)).size() > n2) {
                try {
                    generalPath = (GeneralPath)((List)this.lineShapes.get(n)).get(n2);
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, exception);
                }
            }
        }
        return generalPath;
    }

    public ChartFillPattern getLineNodesColor(int n, int n2) {
        ChartFillPattern chartFillPattern = null;
        if (this.value == null || this.lineNode == null) {
            return null;
        }
        int[] nArray = this.paper.getFilterConstant();
        int n3 = this.getBeginIndex();
        float f = -3.4028235E38f;
        float f2 = Float.MAX_VALUE;
        int n4 = this.getShowColumn();
        for (int i = 0; i < n4; ++i) {
            if (((Chart1DDataSet)this.dataset).getOriginValue(n, i + n3) == null) continue;
            float f3 = this.value[n][i];
            f = this.SEDU(f, f3);
            f2 = this.add(f2, f3);
        }
        if (this.lineNode.length > 0) {
            this.lineNode[(n + this.strindex) % this.lineNode.length].setLoc((int)this.tLines[n4 * n + n2][0], (int)this.tLines[n4 * n + n2][1]);
            float f4 = this.value[n][n2];
            List list = this.paper.getProperties().getGraphProperties().getLineNodeList();
            ChartNodeProperties chartNodeProperties = (ChartNodeProperties)list.get((n + this.strindex) % this.lineNode.length);
            boolean bl = this.isConditionFill(n, n2);
            if (bl) {
                int n5 = 0;
                if (this.paper.isScrollChart()) {
                    n5 = this.paper.platform.showScrollLabelStart();
                }
                if (this.dataset.getSubCondition(n, n2 + n5) != null) {
                    if (this.dataset.getSubCondition(n, n2 + n5).getNodeProperties() != null) {
                        chartFillPattern = this.dataset.getSubCondition(n, n2 + n5).getFillColor();
                        return chartFillPattern;
                    }
                } else if (this.dataset.getCondition(n, n2 + n5).getOtherNodeProperties() != null) {
                    Graph2DLineNode graph2DLineNode = new Graph2DLineNode();
                    chartFillPattern = this.dataset.getCondition(n, n2 + n5).getOtherColor();
                    return chartFillPattern;
                }
            }
            if (f4 == f2 && chartNodeProperties.getCusLFill()) {
                ChartColorPattern chartColorPattern = new ChartColorPattern(chartNodeProperties.getLFillClr());
                chartColorPattern.setAlpha(chartNodeProperties.getNFillClrTrans() / 100.0f);
                chartFillPattern = chartColorPattern;
            } else if (f4 == f && chartNodeProperties.getCusHFill()) {
                ChartColorPattern chartColorPattern = new ChartColorPattern(chartNodeProperties.getHFillClr());
                chartColorPattern.setAlpha(chartNodeProperties.getNFillClrTrans() / 100.0f);
                chartFillPattern = chartColorPattern;
            } else {
                ChartFillPattern chartFillPattern2 = this.lineNode[(n + this.strindex) % this.lineNode.length].getFillPattern();
                if (chartFillPattern2 != null && chartFillPattern2 instanceof ChartColorPattern && ((ChartColorPattern)chartFillPattern2).isNoColor()) {
                    chartFillPattern = this.getSeriesColorByIndex(n);
                }
                chartFillPattern = chartFillPattern2;
            }
        }
        return chartFillPattern;
    }
}

