/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DScatterCurve;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Graph2DMeanLine
extends Chart2DObject {
    private static final int SEDU = 0;
    private static final int append = 1;
    private static final int clipRect = 2;
    private static final int clone = 3;
    private GeneralPath contains = new GeneralPath();
    private GeneralPath[] create;
    private int createStroke;
    private int depthH;
    private float[][] depthW;
    private float[][] draw;
    private Graph2DLineNode drawNode;
    private Graph2DScatterCurve getAbsoluteValueSumOfCategory = new Graph2DScatterCurve();
    private int getAxisX;
    private int getBorderPen;
    private boolean getCategorySize;
    private boolean getChartDataSetModel;
    private boolean getChartPlatform;
    private double[] v;
    private ChartPenStyle getDataPosition = new ChartPenStyle();
    private ChartColorPattern getDimension = new ChartColorPattern();
    private String[][] getFormatedHintValue;
    private ChartTextStyle getGraphArea;
    private float getGraphProperties = 0.0f;

    Graph2DMeanLine(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer, boolean bl, boolean bl2, float f) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.getCategorySize = bl;
        this.getChartDataSetModel = bl2;
        this.depthH = chartDataSet.getCategorySize();
        this.createStroke = chartDataSet.getSeriesSize();
        this.getGraphProperties = f;
        this.getGraphArea = chart2DPaper.getProperties().getHintTextStyle();
        this.getGraphArea.setWordWrapper(false);
    }

    @Override
    public void init() {
        boolean bl;
        this.depthW = new float[this.depthH][2];
        this.draw = new float[this.depthH][2];
        this.v = ((Chart1DDataSet)this.dataset).getMeanValue();
        this.getFormatedHintValue = new String[this.depthH][1];
        float f = this.layer.getXUnit();
        float f2 = this.layer.getYUnit();
        this.drawNode = new Graph2DLineNode();
        float f3 = f * this.getGraphProperties;
        this.create = new GeneralPath[this.depthH];
        this.getDimension.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
        this.getDataPosition.setPenColor(this.getDimension);
        double d = 0.0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int[] nArray = this.paper.getChartPlatform().getDataPosition();
        if (nArray != null && nArray.length > 0 && ((n = nArray[0]) < 0 || n >= this.depthH)) {
            n = 0;
        }
        f3 = (bl = ((ChartCategoryAxis)this.layer.getAxisX()).isLineUnit()) ? 0.0f : f / 2.0f;
        for (int i = 0; i < this.depthH; ++i) {
            this.create[i] = new GeneralPath();
            this.depthW[i][0] = f3 + (float)i * f;
            if (n == 0) {
                this.depthW[i][1] = this.getChartPlatform ? (float)((double)f2 * this.v[i] / ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i)) : (float)((double)f2 * this.v[i]);
            } else if (i + n >= 0 && i + n < this.depthH) {
                this.depthW[i][1] = this.getChartPlatform ? (float)((double)f2 * this.v[i + n] / ((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i)) : (float)((double)f2 * this.v[i + n]);
            }
            if (this.getChartDataSetModel) {
                stringBuffer.append("Y1: ");
            } else {
                stringBuffer.append("Y2: ");
            }
            stringBuffer.append(this.v[i]);
            this.getFormatedHintValue[i][0] = stringBuffer.toString();
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        Rectangle rectangle = null;
        Graphics2D graphics2D2 = null;
        int n = this.depthH;
        switch (this.paper.getProperties().getGraphProperties().getMeanLineType()) {
            case 0: {
                break;
            }
            case 1: {
                this.SEDU(graphics2D);
                break;
            }
            case 2: {
                graphics2D.setStroke(this.getDataPosition.createStroke());
                graphics2D.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
                this.getAbsoluteValueSumOfCategory.isBench = !this.getCategorySize;
                this.getAbsoluteValueSumOfCategory.col = this.depthH;
                n = this.paper.isScrollChart() ? this.paper.getChartPlatform().showScrollLabelCount() : this.depthH;
                this.getAbsoluteValueSumOfCategory.col = n = n > this.depthH ? this.depthH : n;
                this.getAbsoluteValueSumOfCategory.tpoint1 = this.draw;
                graphics2D2 = (Graphics2D)graphics2D.create();
                rectangle = this.paper.getGraphArea();
                if (rectangle != null) {
                    graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                this.getAbsoluteValueSumOfCategory.paint(graphics2D2, this.paper.getProperties().getGraphProperties().getMeanLineType());
                break;
            }
            case 3: {
                graphics2D.setStroke(this.getDataPosition.createStroke());
                graphics2D.setColor(this.paper.getProperties().getGraphProperties().getMeanLineColor());
                n = this.paper.isScrollChart() ? this.paper.getChartPlatform().showScrollLabelCount() : this.depthH;
                this.getAbsoluteValueSumOfCategory.col = n = n > this.depthH ? this.depthH : n;
                this.getAbsoluteValueSumOfCategory.tpoint1 = this.draw;
                graphics2D2 = (Graphics2D)graphics2D.create();
                rectangle = this.paper.getGraphArea();
                if (rectangle != null) {
                    graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                this.getAbsoluteValueSumOfCategory.paint(graphics2D2, this.paper.getProperties().getGraphProperties().getMeanLineType());
                break;
            }
        }
        this.append(graphics2D, this.paper.getProperties().getGraphProperties().getMeanLineNodeStyle());
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.create[n2];
    }

    private void SEDU(Graphics2D graphics2D) {
        if (this.depthH <= 1) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Rectangle rectangle = this.paper.getGraphArea();
        if (rectangle != null) {
            graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.contains.reset();
        this.contains.moveTo(this.draw[0][0], this.draw[0][1]);
        int n = this.paper.isScrollChart() ? this.paper.getChartPlatform().showScrollLabelCount() : this.depthH;
        n = n > this.depthH ? this.depthH : n;
        for (int i = 1; i < n; ++i) {
            this.contains.lineTo(this.draw[i][0], this.draw[i][1]);
        }
        this.getDataPosition.draw(graphics2D2, this.contains);
    }

    private void append(Graphics2D graphics2D, int n) {
        ChartColorPattern chartColorPattern = null;
        chartColorPattern = new ChartColorPattern(this.paper.getProperties().getGraphProperties().getMeanLineColor());
        this.drawNode.getBorderPen().setPenWidth(1.0f);
        this.drawNode.getBorderPen().setPenColor(chartColorPattern);
        this.drawNode.setFillPattern(chartColorPattern);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        if (this.paper.getGraphArea() != null) {
            Rectangle rectangle = (Rectangle)this.paper.getGraphArea().clone();
            rectangle.width += 2;
            rectangle.height += 2;
            graphics2D2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n2 = this.paper.isScrollChart() ? this.paper.getChartPlatform().showScrollLabelCount() : this.depthH;
        n2 = n2 > this.depthH ? this.depthH : n2;
        for (int i = 0; i < n2; ++i) {
            this.drawNode.drawNode(graphics2D2, (int)this.draw[i][0], (int)this.draw[i][1], n, this.paper.getProperties().getGraphProperties().getLineNodeWidth(), this.paper.getProperties().getGraphProperties().getLineNodeHeight());
        }
    }

    public void drawMeanValueY(Graphics2D graphics2D, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        Rectangle2D.Float float_ = (Rectangle2D.Float)this.paper.getProperties().getHintTextStyle().getDimension(graphics2D, stringBuffer.toString());
        ChartLabelBase chartLabelBase = new ChartLabelBase("");
        for (int i = 0; i < this.depthH; ++i) {
            if (!this.create[i].contains(n, n2)) continue;
            stringBuffer.setLength(0);
            if (this.getChartDataSetModel) {
                stringBuffer.append("Y1: ");
            } else {
                stringBuffer.append("Y2: ");
            }
            stringBuffer.append(this.dataset.getChartDataSetModel().getFormatedHintValue(this.v[i]));
            chartLabelBase.setLabelText(stringBuffer.toString());
            chartLabelBase.locate();
            chartLabelBase.paint(graphics2D, n + 10, n2 - 10);
            return;
        }
    }

    @Override
    public String[] search(int n, int n2) {
        for (int i = 0; i < this.depthH; ++i) {
            if (!this.create[i].contains(n, n2)) continue;
            return this.getFormatedHintValue[i];
        }
        return null;
    }

    @Override
    public void locate() {
        int n;
        this.layer.transform(this.depthW, this.draw);
        if (this.layer.isDepth()) {
            for (n = 0; n < this.depthH; ++n) {
                float[] fArray2 = this.draw[n];
                fArray2[0] = fArray2[0] - this.layer.depthW;
                float[] fArray3 = this.draw[n];
                fArray3[1] = fArray3[1] + this.layer.depthH;
            }
        }
        n = 5;
        for (int i = 0; i < this.depthH; ++i) {
            this.create[i].reset();
            this.create[i].moveTo(this.draw[i][0] - (float)n, this.draw[i][1] + (float)n);
            this.create[i].lineTo(this.draw[i][0] - (float)n, this.draw[i][1] - (float)n);
            this.create[i].lineTo(this.draw[i][0] + (float)n, this.draw[i][1] - (float)n);
            this.create[i].lineTo(this.draw[i][0] + (float)n, this.draw[i][1] + (float)n);
            this.create[i].lineTo(this.draw[i][0] - (float)n, this.draw[i][1] + (float)n);
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    public void setPercent(boolean bl) {
        this.getChartPlatform = bl;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        return null;
    }
}

