/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.ChartShowValueCondition;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DPieArc;
import chart.chart2d.PieLabelModification;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetModel;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Graph2DPie
extends Chart2DObject {
    public static final int LABELTYPE_VLAUE = 0;
    public static final int LABELTYPE_CATEGORYNAME = 1;
    public static final int LABELTYPE_PERCENT = 2;
    public static final int LABELTYPE_VLAUE_PERCENT = 3;
    private Chart2DPaper LabelSide;
    private ChartDataSet Lh;
    private Graph2DPieArc[][] Lw;
    private int SEDU;
    private int abs;
    private int add;
    private ChartFillPattern[] addVertex;
    private float[] adjustLabelLocation;
    private int adjustPieLabel = -1;
    private float append;
    private Point2D.Double clear;
    private Point2D.Double[] contains;
    private float cos;
    private double cutBefLabels;
    private double[][] v;
    private double[][][] distance;
    private Shape[][] doubleValue;
    private int draw = -1;
    private int equals = -1;
    private Shape[] filter;
    private String[][][] floatValue;
    private ChartTextStyle floor;
    private boolean get = false;
    private boolean getArcCenter;
    private Point2D.Float[] getArcExtendAngle;
    private ChartLabelBase[] getArcRadius;
    private ChartTextStyle getAxisXProperties;
    private Rectangle2D[] getBefLabelBounds;
    private float getBottomMargin;
    private int getBounds = 2;
    private int getCategoryFilter = 1;
    private int getCategorySize = 1;
    private int getChartDataSetModel;
    private boolean getChartLink;

    public Graph2DPie(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
        this.Lh = chartDataSet;
        this.LabelSide = chart2DPaper;
    }

    @Override
    public void init() {
        float f;
        int n;
        super.init();
        this.SEDU = this.Lh.getCategorySize();
        this.abs = this.Lh.getSeriesSize();
        this.v = new double[this.SEDU][5];
        this.distance = new double[this.abs][this.SEDU][5];
        this.contains = new Point2D.Double[this.abs];
        this.floatValue = new String[this.abs][this.SEDU][3];
        this.floor = this.LabelSide.getProperties().getHintTextStyle();
        this.floor.setWordWrapper(false);
        this.addVertex = this.LabelSide.getChartPlatform().getFillPatternByArarry(0);
        this.cutBefLabels = this.LabelSide.getProperties().getGraphProperties().getPieExplodeDistance();
        this.adjustLabelLocation = new float[2];
        this.get = this.LabelSide.properties.getGraphProperties().isContour();
        this.adjustLabelLocation[1] = this.LabelSide.properties.getGraphProperties().getPieYRotation();
        this.adjustLabelLocation[0] = this.LabelSide.properties.getGraphProperties().getPieXRotation();
        this.doubleValue = new Shape[this.abs][this.SEDU];
        this.filter = new Shape[this.SEDU];
        Number number = null;
        this.Lw = new Graph2DPieArc[this.abs][this.SEDU];
        float[][] fArray2 = new float[this.abs][this.SEDU];
        double[] dArray = new double[this.abs];
        for (int i = 0; i < this.abs; ++i) {
            for (int j = 0; j < this.SEDU; ++j) {
                float f2;
                Number number2 = ((Chart1DDataSet)this.Lh).getValue(i, j);
                if (number2 == null) {
                    f2 = 0.0f;
                } else {
                    f2 = number2.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.Lh, this.LabelSide, 3);
                        this.floatValue[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                    } else {
                        this.floatValue[i][j][0] = this.Lh.getFormatedHintValue(number2);
                    }
                }
                fArray2[i][j] = f2;
                int n2 = i;
                dArray[n2] = dArray[n2] + (double)Math.abs(f2);
            }
            if (dArray[i] != 0.0) continue;
            dArray[i] = 1.0;
        }
        float f3 = this.LabelSide.getBounds().width;
        float f4 = this.LabelSide.getBounds().height;
        float f5 = Math.min(f3, f4);
        float f6 = Math.max(f3, f4);
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        if (f3 == 0.0f || f4 == 0.0f) {
            return;
        }
        for (int i = 1; i <= this.abs; ++i) {
            n3 = i;
            for (n = 1; n <= (int)(f6 / (f5 / (float)n3)); ++n) {
                if (n3 * n < this.abs) continue;
                n4 = n;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (f3 >= f4) {
            n5 = n3;
            n6 = n4;
        } else {
            n5 = n4;
            n6 = n3;
        }
        this.getArcCenter = this.LabelSide.getProperties().getGraphProperties().isShowPieName();
        if (this.getArcCenter) {
            int n7;
            int n8;
            String[] stringArray;
            this.getAxisXProperties = this.LabelSide.getProperties().getAxisXProperties().getLabelTextStyle();
            this.getAxisXProperties.setRotation(0.0);
            this.getAxisXProperties.setShearing(0.0f);
            ArrayList<String> arrayList = null;
            if (this.Lh.getChartDataSetModel().isOneGroup()) {
                arrayList = new ArrayList<String>();
                stringArray = this.Lh.getChartDataSetModel().getValuesName();
                n8 = stringArray.length;
                for (n7 = 0; n7 < n8; ++n7) {
                    arrayList.add(stringArray[n7]);
                }
            } else {
                ChartDataFilter chartDataFilter;
                stringArray = this.Lh.getChartDataSetModel().getSeriesNames();
                n7 = stringArray.size();
                if (this.Lh.getChartDataSetModel().isSwapGroup()) {
                    chartDataFilter = this.Lh.getChartDataSetModel().getCategoryFilter();
                } else {
                    ChartDataFilter chartDataFilter2 = this.Lh.getChartDataSetModel().getCategoryFilter();
                    String string = chartDataFilter2 != null ? chartDataFilter2.getDataMappingFile() : null;
                    chartDataFilter = this.Lh.getChartDataSetModel().getSeriesFilter();
                    if (chartDataFilter != null && string != null && !string.equals("")) {
                        chartDataFilter.setDataMappingFile(string);
                    }
                }
                arrayList = new ArrayList();
                for (int i = 0; i < n7; ++i) {
                    if (chartDataFilter != null) {
                        arrayList.add(chartDataFilter.filter(stringArray.get(i)));
                        continue;
                    }
                    arrayList.add((String)stringArray.get(i));
                }
            }
            n = this.abs;
            this.getArcExtendAngle = new Point2D.Float[n];
            this.getArcRadius = new ChartLabelBase[n];
            this.getBefLabelBounds = new Rectangle2D[n];
            n7 = arrayList.size();
            this.getBottomMargin = 0.0f;
            for (n8 = 0; n8 < n; ++n8) {
                this.getArcRadius[n8] = this.cos(String.valueOf(arrayList.get(n8 % n7)), this.getAxisXProperties);
                this.getArcExtendAngle[n8] = new Point2D.Float();
                this.getBefLabelBounds[n8] = this.getAxisXProperties.getDimension(String.valueOf(arrayList.get(n8 % n7)));
                this.getBottomMargin = (float)((double)this.getBottomMargin > this.getBefLabelBounds[n8].getHeight() ? (double)this.getBottomMargin : this.getBefLabelBounds[n8].getHeight());
            }
        }
        float f7 = 0.0f;
        if (this.abs > 1) {
            f7 = this.LabelSide.properties.getGraphProperties().getPieGap();
            this.getChartDataSetModel = (int)f7;
        }
        this.getCategoryFilter = n6;
        this.getCategorySize = n5;
        float f8 = f4 / (float)n5 / 2.0f - f7 - this.getBottomMargin;
        f8 = f8 < 0.0f ? 0.0f : f8;
        this.append = Math.min(f8, f3 / (float)n6 / 2.0f);
        float f9 = f = this.append / 2.0f;
        float f10 = f9 / 4.0f;
        float f11 = 0.0f;
        String string = null;
        int n9 = 8;
        List list = this.Lh.getFilterLegendSeriesLabels();
        int n10 = this.LabelSide.getProperties().getGraphProperties().getValueLabelType();
        ChartDataSetModel chartDataSetModel = this.LabelSide.model;
        boolean bl2 = this.LabelSide.getProperties().isShadowContents();
        ChartPenStyle chartPenStyle = this.LabelSide.getProperties().getGraphProperties().getContourPen();
        int n11 = this.LabelSide.getProperties().getGraphProperties().getDonutWidth();
        for (int i = 0; i < this.abs; ++i) {
            int n12 = i / n6 + 1;
            int n13 = i - (n12 - 1) * n6 + 1;
            double d = 0.0;
            double d2 = 0.0;
            f11 = (float)(n13 * 2 - 1) * f3 / (float)(n6 * 2) - 3.0f * f9 / 2.0f;
            float f12 = (float)(n12 * 2 - 1) * f4 / (float)(n5 * 2);
            if (this.getArcCenter) {
                this.getArcExtendAngle[i].x = (float)((double)(f3 / (float)n6 * (float)n13 - f3 / (float)n6 / 2.0f) - this.getBefLabelBounds[i].getWidth() / 2.0);
                this.getArcExtendAngle[i].y = (f12 -= this.getBottomMargin / 2.0f) + this.append - this.LabelSide.getProperties().getBottomMargin();
            }
            double d3 = 0.0;
            for (int j = 0; j < this.SEDU; ++j) {
                this.Lw[i][j] = new Graph2DPieArc();
                this.Lw[i][j].setPattern(this.addVertex[0]);
                this.Lw[i][j].setIsDonut(this.getChartLink);
                this.Lw[i][j].setDonutWidth((float)n11 / 100.0f);
                if (j != 0) {
                    d += d2;
                }
                d2 = Math.abs(fArray2[i][j] * 360.0f / (float)dArray[i]);
                for (int k = 0; k < 2; ++k) {
                    this.Lw[i][j].addVertex(f11, f12, f9 / 3.0f);
                    this.Lw[i][j].addVertex(0.0f, 0.0f, 0.0f);
                    this.Lw[i][j].addVertex(0.0f, 0.0f, 0.0f);
                    this.Lw[i][j].addVertex(f11, f12 + 2.0f * f10, f9 / 3.0f);
                }
                double d4 = 0.0;
                d4 = ((Chart1DDataSet)this.Lh).getValue(i, j) == null ? (double)1.4E-45f : (double)((Chart1DDataSet)this.Lh).getValue(i, j).floatValue();
                number = ((Chart1DDataSet)this.Lh).getOriginValue(i, j);
                switch (this.LabelSide.getProperties().getGraphProperties().getValueLabelType()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        if (number == null) break;
                        number = new Double(number.doubleValue() / dArray[i]);
                        break;
                    }
                    case 3: {
                        if (number == null) break;
                        string = this.Lh.getFormatedHintValue(number);
                        number = new Double(number.doubleValue() / dArray[i]);
                        break;
                    }
                }
                String string2 = this.Lh.getFormatedHintValue(number);
                this.Lw[i][j].addVertex(f9 * 3.0f, f9 * 3.0f, 0.0f);
                this.Lw[i][j].addVertex((float)d, (float)d2, (float)d4);
                this.Lw[i][j].setAcrProperties(chartDataSetModel, chartPenStyle, number, String.valueOf(list.get(j)), this.valueLabelPosition, n10, bl2, this.adjustLabelLocation[1], this.append, this.get, string2, string, this.floor, this.LabelSide.getProperties().getGraphProperties().isSuppressZeroLabel());
                this.Lw[i][j].graphProp = this.LabelSide.getProperties().getGraphProperties();
            }
        }
    }

    @Override
    public void locate() {
        int n;
        int n2;
        if (this.adjustLabelLocation[1] >= 85.0f) {
            this.adjustLabelLocation[1] = 85.0f;
        }
        float f = this.adjustLabelLocation[0];
        for (n2 = 0; n2 < this.abs; ++n2) {
            if (this.Lw[n2][0] != null) {
                this.Lw[n2][0].vertex[9][0] = f;
                this.Lw[n2][0].vertex[8][1] = this.Lw[n2][0].vertex[8][0] * (float)Math.cos((double)this.adjustLabelLocation[1] * Math.PI / 180.0);
                this.Lw[n2][0].vertex[3][1] = this.Lw[n2][0].vertex[0][1] + this.Lw[n2][0].vertex[0][2] * (float)Math.sin((double)this.adjustLabelLocation[1] * Math.PI / 180.0);
            }
            for (n = 1; n < this.SEDU; ++n) {
                if (this.Lw[n2][n] == null) continue;
                this.Lw[n2][n].vertex[9][0] = this.Lw[n2][n - 1].vertex[9][0] + this.Lw[n2][n - 1].vertex[9][1];
                this.Lw[n2][n].vertex[8][1] = this.Lw[n2][n].vertex[8][0] * (float)Math.cos((double)this.adjustLabelLocation[1] * Math.PI / 180.0);
                this.Lw[n2][n].vertex[3][1] = this.Lw[n2][n].vertex[0][1] + this.Lw[n2][n].vertex[0][2] * (float)Math.sin((double)this.adjustLabelLocation[1] * Math.PI / 180.0);
                float f2 = this.Lw[n2][n].vertex[9][0];
                if (f2 > 360.0f) {
                    f2 -= (float)(Math.round(f2 / 360.0f) * 360);
                }
                this.Lw[n2][n].vertex[9][0] = f2;
            }
        }
        this.cos = 0.0f;
        for (n2 = 0; n2 < this.abs; ++n2) {
            for (n = 0; n < this.SEDU; ++n) {
                if (this.Lw[n2][n] == null) continue;
                this.cos = (float)this.Lw[n2][n].getArcRadius();
                this.contains[n2] = this.Lw[n2][n].getArcCenter();
                break;
            }
            if (this.cos > 0.0f) break;
        }
        block4: for (n2 = 0; n2 < this.abs; ++n2) {
            for (n = 0; n < this.SEDU; ++n) {
                if (this.Lw[n2][n] == null) continue;
                this.contains[n2] = this.Lw[n2][n].getArcCenter();
                continue block4;
            }
        }
        if (this.Lw[0][0] == null) {
            return;
        }
        this.clear = this.Lw[0][0].getArcCenter();
        this.cos = (float)this.Lw[0][0].getArcRadius();
        if (this.abs == 1) {
            for (n2 = 0; n2 < this.SEDU; ++n2) {
                this.v[n2][0] = this.Lw[0][n2].vertex[0][0];
                this.v[n2][1] = this.Lw[0][n2].vertex[0][1];
                this.v[n2][2] = this.Lw[0][n2].vertex[3][1];
                this.v[n2][3] = this.Lw[0][n2].vertex[8][0];
                this.v[n2][4] = this.Lw[0][n2].vertex[8][1];
            }
            if (this.cutBefLabels > 0.0) {
                this.Lw(this.cutBefLabels, true);
            }
        } else {
            for (n2 = 0; n2 < this.abs; ++n2) {
                for (n = 0; n < this.SEDU; ++n) {
                    this.distance[n2][n][0] = this.Lw[n2][n].vertex[0][0];
                    this.distance[n2][n][1] = this.Lw[n2][n].vertex[0][1];
                    this.distance[n2][n][2] = this.Lw[n2][n].vertex[3][1];
                    this.distance[n2][n][3] = this.Lw[n2][n].vertex[8][0];
                    this.distance[n2][n][4] = this.Lw[n2][n].vertex[8][1];
                }
            }
            if (this.cutBefLabels > 0.0) {
                this.SEDU(this.cutBefLabels, true);
            }
        }
        for (n2 = 0; n2 < this.abs; ++n2) {
            for (n = 0; n < this.SEDU; ++n) {
                this.Lw[n2][n].setPattern(this.addVertex[n]);
                this.Lw[n2][n].locate(0);
            }
        }
        this.adjustPieLabel();
        this.cutBefLabels();
        this.append();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        if (this.SEDU <= 0 || this.abs <= 0) {
            return;
        }
        for (n = 0; n < this.abs; ++n) {
            ChartShowValueCondition chartShowValueCondition = this.Lh.getCondition(n, 0);
            boolean bl = false;
            if (chartShowValueCondition != null && chartShowValueCondition.getConditionType() != 2 && chartShowValueCondition.getConditionType() != 0) {
                bl = true;
            }
            for (int i = 0; i < this.SEDU; ++i) {
                if (this.Lw[n][i] == null) continue;
                this.Lw[n][i].setPattern(this.addVertex[i]);
                this.Lw[n][i].locate(0);
                if (!bl) continue;
                this.Lw[n][i].setIsUseConditionalFill(true);
                this.Lw[n][i].setSubCondition(this.Lh.getSubCondition(n, i));
                this.Lw[n][i].setCondition(this.Lh.getCondition(n, i));
            }
        }
        this.adjustPieLabel();
        this.cutBefLabels();
        if (this.adjustLabelLocation[1] == 0.0f) {
            this.add = 0;
            this.LabelSide(graphics2D);
        } else if (this.Lw[0][0] != null) {
            this.add = 1;
            while ((float)this.add < this.Lw[0][0].vertex[0][2] * (float)Math.sin((double)this.adjustLabelLocation[1] * Math.PI / 180.0)) {
                this.LabelSide(graphics2D);
                ++this.add;
            }
            this.add = 0;
            this.LabelSide(graphics2D);
        }
        this.add = -1;
        this.LabelSide(graphics2D);
        if (this.getArcCenter) {
            for (n = 0; n < this.getArcRadius.length; ++n) {
                this.getArcRadius[n].locate();
                this.getArcRadius[n].paint(graphics2D, this.getArcExtendAngle[n].x, this.getArcExtendAngle[n].y);
            }
        }
    }

    private void LabelSide(Graphics2D graphics2D) {
        for (int i = 0; i < this.abs; ++i) {
            for (int j = 0; j < this.SEDU; ++j) {
                if (this.Lw[i][j] == null) continue;
                this.Lw[i][j].draw(graphics2D, this.add);
            }
        }
    }

    public double drag(double d, double d2, double d3, double d4) {
        if (this.Lw.length == 1) {
            if (this.equals != -1 || this.draw != -1) {
                this.Lh(d, d2, d3, d4);
            }
        } else if (this.equals != -1 || this.draw != -1) {
            double d5 = Math.floor(this.abs(this.Lw[0][this.draw], d, d2, d3, d4)) / 2.0;
            this.SEDU(d5, false);
            this.append();
        }
        this.cutBefLabels = this.cutBefLabels < 0.0 ? 0.0 : this.cutBefLabels;
        this.cutBefLabels = Math.floor(this.cutBefLabels);
        return this.cutBefLabels;
    }

    private void Lh(double d, double d2, double d3, double d4) {
        double d5 = Math.floor(this.abs(this.Lw[0][this.draw], d, d2, d3, d4)) / 2.0;
        this.Lw(d5, false);
        this.append();
    }

    private void Lw(double d, boolean bl) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.cos;
        int n = bl ? 2 : 1;
        for (int i = 0; i < this.Lw[0].length; ++i) {
            if (i == 0 && (d4 = d > this.Lw[0][i].getArcRadius() - (double)this.cos ? this.Lw[0][i].getArcRadius() * (double)this.cos / ((double)this.cos + d) : (double)this.cos) >= (double)this.cos) {
                d4 = this.cos;
            }
            double[] dArray = this.adjustLabelLocation(this.Lw[0][i]);
            double d5 = (double)this.cos - d4;
            d2 = (d + d5) * dArray[1] + d5 * (double)n;
            d3 = (d + d5) * dArray[0];
            if ((this.v[i][3] - d5 * 2.0) / 2.0 >= (double)this.cos) {
                this.Lw[0][i].vertex[0][0] = (float)this.v[i][0];
                this.Lw[0][i].vertex[0][1] = (float)this.v[i][1];
                this.Lw[0][i].vertex[3][1] = (float)this.v[i][2];
                this.Lw[0][i].vertex[8][0] = (float)this.v[i][3];
                this.Lw[0][i].vertex[8][1] = (float)this.v[i][4];
                continue;
            }
            this.Lw[0][i].vertex[0][0] = (float)(this.v[i][0] + d2);
            this.Lw[0][i].vertex[0][1] = (float)(this.v[i][1] + d3);
            this.Lw[0][i].vertex[3][1] = (float)(this.v[i][2] + d3);
            this.Lw[0][i].vertex[8][0] = (float)(this.v[i][3] - d5 * 2.0 * (double)n);
            this.Lw[0][i].vertex[8][1] = (float)(this.v[i][4] - d5 * 2.0 * (double)n);
        }
        this.cutBefLabels = this.clear.distance(this.Lw[0][0].getArcCenter()) / 2.0;
    }

    private void SEDU(double d, boolean bl) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.cos;
        int n = bl ? 2 : 1;
        double d5 = 0.0;
        for (int i = 0; i < this.Lw.length; ++i) {
            for (int j = 0; j < this.Lw[0].length; ++j) {
                double[] dArray;
                if (this.Lw[i][j] == null) {
                    // empty if block
                }
                if (j == 0 && (d4 = d > this.Lw[i][j].getArcRadius() - (double)this.cos ? this.Lw[i][j].getArcRadius() * (double)this.cos / ((double)this.cos + d) : (double)this.cos) >= (double)this.cos) {
                    d4 = this.cos;
                }
                if (this.contains[i] == null) continue;
                if (this.contains[i] != null) {
                    dArray = this.adjustPieLabel(this.Lw[i][j], this.contains[i]);
                } else {
                    double[] dArray2 = new double[2];
                    dArray2[0] = 0.0;
                    dArray = dArray2;
                    dArray2[1] = 0.0;
                }
                double[] dArray3 = dArray;
                d5 = (double)this.cos - d4;
                d2 = (d + d5) * dArray3[1] + d5 * (double)n;
                d3 = (d + d5) * dArray3[0];
                if ((this.distance[i][j][3] - d5 * 2.0) / 2.0 >= (double)this.cos) {
                    this.Lw[i][j].vertex[0][0] = (float)this.distance[i][j][0];
                    this.Lw[i][j].vertex[0][1] = (float)this.distance[i][j][1];
                    this.Lw[i][j].vertex[3][1] = (float)this.distance[i][j][2];
                    this.Lw[i][j].vertex[8][0] = (float)this.distance[i][j][3];
                    this.Lw[i][j].vertex[8][1] = (float)this.distance[i][j][4];
                    if (i <= 0) continue;
                    continue;
                }
                this.Lw[i][j].vertex[0][0] = (float)(this.distance[i][j][0] + d2);
                this.Lw[i][j].vertex[0][1] = (float)(this.distance[i][j][1] + d3);
                this.Lw[i][j].vertex[3][1] = (float)(this.distance[i][j][2] + d3);
                this.Lw[i][j].vertex[8][0] = (float)(this.distance[i][j][3] - d5 * 2.0 * (double)n);
                this.Lw[i][j].vertex[8][1] = (float)(this.distance[i][j][4] - d5 * 2.0 * (double)n);
                if (i <= 0) continue;
            }
        }
        if (this.draw >= 0) {
            this.cutBefLabels = this.clear.distance(this.Lw[0][0].getArcCenter()) / 2.0;
        }
    }

    private double abs(Graph2DPieArc graph2DPieArc, double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        Point2D.Double double_ = this.add(graph2DPieArc);
        if (Math.round(this.clear.x - ((Point2D)double_).getX()) == 0L) {
            double d8 = this.clear.x;
            d7 = d2;
            double d9 = this.clear.x;
            d6 = d4;
            d5 = d4 - d2;
        } else if (Math.round(this.clear.y - ((Point2D)double_).getY()) == 0L) {
            double d10 = d;
            d7 = this.clear.y;
            double d11 = d3;
            d6 = this.clear.y;
            d5 = d3 - d;
        } else {
            double d12 = -(((Point2D)double_).getX() - this.clear.x) / (((Point2D)double_).getY() - this.clear.y);
            double d13 = d2 - d12 * d;
            double d14 = (this.clear.x - d12 * d13 + d12 * this.clear.y) / (d12 * d12 + 1.0);
            d7 = d12 * d14 + d13;
            double d15 = d4 - d12 * d3;
            double d16 = (this.clear.x - d12 * d15 + d12 * this.clear.y) / (d12 * d12 + 1.0);
            d6 = d12 * d16 + d15;
            d5 = Point2D.distance(d14, d7, d16, d6);
        }
        if ((d6 - d7) * (this.clear.y - d7) >= 0.0) {
            d5 = -d5;
        }
        return d5;
    }

    private Point2D.Double add(Graph2DPieArc graph2DPieArc) {
        double d = (float)(Math.sin((double)(graph2DPieArc.vertex[9][0] + graph2DPieArc.vertex[9][1] / 2.0f + 90.0f) * Math.PI / 180.0) * (double)graph2DPieArc.vertex[8][0] / 2.0 + (double)graph2DPieArc.vertex[0][0] + (double)(graph2DPieArc.vertex[8][0] / 2.0f));
        double d2 = (float)(Math.cos((double)(graph2DPieArc.vertex[9][0] + graph2DPieArc.vertex[9][1] / 2.0f + 90.0f) * Math.PI / 180.0) * (double)graph2DPieArc.vertex[8][1] / 2.0 + (double)graph2DPieArc.vertex[0][1]);
        Point2D.Double double_ = new Point2D.Double(d, d2);
        return double_;
    }

    private GeneralPath addVertex(Graph2DPieArc graph2DPieArc) {
        int n;
        float f = 1.0f;
        double d = graph2DPieArc.getArcExtendAngle();
        int n2 = (int)(d / (double)f);
        n2 = n2 == 0 ? 1 : n2;
        double d2 = d / (double)n2;
        GeneralPath generalPath = new GeneralPath();
        Point2D.Double[] doubleArray = new Point2D.Double[n2 + 2];
        for (n = 0; n < n2 + 2; ++n) {
            doubleArray[n] = new Point2D.Double();
        }
        doubleArray[0] = graph2DPieArc.getArcCenter();
        doubleArray[1] = graph2DPieArc.getStartPoint();
        doubleArray[n2 + 1] = graph2DPieArc.getEndPoint();
        for (n = 0; n < n2 - 1; ++n) {
            doubleArray[n + 2].x = (float)(Math.sin(((double)graph2DPieArc.vertex[9][0] + d2 * (double)(n + 1) + 90.0) * Math.PI / 180.0) * (double)graph2DPieArc.vertex[8][0] / 2.0 + (double)graph2DPieArc.vertex[0][0] + (double)(graph2DPieArc.vertex[8][0] / 2.0f));
            doubleArray[n + 2].y = (float)(Math.cos(((double)graph2DPieArc.vertex[9][0] + d2 * (double)(n + 1) + 90.0) * Math.PI / 180.0) * (double)graph2DPieArc.vertex[8][1] / 2.0 + (double)graph2DPieArc.vertex[0][1]);
        }
        generalPath.moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
        for (n = 1; n < doubleArray.length; ++n) {
            generalPath.lineTo((float)doubleArray[n].x, (float)doubleArray[n].y);
        }
        generalPath.lineTo((float)doubleArray[0].x, (float)doubleArray[0].y);
        return generalPath;
    }

    private double[] adjustLabelLocation(Graph2DPieArc graph2DPieArc) {
        double[] dArray = new double[2];
        Point2D.Double double_ = this.add(graph2DPieArc);
        double d = Math.sqrt(Math.pow(double_.getX() - this.clear.x, 2.0) + Math.pow(double_.getY() - this.clear.y, 2.0));
        double d2 = (double_.getY() - this.clear.y) / d;
        double d3 = (double_.getX() - this.clear.x) / d;
        dArray[0] = d2;
        dArray[1] = d3;
        return dArray;
    }

    private double[] adjustPieLabel(Graph2DPieArc graph2DPieArc, Point2D.Double double_) {
        double[] dArray = new double[2];
        Point2D.Double double_2 = this.add(graph2DPieArc);
        double d = Math.sqrt(Math.pow(double_2.getX() - double_.x, 2.0) + Math.pow(double_2.getY() - double_.y, 2.0));
        double d2 = (double_2.getY() - double_.y) / d;
        double d3 = (double_2.getX() - double_.x) / d;
        dArray[0] = d2;
        dArray[1] = d3;
        return dArray;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.abs; ++i) {
            for (int j = 0; j < this.SEDU; ++j) {
                if (!this.doubleValue[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.floatValue[i][j];
            }
        }
        return null;
    }

    private void append() {
        this.clear();
        this.contains();
    }

    private void clear() {
        for (int i = 0; i < this.abs; ++i) {
            for (int j = 0; j < this.SEDU; ++j) {
                this.doubleValue[i][j] = this.addVertex(this.Lw[i][j]);
            }
        }
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.filter[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.doubleValue[n][n2];
    }

    public Shape[][] getItemShapes(int n) {
        return this.doubleValue;
    }

    public boolean contains(int n, int n2) {
        return this.adjustPieLabel != -1;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.SEDU; ++i) {
            if (!this.filter[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.doubleValue;
    }

    Shape[][] getItemShapesForDesigner() {
        Shape[][] shapeArray = new Shape[this.abs][this.SEDU];
        for (int i = 0; i < this.abs; ++i) {
            for (int j = 0; j < this.SEDU; ++j) {
                shapeArray[i][j] = this.Lw[i][j].vertex[9][1] >= 360.0f ? new Arc2D.Double(this.Lw[i][j].vertex[0][0], this.Lw[i][j].vertex[0][1] - this.Lw[i][j].vertex[8][1] / 2.0f, this.Lw[i][j].vertex[8][0], this.Lw[i][j].vertex[8][1], this.Lw[i][j].vertex[9][0], this.Lw[i][j].vertex[9][1], 0) : new Arc2D.Double(this.Lw[i][j].vertex[0][0], this.Lw[i][j].vertex[0][1] - this.Lw[i][j].vertex[8][1] / 2.0f, this.Lw[i][j].vertex[8][0], this.Lw[i][j].vertex[8][1], this.Lw[i][j].vertex[9][0], this.Lw[i][j].vertex[9][1], 2);
            }
        }
        return shapeArray;
    }

    public void setSelectedSeriesIndex(int n) {
        this.draw = n;
    }

    public void setSelectedObjectIndex(int n) {
        this.equals = n;
    }

    private void contains() {
        int n;
        for (n = 0; n < this.SEDU; ++n) {
            this.filter[n] = new GeneralPath();
        }
        for (n = 0; n < this.abs; ++n) {
            for (int i = 0; i < this.SEDU; ++i) {
                ((GeneralPath)this.filter[i]).append(this.doubleValue[n][i], false);
            }
        }
    }

    public Point2D.Double getPieCenter() {
        return this.clear;
    }

    private ChartLabelBase cos(String string, ChartTextStyle chartTextStyle) {
        ChartLabelBase chartLabelBase;
        if (string != null) {
            chartLabelBase = new ChartLabelBase(string);
            chartLabelBase.setChartTextStyle(chartTextStyle);
        } else {
            chartLabelBase = null;
        }
        return chartLabelBase;
    }

    public void cutBefLabels() {
        if (this.valueLabelPosition != 50) {
            return;
        }
        Line2D.Double[] doubleArray = null;
        Line2D.Double[] doubleArray2 = null;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.abs; ++i) {
            int n3;
            int n4;
            int n5;
            int n6;
            for (n6 = 0; n6 < this.SEDU; ++n6) {
                if (this.Lw[i][n6] == null || this.Lw[i][n6].getValueLabel() == null || this.Lw[i][n6].getLabelPosition() == null) continue;
                if (n == -1) {
                    n = n6;
                    n2 = n6;
                    continue;
                }
                doubleArray = this.Lw[i][n].getBefLabelBounds(this.Lw[i][n6].Lw + 2.0, this.Lw[i][n6].Lh);
                doubleArray2 = this.Lw[i][n6].getBefLabelBounds(this.Lw[i][n6].Lw + 2.0, this.Lw[i][n6].Lh);
                if (doubleArray2 == null) continue;
                if (doubleArray == null) {
                    n = n6;
                    continue;
                }
                if (doubleArray == null) {
                    doubleArray = this.Lw[i][n].getBefLabelBounds(this.Lw[i][n6].Lw + 2.0, this.Lw[i][n6].Lh);
                }
                n5 = 0;
                for (n4 = 0; n4 < doubleArray.length; ++n4) {
                    for (n3 = 0; n3 < doubleArray2.length; ++n3) {
                        if (doubleArray[n4].intersectsLine(doubleArray2[n3])) {
                            n5 = 1;
                        }
                        if (n5 == 0) continue;
                    }
                }
                if (n5 == 0) {
                    n = n6;
                    continue;
                }
                this.Lw[i][n6].setLabelPosition(null);
            }
            if (n2 == -1 || n <= 0) continue;
            doubleArray = this.Lw[i][n2].getBefLabelBounds(this.Lw[i][n2].Lw + 2.0, this.Lw[i][n2].Lh);
            doubleArray2 = this.Lw[i][n].getBefLabelBounds(this.Lw[i][n].Lw + 2.0, this.Lw[i][n].Lh);
            n6 = 0;
            n5 = 0;
            if (doubleArray != null) {
                n6 = doubleArray.length;
            }
            if (doubleArray2 != null) {
                n5 = doubleArray2.length;
            }
            block4: for (n4 = 0; n4 < n6; ++n4) {
                for (n3 = 0; n3 < n5; ++n3) {
                    if (!doubleArray[n4].intersectsLine(doubleArray2[n3])) continue;
                    this.Lw[i][n].setLabelPosition(null);
                    continue block4;
                }
            }
        }
    }

    public void adjustPieLabel() {
        int n;
        int n2;
        if (this.valueLabelPosition == 50) {
            return;
        }
        boolean bl = true;
        ArrayList<Graph2DPieArc> arrayList = new ArrayList<Graph2DPieArc>();
        Rectangle rectangle = new Rectangle(this.LabelSide.getBounds());
        double d = -1.0;
        double d2 = -1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        Point2D.Double double_ = null;
        int n3 = rectangle.width - this.getChartDataSetModel > 0 ? (rectangle.width - (this.getCategoryFilter - 1) * this.getChartDataSetModel) / this.getCategoryFilter : 0;
        int n4 = n2 = rectangle.height - this.getChartDataSetModel > 0 ? (rectangle.height - (this.getCategorySize - 1) * this.getChartDataSetModel) / this.getCategorySize : 0;
        if (n3 == 0 || n2 == 0) {
            return;
        }
        for (n = 0; n < this.SEDU; ++n) {
            if (this.Lw[0][n] == null) continue;
            d = this.Lw[0][n].getArcCenter().x;
            d2 = this.Lw[0][n].getArcCenter().y;
            n = this.SEDU;
            break;
        }
        if (d < 0.0 && d2 < 0.0) {
            d = n3 / 2;
            d2 = n2 / 2;
        }
        for (n = 0; n < this.abs; ++n) {
            int n5;
            bl = true;
            for (n5 = 0; n5 < this.SEDU; ++n5) {
                if (this.Lw[n][n5] == null) continue;
                arrayList.add(this.Lw[n][n5]);
                bl = false;
            }
            if (!bl) {
                int n6;
                double_ = new Point2D.Double();
                for (n5 = 0; n5 < this.SEDU; ++n5) {
                    if (this.Lw[n][n5] == null) continue;
                    d3 = this.Lw[n][n5].getArcCenter().x;
                    d4 = this.Lw[n][n5].getArcCenter().y;
                    double_ = this.Lw[n][n5].getArcCenter();
                    n5 = this.SEDU;
                }
                Rectangle rectangle2 = new Rectangle((int)(d3 -= d), (int)(d4 -= d2), n3, n2);
                PieLabelModification pieLabelModification = new PieLabelModification(arrayList, this.getBounds, rectangle2, this.cos, double_, n, this.getCategorySize, this.getCategoryFilter);
                if (this.valueLabelPosition == 49) {
                    boolean bl2 = pieLabelModification.islabelovrlap();
                    if (bl2) {
                        ArrayList arrayList2 = pieLabelModification.setLabelsLocation();
                        for (int i = 0; i < this.SEDU; ++i) {
                            if (arrayList2.get(i) != null) {
                                Point2D.Double double_2 = (Point2D.Double)arrayList2.get(i);
                                this.Lw[n][i].getLabelPosition().y = double_2.y;
                                this.Lw[n][i].setOverlaped();
                                continue;
                            }
                            this.Lw[n][i].setLabelPosition(null);
                        }
                    }
                    for (n6 = 0; n6 < this.SEDU; ++n6) {
                        if (this.Lw[n][n6] == null || this.Lw[n][n6].getLabelPosition() == null || this.Lw[n][n6].getStartPoint() == null || this.Lw[n][n6].getValueLabel() == null) continue;
                        if (!bl2) {
                            pieLabelModification.moveSlimLegLabel(rectangle2, this.Lw[n][n6], this.Lw[n][n6].getLabelPosition(), this.Lw[n][n6].getValueLabel().getLabelBaseDimension().width, this.Lw[n][n6].LabelSide());
                            continue;
                        }
                        pieLabelModification.moveSlimLegLabel(rectangle2, this.Lw[n][n6], this.Lw[n][n6].getLabelPosition(), this.Lw[n][n6].getValueLabel().getLabelBaseDimension().width, this.Lw[n][n6].LabelSide(), true);
                    }
                } else {
                    ArrayList arrayList3 = pieLabelModification.adjustLabelLocation();
                    for (n6 = 0; n6 < this.SEDU; ++n6) {
                        Point2D.Double double_3 = (Point2D.Double)arrayList3.get(n6);
                        if (this.Lw[n][n6] == null || this.Lw[n][n6].isLabelInSlice()) continue;
                        this.Lw[n][n6].setLabelPosition(double_3);
                    }
                }
            }
            arrayList.clear();
        }
    }

    private double cutBefLabels(Line2D line2D, Point2D.Double double_) {
        if (line2D == null || double_ == null) {
            return 0.0;
        }
        return line2D.ptLineDist(double_);
    }

    private Point2D.Double distance(Line2D line2D, Point2D.Double double_, Point2D.Double double_2, double d) {
        if (double_ == null || double_2 == null || d <= 0.0 || line2D == null) {
            return double_2;
        }
        double d2 = line2D.ptLineDist(double_);
        double d3 = line2D.ptLineDist(double_2);
        if (d2 >= d) {
            return double_;
        }
        double d4 = Math.abs((d - d2) / (d3 - d2));
        Point2D.Double double_3 = new Point2D.Double(double_.x + d4 * (double_2.x - double_.x), double_.y + d4 * (double_2.y - double_.y));
        return double_3;
    }

    private boolean doubleValue(double d, double d2, Rectangle rectangle) {
        return d < (double)(rectangle.x - 1) || d2 < (double)(rectangle.y - 1) || d > (double)(rectangle.x + rectangle.width + 1) || d2 > (double)(rectangle.y + rectangle.height + 1);
    }

    private Rectangle draw(int n) {
        int n2 = this.LabelSide.getBounds().width - this.getChartDataSetModel > 0 ? (this.LabelSide.getBounds().width - (this.getCategoryFilter - 1) * this.getChartDataSetModel) / this.getCategoryFilter : 0;
        int n3 = this.LabelSide.getBounds().height - this.getChartDataSetModel > 0 ? (this.LabelSide.getBounds().height - (this.getCategorySize - 1) * this.getChartDataSetModel) / this.getCategorySize : 0;
        float f = this.LabelSide.getBounds().width / this.getCategoryFilter;
        float f2 = this.LabelSide.getBounds().height / this.getCategorySize;
        int n4 = n / this.getCategoryFilter;
        int n5 = n % this.getCategoryFilter;
        return new Rectangle((int)(f * (float)n5 - (float)(n5 * this.getChartDataSetModel)), (int)(f2 * (float)n4 - (float)(n4 * this.getChartDataSetModel)), n2, n3);
    }

    public void setIsDonut(boolean bl) {
        this.getChartLink = bl;
    }

    public boolean isDonut() {
        return this.getChartLink;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.Lh.getShowValueBeginIndex();
        int n4 = this.Lh.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.abs / n5;
        for (int i = 0; i < this.abs; ++i) {
            for (int j = 0; j < this.SEDU; ++j) {
                if (!this.doubleValue[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.Lh.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

