/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DRadarLayer;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import com.jinfonet.util.JRLog;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;
import jet.util.JRInterruptedException;

public class Graph2DRadar
extends Chart2DObject {
    private float SEDU;
    private float abs;
    private float axisY;
    private double axisY1;
    private ChartPenStyle contains;
    private ChartPenStyle cos;
    private GeneralPath[][] draw;
    private Graph2DLineNode drawNode = new Graph2DLineNode();
    private double error;
    private int fill = 5;
    private int floatValue;
    private int formatLineNode;
    private float[] get = new float[2];
    private GeneralPath[] getAbsoluteValueSum;
    private Line2D.Float[][] getAbsoluteValueSumOfCategory;
    private float v;
    protected float[][] value;
    private float[][] getBorderPen;
    private float[][] getBounds;
    private int[] getCategorySize;
    private String[][][] getChartDataSetModel;
    private double[] getChartLegend;

    Graph2DRadar(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        int n;
        int n2;
        int n3;
        super.init();
        this.cos = this.paper.getProperties().getGraphProperties().getContourPen();
        this.error = Math.PI;
        this.floatValue = ((Chart1DDataSet)this.dataset).getSeriesSize();
        this.formatLineNode = ((Chart1DDataSet)this.dataset).getCategorySize();
        this.value = new float[this.floatValue][this.formatLineNode];
        this.paper.axisY1.setRadarArrowStyle(this.objectProperties.getRadarArrowStyle());
        this.getAbsoluteValueSum = new GeneralPath[this.floatValue];
        this.axisY1 = (double)(2.0f / (float)this.formatLineNode) * this.error;
        this.draw = new GeneralPath[this.floatValue][this.formatLineNode];
        this.getAbsoluteValueSumOfCategory = new Line2D.Float[this.floatValue][this.formatLineNode];
        this.getChartDataSetModel = new String[this.floatValue][this.formatLineNode][1];
        if (this.paper.platform.getChartLegend() != null) {
            this.getCategorySize = this.paper.platform.getChartLegend().getIconStyleList();
        }
        for (n3 = 0; n3 < this.floatValue; ++n3) {
            this.getAbsoluteValueSum[n3] = new GeneralPath();
            for (int i = 0; i < this.formatLineNode; ++i) {
                this.draw[n3][i] = new GeneralPath();
                this.getAbsoluteValueSumOfCategory[n3][i] = new Line2D.Float();
            }
        }
        this.getBorderPen = new float[this.formatLineNode * this.floatValue][2];
        this.getBounds = new float[this.floatValue * this.formatLineNode][2];
        this.abs = (float)((ChartNumericAxis)this.paper.axisY1).getMax();
        this.axisY = (float)((ChartNumericAxis)this.paper.axisY1).getMin();
        this.get[0] = this.paper.getBounds().width;
        this.get[1] = this.paper.getBounds().height;
        this.abs -= this.axisY;
        this.SEDU = this.get[1] > this.get[0] ? this.get[0] : this.get[1];
        this.SEDU = ((Chart2DRadarLayer)this.layer).getRadarAxisLength((int)this.SEDU);
        n3 = this.dataset.getChartDataSetModel().isOneGroup() ? 1 : 0;
        float[] fArray2 = null;
        if (((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent()) {
            if (n3 != 0) {
                fArray2 = new float[]{(float)((Chart1DDataSet)this.dataset).getAbsoluteValueSum()};
            }
        } else {
            fArray2 = new float[this.formatLineNode];
            for (int i = 0; i < this.formatLineNode; ++i) {
                fArray2[i] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i);
            }
        }
        for (n2 = 0; n2 < this.floatValue; ++n2) {
            this.v = 0.0f;
            for (n = 0; n < this.formatLineNode; ++n) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    this.v = 0.0f;
                } else {
                    this.v = !((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent() ? number.floatValue() : (n3 == 0 ? number.floatValue() / fArray2[n] : number.floatValue() / fArray2[0]);
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.getChartDataSetModel[n2][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n2, n);
                    } else {
                        this.getChartDataSetModel[n2][n][0] = this.dataset.getFormatedHintValue(number);
                    }
                }
                this.v = this.v - this.axisY > 0.0f ? this.v - this.axisY : 0.0f;
                this.v = this.v > this.abs ? this.abs : this.v;
                this.getBorderPen[this.formatLineNode * n2 + n][0] = this.get[0] / 2.0f + this.v / this.abs * this.SEDU * (float)Math.cos(this.axisY1 * (double)n + 0.5 * this.error);
                this.getBorderPen[this.formatLineNode * n2 + n][1] = this.get[1] / 2.0f + this.v / this.abs * this.SEDU * (float)Math.sin(this.axisY1 * (double)n + 0.5 * this.error);
                this.value[n2][n] = this.v;
            }
        }
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            this.getChartLegend = new double[this.floatValue];
            for (n2 = 0; n2 < this.floatValue; ++n2) {
                for (n = 0; n < this.formatLineNode; ++n) {
                    if (!((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent()) {
                        int n4 = n2;
                        this.getChartLegend[n4] = this.getChartLegend[n4] + (double)Math.abs(this.value[n2][n]);
                        continue;
                    }
                    int n5 = n2;
                    this.getChartLegend[n5] = this.getChartLegend[n5] + (double)Math.abs(this.value[n2][n] * fArray2[n2]);
                }
                if (this.getChartLegend[n2] != 0.0) continue;
                this.getChartLegend[n2] = 1.0;
            }
        } else {
            this.getChartLegend = new double[this.formatLineNode];
            for (n2 = 0; n2 < this.formatLineNode; ++n2) {
                for (n = 0; n < this.floatValue; ++n) {
                    if (!((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent()) {
                        int n6 = n2;
                        this.getChartLegend[n6] = this.getChartLegend[n6] + (double)Math.abs(this.value[n][n2]);
                        continue;
                    }
                    int n7 = n2;
                    this.getChartLegend[n7] = this.getChartLegend[n7] + (double)Math.abs(this.value[n][n2] * fArray2[n2]);
                }
                if (this.getChartLegend[n2] != 0.0) continue;
                this.getChartLegend[n2] = 1.0;
            }
        }
    }

    @Override
    public void locate() {
        this.layer.transform(this.getBorderPen, this.getBounds);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        block12: {
            this.contains();
            this.abs(graphics2D);
            for (int i = 0; i < this.formatLineNode; ++i) {
                for (int j = 0; j < this.floatValue; ++j) {
                    if (((Chart1DDataSet)this.dataset).getValue(j, i) == null) continue;
                    this.axisY(graphics2D, j, i);
                }
            }
            try {
                this.axisY1();
            }
            catch (JRInterruptedException jRInterruptedException) {
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block12;
                JRLog.error(2, exception);
            }
        }
        if (this.valueLabelPosition != 0) {
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.getBounds, 0, this.floatValue, this.valueLabelPosition, this.getChartLegend);
            graph2DStaticHint.paint();
        }
        if (this.objectProperties.isRadarIsFill()) {
            for (int i = 0; i < this.floatValue; ++i) {
                if (this.seriesPattern[i] != null) {
                    if (this.seriesPattern[i] instanceof ChartColorPattern) {
                        this.contains.setPenColor((ChartColorPattern)this.seriesPattern[i]);
                        graphics2D.setColor(this.contains.getPenColor().getColor());
                        this.seriesPattern[i] = new ChartColorPattern(ChartColorPattern.transparent(graphics2D.getColor(), this.objectProperties.getRadarFillTransparence()));
                        this.seriesPattern[i].fill(graphics2D, this.getAbsoluteValueSum[i]);
                        if (this.seriesPattern[i] instanceof ChartColorPattern) {
                            this.seriesPattern[i] = new ChartColorPattern(ChartColorPattern.transparent(graphics2D.getColor(), 0.0f));
                        }
                    } else {
                        this.seriesPattern[i].fill(graphics2D, this.getAbsoluteValueSum[i]);
                    }
                }
                if (!this.paper.getProperties().getGraphProperties().isContour()) continue;
                this.SEDU(graphics2D);
            }
        }
    }

    private void SEDU(Graphics2D graphics2D) {
        for (int i = 0; i < this.floatValue; ++i) {
            this.paper.getProperties().getGraphProperties().getContourPen();
            if (this.cos == null) continue;
            this.cos.draw(graphics2D, this.getAbsoluteValueSum[i]);
        }
    }

    private void abs(Graphics2D graphics2D) {
        for (int i = 0; i < this.floatValue; ++i) {
            this.contains = new ChartPenStyle();
            this.paper.getProperties().getGraphProperties().getContourPen();
            if (!(this.seriesPattern[i] instanceof ChartColorPattern)) continue;
            this.contains.setPenColor((ChartColorPattern)this.seriesPattern[i]);
            this.contains.setPenWidth(this.objectProperties.getLineThickness());
            this.contains.draw(graphics2D, this.getAbsoluteValueSum[i]);
        }
    }

    private void axisY(Graphics2D graphics2D, int n, int n2) {
        int n3 = 0;
        if (this.seriesPattern[n] instanceof ChartColorPattern) {
            ChartColorPattern chartColorPattern = null;
            chartColorPattern = (ChartColorPattern)this.seriesPattern[n];
            if (((Chart1DDataSet)this.dataset).getValue(n, n2) != null) {
                n3 = this.objectProperties.getLineNodeStyle();
            }
            if (this.getCategorySize != null && this.getCategorySize.length != 0) {
                n3 = this.paper.formatLineNode(this.objectProperties.getLineNodeStyle(), this.getCategorySize[n % this.getCategorySize.length]);
            }
            this.drawNode.getBorderPen().setPenWidth(1.0f);
            this.drawNode.getBorderPen().setPenColor(chartColorPattern);
            this.drawNode.setFillPattern(chartColorPattern);
            this.drawNode.drawNode(graphics2D, (int)this.getBounds[this.formatLineNode * n + n2][0], (int)this.getBounds[this.formatLineNode * n + n2][1], n3, this.paper.getProperties().getGraphProperties().getLineNodeWidth(), this.paper.getProperties().getGraphProperties().getLineNodeHeight());
        }
    }

    @Override
    Shape[][] getItemShapes() {
        return this.draw;
    }

    private void axisY1() {
        for (int i = 0; i < this.floatValue; ++i) {
            for (int j = 0; j < this.formatLineNode; ++j) {
                this.draw[i][j].reset();
                this.draw[i][j].moveTo(this.getBounds[i * this.formatLineNode + j][0] - (float)this.fill, this.getBounds[i * this.formatLineNode + j][1] + (float)this.fill);
                this.draw[i][j].lineTo(this.getBounds[i * this.formatLineNode + j][0] - (float)this.fill, this.getBounds[i * this.formatLineNode + j][1] - (float)this.fill);
                this.draw[i][j].lineTo(this.getBounds[i * this.formatLineNode + j][0] + (float)this.fill, this.getBounds[i * this.formatLineNode + j][1] - (float)this.fill);
                this.draw[i][j].lineTo(this.getBounds[i * this.formatLineNode + j][0] + (float)this.fill, this.getBounds[i * this.formatLineNode + j][1] + (float)this.fill);
                this.draw[i][j].lineTo(this.getBounds[i * this.formatLineNode + j][0] - (float)this.fill, this.getBounds[i * this.formatLineNode + j][1] + (float)this.fill);
            }
        }
    }

    private void contains() {
        for (int i = 0; i < this.floatValue; ++i) {
            this.getAbsoluteValueSum[i].reset();
            this.getAbsoluteValueSum[i].moveTo(this.getBounds[i * this.formatLineNode][0], this.getBounds[i * this.formatLineNode][1]);
            if (this.formatLineNode > 1) {
                for (int j = 0; j < this.formatLineNode; ++j) {
                    if (j > 0) {
                        this.getAbsoluteValueSum[i].lineTo(this.getBounds[i * this.formatLineNode + j][0], this.getBounds[i * this.formatLineNode + j][1]);
                    }
                    this.cos(i, j);
                }
            }
            this.getAbsoluteValueSum[i].lineTo(this.getBounds[i * this.formatLineNode][0], this.getBounds[i * this.formatLineNode][1]);
        }
    }

    private void cos(int n, int n2) {
        if (n2 == this.formatLineNode - 1) {
            this.getAbsoluteValueSumOfCategory[n][n2].setLine(this.getBounds[n * this.formatLineNode + n2][0], this.getBounds[n * this.formatLineNode + n2][1], this.getBounds[n * this.formatLineNode][0], this.getBounds[n * this.formatLineNode][1]);
        } else {
            this.getAbsoluteValueSumOfCategory[n][n2].setLine(this.getBounds[n * this.formatLineNode + n2][0], this.getBounds[n * this.formatLineNode + n2][1], this.getBounds[n * this.formatLineNode + n2 + 1][0], this.getBounds[n * this.formatLineNode + n2 + 1][1]);
        }
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.floatValue; ++i) {
            for (int j = 0; j < this.formatLineNode; ++j) {
                if (!this.getAbsoluteValueSumOfCategory[i][j].intersects(n - 5, n2 - 5, 10.0, 10.0)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.getAbsoluteValueSum[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.floatValue; ++i) {
            for (int j = 0; j < this.formatLineNode; ++j) {
                if (!this.draw[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.getChartDataSetModel[i][j];
            }
        }
        return null;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.floatValue / n5;
        for (int i = 0; i < this.floatValue; ++i) {
            for (int j = 0; j < this.formatLineNode; ++j) {
                if (!this.draw[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

