/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DScatterCurve;
import chart.data.Chart2DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.List;

public class Graph2DScatter
extends Chart2DObject {
    protected ChartPenStyle pen;
    protected int col;
    protected int row;
    protected int style;
    protected Shape[] seriesShapes;
    protected Shape[][] itemShapes;
    protected Graph2DLineNode lineNode;
    protected int scatterType;
    private static final int SEDU = 0;
    private static final int append = 1;
    private static final int availableValue = 2;
    protected int gap = 5;
    protected float[][] scatters;
    protected float[][] tScatters;
    protected float[][] value;
    protected float unitX;
    protected float unitY;
    protected float minX;
    protected Graph2DScatterCurve curve;
    private int availableValueX;
    private int closePath;
    private int contains;
    private int[] createStroke;
    private Shape[] draw;
    private String[][][] drawCurve;

    Graph2DScatter(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        int n;
        int n2;
        super.init();
        this.pen = new ChartPenStyle();
        this.pen.setPenWidth(this.objectProperties.getLineThickness());
        this.row = this.dataset.getSeriesSize();
        this.col = this.dataset.getCategorySize();
        this.style = this.objectProperties.getLineNodeStyle();
        this.lineNode = new Graph2DLineNode();
        this.pen.setPenWidth(this.objectProperties.getLineThickness());
        if (this.paper.platform.getChartLegend() != null) {
            this.createStroke = this.paper.platform.getChartLegend().getIconStyleList();
        }
        this.scatters = new float[this.row * this.col][2];
        this.tScatters = new float[this.row * this.col][2];
        this.value = new float[this.row * this.col][2];
        this.drawCurve = new String[this.row][this.col][4];
        this.availableValueX = this.row / 2;
        this.seriesShapes = new Shape[this.row];
        this.itemShapes = new Shape[this.row][this.col];
        this.draw = new Shape[this.row];
        this.unitX = this.layer.getXUnit();
        this.unitY = this.layer.getYUnit();
        for (int i = 0; i < this.row; ++i) {
            this.seriesShapes[i] = new GeneralPath();
            this.draw[i] = new GeneralPath();
            for (int j = 0; j < this.col; ++j) {
                this.itemShapes[i][j] = new GeneralPath();
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                Number number = ((Chart2DDataSet)this.dataset).getX(n2, n);
                if (this.layer.isShowCategoryAndSeries()) {
                    this.drawCurve[n2][n] = this.hintLabelShowCategoryAndSeries(4, n2, n, number);
                    continue;
                }
                if (number != null) {
                    this.value[n2 * this.col + n][0] = number.floatValue();
                    stringBuffer.append("X: ");
                    stringBuffer.append(this.dataset.getFormatedHintValue(number));
                    this.drawCurve[n2][n][0] = stringBuffer.toString();
                    stringBuffer.setLength(0);
                }
                if ((number = ((Chart2DDataSet)this.dataset).getY(n2, n)) == null) continue;
                this.value[n2 * this.col + n][1] = number.floatValue();
                stringBuffer.append("Y: ");
                stringBuffer.append(this.dataset.getFormatedHintValue(number));
                this.drawCurve[n2][n][1] = stringBuffer.toString();
                stringBuffer.setLength(0);
            }
        }
        this.minX = (float)((ChartNumericAxis)this.layer.getAxisX()).getMin();
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                this.scatters[n2 * this.col + n][0] = this.layer.availableValueX(this.value[n2 * this.col + n][0]) * this.unitX;
                this.scatters[n2 * this.col + n][1] = this.unitY * this.layer.availableValue(this.value[n2 * this.col + n][1]);
            }
        }
    }

    @Override
    public void locate() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.row; ++n2) {
            ((GeneralPath)this.seriesShapes[n2]).reset();
            ((GeneralPath)this.draw[n2]).reset();
            for (n = 0; n < this.col; ++n) {
                ((GeneralPath)this.itemShapes[n2][n]).reset();
            }
        }
        this.layer.transform(this.scatters, this.tScatters);
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                if (((Chart2DDataSet)this.dataset).getX(n2, n) == null || ((Chart2DDataSet)this.dataset).getY(n2, n) == null) continue;
                ((GeneralPath)this.itemShapes[n2][n]).moveTo(this.tScatters[n2 * this.col + n][0] - (float)this.gap, this.tScatters[n2 * this.col + n][1] + (float)this.gap);
                ((GeneralPath)this.itemShapes[n2][n]).lineTo(this.tScatters[n2 * this.col + n][0] + (float)this.gap, this.tScatters[n2 * this.col + n][1] + (float)this.gap);
                ((GeneralPath)this.itemShapes[n2][n]).lineTo(this.tScatters[n2 * this.col + n][0] + (float)this.gap, this.tScatters[n2 * this.col + n][1] - (float)this.gap);
                ((GeneralPath)this.itemShapes[n2][n]).lineTo(this.tScatters[n2 * this.col + n][0] - (float)this.gap, this.tScatters[n2 * this.col + n][1] - (float)this.gap);
                ((GeneralPath)this.itemShapes[n2][n]).closePath();
                ((GeneralPath)this.draw[n2]).append(this.itemShapes[n2][n], false);
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        switch (this.scatterType) {
            case 0: {
                for (int i = 0; i < this.row; ++i) {
                    this.drawLine(graphics2D, i);
                    for (int j = 0; j < this.col; ++j) {
                        this.drawScatterN(graphics2D, i, j);
                    }
                }
                break;
            }
            case 1: {
                if (this.style == 9) {
                    this.style = 2;
                }
                for (int i = 0; i < this.row; ++i) {
                    for (int j = 0; j < this.col; ++j) {
                        this.drawScatterN(graphics2D, i, j);
                    }
                }
                break;
            }
            case 2: {
                this.drawCurve(graphics2D);
                for (int i = 0; i < this.row; ++i) {
                    for (int j = 0; j < this.col; ++j) {
                        this.drawScatterN(graphics2D, i, j);
                    }
                }
                break;
            }
        }
    }

    public void drawCurve(Graphics2D graphics2D) {
        float[][] fArray2 = new float[this.col][2];
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = this.pen.createStroke();
        if (basicStroke == null) {
            return;
        }
        graphics2D.setStroke(this.pen.createStroke());
        ChartColorPattern chartColorPattern = null;
        for (int i = 0; i < this.row; ++i) {
            if (this.seriesPattern[i] == null) continue;
            chartColorPattern = this.seriesPattern[i] instanceof ChartColorPattern ? (ChartColorPattern)this.seriesPattern[i] : (this.seriesPattern[i] instanceof ChartTexturePattern ? ((ChartTexturePattern)this.seriesPattern[i]).getForeground() : (this.seriesPattern[i] instanceof ChartGradientPattern ? ((ChartGradientPattern)this.seriesPattern[i]).getStartColor() : new ChartColorPattern()));
            this.pen.setPenColor(chartColorPattern);
            graphics2D.setColor(chartColorPattern.getColor());
            int n = 0;
            this.curve.col = this.col;
            for (int j = 0; j < this.col; ++j) {
                int n2;
                float[][] fArray3;
                if (j == this.col - 1 && n != this.col - 1 && ((Chart2DDataSet)this.dataset).getX(i, j) != null && ((Chart2DDataSet)this.dataset).getY(i, j) != null) {
                    fArray3 = new float[n + 1][2];
                    fArray3[n][0] = this.tScatters[this.col * i + this.col - 1][0];
                    fArray3[n][1] = this.tScatters[this.col * i + this.col - 1][1];
                    for (n2 = 0; n2 < n; ++n2) {
                        fArray3[n2][0] = fArray2[n2][0];
                        fArray3[n2][1] = fArray2[n2][1];
                    }
                    this.curve.drawCurve(graphics2D, fArray3);
                    continue;
                }
                if (((Chart2DDataSet)this.dataset).getX(i, j) == null || ((Chart2DDataSet)this.dataset).getY(i, j) == null) {
                    if (n > 1) {
                        fArray3 = new float[n][2];
                        for (n2 = 0; n2 < n; ++n2) {
                            fArray3[n2][0] = fArray2[n2][0];
                            fArray3[n2][1] = fArray2[n2][1];
                        }
                        this.curve.drawCurve(graphics2D, fArray3);
                    }
                    fArray2 = new float[this.col][2];
                    n = 0;
                    continue;
                }
                fArray2[n][0] = this.tScatters[this.col * i + j][0];
                fArray2[n][1] = this.tScatters[this.col * i + j][1];
                if (n == this.col - 1) {
                    this.curve.drawCurve(graphics2D, fArray2);
                }
                ++n;
            }
        }
        graphics2D.setStroke(stroke);
    }

    public void drawLine(Graphics2D graphics2D, int n) {
        ChartColorPattern chartColorPattern = null;
        chartColorPattern = this.seriesPattern[n] instanceof ChartColorPattern ? (ChartColorPattern)this.seriesPattern[n] : (this.seriesPattern[n] instanceof ChartTexturePattern ? ((ChartTexturePattern)this.seriesPattern[n]).getForeground() : (this.seriesPattern[n] instanceof ChartGradientPattern ? ((ChartGradientPattern)this.seriesPattern[n]).getStartColor() : new ChartColorPattern()));
        this.pen.setPenColor(chartColorPattern);
        this.pen.draw(graphics2D, this.seriesShapes[n]);
    }

    public void drawScatterN(Graphics2D graphics2D, int n, int n2) {
        int n3 = this.style;
        if (this.createStroke != null && this.createStroke.length != 0) {
            n3 = this.paper.formatLineNode(this.style, this.createStroke[n % this.createStroke.length]);
        }
        if (((Chart2DDataSet)this.dataset).getX(n, n2) != null && ((Chart2DDataSet)this.dataset).getY(n, n2) != null) {
            this.lineNode.setPenStyle(this.objectProperties.getLineNodePen());
            this.lineNode.setFillPattern(this.seriesPattern[n]);
            this.lineNode.drawNode(graphics2D, (int)this.tScatters[n * this.col + n2][0], (int)this.tScatters[n * this.col + n2][1], n3, this.objectProperties.getLineNodeWidth(), this.objectProperties.getLineNodeHeight());
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.draw[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.itemShapes[n][n2];
    }

    @Override
    public Shape[][] getItemShapes() {
        return this.itemShapes;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (!this.itemShapes[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.drawCurve[i][j];
            }
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.draw.length; ++i) {
            if (!this.draw[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public String[] hintLabelShowCategoryAndSeries(int n, int n2, int n3, Number number) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = new String[n];
        stringBuffer.append(this.paper.model.getCategoryNmae() + ": ");
        stringBuffer.append(this.dataset.getFormatedHintCategoryValue(this.paper.model.getCategoryName(n3), n3));
        stringArray[0] = stringBuffer.toString();
        stringBuffer.setLength(0);
        if (this.paper.model.getSeriesN() != null) {
            stringBuffer.append(this.paper.model.getSeriesN() + ": ");
            stringBuffer.append(this.dataset.getFormatedHintSeriesValue(this.paper.model.getSeriesName(n2 % this.paper.model.getSeriesNames().size()), n2 % this.paper.model.getSeriesNames().size()));
            stringArray[1] = stringBuffer.toString();
            stringBuffer.setLength(0);
        } else {
            stringArray[1] = "";
            stringBuffer.setLength(0);
        }
        if (number != null) {
            this.value[n2 * this.col + n3][0] = number.floatValue();
            stringBuffer.append("X: ");
            stringBuffer.append(this.dataset.getFormatedHintValue(number));
            stringArray[2] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        if ((number = ((Chart2DDataSet)this.dataset).getY(n2, n3)) != null) {
            this.value[n2 * this.col + n3][1] = number.floatValue();
            stringBuffer.append("Y: ");
            stringBuffer.append(this.dataset.getFormatedHintValue(number));
            stringArray[3] = stringBuffer.toString();
            stringBuffer.setLength(0);
        }
        return stringArray;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (!this.itemShapes[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

