/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartCoordinatePaper;
import chart.ChartObject;
import chart.ChartPlatform;
import chart.GridLine;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart3d.Chart3DAxes;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DWalls;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.chart3d.Graph3DAreaA;
import chart.chart3d.Graph3DAreaP;
import chart.chart3d.Graph3DAreaSt;
import chart.chart3d.Graph3DBarA;
import chart.chart3d.Graph3DBarP;
import chart.chart3d.Graph3DBarSi;
import chart.chart3d.Graph3DBarSt;
import chart.chart3d.Graph3DLineA;
import chart.chart3d.Graph3DSurface;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartDataUsedInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartGraphicsUtil;
import chart.properties.ChartCoordinatePaperProperties;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class Chart3DPaper
extends ChartCoordinatePaper {
    public static final int ROTATION = 0;
    public static final int RESIZING = 1;
    private int IsLabelFontAutomaticOrientation = 0;
    ChartPlatform platform;
    public ChartDataSetModel model;
    List datasets;
    ChartAxis axisX;
    ChartAxis axisY;
    ChartAxis axisZ;
    GridLine gridX;
    GridLine gridY;
    GridLine gridZ;
    int marginTop;
    int marginLeft;
    int marginRight;
    int marginBottom;
    private Chart3DWalls SEDU;
    private Chart3DAxes abs;
    private Chart3DObject[] add;
    private ChartCompass adjustDistance;
    public ChartMatrix m1 = new ChartMatrix();
    public ChartMatrix m2 = new ChartMatrix();
    public ChartMatrix rm = new ChartMatrix();
    float[] unit = new float[3];
    float[] len = new float[3];
    int shownFace;
    private boolean after = false;
    private boolean before = true;
    float[] origin = new float[3];
    private float[] benchmarkmirror = new float[3];
    private float[] calculateGraphArea = new float[3];
    private int calculatePercentMinMaxPercentOfCategory = 10;
    private float contains;
    private float custommerConstant;
    private float drawSelectedShape;
    private int[] floatValue = new int[2];
    private int get;
    private int getAixsLabelStep = -1;
    private int getAutoOritention = -1;
    private String getAxisAreaPath;
    private String getAxisInfo;
    private int[] getAxisShapes;
    private Rectangle getAxisWithTickLength;
    int[] constantIndex;

    public Chart3DPaper(ChartPlatform chartPlatform) {
        this.platform = chartPlatform;
    }

    public Chart3DPaper(ChartPlatform chartPlatform, ChartCoordinatePaperProperties chartCoordinatePaperProperties) {
        this.platform = chartPlatform;
        this.properties = chartCoordinatePaperProperties;
    }

    @Override
    public void init() {
        this.setBackground(this.properties.getBackground());
        this.model = this.platform.getDataSetModel();
        this.datasets = this.model.getChartDataSets();
        if (this.datasets.size() > 1) {
            // empty if block
        }
        ChartDataSet chartDataSet = (ChartDataSet)this.datasets.get(0);
        this.get = chartDataSet.getChartDataSetInfo().getChartType();
        this.floatValue[0] = ChartTypeInfo.getPrimType(this.get);
        this.floatValue[1] = ChartTypeInfo.getSubType(this.get);
        this.IsLabelFontAutomaticOrientation();
        if (this.floatValue[0] != 4) {
            this.custommerConstant = (float)((ChartNumericAxis)this.axisY).getMin();
            this.drawSelectedShape = (float)((ChartNumericAxis)this.axisY).getMax();
        }
        this.add = new Chart3DObject[1];
        this.add[0] = this.abs(chartDataSet);
        this.setConstantFilterName();
    }

    public void doLayout() {
        this.locate();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.background = this.properties.getBackground();
        super.paint(graphics2D);
        this.transform();
        if (this.SEDU != null) {
            this.SEDU.paint(graphics2D);
            this.abs.paintGridLines(graphics2D);
        }
        for (int i = 0; i < this.add.length; ++i) {
            this.add[i].paint(graphics2D);
        }
        if (this.floatValue[0] != 4) {
            this.abs.paint(graphics2D);
        }
        this.adjustDistance(graphics2D);
        super.paintBorder(graphics2D);
    }

    private void IsLabelFontAutomaticOrientation() {
        Vector<Object[]> vector;
        Object object;
        ChartDataSet chartDataSet = (ChartDataSet)this.datasets.get(0);
        int n = chartDataSet.getChartDataSetInfo().getChartType();
        boolean bl = false;
        switch (ChartTypeInfo.getPrimType(n)) {
            case 4: {
                this.axisX = null;
                this.axisY = null;
                this.axisZ = null;
                this.SEDU = null;
                break;
            }
            default: {
                if (!(!this.model.isOneGroup() || this.floatValue[0] != 0 && this.floatValue[0] != 1 && this.floatValue[0] != 3 || this.floatValue[1] != 0 && this.floatValue[1] != 256 && this.floatValue[1] != 512)) {
                    object = this.model.getCategoryNames();
                    vector = null;
                } else if (this.floatValue[1] == 0 || this.floatValue[1] == 256 || this.floatValue[1] == 512) {
                    object = this.model.getCategoryNames();
                    vector = this.model.getSeriesNames();
                } else {
                    object = this.model.getCategoryNames();
                    vector = this.model.getSeriesNames();
                }
                this.axisX = new ChartCategoryAxis(this.properties.getAxisXProperties(), (List)object);
                this.axisX.setType("x1");
                this.axisX.setAxisPosition(5);
                this.gridX = new GridLine();
                this.gridX.setType("x1");
                this.gridX.setAxis(this.axisX);
                bl = this.properties.getAxisYProperties().getIsShowPercent();
                if (this.floatValue[0] == 7) {
                    bl = false;
                }
                if (!bl) {
                    this.axisY = new ChartNumericAxis(this.properties.getAxisYProperties(), chartDataSet.getMin(), chartDataSet.getMax());
                } else {
                    double d = ((Chart1DDataSet)chartDataSet).calculatePercentMinMaxPercentOfCategory()[0];
                    double d2 = ((Chart1DDataSet)chartDataSet).calculatePercentMinMaxPercentOfCategory()[1];
                    this.axisY = new ChartNumericAxis(this.properties.getAxisYProperties(), d, d2);
                }
                this.axisY.setType("y1");
                this.axisY.setAxisPosition(5);
                this.gridY = new GridLine();
                this.gridY.setType("y1");
                this.gridY.setAxis(this.axisY);
                if (ChartTypeInfo.getSubType(n) != 256 && !bl) {
                    ((ChartNumericAxis)this.axisY).setAutoExpand(true);
                    ((ChartNumericAxis)this.axisY).setIntegerIncrement(chartDataSet.isIntegerData());
                }
                this.axisZ = new ChartCategoryAxis(this.properties.getAxisZProperties(), vector);
                this.axisZ.setType("z");
                this.gridZ = new GridLine();
                this.gridZ.setType("z");
                this.axisZ.setAxisPosition(5);
                this.gridZ.setAxis(this.axisZ);
                this.axisX.setShow(this.properties.isShowAxisX());
                this.axisY.setShow(this.properties.isShowAxisY());
                this.axisZ.setShow(this.properties.isShowAxisZ());
                this.SEDU = new Chart3DWalls(this);
                this.SEDU.init();
                this.abs = new Chart3DAxes(this);
                this.abs.init();
            }
        }
        if (this.axisX != null) {
            this.axisX.setFilter(this.model.getCategoryFilter());
            this.axisX.setUseCustommerConstant(this.isCustommerConstantAxis(true));
            object = new float[2];
            object[0] = 0.0f;
            object[1] = 1.0f;
            this.axisX.setScrollInfo((float[])object);
            this.axisX.init();
        }
        if (this.axisZ != null) {
            this.axisZ.setFilter(this.model.getSeriesFilter());
            this.axisZ.init();
        }
        if (this.axisY != null) {
            boolean bl2 = false;
            if (chartDataSet.getDataFilter() != null && chartDataSet.getDataFilter().usedFormat()) {
                bl2 = true;
            }
            if (!bl2 && bl) {
                vector = new Vector<Object[]>();
                String string = "10.00%";
                ChartDataFilter chartDataFilter = new ChartDataFilter();
                Object[] objectArray = new Object[]{new Integer(Integer.valueOf(string.substring(0, 1))), string.substring(1)};
                vector.add(objectArray);
                chartDataFilter.setFilters(vector);
                this.axisY.setFilter(chartDataFilter);
            } else {
                this.axisY.setFilter(chartDataSet.getDataFilter());
            }
            this.axisY.init();
        }
        if (this.floatValue[0] == 2 || this.floatValue[0] == 3 || this.floatValue[0] == 7) {
            ((ChartCategoryAxis)this.axisX).setIsLineUnit(true);
        }
        if (ChartTypeInfo.getPrimType(n) == 7) {
            ((ChartCategoryAxis)this.axisZ).setIsLineUnit(true);
        }
    }

    public void calculateGraphArea() {
        ChartAxis chartAxis = null;
        ChartAxis chartAxis2 = null;
        Rectangle rectangle = super.getBounds();
        Rectangle rectangle2 = super.getCoreArea();
        this.marginTop = rectangle2.y;
        this.marginLeft = rectangle2.x;
        this.marginRight = rectangle.width - rectangle2.x - rectangle2.width;
        this.marginBottom = rectangle.height - rectangle2.y - rectangle2.height;
        ChartDataSet chartDataSet = (ChartDataSet)this.datasets.get(0);
        int n = chartDataSet.getChartDataSetInfo().getChartType();
        if (ChartTypeInfo.getPrimType(n) == 1) {
            chartAxis = this.axisY;
            chartAxis2 = this.axisX;
        } else {
            chartAxis = this.axisX;
            chartAxis2 = this.axisY;
        }
        if (chartAxis2 != null && chartAxis2.isShow()) {
            this.marginLeft += chartAxis2.getAxisWithTickLength();
            this.marginLeft += chartAxis2.getMaxDimensionOfLabelsFor3D().width;
        }
        if (chartAxis != null && chartAxis.isShow()) {
            this.marginBottom += chartAxis.getAxisWithTickLength();
            this.marginBottom += chartAxis.getMaxDimensionOfLabelsFor3D().height;
        }
        this.marginBottom = this.marginBottom < rectangle.height - 10 ? this.marginBottom : rectangle.height - 10;
        this.marginLeft = this.marginLeft < rectangle.width / 2 ? this.marginLeft : rectangle.width / 2;
        this.marginTop += 10;
        this.marginRight += this.marginLeft;
        this.getAxisWithTickLength = new Rectangle(this.marginLeft, this.marginTop, rectangle.width - this.marginLeft - this.marginRight, rectangle.height - this.marginTop - this.marginBottom);
    }

    @Override
    public void locate() {
        this.calculateGraphArea();
        this.rm.reset(this.properties.getRotationMatrix());
        this.calculateGraphArea[0] = this.properties.getScaleX() * 0.86f;
        this.calculateGraphArea[1] = this.properties.getScaleY() * 0.86f;
        this.calculateGraphArea[2] = this.properties.getScaleZ() * 0.86f;
        this.calculatePercentMinMaxPercentOfCategory = this.properties.getPerspective();
        float f = super.getBounds().width;
        float f2 = super.getBounds().height;
        if (this.floatValue[0] == 1) {
            this.before = false;
            this.len[0] = (int)(f2 - (float)(2 * this.marginBottom));
            this.len[1] = (int)(f - (float)this.marginLeft);
        } else {
            this.before = true;
            this.len[0] = (int)(f - (float)(2 * this.marginLeft));
            this.len[1] = (int)(f2 - (float)this.marginBottom);
        }
        if (this.len[0] < 0.0f) {
            this.len[0] = 0.0f;
        }
        if (this.len[1] < 0.0f) {
            this.len[1] = 0.0f;
        }
        if (this.floatValue[0] != 4 && !this.axisX.custommerConstant()) {
            this.unit[0] = this.axisX.getUnit(this.len[0]);
        } else if (this.axisX.custommerConstant()) {
            float[] fArray2 = new float[]{0.0f, 1.0f};
            this.axisX.setScrollInfo(fArray2);
            this.unit[0] = this.axisX.getTickmarkUnit(this.len[0]);
        }
        if (this.axisX.getProperties().IsLabelFontAutomaticOrientation()) {
            if (this.axisX.getAutoOritention(this.unit[0])) {
                this.axisX.setLabelAutoRotate(true);
            } else {
                this.axisX.getProperties().getLabelTextStyle().setRotation(0.0);
            }
            this.calculateGraphArea();
            if (this.floatValue[0] == 1) {
                this.len[0] = (int)(f2 - (float)(2 * this.marginBottom));
                this.len[1] = (int)(f - (float)this.marginLeft);
            } else {
                this.len[0] = (int)(f - (float)(2 * this.marginLeft));
                this.len[1] = (int)(f2 - (float)this.marginBottom);
            }
        } else {
            this.calculateGraphArea();
            if (this.floatValue[0] == 1) {
                this.len[0] = (int)(f2 - (float)(2 * this.marginBottom));
                this.len[1] = (int)(f - (float)this.marginLeft);
            } else {
                this.len[0] = (int)(f - (float)(2 * this.marginLeft));
                this.len[1] = (int)(f2 - (float)this.marginBottom);
            }
        }
        if (this.floatValue[0] != 4 && this.axisX.custommerConstant()) {
            this.axisX.setLength(this.len[0]);
            this.axisX.setTickSkipNum();
        }
        this.len[2] = this.floatValue[1] == 768 && !this.model.isOneGroup() ? (this.len[1] < this.len[0] ? (this.len[1] * 1.5f > this.len[0] ? this.len[0] : this.len[1] * 1.5f) : (this.len[0] * 1.5f > this.len[1] ? this.len[1] : this.len[0] * 1.5f)) : this.len[0] * 2.0f / 5.0f;
        if (this.floatValue[0] != 4) {
            this.unit[2] = this.axisZ.getUnit(this.len[2]);
        }
        if (this.axisX.getProperties().getLabelTextStyle().getWordWrapper() || this.axisZ.getProperties().getLabelTextStyle().getWordWrapper()) {
            if (this.floatValue[0] != 1) {
                this.axisX.setUnitWidth((int)((double)this.unit[0] * 0.8));
                this.axisZ.setUnitWidth((int)((double)this.unit[2] * 0.8));
            }
            this.calculateGraphArea();
        }
        this.benchmarkmirror[0] = this.len[0] / 2.0f;
        this.benchmarkmirror[2] = this.len[2] / 2.0f;
        this.benchmarkmirror[1] = (this.len[1] - (float)this.marginBottom) / 2.0f;
        this.origin[0] = f / 2.0f;
        this.origin[1] = f2 / 2.0f;
        if (this.floatValue[0] != 4) {
            this.unit[1] = this.axisY.getUnit(this.len[1]);
            this.contains = -((float)((ChartNumericAxis)this.axisY).getMin() * this.unit[1]);
        }
        if (this.SEDU != null) {
            this.SEDU();
            this.SEDU.locate();
            this.abs.locate();
            this.after = false;
        }
        for (int i = 0; i < this.add.length; ++i) {
            this.add[i].init();
            this.add[i].locate();
        }
    }

    private void SEDU() {
        this.adjustDistance = new ChartCompass(this.benchmarkmirror[0], this.benchmarkmirror[1], this.benchmarkmirror[2], this.get);
    }

    public void transform() {
        if (this.after || this.adjustDistance == null) {
            return;
        }
        if (this.floatValue[0] != 4) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5 = 0.0f;
            float f6 = 0.0f;
            if (this.floatValue[0] == 2) {
                f4 = this.origin[0] + this.benchmarkmirror[0];
                f3 = this.origin[0] - this.benchmarkmirror[0];
                f2 = this.origin[1] + this.benchmarkmirror[1];
                f = this.origin[1] - this.benchmarkmirror[1];
                this.calculatePercentMinMaxPercentOfCategory = this.calculatePercentMinMaxPercentOfCategory < 1 ? 9 : this.calculatePercentMinMaxPercentOfCategory;
            } else {
                f4 = this.origin[0] + this.benchmarkmirror[1];
                f3 = this.origin[0] - this.benchmarkmirror[1];
                f2 = this.origin[1] + this.benchmarkmirror[0];
                f = this.origin[1] - this.benchmarkmirror[0];
                this.calculatePercentMinMaxPercentOfCategory = this.calculatePercentMinMaxPercentOfCategory < 1 ? 9 : this.calculatePercentMinMaxPercentOfCategory;
            }
            do {
                this.m2.unit();
                this.m2.setVisualEffect(this.origin[0], this.origin[1], Math.min(this.origin[0], this.origin[1]) * (float)this.calculatePercentMinMaxPercentOfCategory);
                this.m2.shift(-this.benchmarkmirror[0], -this.benchmarkmirror[1], -this.benchmarkmirror[2]);
                this.m2.mul(this.rm);
                this.m2.scale(this.calculateGraphArea[0], this.calculateGraphArea[1], this.calculateGraphArea[2]);
                if (this.before) {
                    this.m1.mirror();
                } else {
                    this.m1.benchmarkmirror();
                }
                this.m1.shift(this.origin[0], this.origin[1], this.origin[2] - f5);
                this.m2.mul(this.m1);
                this.adjustDistance.transform(this.m2);
                f6 = this.adjustDistance.adjustDistance(f4, f3, f2, f);
                f5 += f6;
            } while (f6 > 1.0f);
            if (this.SEDU != null) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 3;
                this.SEDU.transform(this.m2);
                n3 = this.adjustDistance.shownFace(this.SEDU.getWalls().tVertex, 0);
                for (int i = 0; i < 3; ++i) {
                    if ((n3 >> i * 2 & 1) != 1) {
                        n2 = i * 2;
                    }
                    if ((n3 >> i * 2 + 1 & 1) != 1) {
                        n2 = i * 2 + 1;
                    } else if (i * 2 + 1 == n4) continue;
                    n |= 1 << n2;
                }
                this.shownFace = n;
            }
            if (this.abs != null) {
                this.abs.transform(this.m2);
            }
            if (this.add != null && this.add[0] != null) {
                this.add[0].transform(this.m2);
            }
        }
        this.after = true;
    }

    private Chart3DObject abs(ChartDataSet chartDataSet) {
        Chart3DObject chart3DObject = null;
        switch (this.floatValue[0]) {
            case 0: {
                switch (this.floatValue[1]) {
                    case 0: {
                        chart3DObject = new Graph3DBarSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DBarP(chartDataSet, this);
                        break;
                    }
                    case 512: {
                        chart3DObject = new Graph3DBarSi(chartDataSet, this);
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DBarA(chartDataSet, this);
                    }
                }
                break;
            }
            case 1: {
                switch (this.floatValue[1]) {
                    case 0: {
                        chart3DObject = new Graph3DBarSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DBarP(chartDataSet, this);
                        break;
                    }
                    case 512: {
                        chart3DObject = new Graph3DBarSi(chartDataSet, this);
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DBarA(chartDataSet, this);
                    }
                }
                break;
            }
            case 2: {
                switch (this.floatValue[1]) {
                    case 0: {
                        break;
                    }
                    case 256: {
                        break;
                    }
                    case 512: {
                        break;
                    }
                    case 768: {
                        chart3DObject = new Graph3DLineA(chartDataSet, this);
                    }
                }
                break;
            }
            case 3: {
                switch (this.floatValue[1]) {
                    case 768: {
                        chart3DObject = new Graph3DAreaA(chartDataSet, this);
                        break;
                    }
                    case 0: {
                        chart3DObject = new Graph3DAreaSt(chartDataSet, this);
                        break;
                    }
                    case 256: {
                        chart3DObject = new Graph3DAreaP(chartDataSet, this);
                    }
                }
                break;
            }
            case 7: {
                chart3DObject = new Graph3DSurface(chartDataSet, this);
            }
        }
        return chart3DObject;
    }

    public ChartCompass getCompass() {
        return this.adjustDistance;
    }

    public float availableLength(float f) {
        if (f < this.custommerConstant * this.unit[1]) {
            return 0.0f;
        }
        if (f > this.drawSelectedShape * this.unit[1]) {
            return this.len[1];
        }
        return f + this.contains;
    }

    public float availableOriginY(float f) {
        if (f < this.custommerConstant * this.unit[1]) {
            return 0.0f;
        }
        if (f > (this.drawSelectedShape - this.custommerConstant) * this.unit[1]) {
            return this.len[1];
        }
        return f;
    }

    public float availableValue(float f) {
        f = f < this.custommerConstant ? this.custommerConstant : (f > this.drawSelectedShape ? this.drawSelectedShape : f);
        return f;
    }

    public float[] getUnit() {
        return this.unit;
    }

    public float[] getLength() {
        return this.len;
    }

    public int getShownFace() {
        return this.shownFace;
    }

    public float[] getOrigin() {
        return this.origin;
    }

    public void setOriginY(float f) {
        this.contains = f;
    }

    public float getOriginY() {
        return this.contains;
    }

    public void setMode(int n) {
        this.IsLabelFontAutomaticOrientation = n;
    }

    public int getMode() {
        return this.IsLabelFontAutomaticOrientation;
    }

    public int[] getIntType() {
        return this.floatValue;
    }

    public int getChartType() {
        return this.get;
    }

    public void setYUnit(float f) {
        this.unit[1] = f;
    }

    public Chart3DWalls getWalls() {
        return this.SEDU;
    }

    public ChartPlatform getChartPlatform() {
        return this.platform;
    }

    public ChartDataSetInfo[] getDataSetInfos() {
        return this.model.getDatasetInfos();
    }

    @Override
    public ChartNumericAxis getAxisY1() {
        return (ChartNumericAxis)this.axisY;
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        return this.add[n].getItemShapes(n);
    }

    @Override
    public void setXDimValue(Vector vector) {
        ((ChartCategoryAxis)this.axisX).setDimValue(vector);
    }

    @Override
    public void setZDimValue(Vector vector) {
        ((ChartCategoryAxis)this.axisZ).setDimValue(vector);
    }

    @Override
    public String[] getXLabels() {
        return ((ChartCategoryAxis)this.axisX).getLabelsForHtml();
    }

    @Override
    public String[] getZLabels() {
        return ((ChartCategoryAxis)this.axisZ).getLabelsForHtml();
    }

    @Override
    public Shape[] getAxisXShapes() {
        return this.axisX.getAxisShapes();
    }

    @Override
    public int getAxisXLabelStep() {
        if (this.axisX == null) {
            return 1;
        }
        return this.axisX.getAixsLabelStep();
    }

    @Override
    public Shape[] getAxisZShapes() {
        return this.axisZ.getAxisShapes();
    }

    @Override
    public String[] getHintValue(int n, int n2) {
        this.getAixsLabelStep = n;
        this.getAutoOritention = n2;
        String[] stringArray = null;
        this.getAxisShapes = null;
        if (this.add != null && this.add[0] != null && this.properties.isShowTips()) {
            stringArray = this.add[0].search(n, n2);
            this.getAxisShapes = this.add[0].drilldown;
            if (stringArray != null) {
                return stringArray;
            }
        }
        stringArray = new String[]{this.add(n, n2)};
        return stringArray;
    }

    private String add(int n, int n2) {
        String string;
        if (this.axisX != null) {
            string = this.axisX.searchAxisLabel(n, n2);
            if (string != null) {
                this.getAxisAreaPath = string;
                if (this.axisX.isShowLabelTips()) {
                    return string;
                }
            } else {
                this.getAxisAreaPath = null;
            }
        }
        if (this.axisZ != null) {
            string = this.axisZ.searchAxisLabel(n, n2);
            if (string != null) {
                this.getAxisInfo = string;
                if (this.axisZ.isShowLabelTips()) {
                    return string;
                }
            } else {
                this.getAxisInfo = null;
            }
        }
        if (this.axisY != null && (string = this.axisY.searchAxisLabel(n, n2)) != null && this.axisY.isShowLabelTips()) {
            return string;
        }
        return null;
    }

    @Override
    public String getXDim() {
        return this.getAxisAreaPath;
    }

    @Override
    public String getZDim() {
        return this.getAxisInfo;
    }

    @Override
    public int[] getDrilldown() {
        return this.getAxisShapes;
    }

    @Override
    public String[] getDrilldownGroup() {
        String[] stringArray = new String[2];
        if (this.getAxisShapes != null) {
            if (this.model.isTurnedXZ()) {
                stringArray[0] = null;
                stringArray[1] = this.model.getSeriesName(this.getAxisShapes[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.getAxisShapes[0] % this.model.getSeriesCount()).toString());
            } else {
                stringArray[0] = this.model.getSeriesName(this.getAxisShapes[0] % this.model.getSeriesCount()) == null ? null : this.model.mapRowName(this.model.getSeriesName(this.getAxisShapes[0] % this.model.getSeriesCount()).toString());
                stringArray[1] = this.model.getCategoryName(this.getAxisShapes[1]) == null ? null : this.model.getCategoryName(this.getAxisShapes[1]).toString();
            }
        }
        return stringArray;
    }

    protected Chart3DAxes getAxes() {
        return this.abs;
    }

    public float[] getWordWrapUnit() {
        float[] fArray2 = new float[]{Math.abs(this.unit[0] * 0.8f), Math.abs(this.unit[2] * 0.8f)};
        return fArray2;
    }

    @Override
    public ChartObject getChartObject(int n, int n2) {
        this.selectedSeriesIndex = -1;
        if (this.getBounds().contains(n, n2)) {
            this.searchSelectedSeriesIndex(n -= this.getBounds().x, n2 -= this.getBounds().y);
            if (this.axisX != null && this.axisX.searchSelectedAxis(n, n2)) {
                return this.axisX;
            }
            if (this.axisY != null && this.axisY.searchSelectedAxis(n, n2)) {
                return this.axisY;
            }
            if (this.axisZ != null && this.axisZ.searchSelectedAxis(n, n2)) {
                return this.axisZ;
            }
            if (this.selectedSeriesIndex != -1) {
                return this.add[0];
            }
            if (this.abs != null && this.abs.searchSelectedGridX(n, n2)) {
                return this.gridX;
            }
            if (this.abs != null && this.abs.searchSelectedGridY(n, n2)) {
                return this.gridY;
            }
            if (this.abs != null && this.abs.searchSelectedGridZ(n, n2)) {
                return this.gridZ;
            }
            if (this.SEDU != null && this.SEDU.searchSelectedWallXY(n, n2)) {
                this.SEDU.getWallXY().setType("xy");
                return this.SEDU.getWallXY();
            }
            if (this.SEDU != null && this.SEDU.searchSelectedWallYZ(n, n2)) {
                this.SEDU.getWallYZ().setType("yz");
                return this.SEDU.getWallYZ();
            }
            if (this.SEDU != null && this.SEDU.searchSelectedWallFloor(n, n2)) {
                this.SEDU.getWallFloor().setType("floor");
                return this.SEDU.getWallFloor();
            }
            return this;
        }
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public void searchSelectedSeriesIndex(int n, int n2) {
        this.selectedSeriesIndex = -1;
        if (this.add[0] != null) {
            this.add[0].search(n, n2);
            this.selectedSeriesIndex = this.add[0].selectedSeriesIndex;
        }
    }

    public String getSelectShowValue(int n, int n2) {
        if (this.selectedSeriesIndex == -1) {
            this.searchSelectedSeriesIndex(n, n2);
        }
        if (this.model.getValuesName() != null && this.selectedSeriesIndex != -1) {
            return this.model.getValuesName()[0];
        }
        return null;
    }

    public String[] getSelectOrignShowValue(int n, int n2) {
        if (this.selectedSeriesIndex == -1) {
            this.searchSelectedSeriesIndex(n, n2);
        }
        if (this.model.getValuesName() != null && this.selectedSeriesIndex != -1) {
            return this.model.getOrignValuesName(0);
        }
        return null;
    }

    public void seTransformed(boolean bl) {
        this.after = bl;
    }

    private void adjustDistance(Graphics2D graphics2D) {
        if (this.axisX != null && this.axisX.getStatus() == 1) {
            Line2D line2D = this.axisX.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.axisY != null && this.axisY.getStatus() == 1) {
            Line2D line2D = this.axisY.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.axisZ != null && this.axisZ.getStatus() == 1) {
            Line2D line2D = this.axisZ.getAxisAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, line2D);
            return;
        }
        if (this.gridX != null && this.selectedSeriesIndex != -1 && this.gridX.getStatus() == 1) {
            GeneralPath generalPath = this.abs.getGridXAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.gridY != null && this.selectedSeriesIndex == -1 && this.gridY.getStatus() == 1) {
            GeneralPath generalPath = this.abs.getGridYAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.gridZ != null && this.selectedSeriesIndex == -1 && this.gridZ.getStatus() == 1) {
            GeneralPath generalPath = this.abs.getGridZAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.SEDU.getWallXY() != null && this.SEDU.getWallXY().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.SEDU.getWallXYAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.SEDU.getWallYZ() != null && this.SEDU.getWallYZ().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.SEDU.getWallYZAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
        if (this.SEDU.getWallFloor() != null && this.SEDU.getWallFloor().getStatus() == 1 && this.selectedSeriesIndex == -1) {
            GeneralPath generalPath = (GeneralPath)this.SEDU.getWallFloorAreaPath();
            ChartGraphicsUtil.drawSelectedShape(graphics2D, generalPath);
            return;
        }
    }

    @Override
    public Vector getChartObjects() {
        Vector<ChartObject> vector = new Vector<ChartObject>();
        vector.add(this);
        if (this.axisX != null) {
            this.axisX.setType("x1");
            vector.add(this.axisX);
        }
        if (this.axisY != null) {
            this.axisY.setType("y1");
            vector.add(this.axisY);
        }
        if (this.axisZ != null && this.floatValue[1] == 768) {
            this.axisZ.setType("z");
            vector.add(this.axisZ);
        }
        if (this.axisX != null && this.gridX != null) {
            this.gridX.setType("x1");
            this.gridX.setAxis(this.axisX);
            vector.add(this.gridX);
        }
        if (this.axisY != null && this.gridY != null) {
            this.gridY.setType("y1");
            this.gridY.setAxis(this.axisY);
            vector.add(this.gridY);
        }
        if (this.axisZ != null && this.gridZ != null && this.floatValue[1] == 768) {
            this.gridZ.setType("z");
            this.gridZ.setAxis(this.axisZ);
            vector.add(this.gridZ);
        }
        if (this.SEDU != null && this.SEDU.getWallXY() != null) {
            this.SEDU.getWallXY().setType("xy");
            vector.add(this.SEDU.getWallXY());
        }
        if (this.SEDU != null && this.SEDU.getWallFloor() != null) {
            this.SEDU.getWallFloor().setType("floor");
            vector.add(this.SEDU.getWallFloor());
        }
        if (this.SEDU != null && this.SEDU.getWallYZ() != null) {
            this.SEDU.getWallYZ().setType("yz");
            vector.add(this.SEDU.getWallYZ());
        }
        return vector;
    }

    @Override
    public Rectangle getGraphArea() {
        return this.getAxisWithTickLength;
    }

    @Override
    public Shape[] getAxisY2Shapes() {
        return null;
    }

    @Override
    public Shape[] getAxisYShapes() {
        if (this.axisY == null) {
            return null;
        }
        return this.axisY.getAxisShapes();
    }

    @Override
    public String[] getY2Labels() {
        return null;
    }

    @Override
    public String[] getYLabels() {
        if (this.axisY == null) {
            return null;
        }
        return ((ChartNumericAxis)this.axisY).getLabelsForHtml();
    }

    public float getMaxAxisValue() {
        return this.drawSelectedShape;
    }

    public float getMinAxisValue() {
        return this.custommerConstant;
    }

    @Override
    public ChartAxis getAxisX1() {
        return this.axisX;
    }

    protected boolean isCustommerConstantAxis(boolean bl) {
        boolean bl2 = false;
        if (this.datasets != null && this.datasets.size() >= 1) {
            for (int i = 0; i < this.datasets.size(); ++i) {
                ChartDataSet chartDataSet = (ChartDataSet)this.datasets.get(i);
                if (bl && chartDataSet.getChartDataSetInfo().getAxisInfo() != 0 || !bl && chartDataSet.getChartDataSetInfo().getAxisInfo() != 1) continue;
                int n = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
                int n2 = ChartTypeInfo.getSubType(chartDataSet.getChartDataSetInfo().getChartType());
                int n3 = ChartTypeInfo.getEffect(chartDataSet.getChartDataSetInfo().getChartType());
                if ((n == 0 || n == 1 || n == 2 || n == 3) && n3 == 4096) {
                    if (n == 0 || n == 1) {
                        bl2 = true;
                        continue;
                    }
                    if (n == 2 && n2 == 768) {
                        bl2 = true;
                        continue;
                    }
                    if (n != 3) continue;
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                break;
            }
        }
        return bl2;
    }

    void setConstantFilterName() {
        if (this.axisX != null && this.axisX.getConstantStartEnd() != null) {
            Object[] objectArray = this.axisX.getConstantStartEnd();
            List list = this.getChartPlatform().getDataSetModel().getCategoryNames();
            int n = list.size();
            if (objectArray[0] instanceof Number) {
                Object e;
                int n2;
                this.constantIndex = new int[]{-1, -1};
                for (n2 = 0; n2 < list.size(); ++n2) {
                    e = list.get(n2);
                    if (!(e instanceof Number) || !(((Number)e).floatValue() >= ((Number)objectArray[0]).floatValue())) continue;
                    this.constantIndex[0] = n2;
                    break;
                }
                this.constantIndex[1] = this.constantIndex[0];
                for (n2 = n - 1; n2 >= 0; --n2) {
                    e = list.get(n2);
                    if (!(e instanceof Number) || !(((Number)e).floatValue() <= ((Number)objectArray[1]).floatValue())) continue;
                    this.constantIndex[1] = n2;
                    break;
                }
            } else if (objectArray[0] instanceof Date) {
                Object e;
                int n3;
                this.constantIndex = new int[]{-1, -1};
                for (n3 = 0; n3 < list.size(); ++n3) {
                    e = list.get(n3);
                    if (!(e instanceof Date) || ((Date)e).before((Date)objectArray[0])) continue;
                    this.constantIndex[0] = n3;
                    break;
                }
                this.constantIndex[1] = this.constantIndex[0];
                for (n3 = n - 1; n3 >= 0; --n3) {
                    e = list.get(n3);
                    if (!(e instanceof Date) || ((Date)e).after((Date)objectArray[1])) continue;
                    this.constantIndex[1] = n3;
                    break;
                }
            }
            if (this.constantIndex != null && (this.constantIndex[0] == -1 || this.constantIndex[1] == -1)) {
                this.constantIndex = null;
            }
        }
    }

    @Override
    public int[] getFilterConstant() {
        return this.constantIndex;
    }

    public ChartAxis getAxisZ() {
        return this.axisZ;
    }

    @Override
    public int[] getLinkInfo(int n, int n2) {
        this.getAixsLabelStep = n;
        this.getAutoOritention = n2;
        int[] nArray = null;
        if (this.add != null && this.add[0] != null && this.properties.isShowTips() && (nArray = this.add[0].searchLinkInfo(n, n2)) != null) {
            return nArray;
        }
        int n3 = -1;
        n3 = this.after(true, n, n2);
        if (n3 != -1 && this.platform.getShowValueConditions() != null && this.platform.getShowValueConditions().getXLink() != null) {
            nArray = ((ChartDataUsedInfo)this.platform.getShowValueConditions().getXLink().get(n3)).getChartLinkInfo();
            return nArray;
        }
        n3 = this.after(false, n, n2);
        if (n3 != -1 && this.platform.getShowValueConditions() != null && this.platform.getShowValueConditions().getZLink() != null) {
            nArray = ((ChartDataUsedInfo)this.platform.getShowValueConditions().getZLink().get(n3)).getChartLinkInfo();
            return nArray;
        }
        return nArray;
    }

    private int after(boolean bl, int n, int n2) {
        int n3 = -1;
        if (bl) {
            if (this.axisX != null) {
                n3 = this.axisX.searchAxisLabelIndex(n, n2);
            }
        } else if (this.axisZ != null) {
            n3 = this.axisZ.searchAxisLabelIndex(n, n2);
        }
        return n3;
    }
}

