/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartShowValueCondition;
import chart.ChartShowValueSubCondition;
import chart.chart3d.ChartBlock;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;

public class Chart3DStrip
extends ChartBlock {
    ChartPenStyle pen;
    ChartFillPattern pattern;
    int shownFaces;
    boolean contour = true;
    int[] x = new int[4];
    int[] y = new int[4];
    Point2D.Float[] points = new Point2D.Float[4];
    GeneralPath path = new GeneralPath();
    int[] number = new int[3];
    GeneralPath path1 = new GeneralPath();
    Color[] thresholdColorS;
    Color thresholdColor;
    float transparent;
    GeneralPath toHtml = new GeneralPath();
    private float SEDU;
    private float add;
    private float addElement;
    private float addVertex;
    private float append;
    private float closePath;
    private ChartShowValueCondition draw;
    private float[] drawArea1;
    private float drawB;
    private float drawSelectedShape;
    private int fill;
    private int get;
    private int getCondition;
    private int getConditionType;
    private int getEndValue;
    private int getFillColor;
    private boolean getOtherColor;
    GeneralPath selectedPath = new GeneralPath();

    public Chart3DStrip() {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = new Point2D.Float();
        }
        this.pattern = new ChartColorPattern("Red");
        this.pen = new ChartPenStyle("Solid Line");
    }

    public Chart3DStrip(ChartFillPattern chartFillPattern, boolean bl, ChartPenStyle chartPenStyle) {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = new Point2D.Float();
        }
        this.pattern = chartFillPattern;
        this.contour = bl;
        this.pen = chartPenStyle;
    }

    public Chart3DStrip(boolean bl, ChartPenStyle chartPenStyle) {
        for (int i = 0; i < 4; ++i) {
            this.points[i] = new Point2D.Float();
        }
        this.contour = bl;
        this.pen = chartPenStyle;
    }

    public void drawLine(Graphics2D graphics2D, int n) {
        for (int i = 0; i < 6; ++i) {
            if ((n >> i & 1) != 1) continue;
            int n2 = 0;
            this.path.reset();
            switch (i) {
                case 0: {
                    this.points[0].x = this.tVertex[++n2][0];
                    this.points[0].y = this.tVertex[n2++][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2][1];
                    this.points[2].x = this.tVertex[n2 += 4][0];
                    this.points[2].y = this.tVertex[n2--][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 1: {
                    this.points[0].x = this.tVertex[n2][0];
                    this.points[0].y = this.tVertex[n2][1];
                    this.points[1].x = this.tVertex[n2 += 3][0];
                    this.points[1].y = this.tVertex[n2][1];
                    this.points[2].x = this.tVertex[n2 += 4][0];
                    this.points[2].y = this.tVertex[n2][1];
                    this.points[3].x = this.tVertex[n2 -= 3][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 2: {
                    this.points[0].x = this.tVertex[n2 += 4][0];
                    this.points[0].y = this.tVertex[n2++][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2++][1];
                    this.points[2].x = this.tVertex[n2][0];
                    this.points[2].y = this.tVertex[n2++][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 3: {
                    this.points[0].x = this.tVertex[n2][0];
                    this.points[0].y = this.tVertex[n2++][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2++][1];
                    this.points[2].x = this.tVertex[n2][0];
                    this.points[2].y = this.tVertex[n2++][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 4: {
                    this.points[0].x = this.tVertex[n2 += 3][0];
                    this.points[0].y = this.tVertex[n2--][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2][1];
                    this.points[2].x = this.tVertex[n2 += 4][0];
                    this.points[2].y = this.tVertex[n2++][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 5: {
                    this.points[0].x = this.tVertex[n2][0];
                    this.points[0].y = this.tVertex[n2++][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2][1];
                    this.points[2].x = this.tVertex[n2 += 4][0];
                    this.points[2].y = this.tVertex[n2--][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                }
            }
            this.path.moveTo(this.points[0].x, this.points[0].y);
            this.path.lineTo(this.points[1].x, this.points[1].y);
            this.path.lineTo(this.points[2].x, this.points[2].y);
            this.path.lineTo(this.points[3].x, this.points[3].y);
            this.path.lineTo(this.points[0].x, this.points[0].y);
            if (this.pattern != null) {
                this.pattern.fill(graphics2D, this.path);
            }
            if (this.contour) {
                this.pen.draw(graphics2D, this.path);
            }
            if (!this.getOtherColor) continue;
            ChartGraphicsUtil.drawSelectedShape(graphics2D, this.path);
        }
    }

    public void draw1(Graphics2D graphics2D, int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < this.number[2]; ++n2) {
            graphics2D.setColor(ChartColorPattern.transparent(this.thresholdColorS[n2], this.transparent));
            this.drawArea1(graphics2D, (this.number[1] + 1) * 4 + (n2 + 1) * 4);
        }
        for (n2 = 0; n2 < this.number[1]; ++n2) {
            this.drawB(graphics2D, n, bl, n2 * 4);
            graphics2D.setColor(ChartColorPattern.transparent(this.thresholdColorS[this.number[2] + n2], this.transparent));
            this.drawArea1(graphics2D, (this.number[1] + 1) * 4 + (n2 + 1 + this.number[2]) * 4);
        }
        this.drawB(graphics2D, n, bl, 4 * this.number[1]);
        if (0 < this.number[0] - this.number[1] - this.number[2]) {
            for (n2 = 0; n2 < this.number[0] - this.number[1] - this.number[2]; ++n2) {
                graphics2D.setColor(ChartColorPattern.transparent(this.thresholdColorS[this.number[1] + this.number[2] + n2], this.transparent));
                this.drawArea1(graphics2D, (2 * this.number[1] + 2 + n2 + this.number[2]) * 4);
            }
        }
    }

    public void draw2(Graphics2D graphics2D, int n, boolean bl) {
        int n2;
        if (0 < this.number[0] - this.number[1] - this.number[2]) {
            for (n2 = this.number[0] - this.number[1] - this.number[2] - 1; n2 >= 0; --n2) {
                graphics2D.setColor(ChartColorPattern.transparent(this.thresholdColorS[n2 + this.number[1] + this.number[2]], this.transparent));
                this.drawArea1(graphics2D, (2 * this.number[1] + 2 + n2 + this.number[2]) * 4);
            }
        }
        this.drawB(graphics2D, n, bl, 4 * this.number[1]);
        for (n2 = this.number[1] - 1; n2 >= 0; --n2) {
            graphics2D.setColor(ChartColorPattern.transparent(this.thresholdColorS[this.number[2] + n2], this.transparent));
            this.drawArea1(graphics2D, (this.number[1] + 1) * 4 + (n2 + 1 + this.number[2]) * 4);
            this.drawB(graphics2D, n, bl, n2 * 4);
        }
        for (n2 = this.number[2] - 1; n2 >= 0; --n2) {
            graphics2D.setColor(ChartColorPattern.transparent(this.thresholdColorS[n2], this.transparent));
            this.drawArea1(graphics2D, (this.number[1] + 1) * 4 + (n2 + 1) * 4);
        }
    }

    public void drawArea(Graphics2D graphics2D, int n) {
        int n2 = n;
        if (this.thresholdColor != null) {
            graphics2D.setColor(ChartColorPattern.transparent(this.thresholdColor, this.transparent));
        }
        this.points[0].x = this.tVertex[n2][0];
        this.points[0].y = this.tVertex[n2++][1];
        this.points[1].x = this.tVertex[n2][0];
        this.points[1].y = this.tVertex[n2++][1];
        this.points[2].x = this.tVertex[n2][0];
        this.points[2].y = this.tVertex[n2++][1];
        this.points[3].x = this.tVertex[n2][0];
        this.points[3].y = this.tVertex[n2][1];
        this.path1.reset();
        this.path1.moveTo(this.points[0].x, this.points[0].y);
        this.path1.lineTo(this.points[1].x, this.points[1].y);
        this.path1.lineTo(this.points[2].x, this.points[2].y);
        this.path1.lineTo(this.points[3].x, this.points[3].y);
        this.path1.lineTo(this.points[0].x, this.points[0].y);
        graphics2D.fill(this.path1);
    }

    public void drawArea1(Graphics2D graphics2D, int n) {
        int n2 = n;
        this.points[0].x = this.tVertex[n2][0];
        this.points[0].y = this.tVertex[n2++][1];
        this.points[1].x = this.tVertex[n2][0];
        this.points[1].y = this.tVertex[n2++][1];
        this.points[2].x = this.tVertex[n2][0];
        this.points[2].y = this.tVertex[n2++][1];
        this.points[3].x = this.tVertex[n2][0];
        this.points[3].y = this.tVertex[n2][1];
        this.path1.reset();
        this.path1.moveTo(this.points[0].x, this.points[0].y);
        this.path1.lineTo(this.points[1].x, this.points[1].y);
        this.path1.lineTo(this.points[2].x, this.points[2].y);
        this.path1.lineTo(this.points[3].x, this.points[3].y);
        this.path1.lineTo(this.points[0].x, this.points[0].y);
        graphics2D.fill(this.path1);
    }

    public void drawB(Graphics2D graphics2D, int n, boolean bl, int n2) {
        for (int i = 0; i < 6; ++i) {
            if ((n >> i & 1) != 1) continue;
            int n3 = n2;
            this.path.reset();
            switch (i) {
                case 0: {
                    this.points[0].x = this.tVertex[++n3][0];
                    this.points[0].y = this.tVertex[n3++][1];
                    this.points[1].x = this.tVertex[n3][0];
                    this.points[1].y = this.tVertex[n3][1];
                    this.points[2].x = this.tVertex[n3 += 4][0];
                    this.points[2].y = this.tVertex[n3--][1];
                    this.points[3].x = this.tVertex[n3][0];
                    this.points[3].y = this.tVertex[n3][1];
                    break;
                }
                case 1: {
                    this.points[0].x = this.tVertex[n3][0];
                    this.points[0].y = this.tVertex[n3][1];
                    this.points[1].x = this.tVertex[n3 += 3][0];
                    this.points[1].y = this.tVertex[n3][1];
                    this.points[2].x = this.tVertex[n3 += 4][0];
                    this.points[2].y = this.tVertex[n3][1];
                    this.points[3].x = this.tVertex[n3 -= 3][0];
                    this.points[3].y = this.tVertex[n3][1];
                    break;
                }
                case 2: {
                    this.points[0].x = this.tVertex[n3 += 4][0];
                    this.points[0].y = this.tVertex[n3++][1];
                    this.points[1].x = this.tVertex[n3][0];
                    this.points[1].y = this.tVertex[n3++][1];
                    this.points[2].x = this.tVertex[n3][0];
                    this.points[2].y = this.tVertex[n3++][1];
                    this.points[3].x = this.tVertex[n3][0];
                    this.points[3].y = this.tVertex[n3][1];
                    break;
                }
                case 3: {
                    this.points[0].x = this.tVertex[n3][0];
                    this.points[0].y = this.tVertex[n3++][1];
                    this.points[1].x = this.tVertex[n3][0];
                    this.points[1].y = this.tVertex[n3++][1];
                    this.points[2].x = this.tVertex[n3][0];
                    this.points[2].y = this.tVertex[n3++][1];
                    this.points[3].x = this.tVertex[n3][0];
                    this.points[3].y = this.tVertex[n3][1];
                    break;
                }
                case 4: {
                    this.points[0].x = this.tVertex[n3 += 3][0];
                    this.points[0].y = this.tVertex[n3--][1];
                    this.points[1].x = this.tVertex[n3][0];
                    this.points[1].y = this.tVertex[n3][1];
                    this.points[2].x = this.tVertex[n3 += 4][0];
                    this.points[2].y = this.tVertex[n3++][1];
                    this.points[3].x = this.tVertex[n3][0];
                    this.points[3].y = this.tVertex[n3][1];
                    break;
                }
                case 5: {
                    this.points[0].x = this.tVertex[n3][0];
                    this.points[0].y = this.tVertex[n3++][1];
                    this.points[1].x = this.tVertex[n3][0];
                    this.points[1].y = this.tVertex[n3][1];
                    this.points[2].x = this.tVertex[n3 += 4][0];
                    this.points[2].y = this.tVertex[n3--][1];
                    this.points[3].x = this.tVertex[n3][0];
                    this.points[3].y = this.tVertex[n3][1];
                }
            }
            this.path.moveTo(this.points[0].x, this.points[0].y);
            this.path.lineTo(this.points[1].x, this.points[1].y);
            this.path.lineTo(this.points[2].x, this.points[2].y);
            this.path.lineTo(this.points[3].x, this.points[3].y);
            this.path.lineTo(this.points[0].x, this.points[0].y);
            if (this.pattern != null) {
                this.pattern.fill(graphics2D, this.path);
            }
            if (bl) {
                this.pen.draw(graphics2D, this.path);
            }
            if (!this.getOtherColor) continue;
            ChartGraphicsUtil.drawSelectedShape(graphics2D, this.path);
        }
    }

    public Vector stripToHtml(int n, int n2, Point point, int n3) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer(24);
        for (n = 0; n < 6; ++n) {
            if ((n3 >> n & 1) != 1) continue;
            n2 = 0;
            switch (n) {
                case 0: {
                    this.points[0].x = this.tVertex[++n2][0];
                    this.points[0].y = this.tVertex[n2++][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2][1];
                    this.points[2].x = this.tVertex[n2 += 4][0];
                    this.points[2].y = this.tVertex[n2--][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 1: {
                    this.points[0].x = this.tVertex[n2][0];
                    this.points[0].y = this.tVertex[n2][1];
                    this.points[1].x = this.tVertex[n2 += 3][0];
                    this.points[1].y = this.tVertex[n2][1];
                    this.points[2].x = this.tVertex[n2 += 4][0];
                    this.points[2].y = this.tVertex[n2][1];
                    this.points[3].x = this.tVertex[n2 -= 3][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 2: {
                    this.points[0].x = this.tVertex[n2 += 4][0];
                    this.points[0].y = this.tVertex[n2++][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2++][1];
                    this.points[2].x = this.tVertex[n2][0];
                    this.points[2].y = this.tVertex[n2++][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 3: {
                    this.points[0].x = this.tVertex[n2][0];
                    this.points[0].y = this.tVertex[n2++][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2++][1];
                    this.points[2].x = this.tVertex[n2][0];
                    this.points[2].y = this.tVertex[n2++][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 4: {
                    this.points[0].x = this.tVertex[n2 += 3][0];
                    this.points[0].y = this.tVertex[n2--][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2][1];
                    this.points[2].x = this.tVertex[n2 += 4][0];
                    this.points[2].y = this.tVertex[n2++][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                    break;
                }
                case 5: {
                    this.points[0].x = this.tVertex[n2][0];
                    this.points[0].y = this.tVertex[n2++][1];
                    this.points[1].x = this.tVertex[n2][0];
                    this.points[1].y = this.tVertex[n2][1];
                    this.points[2].x = this.tVertex[n2 += 4][0];
                    this.points[2].y = this.tVertex[n2--][1];
                    this.points[3].x = this.tVertex[n2][0];
                    this.points[3].y = this.tVertex[n2][1];
                }
            }
            int n4 = 5;
            this.x[0] = (int)this.points[0].x - n4;
            this.y[0] = (int)this.points[0].y + n4;
            this.x[1] = (int)this.points[1].x + n4;
            this.y[1] = (int)this.points[1].y - n4;
            this.x[2] = (int)this.points[2].x + n4;
            this.y[2] = (int)this.points[2].y - n4;
            this.x[3] = (int)this.points[3].x - n4;
            this.y[3] = (int)this.points[3].y + n4;
            for (int i = 0; i < 4; ++i) {
                stringBuffer.append(this.x[i] + point.x).append(',').append(this.y[i] + point.y).append(',');
            }
            stringBuffer.append(this.x[0] + point.x).append(',').append(this.y[0] + point.y);
            vector.addElement(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        return vector;
    }

    public void drawAreaSurface(Graphics2D graphics2D, boolean bl) {
        this.path.reset();
        this.path.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.path.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
        this.path.lineTo(this.tVertex[2][0], this.tVertex[2][1]);
        this.path.lineTo(this.tVertex[3][0], this.tVertex[3][1]);
        this.path.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
        int n = 0;
        if (this.draw != null) {
            n = this.draw.getConditionType();
        }
        if (n == 2) {
            float f = Math.max(this.SEDU, this.add);
            float f2 = Math.min(this.SEDU, this.add);
            float[][] fArray2 = new float[4][2];
            if (this.SEDU <= this.add && this.SEDU >= 0.0f || this.SEDU <= 0.0f && this.SEDU <= this.add) {
                fArray2[0][0] = this.tVertex[3][0];
                fArray2[0][1] = this.tVertex[3][1];
                fArray2[1][0] = this.tVertex[0][0];
                fArray2[1][1] = this.tVertex[0][1];
                fArray2[2][0] = this.tVertex[1][0];
                fArray2[2][1] = this.tVertex[1][1];
                fArray2[3][0] = this.tVertex[2][0];
                fArray2[3][1] = this.tVertex[2][1];
            } else {
                fArray2[0][0] = this.tVertex[2][0];
                fArray2[0][1] = this.tVertex[2][1];
                fArray2[1][0] = this.tVertex[1][0];
                fArray2[1][1] = this.tVertex[1][1];
                fArray2[2][0] = this.tVertex[0][0];
                fArray2[2][1] = this.tVertex[0][1];
                fArray2[3][0] = this.tVertex[3][0];
                fArray2[3][1] = this.tVertex[3][1];
            }
            if (this.SEDU != this.add) {
                this.SEDU(graphics2D, this.draw, fArray2, f, f2, this.path);
            } else if (this.SEDU == f2) {
                this.addElement(graphics2D, this.draw, this.path, false);
            } else {
                this.addElement(graphics2D, this.draw, this.path, true);
            }
        } else if (this.pattern != null) {
            this.pattern.fill(graphics2D, this.path);
        }
        if (bl) {
            this.pen.draw(graphics2D, this.path);
        }
        this.selectedPath.reset();
        this.selectedPath.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.selectedPath.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
        this.selectedPath.lineTo(this.tVertex[2][0], this.tVertex[2][1]);
        this.selectedPath.lineTo(this.tVertex[3][0], this.tVertex[3][1]);
        this.selectedPath.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
    }

    public void fillSurface(Graphics2D graphics2D) {
        int n = this.tVertex.length;
        if (n <= 1) {
            return;
        }
        this.path.reset();
        this.path.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        for (int i = 1; i < n; ++i) {
            this.path.lineTo(this.tVertex[i][0], this.tVertex[i][1]);
        }
        this.path.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.path.closePath();
        if (this.pattern != null) {
            this.pattern.fill(graphics2D, this.path);
        }
    }

    public void drawSurfaceGrid(Graphics2D graphics2D) {
        int n = this.tVertex.length;
        if (n <= 1) {
            return;
        }
        if (this.contour) {
            if (n == 3) {
                this.path.reset();
                this.path.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
                this.path.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
                this.pen.draw(graphics2D, this.path);
            } else {
                this.path.reset();
                this.path.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
                this.path.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
                this.pen.draw(graphics2D, this.path);
            }
        }
    }

    public void drawSurfaceContour(Graphics2D graphics2D) {
        this.path.reset();
        this.path.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.path.lineTo(this.tVertex[2][0], this.tVertex[2][1]);
        this.path.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
        this.pen.draw(graphics2D, this.path);
    }

    public Area areaSurface() {
        this.path.reset();
        this.path.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        this.path.lineTo(this.tVertex[1][0], this.tVertex[1][1]);
        this.path.lineTo(this.tVertex[2][0], this.tVertex[2][1]);
        this.path.lineTo(this.tVertex[3][0], this.tVertex[3][1]);
        this.path.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
        return new Area(this.path);
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.pen = chartPenStyle;
    }

    public ChartPenStyle getPen() {
        return this.pen;
    }

    public void setPattern(ChartFillPattern chartFillPattern) {
        this.pattern = chartFillPattern;
    }

    public ChartFillPattern getPattern() {
        return this.pattern;
    }

    public void setShownFaces(int n) {
        this.shownFaces = n;
    }

    public int getShownFaces() {
        return this.shownFaces;
    }

    public void setLineVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.vertex = new float[8][3];
        this.tVertex = new float[8][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f4, f5, f6 + f8);
        this.addVertex(f, f2, f3 + f8);
        this.addVertex(f, f2 + f7, f3);
        this.addVertex(f4, f5 + f7, f6);
        this.addVertex(f4, f5 + f7, f6 + f8);
        this.addVertex(f, f2 + f7, f3 + f8);
    }

    public void setAreaSurfaceVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this.vertex = new float[4][3];
        this.tVertex = new float[4][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f4, f5, f6 + f7);
        this.addVertex(f, f2, f3 + f7);
    }

    public void setSurfaceVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.vertex = new float[3][3];
        this.tVertex = new float[3][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f7, f8, f9);
    }

    public void setSurfaceVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this.vertex = new float[4][3];
        this.tVertex = new float[4][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f7, f8, f9);
        this.addVertex(f10, f11, f12);
    }

    public void setSurfaceVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        this.vertex = new float[5][3];
        this.tVertex = new float[5][2];
        this.addVertex(f, f2, f3);
        this.addVertex(f4, f5, f6);
        this.addVertex(f7, f8, f9);
        this.addVertex(f10, f11, f12);
        this.addVertex(f13, f14, f15);
    }

    public void setLineVertex1(float f, float f2, float f3, float f4, float f5, float f6) {
        this.addVertex(f, f2, f3);
        this.addVertex(f + f6, f2 + f4, f3);
        this.addVertex(f + f6, f2 + f4, f3 + f5);
        this.addVertex(f, f2, f3 + f5);
    }

    public void setLineVertexForArea(float f, float f2, float f3, float f4, float f5, float f6) {
        this.addVertex(f, f2, f3);
        this.addVertex(f + f6, f4, f3);
        this.addVertex(f + f6, f4, f3 + f5);
        this.addVertex(f, f2, f3 + f5);
    }

    public void setK(int[] nArray) {
        this.number = nArray;
    }

    public void setThresholdColor(Color[] colorArray, float f) {
        this.thresholdColorS = new Color[colorArray.length];
        this.thresholdColorS = colorArray;
        this.transparent = f;
    }

    public void setThresholdColor(Color color, float f) {
        this.thresholdColor = color;
        this.transparent = f;
    }

    public Shape surfaceToHtml() {
        this.toHtml.reset();
        this.toHtml.moveTo(this.tVertex[0][0], this.tVertex[0][1]);
        for (int i = 1; i < this.tVertex.length; ++i) {
            this.toHtml.lineTo(this.tVertex[i][0], this.tVertex[i][1]);
        }
        this.toHtml.lineTo(this.tVertex[0][0], this.tVertex[0][1]);
        return this.toHtml;
    }

    public Shape toHtml() {
        this.getConditionType = 0;
        this.getEndValue = 0;
        this.getFillColor = 0;
        this.fill = 4;
        this.get = 4;
        this.getCondition = 4;
        for (int i = 0; i < 4; ++i) {
            this.getConditionType = this.tVertex[i][0] <= this.tVertex[this.getConditionType][0] ? i : this.getConditionType;
            this.getEndValue = this.tVertex[i][0] >= this.tVertex[this.getEndValue][0] ? i : this.getEndValue;
            this.getFillColor = this.tVertex[i][1] <= this.tVertex[this.getFillColor][1] ? i : this.getFillColor;
            this.fill = this.tVertex[i + 4][0] <= this.tVertex[this.fill][0] ? i + 4 : this.fill;
            this.get = this.tVertex[i + 4][0] >= this.tVertex[this.get][0] ? i + 4 : this.get;
            this.getCondition = this.tVertex[i + 4][1] >= this.tVertex[this.getCondition][1] ? i + 4 : this.getCondition;
        }
        this.toHtml.reset();
        this.toHtml.moveTo(this.tVertex[this.getConditionType][0], this.tVertex[this.getConditionType][1]);
        this.toHtml.lineTo(this.tVertex[this.fill][0], this.tVertex[this.fill][1]);
        this.toHtml.lineTo(this.tVertex[this.getCondition][0], this.tVertex[this.getCondition][1]);
        this.toHtml.lineTo(this.tVertex[this.get][0], this.tVertex[this.get][1]);
        this.toHtml.lineTo(this.tVertex[this.getEndValue][0], this.tVertex[this.getEndValue][1]);
        this.toHtml.lineTo(this.tVertex[this.getFillColor][0], this.tVertex[this.getFillColor][1]);
        this.toHtml.lineTo(this.tVertex[this.getConditionType][0], this.tVertex[this.getConditionType][1]);
        return this.toHtml;
    }

    public void setSelectedStatus(boolean bl) {
        this.getOtherColor = bl;
    }

    public void drawSelectedOutLine(Graphics2D graphics2D) {
        ChartGraphicsUtil.drawSelectedShape(graphics2D, this.selectedPath);
    }

    private void SEDU(Graphics2D graphics2D, ChartShowValueCondition chartShowValueCondition, float[][] fArray2, float f, float f2, GeneralPath generalPath) {
        int n = chartShowValueCondition.getSubConditons().size();
        Area area = new Area();
        area.add(new Area(generalPath));
        for (int i = 0; i < n; ++i) {
            Shape shape = this.add(fArray2, f2, f, chartShowValueCondition.getCondition(i).getStartValue(), chartShowValueCondition.getCondition(i).getEndValue());
            if (shape == null) continue;
            chartShowValueCondition.getCondition(i).getFillColor().fill(graphics2D, shape);
            area.subtract(new Area(shape));
        }
        if (area != null) {
            chartShowValueCondition.getOtherColor().fill(graphics2D, area);
        }
    }

    private Shape add(float[][] fArray2, float f, float f2, float f3, float f4) {
        float f5;
        float[][] fArray3 = new float[4][2];
        GeneralPath generalPath = new GeneralPath();
        boolean bl = false;
        if (f > f3) {
            if (f > f4) {
                return null;
            }
            f5 = f;
        } else {
            if (f3 > f2) {
                return null;
            }
            f5 = f3;
        }
        if (!bl) {
            fArray3[0][0] = fArray2[0][0] + (fArray2[3][0] - fArray2[0][0]) * (f5 - f) / (f2 - f);
            fArray3[0][1] = fArray2[0][1] + (fArray2[3][1] - fArray2[0][1]) * (f5 - f) / (f2 - f);
            fArray3[1][0] = fArray2[1][0] + (fArray2[2][0] - fArray2[1][0]) * (f5 - f) / (f2 - f);
            fArray3[1][1] = fArray2[1][1] + (fArray2[2][1] - fArray2[1][1]) * (f5 - f) / (f2 - f);
        }
        float f6 = f2 >= f4 ? f4 : f2;
        if (!bl) {
            fArray3[2][0] = fArray2[1][0] + (fArray2[2][0] - fArray2[1][0]) * (f6 - f) / (f2 - f);
            fArray3[2][1] = fArray2[1][1] + (fArray2[2][1] - fArray2[1][1]) * (f6 - f) / (f2 - f);
            fArray3[3][0] = fArray2[0][0] + (fArray2[3][0] - fArray2[0][0]) * (f6 - f) / (f2 - f);
            fArray3[3][1] = fArray2[0][1] + (fArray2[3][1] - fArray2[0][1]) * (f6 - f) / (f2 - f);
        }
        generalPath.moveTo(fArray3[0][0], fArray3[0][1]);
        generalPath.lineTo(fArray3[1][0], fArray3[1][1]);
        generalPath.lineTo(fArray3[2][0], fArray3[2][1]);
        generalPath.lineTo(fArray3[3][0], fArray3[3][1]);
        generalPath.closePath();
        return generalPath;
    }

    public void setValueScope(float f, float f2, float f3, float f4, float f5, float[] fArray2) {
        this.SEDU = f2;
        this.addElement = f;
        this.add = f3;
        this.append = f4;
        this.closePath = f5;
        this.drawArea1 = fArray2;
    }

    public void setConditionalFill(ChartShowValueCondition chartShowValueCondition) {
        this.draw = chartShowValueCondition;
    }

    private void addElement(Graphics2D graphics2D, ChartShowValueCondition chartShowValueCondition, GeneralPath generalPath, boolean bl) {
        int n = chartShowValueCondition.getSubConditons().size();
        int n2 = -1;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = bl ? this.SEDU : this.addElement;
        for (int i = n - 1; i >= 0; --i) {
            f = ((ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(i)).getStartValue();
            f2 = ((ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(i)).getEndValue();
            if (!(f <= f3) || !(f3 <= f2)) continue;
            n2 = i;
            break;
        }
        if (n2 != -1) {
            ((ChartShowValueSubCondition)chartShowValueCondition.getSubConditons().get(n2)).getFillColor().fill(graphics2D, generalPath);
        } else {
            chartShowValueCondition.getOtherColor().fill(graphics2D, generalPath);
        }
    }

    public void setStartValue(float f) {
        this.drawB = f;
    }

    public void setEndValue(float f) {
        this.drawSelectedShape = f;
    }

    public float getStartValue() {
        return this.drawB;
    }

    public float getEndValue() {
        return this.drawSelectedShape;
    }
}

