/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

public class ChartMatrix {
    float xx = 1.0f;
    float xy;
    float xz;
    float xo;
    float yx;
    float yy = 1.0f;
    float yz;
    float yo;
    float zx;
    float zy;
    float zz = 1.0f;
    float zo;
    float xc;
    float yc;
    float zc;
    float hh = 1.0f;

    public void setVisualEffect(float f, float f2, float f3) {
        this.xc = f;
        this.yc = f2;
        this.zc = f3;
    }

    public void shift(float f, float f2, float f3) {
        this.xo += f;
        this.yo += f2;
        this.zo += f3;
    }

    public void scale(float f, float f2, float f3) {
        this.xx *= f;
        this.xy *= f;
        this.xz *= f;
        this.xo *= f;
        this.yx *= f2;
        this.yy *= f2;
        this.yz *= f2;
        this.yo *= f2;
        this.zx *= f3;
        this.zy *= f3;
        this.zz *= f3;
        this.zo *= f3;
    }

    public void yrot(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.xx * f + this.zx * f2;
        float f4 = this.xy * f + this.zy * f2;
        float f5 = this.xz * f + this.zz * f2;
        float f6 = this.xo * f + this.zo * f2;
        float f7 = this.zx * f - this.xx * f2;
        float f8 = this.zy * f - this.xy * f2;
        float f9 = this.zz * f - this.xz * f2;
        float f10 = this.zo * f - this.xo * f2;
        this.xo = f6;
        this.xx = f3;
        this.xy = f4;
        this.xz = f5;
        this.zo = f10;
        this.zx = f7;
        this.zy = f8;
        this.zz = f9;
    }

    public void _xrot(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.yx * f - this.zx * f2;
        float f4 = this.yy * f - this.zy * f2;
        float f5 = this.yz * f - this.zz * f2;
        float f6 = this.yo * f - this.zo * f2;
        float f7 = this.zx * f + this.yx * f2;
        float f8 = this.zy * f + this.yy * f2;
        float f9 = this.zz * f + this.yz * f2;
        float f10 = this.zo * f + this.yo * f2;
        this.yo = f6;
        this.yx = f3;
        this.yy = f4;
        this.yz = f5;
        this.zo = f10;
        this.zx = f7;
        this.zy = f8;
        this.zz = f9;
    }

    public void xrot(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.yx * f + this.zx * f2;
        float f4 = this.yy * f + this.zy * f2;
        float f5 = this.yz * f + this.zz * f2;
        float f6 = this.yo * f + this.zo * f2;
        float f7 = this.zx * f - this.yx * f2;
        float f8 = this.zy * f - this.yy * f2;
        float f9 = this.zz * f - this.yz * f2;
        float f10 = this.zo * f - this.yo * f2;
        this.yo = f6;
        this.yx = f3;
        this.yy = f4;
        this.yz = f5;
        this.zo = f10;
        this.zx = f7;
        this.zy = f8;
        this.zz = f9;
    }

    public void zrot(double d) {
        float f = (float)Math.cos(d *= Math.PI / 180);
        float f2 = (float)Math.sin(d);
        float f3 = this.yx * f + this.xx * f2;
        float f4 = this.yy * f + this.xy * f2;
        float f5 = this.yz * f + this.xz * f2;
        float f6 = this.yo * f + this.xo * f2;
        float f7 = this.xx * f - this.yx * f2;
        float f8 = this.xy * f - this.yy * f2;
        float f9 = this.xz * f - this.yz * f2;
        float f10 = this.xo * f - this.yo * f2;
        this.yo = f6;
        this.yx = f3;
        this.yy = f4;
        this.yz = f5;
        this.xo = f10;
        this.xx = f7;
        this.xy = f8;
        this.xz = f9;
    }

    public void mul(ChartMatrix chartMatrix) {
        float f = this.xx * chartMatrix.xx + this.yx * chartMatrix.xy + this.zx * chartMatrix.xz;
        float f2 = this.xy * chartMatrix.xx + this.yy * chartMatrix.xy + this.zy * chartMatrix.xz;
        float f3 = this.xz * chartMatrix.xx + this.yz * chartMatrix.xy + this.zz * chartMatrix.xz;
        float f4 = this.xo * chartMatrix.xx + this.yo * chartMatrix.xy + this.zo * chartMatrix.xz + chartMatrix.xo;
        float f5 = this.xx * chartMatrix.yx + this.yx * chartMatrix.yy + this.zx * chartMatrix.yz;
        float f6 = this.xy * chartMatrix.yx + this.yy * chartMatrix.yy + this.zy * chartMatrix.yz;
        float f7 = this.xz * chartMatrix.yx + this.yz * chartMatrix.yy + this.zz * chartMatrix.yz;
        float f8 = this.xo * chartMatrix.yx + this.yo * chartMatrix.yy + this.zo * chartMatrix.yz + chartMatrix.yo;
        float f9 = this.xx * chartMatrix.zx + this.yx * chartMatrix.zy + this.zx * chartMatrix.zz;
        float f10 = this.xy * chartMatrix.zx + this.yy * chartMatrix.zy + this.zy * chartMatrix.zz;
        float f11 = this.xz * chartMatrix.zx + this.yz * chartMatrix.zy + this.zz * chartMatrix.zz;
        float f12 = this.xo * chartMatrix.zx + this.yo * chartMatrix.zy + this.zo * chartMatrix.zz + chartMatrix.zo;
        this.xx = f;
        this.xy = f2;
        this.xz = f3;
        this.xo = f4;
        this.yx = f5;
        this.yy = f6;
        this.yz = f7;
        this.yo = f8;
        this.zx = f9;
        this.zy = f10;
        this.zz = f11;
        this.zo = f12;
    }

    public void benchmarkmirror() {
        this.xx = 0.0f;
        this.xy = 1.0f;
        this.xz = 0.0f;
        this.xo = 0.0f;
        this.yx = -1.0f;
        this.yy = 0.0f;
        this.yz = 0.0f;
        this.yo = 0.0f;
        this.zx = 0.0f;
        this.zy = 0.0f;
        this.zz = -1.0f;
        this.zo = 0.0f;
    }

    public void mirror() {
        this.xo = 0.0f;
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xz = 0.0f;
        this.yo = 0.0f;
        this.yx = 0.0f;
        this.yy = -1.0f;
        this.yz = 0.0f;
        this.zo = 0.0f;
        this.zx = 0.0f;
        this.zy = 0.0f;
        this.zz = -1.0f;
    }

    public void unit() {
        this.xo = 0.0f;
        this.xx = 1.0f;
        this.xy = 0.0f;
        this.xz = 0.0f;
        this.yo = 0.0f;
        this.yx = 0.0f;
        this.yy = 1.0f;
        this.yz = 0.0f;
        this.zo = 0.0f;
        this.zx = 0.0f;
        this.zy = 0.0f;
        this.zz = 1.0f;
    }

    public void transform(float[][] fArray2, float[][] fArray3, int n) {
        for (int i = 0; i < n; ++i) {
            float f = fArray2[i][0] * this.xx + fArray2[i][1] * this.xy + fArray2[i][2] * this.xz + this.xo;
            float f2 = fArray2[i][0] * this.yx + fArray2[i][1] * this.yy + fArray2[i][2] * this.yz + this.yo;
            float f3 = fArray2[i][0] * this.zx + fArray2[i][1] * this.zy + fArray2[i][2] * this.zz + this.zo;
            fArray3[i][0] = f;
            fArray3[i][1] = f2;
            fArray3[i][0] = Math.round(f - (this.xc - f) * f3 / (this.zc - f3));
            fArray3[i][1] = Math.round(f2 - (this.yc - f2) * f3 / (this.zc - f3));
        }
    }

    public void transformNonePerspective(float[][] fArray2, float[][] fArray3, int n) {
        for (int i = 0; i < n; ++i) {
            float f = fArray2[i][0] * this.xx + fArray2[i][1] * this.xy + fArray2[i][2] * this.xz + this.xo;
            float f2 = fArray2[i][0] * this.yx + fArray2[i][1] * this.yy + fArray2[i][2] * this.yz + this.yo;
            fArray3[i][0] = f;
            fArray3[i][1] = f2;
        }
    }

    public void transform2(float[][] fArray2, float[][] fArray3, int n) {
        for (int i = 0; i < n; ++i) {
            float f = fArray2[i][0] * this.xx + fArray2[i][1] * this.xy + fArray2[i][2] * this.xz + this.xo;
            float f2 = fArray2[i][0] * this.yx + fArray2[i][1] * this.yy + fArray2[i][2] * this.yz + this.yo;
            float f3 = fArray2[i][0] * this.zx + fArray2[i][1] * this.zy + fArray2[i][2] * this.zz + this.zo;
            fArray3[i][0] = f;
            fArray3[i][1] = f2;
            fArray3[i][2] = f3;
            fArray3[i][2] = Math.round(f3);
        }
    }

    public void reset(float[] fArray2) {
        this.xx = fArray2[0];
        this.xy = fArray2[1];
        this.xz = fArray2[2];
        this.xo = fArray2[3];
        this.yx = fArray2[4];
        this.yy = fArray2[5];
        this.yz = fArray2[6];
        this.yo = fArray2[7];
        this.zx = fArray2[8];
        this.zy = fArray2[9];
        this.zz = fArray2[10];
        this.zo = fArray2[11];
    }

    public float[] getMatrix() {
        float[] fArray2 = new float[]{this.xx, this.xy, this.xz, this.xo, this.yx, this.yy, this.yz, this.yo, this.zx, this.zy, this.zz, this.zo};
        return fArray2;
    }

    public static float[] transform3(float[] fArray2, ChartMatrix chartMatrix) {
        float f = chartMatrix.xx;
        float f2 = chartMatrix.xy;
        float f3 = chartMatrix.xz;
        float f4 = chartMatrix.xo;
        float f5 = chartMatrix.yx;
        float f6 = chartMatrix.yy;
        float f7 = chartMatrix.yz;
        float f8 = chartMatrix.yo;
        float f9 = chartMatrix.zx;
        float f10 = chartMatrix.zy;
        float f11 = chartMatrix.zz;
        float f12 = chartMatrix.zo;
        float[] fArray3 = new float[3];
        float f13 = fArray2[0];
        float f14 = fArray2[1];
        float f15 = fArray2[2];
        fArray3[0] = f13 * f + f14 * f2 + f15 * f3 + f4;
        fArray3[1] = f13 * f5 + f14 * f6 + f15 * f7 + f8;
        fArray3[2] = f13 * f9 + f14 * f10 + f15 * f11 + f12;
        return fArray3;
    }

    public static float[] rotaionXYZ(double d, double d2, double d3, float[] fArray2) {
        float[] fArray3 = new float[3];
        double[] dArray = new double[]{-1.0 * (d *= Math.PI / 180), d2 *= Math.PI / 180, d3 *= Math.PI / 180};
        double d4 = Math.sin(dArray[0]) * Math.sin(dArray[1]) * Math.cos(dArray[2]) - Math.cos(dArray[0]) * Math.sin(dArray[2]);
        double d5 = Math.sin(dArray[0]) * Math.sin(dArray[1]) * Math.sin(dArray[2]) + Math.cos(dArray[0]) * Math.cos(dArray[2]);
        double d6 = Math.cos(dArray[0]) * Math.sin(dArray[1]) * Math.cos(dArray[2]) + Math.sin(dArray[0]) * Math.sin(dArray[2]);
        double d7 = Math.cos(dArray[0]) * Math.sin(dArray[1]) * Math.sin(dArray[2]) - Math.sin(dArray[0]) * Math.cos(dArray[2]);
        double d8 = Math.cos(dArray[1]) * Math.cos(dArray[2]);
        double d9 = Math.cos(dArray[1]) * Math.sin(dArray[2]);
        double d10 = Math.sin(dArray[0]) * Math.cos(dArray[1]);
        double d11 = Math.cos(dArray[0]) * Math.cos(dArray[1]);
        double d12 = -Math.sin(dArray[1]);
        float f = fArray2[0];
        float f2 = fArray2[1];
        float f3 = fArray2[2];
        fArray3[0] = (float)((double)f * d8 + (double)f2 * d4 + (double)f3 * d6);
        fArray3[1] = (float)((double)f * d9 + (double)f2 * d5 + (double)f3 * d7);
        fArray3[2] = (float)((double)f * d12 + (double)f2 * d10 + (double)f3 * d11);
        return fArray3;
    }

    public static double[] getAngle(ChartMatrix chartMatrix) {
        double[] dArray = new double[]{chartMatrix.zz != 0.0f ? -Math.atan(chartMatrix.zy / chartMatrix.zz) : -1.5707963267948966, Math.asin(-chartMatrix.zx), chartMatrix.xx != 0.0f ? Math.atan(chartMatrix.yx / chartMatrix.xx) : 1.5707963267948966};
        float[][] fArrayArray = new float[][]{{1.0f / (float)Math.sqrt(3.0), 1.0f / (float)Math.sqrt(3.0), 1.0f / (float)Math.sqrt(3.0)}, {1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}, {0.0f, -1.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}};
        float[][] fArray2 = new float[fArrayArray.length][3];
        fArray2[0] = ChartMatrix.transform3(fArrayArray[0], chartMatrix);
        double d = dArray[0] * 180.0 / Math.PI;
        double d2 = dArray[1] * 180.0 / Math.PI;
        double d3 = dArray[2] * 180.0 / Math.PI;
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    for (int i2 = 0; i2 < 2; ++i2) {
                        for (int i3 = 0; i3 < 2; ++i3) {
                            for (int i4 = 0; i4 < 2; ++i4) {
                                fArray3 = ChartMatrix.rotaionXYZ((double)(180 * i) + Math.pow(-1.0, i2) * d, (double)(180 * j) + Math.pow(-1.0, i3) * d2, (double)(180 * k) + Math.pow(-1.0, i4) * d3, fArrayArray[0]);
                                if (!((double)Math.abs(fArray3[0] - fArray2[0][0]) < 0.001) || !((double)Math.abs(fArray3[1] - fArray2[0][1]) < 0.001) || !((double)(180 * i) + Math.pow(-1.0, i2) * d >= 0.0) || !((double)(180 * j) + Math.pow(-1.0, i3) * d >= 0.0) || !((double)(180 * k) + Math.pow(-1.0, i4) * d >= 0.0)) continue;
                                dArray[0] = 360.0 - ((double)(180 * i) + Math.pow(-1.0, i2) * d) % 360.0;
                                dArray[1] = ((double)(180 * j) + Math.pow(-1.0, i3) * d2) % 360.0;
                                dArray[2] = ((double)(180 * k) + Math.pow(-1.0, i4) * d3) % 360.0;
                            }
                        }
                    }
                }
            }
        }
        return dArray;
    }
}

