/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartCategoryAxis;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.Chart3DStrip;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGraphicsUtil;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.List;

public class Graph3DAreaSt
extends Chart3DObject {
    int[] type;
    boolean[][] negative;
    protected Chart3DStrip[][] strip;
    protected Chart3DStrip[][] bottom;
    protected ChartFillPattern[] pattern;
    protected ChartCompass compass;
    int col;
    int row;
    boolean contour;
    private ChartPenStyle SEDU;
    GeneralPath path;
    protected boolean outerAscending;
    protected boolean innerAscending;
    protected boolean toUpAscending;
    float[] unit;
    Rectangle rect = new Rectangle();
    float[][] lineValues;
    protected Chart3DStrip[][][] areas;
    int numThreshold = 2;
    float[] thresholdV;
    int[][][] num;
    Color[] thresholdColorS;
    float transparent;
    protected Chart3DStrip[][] sideArea;

    Graph3DAreaSt(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.dataset = chartDataSet;
        this.type = chart3DPaper.getIntType();
        this.paper = chart3DPaper;
        this.col = chartDataSet.getCategorySize();
        this.row = chartDataSet.getSeriesSize();
        this.pattern = chart3DPaper.getChartPlatform().getFillPatternByArarry(0);
        this.transparent = chart3DPaper.getProperties().getGraphProperties().getThresholdFillTransparency();
    }

    @Override
    public void locate() {
    }

    @Override
    void transform(ChartMatrix chartMatrix) {
        int n;
        int n2;
        if (this.col < 2) {
            return;
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            if (this.strip[n2] == null) continue;
            for (n = 0; n < this.strip[n2].length; ++n) {
                this.strip[n2][n].transform(chartMatrix);
                this.bottom[n2][n].transform(chartMatrix);
            }
        }
        for (n2 = 0; n2 < this.col - 1; ++n2) {
            for (n = 0; n < this.numThreshold; ++n) {
                for (int i = 0; i < 3; ++i) {
                    this.areas[n2][n][i].transform(chartMatrix);
                }
            }
        }
        if (this.sideArea != null && this.sideArea.length > 0) {
            for (n2 = 0; n2 < this.numThreshold; ++n2) {
                for (n = 0; n < this.sideArea[n2].length; ++n) {
                    this.sideArea[n2][n].transform(chartMatrix);
                }
            }
        }
        this.SEDU();
    }

    @Override
    public void init() {
        float f;
        float f2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.path = new GeneralPath();
        this.contour = this.paper.getProperties().getGraphProperties().isContour();
        this.SEDU = this.properties.getGraphProperties().getContourPen();
        if (this.col < 2) {
            return;
        }
        this.setCompass(this.paper.getCompass());
        this.strip = new Chart3DStrip[this.row][this.col - 1];
        this.bottom = new Chart3DStrip[this.row][this.col - 1];
        this.areas = new Chart3DStrip[this.col - 1][this.numThreshold][3];
        this.num = new int[this.col - 1][this.numThreshold][4];
        this.unit = this.paper.getUnit();
        this.unit[2] = this.paper.getLength()[2] / 2.0f;
        float f3 = 30.0f;
        if (f3 > this.unit[2]) {
            f3 = this.unit[2];
        }
        float f4 = 0.0f;
        f4 = this.paper.getOriginY();
        float f5 = this.unit[0];
        float f6 = 0.0f;
        float f7 = this.unit[2] - f3 / 2.0f;
        this.lineValues = new float[this.row][this.col];
        this.negative = new boolean[this.row][];
        float[] fArray2 = new float[this.col];
        if (this.dataset.getChartDataSetModel().isOneGroupForBar()) {
            for (n5 = 0; n5 < this.col; ++n5) {
                for (int i = 0; i < this.col; ++i) {
                    fArray2[n5] = fArray2[n5] + (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i);
                }
                fArray2[n5] = fArray2[n5] == 0.0f ? 1.0f : fArray2[n5];
            }
        } else {
            for (n5 = 0; n5 < this.col; ++n5) {
                fArray2[n5] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n5);
            }
        }
        for (n4 = 0; n4 < this.row; ++n4) {
            for (n3 = 0; n3 < this.col; ++n3) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n4, n3);
                float f8 = number == null ? 0.0f : Math.abs(number.floatValue());
                this.lineValues[n4][n3] = f8;
            }
        }
        if (((ChartNumericAxisProperties)this.paper.axisY.getProperties()).getIsShowPercent()) {
            for (n4 = 0; n4 < this.row; ++n4) {
                for (n3 = 0; n3 < this.col; ++n3) {
                    this.lineValues[n4][n3] = this.lineValues[n4][n3] / fArray2[n3];
                }
            }
        }
        if (this.paper.getProperties().getGraphProperties().isShowThresholdLine() && this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.numThreshold = 2;
            this.thresholdV = new float[this.numThreshold];
            this.thresholdColorS = new Color[this.numThreshold];
            this.thresholdV[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.thresholdV[1] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.thresholdColorS[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
            this.thresholdColorS[1] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine()) {
            this.numThreshold = 1;
            this.thresholdV = new float[this.numThreshold];
            this.thresholdColorS = new Color[this.numThreshold];
            this.thresholdV[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.thresholdColorS[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.numThreshold = 1;
            this.thresholdV = new float[this.numThreshold];
            this.thresholdColorS = new Color[this.numThreshold];
            this.thresholdV[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.thresholdColorS[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else {
            this.numThreshold = 0;
            this.thresholdV = new float[this.numThreshold];
            this.thresholdColorS = new Color[this.numThreshold];
        }
        for (n4 = 0; n4 < this.numThreshold; ++n4) {
            float f9 = 0.0f;
            for (n2 = n4; n2 < this.numThreshold; ++n2) {
                if (!(this.thresholdV[n4] > this.thresholdV[n2])) continue;
                f9 = this.thresholdV[n2];
                this.thresholdV[n2] = this.thresholdV[n4];
                this.thresholdV[n4] = f9;
                Color color = this.thresholdColorS[n2];
                this.thresholdColorS[n2] = this.thresholdColorS[n4];
                this.thresholdColorS[n4] = color;
            }
        }
        float[] fArray3 = new float[this.numThreshold];
        for (int i = 0; i < this.numThreshold; ++i) {
            fArray3[i] = this.paper.availableLength(this.thresholdV[i] * this.unit[1]);
            if (!(fArray3[i] < 2.0f) || fArray3[i] == 0.0f) continue;
            fArray3[i] = fArray3[i] + 3.0f;
        }
        float f10 = f6;
        float f11 = f7;
        float f12 = 0.0f;
        float f13 = 0.0f;
        float f14 = 0.0f;
        float f15 = 0.0f;
        float f16 = 0.0f;
        float[][] fArray4 = new float[this.col - 1][2];
        for (n = 0; n < this.col - 1; ++n) {
            fArray4[n][0] = 0.0f;
            fArray4[n][1] = 0.0f;
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            this.sideArea = new Chart3DStrip[this.numThreshold][2];
            for (n = 0; n < this.numThreshold; ++n) {
                this.sideArea[n][0] = new Chart3DStrip(this.pattern[0], this.contour, this.SEDU);
                this.sideArea[n][1] = new Chart3DStrip(this.pattern[0], this.contour, this.SEDU);
                this.sideArea[n][0].setThresholdColor(this.thresholdColorS[n], this.transparent);
                this.sideArea[n][1].setThresholdColor(this.thresholdColorS[n], this.transparent);
            }
        }
        ChartCategoryAxis chartCategoryAxis = (ChartCategoryAxis)this.paper.getAxisX1();
        if (this.paper.getAxisX1().custommerConstant()) {
            for (n2 = 0; n2 < this.numThreshold; ++n2) {
                Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(0);
                f2 = chartCategoryAxis.getX(object, this.unit[0]);
                f12 = chartCategoryAxis.getX(object, this.unit[0]);
                this.sideArea[n2][0].setLineVertex1(0.0f, fArray3[n2], 0.0f, 0.0f, this.unit[2] * 2.0f, f2);
                object = this.getChartDataSet().getChartDataSetModel().getCategoryName(this.col - 1);
                f = chartCategoryAxis.getX(object, this.unit[0]);
                this.sideArea[n2][1].setLineVertex1(f, fArray3[n2], 0.0f, 0.0f, this.unit[2] * 2.0f, this.paper.getLength()[0] - f);
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            float f17 = f11;
            for (int i = 0; i < this.col - 1; ++i) {
                f16 = this.lineValues[n2][i];
                f15 = f16 * this.unit[1];
                f14 = this.lineValues[n2][i + 1];
                f13 = f14 * this.unit[1];
                f12 = f10 + f5;
                if (this.paper.getAxisX1().custommerConstant()) {
                    Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(i);
                    f10 = f = chartCategoryAxis.getX(object, this.unit[0]);
                    object = this.getChartDataSet().getChartDataSetModel().getCategoryName(i + 1);
                    f12 = chartCategoryAxis.getX(object, this.unit[0]);
                }
                this.strip[n2][i] = new Chart3DStrip(this.pattern[n2], this.contour, this.SEDU);
                this.strip[n2][i].setAreaSurfaceVertex(f10, this.paper.availableLength(f15), f11, f12, this.paper.availableLength(f13), f17, f3);
                this.bottom[n2][i] = new Chart3DStrip(this.pattern[n2], this.contour, this.SEDU);
                this.bottom[n2][i].setAreaSurfaceVertex(f10, this.paper.availableOriginY(f4), f11, f12, this.paper.availableOriginY(f4), f17, f3);
                f10 = f12;
                fArray4[i][0] = f15;
                fArray4[i][1] = f13;
            }
            f10 = f6;
        }
        for (n2 = 0; n2 < this.col - 1; ++n2) {
            int n6;
            f15 = this.paper.availableLength(fArray4[n2][0]);
            f13 = this.paper.availableLength(fArray4[n2][1]);
            for (int i = 0; i < this.numThreshold; ++i) {
                this.num[n2][i][0] = 0;
                this.num[n2][i][1] = 0;
                this.num[n2][i][2] = 0;
                this.areas[n2][i][0] = new Chart3DStrip(this.pattern[0], this.contour, this.SEDU);
                this.areas[n2][i][1] = new Chart3DStrip(this.pattern[0], this.contour, this.SEDU);
                this.areas[n2][i][2] = new Chart3DStrip(this.pattern[0], this.contour, this.SEDU);
                this.areas[n2][i][0].setThresholdColor(this.thresholdColorS[i], this.transparent);
                this.areas[n2][i][1].setThresholdColor(this.thresholdColorS[i], this.transparent);
                this.areas[n2][i][2].setThresholdColor(this.thresholdColorS[i], this.transparent);
            }
            float f18 = 0.0f;
            f2 = 0.0f;
            if (this.paper.getAxisX1().custommerConstant()) {
                float f19;
                Object object = this.getChartDataSet().getChartDataSetModel().getCategoryName(n2);
                f2 = f10 = (f19 = chartCategoryAxis.getX(object, this.unit[0]));
                object = this.getChartDataSet().getChartDataSetModel().getCategoryName(n2 + 1);
                float f20 = chartCategoryAxis.getX(object, this.unit[0]);
                f18 = f20 - f10;
                if (n2 != this.col - 2) {
                    object = this.getChartDataSet().getChartDataSetModel().getCategoryName(n2 + 1);
                    f20 = chartCategoryAxis.getX(object, this.unit[0]);
                    f18 = f20 - f10;
                }
            } else {
                f2 = (float)n2 * this.unit[0];
                f18 = this.unit[0];
            }
            for (n6 = 0; n6 < this.numThreshold; ++n6) {
                if (fArray3[n6] <= f15 && fArray3[n6] > f13) {
                    if (fArray3[n6] > f4) {
                        this.areas[n2][n6][2].setLineVertex1(f2 + (fArray3[n6] - f15) / (f13 - f15) * f18, fArray3[n6], this.unit[2] - f3 / 2.0f, 0.0f, f3, f18 - (fArray3[n6] - f15) / (f13 - f15) * f18);
                        int[] nArray = this.num[n2][n6];
                        nArray[1] = nArray[1] + 1;
                        continue;
                    }
                    if (!(f13 <= f4)) continue;
                    this.areas[n2][n6][2].setLineVertex1(f2, fArray3[n6], this.unit[2] - f3 / 2.0f, 0.0f, f3, f18);
                    int[] nArray = this.num[n2][n6];
                    nArray[3] = nArray[3] + 1;
                    continue;
                }
                if (!(fArray3[n6] > f15) || !(fArray3[n6] <= f13)) continue;
                if (fArray3[n6] > f4) {
                    this.areas[n2][n6][2].setLineVertex1(f2, fArray3[n6], this.unit[2] - f3 / 2.0f, 0.0f, f3, (fArray3[n6] - f15) / (f13 - f15) * f18);
                    int[] nArray = this.num[n2][n6];
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                if (!(f15 <= f4)) continue;
                this.areas[n2][n6][2].setLineVertex1(f2, fArray3[n6], this.unit[2] - f3 / 2.0f, 0.0f, f3, f18);
                int[] nArray = this.num[n2][n6];
                nArray[3] = nArray[3] + 1;
            }
            for (n6 = 0; n6 < this.numThreshold; ++n6) {
                if (fArray3[n6] > f15 && fArray3[n6] > f13 && fArray3[n6] > f4) {
                    this.areas[n2][n6][2].setLineVertex1(f2, fArray3[n6], this.unit[2] - f3 / 2.0f, 0.0f, f3, f18);
                    int[] nArray = this.num[n2][n6];
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                if (fArray3[n6] != f15 || fArray3[n6] != f13) continue;
                this.areas[n2][n6][2].setLineVertex1(f2, fArray3[n6], this.unit[2] - f3 / 2.0f, 0.0f, f3, f18);
                int[] nArray = this.num[n2][n6];
                nArray[0] = nArray[0] + 1;
            }
            for (n6 = 0; n6 < this.numThreshold; ++n6) {
                this.areas[n2][n6][0].setLineVertex1(f2, fArray3[n6], 0.0f, 0.0f, this.unit[2] - f3 / 2.0f, f18);
                this.areas[n2][n6][1].setLineVertex1(f2, fArray3[n6], this.unit[2] + f3 / 2.0f, 0.0f, this.unit[2] - f3 / 2.0f, f18);
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.col < 2) {
            return;
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            n4 = 0;
            if (!this.innerAscending) {
                n4 = 1;
            }
            if (this.toUpAscending) {
                for (n3 = 0; n3 < this.numThreshold; ++n3) {
                    this.sideArea[n3][n4].drawArea(graphics2D, 0);
                }
            } else {
                for (n3 = this.numThreshold - 1; n3 >= 0; --n3) {
                    this.sideArea[n3][n4].drawArea(graphics2D, 0);
                }
            }
        }
        n4 = this.row - 1;
        for (n3 = 0; n3 < this.col - 1; ++n3) {
            int n5;
            n2 = n3;
            if (!this.innerAscending) {
                n2 = this.col - n3 - 1 - 1;
            }
            for (n = 0; n < this.numThreshold; ++n) {
                if (!this.outerAscending) {
                    this.areas[n2][n][1].drawArea(graphics2D, 0);
                    continue;
                }
                this.areas[n2][n][0].drawArea(graphics2D, 0);
            }
            if ((this.paper.getShownFace() >> 3 & 1) == 1) {
                for (n = 0; n < this.numThreshold; ++n) {
                    for (n5 = 0; n5 < this.num[n2][n][2]; ++n5) {
                        this.areas[n2][n][2].drawArea(graphics2D, n5 + this.num[n2][n][0] + this.num[n2][n][1] + this.num[n2][n][3]);
                    }
                    for (n5 = 0; n5 < this.num[n2][n][3]; ++n5) {
                        this.areas[n2][n][2].drawArea(graphics2D, n5);
                    }
                }
                this.bottom[0][n2].drawAreaSurface(graphics2D, this.contour);
                this.strip[n4][n2].drawAreaSurface(graphics2D, this.contour);
                for (n = 0; n < this.numThreshold; ++n) {
                    for (n5 = 0; n5 < this.num[n2][n][1]; ++n5) {
                        this.areas[n2][n][2].drawArea(graphics2D, n5 + this.num[n2][n][3]);
                    }
                    for (n5 = 0; n5 < this.num[n2][n][0]; ++n5) {
                        this.areas[n2][n][2].drawArea(graphics2D, n5 + this.num[n2][n][1] + this.num[n2][n][3]);
                    }
                }
                continue;
            }
            for (n = 0; n < this.numThreshold; ++n) {
                for (n5 = 0; n5 < this.num[n2][n][0]; ++n5) {
                    this.areas[n2][n][2].drawArea(graphics2D, n5 + this.num[n2][n][1] + this.num[n2][n][3]);
                }
                for (n5 = 0; n5 < this.num[n2][n][1]; ++n5) {
                    this.areas[n2][n][2].drawArea(graphics2D, n5 + this.num[n2][n][3]);
                }
            }
            this.strip[n4][n2].drawAreaSurface(graphics2D, this.contour);
            this.bottom[0][n2].drawAreaSurface(graphics2D, this.contour);
            for (n = 0; n < this.numThreshold; ++n) {
                for (n5 = 0; n5 < this.num[n2][n][3]; ++n5) {
                    this.areas[n2][n][2].drawArea(graphics2D, n5);
                }
                for (n5 = 0; n5 < this.num[n2][n][2]; ++n5) {
                    this.areas[n2][n][2].drawArea(graphics2D, n5 + this.num[n2][n][1] + this.num[n2][n][0] + this.num[n2][n][3]);
                }
            }
        }
        for (n3 = this.row - 1; n3 >= 0; --n3) {
            this.paintInnerFace(graphics2D, n3);
            this.paintOuterFace(graphics2D, n3);
        }
        for (n3 = 0; n3 < this.col - 1; ++n3) {
            n2 = n3;
            if (!this.innerAscending) {
                n2 = this.col - 1 - n3 - 1;
            }
            for (n = 0; n < this.numThreshold; ++n) {
                if (!this.outerAscending) {
                    this.areas[n2][n][0].drawArea(graphics2D, 0);
                    continue;
                }
                this.areas[n2][n][1].drawArea(graphics2D, 0);
            }
        }
        if (this.paper.getAxisX1().custommerConstant()) {
            n3 = 0;
            if (this.innerAscending) {
                n3 = 1;
            }
            if (this.toUpAscending) {
                for (n2 = 0; n2 < this.numThreshold; ++n2) {
                    this.sideArea[n2][n3].drawArea(graphics2D, 0);
                }
            } else {
                for (n2 = this.numThreshold - 1; n2 >= 0; --n2) {
                    this.sideArea[n2][n3].drawArea(graphics2D, 0);
                }
            }
        }
        this.areas(graphics2D);
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.strip[n][n2].toHtml();
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        if (this.col < 2) {
            this.selectedSeriesIndex = -1;
            return null;
        }
        String[] stringArray = null;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col - 1; ++j) {
                if (this.inSide(i, j, n, n2)) {
                    if (this.paper.getProperties().isShowCategoryAndSeries()) {
                        stringArray = new String[3];
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(i, j);
                    } else {
                        stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(i, j))};
                    }
                    this.selectedSeriesIndex = i;
                    this.drilldown = new int[2];
                    this.drilldown[0] = i;
                    this.drilldown[1] = j;
                    return stringArray;
                }
                if (j != this.col - 2) continue;
                float f = this.strip[i][j].tVertex[1][0];
                float f2 = this.strip[i][j].tVertex[2][0];
                float f3 = this.strip[i][j].tVertex[1][1];
                float f4 = this.strip[i][j].tVertex[1][1] + 5.0f;
                float f5 = 5.0f;
                if (!((float)n >= f - f5) || !((float)n <= f2 + f5) || !((float)n2 <= Math.max(f3 + f5, f4 + f5)) || !((float)n2 >= Math.min(f3 - f5, f4 - f5))) continue;
                if (this.paper.getProperties().isShowCategoryAndSeries()) {
                    stringArray = new String[3];
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(i, j + 1);
                } else {
                    stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(i, j + 1))};
                }
                this.selectedSeriesIndex = i;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j + 1;
                return stringArray;
            }
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    public boolean inSide(int n, int n2, int n3, int n4) {
        float f = 5.0f;
        float f2 = this.strip[n][n2].tVertex[0][0];
        float f3 = this.strip[n][n2].tVertex[3][0];
        float f4 = this.strip[n][n2].tVertex[0][1];
        float f5 = this.strip[n][n2].tVertex[0][1] + f;
        return (float)n3 >= f2 - f && (float)n3 <= f3 + f && (float)n4 <= Math.max(f5 + f, f4 - f) && (float)n4 >= Math.min(f5 + f, f4 - f);
    }

    protected void paintInnerFace(Graphics2D graphics2D, int n) {
        int n2 = this.strip[n].length - 1;
        this.path.reset();
        if (!this.innerAscending) {
            this.path.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            this.path.lineTo(this.strip[n][0].tVertex[0][0], this.strip[n][0].tVertex[0][1]);
            this.path.lineTo(this.strip[n][0].tVertex[3][0], this.strip[n][0].tVertex[3][1]);
            this.path.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            this.path.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.path.moveTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.path.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.path.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.path.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.path.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
        }
        if (this.pattern[n] != null) {
            this.pattern[n].fill(graphics2D, this.path);
        }
        this.contour = this.paper.getProperties().getGraphProperties().isContour();
        if (this.contour) {
            this.SEDU.draw(graphics2D, this.path);
        }
        if (n == this.selectedSeriesIndex && this.status == 1) {
            ChartGraphicsUtil.drawSelectedShape(graphics2D, this.path);
        }
    }

    protected void paintOuterFace(Graphics2D graphics2D, int n) {
        int n2 = this.strip[n].length - 1;
        this.path.reset();
        if (!this.outerAscending) {
            this.path.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            for (int i = 0; i <= n2; ++i) {
                this.path.lineTo(this.strip[n][i].tVertex[0][0], this.strip[n][i].tVertex[0][1]);
            }
            this.path.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.path.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.path.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.path.moveTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            for (int i = 0; i <= n2; ++i) {
                this.path.lineTo(this.strip[n][i].tVertex[3][0], this.strip[n][i].tVertex[3][1]);
            }
            this.path.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.path.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.path.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
        }
        if (this.pattern[n] != null) {
            this.pattern[n].fill(graphics2D, this.path);
        }
        if (this.contour) {
            this.SEDU.draw(graphics2D, this.path);
        }
        if (n == this.selectedSeriesIndex && this.status == 1) {
            ChartGraphicsUtil.drawSelectedShape(graphics2D, this.path);
        }
    }

    private void SEDU() {
        this.add();
        this.abs();
        this.areaSurface();
    }

    private void abs() {
        this.outerAscending = (this.paper.getShownFace() >> 5 & 1) == 1;
    }

    private void add() {
        this.innerAscending = (this.paper.getShownFace() & 1) != 1;
    }

    private void areaSurface() {
        this.toUpAscending = (this.paper.getShownFace() >> 3 & 1) == 1;
    }

    public void setCompass(ChartCompass chartCompass) {
        this.compass = chartCompass;
    }

    protected Area innerFaceCover(int n) {
        int n2 = this.strip[n].length - 1;
        this.path.reset();
        if (!this.innerAscending) {
            this.path.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            this.path.lineTo(this.strip[n][0].tVertex[0][0], this.strip[n][0].tVertex[0][1]);
            this.path.lineTo(this.strip[n][0].tVertex[3][0], this.strip[n][0].tVertex[3][1]);
            this.path.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            this.path.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.path.moveTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.path.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.path.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.path.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.path.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
        }
        return new Area(this.path);
    }

    protected Area outerFaceCover(int n) {
        int n2 = this.strip[n].length - 1;
        this.path.reset();
        if (!this.outerAscending) {
            this.path.moveTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
            for (int i = 0; i <= n2; ++i) {
                this.path.lineTo(this.strip[n][i].tVertex[0][0], this.strip[n][i].tVertex[0][1]);
            }
            this.path.lineTo(this.strip[n][n2].tVertex[1][0], this.strip[n][n2].tVertex[1][1]);
            this.path.lineTo(this.bottom[n][n2].tVertex[1][0], this.bottom[n][n2].tVertex[1][1]);
            this.path.lineTo(this.bottom[n][0].tVertex[0][0], this.bottom[n][0].tVertex[0][1]);
        } else {
            this.path.moveTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
            for (int i = 0; i <= n2; ++i) {
                this.path.lineTo(this.strip[n][i].tVertex[3][0], this.strip[n][i].tVertex[3][1]);
            }
            this.path.lineTo(this.strip[n][n2].tVertex[2][0], this.strip[n][n2].tVertex[2][1]);
            this.path.lineTo(this.bottom[n][n2].tVertex[2][0], this.bottom[n][n2].tVertex[2][1]);
            this.path.lineTo(this.bottom[n][0].tVertex[3][0], this.bottom[n][0].tVertex[3][1]);
        }
        return new Area(this.path);
    }

    protected Area bottomCover(int n) {
        Area area = new Area();
        for (int i = 0; i < this.strip[n].length; ++i) {
            int n2 = i;
            if (!this.innerAscending) {
                n2 = this.strip[n].length - i - 1;
            }
            if ((this.paper.getShownFace() >> 3 & 1) == 1) {
                if (this.negative[n][n2]) {
                    area.add(this.strip[n][n2].areaSurface());
                    area.add(this.bottom[n][n2].areaSurface());
                    continue;
                }
                area.add(this.bottom[n][n2].areaSurface());
                area.add(this.strip[n][n2].areaSurface());
                continue;
            }
            if (this.negative[n][n2]) {
                area.add(this.bottom[n][n2].areaSurface());
                area.add(this.strip[n][n2].areaSurface());
                continue;
            }
            area.add(this.strip[n][n2].areaSurface());
            area.add(this.bottom[n][n2].areaSurface());
        }
        return area;
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        if (this.col < 2) {
            return null;
        }
        Shape[][] shapeArray = new Shape[this.row][this.col];
        float f = 5.0f;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                float f2;
                float f3;
                float f4;
                float f5;
                if (j == this.col - 1) {
                    f5 = Math.min(this.strip[i][j - 1].tVertex[1][0], this.strip[i][j - 1].tVertex[2][0]);
                    f4 = Math.max(this.strip[i][j - 1].tVertex[2][0], this.strip[i][j - 1].tVertex[1][0]);
                    f3 = Math.max(this.strip[i][j - 1].tVertex[1][1], this.strip[i][j - 1].tVertex[1][1]);
                    f2 = Math.min(this.strip[i][j - 1].tVertex[1][1], this.strip[i][j - 1].tVertex[1][1]);
                } else {
                    f5 = Math.min(this.strip[i][j].tVertex[0][0], this.strip[i][j].tVertex[3][0]);
                    f4 = Math.max(this.strip[i][j].tVertex[3][0], this.strip[i][j].tVertex[0][0]);
                    f2 = Math.min(this.strip[i][j].tVertex[0][1], this.strip[i][j].tVertex[0][1]);
                    f3 = Math.max(this.strip[i][j].tVertex[0][1], this.strip[i][j].tVertex[0][1]);
                }
                shapeArray[i][j] = new GeneralPath();
                ((GeneralPath)shapeArray[i][j]).moveTo(f5 - f, f3 + f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f4 + f, f3 + f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f4 + f, f2 - f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f5 - f, f2 - f);
                ((GeneralPath)shapeArray[i][j]).lineTo(f5 - f, f3 + f);
            }
        }
        return shapeArray;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    private void areas(Graphics2D graphics2D) {
        if (this.col < 2) {
            return;
        }
        for (int i = 0; i < this.row; ++i) {
            if (this.strip[i] == null) continue;
            for (int j = 0; j < this.strip[i].length; ++j) {
                if (this.selectedSeriesIndex != i || this.status != 1) continue;
                this.strip[i][j].drawSelectedOutLine(graphics2D);
            }
        }
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        if (this.col < 2) {
            return null;
        }
        int[] nArray = null;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col - 1; ++j) {
                if (this.inSide(i, j, n, n2)) {
                    ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                    if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                        nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                    }
                    return nArray;
                }
                if (j != this.col - 2) continue;
                float f = this.strip[i][j].tVertex[1][0];
                float f2 = this.strip[i][j].tVertex[2][0];
                float f3 = this.strip[i][j].tVertex[1][1];
                float f4 = this.strip[i][j].tVertex[1][1] + 5.0f;
                float f5 = 5.0f;
                if (!((float)n >= f - f5) || !((float)n <= f2 + f5) || !((float)n2 <= Math.max(f3 + f5, f4 + f5)) || !((float)n2 >= Math.min(f3 - f5, f4 - f5))) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(i)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

