/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.ChartEnv;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.Chart3DStrip;
import chart.chart3d.ChartCube;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartFillPattern;
import chart.util.ChartHintLabel;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.List;

public class Graph3DSurface
extends Chart3DObject {
    private ChartDataSet SEDU;
    private Chart3DPaper WORDWRAPPER_GAP;
    private int[] abs;
    private ChartCube[][] addVertex;
    private int availableValue = ChartEnv.WORDWRAPPER_GAP;
    private Chart3DStrip[][] axisY;
    private Chart3DStrip[][] drawSurfaceContour;
    private Chart3DStrip[][][][] drawSurfaceGrid;
    private ChartFillPattern[] fillSurface;
    private ChartMatrix floatValue;
    private int floor;
    private int get;
    private float[][] getCategorySize;
    private int[][] getChartFillPatternForSurface;
    private int[][] getChartLink;
    private int[][] getChartLinkInfo;
    private int[][] getChartPlatform;
    private boolean getCondition;
    private boolean getContourPen;
    private float[] getFormatedHintValue;
    private float getFristLabel;
    private float getGraphProperties = 0.0f;
    private float[][] getIntType;
    private float[][] getMin;
    private float getOriginY;
    private boolean getProperties;
    private float getSeriesSize;

    public Graph3DSurface(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.SEDU = chartDataSet;
        this.abs = chart3DPaper.getIntType();
        this.WORDWRAPPER_GAP = chart3DPaper;
        this.floor = chartDataSet.getCategorySize();
        this.get = chartDataSet.getSeriesSize();
        this.fillSurface = chart3DPaper.getChartPlatform().getChartFillPatternForSurface(chart3DPaper);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.get < 2 || this.floor < 2) {
            return;
        }
        for (int i = 0; i < this.get - 1; ++i) {
            int n = i;
            if (!this.getContourPen) {
                n = this.get - 1 - i - 1;
            }
            for (int j = 0; j < this.floor - 1; ++j) {
                int n2;
                int n3 = j;
                if (!this.getCondition) {
                    n3 = this.floor - 1 - j - 1;
                }
                if (this.getContourPen) {
                    for (n2 = 0; n2 < this.getChartFillPatternForSurface[n][n3]; ++n2) {
                        if (this.drawSurfaceGrid[n][n3][n2][0] == null) continue;
                        this.drawSurfaceGrid[n][n3][n2][0].fillSurface(graphics2D);
                        this.drawSurfaceGrid[n][n3][n2][0].drawSurfaceGrid(graphics2D);
                    }
                    if (this.axisY[n][n3] == null) continue;
                    if (this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour()) {
                        this.axisY[n][n3].drawSurfaceContour(graphics2D);
                    }
                    for (n2 = 0; n2 < this.getChartLink[n][n3]; ++n2) {
                        if (this.drawSurfaceGrid[n][n3][n2][1] == null) continue;
                        this.drawSurfaceGrid[n][n3][n2][1].fillSurface(graphics2D);
                        this.drawSurfaceGrid[n][n3][n2][1].drawSurfaceGrid(graphics2D);
                    }
                    if (this.drawSurfaceContour[n][n3] == null || !this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour()) continue;
                    this.drawSurfaceContour[n][n3].drawSurfaceContour(graphics2D);
                    continue;
                }
                for (n2 = 0; n2 < this.getChartLink[n][n3]; ++n2) {
                    if (this.drawSurfaceGrid[n][n3][n2][1] == null) continue;
                    this.drawSurfaceGrid[n][n3][n2][1].fillSurface(graphics2D);
                    this.drawSurfaceGrid[n][n3][n2][1].drawSurfaceGrid(graphics2D);
                }
                if (this.drawSurfaceContour[n][n3] == null) continue;
                if (this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour()) {
                    this.drawSurfaceContour[n][n3].drawSurfaceContour(graphics2D);
                }
                for (n2 = 0; n2 < this.getChartFillPatternForSurface[n][n3]; ++n2) {
                    if (this.drawSurfaceGrid[n][n3][n2][0] == null) continue;
                    this.drawSurfaceGrid[n][n3][n2][0].fillSurface(graphics2D);
                    this.drawSurfaceGrid[n][n3][n2][0].drawSurfaceGrid(graphics2D);
                }
                if (this.axisY[n][n3] == null || !this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour()) continue;
                this.axisY[n][n3].drawSurfaceContour(graphics2D);
            }
        }
    }

    @Override
    public void transform(ChartMatrix chartMatrix) {
        int n;
        int n2;
        if (this.floor < 2 || this.get < 2) {
            return;
        }
        for (n2 = 0; n2 < this.get; ++n2) {
            for (n = 0; n < this.floor; ++n) {
                if (this.addVertex[n2][n] == null) continue;
                this.addVertex[n2][n].transform(chartMatrix);
            }
        }
        for (n2 = 0; n2 < this.get - 1; ++n2) {
            for (n = 0; n < this.floor - 1; ++n) {
                int n3;
                if (this.axisY[n2][n] == null) continue;
                this.axisY[n2][n].transform(chartMatrix);
                if (this.drawSurfaceContour[n2][n] == null) continue;
                this.drawSurfaceContour[n2][n].transform(chartMatrix);
                for (n3 = 0; n3 < this.getChartFillPatternForSurface[n2][n]; ++n3) {
                    if (this.drawSurfaceGrid[n2][n][n3][0] == null) continue;
                    this.drawSurfaceGrid[n2][n][n3][0].transform(chartMatrix);
                }
                for (n3 = 0; n3 < this.getChartLink[n2][n]; ++n3) {
                    if (this.drawSurfaceGrid[n2][n][n3][1] == null) continue;
                    this.drawSurfaceGrid[n2][n][n3][1].transform(chartMatrix);
                }
            }
        }
        this.SEDU();
    }

    private void SEDU() {
        if (this.floor - 1 != 1) {
            this.abs();
        }
        if (this.get != 2) {
            this.WORDWRAPPER_GAP();
        }
    }

    private void WORDWRAPPER_GAP() {
        this.getContourPen = (this.WORDWRAPPER_GAP.getShownFace() >> 5 & 1) == 1;
    }

    private void abs() {
        this.getCondition = (this.WORDWRAPPER_GAP.getShownFace() & 1) != 1;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        String[] stringArray = null;
        if (this.get < 2 || this.floor < 2) {
            this.selectedSeriesIndex = -1;
            return null;
        }
        for (int i = 0; i < this.get; ++i) {
            int n3 = i;
            if (this.getContourPen) {
                n3 = this.get - i - 1;
            }
            for (int j = 0; j < this.floor; ++j) {
                int n4 = j;
                if (this.getCondition) {
                    n4 = this.floor - j - 1;
                }
                if (!this.addVertex[n3][n4].inBar(n3, n4, n, n2)) continue;
                if (this.WORDWRAPPER_GAP.getProperties().isShowCategoryAndSeries()) {
                    stringArray = new String[3];
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.WORDWRAPPER_GAP, 3);
                    stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(n3, n4);
                } else {
                    stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getValue(n3, n4))};
                }
                this.selectedSeriesIndex = n3;
                this.drilldown = new int[2];
                this.drilldown[0] = n3;
                this.drilldown[1] = n4;
                return stringArray;
            }
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    @Override
    public void locate() {
    }

    @Override
    public void init() {
        float f;
        float f2;
        float f3;
        float f4;
        int n;
        int n2;
        if (this.floor < 2 || this.get < 2) {
            return;
        }
        int[] nArray = new int[4];
        int n3 = 0;
        float[][] fArray2 = new float[this.get][this.floor];
        float[][] fArray3 = new float[4][3];
        int n4 = this.fillSurface.length;
        this.getCategorySize = new float[4][3];
        this.getFormatedHintValue = this.WORDWRAPPER_GAP.getUnit();
        float f5 = (float)((ChartNumericAxis)this.WORDWRAPPER_GAP.axisY).getMin();
        this.getIntType = new float[3][3];
        this.getMin = new float[3][3];
        this.getOriginY = ((ChartNumericAxis)this.WORDWRAPPER_GAP.axisY).getFristLabel();
        this.getProperties = this.getOriginY != f5;
        this.addVertex = new ChartCube[this.get][this.floor];
        this.axisY = new Chart3DStrip[this.get - 1][this.floor - 1];
        this.drawSurfaceContour = new Chart3DStrip[this.get - 1][this.floor - 1];
        this.getChartLinkInfo = new int[this.get - 1][this.floor - 1];
        this.getChartPlatform = new int[this.get - 1][this.floor - 1];
        this.getChartFillPatternForSurface = new int[this.get - 1][this.floor - 1];
        this.getChartLink = new int[this.get - 1][this.floor - 1];
        this.getGraphProperties = this.WORDWRAPPER_GAP.getOriginY();
        this.getFristLabel = (float)((ChartNumericAxis)this.WORDWRAPPER_GAP.axisY).getTickPace();
        float[][] fArray4 = new float[n4 * 2 + 1][3];
        float[][] fArray5 = new float[n4 * 2 + 1][3];
        Chart3DStrip[] chart3DStripArray = new Chart3DStrip[n4];
        Chart3DStrip[] chart3DStripArray2 = new Chart3DStrip[n4];
        this.drawSurfaceGrid = new Chart3DStrip[this.get - 1][this.floor - 1][n4][2];
        if (this.getProperties) {
            this.getSeriesSize = this.getFristLabel - (this.getOriginY - f5);
            this.getSeriesSize *= this.getFormatedHintValue[1];
        } else {
            this.getSeriesSize = 0.0f;
        }
        for (n2 = 0; n2 < this.get; ++n2) {
            for (n = 0; n < this.floor; ++n) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                fArray2[n2][n] = number == null ? 0.0f : number.floatValue();
            }
        }
        this.availableValue += 2;
        for (n2 = 0; n2 < this.get; ++n2) {
            for (n = 0; n < this.floor; ++n) {
                this.addVertex[n2][n] = new ChartCube();
                f4 = this.WORDWRAPPER_GAP.availableValue(fArray2[n2][n]);
                f3 = f4 * this.getFormatedHintValue[1] + this.getGraphProperties;
                f2 = this.getFormatedHintValue[0] * (float)n;
                f = this.getFormatedHintValue[2] * (float)n2;
                this.addVertex[n2][n].addVertex(f2 - (float)this.availableValue, f3 + (float)this.availableValue, f - (float)this.availableValue);
                this.addVertex[n2][n].addVertex(f2 - (float)this.availableValue, f3 + (float)this.availableValue, f + (float)this.availableValue);
                this.addVertex[n2][n].addVertex(f2 + (float)this.availableValue, f3 + (float)this.availableValue, f + (float)this.availableValue);
                this.addVertex[n2][n].addVertex(f2 + (float)this.availableValue, f3 + (float)this.availableValue, f - (float)this.availableValue);
                this.addVertex[n2][n].addVertex(f2 - (float)this.availableValue, f3 - (float)this.availableValue, f - (float)this.availableValue);
                this.addVertex[n2][n].addVertex(f2 - (float)this.availableValue, f3 - (float)this.availableValue, f + (float)this.availableValue);
                this.addVertex[n2][n].addVertex(f2 + (float)this.availableValue, f3 - (float)this.availableValue, f + (float)this.availableValue);
                this.addVertex[n2][n].addVertex(f2 + (float)this.availableValue, f3 - (float)this.availableValue, f - (float)this.availableValue);
            }
        }
        for (n2 = 0; n2 < this.get - 1; ++n2) {
            for (n = 0; n < this.floor - 1; ++n) {
                int n5;
                float f6;
                float f7;
                int n6;
                this.axisY[n2][n] = new Chart3DStrip(this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour(), this.properties.getGraphProperties().getContourPen());
                this.drawSurfaceContour[n2][n] = new Chart3DStrip(this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour(), this.properties.getGraphProperties().getContourPen());
                for (n6 = 0; n6 < n4; ++n6) {
                    this.drawSurfaceGrid[n2][n][n6][0] = new Chart3DStrip(this.fillSurface[0], this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour(), this.properties.getGraphProperties().getContourPen());
                    this.drawSurfaceGrid[n2][n][n6][1] = new Chart3DStrip(this.fillSurface[0], this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour(), this.properties.getGraphProperties().getContourPen());
                }
                f4 = this.WORDWRAPPER_GAP.availableValue(fArray2[n2][n]);
                f3 = f4 * this.getFormatedHintValue[1] + this.getGraphProperties;
                float f8 = this.WORDWRAPPER_GAP.availableValue(fArray2[n2][n + 1]);
                float f9 = f8 * this.getFormatedHintValue[1] + this.getGraphProperties;
                float f10 = this.WORDWRAPPER_GAP.availableValue(fArray2[n2 + 1][n + 1]);
                float f11 = f10 * this.getFormatedHintValue[1] + this.getGraphProperties;
                float f12 = this.WORDWRAPPER_GAP.availableValue(fArray2[n2 + 1][n]);
                float f13 = f12 * this.getFormatedHintValue[1] + this.getGraphProperties;
                f2 = this.getFormatedHintValue[0] * (float)n;
                float f14 = f7 = this.getFormatedHintValue[0] * (float)(n + 1);
                float f15 = f2;
                float f16 = f = this.getFormatedHintValue[2] * (float)n2;
                float f17 = f6 = this.getFormatedHintValue[2] * (float)(n2 + 1);
                this.getCategorySize[0][0] = f2;
                this.getCategorySize[0][1] = f3;
                this.getCategorySize[0][2] = f;
                this.getCategorySize[1][0] = f7;
                this.getCategorySize[1][1] = f9;
                this.getCategorySize[1][2] = f16;
                this.getCategorySize[2][0] = f14;
                this.getCategorySize[2][1] = f11;
                this.getCategorySize[2][2] = f6;
                this.getCategorySize[3][0] = f15;
                this.getCategorySize[3][1] = f13;
                this.getCategorySize[3][2] = f17;
                fArray3[0][0] = f2;
                fArray3[0][1] = f3;
                fArray3[0][2] = f;
                fArray3[1][0] = f7;
                fArray3[1][1] = f9;
                fArray3[1][2] = f16;
                fArray3[2][0] = f14;
                fArray3[2][1] = f11;
                fArray3[2][2] = f6;
                fArray3[3][0] = f15;
                fArray3[3][1] = f13;
                fArray3[3][2] = f17;
                float f18 = Float.MIN_VALUE;
                for (n6 = 0; n6 < 4; ++n6) {
                    if (!(this.getCategorySize[n6][1] > f18)) continue;
                    f18 = this.getCategorySize[n6][1];
                    n3 = n6;
                }
                int n7 = n3 + 2 > 3 ? n3 - 2 : n3 + 2;
                nArray[0] = n3 > n7 ? n7 : n3;
                int n8 = nArray[0] - 1 < 0 ? nArray[0] + 1 : nArray[0] - 1;
                if (this.getCategorySize[n3][1] == Math.max(this.getCategorySize[n8][1], this.getCategorySize[n5 = n8 + 2][1]) && this.getCategorySize[n8][1] + this.getCategorySize[n5][1] > this.getCategorySize[n3][1] + this.getCategorySize[n7][1]) {
                    nArray[0] = n3;
                    nArray[1] = n7;
                    nArray[2] = n8;
                    nArray[3] = n5;
                    if (this.getCategorySize[n8][1] > this.getCategorySize[n5][1]) {
                        n3 = nArray[2];
                        n7 = nArray[3];
                    } else {
                        n3 = nArray[3];
                        n7 = nArray[2];
                    }
                    if (this.getCategorySize[nArray[0]][0] > this.getCategorySize[nArray[1]][0]) {
                        n8 = nArray[0];
                        n5 = nArray[1];
                    } else {
                        n8 = nArray[1];
                        n5 = nArray[0];
                    }
                }
                for (n6 = 0; n6 < 3; ++n6) {
                    this.getCategorySize[0][n6] = fArray3[n3][n6];
                    this.getCategorySize[1][n6] = fArray3[n8][n6];
                    this.getCategorySize[2][n6] = fArray3[n7][n6];
                    this.getCategorySize[3][n6] = fArray3[n5][n6];
                }
                this.axisY[n2][n].setSurfaceVertex(this.getCategorySize[0][0], this.getCategorySize[0][1], this.getCategorySize[0][2], this.getCategorySize[2][0], this.getCategorySize[2][1], this.getCategorySize[2][2], this.getCategorySize[1][0], this.getCategorySize[1][1], this.getCategorySize[1][2]);
                this.drawSurfaceContour[n2][n].setSurfaceVertex(this.getCategorySize[0][0], this.getCategorySize[0][1], this.getCategorySize[0][2], this.getCategorySize[2][0], this.getCategorySize[2][1], this.getCategorySize[2][2], this.getCategorySize[3][0], this.getCategorySize[3][1], this.getCategorySize[3][2]);
                if (this.getCategorySize[2][1] >= this.getCategorySize[1][1]) {
                    this.getIntType = this.addVertex(this.getCategorySize[0][0], this.getCategorySize[0][1], this.getCategorySize[0][2], this.getCategorySize[2][0], this.getCategorySize[2][1], this.getCategorySize[2][2], this.getCategorySize[1][0], this.getCategorySize[1][1], this.getCategorySize[1][2]);
                    this.getChartLinkInfo[n2][n] = this.availableValue(this.getCategorySize[1][1], f5, this.getFristLabel);
                    this.getChartFillPatternForSurface[n2][n] = this.axisY(this.getCategorySize[0][1], this.getCategorySize[1][1], this.getFristLabel, f5);
                    fArray4 = this.dataset(this.getIntType, this.getChartFillPatternForSurface[n2][n], this.getChartLinkInfo[n2][n], this.getFristLabel, f5);
                    chart3DStripArray = this.drawSurfaceContour(fArray4, this.getChartFillPatternForSurface[n2][n], this.getChartLinkInfo[n2][n], this.getFristLabel, f5, this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour());
                    for (n6 = 0; n6 < this.getChartFillPatternForSurface[n2][n]; ++n6) {
                        this.drawSurfaceGrid[n2][n][n6][0] = chart3DStripArray[n6];
                    }
                } else {
                    this.getIntType = this.addVertex(this.getCategorySize[0][0], this.getCategorySize[0][1], this.getCategorySize[0][2], this.getCategorySize[1][0], this.getCategorySize[1][1], this.getCategorySize[1][2], this.getCategorySize[2][0], this.getCategorySize[2][1], this.getCategorySize[2][2]);
                    this.getChartLinkInfo[n2][n] = this.availableValue(this.getCategorySize[2][1], f5, this.getFristLabel);
                    this.getChartFillPatternForSurface[n2][n] = this.axisY(this.getCategorySize[0][1], this.getCategorySize[2][1], this.getFristLabel, f5);
                    fArray4 = this.dataset(this.getIntType, this.getChartFillPatternForSurface[n2][n], this.getChartLinkInfo[n2][n], this.getFristLabel, f5);
                    chart3DStripArray = this.drawSurfaceContour(fArray4, this.getChartFillPatternForSurface[n2][n], this.getChartLinkInfo[n2][n], this.getFristLabel, f5, this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour());
                    for (n6 = 0; n6 < this.getChartFillPatternForSurface[n2][n]; ++n6) {
                        this.drawSurfaceGrid[n2][n][n6][0] = chart3DStripArray[n6];
                    }
                }
                if (this.getCategorySize[2][1] >= this.getCategorySize[3][1]) {
                    this.getMin = this.addVertex(this.getCategorySize[0][0], this.getCategorySize[0][1], this.getCategorySize[0][2], this.getCategorySize[2][0], this.getCategorySize[2][1], this.getCategorySize[2][2], this.getCategorySize[3][0], this.getCategorySize[3][1], this.getCategorySize[3][2]);
                    this.getChartPlatform[n2][n] = this.availableValue(this.getCategorySize[3][1], f5, this.getFristLabel);
                    this.getChartLink[n2][n] = this.axisY(this.getCategorySize[0][1], this.getCategorySize[3][1], this.getFristLabel, f5);
                    fArray5 = this.dataset(this.getMin, this.getChartLink[n2][n], this.getChartPlatform[n2][n], this.getFristLabel, f5);
                    chart3DStripArray2 = this.drawSurfaceContour(fArray5, this.getChartLink[n2][n], this.getChartPlatform[n2][n], this.getFristLabel, f5, this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour());
                    for (n6 = 0; n6 < this.getChartLink[n2][n]; ++n6) {
                        this.drawSurfaceGrid[n2][n][n6][1] = chart3DStripArray2[n6];
                    }
                    continue;
                }
                this.getMin = this.addVertex(this.getCategorySize[0][0], this.getCategorySize[0][1], this.getCategorySize[0][2], this.getCategorySize[3][0], this.getCategorySize[3][1], this.getCategorySize[3][2], this.getCategorySize[2][0], this.getCategorySize[2][1], this.getCategorySize[2][2]);
                this.getChartPlatform[n2][n] = this.availableValue(this.getCategorySize[2][1], f5, this.getFristLabel);
                this.getChartLink[n2][n] = this.axisY(this.getCategorySize[0][1], this.getCategorySize[2][1], this.getFristLabel, f5);
                fArray5 = this.dataset(this.getMin, this.getChartLink[n2][n], this.getChartPlatform[n2][n], this.getFristLabel, f5);
                chart3DStripArray2 = this.drawSurfaceContour(fArray5, this.getChartLink[n2][n], this.getChartPlatform[n2][n], this.getFristLabel, f5, this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour());
                for (n6 = 0; n6 < this.getChartLink[n2][n]; ++n6) {
                    this.drawSurfaceGrid[n2][n][n6][1] = chart3DStripArray2[n6];
                }
            }
        }
    }

    private float[][] addVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float[][] fArray2 = new float[3][3];
        fArray2[0][0] = f;
        fArray2[0][1] = f2;
        fArray2[0][2] = f3;
        fArray2[1][0] = f4;
        fArray2[1][1] = f5;
        fArray2[1][2] = f6;
        fArray2[2][0] = f7;
        fArray2[2][1] = f8;
        fArray2[2][2] = f9;
        return fArray2;
    }

    private int availableValue(float f, float f2, float f3) {
        f = (f - this.getGraphProperties) / this.getFormatedHintValue[1];
        f = this.WORDWRAPPER_GAP.availableValue(f);
        int n = 0;
        int n2 = this.fillSurface.length;
        if (this.getProperties) {
            if (f > this.getOriginY) {
                ++n;
            }
            f -= this.getOriginY;
        } else {
            f -= f2;
        }
        n = (n += (int)(f / f3)) == n2 ? n2 - 1 : n;
        return n;
    }

    private int axisY(float f, float f2, float f3, float f4) {
        f = (f - this.getGraphProperties) / this.getFormatedHintValue[1];
        f2 = (f2 - this.getGraphProperties) / this.getFormatedHintValue[1];
        f = this.WORDWRAPPER_GAP.availableValue(f);
        f2 = this.WORDWRAPPER_GAP.availableValue(f2);
        int n = 0;
        int n2 = 0;
        float f5 = 0.0f;
        if (this.getProperties) {
            if (f < this.getOriginY && f2 < this.getOriginY) {
                return 1;
            }
            if (f2 < this.getOriginY) {
                ++n2;
                f2 = 0.0f;
                f -= this.getOriginY;
            } else {
                f -= this.getOriginY;
                f2 -= this.getOriginY;
            }
        } else {
            f -= f4;
            f2 -= f4;
        }
        n += (int)(f / f3);
        float f6 = f5 = f % f3 == 0.0f ? 0.0f : Math.abs(f3 - Math.abs(f % f3));
        if (f5 / f3 >= 0.001f) {
            ++n;
        }
        n2 = (n2 += n - (int)Math.floor(f2 / f3)) == 0 ? 1 : n2;
        return n2;
    }

    private float[][] dataset(float[][] fArray2, int n, int n2, float f, float f2) {
        f *= this.getFormatedHintValue[1];
        f2 *= this.getFormatedHintValue[1];
        f2 += this.getGraphProperties;
        float[][] fArray3 = new float[n * 2 + 1][3];
        float f3 = 0.0f;
        float f4 = 0.0f;
        fArray3[n * 2][0] = fArray2[0][0];
        fArray3[n * 2][1] = fArray2[0][1];
        fArray3[n * 2][2] = fArray2[0][2];
        fArray3[n * 2 - 1][0] = fArray2[1][0];
        fArray3[n * 2 - 1][1] = fArray2[1][1];
        fArray3[n * 2 - 1][2] = fArray2[1][2];
        fArray3[n * 2 - 2][0] = fArray2[2][0];
        fArray3[n * 2 - 2][1] = fArray2[2][1];
        fArray3[n * 2 - 2][2] = fArray2[2][2];
        if (n > 1) {
            for (int i = 0; i < n - 1; ++i) {
                f3 = f2 + (float)(n2 + i + 1) * f - this.getSeriesSize;
                f4 = fArray2[0][1] - fArray2[2][1] == 0.0f ? 0.0f : (f3 - fArray2[2][1]) / (fArray2[0][1] - fArray2[2][1]);
                fArray3[i * 2][0] = fArray2[2][0] + (fArray2[0][0] - fArray2[2][0]) * f4;
                fArray3[i * 2][1] = f3;
                fArray3[i * 2][2] = fArray2[2][2] + (fArray2[0][2] - fArray2[2][2]) * f4;
                if (f3 < fArray2[1][1]) {
                    f4 = fArray2[1][1] - fArray2[2][1] == 0.0f ? 0.0f : (f3 - fArray2[2][1]) / (fArray2[1][1] - fArray2[2][1]);
                    fArray3[i * 2 + 1][0] = fArray2[2][0] + (fArray2[1][0] - fArray2[2][0]) * f4;
                    fArray3[i * 2 + 1][1] = f3;
                    fArray3[i * 2 + 1][2] = fArray2[2][2] + (fArray2[1][2] - fArray2[2][2]) * f4;
                    continue;
                }
                f4 = fArray2[0][1] - fArray2[1][1] == 0.0f ? 0.0f : (f3 - fArray2[1][1]) / (fArray2[0][1] - fArray2[1][1]);
                fArray3[i * 2 + 1][0] = fArray2[1][0] + (fArray2[0][0] - fArray2[1][0]) * f4;
                fArray3[i * 2 + 1][1] = f3;
                fArray3[i * 2 + 1][2] = fArray2[1][2] + (fArray2[0][2] - fArray2[1][2]) * f4;
            }
        }
        return fArray3;
    }

    private Chart3DStrip[] drawSurfaceContour(float[][] fArray2, int n, int n2, float f, float f2, boolean bl) {
        f *= this.getFormatedHintValue[1];
        f2 *= this.getFormatedHintValue[1];
        f2 += this.getGraphProperties;
        int n3 = this.fillSurface.length;
        Chart3DStrip[] chart3DStripArray = new Chart3DStrip[n];
        if (n == 1) {
            chart3DStripArray[0] = new Chart3DStrip(this.fillSurface[n2], this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour(), this.properties.getGraphProperties().getContourPen());
            chart3DStripArray[0].setSurfaceVertex(fArray2[0][0], fArray2[0][1], fArray2[0][2], fArray2[1][0], fArray2[1][1], fArray2[1][2], fArray2[2][0], fArray2[2][1], fArray2[2][2]);
        } else {
            for (int i = 0; i < n; ++i) {
                chart3DStripArray[i] = new Chart3DStrip(this.fillSurface[n2 + i], this.WORDWRAPPER_GAP.getProperties().getGraphProperties().isContour(), this.properties.getGraphProperties().getContourPen());
                float f3 = f2 + (float)(n2 + i + 1) * f - this.getSeriesSize;
                float f4 = f2 + (float)(n2 + i) * f;
                f4 -= n2 + i > 0 ? this.getSeriesSize : 0.0f;
                if (i == 0 || i == n - 1) {
                    if (i == 0) {
                        if (f3 > fArray2[n * 2 - 1][1]) {
                            chart3DStripArray[0].setSurfaceVertex(fArray2[0][0], fArray2[0][1], fArray2[0][2], fArray2[1][0], fArray2[1][1], fArray2[1][2], fArray2[n * 2 - 1][0], fArray2[n * 2 - 1][1], fArray2[n * 2 - 1][2], fArray2[n * 2 - 2][0], fArray2[n * 2 - 2][1], fArray2[n * 2 - 2][2]);
                            continue;
                        }
                        chart3DStripArray[0].setSurfaceVertex(fArray2[0][0], fArray2[0][1], fArray2[0][2], fArray2[1][0], fArray2[1][1], fArray2[1][2], fArray2[n * 2 - 2][0], fArray2[n * 2 - 2][1], fArray2[n * 2 - 2][2]);
                        continue;
                    }
                    if (f4 > fArray2[n * 2 - 1][1]) {
                        chart3DStripArray[n - 1].setSurfaceVertex(fArray2[(i - 1) * 2][0], fArray2[(i - 1) * 2][1], fArray2[(i - 1) * 2][2], fArray2[(i - 1) * 2 + 1][0], fArray2[(i - 1) * 2 + 1][1], fArray2[(i - 1) * 2 + 1][2], fArray2[n * 2][0], fArray2[n * 2][1], fArray2[n * 2][2]);
                        continue;
                    }
                    chart3DStripArray[n - 1].setSurfaceVertex(fArray2[(i - 1) * 2][0], fArray2[(i - 1) * 2][1], fArray2[(i - 1) * 2][2], fArray2[(i - 1) * 2 + 1][0], fArray2[(i - 1) * 2 + 1][1], fArray2[(i - 1) * 2 + 1][2], fArray2[n * 2 - 1][0], fArray2[n * 2 - 1][1], fArray2[n * 2 - 1][2], fArray2[n * 2][0], fArray2[n * 2][1], fArray2[n * 2][2]);
                    continue;
                }
                if (f3 > fArray2[n * 2 - 1][1] && f4 < fArray2[n * 2 - 1][1]) {
                    chart3DStripArray[i].setSurfaceVertex(fArray2[(i - 1) * 2][0], fArray2[(i - 1) * 2][1], fArray2[(i - 1) * 2][2], fArray2[(i - 1) * 2 + 1][0], fArray2[(i - 1) * 2 + 1][1], fArray2[(i - 1) * 2 + 1][2], fArray2[n * 2 - 1][0], fArray2[n * 2 - 1][1], fArray2[n * 2 - 1][2], fArray2[i * 2 + 1][0], fArray2[i * 2 + 1][1], fArray2[i * 2 + 1][2], fArray2[i * 2][0], fArray2[i * 2][1], fArray2[i * 2][2]);
                    continue;
                }
                chart3DStripArray[i].setSurfaceVertex(fArray2[(i - 1) * 2][0], fArray2[(i - 1) * 2][1], fArray2[(i - 1) * 2][2], fArray2[(i - 1) * 2 + 1][0], fArray2[(i - 1) * 2 + 1][1], fArray2[(i - 1) * 2 + 1][2], fArray2[i * 2 + 1][0], fArray2[i * 2 + 1][1], fArray2[i * 2 + 1][2], fArray2[i * 2][0], fArray2[i * 2][1], fArray2[i * 2][2]);
            }
        }
        return chart3DStripArray;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.addVertex[n][n2].toHtml();
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        if (this.get < 2 || this.floor < 2) {
            return null;
        }
        Shape[][] shapeArray = new Shape[this.get][this.floor];
        for (int i = 0; i < this.get; ++i) {
            for (int j = 0; j < this.floor; ++j) {
                shapeArray[i][j] = this.getShapeByItem(i, j);
            }
        }
        return shapeArray;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        if (this.get < 2 || this.floor < 2) {
            return null;
        }
        for (int i = 0; i < this.get; ++i) {
            int n3 = i;
            if (this.getContourPen) {
                n3 = this.get - i - 1;
            }
            for (int j = 0; j < this.floor; ++j) {
                int n4 = j;
                if (this.getCondition) {
                    n4 = this.floor - j - 1;
                }
                if (!this.addVertex[n3][n4].inBar(n3, n4, n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(n3, n4);
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n3)).get(n4)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

