/*
 * Decompiled with CFR 0.152.
 */
package chart.data;

import chart.ChartPlatform;
import chart.ChartShowValueCondition;
import chart.ChartShowValueInfo;
import chart.data.Chart4DDataSeries;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartTypeInfo;
import chart.data.ChartValueMap;
import java.util.ArrayList;
import java.util.List;

public class Chart4DDataSet
extends ChartDataSet {
    double v1Min;
    double v1Max;
    double v2Min;
    double v2Max;
    double v3Min;
    double v3Max;
    double v4Min;
    double v4Max;
    ChartShowValueCondition[] cnd;

    public Chart4DDataSet(ChartDataSetModel chartDataSetModel, ChartDataSetInfo chartDataSetInfo) {
        super(chartDataSetModel, chartDataSetInfo);
    }

    public Chart4DDataSet(ChartDataSetModel chartDataSetModel, List list, ChartDataSetInfo chartDataSetInfo) {
        super(chartDataSetModel, chartDataSetInfo);
        this.dataBlock = list;
    }

    @Override
    public void initDataSeries() {
        int n = this.model.getSeriesCount();
        int n2 = this.model.getCategoryCount();
        this.serieses = new ArrayList();
        ChartValueMap chartValueMap = this.model.getValueMap();
        for (int i = 0; i < this.dataBlock.size(); i += 4) {
            List list = (List)this.dataBlock.get(i);
            List list2 = (List)this.dataBlock.get(i + 1);
            List list3 = (List)this.dataBlock.get(i + 2);
            List list4 = (List)this.dataBlock.get(i + 3);
            for (int j = 0; j < n; ++j) {
                Chart4DDataSeries chart4DDataSeries = new Chart4DDataSeries();
                List list5 = (List)list.get(j);
                List list6 = (List)list2.get(j);
                List list7 = (List)list3.get(j);
                List list8 = (List)list4.get(j);
                for (int k = 0; k < n2; ++k) {
                    Number number = chartValueMap.getValue(list5.get(k));
                    Number number2 = chartValueMap.getValue(list6.get(k));
                    Number number3 = chartValueMap.getValue(list7.get(k));
                    Number number4 = chartValueMap.getValue(list8.get(k));
                    chart4DDataSeries.addValue(number, number2, number3, number4);
                }
                this.serieses.add(chart4DDataSeries);
            }
        }
    }

    static List createStockFakeData(int n, int n2, double d, double d2) {
        double[][] dArray = new double[n * n2][4];
        for (int i = 0; i < n * n2; ++i) {
            double d3 = 1.0;
            dArray[i][0] = (double)(ChartDataSetModel.open[i % n] / 100.0f) * (d2 - d) * d3 + d;
            dArray[i][1] = (double)(ChartDataSetModel.high[i % n] / 100.0f) * (d2 - d) * d3 + d;
            dArray[i][2] = (double)(ChartDataSetModel.low[i % n] / 100.0f) * (d2 - d) * d3 + d;
            dArray[i][3] = (double)(ChartDataSetModel.close[i % n] / 100.0f) * (d2 - d) * d3 + d;
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            ArrayList arrayList2 = new ArrayList();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            block8: for (int j = 0; j < n; ++j) {
                switch (i % 4) {
                    case 0: {
                        arrayList3.add(new Double(dArray[i * n + j][0]));
                        continue block8;
                    }
                    case 1: {
                        arrayList3.add(new Double(dArray[i * n + j][1]));
                        continue block8;
                    }
                    case 2: {
                        arrayList3.add(new Double(dArray[i * n + j][2]));
                        continue block8;
                    }
                    case 3: {
                        arrayList3.add(new Double(dArray[i * n + j][3]));
                    }
                }
            }
            arrayList2.add(arrayList3);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    @Override
    public void calculateMinMax() {
        this.v1Min = 0.0;
        this.v2Min = 0.0;
        this.v3Min = 0.0;
        this.v4Min = 0.0;
        this.v1Max = 0.0;
        this.v2Max = 0.0;
        this.v3Max = 0.0;
        this.v4Max = 0.0;
        switch (this.datasetInfo.minmaxType) {
            case 0: {
                this.I();
                break;
            }
        }
    }

    private void I() {
        for (int i = 0; i < this.getSeriesSize(); ++i) {
            Chart4DDataSeries chart4DDataSeries = (Chart4DDataSeries)this.serieses.get(i);
            for (int j = 0; j < this.getCategorySize(); ++j) {
                double d;
                Number number = chart4DDataSeries.getV1(j);
                Number number2 = chart4DDataSeries.getV2(j);
                Number number3 = chart4DDataSeries.getV3(j);
                Number number4 = chart4DDataSeries.getV4(j);
                if (number != null) {
                    d = number.doubleValue();
                    this.v1Min = this.v1Min < d ? this.v1Min : d;
                    double d2 = this.v1Max = this.v1Max > d ? this.v1Max : d;
                }
                if (number2 != null) {
                    d = number2.doubleValue();
                    this.v2Min = this.v2Min < d ? this.v2Min : d;
                    double d3 = this.v2Max = this.v2Max > d ? this.v2Max : d;
                }
                if (number3 != null) {
                    d = number3.doubleValue();
                    this.v3Min = this.v3Min < d ? this.v3Min : d;
                    double d4 = this.v3Max = this.v3Max > d ? this.v3Max : d;
                }
                if (number4 == null) continue;
                d = number4.doubleValue();
                this.v4Min = this.v4Min < d ? this.v4Min : d;
                this.v4Max = this.v4Max > d ? this.v4Max : d;
            }
        }
    }

    public double getV1Min() {
        return this.v1Min;
    }

    public double getV1Max() {
        return this.v1Max;
    }

    public double getV2Min() {
        return this.v2Min;
    }

    public double getV2Max() {
        return this.v2Max;
    }

    public double getV3Min() {
        return this.v3Min;
    }

    public double getV3Max() {
        return this.v3Max;
    }

    public double getV4Min() {
        return this.v4Min;
    }

    public double getV4Max() {
        return this.v4Max;
    }

    @Override
    public double getMin() {
        double d = 0.0;
        d = d < this.v1Min ? d : this.v1Min;
        d = d < this.v2Min ? d : this.v2Min;
        d = d < this.v3Min ? d : this.v3Min;
        d = d < this.v4Min ? d : this.v4Min;
        return d;
    }

    @Override
    public double getMax() {
        double d = 0.0;
        d = d > this.v1Max ? d : this.v1Max;
        d = d > this.v2Max ? d : this.v2Max;
        d = d > this.v3Max ? d : this.v3Max;
        d = d > this.v4Max ? d : this.v4Max;
        return d;
    }

    public Number getV1(int n, int n2) {
        return ((Chart4DDataSeries)this.serieses.get(n)).getV1(n2);
    }

    public Number getV2(int n, int n2) {
        return ((Chart4DDataSeries)this.serieses.get(n)).getV2(n2);
    }

    public Number getV3(int n, int n2) {
        return ((Chart4DDataSeries)this.serieses.get(n)).getV3(n2);
    }

    public Number getV4(int n, int n2) {
        return ((Chart4DDataSeries)this.serieses.get(n)).getV4(n2);
    }

    @Override
    public List getLegendSeriesLabels() {
        ArrayList arrayList = new ArrayList();
        int n = ChartTypeInfo.getPrimType(this.datasetInfo.chartType);
        switch (n) {
            default: 
        }
        return arrayList;
    }

    @Override
    public List getFilterLegendSeriesLabels() {
        ArrayList arrayList = new ArrayList();
        int n = ChartTypeInfo.getPrimType(this.datasetInfo.chartType);
        switch (n) {
            default: 
        }
        return arrayList;
    }

    @Override
    public void setChartConditions(ChartPlatform chartPlatform) {
        if (chartPlatform.getShowValueConditions() != null) {
            int n = this.getShowValueBeginIndex();
            int n2 = this.getShowValueEndIndex();
            this.cnd = new ChartShowValueCondition[n2 - n];
            int n3 = this.getChartDataSetInfo().getChartType();
            int n4 = this.getChartDataSetInfo().getAxisInfo();
            String[][] stringArray = this.model.getAllShowValue();
            int n5 = n;
            int n6 = 0;
            while (n5 < n2) {
                int n7 = Integer.parseInt(stringArray[n5][0]);
                String string = stringArray[n5][1];
                ChartShowValueInfo chartShowValueInfo = new ChartShowValueInfo(n7, n3, n4, string);
                ChartShowValueCondition chartShowValueCondition = chartPlatform.getShowValueConditions().getShowValueCondition(chartShowValueInfo);
                this.cnd[n6] = chartShowValueCondition != null && chartShowValueCondition.getConditionType() != 0 ? chartPlatform.getShowValueConditions().getShowValueCondition(chartShowValueInfo) : chartPlatform.getShowValueConditions().getShowValueCondition(chartShowValueInfo);
                ++n5;
                ++n6;
            }
        }
    }

    @Override
    public ChartShowValueCondition getCondition(int n, int n2) {
        int n3;
        int n4;
        if (this.cnd != null && (n4 = n / (n3 = this.model.getSeriesCount() == 0 ? 1 : this.model.getSeriesCount())) >= 0 && n4 < this.cnd.length) {
            return this.cnd[n4];
        }
        return null;
    }
}

