/*
 * Decompiled with CFR 0.152.
 */
package chart.data;

import chart.ChartDefinition;
import chart.data.Chart1DDataSet;
import chart.data.Chart2DDataSet;
import chart.data.Chart3DDataSet;
import chart.data.Chart4DDataSet;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDefaultValueMap;
import chart.data.ChartTypeInfo;
import chart.data.ChartValueMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class ChartDataSetModel {
    public static final int DATASET_TYPE_STANDARD = 0;
    public static final int DATASET_TYPE_DYNAMIC = 1;
    int type = 0;
    private boolean SEDU;
    private boolean add;
    private List addAll = new ArrayList();
    private List axisInfo = new ArrayList();
    private List byteValue;
    private ChartDataSetInfo[] calculateMinMax;
    private int[] canSwitchGroup;
    private int chartType = 0;
    private int clone = 0;
    private int colEnd;
    List datasets = new ArrayList();
    boolean isOneGroup = false;
    boolean isOneGroupForBar;
    private boolean colStart;
    TableRange offset = new TableRange();
    ChartValueMap valueMap;
    ChartDataFilter categoryFilter;
    ChartDataFilter seriesFilter;
    ChartDataFilter primFilter;
    ChartDataFilter secFilter;
    ChartDataFilter hintFilter;
    ChartDataFilter hintPercentFilter;
    private static String[] createBubbleFakeData = new String[]{"Series 1", "Series 2", "Series 3", "Series 4"};
    private static String[] createFakeData = new String[]{"Category 1", "Category 2", "Category 3", "Category 4"};
    private static String[] createFakeDataForBullet = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
    private static float[][] createScatterFakeData = new float[][]{{12.42f, 10.5f, 26.3f, 37.9f, 45.5f, 50.99f, 55.23f, 48.32f, 63.87f, 50.56f, 42.42f, 45.5f, 36.3f, 55.7f, 85.5f, 73.99f, 65.23f, 68.32f, 83.87f, 92.56f}, {14.6f, 16.9f, 29.9f, 45.7f, 46.0f, 60.65f, 56.78f, 52.65f, 68.99f, 55.68f, 44.6f, 46.9f, 39.9f, 55.7f, 86.0f, 75.65f, 66.78f, 69.65f, 88.99f, 95.68f}, {11.55f, 7.99f, 24.32f, 35.7f, 42.88f, 45.22f, 54.32f, 39.88f, 59.66f, 48.32f, 41.55f, 42.99f, 34.32f, 45.7f, 82.88f, 71.22f, 64.32f, 59.88f, 82.66f, 88.32f}, {13.56f, 9.87f, 25.66f, 39.1f, 44.6f, 53.54f, 55.0f, 40.55f, 65.33f, 50.56f, 43.56f, 43.87f, 34.32f, 49.1f, 84.6f, 72.54f, 65.0f, 65.55f, 85.33f, 93.56f}};
    static float[] open = createScatterFakeData[0];
    static float[] high = createScatterFakeData[1];
    static float[] low = createScatterFakeData[2];
    static float[] close = createScatterFakeData[3];
    private String[] createStockFakeData;
    private boolean doubleValue = false;
    protected String categoryNmae;
    protected String seriesN;
    private boolean equals;
    private int[] filter;
    private int[] floatValue;
    private String[][] format;
    private boolean get = false;
    List orignValueNames = null;
    boolean swapedGroups = false;
    boolean canSwapGroups = true;
    boolean swapedCategoryAndSeries;
    private int getAllShowValues = 0;
    private int getCategoryCount;
    private int getCategoryEnd;
    List motionDataCube = null;
    List motionGroupNames = null;
    int motionFieldIndex = 0;
    boolean showMotionHistory = false;
    double xmax = 0.0;
    double xmin = 0.0;
    double ymax = 0.0;
    double ymin = 0.0;
    double zmax = 0.0;
    double zmin = 0.0;

    public ChartDataSetModel() {
    }

    public ChartDataSetModel(List arrayList, List arrayList2, List arrayList3, ChartValueMap chartValueMap, ChartDataSetInfo[] chartDataSetInfoArray, int[] nArray) {
        this();
        int n;
        this.valueMap = chartValueMap;
        if (arrayList != null && arrayList.size() > 0) {
            this.chartType = arrayList.size();
            this.addAll = arrayList;
            for (n = 0; n < arrayList.size(); ++n) {
                if (arrayList.get(n) != null) continue;
                this.addAll.set(n, "");
            }
        } else {
            int n2;
            int n3;
            this.chartType = 1;
            this.clone = 1;
            arrayList = new ArrayList<String>();
            for (n3 = 0; n3 < this.chartType; ++n3) {
                arrayList.add("");
            }
            this.addAll = arrayList;
            if (chartDataSetInfoArray == null || chartDataSetInfoArray.length == 0) {
                chartDataSetInfoArray = new ChartDataSetInfo[]{new ChartDataSetInfo()};
            }
            this.calculateMinMax = chartDataSetInfoArray;
            n3 = chartDataSetInfoArray.length;
            arrayList3 = new ArrayList();
            ArrayList<Object> arrayList4 = new ArrayList<Object>();
            for (int i = 0; i < this.chartType; ++i) {
                arrayList4.add(null);
            }
            ArrayList<ArrayList<Object>> arrayList5 = new ArrayList<ArrayList<Object>>();
            arrayList5.add(arrayList4);
            if (n3 == 1) {
                nArray = new int[]{0, 1};
                n2 = ChartTypeInfo.getSeriesType(chartDataSetInfoArray[0].getChartType());
                switch (n2) {
                    case 0: {
                        this.colEnd = 1;
                        break;
                    }
                    case 65536: {
                        this.colEnd = 2;
                        break;
                    }
                    case 131072: {
                        this.colEnd = 3;
                        break;
                    }
                    case 196608: {
                        this.colEnd = 4;
                    }
                }
                for (int i = 0; i < this.colEnd; ++i) {
                    arrayList3.add(arrayList5);
                }
            }
            if (n3 > 1) {
                this.colEnd = n3;
                nArray = new int[n3 + 1];
                for (n2 = 0; n2 < n3 + 1; ++n2) {
                    nArray[n2] = n2;
                }
                for (n2 = 0; n2 < this.colEnd; ++n2) {
                    arrayList3.add(arrayList5);
                }
            }
            this.canSwitchGroup = nArray;
            this.byteValue = arrayList3;
            arrayList2 = new ArrayList<String>();
            arrayList2.add("");
            this.axisInfo = arrayList2;
            this.isOneGroup = true;
            return;
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            this.clone = arrayList2.size();
            this.axisInfo = arrayList2;
            for (n = 0; n < arrayList2.size(); ++n) {
                if (arrayList2.get(n) != null) continue;
                this.axisInfo.set(n, "");
            }
        } else {
            this.axisInfo.add("");
            this.clone = 1;
            this.isOneGroup = true;
        }
        if (this.byteValue == null) {
            this.byteValue = new ArrayList();
        }
        this.byteValue.addAll(arrayList3);
        this.colEnd = this.byteValue.size();
        if (chartDataSetInfoArray == null) {
            chartDataSetInfoArray = new ChartDataSetInfo[]{new ChartDataSetInfo()};
        } else {
            this.calculateMinMax = chartDataSetInfoArray;
        }
        this.canSwitchGroup = nArray;
    }

    public void createFakeData(ChartDefinition chartDefinition, double[] dArray) {
        int n;
        this.byteValue = new ArrayList();
        this.valueMap = new ChartDefaultValueMap();
        this.calculateMinMax = chartDefinition.getChartDataSetInfos();
        boolean bl = false;
        for (int i = 0; i < this.calculateMinMax.length; ++i) {
            this.type = this.calculateMinMax[i].getChartType();
            if (ChartTypeInfo.getPrimType(this.type) != 10) continue;
            bl = true;
            break;
        }
        String[] stringArray = bl ? createFakeDataForBullet : createFakeData;
        for (n = 0; n < stringArray.length; ++n) {
            this.addAll.add(stringArray[n]);
        }
        this.chartType = stringArray.length;
        if (chartDefinition.getSeries() != null) {
            for (n = 0; n < createBubbleFakeData.length; ++n) {
                this.axisInfo.add(createBubbleFakeData[n]);
            }
            this.clone = stringArray.length;
        } else {
            this.axisInfo.add("");
            this.clone = 1;
            this.isOneGroup = true;
        }
        this.createStockFakeData = chartDefinition.getFakeDataValueNames();
        this.colEnd = chartDefinition.getIndexedFakeDataValueNames().length;
        this.canSwitchGroup = chartDefinition.getSeparatingIndex();
        for (int i = 0; i < 3; ++i) {
            if (dArray[i * 2 + 1] - dArray[i * 2 + 0] < Double.MIN_VALUE) {
                int n2 = i * 2 + 1;
                dArray[n2] = dArray[n2] + 100.0;
            }
            if (!(dArray[i * 2 + 1] < dArray[i * 2 + 0])) continue;
            double d = dArray[i * 2 + 1];
            dArray[i * 2 + 1] = dArray[i * 2 + 0];
            dArray[i * 2 + 0] = d;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        block21: for (int i = 0; i < this.calculateMinMax.length; ++i) {
            double d3;
            double d4;
            n = this.calculateMinMax[i].getChartType();
            int n3 = ChartTypeInfo.getSeriesType(n);
            int n4 = ChartTypeInfo.getPrimType(n);
            if (this.calculateMinMax[i].axisInfo == 0) {
                d4 = dArray[2];
                d3 = dArray[3];
            } else {
                d4 = dArray[4];
                d3 = dArray[5];
            }
            int n5 = this.canSwitchGroup[i + 1] - this.canSwitchGroup[i];
            switch (n3) {
                case 0: {
                    switch (n4) {
                        case 11: {
                            this.byteValue.addAll(Chart1DDataSet.createFakeDataForBullet(this.chartType, this.clone, n5, d4, d3, n5 > 1 || this.calculateMinMax.length > 1, this.filter));
                            continue block21;
                        }
                    }
                    this.byteValue.addAll(Chart1DDataSet.createFakeData(this.chartType, this.clone, n5, d4, d3, n5 > 1 || this.calculateMinMax.length > 1));
                    continue block21;
                }
                case 65536: {
                    switch (n4) {
                        case 8: {
                            this.byteValue.addAll(Chart2DDataSet.createScatterFakeData(this.chartType, this.clone, n5, d4, d3, d, d2));
                            break;
                        }
                        case 10: {
                            this.byteValue.addAll(Chart2DDataSet.createStockFakeData(this.chartType, n5, d4, d3));
                        }
                    }
                    continue block21;
                }
                case 131072: {
                    switch (n4) {
                        case 9: {
                            this.byteValue.addAll(Chart3DDataSet.createBubbleFakeData(this.chartType, this.clone, n5, d4, d3, d, d2));
                            break;
                        }
                        case 10: {
                            this.byteValue.addAll(Chart3DDataSet.createStockFakeData(this.chartType, n5, d4, d3));
                        }
                    }
                    continue block21;
                }
                case 196608: {
                    this.byteValue.addAll(Chart4DDataSet.createStockFakeData(this.chartType, n5, d4, d3));
                }
            }
        }
    }

    public void createFakeData(ChartDefinition chartDefinition, double[] dArray, String[] stringArray, String[] stringArray2) {
        int n;
        this.byteValue = new ArrayList();
        this.valueMap = new ChartDefaultValueMap();
        this.calculateMinMax = chartDefinition.getChartDataSetInfos();
        boolean bl = false;
        for (int i = 0; i < this.calculateMinMax.length; ++i) {
            this.type = this.calculateMinMax[i].getChartType();
            if (ChartTypeInfo.getPrimType(this.type) != 10) continue;
            bl = true;
            break;
        }
        String[] stringArray3 = bl ? createFakeDataForBullet : stringArray;
        for (n = 0; n < stringArray3.length; ++n) {
            this.addAll.add(stringArray3[n]);
        }
        this.chartType = stringArray3.length;
        if (chartDefinition.getSeries() != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.axisInfo.add(stringArray2[n]);
            }
            this.clone = stringArray3.length;
        } else {
            this.axisInfo.add("");
            this.clone = 1;
            this.isOneGroup = true;
        }
        this.createStockFakeData = chartDefinition.getFakeDataValueNames();
        this.colEnd = chartDefinition.getIndexedFakeDataValueNames().length;
        this.canSwitchGroup = chartDefinition.getSeparatingIndex();
        for (int i = 0; i < 3; ++i) {
            if (dArray[i * 2 + 1] - dArray[i * 2 + 0] < Double.MIN_VALUE) {
                int n2 = i * 2 + 1;
                dArray[n2] = dArray[n2] + 100.0;
            }
            if (!(dArray[i * 2 + 1] < dArray[i * 2 + 0])) continue;
            double d = dArray[i * 2 + 1];
            dArray[i * 2 + 1] = dArray[i * 2 + 0];
            dArray[i * 2 + 0] = d;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        block21: for (int i = 0; i < this.calculateMinMax.length; ++i) {
            double d3;
            double d4;
            n = this.calculateMinMax[i].getChartType();
            int n3 = ChartTypeInfo.getSeriesType(n);
            int n4 = ChartTypeInfo.getPrimType(n);
            if (this.calculateMinMax[i].axisInfo == 0) {
                d4 = dArray[2];
                d3 = dArray[3];
            } else {
                d4 = dArray[4];
                d3 = dArray[5];
            }
            int n5 = this.canSwitchGroup[i + 1] - this.canSwitchGroup[i];
            switch (n3) {
                case 0: {
                    switch (n4) {
                        case 11: {
                            this.byteValue.addAll(Chart1DDataSet.createFakeDataForBullet(this.chartType, this.clone, n5, d4, d3, n5 > 1 || this.calculateMinMax.length > 1, this.filter));
                            continue block21;
                        }
                    }
                    this.byteValue.addAll(Chart1DDataSet.createFakeData(this.chartType, this.clone, n5, d4, d3, n5 > 1 || this.calculateMinMax.length > 1));
                    continue block21;
                }
                case 65536: {
                    switch (n4) {
                        case 8: {
                            this.byteValue.addAll(Chart2DDataSet.createScatterFakeData(this.chartType, this.clone, n5, d4, d3, d, d2));
                            break;
                        }
                        case 10: {
                            this.byteValue.addAll(Chart2DDataSet.createStockFakeData(this.chartType, n5, d4, d3));
                        }
                    }
                    continue block21;
                }
                case 131072: {
                    switch (n4) {
                        case 9: {
                            this.byteValue.addAll(Chart3DDataSet.createBubbleFakeData(this.chartType, this.clone, n5, d4, d3, d, d2));
                            break;
                        }
                        case 10: {
                            this.byteValue.addAll(Chart3DDataSet.createStockFakeData(this.chartType, n5, d4, d3));
                        }
                    }
                    continue block21;
                }
                case 196608: {
                    this.byteValue.addAll(Chart4DDataSet.createStockFakeData(this.chartType, n5, d4, d3));
                }
            }
        }
    }

    public void createRealtimeChartData(ChartDefinition chartDefinition) {
        int n;
        int n2;
        int n3;
        this.valueMap = new ChartDefaultValueMap();
        this.calculateMinMax = chartDefinition.getChartDataSetInfos();
        List list = chartDefinition.getAllShowValues();
        this.createStockFakeData = new String[list.size()];
        for (n3 = 0; n3 < list.size(); ++n3) {
            this.createStockFakeData[n3] = ((String[])list.get(n3))[1];
        }
        n3 = chartDefinition.getDisplayValueNumber();
        int n4 = n3 = n3 < 1 ? 1 : n3;
        if (this.addAll != null) {
            n2 = n3 - this.addAll.size();
            if (n2 > 0) {
                for (n = 0; n < n2; ++n) {
                    this.addAll.add("");
                }
            } else if (n2 < 0) {
                for (n = 0; n < -n2 && this.addAll.size() > 0; ++n) {
                    this.addAll.remove(0);
                }
            }
        }
        if (this.byteValue != null) {
            this.makeRealTimeData(this.byteValue, n3);
        }
        this.chartType = n3;
        this.clone = 1;
        this.isOneGroup = true;
        this.colEnd = chartDefinition.getIndexedFakeDataValueNames().length;
        this.canSwitchGroup = chartDefinition.getSeparatingIndex();
        for (n2 = 0; n2 < this.calculateMinMax.length; ++n2) {
            n = this.canSwitchGroup[n2 + 1] - this.canSwitchGroup[n2];
            this.type = this.calculateMinMax[n2].getChartType();
        }
        this.canSwapGroups = false;
    }

    void makeRealTimeData(List list, int n) {
        block5: {
            int n2;
            block6: {
                if (list == null) {
                    return;
                }
                if (list.size() > 0 && list.get(0) != null && list.get(0) instanceof List) {
                    for (int i = 0; i < list.size(); ++i) {
                        this.makeRealTimeData((List)list.get(i), n);
                    }
                    return;
                }
                if (list.size() != 0 && (list.size() <= 0 || list.get(0) == null || list.get(0) instanceof List) && (list.size() <= 0 || list.get(0) != null)) break block5;
                n2 = n - list.size();
                if (n2 <= 0) break block6;
                for (int i = 0; i < n2; ++i) {
                    list.add(null);
                }
                break block5;
            }
            if (n2 >= 0) break block5;
            for (int i = 0; i < -n2 && this.addAll.size() > 0; ++i) {
                list.remove(0);
            }
        }
    }

    private double SEDU(Number number) {
        if (number == null) {
            return 0.0;
        }
        if (number instanceof Integer) {
            return ((Integer)number).intValue();
        }
        if (number instanceof Byte) {
            return ((Byte)number).byteValue();
        }
        if (number instanceof Short) {
            return ((Short)number).shortValue();
        }
        if (number instanceof Long) {
            return ((Long)number).longValue();
        }
        if (number instanceof Float) {
            return ((Float)number).floatValue();
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return Double.parseDouble(number.toString());
    }

    public void addValueNames() {
        if (this.format == null || this.get) {
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        for (int i = 0; i < this.format.length; ++i) {
            String[] stringArray = this.format[i];
            int n2 = Integer.parseInt(stringArray[0]);
            if (n2 == 0) {
                ++n;
                continue;
            }
            if (n2 == 2) {
                this.createStockFakeData[n] = new String(stringArray[1]);
                ++n;
                continue;
            }
            String string = new String(stringArray[1]);
            arrayList.add(string);
            arrayList.add(new Integer(i));
        }
        if (arrayList.size() > 0) {
            if (this.format.length > this.colEnd) {
                this.colEnd += arrayList.size() / 2;
            }
            if (this.createStockFakeData.length == this.format.length) {
                return;
            }
            String[] stringArray = (String[])this.createStockFakeData.clone();
            this.createStockFakeData = new String[arrayList.size() / 2 + this.createStockFakeData.length];
            for (n = 0; n < arrayList.size(); n += 2) {
                this.createStockFakeData[((Integer)arrayList.get((int)(n + 1))).intValue()] = (String)arrayList.get(n);
            }
            int n3 = 0;
            for (n = 0; n < this.createStockFakeData.length; ++n) {
                if (this.createStockFakeData[n] != null) continue;
                this.createStockFakeData[n] = stringArray[n3];
                ++n3;
            }
        }
        this.get = true;
    }

    public void replaceShowValueNames() {
        if (this.format == null) {
            return;
        }
        for (int i = 0; i < this.format.length && i < this.createStockFakeData.length; ++i) {
            this.createStockFakeData[i] = this.createStockFakeData[i] == null ? null : (this.createStockFakeData[i] = this.format[i][0].equals("2") ? new String(this.format[i][1]) : this.createStockFakeData[i]);
        }
    }

    private void add() {
        if (this.floatValue == null || this.format == null) {
            return;
        }
        block4: for (int i = 0; i < this.floatValue.length; ++i) {
            int n = this.floatValue[i];
            switch (n) {
                case 2: {
                    int n2;
                    List list;
                    int n3;
                    List list2 = (List)this.byteValue.get(i);
                    if (list2.size() <= 0) continue block4;
                    double d = 0.0;
                    int n4 = 0;
                    for (n3 = 0; n3 < list2.size(); ++n3) {
                        list = (List)list2.get(n3);
                        for (n2 = 0; n2 < list.size(); ++n2) {
                            Object e = list.get(n2);
                            if (e == null || e.equals("")) continue;
                            if (e instanceof Number) {
                                d += this.SEDU((Number)e);
                            } else if (e instanceof String) {
                                d += Double.parseDouble((String)e);
                            }
                            ++n4;
                        }
                    }
                    d = n4 != 0 ? d / (double)n4 : 0.0;
                    for (n3 = 0; n3 < list2.size(); ++n3) {
                        list = (List)list2.get(n3);
                        for (n2 = 0; n2 < list.size(); ++n2) {
                            list.set(n2, new Double(d));
                        }
                    }
                    continue block4;
                }
                case 1: {
                    this.addAll(i);
                    continue block4;
                }
            }
        }
    }

    private void addAll(int n) {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = this.format[n];
        String string = stringArray[2];
        if (!string.equals("")) {
            for (int i = 0; i < this.clone; ++i) {
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                for (int j = 0; j < this.chartType; ++j) {
                    arrayList2.add(new Double(string));
                }
                arrayList.add(arrayList2);
            }
        } else {
            for (int i = 0; i < this.clone; ++i) {
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                for (int j = 0; j < this.chartType; ++j) {
                    arrayList3.add(new Double(0.0));
                }
                arrayList.add(arrayList3);
            }
        }
        if (this.byteValue.size() < this.floatValue.length) {
            this.byteValue.add(n, arrayList);
        }
    }

    private void axisInfo() {
        if (this.floatValue == null || this.format == null) {
            return;
        }
        block4: for (int i = 0; i < this.floatValue.length; ++i) {
            int n = this.floatValue[i];
            switch (n) {
                case 2: {
                    ArrayList arrayList2;
                    int n2;
                    double d = 0.0;
                    int n3 = 0;
                    List list = (List)((List)this.byteValue.get(i)).get(0);
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        arrayList2 = list.get(n2);
                        if (arrayList2 == null) continue;
                        ++n3;
                        if (((Object)arrayList2).equals("")) continue;
                        if (arrayList2 instanceof Number) {
                            d += this.SEDU((Number)((Object)arrayList2));
                            continue;
                        }
                        if (!(arrayList2 instanceof String)) continue;
                        d += Double.parseDouble((String)((Object)arrayList2));
                    }
                    for (n2 = 0; n2 < list.size(); ++n2) {
                        list.set(n2, n3 != 0 ? d / (double)n3 : 0.0);
                    }
                    continue block4;
                }
                case 1: {
                    int n4;
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    arrayList.add(arrayList2);
                    String[] stringArray = this.format[i];
                    String string = stringArray[2];
                    if (string.equals("")) {
                        for (n4 = 0; n4 < this.chartType; ++n4) {
                            arrayList2.add(new Double(0.0));
                        }
                    } else {
                        for (n4 = 0; n4 < this.chartType; ++n4) {
                            arrayList2.add(new Double(Double.parseDouble(string)));
                        }
                    }
                    if (this.byteValue.size() >= this.floatValue.length) continue block4;
                    this.byteValue.add(i, arrayList);
                    continue block4;
                }
            }
        }
    }

    public void initSpecialValue() {
        if (this.byteValue == null || this.floatValue == null) {
            return;
        }
        if (this.clone == 1) {
            this.axisInfo();
        } else if (this.clone > 1) {
            this.add();
        }
    }

    public void init() {
        this.datasets = new ArrayList();
        this.testSwitchGroup();
        this.calculateMinMax();
        int n = this.byteValue.size();
        List list = null;
        if (this.motionDataCube == null) {
            list = this.categoryNmae(this.byteValue);
            list = this.byteValue(list);
        }
        ChartDataSet chartDataSet = null;
        int n2 = 1;
        int n3 = 0;
        if (this.motionDataCube != null) {
            int n4;
            int n5;
            int n6;
            int n7 = this.motionDataCube.size();
            double d = 0.0;
            ChartDataSet chartDataSet2 = null;
            block22: for (n6 = 0; n6 < n7; ++n6) {
                List list2;
                this.byteValue = list2 = (List)this.motionDataCube.get(n6);
                this.initSpecialValue();
                list2 = this.byteValue;
                list = this.categoryNmae(list2);
                list = this.byteValue(list);
                n5 = 0;
                n4 = this.colEnd;
                switch (ChartTypeInfo.getSeriesType(this.calculateMinMax[0].chartType)) {
                    case 0: {
                        chartDataSet2 = new Chart1DDataSet(this, list == null ? null : list.subList(n5, n4), this.calculateMinMax[0]);
                        ((Chart1DDataSet)chartDataSet2).setValuesName(this.createStockFakeData, n5, n4);
                        break;
                    }
                    case 65536: {
                        chartDataSet2 = new Chart2DDataSet(this, list == null ? null : list.subList(n5, n4), this.calculateMinMax[0]);
                        break;
                    }
                    case 131072: {
                        chartDataSet2 = new Chart3DDataSet(this, list == null ? null : list.subList(n5, n4), this.calculateMinMax[0]);
                        ((Chart3DDataSet)chartDataSet2).setValuesName(this.createStockFakeData, n5, n4);
                        break;
                    }
                    case 196608: {
                        chartDataSet2 = new Chart4DDataSet(this, list == null ? null : list.subList(n5, n4), this.calculateMinMax[0]);
                    }
                }
                chartDataSet2.setShowValueBeginIndex(n5);
                chartDataSet2.setShowValueEndIndex(n4);
                if (this.isSwapGroup() && this.colEnd == 1 && this.getCategoryNmae() == null) {
                    chartDataSet2.setShowValueEndIndex(this.canSwitchGroup[1]);
                }
                chartDataSet2.initDataSeries();
                chartDataSet2.calculateMinMax();
                switch (ChartTypeInfo.getSeriesType(this.calculateMinMax[0].chartType)) {
                    case 0: {
                        d = ((Chart1DDataSet)chartDataSet2).getMax();
                        this.ymax = this.ymax < d ? d : this.ymax;
                        d = ((Chart1DDataSet)chartDataSet2).getMin();
                        this.ymin = this.ymin > d ? d : this.ymin;
                        continue block22;
                    }
                    case 131072: {
                        d = ((Chart3DDataSet)chartDataSet2).getYMax();
                        this.ymax = this.ymax < d ? d : this.ymax;
                        d = ((Chart3DDataSet)chartDataSet2).getYMin();
                        this.ymin = this.ymin > d ? d : this.ymin;
                        d = ((Chart3DDataSet)chartDataSet2).getXMax();
                        this.xmax = this.xmax < d ? d : this.xmax;
                        d = ((Chart3DDataSet)chartDataSet2).getXMin();
                        this.xmin = this.xmin > d ? d : this.xmin;
                        d = ((Chart3DDataSet)chartDataSet2).getZMax();
                        this.zmax = this.zmax < d ? d : this.zmax;
                        d = ((Chart3DDataSet)chartDataSet2).getZMin();
                        this.zmin = this.zmin > d ? d : this.zmin;
                        continue block22;
                    }
                }
            }
            if (!this.showMotionHistory || ChartTypeInfo.getPrimType(this.calculateMinMax[0].chartType) != 9) {
                n3 = this.motionFieldIndex;
                n2 = n3 + 1;
            } else {
                n3 = 0;
                n2 = this.motionFieldIndex + 1;
                n2 = n2 > this.motionDataCube.size() ? this.motionDataCube.size() : n2;
            }
            for (n6 = n3; n6 < n2; ++n6) {
                int n8 = ChartTypeInfo.getSeriesType(this.calculateMinMax[0].chartType);
                this.byteValue = (List)this.motionDataCube.get(n6);
                this.initSpecialValue();
                list = this.categoryNmae(this.byteValue);
                list = this.byteValue(list);
                n5 = 0;
                n4 = this.colEnd;
                switch (n8) {
                    case 0: {
                        chartDataSet = new Chart1DDataSet(this, list == null ? null : list.subList(n5, n4), this.calculateMinMax[0]);
                        ((Chart1DDataSet)chartDataSet).setValuesName(this.createStockFakeData, n5, n4);
                        break;
                    }
                    case 65536: {
                        chartDataSet = new Chart2DDataSet(this, list == null ? null : list.subList(n5, n4), this.calculateMinMax[0]);
                        break;
                    }
                    case 131072: {
                        chartDataSet = new Chart3DDataSet(this, list == null ? null : list.subList(n5, n4), this.calculateMinMax[0]);
                        ((Chart3DDataSet)chartDataSet).setValuesName(this.createStockFakeData, n5, n4);
                        break;
                    }
                    case 196608: {
                        chartDataSet = new Chart4DDataSet(this, list == null ? null : list.subList(n5, n4), this.calculateMinMax[0]);
                    }
                }
                if (chartDataSet != null) {
                    chartDataSet.setShowValueBeginIndex(n5);
                    chartDataSet.setShowValueEndIndex(n4);
                    if (this.isSwapGroup() && this.colEnd == 1 && this.getCategoryNmae() == null) {
                        chartDataSet.setShowValueEndIndex(this.canSwitchGroup[1]);
                    }
                }
                if (this.calculateMinMax[0].axisInfo == 0 && this.primFilter != null) {
                    chartDataSet.setDataFilter(this.primFilter);
                }
                chartDataSet.setDataSetIndex(n6);
                chartDataSet.initDataSeries();
                chartDataSet.calculateMinMax();
                this.datasets.add(chartDataSet);
            }
        } else {
            for (int i = 0; i < this.calculateMinMax.length; ++i) {
                int n9 = this.canSwitchGroup[i];
                int n10 = this.canSwitchGroup[i + 1] > this.colEnd ? this.colEnd : this.canSwitchGroup[i + 1];
                int n11 = ChartTypeInfo.getSeriesType(this.calculateMinMax[i].chartType);
                switch (n11) {
                    case 0: {
                        chartDataSet = new Chart1DDataSet(this, list == null ? null : list.subList(n9, n10), this.calculateMinMax[i]);
                        ((Chart1DDataSet)chartDataSet).setValuesName(this.createStockFakeData, n9, n10);
                        break;
                    }
                    case 65536: {
                        chartDataSet = new Chart2DDataSet(this, list == null ? null : list.subList(n9, n10), this.calculateMinMax[i]);
                        break;
                    }
                    case 131072: {
                        chartDataSet = new Chart3DDataSet(this, list == null ? null : list.subList(n9, n10), this.calculateMinMax[i]);
                        ((Chart3DDataSet)chartDataSet).setValuesName(this.createStockFakeData, n9, n10);
                        break;
                    }
                    case 196608: {
                        chartDataSet = new Chart4DDataSet(this, list == null ? null : list.subList(n9, n10), this.calculateMinMax[i]);
                    }
                }
                if (chartDataSet != null) {
                    chartDataSet.setShowValueBeginIndex(n9);
                    chartDataSet.setShowValueEndIndex(n10);
                    if (this.isSwapGroup() && this.colEnd == 1 && this.getCategoryNmae() == null) {
                        chartDataSet.setShowValueEndIndex(this.canSwitchGroup[i + 1]);
                    }
                }
                if (this.calculateMinMax[i].axisInfo == 0 && this.primFilter != null) {
                    chartDataSet.setDataFilter(this.primFilter);
                }
                if (i == 1 && this.secFilter != null) {
                    chartDataSet.setDataFilter(this.secFilter);
                }
                chartDataSet.setDataSetIndex(i);
                chartDataSet.initDataSeries();
                if (this.getAllShowValues != 1 && this.getAllShowValues != 2) {
                    chartDataSet.calculateMinMax();
                }
                this.datasets.add(chartDataSet);
            }
        }
    }

    private List byteValue(List arrayList) {
        List list;
        int n;
        if (!this.SEDU && !this.add) {
            return arrayList;
        }
        ArrayList<List> arrayList2 = null;
        if (this.add) {
            arrayList2 = new ArrayList<List>();
            for (n = 0; n < arrayList.size(); ++n) {
                list = (List)arrayList.get(n);
                list = this.chartType(list);
                arrayList2.add(list);
            }
        }
        if (this.SEDU) {
            ArrayList<List> arrayList3 = arrayList2 == null ? arrayList : arrayList2;
            arrayList2 = new ArrayList();
            for (n = 0; n < arrayList3.size(); ++n) {
                list = (List)arrayList3.get(n);
                ArrayList<List> arrayList4 = new ArrayList<List>();
                for (int i = 0; i < list.size(); ++i) {
                    List list2 = (List)list.get(i);
                    list2 = this.chartType(list2);
                    arrayList4.add(list2);
                }
                arrayList2.add(arrayList4);
            }
        }
        return arrayList2;
    }

    private void calculateMinMax() {
        this.isOneGroupForBar = this.isOneGroup && this.calculateMinMax.length == 1 && (ChartTypeInfo.getPrimType(this.calculateMinMax[0].chartType) == 0 || ChartTypeInfo.getPrimType(this.calculateMinMax[0].chartType) == 1) && this.colEnd == 1;
        boolean bl = this.colStart;
        boolean bl2 = this.colStart = this.isOneGroupForBar && this.calculateMinMax[0].minmaxType != 0;
        if (bl ^ this.colStart) {
            this.categoryFilter();
        }
    }

    public void testSwitchGroup() {
        if (this.canSwitchGroup()) {
            if (this.isOneGroup) {
                if (this.colEnd > 1) {
                    this.canSwapGroups();
                }
            } else {
                this.categoryFilter();
            }
        }
    }

    public boolean canSwitchGroup() {
        int n = ChartTypeInfo.getPrimType(this.calculateMinMax[0].chartType);
        return this.canSwapGroups && this.doubleValue && this.calculateMinMax.length == 1 && n != 9 && n != 8 && n != 10 && n != 11 && n != 13;
    }

    private void canSwapGroups() {
        int n;
        Object[][][] objectArray = new Object[this.byteValue.size()][this.axisInfo.size()][this.addAll.size()];
        for (int i = 0; i < this.byteValue.size(); ++i) {
            for (int j = 0; j < this.axisInfo.size(); ++j) {
                for (int k = 0; k < this.addAll.size(); ++k) {
                    objectArray[i][j][k] = ((List)((List)this.byteValue.get(i)).get(j)).get(k);
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.axisInfo.size(); ++i) {
            ArrayList arrayList2 = new ArrayList();
            for (int j = 0; j < this.addAll.size(); ++j) {
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                for (n = 0; n < this.byteValue.size(); ++n) {
                    arrayList3.add(objectArray[n][i][j]);
                }
                arrayList2.add(arrayList3);
            }
            arrayList.add(arrayList2);
        }
        this.byteValue = arrayList;
        List list = this.addAll;
        ArrayList<String> arrayList4 = new ArrayList<String>();
        int n2 = this.createStockFakeData.length;
        for (n = 0; n < n2; ++n) {
            arrayList4.add(this.createStockFakeData[n]);
        }
        this.addAll = arrayList4;
        this.chartType = this.createStockFakeData.length;
        this.axisInfo = list;
        this.clone = this.axisInfo.size();
        this.colEnd = 1;
        n = this.offset.colStart;
        this.offset.colStart = this.offset.rowStart;
        this.offset.rowStart = n;
        n = this.offset.colEnd;
        this.offset.colEnd = this.offset.rowEnd;
        this.offset.rowEnd = n;
        ChartDataFilter chartDataFilter = this.categoryFilter;
        this.categoryFilter = this.seriesFilter;
        this.seriesFilter = chartDataFilter;
        boolean bl = this.SEDU;
        this.SEDU = this.add;
        this.add = bl;
        this.doubleValue = true;
        this.isOneGroup = false;
        this.swapedGroups = true;
    }

    private void categoryFilter() {
        int n;
        Object[][][] objectArray;
        if (this.motionDataCube != null) {
            objectArray = new ArrayList();
            for (n = 0; n < this.motionDataCube.size(); ++n) {
                List list = (List)this.motionDataCube.get(n);
                Object[][][] objectArray2 = new Object[list.size()][this.axisInfo.size()][this.addAll.size()];
                for (int i = 0; i < list.size(); ++i) {
                    for (int j = 0; j < this.axisInfo.size(); ++j) {
                        for (int k = 0; k < this.addAll.size(); ++k) {
                            objectArray2[i][j][k] = ((List)((List)list.get(i)).get(j)).get(k);
                        }
                    }
                }
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < list.size(); ++i) {
                    ArrayList arrayList2 = new ArrayList();
                    for (int j = 0; j < this.addAll.size(); ++j) {
                        ArrayList<Object> arrayList3 = new ArrayList<Object>();
                        for (int k = 0; k < this.axisInfo.size(); ++k) {
                            arrayList3.add(objectArray2[i][k][j]);
                        }
                        arrayList2.add(arrayList3);
                    }
                    arrayList.add(arrayList2);
                }
                objectArray.add(arrayList);
            }
            this.motionDataCube = objectArray;
        } else {
            objectArray = new Object[this.byteValue.size()][this.axisInfo.size()][this.addAll.size()];
            for (int i = 0; i < this.byteValue.size(); ++i) {
                for (int j = 0; j < this.axisInfo.size(); ++j) {
                    for (int k = 0; k < this.addAll.size(); ++k) {
                        objectArray[i][j][k] = ((List)((List)this.byteValue.get(i)).get(j)).get(k);
                    }
                }
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.byteValue.size(); ++i) {
                ArrayList arrayList4 = new ArrayList();
                for (int j = 0; j < this.addAll.size(); ++j) {
                    ArrayList<Object> arrayList5 = new ArrayList<Object>();
                    for (int k = 0; k < this.axisInfo.size(); ++k) {
                        arrayList5.add(objectArray[i][k][j]);
                    }
                    arrayList4.add(arrayList5);
                }
                arrayList.add(arrayList4);
            }
            this.byteValue = arrayList;
        }
        List list = this.addAll;
        this.addAll = this.axisInfo;
        this.axisInfo = list;
        this.clone = this.axisInfo.size();
        this.chartType = this.addAll.size();
        int n2 = this.offset.colStart;
        this.offset.colStart = this.offset.rowStart;
        this.offset.rowStart = n2;
        n2 = this.offset.colEnd;
        this.offset.colEnd = this.offset.rowEnd;
        this.offset.rowEnd = n2;
        n = this.SEDU ? 1 : 0;
        this.SEDU = this.add;
        this.add = n;
        this.swapedCategoryAndSeries = true;
    }

    private List categoryNmae(List list) {
        List list2;
        int n;
        int n2 = this.offset.getCategoryStart();
        int n3 = this.offset.getCategoryEnd();
        int n4 = this.offset.getSeriesStart();
        int n5 = this.offset.getSeriesEnd();
        if (n2 == 0 && n3 == this.chartType && n4 == 0 && n5 == this.clone) {
            return list;
        }
        ArrayList<List> arrayList = new ArrayList<List>();
        ArrayList arrayList2 = new ArrayList();
        for (n = 0; n < this.colEnd; ++n) {
            List list3 = (List)list.get(n);
            list2 = list3.subList(n4, n5);
            arrayList.add(list2);
        }
        for (n = 0; n < this.colEnd; ++n) {
            list2 = (List)arrayList.get(n);
            ArrayList arrayList3 = new ArrayList();
            for (int i = 0; i < list2.size(); ++i) {
                List list4 = (List)list2.get(i);
                List list5 = list4.subList(n2, n3);
                arrayList3.add(list5);
            }
            arrayList2.add(arrayList3);
        }
        return arrayList2;
    }

    private List chartType(List list) {
        ArrayList arrayList = new ArrayList();
        for (int i = list.size() - 1; i >= 0; --i) {
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public boolean isNumberCatgoryName() {
        for (int i = 0; i < this.addAll.size(); ++i) {
            if (this.addAll.get(i) == null) continue;
            return this.addAll.get(i) instanceof Number;
        }
        return false;
    }

    public void setValueMap(ChartValueMap chartValueMap) {
        this.valueMap = chartValueMap;
    }

    public ChartValueMap getValueMap() {
        return this.valueMap;
    }

    public boolean isOneGroup() {
        return this.isOneGroup;
    }

    public List getChartDataSets() {
        return this.datasets;
    }

    public ChartDataSet getChartDataSet(int n) {
        return (ChartDataSet)this.datasets.get(n);
    }

    public List getOriginalSeriesNames() {
        return this.axisInfo;
    }

    public List getOriginalCategoryNames() {
        return this.addAll;
    }

    public int getSeriesCount() {
        return this.offset.getSeriesCount();
    }

    public int getCategoryCount() {
        return this.offset.getCategoryCount();
    }

    public List getSeriesNames() {
        int n = this.offset.getSeriesStart();
        int n2 = this.offset.getSeriesEnd();
        List list = this.axisInfo.subList(n, n2);
        if (this.add) {
            list = this.chartType(list);
        }
        return list;
    }

    public List getCategoryNames() {
        int n = this.offset.getCategoryStart();
        int n2 = this.offset.getCategoryEnd();
        List list = this.addAll.subList(n, n2);
        if (this.SEDU) {
            list = this.chartType(list);
        }
        return list;
    }

    public Object getSeriesName(int n) {
        if (this.add) {
            return this.axisInfo.get(this.offset.getSeriesEnd() - 1 - n);
        }
        return this.axisInfo.get(n + this.offset.getSeriesStart());
    }

    public Object getCategoryName(int n) {
        if (this.SEDU) {
            return this.addAll.get(this.offset.getCategoryEnd() - 1 - n);
        }
        return this.addAll.get(n + this.offset.getCategoryStart());
    }

    public String[] getFilteredSeriesNames() {
        ChartDataFilter chartDataFilter = this.getSeriesFilter();
        List list = this.getSeriesNames();
        String[] stringArray = new String[list.size()];
        if (chartDataFilter != null) {
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = chartDataFilter.filter(list.get(i));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).toString();
            }
        }
        return stringArray;
    }

    public String[] getFilteredCategoryNames() {
        ChartDataFilter chartDataFilter = this.getCategoryFilter();
        List list = this.getCategoryNames();
        String[] stringArray = new String[list.size()];
        if (chartDataFilter != null) {
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = chartDataFilter.filter(list.get(i));
            }
        } else {
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).toString();
            }
        }
        return stringArray;
    }

    public String getFilteredSeriesName(int n) {
        ChartDataFilter chartDataFilter = this.getSeriesFilter();
        Object object = this.getSeriesName(n);
        String string = chartDataFilter != null ? chartDataFilter.filter(object, n) : object.toString();
        return string;
    }

    public String getFilteredCategoryName(int n) {
        ChartDataFilter chartDataFilter = this.getCategoryFilter();
        Object object = this.getCategoryName(n);
        String string = chartDataFilter != null ? chartDataFilter.filter(object, n) : object.toString();
        return string;
    }

    public int[] getDataWindow() {
        int[] nArray = new int[]{this.offset.getCategoryStart(), this.offset.getSeriesStart(), this.offset.getCategoryEnd(), this.offset.getSeriesEnd()};
        return nArray;
    }

    public void setDataWindow(int n, int n2, int n3, int n4) {
        this.offset.colStart = n;
        this.offset.rowStart = n2;
        this.offset.colEnd = n3;
        this.offset.rowEnd = n4;
    }

    public ChartDataSetInfo[] getDatasetInfos() {
        return this.calculateMinMax;
    }

    public void setDatasetInfos(ChartDataSetInfo[] chartDataSetInfoArray) {
        this.calculateMinMax = chartDataSetInfoArray;
    }

    public int[] getSeparatingIndex() {
        return this.canSwitchGroup;
    }

    public void setSeparatingIndex(int[] nArray) {
        this.canSwitchGroup = nArray;
    }

    public ChartDataFilter getCategoryFilter() {
        return this.categoryFilter;
    }

    public ChartDataFilter getSeriesFilter() {
        return this.seriesFilter;
    }

    public void setSeriesFilter(ChartDataFilter chartDataFilter) {
        this.seriesFilter = chartDataFilter;
    }

    public void setCategoryFilter(ChartDataFilter chartDataFilter) {
        this.categoryFilter = chartDataFilter;
    }

    public ChartDataFilter getPrimFilter() {
        return this.primFilter;
    }

    public void setPrimFilter(ChartDataFilter chartDataFilter) {
        this.primFilter = chartDataFilter;
    }

    public ChartDataFilter getSecFilter() {
        return this.secFilter;
    }

    public void setSecFilter(ChartDataFilter chartDataFilter) {
        this.secFilter = chartDataFilter;
    }

    public ChartDataFilter getHintFilter() {
        return this.hintFilter;
    }

    public void setHintFilter(ChartDataFilter chartDataFilter) {
        this.hintFilter = chartDataFilter;
    }

    public boolean isOneGroupForBar() {
        return this.isOneGroupForBar;
    }

    public boolean isTurnedXZ() {
        return this.colStart;
    }

    public String getFormatedHintValue(Number number) {
        if (number != null) {
            if (this.hintFilter == null) {
                DecimalFormat decimalFormat = new DecimalFormat();
                return decimalFormat.format(number);
            }
            return this.hintFilter.filter(number);
        }
        return null;
    }

    public String getFormatedHintValue(double d) {
        return this.getFormatedHintValue(new Double(d));
    }

    public boolean isReverseCategory() {
        return this.SEDU;
    }

    public void setReverseCategory(boolean bl) {
        this.SEDU = bl;
    }

    public boolean isReverseSeries() {
        return this.add;
    }

    public void setReverseSeries(boolean bl) {
        this.add = bl;
    }

    public void setValuesName(String[] stringArray) {
        this.createStockFakeData = stringArray;
    }

    public String[] getValuesName() {
        return this.createStockFakeData;
    }

    public String[] getOrignValuesName(int n) {
        return this.orignValueNames == null ? null : (String[])this.orignValueNames.get(n % this.orignValueNames.size());
    }

    public void setOrignValuesName(List list) {
        this.orignValueNames = list;
    }

    public String getSingleValuesName(int n) {
        if (this.createStockFakeData.length == 1) {
            return this.createStockFakeData[0];
        }
        int n2 = this.clone * this.chartType / this.createStockFakeData.length;
        return this.createStockFakeData[n / n2];
    }

    public void setOneGroup(boolean bl) {
        this.isOneGroup = bl;
    }

    public int getYcnt() {
        return this.colEnd;
    }

    public String mapRowName(String string) {
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public boolean isSwapGroup() {
        return this.doubleValue;
    }

    public void setSwapGroup(boolean bl) {
        this.doubleValue = bl;
    }

    public List getData() {
        return this.byteValue;
    }

    public String getCategoryNmae() {
        return this.categoryNmae;
    }

    public void setCategoryNmae(String string) {
        this.categoryNmae = string;
    }

    public String getSeriesN() {
        return this.seriesN;
    }

    public void setSeriesN(String string) {
        this.seriesN = string;
    }

    public String getFormatedHintCategoryValue(Object object, int n) {
        if (object != null) {
            if (this.categoryFilter == null) {
                return object.toString();
            }
            return this.categoryFilter.filter(object, n);
        }
        return null;
    }

    public String getFormatedHintSeriesValue(Object object, int n) {
        if (object != null) {
            if (this.seriesFilter == null) {
                return object.toString();
            }
            return this.seriesFilter.filter(object, n);
        }
        return null;
    }

    public String getValuesName(int n) {
        return this.createStockFakeData[n];
    }

    public boolean isDetail() {
        return this.equals;
    }

    public void setDetail(boolean bl) {
        this.equals = bl;
    }

    public ChartDataFilter getHintPercentFilter() {
        return this.hintPercentFilter;
    }

    public void setHintPercentFilter(ChartDataFilter chartDataFilter) {
        this.hintPercentFilter = chartDataFilter;
    }

    public void setBulletDataSize(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(";");
        int n = stringArray.length;
        this.filter = new int[n];
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            this.filter[i] = Integer.parseInt(string2);
        }
    }

    public void setIndexValueTypes(int[] nArray) {
        this.floatValue = nArray;
    }

    public void setAllShowValue(List list) {
        this.format = new String[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            this.format[i] = (String[])list.get(i);
        }
    }

    public String[][] getAllShowValue() {
        return this.format;
    }

    public boolean isSwapedGroups() {
        return this.swapedGroups;
    }

    public boolean getIsCanSwaproups() {
        return this.canSwapGroups;
    }

    public void setIsCanSwaproups(boolean bl) {
        this.canSwapGroups = bl;
    }

    public List getMotionChartDataCubeList() {
        return this.motionDataCube;
    }

    public void setMotionChartDataCubeList(List list) {
        this.motionDataCube = list;
    }

    public void setMotionChartGroupNames(List list) {
        this.motionGroupNames = list;
    }

    public List getMotionChartGroupNames() {
        return this.motionGroupNames;
    }

    public int getMotionFieldIndex() {
        return this.motionFieldIndex;
    }

    public void setMotionFieldIndex(int n) {
        this.motionFieldIndex = n;
    }

    public boolean getShowMotionHistory() {
        return this.showMotionHistory;
    }

    public void setShowMotionHistory(boolean bl) {
        this.showMotionHistory = bl;
    }

    public void setValueSqlType(int n) {
        this.getAllShowValues = n;
    }

    public int getValueSqlType() {
        return this.getAllShowValues;
    }

    public void setCategorySqlType(int n) {
        this.getCategoryCount = n;
    }

    public int getCategorySqlType() {
        if (this.doubleValue && this.canSwitchGroup()) {
            return this.getCategoryEnd;
        }
        return this.getCategoryCount;
    }

    public void setSeriesSqlType(int n) {
        this.getCategoryEnd = n;
    }

    public int getSeriesSqlType() {
        if (this.swapedGroups && this.canSwitchGroup()) {
            return this.getCategoryCount;
        }
        return this.getCategoryEnd;
    }

    public double getMaxX() {
        return this.xmax;
    }

    public double getMaxY() {
        return this.ymax;
    }

    public double getMaxZ() {
        return this.zmax;
    }

    public double getMinX() {
        return this.xmin;
    }

    public double getMinY() {
        return this.ymin;
    }

    public double getMinZ() {
        return this.zmin;
    }

    public boolean swapedCategroySeries() {
        return this.swapedCategoryAndSeries;
    }

    public String getFormatedHintStringValue(Object object) {
        return this.hintFilter.filter(object);
    }

    class TableRange {
        int colStart = -1;
        int rowStart = -1;
        int colEnd = -1;
        int rowEnd = -1;

        TableRange() {
        }

        int getCategoryCount() {
            return this.getCategoryEnd() - this.getCategoryStart();
        }

        int getSeriesCount() {
            return this.getSeriesEnd() - this.getSeriesStart();
        }

        int getCategoryStart() {
            if (this.colStart < 0 || this.colStart > this.colEnd && this.colEnd > 0) {
                return 0;
            }
            if (this.colStart >= ChartDataSetModel.this.addAll.size()) {
                return ChartDataSetModel.this.addAll.size() - 1;
            }
            return this.colStart;
        }

        int getCategoryEnd() {
            if (this.colEnd >= ChartDataSetModel.this.addAll.size() || this.colEnd < 0 || this.colStart > this.colEnd) {
                return ChartDataSetModel.this.addAll.size();
            }
            return this.colEnd + 1;
        }

        int getSeriesStart() {
            if (this.rowStart < 0 || this.rowStart > this.rowEnd && this.rowEnd > 0) {
                return 0;
            }
            if (this.rowStart >= ChartDataSetModel.this.axisInfo.size()) {
                return ChartDataSetModel.this.axisInfo.size() - 1;
            }
            return this.rowStart;
        }

        int getSeriesEnd() {
            if (this.rowEnd >= ChartDataSetModel.this.axisInfo.size() || this.rowEnd < 0 || this.rowStart > this.rowEnd) {
                return ChartDataSetModel.this.axisInfo.size();
            }
            return this.rowEnd + 1;
        }
    }
}

