/*
 * Decompiled with CFR 0.152.
 */
package chart.graphics;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class ChartLineStyle
implements Cloneable {
    private static final float SEDU = 3.0f;
    int cureType = 0;
    float penWidth = 3.0f;
    ChartPenStyle penStyle;

    public ChartLineStyle() {
    }

    public ChartLineStyle(int n, ChartPenStyle chartPenStyle) {
        this.cureType = n;
        this.penStyle = chartPenStyle;
        this.penWidth = chartPenStyle.getPenWidth();
    }

    public ChartLineStyle(int n, int n2, int n3) {
        this.cureType = 1;
        this.penStyle = new ChartPenStyle(n2);
        this.penWidth = n3;
        this.penStyle.setPenWidth(n3);
    }

    public ChartLineStyle(boolean bl, int n) {
        this();
        ChartPenStyle chartPenStyle = new ChartPenStyle(1.0f, 2, 0, n, false, false, new ChartColorPattern());
        if (!bl) {
            this.cureType = 1;
        }
        this.penStyle = chartPenStyle;
        this.penWidth = this.penStyle.getPenWidth();
    }

    public ChartLineStyle(String string) {
        String[] stringArray = string.split(",");
        if (stringArray == null) {
            this.cureType = 1;
            this.penStyle = new ChartPenStyle(9);
            this.penWidth = 2.0f;
            this.penStyle.setPenWidth(this.penWidth);
        } else {
            this.cureType = Integer.parseInt(stringArray[0]);
            this.penStyle = new ChartPenStyle(Integer.parseInt(stringArray[1]));
            this.penWidth = stringArray.length < 3 ? 3.0f : (float)Integer.parseInt(stringArray[2]);
            this.penStyle.setPenWidth(this.penWidth);
        }
    }

    public void setCureType(int n) {
        this.cureType = n;
    }

    public int getCureType() {
        return this.cureType;
    }

    public void setPen(ChartPenStyle chartPenStyle) {
        this.penStyle = chartPenStyle;
    }

    public ChartPenStyle getPenStyle() {
        return this.penStyle;
    }

    public int getPenStyleType() {
        return this.penStyle.getDashPattern();
    }

    public void setPenStyle(int n) {
        if (this.penStyle != null) {
            this.penStyle.setDashPattern(n);
        } else {
            this.penStyle = new ChartPenStyle(n);
            this.penStyle.setPenWidth(this.penWidth);
        }
    }

    public void setPenWidth(float f) {
        this.penWidth = f;
        this.penStyle.setPenWidth(f);
    }

    public float getPenWidth() {
        return this.penWidth;
    }

    public void paint(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(n, n2 + n4 / 2);
        generalPath.lineTo(n + n3, n2 + n4 / 2);
        this.penStyle.draw(graphics2D, generalPath);
    }
}

