/*
 * Decompiled with CFR 0.152.
 */
package chart.properties;

import chart.data.ChartDataFilter;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartAxisTickProperties;
import chart.properties.ChartAxisUnitProperties;
import chart.properties.ChartLinkProperty;
import chart.properties.ChartMessageProperties;
import chart.properties.ChartPropertiesable;

public class ChartAxisProperties
implements Cloneable,
ChartPropertiesable {
    protected ChartPenStyle axisPen;
    protected boolean showGrid = false;
    protected ChartPenStyle gridPen = null;
    protected boolean isBestEffort = true;
    protected float labelAxisGap = 10.0f;
    protected int placement = 0;
    protected boolean showLabelTips = false;
    protected int labelPosition = 0;
    protected int positionAxis;
    protected boolean scrollLabelChart;
    protected int scrollLabelShowNumber;
    protected int displayArea = 88;
    protected ChartMessageProperties message = null;
    ChartLinkProperty linkProp;
    ChartAxisTickProperties majorTickProperty = ChartAxisTickProperties.getMajorProperty();
    ChartAxisTickProperties minorTickProperty = ChartAxisTickProperties.getMinorProperty();
    ChartAxisUnitProperties unitProperty = new ChartAxisUnitProperties();
    ChartDataFilter minorFilter;
    protected boolean showChartInScroll;
    private String SEDU;
    private String getAutoRotate;
    private String getLabelEveryTickMark;
    boolean autoScaleYAxis = false;

    public ChartAxisProperties() {
        this.axisPen = new ChartPenStyle(2);
        this.majorTickProperty.setTickMarkPen(new ChartPenStyle(2));
        this.majorTickProperty.setTickMarkType(1);
        this.majorTickProperty.setTickMarkLength(3.0f);
        this.majorTickProperty.setTickMarkLabel(new ChartTextStyle());
        this.majorTickProperty.setLabelEveryTickMark(-1);
        this.majorTickProperty.setLabelNumber(-1);
        this.majorTickProperty.setAutoRotate(false);
        this.majorTickProperty.setShowTickMarkLabels(true);
        this.minorTickProperty.setTickMarkLength(4.0f);
        this.minorTickProperty.setTickMarkType(0);
    }

    public ChartPenStyle getAxisPen() {
        return this.axisPen;
    }

    public void setAxisPen(ChartPenStyle chartPenStyle) {
        this.axisPen = chartPenStyle;
    }

    public ChartPenStyle getGridPen() {
        return this.gridPen;
    }

    public void setGridPen(ChartPenStyle chartPenStyle) {
        this.gridPen = chartPenStyle;
    }

    public boolean isBestEffort() {
        return this.isBestEffort;
    }

    public void setBestEffort(boolean bl) {
        this.isBestEffort = bl;
    }

    public float getLabelAxisGap() {
        return this.labelAxisGap;
    }

    public void setLabelAxisGap(float f) {
        this.labelAxisGap = f;
    }

    public int getLabelEveryNTickMarks() {
        return this.majorTickProperty.getLabelEveryTickMark();
    }

    public void setLabelEveryNTickMarks(int n) {
        this.majorTickProperty.setLabelEveryTickMark(n);
    }

    public ChartTextStyle getLabelTextStyle() {
        return this.majorTickProperty.getTickMarkLabel();
    }

    public void setLabelTextStyle(ChartTextStyle chartTextStyle) {
        this.majorTickProperty.setTickMarkLabel(chartTextStyle);
    }

    public int getNumOfLabels() {
        return this.majorTickProperty.getLabelNumber();
    }

    public void setNumOfLabels(int n) {
        this.majorTickProperty.setLabelNumber(n);
    }

    public int getPlacement() {
        return this.placement;
    }

    public void setPlacement(int n) {
        this.placement = n;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean bl) {
        this.showGrid = bl;
    }

    public boolean isShowTickMarkLabels() {
        return this.majorTickProperty.getShowMarkLabels();
    }

    public void setShowTickMarkLabels(boolean bl) {
        this.majorTickProperty.setShowTickMarkLabels(bl);
    }

    public float getTickMarkLength() {
        return this.majorTickProperty.getTickMarkLength();
    }

    public void setTickMarkLength(float f) {
        this.majorTickProperty.setTickMarkLength(f);
    }

    public ChartPenStyle getTickMarkPen() {
        return this.majorTickProperty.getTickMarkPen();
    }

    public void setTickMarkPen(ChartPenStyle chartPenStyle) {
        this.majorTickProperty.setTickMarkPen(chartPenStyle);
    }

    public int getTickMarkType() {
        return this.majorTickProperty.getTickMarkType();
    }

    public void setTickMarkType(int n) {
        this.majorTickProperty.setTickMarkType(n);
    }

    public float getMinorTickMarkLength() {
        return this.minorTickProperty.getTickMarkLength();
    }

    public void setMinorTickMarkLength(float f) {
        this.minorTickProperty.setTickMarkLength(f);
    }

    public int getMinorTickMarkType() {
        return this.minorTickProperty.getTickMarkType();
    }

    public void setMinorTickMarkType(int n) {
        this.minorTickProperty.setTickMarkType(n);
    }

    public void setLabelFontAutomaticOrientation(boolean bl) {
        this.majorTickProperty.setAutoRotate(bl);
    }

    public void setShowLabelTips(boolean bl) {
        this.showLabelTips = bl;
    }

    public boolean IsLabelFontAutomaticOrientation() {
        return this.majorTickProperty.getAutoRotate();
    }

    public boolean IsShowLabelTips() {
        return this.showLabelTips;
    }

    public int getLabelPosition() {
        return this.labelPosition;
    }

    public void setLabelPosition(int n) {
        this.labelPosition = n;
    }

    public void setPositionAxis(int n) {
        this.positionAxis = n;
    }

    public int getPositionAxis() {
        return this.positionAxis;
    }

    public boolean labelOnTickmark() {
        return this.positionAxis == 0;
    }

    public void setScrollableChart(boolean bl) {
        this.scrollLabelChart = bl;
    }

    public boolean getScrollableChart() {
        return this.scrollLabelChart;
    }

    public void setScrollableVisibleValue(int n) {
        if (n >= 1) {
            this.scrollLabelShowNumber = n;
        }
    }

    public int getScrollableVisibleValue() {
        return this.scrollLabelShowNumber;
    }

    public int getDisplayAreaPercent() {
        return this.displayArea;
    }

    public void setDisplayAreaPercent(int n) {
        if (n >= 1 && n <= 99) {
            this.displayArea = n;
        }
    }

    public ChartMessageProperties getAxisMessage() {
        return this.message;
    }

    public void setAxisMessage(ChartMessageProperties chartMessageProperties) {
        this.message = chartMessageProperties;
    }

    public void setLinkProperty(ChartLinkProperty chartLinkProperty) {
        this.linkProp = chartLinkProperty;
    }

    public ChartLinkProperty getLinkProperty() {
        return this.linkProp;
    }

    public void setIsShowChartInScroll(boolean bl) {
        this.showChartInScroll = bl;
    }

    public boolean getIsShowChartInScroll() {
        return this.showChartInScroll;
    }

    public String getMinStringValue() {
        return this.SEDU;
    }

    public void setMinStringValue(String string) {
        this.SEDU = string;
    }

    public String getMaxStringValue() {
        return this.getAutoRotate;
    }

    public void setMaxStringValue(String string) {
        this.getAutoRotate = string;
    }

    public boolean getIsTextAxis() {
        return false;
    }

    public void setIsTextAxis(boolean bl) {
    }

    public ChartAxisTickProperties getMajorTickMarkProperties() {
        return this.majorTickProperty;
    }

    public ChartAxisTickProperties getMinorTickMarkProperties() {
        return this.minorTickProperty;
    }

    public ChartAxisUnitProperties getUnitProperties() {
        return this.unitProperty;
    }

    public void setUnitProperties(ChartAxisUnitProperties chartAxisUnitProperties) {
        this.unitProperty = chartAxisUnitProperties;
    }

    public ChartDataFilter getMinorDataFilter() {
        return this.minorFilter;
    }

    public void setMinorDataFilter(ChartDataFilter chartDataFilter) {
        this.minorFilter = chartDataFilter;
    }

    public void setDataMappingFile(String string) {
        this.getLabelEveryTickMark = string;
    }

    public String getDataMappingFile() {
        return this.getLabelEveryTickMark;
    }

    public boolean isAutoScaleYAxis() {
        return this.autoScaleYAxis;
    }

    public void setAutoScaleYAxis(boolean bl) {
        this.autoScaleYAxis = bl;
    }
}

