/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import chart.ChartPlatform;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DPaper;
import chart.data.ChartDataSetInfo;
import chart.data.ChartTypeInfo;
import chart.util.ChartGraphInfo;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import jet.connect.DbColDesc;
import jet.connect.DbValue;
import jet.datastream.DSChartPlatform;
import jet.datastream.DSChartShowValueInfo;
import jet.util.JRInterruptedException;

public class ChartDrillInfo {
    ChartPlatform chart;
    String categoryBLName;
    String categoryMapName;
    String seriesBLName;
    String seriesMapName;
    boolean isBv;
    int categorySqlType;
    int categoryPrecision;
    int categoryScale;
    int seriesSqlType;
    int seriesPrecision;
    int seriesScale;
    int[] conditionsFillType;
    int[] conditionsExpSize;

    public ChartDrillInfo(ChartPlatform chartPlatform) {
        this.chart = chartPlatform;
    }

    public void initChartPlatform(DSChartPlatform dSChartPlatform) {
        this.SEDU(dSChartPlatform);
        if (this.chart != null) {
            Rectangle rectangle = this.chart.getBounds();
            if (!this.chart.ispaint) {
                try {
                    BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    this.chart.paint(graphics2D);
                }
                catch (ClassCastException classCastException) {
                    BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 6);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    this.chart.paint(graphics2D);
                }
            }
        }
    }

    public List getLegendGraphInfo() {
        List list = null;
        try {
            list = this.categoryScale();
        }
        catch (Exception exception) {
            return new ArrayList();
        }
        return list;
    }

    public List getAxisGraphInfo() {
        ArrayList arrayList = new ArrayList();
        List list = this.categoryBLName();
        if (list != null) {
            arrayList.addAll(list);
        }
        List list2 = this.categoryPrecision();
        if (list != null) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public List getChartGraphInfo() {
        List list;
        ArrayList arrayList = new ArrayList();
        List list2 = this.getLegendGraphInfo();
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        if ((list = this.getAxisGraphInfo()) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private void SEDU(DSChartPlatform dSChartPlatform) {
        List list = dSChartPlatform.getDSChartConditional().getShowValueInfos();
        DSChartShowValueInfo dSChartShowValueInfo = null;
        if (list != null && list.size() > 0) {
            this.conditionsFillType = new int[list.size()];
            this.conditionsExpSize = new int[list.size()];
            block4: for (int i = 0; i < this.conditionsFillType.length; ++i) {
                this.conditionsFillType[i] = ((DSChartShowValueInfo)list.get(i)).getFillType();
                switch (this.conditionsFillType[i]) {
                    case 1: 
                    case 2: {
                        dSChartShowValueInfo = (DSChartShowValueInfo)dSChartPlatform.getDSChartConditional().getShowValueInfos().get(i);
                        this.conditionsExpSize[i] = dSChartShowValueInfo.getShowValueFillColorByExpressions() == null ? 0 : dSChartShowValueInfo.getShowValueFillColorByExpressions().size();
                        int n = i;
                        this.conditionsExpSize[n] = this.conditionsExpSize[n] + 1;
                        continue block4;
                    }
                    case 5: {
                        dSChartShowValueInfo = (DSChartShowValueInfo)dSChartPlatform.getDSChartConditional().getShowValueInfos().get(i);
                        this.conditionsExpSize[i] = dSChartShowValueInfo.getShowValueFillColorByRange() == null ? 0 : dSChartShowValueInfo.getShowValueFillColorByRange().size();
                        int n = i;
                        this.conditionsExpSize[n] = this.conditionsExpSize[n] + 1;
                        continue block4;
                    }
                    default: {
                        this.conditionsExpSize[i] = 0;
                    }
                }
            }
            dSChartPlatform.getDSChartConditional().getShowValueInfos();
        } else {
            this.conditionsFillType = null;
            this.conditionsExpSize = null;
        }
        dSChartPlatform.getDSChartConditional();
        this.isBv = (Boolean)dSChartPlatform.getPropertyByName("IsBVData").getObject();
        this.categoryBLName = this.isBv || dSChartPlatform.getCategoryAndSeriesDisplayName() == null ? (this.chart.getChartDefinition().getCategory() != null ? new String(this.chart.getChartDefinition().getCategory()) : "") : new String(dSChartPlatform.getCategoryAndSeriesDisplayName()[0]);
        if (this.isBv || dSChartPlatform.getCategoryAndSeriesDisplayName() != null) {
            this.categoryMapName = new String(dSChartPlatform.getCategoryAndSeriesDisplayName()[0]);
        } else {
            String string = this.categoryMapName = this.chart.getChartDefinition().getCategory() != null ? new String(this.chart.getChartDefinition().getCategory()) : "";
        }
        if (this.isBv || dSChartPlatform.getCategoryAndSeriesDisplayName() == null) {
            this.seriesBLName = this.chart.getChartDefinition().getSeries() == null ? null : new String(this.chart.getChartDefinition().getSeries());
        } else {
            String string = this.seriesBLName = dSChartPlatform.getCategoryAndSeriesDisplayName()[1] == null ? null : new String(dSChartPlatform.getCategoryAndSeriesDisplayName()[1]);
        }
        this.seriesMapName = this.isBv || dSChartPlatform.getCategoryAndSeriesDisplayName() != null ? (dSChartPlatform.getCategoryAndSeriesDisplayName()[1] == null ? null : new String(dSChartPlatform.getCategoryAndSeriesDisplayName()[1])) : (this.chart.getChartDefinition().getSeries() == null ? null : new String(this.chart.getChartDefinition().getSeries()));
        this.categorySqlType = dSChartPlatform.getDSChartConditional().getCategorySqlType();
        this.categoryPrecision = dSChartPlatform.getDSChartConditional().getCategoryPrecision();
        this.categoryScale = dSChartPlatform.getDSChartConditional().getCategoryScale();
        this.seriesSqlType = dSChartPlatform.getDSChartConditional().getSeriesSqlType();
        this.seriesPrecision = dSChartPlatform.getDSChartConditional().getSeriesPrecision();
        this.seriesScale = dSChartPlatform.getDSChartConditional().getSeriesScale();
    }

    private Shape[] add() {
        Shape[] shapeArray = this.chart.getChartLegend().getLabelsShapes();
        if (shapeArray == null) {
            return null;
        }
        Rectangle rectangle = this.chart.getChartLegend().getBounds();
        AffineTransform affineTransform = new AffineTransform();
        Rectangle rectangle2 = this.chart.getChartLegend().getBounds();
        affineTransform.translate(rectangle2.x, rectangle2.y);
        Shape[] shapeArray2 = new Shape[shapeArray.length];
        for (int i = 0; i < shapeArray2.length; ++i) {
            shapeArray2[i] = affineTransform.createTransformedShape(shapeArray[i]);
        }
        return shapeArray2;
    }

    private Shape[] addAll(ChartAxis chartAxis) {
        Shape[] shapeArray = chartAxis.getAxisShapes();
        if (shapeArray == null) {
            return null;
        }
        AffineTransform affineTransform = new AffineTransform();
        Rectangle rectangle = this.chart.getChartCoordinatePaper().getBounds();
        affineTransform.translate(rectangle.x, rectangle.y);
        Shape[] shapeArray2 = new Shape[shapeArray.length];
        for (int i = 0; i < shapeArray2.length; ++i) {
            shapeArray2[i] = affineTransform.createTransformedShape(shapeArray[i]);
        }
        return shapeArray2;
    }

    private Shape[] booleanValue(ChartAxis chartAxis, int n) {
        int n2 = 1;
        n2 = n > 1 ? n : n2;
        Shape[] shapeArray = chartAxis.getAxisShapes();
        if (shapeArray == null) {
            return null;
        }
        AffineTransform affineTransform = new AffineTransform();
        Rectangle rectangle = this.chart.getChartCoordinatePaper().getBounds();
        affineTransform.translate(rectangle.x, rectangle.y);
        Shape[] shapeArray2 = new Shape[shapeArray.length];
        for (int i = 0; i < shapeArray2.length; i += n2) {
            shapeArray2[i] = affineTransform.createTransformedShape(shapeArray[i]);
        }
        return shapeArray2;
    }

    private List categoryBLName() {
        List list = new ArrayList();
        int n = ChartTypeInfo.getPrimType(this.chart.getChartDefinition().getChartDataSetInfos()[0].getChartType());
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 11: {
                if (this.chart.getChartCoordinatePaper().getAxisX1() == null || !this.chart.getChartCoordinatePaper().getAxisX1().isShow() || !this.chart.getChartCoordinatePaper().getAxisX1().getProperties().isShowTickMarkLabels()) break;
                ChartAxis chartAxis = this.chart.getChartCoordinatePaper().getAxisX1();
                if (!chartAxis.isLocated()) {
                    // empty if block
                }
                if (!(chartAxis instanceof ChartCategoryAxis) || ((ChartCategoryAxis)chartAxis).custommerConstant()) break;
                list = this.categoryMapName(chartAxis);
                break;
            }
            case 9: {
                if (this.chart.getChartCoordinatePaper().getAxisX1() == null || !(this.chart.getChartCoordinatePaper().getAxisX1() instanceof ChartCategoryAxis) || !this.chart.getChartCoordinatePaper().getAxisX1().isShow() || !this.chart.getChartCoordinatePaper().getAxisX1().getProperties().isShowTickMarkLabels()) break;
                int n2 = this.chart.getChartCoordinatePaper().getAxisXLabelStep();
                Shape[] shapeArray = this.booleanValue(this.chart.getChartCoordinatePaper().getAxisX1(), n2);
                List list2 = this.conditionsFillType(0, shapeArray.length, n2);
                list2 = this.categorySqlType(list2, 0);
                list = this.chart(shapeArray, list2, false);
                break;
            }
        }
        return list;
    }

    private List categoryMapName(ChartAxis chartAxis) {
        int n;
        boolean bl;
        List list = new ArrayList();
        int n2 = this.chart.getDataSetModel().getAllShowValue().length;
        boolean bl2 = bl = this.chart.getDataSetModel().getSeriesN() != null;
        if (this.chart.isScrollChart() && this.chart.getChartCoordinatePaper() != null && this.chart.getChartCoordinatePaper() instanceof Chart2DPaper && ((Chart2DPaper)this.chart.getChartCoordinatePaper()).isScrollChart() && !chartAxis.custommerConstant()) {
            int[] nArray = this.chart.getDataPosition();
            n = this.chart.getDataPosition()[0];
            int n3 = this.chart.getDataPosition()[1];
        } else {
            n = -1;
            int n4 = -1;
        }
        int n5 = this.chart.getChartCoordinatePaper().getAxisXLabelStep();
        Shape[] shapeArray = this.booleanValue(chartAxis, n5);
        if (shapeArray == null) {
            return null;
        }
        if (n2 > 1) {
            if (this.chart.getDataSetModel().swapedCategroySeries() && !bl) {
                return list;
            }
            if (this.chart.getDataSetModel().swapedCategroySeries()) {
                List list2 = this.createTransformedShape(n > 0 ? n : 0, shapeArray.length, n5);
                list = this.chart(shapeArray, list2, true);
                return list;
            }
            List list3 = this.conditionsFillType(n > 0 ? n : 0, shapeArray.length, n5);
            list = this.chart(shapeArray, list3, false);
            return list;
        }
        if (this.chart.getDataSetModel().swapedCategroySeries()) {
            List list4 = this.createTransformedShape(n > 0 ? n : 0, shapeArray.length, n5);
            list = this.chart(shapeArray, list4, true);
            return list;
        }
        List list5 = this.conditionsFillType(n > 0 ? n : 0, shapeArray.length, n5);
        list = this.chart(shapeArray, list5, false);
        return list;
    }

    private List categoryPrecision() {
        List list = new ArrayList();
        Shape[] shapeArray = this.chart.getChartCoordinatePaper().getAxisZShapes();
        if (shapeArray != null && shapeArray.length > 0) {
            boolean bl;
            boolean bl2 = bl = this.chart.getDataSetModel().getSeriesN() != null;
            if (bl) {
                AffineTransform affineTransform = new AffineTransform();
                Rectangle rectangle = this.chart.getChartCoordinatePaper().getBounds();
                affineTransform.translate(rectangle.x, rectangle.y);
                Shape[] shapeArray2 = new Shape[shapeArray.length];
                for (int i = 0; i < shapeArray.length; ++i) {
                    shapeArray2[i] = affineTransform.createTransformedShape(shapeArray[i]);
                }
                if (!this.chart.getDataSetModel().swapedCategroySeries()) {
                    List list2 = this.createDbValue(0, shapeArray2.length);
                    list2 = this.categorySqlType(list2, this.chart.getLegendLabelStart());
                    list = this.chart(shapeArray2, list2, true);
                } else {
                    List list3 = this.conditionsExpSize(0, shapeArray2.length);
                    list3 = this.categorySqlType(list3, this.chart.getLegendLabelStart());
                    list = this.chart(shapeArray2, list3, true);
                }
            }
        }
        return list;
    }

    private List categoryScale() {
        List list;
        block45: {
            Shape[] shapeArray;
            boolean bl;
            List list2;
            int n;
            boolean bl2;
            block44: {
                list = new ArrayList();
                boolean bl3 = this.chart.getChartDefinition().isComboChart();
                int n2 = this.chart.getDataSetModel().getAllShowValue().length;
                bl2 = this.chart.getDataSetModel().getSeriesN() != null;
                boolean bl4 = this.chart.getDataSetModel().swapedCategroySeries();
                n = 0;
                list2 = null;
                bl = false;
                shapeArray = this.add();
                if (shapeArray == null) {
                    return list;
                }
                if (shapeArray.length <= 0) {
                    return list;
                }
                if (bl3) break block44;
                n = ChartTypeInfo.getPrimType(this.chart.getChartDefinition().getChartDataSetInfos()[0].getChartType());
                switch (n) {
                    case 0: 
                    case 1: 
                    case 5: {
                        if (!bl2 && !bl4 && n2 == 1 || bl2 && bl4 || !bl2 && n2 > 1 && bl4) {
                            list2 = this.conditionsExpSize(0, shapeArray.length);
                            bl = false;
                        } else if (bl2 && !bl4) {
                            list2 = this.createDbValue(0, shapeArray.length);
                            bl = true;
                        }
                        if (this.conditionsExpSize != null) {
                            ArrayList arrayList = new ArrayList();
                            for (int i = 0; i < this.conditionsExpSize.length; ++i) {
                                int n3 = this.conditionsExpSize[i];
                                if (n3 > 0) {
                                    for (int j = 0; j < n3; ++j) {
                                        arrayList.add(null);
                                    }
                                    continue;
                                }
                                arrayList.addAll(list2);
                            }
                            list2 = arrayList;
                        }
                        list2 = this.categorySqlType(list2, this.chart.getLegendLabelStart());
                        list = this.chart(shapeArray, list2, bl);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (bl2 && !bl4) {
                            list2 = this.createDbValue(0, shapeArray.length);
                            bl = true;
                        } else if (!bl2 && n2 > 1 && bl4 || bl2 && bl4) {
                            list2 = this.conditionsExpSize(0, shapeArray.length);
                            bl = false;
                        }
                        if (this.conditionsExpSize != null) {
                            ArrayList arrayList = new ArrayList();
                            for (int i = 0; i < this.conditionsExpSize.length; ++i) {
                                int n4 = this.conditionsExpSize[i];
                                if (n4 > 0) {
                                    for (int j = 0; j < n4; ++j) {
                                        arrayList.add(null);
                                    }
                                    continue;
                                }
                                arrayList.addAll(list2);
                            }
                            list2 = arrayList;
                        }
                        list2 = this.categorySqlType(list2, this.chart.getLegendLabelStart());
                        list = this.chart(shapeArray, list2, bl);
                        break;
                    }
                    case 4: {
                        if (!bl4 || n2 > 1 && bl4) {
                            list2 = this.conditionsExpSize(0, shapeArray.length);
                            bl = false;
                        } else if (bl2 && bl4) {
                            list2 = this.clear(0, shapeArray.length);
                            bl = true;
                        }
                        if (this.conditionsExpSize != null) {
                            ArrayList arrayList = new ArrayList();
                            for (int i = 0; i < this.conditionsExpSize.length; ++i) {
                                int n5 = this.conditionsExpSize[i];
                                if (n5 > 0) {
                                    for (int j = 0; j < n5; ++j) {
                                        arrayList.add(null);
                                    }
                                    continue;
                                }
                                arrayList.addAll(list2);
                            }
                            list2 = arrayList;
                        }
                        list2 = this.categorySqlType(list2, this.chart.getLegendLabelStart());
                        list = this.chart(shapeArray, list2, bl);
                        break;
                    }
                    case 6: {
                        if (!bl4 && bl2) {
                            list2 = this.createDbValue(0, shapeArray.length);
                            bl = true;
                        } else if (bl4 && bl2 || bl4 && !bl2 && n2 > 1) {
                            list2 = this.conditionsExpSize(0, shapeArray.length);
                            bl = false;
                        }
                        if (n2 > 1) {
                            ArrayList arrayList = new ArrayList();
                            for (int i = 0; i < n2; ++i) {
                                arrayList.addAll(list2);
                            }
                            list2 = arrayList;
                        }
                        list2 = this.categorySqlType(list2, this.chart.getLegendLabelStart());
                        list = this.chart(shapeArray, list2, bl);
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (bl2) {
                            list2 = this.createDbValue(0, shapeArray.length);
                            bl = true;
                            if (n2 > 2) {
                                ArrayList arrayList = new ArrayList();
                                for (int i = 0; i < n2; ++i) {
                                    arrayList.addAll(list2);
                                }
                                list2 = arrayList;
                            }
                            list2 = this.categorySqlType(list2, this.chart.getLegendLabelStart());
                            list = this.chart(shapeArray, list2, bl);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block45;
            }
            boolean bl5 = true;
            ChartDataSetInfo[] chartDataSetInfoArray = this.chart.getChartDefinition().getChartDataSetInfos();
            for (int i = 0; i < chartDataSetInfoArray.length; ++i) {
                n = ChartTypeInfo.getPrimType(chartDataSetInfoArray[i].getChartType());
                if (n == 2 || n == 0 || n == 1 || n == 0) continue;
                bl5 = false;
                break;
            }
            if (bl5 && bl2) {
                list2 = this.createDbValue(0, shapeArray.length);
                bl = true;
                if (this.conditionsExpSize != null) {
                    ArrayList arrayList = new ArrayList();
                    for (int i = 0; i < this.conditionsExpSize.length; ++i) {
                        int n6 = this.conditionsExpSize[i];
                        if (n6 > 0) {
                            for (int j = 0; j < n6; ++j) {
                                arrayList.add(null);
                            }
                            continue;
                        }
                        arrayList.addAll(list2);
                    }
                    list2 = arrayList;
                }
                list2 = this.categorySqlType(list2, this.chart.getLegendLabelStart());
                list = this.chart(shapeArray, list2, bl);
            }
        }
        return list;
    }

    private List categorySqlType(List list, int n) {
        if (n == 0) {
            return list;
        }
        if (n < list.size() - 1) {
            for (int i = 0; i < n; ++i) {
                list.remove(0);
            }
            return list;
        }
        list.clear();
        return list;
    }

    private List chart(Shape[] shapeArray, List list, boolean bl) {
        ArrayList<ChartGraphInfo> arrayList = new ArrayList<ChartGraphInfo>();
        if (shapeArray == null || list == null) {
            return arrayList;
        }
        int n = shapeArray.length <= list.size() ? shapeArray.length : list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i) == null) continue;
            ChartGraphInfo chartGraphInfo = new ChartGraphInfo(shapeArray[i]);
            chartGraphInfo.setInCategory(!bl);
            chartGraphInfo.setInSeries(bl);
            chartGraphInfo.setRealValue((DbValue)list.get(i));
            if (bl) {
                chartGraphInfo.setBlColumnName(this.getSeriesBLName());
                chartGraphInfo.setMappingName(this.getSeriesMappingName());
            } else {
                chartGraphInfo.setBlColumnName(this.getCategoryBLName());
                chartGraphInfo.setMappingName(this.getCategoryMappingName());
            }
            arrayList.add(chartGraphInfo);
        }
        return arrayList;
    }

    public String getCategoryBLName() {
        return this.categoryBLName;
    }

    public String getCategoryMappingName() {
        return this.categoryMapName;
    }

    public String getSeriesBLName() {
        return this.seriesBLName;
    }

    public String getSeriesMappingName() {
        return this.seriesMapName;
    }

    protected int getConditionFillType(int n) {
        int n2 = -1;
        if (this.conditionsFillType != null && n >= 0 && n < this.conditionsFillType.length) {
            n2 = this.conditionsFillType[n];
        }
        return n2;
    }

    protected int getConditionExpSize(int n) {
        int n2 = -1;
        if (this.conditionsExpSize != null && n > 0 && n < this.conditionsExpSize.length) {
            n2 = this.conditionsExpSize[n];
        }
        return n2;
    }

    private List clear(int n, int n2) {
        int n3 = n2 > 0 ? n + n2 : n + 1;
        List list = this.chart.getDataSetModel().swapedCategroySeries() ? this.chart.getDataSetModel().getCategoryNames() : this.chart.getDataSetModel().getSeriesNames();
        String string = null;
        string = this.seriesBLName;
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        if (arrayList != null && string != null && !string.equals("")) {
            for (int i = n; i < list.size() && i < n3; ++i) {
                DbValue dbValue = ChartDrillInfo.createDbValue(list.get(i), string, this.seriesSqlType, this.seriesPrecision, this.seriesScale);
                arrayList.add(dbValue);
            }
        }
        return arrayList;
    }

    private List conditionsExpSize(int n, int n2) {
        int n3 = n2 > 0 ? n + n2 : n + 1;
        List list = this.chart.getDataSetModel().swapedCategroySeries() ? this.chart.getDataSetModel().getSeriesNames() : this.chart.getDataSetModel().getCategoryNames();
        String string = null;
        string = this.categoryBLName;
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        if (arrayList != null && string != null && !string.equals("")) {
            for (int i = n; i < list.size() && i < n3; ++i) {
                DbValue dbValue = ChartDrillInfo.createDbValue(list.get(i), string, this.categorySqlType, this.categoryPrecision, this.categoryScale);
                arrayList.add(dbValue);
            }
        }
        return arrayList;
    }

    private List conditionsFillType(int n, int n2, int n3) {
        int n4 = 1;
        n4 = n3 > 1 ? n3 : n4;
        int n5 = n2 > 0 ? n + n2 : n + 1;
        List list = this.chart.getDataSetModel().swapedCategroySeries() ? this.chart.getDataSetModel().getSeriesNames() : this.chart.getDataSetModel().getCategoryNames();
        String string = null;
        string = this.categoryBLName;
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        if (arrayList != null && string != null && !string.equals("")) {
            for (int i = n; i < list.size() && i < n5; i += n4) {
                DbValue dbValue = ChartDrillInfo.createDbValue(list.get(i), string, this.categorySqlType, this.categoryPrecision, this.categoryScale);
                arrayList.add(dbValue);
            }
        }
        return arrayList;
    }

    private List createDbValue(int n, int n2) {
        int n3 = n2 > 0 ? n + n2 : n + 1;
        List list = this.chart.getDataSetModel().swapedCategroySeries() ? this.chart.getDataSetModel().getCategoryNames() : this.chart.getDataSetModel().getSeriesNames();
        String string = null;
        string = this.seriesBLName;
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        if (arrayList != null && string != null && !string.equals("")) {
            for (int i = 0; i < list.size() && i < n3; ++i) {
                DbValue dbValue = ChartDrillInfo.createDbValue(list.get(i), string, this.seriesSqlType, this.seriesPrecision, this.seriesScale);
                arrayList.add(dbValue);
            }
        }
        return arrayList;
    }

    private List createTransformedShape(int n, int n2, int n3) {
        int n4 = 1;
        n4 = n3 > 1 ? n3 : n4;
        int n5 = n2 > 0 ? n + n2 : n + 1;
        List list = this.chart.getDataSetModel().swapedCategroySeries() ? this.chart.getDataSetModel().getCategoryNames() : this.chart.getDataSetModel().getSeriesNames();
        String string = null;
        string = this.seriesBLName;
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        if (arrayList != null && string != null && !string.equals("")) {
            for (int i = 0; i < list.size() && i < n5; i += n4) {
                DbValue dbValue = ChartDrillInfo.createDbValue(list.get(i), string, this.seriesSqlType, this.seriesPrecision, this.seriesScale);
                arrayList.add(dbValue);
            }
        }
        return arrayList;
    }

    public static DbValue createDbValue(Object object, String string, int n, int n2, int n3) {
        DbColDesc dbColDesc = new DbColDesc(string, n, n2, n3, 2);
        DbValue dbValue = DbValue.makeDbValue(dbColDesc);
        try {
            if (object != null) {
                dbValue.setValue(object.toString());
            } else {
                dbValue.setNull();
            }
        }
        catch (JRInterruptedException jRInterruptedException) {
            dbValue.setNull();
        }
        catch (Exception exception) {
            dbValue.setNull();
        }
        return dbValue;
    }
}

