/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import jet.connect.DbValue;

public class ChartGraphInfo {
    Shape graphArea;
    String hint = "";
    DbValue value;
    boolean inCategory;
    boolean inSeries;
    String mappingN;
    String blColN;
    String link;

    public ChartGraphInfo() {
    }

    public ChartGraphInfo(Shape shape) {
        this.graphArea = shape;
    }

    public void setGraph(Shape shape) {
        this.graphArea = shape;
    }

    public Shape getGraph() {
        return this.graphArea;
    }

    public boolean inCategory() {
        return this.inCategory;
    }

    public void setInCategory(boolean bl) {
        this.inCategory = bl;
    }

    public boolean inSeries() {
        return this.inSeries;
    }

    public void setInSeries(boolean bl) {
        this.inSeries = bl;
    }

    public String getMappingName() {
        return this.mappingN;
    }

    public void setMappingName(String string) {
        this.mappingN = string;
    }

    public void setBlColumnName(String string) {
        this.blColN = string;
    }

    public String getBlColumnName() {
        return this.blColN;
    }

    public DbValue getRealValue() {
        return this.value;
    }

    public void setRealValue(DbValue dbValue) {
        this.value = dbValue;
    }

    public String getShape() {
        return "poly";
    }

    public String getCoordinate() {
        if (this.graphArea != null) {
            float[] fArray2 = new float[6];
            PathIterator pathIterator = this.graphArea.getPathIterator(new AffineTransform());
            StringBuffer stringBuffer = new StringBuffer();
            while (!pathIterator.isDone()) {
                pathIterator.currentSegment(fArray2);
                float f = fArray2[0];
                float f2 = fArray2[1];
                stringBuffer.append(f + "," + f2 + ",");
                pathIterator.next();
            }
            if (stringBuffer.length() >= 1) {
                return stringBuffer.substring(0, stringBuffer.length() - 1);
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public String getLinkValue() {
        return this.link;
    }

    public void setLinkValue(String string) {
        this.link = string;
    }
}

