/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import chart.data.ChartDataFilter;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTexturePattern;
import chart.graphics.RoundGradientContext;
import chart.graphics.RoundGradientPaint;
import chart.util.ChartMapColorInfo;
import chart.util.ChartRenderTools;
import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class ChartHeatMapColorManager {
    Vector colorList = new Vector();
    int currentIndex = 0;
    Vector colorByGroupList = new Vector();
    Vector colorByList = new Vector();
    int currentGroupIndex = 1;
    Vector colorBySumList = new Vector();
    boolean isMerageColor = false;
    Color startClr = new Color(245, 245, 245);
    Color endClr = new Color(68, 68, 68);
    Color zeroClr = new Color(255, 255, 255);
    Color nullClr = new Color(255, 255, 255);
    double max;
    double min;
    boolean calculatedMaxMin = false;
    boolean mapZeroToWhite;
    boolean useLG = false;
    boolean useLN = false;
    int type;
    List colorByFields = new Vector();
    List conditionalFillExps;
    List conditionalFillColors;
    List patternList;
    boolean reverse;
    List nullValues = new Vector();
    ChartDataFilter numValFormat;
    List numberDataIndexs = null;
    boolean setNumberDataIndexs = false;
    boolean hasFileter = false;
    Vector originGroupNames = new Vector();
    Hashtable originGroups;
    Vector originColorByGroups;
    boolean isVaryColor = true;

    public void init() {
    }

    private Vector InitialOriginGroupNames() {
        Vector<Color> vector = new Vector<Color>();
        vector.add(Color.red);
        vector.add(Color.blue);
        vector.add(Color.cyan);
        vector.add(Color.green);
        vector.add(Color.orange);
        vector.add(Color.yellow);
        vector.add(Color.pink);
        return vector;
    }

    public Color getNextColor() {
        Color color = this.calculatedMaxMin((ChartFillPattern)this.colorList.get(this.currentIndex % this.colorList.size()));
        ++this.currentIndex;
        return color;
    }

    public Color getUsedColor(Vector vector) {
        this.addAll();
        int n = this.SEDU(vector);
        Color color = this.calculatedMaxMin((ChartFillPattern)this.colorList.get(n % this.colorList.size()));
        return color;
    }

    private int SEDU(Vector vector) {
        int n = 0;
        int n2 = this.colorByGroupList.size();
        if (n2 == vector.size() && this.colorByFields != null && this.colorByFields.size() == n2) {
            boolean bl = false;
            for (int i = 0; i < n2; ++i) {
                bl = true;
                for (int j = 0; j < vector.size(); ++j) {
                    if (vector.get(j) == null || ((Vector)this.colorByGroupList.get(i)).contains(vector.get(j))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                n = i;
                break;
            }
            return n;
        }
        if (this.colorByFields != null && this.colorByFields.size() > 0) {
            Vector vector2 = new Vector();
            try {
                int n3;
                int n4;
                for (n4 = 0; n4 < this.colorByFields.size(); ++n4) {
                    n3 = (Integer)this.colorByFields.get(n4);
                    vector2.add(vector.get(n3 - 1));
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    n4 = 1;
                    for (int i = 0; i < vector2.size(); ++i) {
                        if (vector2.get(i) == null || ((Vector)this.colorByGroupList.get(n3)).contains(vector2.get(i))) continue;
                        n4 = 0;
                        break;
                    }
                    if (n4 == 0) continue;
                    n = n3;
                    break;
                }
                return n;
            }
            catch (Exception exception) {
                return n;
            }
        }
        return n;
    }

    public void setColorByGroupName(String string, int n) {
    }

    public void setColorBySum(Vector vector, double d) {
        int n = this.add(vector);
        if (n >= 0) {
            ((Vector)this.colorBySumList.get(n)).add(new Double(d));
        } else {
            Vector<Double> vector2 = new Vector<Double>();
            vector2.add(new Double(d));
            this.colorBySumList.add(vector2);
            Vector vector3 = this.abs(vector);
            this.colorByGroupList.add(vector);
        }
    }

    private Vector abs(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        if (this.numValFormat != null) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i) != null && !(vector.get(i) instanceof String)) {
                    vector2.add(vector.get(i).toString());
                    continue;
                }
                if (vector.get(i) != null) {
                    vector2.add(vector.get(i).toString());
                    continue;
                }
                vector2.add(null);
            }
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get(i) != null) {
                    vector2.add(vector.get(i).toString());
                    continue;
                }
                vector2.add(null);
            }
        }
        return vector2;
    }

    Vector format(Vector vector) {
        Vector<Vector> vector2 = new Vector<Vector>();
        for (int i = 0; i < vector.size(); ++i) {
            vector2.add(this.abs((Vector)vector.get(i)));
        }
        return vector2;
    }

    private int add(Vector vector) {
        boolean bl = false;
        for (int i = 0; i < this.colorByGroupList.size(); ++i) {
            Vector vector2 = (Vector)this.colorByGroupList.get(i);
            if (vector2.size() != vector.size()) continue;
            bl = true;
            for (int j = 0; j < vector2.size(); ++j) {
                if ((vector2.get(j) == null || vector2.get(j).equals(vector.get(j))) && (vector2.get(j) != null || vector.get(j) == null)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    private void addAll() {
        if (this.colorByGroupList.size() > 0 && !this.isMerageColor && this.colorByFields != null && this.colorByFields.size() > 0) {
            int n = 0;
            int n2 = -1;
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            for (int i = 0; i < this.colorByGroupList.size() && i < this.colorBySumList.size(); ++i) {
                Vector vector3 = new Vector();
                Vector vector4 = (Vector)this.colorBySumList.get(i);
                for (int j = 0; j < this.colorByFields.size(); ++j) {
                    n = (Integer)this.colorByFields.get(j) - 1;
                    vector3.add(((Vector)this.colorByGroupList.get(i)).get(n));
                }
                n2 = this.append(vector, vector3);
                if (n2 >= 0) {
                    ((Vector)vector2.get(n2)).addAll(vector4);
                    continue;
                }
                vector.add(vector3);
                Vector vector5 = new Vector();
                vector5.addAll(vector4);
                vector2.add(vector5);
            }
            this.colorByGroupList = vector;
            this.colorBySumList = vector2;
        }
        this.isMerageColor = true;
    }

    private int append(Vector vector, Vector vector2) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector3 = (Vector)vector.get(i);
            if (vector3.size() != vector2.size()) continue;
            bl = true;
            for (int j = 0; j < vector3.size(); ++j) {
                if ((vector3.get(j) == null || vector3.get(j).equals(vector2.get(j))) && (vector3.get(j) != null || vector2.get(j) == null)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public void setColorList(ChartFillPattern[] chartFillPatternArray) {
        if (chartFillPatternArray == null) {
            return;
        }
        if (this.colorList == null) {
            this.colorList = new Vector();
        }
        this.colorList.clear();
        for (int i = 0; i < chartFillPatternArray.length; ++i) {
            this.colorList.add(chartFillPatternArray[i]);
        }
        if (this.colorList.size() == 0) {
            this.colorList.add(new ChartColorPattern(new Color(255, 255, 255)));
        }
    }

    private boolean blue() {
        return this.hasFileter && this.originGroupNames != null && this.originGroups != null;
    }

    private Color calculatedMaxMin(ChartFillPattern chartFillPattern) {
        if (chartFillPattern instanceof ChartColorPattern) {
            return ((ChartColorPattern)chartFillPattern).getColor();
        }
        if (chartFillPattern instanceof ChartGradientPattern) {
            return ((ChartGradientPattern)chartFillPattern).getStartColor().getColor();
        }
        if (chartFillPattern instanceof RoundGradientContext) {
            // empty if block
        }
        return new Color(255, 255, 255);
    }

    private void clear() {
        double d;
        if (this.calculatedMaxMin) {
            return;
        }
        double d2 = 3.4028234663852886E38;
        double d3 = -3.4028234663852886E38;
        if (this.blue()) {
            d = 0.0;
            this.max = d3;
            this.min = d2;
            for (Object k : this.originGroups.keySet()) {
                Double[] doubleArray = (Double[])this.originGroups.get(k);
                if (doubleArray == null || doubleArray.length < 3) continue;
                d = this.colorByFields(doubleArray[2]);
                this.max = this.max < d ? d : this.max;
                d = this.colorByFields(doubleArray[1]);
                this.min = this.min > d ? d : this.min;
            }
        } else {
            for (int i = 0; i < this.colorBySumList.size(); ++i) {
                Vector vector = (Vector)this.colorBySumList.get(i);
                for (int j = 0; j < vector.size(); ++j) {
                    double d4 = (Double)vector.get(j);
                    if (this.useLG) {
                        if (d4 <= 0.0 || new Double(d4).isNaN()) continue;
                        d4 = d4 < 0.0 ? -Math.log10(-d4) : Math.log10(d4);
                        d4 = d4 < -3.4028234663852886E38 ? -3.4028234663852886E38 : d4;
                        vector.set(j, new Double(d4));
                    } else if (this.useLN) {
                        if (d4 <= 0.0 || new Double(d4).isNaN()) continue;
                        d4 = d4 < 0.0 ? -Math.log(-d4) : Math.log(d4);
                        d4 = d4 < -3.4028234663852886E38 ? -3.4028234663852886E38 : d4;
                        vector.set(j, new Double(d4));
                    }
                    if (d4 < d2) {
                        this.min = d4;
                        d2 = d4;
                    }
                    if (!(d4 > d3)) continue;
                    this.max = d4;
                    d3 = d4;
                }
                Object[] objectArray = vector.toArray();
                Arrays.sort(objectArray);
                vector.clear();
                for (int j = 0; j < objectArray.length; ++j) {
                    vector.add((Double)objectArray[j]);
                }
            }
        }
        double d5 = this.max = this.max < this.min ? this.min : this.max;
        if (this.mapZeroToWhite && this.max > 0.0 && this.min < 0.0 && this.type == 3) {
            d = Math.max(Math.abs(this.min), Math.abs(this.max));
            this.startClr = ChartMapColorInfo.getMapColor(Math.abs(this.min), 0.0, d, Color.white, this.startClr, false, Color.white);
            this.endClr = ChartMapColorInfo.getMapColor(Math.abs(this.max), 0.0, d, Color.white, this.endClr, false, Color.white);
        }
        this.calculatedMaxMin = true;
    }

    private double colorByFields(double d) {
        double d2 = d;
        if (this.useLG) {
            if (d2 <= 0.0) {
                return Double.NaN;
            }
            if (new Double(d2).isNaN()) {
                return Double.NaN;
            }
            d2 = d2 < 0.0 ? -Math.log10(-d2) : Math.log10(d2);
            d2 = d2 < -3.4028234663852886E38 ? -3.4028234663852886E38 : d2;
        } else if (this.useLN) {
            if (d2 <= 0.0) {
                return Double.NaN;
            }
            if (new Double(d2).isNaN()) {
                return Double.NaN;
            }
            d2 = d2 < 0.0 ? -Math.log(-d2) : Math.log(d2);
            d2 = d2 < -3.4028234663852886E38 ? -3.4028234663852886E38 : d2;
        }
        return d2;
    }

    public Vector getGroupList() {
        if (this.numValFormat != null && this.colorByGroupList != null && this.colorByGroupList.size() > 0 && this.numberDataIndexs != null && this.numberDataIndexs.size() > 0) {
            int n;
            Vector vector = new Vector();
            int[] nArray = new int[this.numberDataIndexs.size()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = (Integer)this.numberDataIndexs.get(n);
            }
            for (n = 0; n < this.colorByGroupList.size(); ++n) {
                Vector<String> vector2 = new Vector<String>();
                Vector vector3 = (Vector)this.colorByGroupList.get(n);
                for (int i = 0; i < vector3.size(); ++i) {
                    if (this.getIndex(i, nArray)) {
                        try {
                            Float f = new Float((String)vector3.get(i));
                            vector2.add(this.numValFormat.filter(f));
                        }
                        catch (Exception exception) {
                            vector2.add((String)vector3.get(i));
                        }
                        continue;
                    }
                    vector2.add((String)vector3.get(i));
                }
                vector.add(vector2);
            }
            return this.format(vector);
        }
        return this.format(this.colorByGroupList);
    }

    public Vector getGroupValues() {
        return this.colorBySumList;
    }

    public void setStartColor(Color color) {
        this.startClr = color;
    }

    public void setEndColor(Color color) {
        this.endClr = color;
    }

    public void setMapZeroToWhite(boolean bl) {
        this.mapZeroToWhite = bl;
    }

    public Color getColor(double d) {
        this.clear();
        if (this.useLG) {
            d = (d = Math.log10(d)) < -3.4028234663852886E38 ? -3.4028234663852886E38 : d;
        } else if (this.useLN) {
            d = (d = Math.log(d)) < -3.4028234663852886E38 ? -3.4028234663852886E38 : d;
        }
        Color color = null;
        color = ChartMapColorInfo.getMapColor(d, this.min, this.max, this.startClr, this.endClr, this.mapZeroToWhite, this.zeroClr);
        return color;
    }

    public Color getUsedColor(Vector vector, double d) {
        String string = this.getUsedFillColor(vector, d);
        ChartFillPattern chartFillPattern = ChartRenderTools.mapFillPattern(string);
        if (chartFillPattern instanceof ChartColorPattern) {
            return ((ChartColorPattern)chartFillPattern).getColor();
        }
        return Color.white;
    }

    public String getUsedFillColor(Vector vector, double d) {
        this.addAll();
        this.clear();
        double d2 = d;
        if (this.type == 3) {
            if (vector != null && vector.size() > 0 && vector.get(vector.size() - 1) != null && ((String)vector.get(vector.size() - 1)).equalsIgnoreCase("null")) {
                return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
            }
            if (this.getNullValueIndex(vector) >= 0) {
                return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
            }
            if (this.useLG) {
                if (d2 <= 0.0) {
                    return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
                }
                if (new Double(d2).isNaN()) {
                    return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
                }
                d2 = (d2 = Math.log10(d2)) < -3.4028234663852886E38 ? -3.4028234663852886E38 : d2;
            } else if (this.useLN) {
                if (d2 <= 0.0) {
                    return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
                }
                if (new Double(d2).isNaN()) {
                    return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
                }
                d2 = (d2 = Math.log(d2)) < -3.4028234663852886E38 ? -3.4028234663852886E38 : d2;
            }
            Color color = ChartMapColorInfo.getMapColor(d2, this.min, this.max, this.startClr, this.endClr, this.mapZeroToWhite, this.zeroClr);
            return ChartRenderTools.mapPatternString(new ChartColorPattern(color));
        }
        if (this.type == 2) {
            if (this.isVaryColor) {
                if (this.blue()) {
                    int n = this.colorByList(this.originColorByGroups, vector);
                    if ((n = ((Double[])this.originGroups.get(this.originColorByGroups.get(n)))[0].intValue()) >= 0) {
                        return (String)this.patternList.get(n % this.patternList.size());
                    }
                    return (String)this.patternList.get(0);
                }
                int n = this.SEDU(vector);
                return (String)this.patternList.get(n % this.patternList.size());
            }
            return (String)this.patternList.get(0);
        }
        if (this.type == 1) {
            return (String)this.patternList.get(0);
        }
        if (this.type == 4) {
            Object object;
            Serializable serializable;
            if (vector != null && vector.size() > 0 && vector.get(vector.size() - 1) != null && ((String)vector.get(vector.size() - 1)).equalsIgnoreCase("null")) {
                return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
            }
            if (this.getNullValueIndex(vector) >= 0) {
                return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
            }
            if (this.useLG) {
                if (d2 <= 0.0) {
                    return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
                }
                if (new Double(d2).isNaN()) {
                    return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
                }
                d2 = (d2 = Math.log10(d2)) < -3.4028234663852886E38 ? -3.4028234663852886E38 : d2;
            } else if (this.useLN) {
                if (d2 <= 0.0) {
                    return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
                }
                if (new Double(d2).isNaN()) {
                    return ChartRenderTools.mapPatternString(new ChartColorPattern(this.nullClr));
                }
                d2 = (d2 = Math.log(d2)) < -3.4028234663852886E38 ? -3.4028234663852886E38 : d2;
            }
            int n = this.SEDU(vector);
            Color color = null;
            Color color2 = null;
            Color color3 = null;
            ChartFillPattern chartFillPattern = null;
            if (!this.blue()) {
                chartFillPattern = (ChartFillPattern)this.colorList.get(n % this.colorList.size());
            } else {
                int n2 = this.colorByList(this.originColorByGroups, vector);
                n2 = ((Double[])this.originGroups.get(this.originColorByGroups.get(n2)))[0].intValue();
                chartFillPattern = (ChartFillPattern)this.colorList.get(n2 % this.colorList.size());
            }
            float f = 0.0f;
            if (chartFillPattern instanceof ChartColorPattern) {
                color3 = ((ChartColorPattern)chartFillPattern).getColor();
                color = ChartMapColorInfo.getHighColor(color3);
                color2 = color3;
                f = chartFillPattern.getAlpha();
            } else if (chartFillPattern instanceof ChartGradientPattern) {
                color = ((ChartGradientPattern)chartFillPattern).getStartColor().getColor();
                color2 = ((ChartGradientPattern)chartFillPattern).getEndColor().getColor();
                f = chartFillPattern.getAlpha();
            } else {
                if (chartFillPattern instanceof ChartTexturePattern) {
                    return ChartRenderTools.mapPatternString(chartFillPattern);
                }
                if (chartFillPattern instanceof RoundGradientPaint) {
                    return ChartRenderTools.mapPatternString(chartFillPattern);
                }
                color = Color.white;
                color2 = Color.white;
            }
            double d3 = 0.0;
            double d4 = 0.0;
            if (!this.blue()) {
                serializable = (Vector)this.colorBySumList.get(n);
                d3 = (Double)serializable.get(0);
                d4 = (Double)serializable.get(serializable.size() - 1);
            } else {
                int n3 = this.colorByList(this.originColorByGroups, vector);
                object = (Double[])this.originGroups.get(this.originColorByGroups.get(n3));
                d3 = object[1];
                d4 = object[2];
            }
            serializable = ChartMapColorInfo.getMapColor(d2, d3, d4, color, color2, this.mapZeroToWhite, this.zeroClr);
            object = new ChartColorPattern((Color)serializable);
            ((ChartColorPattern)object).setAlpha(f);
            return ChartRenderTools.mapPatternString((ChartFillPattern)object);
        }
        return ChartRenderTools.mapPatternString((ChartFillPattern)this.colorList.get(0));
    }

    private int colorByGroupList(Vector vector, Vector vector2) {
        int n = -1;
        if (vector != null && vector2 != null) {
            boolean bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                bl = true;
                for (int j = 0; j < vector2.size(); ++j) {
                    if (string.indexOf((String)vector2.get(j)) >= 0) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return i;
            }
        }
        return n;
    }

    private int colorByList(Vector vector, Vector vector2) {
        int n = 0;
        if (vector != null && vector2 != null) {
            int n2;
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.colorByFields != null && this.colorByFields.size() > 0) {
                for (n3 = 0; n3 < this.colorByFields.size(); ++n3) {
                    n2 = (Integer)this.colorByFields.get(n3);
                    stringBuffer.append((String)vector2.get(--n2));
                    if (n3 == this.colorByFields.size() - 1) continue;
                    stringBuffer.append(";");
                }
            } else {
                for (n3 = 0; n3 < vector2.size(); ++n3) {
                    stringBuffer.append((String)vector2.get(n3));
                    if (n3 == vector2.size() - 1) continue;
                    stringBuffer.append(";");
                }
            }
            String string = stringBuffer.toString();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                String string2 = (String)vector.get(n2);
                if (string2 == null || string.indexOf(string2) < 0) continue;
                return n2;
            }
        }
        return n;
    }

    public void setUseLG(boolean bl) {
        this.useLG = bl;
    }

    public void setUseLN(boolean bl) {
        this.useLN = bl;
    }

    public void calculate() {
        this.calculatedMaxMin = true;
        this.clear();
    }

    public void setNullValue(List list) {
        if (list == null) {
            return;
        }
        this.nullValues.add(list);
    }

    int getNullValueIndex(List list) {
        boolean bl = false;
        for (int i = 0; i < this.nullValues.size(); ++i) {
            List list2 = (List)this.nullValues.get(i);
            if (list2.size() != list.size()) continue;
            bl = true;
            for (int j = 0; j < list.size(); ++j) {
                if (list.get(j) == null || ((String)list.get(j)).equals(list2.get(j))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public void resetGroupList() {
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public Color getStartColor() {
        return this.startClr;
    }

    public Color getEndColor() {
        return this.endClr;
    }

    public void setColorByFieldIndexs(List list) {
        this.colorByFields = list;
    }

    public List getColorByFieldIndexs() {
        return this.colorByFields;
    }

    public void setConditionalFillExpressions(List list) {
        this.conditionalFillExps = list;
    }

    public void setConditionalFills(List list) {
        this.conditionalFillColors = list;
    }

    public List getConditionalFillExpressions() {
        return this.conditionalFillExps;
    }

    public List getConditionalFills() {
        return this.conditionalFillColors;
    }

    public void setZeroColor(Color color) {
        if (color == null) {
            return;
        }
        this.zeroClr = color;
    }

    public Color getZeroColor() {
        return this.zeroClr;
    }

    public void setNullColor(Color color) {
        if (color == null) {
            return;
        }
        this.nullClr = color;
    }

    public Color getNullColor() {
        return this.nullClr;
    }

    public void setPatternList(List list) {
        this.patternList = list;
    }

    public void setReverseColor(boolean bl) {
        this.reverse = bl;
    }

    public boolean getReverseColor() {
        return this.reverse;
    }

    public void setLegendFilter(ChartDataFilter chartDataFilter) {
        this.numValFormat = chartDataFilter;
    }

    public void setNumberDataIndex(List list) {
    }

    public boolean hasNumberDataIndex() {
        return this.setNumberDataIndexs;
    }

    boolean getIndex(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    void InitialOriginGroupNames(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        if (this.originColorByGroups == null) {
            this.originColorByGroups = new Vector();
        } else {
            this.originColorByGroups.clear();
        }
        if (this.originColorByGroups != null) {
            Set set = hashtable.keySet();
            for (String string : set) {
                if (string == null) continue;
                this.originColorByGroups.add(string);
            }
        }
    }

    public void setOriginGroupNames(Vector vector) {
        this.originGroupNames = vector;
    }

    public void setOriginGroupValues(Hashtable hashtable) {
        this.originGroups = hashtable;
        this.InitialOriginGroupNames(hashtable);
    }

    public void setHasFilter(boolean bl) {
        this.hasFileter = bl;
    }

    public Vector getOriginGroupNames() {
        return this.originGroupNames;
    }

    public Vector getColorByGroupList() {
        return this.format(this.colorByGroupList);
    }

    public void setIsVaryColor(boolean bl) {
        this.isVaryColor = bl;
    }

    public void setNumberDataIndexs(List list) {
        this.numberDataIndexs = list;
    }
}

