/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import chart.ChartComponent;
import chart.ChartCoordinatePaper;
import chart.ChartLabel;
import chart.ChartLegend;
import chart.ChartPlatform;
import chart.ChartShowValueCondition;
import chart.ChartShowValueConditionControl;
import chart.chart2d.Chart2DPaper;
import chart.chart3d.Chart3DPaper;
import chart.data.Chart1DDataSet;
import chart.data.Chart2DDataSet;
import chart.data.Chart3DDataSet;
import chart.data.Chart4DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataSetInfo;
import chart.data.ChartDataSetModel;
import chart.data.ChartDataUsedInfo;
import chart.data.ChartTypeInfo;
import chart.util.ChartHintLabel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ChartHtmlMapExport {
    private ChartPlatform IsShowLabelTips;
    private ChartDataSetModel SEDU;
    private ChartCoordinatePaper add;
    private Shape[][] addGraphLinkInfo;
    private Shape[] addLegendLinkInfo;
    private Shape[] addXLinkInfo;
    private int addZLinkInfo;
    private int append;
    private List axisToHtml = new ArrayList();
    private List bubbleObjectToHtml = new ArrayList();
    private List charAt = new ArrayList();
    public static final String TITLE = "title";
    public static final String SHAPE = "shape";
    public static final String COORDS = "coords";
    public static final String XVALUE = "xValue";
    public static final String ZVALUE = "zValue";
    public static final String XLINK = "xHyperLink";
    public static final String ZLINK = "zHyperLink";
    public static final String LINK = "hyperLink";
    public static final String YVALUE = "yValue";
    public static final String Y2VALUE = "y2Value";
    public static final String XLINKINFO = "xLinkInfo";
    public static final String ZLINKINFO = "zLinkInfo";
    public static final String GRAPHLINKINFO = "graphLinkInfo";
    public static final String LEGENDLINKINFO = "legendLinkInfo";
    public static final String INSTANCENAME = "instanceName";
    public static final String OBJECTTYPE = "objectType";
    public static final String PAPER = "paper";
    public static final String LEGEND = "legend";
    public static final String LABEL = "label";
    public static final String PLATFORM = "platform";
    private ChartLegend currentSegment;
    private Shape[] effect3DObjectToHtml;
    private Shape[] equals;
    private List get = new ArrayList();
    private List getArcAreaString = new ArrayList();

    public ChartHtmlMapExport(ChartPlatform chartPlatform) {
        this.IsShowLabelTips = chartPlatform;
        this.SEDU = chartPlatform.getDataSetModel();
        this.add = chartPlatform.getChartCoordinatePaper();
        this.currentSegment = chartPlatform.getChartLegend();
    }

    public void exportDHTML(String string, String string2, String string3) {
        this.IsShowLabelTips(string, string2, string3);
    }

    public void exportHTML(String string, String string2, String string3) {
        this.IsShowLabelTips(string, string2, string3);
    }

    private void IsShowLabelTips(String string, String string2, String string3) {
        Point point = this.add.getLocation();
        this.add(point);
        this.objectToHtml(point, string);
        this.axisToHtml(point, string2, string3);
        this.SEDU(point);
    }

    private void SEDU(Point point) {
        block11: {
            String string;
            HashMap<String, String> hashMap;
            int n;
            ChartDataSetInfo[] chartDataSetInfoArray = this.SEDU.getDatasetInfos();
            for (int i = 0; i < chartDataSetInfoArray.length; ++i) {
                int n2 = chartDataSetInfoArray[i].getChartType();
                int n3 = ChartTypeInfo.getPrimType(n2);
                if (n3 != 9 && n3 != 6 && n3 != 5 && n3 != 8 && n3 != 10 && n3 != 4 && n3 != 13) continue;
                return;
            }
            String[] stringArray = this.add.getYLabels();
            String[] stringArray2 = this.add.getY2Labels();
            this.effect3DObjectToHtml = this.add.getAxisYShapes();
            this.equals = this.add.getAxisY2Shapes();
            if (stringArray == null && stringArray2 == null) {
                return;
            }
            if (stringArray != null) {
                if (this.add.getProperties().getAxisYProperties().IsShowLabelTips()) {
                    for (n = 0; n < stringArray.length; ++n) {
                        hashMap = new HashMap<String, String>();
                        string = stringArray[n];
                        hashMap.put(YVALUE, string);
                        hashMap.put(TITLE, string);
                        this.get.add(hashMap);
                        if (this.effect3DObjectToHtml == null) continue;
                        this.getPolyAreaString(this.effect3DObjectToHtml[n], point, hashMap);
                    }
                } else {
                    for (n = 0; n < stringArray.length; ++n) {
                        hashMap = new HashMap();
                        string = stringArray[n];
                        hashMap.put(YVALUE, string);
                        this.get.add(hashMap);
                        if (this.effect3DObjectToHtml == null) continue;
                        this.getPolyAreaString(this.effect3DObjectToHtml[n], point, hashMap);
                    }
                }
            }
            if (stringArray2 == null) break block11;
            if (this.add.getProperties().getAxisY2Properties().IsShowLabelTips()) {
                for (n = 0; n < stringArray2.length; ++n) {
                    hashMap = new HashMap();
                    string = stringArray2[n];
                    hashMap.put(Y2VALUE, string);
                    hashMap.put(TITLE, string);
                    this.getArcAreaString.add(hashMap);
                    if (this.equals == null) continue;
                    this.getPolyAreaString(this.equals[n], point, hashMap);
                }
            } else {
                for (n = 0; n < stringArray2.length; ++n) {
                    hashMap = new HashMap();
                    string = stringArray2[n];
                    hashMap.put(Y2VALUE, string);
                    this.getArcAreaString.add(hashMap);
                    if (this.equals == null) continue;
                    this.getPolyAreaString(this.equals[n], point, hashMap);
                }
            }
        }
    }

    private void add(Point point) {
        int n;
        ChartDataSetInfo[] chartDataSetInfoArray = this.SEDU.getDatasetInfos();
        for (n = 0; n < chartDataSetInfoArray.length; ++n) {
            int n2 = chartDataSetInfoArray[n].getChartType();
            int n3 = ChartTypeInfo.getPrimType(n2);
            if (n3 != 13) continue;
            return;
        }
        if (!this.currentSegment.getProperties().isShowTips()) {
            return;
        }
        n = this.currentSegment.getOriLabels().length;
        Shape[] shapeArray = this.currentSegment.getLabelsShapes();
        Point point2 = this.currentSegment.getLocation();
        for (int i = 0; i < n; ++i) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(TITLE, this.currentSegment.getOriLabels()[i].getText());
            this.getRectAreaString(shapeArray[i], point2, hashMap);
            this.addLegendLinkInfo(i, hashMap);
            this.charAt.add(hashMap);
        }
    }

    public void objectToHtml(Point point, String string) {
        boolean bl = false;
        List list = this.SEDU.getChartDataSets();
        int n = list.size();
        boolean bl2 = false;
        if (this.add instanceof Chart2DPaper) {
            bl = ((Chart2DPaper)this.add).getProperties().isReversePaintingOrder();
            bl2 = ((Chart2DPaper)this.add).isScrollChart();
        }
        if (bl) {
            block24: for (int i = 0; i < n; ++i) {
                ChartDataSet chartDataSet = (ChartDataSet)list.get(i);
                this.addZLinkInfo = chartDataSet.getSeriesSize();
                this.append = !bl2 ? chartDataSet.getCategorySize() : this.IsShowLabelTips.showScrollLabelEnd() - this.IsShowLabelTips.showScrollLabelStart();
                int n2 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
                int n3 = ChartTypeInfo.getEffect(chartDataSet.getChartDataSetInfo().getChartType());
                this.addGraphLinkInfo = this.add.getItemShapes(i);
                if (this.addGraphLinkInfo == null) continue;
                switch (n3) {
                    case 0: {
                        switch (n2) {
                            case 9: {
                                this.bubbleObjectToHtml(point, string, (Chart3DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block24;
                            }
                            case 4: {
                                this.pieObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block24;
                            }
                            case 6: {
                                this.guageObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block24;
                            }
                            case 10: {
                                this.stockObjectToHtml(point, string, chartDataSet, this.addGraphLinkInfo);
                                continue block24;
                            }
                            case 8: {
                                this.scatterObjectToHtml(point, string, (Chart2DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block24;
                            }
                            case 13: {
                                this.addGraphLinkInfo(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block24;
                            }
                        }
                        this.normalObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                        continue block24;
                    }
                    case 4096: {
                        this.effect3DObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                    }
                }
            }
        } else {
            block25: for (int i = n - 1; i >= 0; --i) {
                ChartDataSet chartDataSet = (ChartDataSet)list.get(i);
                this.addZLinkInfo = chartDataSet.getSeriesSize();
                this.append = !bl2 ? chartDataSet.getCategorySize() : this.IsShowLabelTips.showScrollLabelEnd() - this.IsShowLabelTips.showScrollLabelStart();
                int n4 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
                int n5 = ChartTypeInfo.getEffect(chartDataSet.getChartDataSetInfo().getChartType());
                this.addGraphLinkInfo = this.add.getItemShapes(i);
                if (this.addGraphLinkInfo == null) continue;
                switch (n5) {
                    case 0: {
                        switch (n4) {
                            case 9: {
                                this.bubbleObjectToHtml(point, string, (Chart3DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block25;
                            }
                            case 4: {
                                this.pieObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block25;
                            }
                            case 6: {
                                this.guageObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block25;
                            }
                            case 10: {
                                this.stockObjectToHtml(point, string, chartDataSet, this.addGraphLinkInfo);
                                continue block25;
                            }
                            case 8: {
                                this.scatterObjectToHtml(point, string, (Chart2DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block25;
                            }
                            case 13: {
                                this.addGraphLinkInfo(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                                continue block25;
                            }
                        }
                        this.normalObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                        continue block25;
                    }
                    case 4096: {
                        this.effect3DObjectToHtml(point, string, (Chart1DDataSet)chartDataSet, this.addGraphLinkInfo);
                    }
                }
            }
        }
    }

    private void addGraphLinkInfo(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        for (int i = 0; i < this.addZLinkInfo; ++i) {
            for (int j = 0; j < this.append; ++j) {
                String string2;
                if (this.SEDU.getValueSqlType() == 0) {
                    if (chart1DDataSet.getValue(i, j) == null || this.addGraphLinkInfo[i][j] == null) continue;
                    string2 = this.add.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.SEDU, i, j) : chart1DDataSet.getFormatedHintValue(i, j);
                } else {
                    if (chart1DDataSet.getStringValues(i, j) == null || this.addGraphLinkInfo[i][j] == null) continue;
                    string2 = chart1DDataSet.getStringValues(i, j);
                }
                String string3 = this.SEDU.getSeriesName(i % this.SEDU.getSeriesCount()) == null ? null : this.SEDU.mapRowName(this.SEDU.getSeriesName(i % this.SEDU.getSeriesCount()).toString().trim());
                String string4 = this.SEDU.getCategoryName(j) == null ? null : this.SEDU.getCategoryName(j).toString().trim();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (string == null || string.trim().equals("")) {
                    hashMap.put(XVALUE, string4);
                    hashMap.put(ZVALUE, string3);
                } else {
                    hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string3, string4));
                }
                this.getPolyAreaString(this.addGraphLinkInfo[i][j], point, hashMap);
                hashMap.put(TITLE, string2);
                this.addGraphLinkInfo(i, j, (ChartDataSet)chart1DDataSet, hashMap);
                this.charAt.add(hashMap);
            }
        }
    }

    public void normalObjectToHtml(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (this.add instanceof Chart2DPaper) {
            bl = ((Chart2DPaper)this.add).isScrollChart();
        }
        int n = bl ? this.IsShowLabelTips.showScrollLabelEnd() - this.IsShowLabelTips.showScrollLabelStart() : this.append;
        int n2 = this.getUnitStep(this.add.getGraphArea(), n);
        int n3 = this.getUnitStep(this.add.getGraphArea(), this.addZLinkInfo);
        if (n2 < 1) {
            n2 = 1;
        }
        if (n3 < 1) {
            n3 = 1;
        }
        for (int i = 0; i < this.addZLinkInfo; i += n3) {
            for (int j = n - 1; j >= 0; j -= n2) {
                if (chart1DDataSet.getValue(i, j) == null) continue;
                string2 = this.SEDU.getSeriesName(i % this.SEDU.getSeriesCount()) == null ? null : this.SEDU.mapRowName(this.SEDU.getSeriesName(i % this.SEDU.getSeriesCount()).toString().trim());
                string3 = this.SEDU.getCategoryName(j) == null ? null : this.SEDU.getCategoryName(j).toString().trim();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (this.SEDU.isTurnedXZ()) {
                    String string4 = string2;
                    string2 = string3;
                    string3 = string4;
                }
                if (string == null || string.trim().equals("")) {
                    hashMap.put(XVALUE, string3);
                    hashMap.put(ZVALUE, string2);
                } else {
                    hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string2, string3));
                }
                String string5 = this.add instanceof Chart2DPaper ? (this.add.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.SEDU, i, j) : chart1DDataSet.getFormatedHintValue(i, j)) : chart1DDataSet.getFormatedHintValue(i, j);
                hashMap.put(TITLE, string5);
                this.addGraphLinkInfo(i, j, (ChartDataSet)chart1DDataSet, hashMap);
                this.getIntRectAreaString(shapeArray[i][j], point, hashMap);
                this.charAt.add(hashMap);
            }
        }
    }

    public void pieObjectToHtml(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < this.addZLinkInfo; ++i) {
            for (int j = 0; j < this.append; ++j) {
                if (chart1DDataSet.getValue(i, j) == null) continue;
                int n = this.SEDU.getSeriesCount();
                string2 = this.SEDU.getSeriesName(i % n) == null ? null : this.SEDU.mapRowName(this.SEDU.getSeriesName(i % n).toString().trim());
                string3 = this.SEDU.getCategoryName(j) == null ? null : this.SEDU.getCategoryName(j).toString().trim();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (string == null || string.trim().equals("")) {
                    hashMap.put(XVALUE, string3);
                    hashMap.put(ZVALUE, string2);
                } else {
                    hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string2, string3));
                }
                String string4 = this.add instanceof Chart2DPaper ? (this.add.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.SEDU, i, j) : chart1DDataSet.getFormatedHintValue(i, j)) : chart1DDataSet.getFormatedHintValue(i, j);
                hashMap.put(TITLE, string4);
                this.getArcAreaString(shapeArray[i][j], point, hashMap);
                this.charAt.add(hashMap);
                this.addGraphLinkInfo(i, j, (ChartDataSet)chart1DDataSet, hashMap);
            }
        }
    }

    public void scatterObjectToHtml(Point point, String string, Chart2DDataSet chart2DDataSet, Shape[][] shapeArray) {
        for (int i = 0; i < this.addZLinkInfo; ++i) {
            for (int j = 0; j < this.append; ++j) {
                if (chart2DDataSet.getX(i, j) == null || chart2DDataSet.getY(i, j) == null) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String string2 = "X: " + this.SEDU.getFormatedHintValue(chart2DDataSet.getX(i, j)) + "\n" + "Y:" + this.SEDU.getFormatedHintValue(chart2DDataSet.getY(i, j));
                if (this.add instanceof Chart2DPaper && this.add.properties.isShowCategoryAndSeries()) {
                    string2 = ChartHintLabel.hintLabelForScatter(chart2DDataSet, this.SEDU, i, j) + "\n" + string2;
                }
                this.getRectAreaString(shapeArray[i][j], point, hashMap);
                hashMap.put(TITLE, string2);
                this.addGraphLinkInfo(i, j, chart2DDataSet, hashMap);
                this.charAt.add(hashMap);
            }
        }
    }

    public void bubbleObjectToHtml(Point point, String string, Chart3DDataSet chart3DDataSet, Shape[][] shapeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = chart3DDataSet.getValueNames();
        for (int i = this.addZLinkInfo - 1; i >= 0; --i) {
            for (int j = this.append - 1; j >= 0; --j) {
                Object object;
                Object object2;
                if (chart3DDataSet.getX(i, j) == null || chart3DDataSet.getY(i, j) == null || chart3DDataSet.getZ(i, j) == null || stringArray == null) continue;
                if (stringArray.length < 2) {
                    // empty if block
                }
                ArrayList arrayList = new ArrayList();
                if (this.add instanceof Chart2DPaper) {
                    if (this.add.properties.isShowCategoryAndSeries()) {
                        if (chart3DDataSet.getChartDataSetModel().getSeriesN() != null && !chart3DDataSet.getChartDataSetModel().getSeriesN().equals("")) {
                            stringBuffer.append(chart3DDataSet.getChartDataSetModel().getSeriesN());
                            stringBuffer.append(" : ");
                            object2 = chart3DDataSet.getChartDataSetModel().getSeriesNames().get(i % chart3DDataSet.getChartDataSetModel().getSeriesNames().size());
                            if (object2 != null) {
                                object = chart3DDataSet.getFormatedHintSeriesValue(chart3DDataSet.getChartDataSetModel().getSeriesNames().get(i % chart3DDataSet.getChartDataSetModel().getSeriesNames().size()), i % chart3DDataSet.getChartDataSetModel().getSeriesNames().size());
                                stringBuffer.append((String)object);
                            }
                            stringBuffer.append(" ");
                            stringBuffer.append("\n");
                        }
                        if (chart3DDataSet.getChartDataSetModel().getCategoryNmae() != null && !chart3DDataSet.getChartDataSetModel().getCategoryNmae().equals("")) {
                            stringBuffer.append(chart3DDataSet.getChartDataSetModel().getCategoryNmae());
                            object2 = chart3DDataSet.getChartDataSetModel().getCategoryNames().get(j);
                            stringBuffer.append(" : ");
                            if (object2 != null) {
                                object = chart3DDataSet.getFormatedHintCategoryValue(chart3DDataSet.getChartDataSetModel().getCategoryName(j), j);
                                stringBuffer.append((String)object);
                            }
                            stringBuffer.append(" ");
                            stringBuffer.append("\n");
                        }
                    }
                    if (stringArray.length % 2 == 0) {
                        stringBuffer.append(chart3DDataSet.getCategoryName());
                        stringBuffer.append(" : ");
                        if (chart3DDataSet.isUseCategoryAsX()) {
                            object2 = chart3DDataSet.getChartDataSetModel().getCategoryName(j);
                            if (object2 != null) {
                                stringBuffer.append(object2.toString());
                            }
                        } else {
                            stringBuffer.append(chart3DDataSet.getFormatedHintValue(chart3DDataSet.getX(i, j)));
                        }
                    } else {
                        stringBuffer.append(stringArray[0]);
                        stringBuffer.append(" : ");
                        stringBuffer.append(chart3DDataSet.getFormatedHintValue(chart3DDataSet.getX(i, j)));
                    }
                    stringBuffer.append(" ");
                    stringBuffer.append("\n");
                    int n = i / chart3DDataSet.getChartDataSetModel().getSeriesCount();
                    int n2 = 0;
                    n2 = stringArray.length % 2 != 0 ? (n2 += n * 2 + 1) : (n2 += n * 2);
                    n2 = n2 >= stringArray.length ? stringArray.length - 1 : n2;
                    stringBuffer.append(stringArray[n2]);
                    stringBuffer.append(" : ");
                    stringBuffer.append(chart3DDataSet.getFormatedHintValue(chart3DDataSet.getY(i, j)));
                    stringBuffer.append(" ");
                    stringBuffer.append("\n");
                    n2 = ++n2 >= stringArray.length ? stringArray.length - 1 : n2;
                    stringBuffer.append(stringArray[n2]);
                    stringBuffer.append(" : ");
                    stringBuffer.append(chart3DDataSet.getFormatedHintValue(chart3DDataSet.getZ(i, j)));
                }
                object2 = new HashMap<String, String>();
                object = new String[arrayList.size()];
                for (int k = 0; k < ((String[])object).length; ++k) {
                    object[k] = arrayList.get(k).toString();
                }
                ((HashMap)object2).put(TITLE, stringBuffer.toString());
                this.charAt.add(object2);
                stringBuffer.setLength(0);
                this.getCircleAreaString(shapeArray[i][j], point, (HashMap)object2);
                this.addGraphLinkInfo(i, j, chart3DDataSet, (HashMap)object2);
            }
        }
    }

    public void bubbleObjectToHtmlV10(Point point, String string, Chart3DDataSet chart3DDataSet, Shape[][] shapeArray) {
        for (int i = 0; i < this.addZLinkInfo; ++i) {
            for (int j = 0; j < this.append; ++j) {
                if (chart3DDataSet.getX(i, j) == null || chart3DDataSet.getY(i, j) == null || chart3DDataSet.getZ(i, j) == null) continue;
                String string2 = "X: " + this.SEDU.getFormatedHintValue(chart3DDataSet.getX(i, j)) + "\n" + "Y:" + this.SEDU.getFormatedHintValue(chart3DDataSet.getY(i, j)) + "\n" + "R:" + this.SEDU.getFormatedHintValue(chart3DDataSet.getZ(i, j));
                if (this.add instanceof Chart2DPaper && this.add.properties.isShowCategoryAndSeries()) {
                    string2 = ChartHintLabel.hintLabelForbubble(chart3DDataSet, this.SEDU, i, j) + "\n" + string2;
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(TITLE, string2);
                this.charAt.add(hashMap);
                this.getCircleAreaString(shapeArray[i][j], point, hashMap);
            }
        }
    }

    public void stockObjectToHtml(Point point, String string, ChartDataSet chartDataSet, Shape[][] shapeArray) {
        int n = ChartTypeInfo.getSeriesType(chartDataSet.getChartDataSetInfo().getChartType());
        switch (n) {
            case 65536: {
                for (int i = 0; i < this.addZLinkInfo; ++i) {
                    for (int j = 0; j < this.append; ++j) {
                        if (((Chart2DDataSet)chartDataSet).getX(i, j) == null || ((Chart2DDataSet)chartDataSet).getY(i, j) == null) continue;
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        String string2 = "H: " + this.SEDU.getFormatedHintValue(((Chart2DDataSet)chartDataSet).getX(i, j)) + "\n" + "L:" + this.SEDU.getFormatedHintValue(((Chart2DDataSet)chartDataSet).getY(i, j));
                        if (this.add instanceof Chart2DPaper && this.add.properties.isShowCategoryAndSeries() && this.SEDU.getCategoryNmae() != null) {
                            string2 = " " + this.SEDU.getCategoryNmae() + ": " + chartDataSet.getFormatedHintCategoryValue(this.SEDU.getCategoryName(j), j) + string2;
                        }
                        this.getRectAreaString(shapeArray[i][j], point, hashMap);
                        hashMap.put(TITLE, string2);
                        this.addGraphLinkInfo(i, j, chartDataSet, hashMap);
                        this.charAt.add(hashMap);
                    }
                }
                break;
            }
            case 131072: {
                for (int i = 0; i < this.addZLinkInfo; ++i) {
                    for (int j = 0; j < this.append; ++j) {
                        if (((Chart3DDataSet)chartDataSet).getX(i, j) == null || ((Chart3DDataSet)chartDataSet).getY(i, j) == null || ((Chart3DDataSet)chartDataSet).getZ(i, j) == null) continue;
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        String string3 = "H: " + ((Chart3DDataSet)chartDataSet).getX(i, j).toString() + "\n" + "L:" + ((Chart3DDataSet)chartDataSet).getY(i, j).toString() + "\n" + "C:" + ((Chart3DDataSet)chartDataSet).getZ(i, j);
                        if (this.add instanceof Chart2DPaper && this.add.properties.isShowCategoryAndSeries() && this.SEDU.getCategoryNmae() != null) {
                            string3 = " " + this.SEDU.getCategoryNmae() + ": " + chartDataSet.getFormatedHintCategoryValue(this.SEDU.getCategoryName(j), j) + string3;
                        }
                        this.getRectAreaString(shapeArray[i][j], point, hashMap);
                        hashMap.put(TITLE, string3);
                        this.addGraphLinkInfo(i, j, chartDataSet, hashMap);
                        this.charAt.add(hashMap);
                    }
                }
                break;
            }
            case 196608: {
                for (int i = 0; i < this.addZLinkInfo; ++i) {
                    for (int j = 0; j < this.append; ++j) {
                        if (((Chart4DDataSet)chartDataSet).getV1(i, j) == null || ((Chart4DDataSet)chartDataSet).getV2(i, j) == null || ((Chart4DDataSet)chartDataSet).getV3(i, j) == null || ((Chart4DDataSet)chartDataSet).getV4(i, j) == null) continue;
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        String string4 = "O: " + ((Chart4DDataSet)chartDataSet).getV1(i, j).toString() + "\n" + "H: " + ((Chart4DDataSet)chartDataSet).getV2(i, j).toString() + "\n" + "L:" + ((Chart4DDataSet)chartDataSet).getV3(i, j).toString() + "\n" + "C:" + ((Chart4DDataSet)chartDataSet).getV4(i, j);
                        if (this.add instanceof Chart2DPaper && this.add.properties.isShowCategoryAndSeries() && this.SEDU.getCategoryNmae() != null) {
                            string4 = " " + this.SEDU.getCategoryNmae() + ": " + chartDataSet.getFormatedHintCategoryValue(this.SEDU.getCategoryName(j), j) + string4;
                        }
                        hashMap.put(TITLE, string4);
                        this.getRectAreaString(shapeArray[i][j], point, hashMap);
                        this.charAt.add(hashMap);
                        this.addGraphLinkInfo(i, j, chartDataSet, hashMap);
                    }
                }
                break;
            }
        }
    }

    public void guageObjectToHtml(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (ChartTypeInfo.getSubType(chart1DDataSet.getChartDataSetInfo().getChartType()) == 512) {
            bl = chart1DDataSet.getChartDataSetModel().isOneGroup();
            this.addZLinkInfo = bl ? 3 : chart1DDataSet.getSeriesSize();
        }
        for (int i = 0; i < this.addZLinkInfo; ++i) {
            for (int j = 0; j < this.append; ++j) {
                int n = i;
                if (bl) {
                    n = 0;
                }
                if (chart1DDataSet.getValue(n, j) == null) continue;
                string2 = this.SEDU.getSeriesName(n % this.SEDU.getSeriesCount()) == null ? null : this.SEDU.mapRowName(this.SEDU.getSeriesName(n % this.SEDU.getSeriesCount()).toString().trim());
                string3 = this.SEDU.getCategoryName(j) == null ? null : this.SEDU.getCategoryName(j).toString().trim();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (string == null || string.trim().equals("")) {
                    hashMap.put(XVALUE, string3);
                    hashMap.put(ZVALUE, string2);
                } else {
                    hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string2, string3));
                }
                String string4 = this.add instanceof Chart2DPaper ? (this.add.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.SEDU, n, j) : chart1DDataSet.getFormatedHintValue(n, j)) : chart1DDataSet.getFormatedHintValue(n, j);
                if (ChartTypeInfo.getSubType(chart1DDataSet.getChartDataSetInfo().getChartType()) == 512) {
                    this.getCircleAreaString(shapeArray[i][j], point, hashMap);
                } else {
                    this.getPolyAreaString(shapeArray[i][j], point, hashMap);
                }
                hashMap.put(TITLE, string4);
                this.charAt.add(hashMap);
                this.addGraphLinkInfo(i, j, (ChartDataSet)chart1DDataSet, hashMap);
            }
        }
    }

    public void effect3DObjectToHtml(Point point, String string, Chart1DDataSet chart1DDataSet, Shape[][] shapeArray) {
        for (int i = 0; i < this.addZLinkInfo; ++i) {
            for (int j = 0; j < this.append; ++j) {
                if (chart1DDataSet.getValue(i, j) == null || shapeArray[i][j] == null) continue;
                String string2 = this.SEDU.getSeriesName(i % this.SEDU.getSeriesCount()) == null ? null : this.SEDU.mapRowName(this.SEDU.getSeriesName(i % this.SEDU.getSeriesCount()).toString().trim());
                String string3 = this.SEDU.getCategoryName(j) == null ? null : this.SEDU.getCategoryName(j).toString().trim();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (this.SEDU.isTurnedXZ()) {
                    String string4 = string2;
                    string2 = string3;
                    string3 = string4;
                }
                if (string == null || string.trim().equals("")) {
                    hashMap.put(XVALUE, string3);
                    hashMap.put(ZVALUE, string2);
                } else {
                    hashMap.put(LINK, ChartHtmlMapExport.parseHyperLink(string, string2, string3));
                }
                String string5 = this.add instanceof Chart3DPaper ? (this.add.properties.isShowCategoryAndSeries() ? ChartHintLabel.hintLbaelForNormalObjectToHtml(chart1DDataSet, this.SEDU, i, j) : chart1DDataSet.getFormatedHintValue(i, j)) : chart1DDataSet.getFormatedHintValue(i, j);
                this.getPolyAreaString(shapeArray[i][j], point, hashMap);
                hashMap.put(TITLE, string5);
                this.addGraphLinkInfo(i, j, (ChartDataSet)chart1DDataSet, hashMap);
                this.charAt.add(hashMap);
            }
        }
    }

    public void axisToHtml(Point point, String string, String string2) {
        String string3;
        HashMap<String, String> hashMap;
        int n;
        int n2;
        ChartDataSetInfo[] chartDataSetInfoArray = this.SEDU.getDatasetInfos();
        for (int i = 0; i < chartDataSetInfoArray.length; ++i) {
            int n3 = chartDataSetInfoArray[i].getChartType();
            int n4 = ChartTypeInfo.getPrimType(n3);
            if (n4 != 9 && n4 != 6 && n4 != 5 && n4 != 8 && n4 != 10 && n4 != 4 && n4 != 13) continue;
            return;
        }
        String[] stringArray = this.add.getXLabels();
        String[] stringArray2 = this.add.getZLabels();
        this.addLegendLinkInfo = this.add.getAxisXShapes();
        this.addXLinkInfo = this.add.getAxisZShapes();
        if (stringArray == null) {
            return;
        }
        if (string == null || string.trim().equals("")) {
            n2 = this.add.getAxisXLabelStep();
            if (n2 < 1) {
                n2 = 1;
            }
            if (this.add.getProperties().getAxisXProperties().IsShowLabelTips()) {
                for (n = 0; n < stringArray.length; n += n2) {
                    hashMap = new HashMap<String, String>();
                    string3 = stringArray[n];
                    hashMap.put(XVALUE, string3);
                    hashMap.put(TITLE, string3);
                    this.axisToHtml.add(hashMap);
                    if (this.addLegendLinkInfo != null) {
                        this.getPolyAreaString(this.addLegendLinkInfo[n], point, hashMap);
                    }
                    this.addXLinkInfo(n, hashMap);
                }
            } else {
                for (n = 0; n < stringArray.length; n += n2) {
                    hashMap = new HashMap();
                    string3 = stringArray[n];
                    hashMap.put(XVALUE, string3);
                    this.axisToHtml.add(hashMap);
                    if (this.addLegendLinkInfo != null) {
                        this.getPolyAreaString(this.addLegendLinkInfo[n], point, hashMap);
                    }
                    this.addXLinkInfo(n, hashMap);
                }
            }
        } else {
            n2 = this.add.getAxisXLabelStep();
            if (n2 < 1) {
                n2 = 1;
            }
            if (this.add.getProperties().getAxisXProperties().IsShowLabelTips()) {
                for (n = 0; n < stringArray.length; n += n2) {
                    hashMap = new HashMap();
                    string3 = ChartHtmlMapExport.parseXHyperLink(string, stringArray[n]);
                    hashMap.put(XLINK, string3);
                    hashMap.put(TITLE, stringArray[n]);
                    this.axisToHtml.add(hashMap);
                    if (this.addLegendLinkInfo != null) {
                        this.getPolyAreaString(this.addLegendLinkInfo[n], point, hashMap);
                    }
                    this.addXLinkInfo(n, hashMap);
                }
            } else {
                for (n = 0; n < stringArray.length; n += n2) {
                    hashMap = new HashMap();
                    string3 = ChartHtmlMapExport.parseXHyperLink(string, stringArray[n]);
                    hashMap.put(XLINK, string3);
                    this.axisToHtml.add(hashMap);
                    if (this.addLegendLinkInfo != null) {
                        this.getPolyAreaString(this.addLegendLinkInfo[n], point, hashMap);
                    }
                    this.addXLinkInfo(n, hashMap);
                }
            }
        }
        if (stringArray2 == null) {
            return;
        }
        if (string2 == null || string2.trim().equals("")) {
            n2 = this.getUnitStep(this.add.getGraphArea(), stringArray2.length);
            if (n2 < 1) {
                n2 = 1;
            }
            if (this.add.getProperties().getAxisZProperties().IsShowLabelTips()) {
                for (n = 0; n < stringArray2.length; n += n2) {
                    hashMap = new HashMap();
                    hashMap.put(ZVALUE, stringArray2[n]);
                    hashMap.put(TITLE, stringArray2[n]);
                    if (this.addXLinkInfo != null) {
                        this.getPolyAreaString(this.addXLinkInfo[n], point, hashMap);
                    }
                    this.bubbleObjectToHtml.add(hashMap);
                    this.addZLinkInfo(n, hashMap);
                }
            } else {
                for (n = 0; n < stringArray2.length; n += n2) {
                    hashMap = new HashMap();
                    string3 = stringArray2[n];
                    hashMap.put(ZVALUE, string3);
                    this.bubbleObjectToHtml.add(hashMap);
                    if (this.addXLinkInfo != null) {
                        this.getPolyAreaString(this.addXLinkInfo[n], point, hashMap);
                    }
                    this.addZLinkInfo(n, hashMap);
                }
            }
        } else {
            n2 = this.getUnitStep(this.add.getGraphArea(), stringArray2.length);
            if (n2 < 1) {
                n2 = 1;
            }
            if (this.add.getProperties().getAxisZProperties().IsShowLabelTips()) {
                for (n = 0; n < stringArray2.length; n += n2) {
                    hashMap = new HashMap();
                    string3 = ChartHtmlMapExport.parseZHyperLink(string2, stringArray2[n]);
                    hashMap.put(ZLINK, string3);
                    hashMap.put(TITLE, stringArray2[n]);
                    if (this.addXLinkInfo != null) {
                        this.getPolyAreaString(this.addXLinkInfo[n], point, hashMap);
                    }
                    this.bubbleObjectToHtml.add(hashMap);
                    this.addZLinkInfo(n, hashMap);
                }
            } else {
                for (n = 0; n < stringArray2.length; n += n2) {
                    hashMap = new HashMap();
                    string3 = ChartHtmlMapExport.parseZHyperLink(string2, stringArray2[n]);
                    hashMap.put(ZLINK, string3);
                    this.bubbleObjectToHtml.add(hashMap);
                    if (this.addXLinkInfo != null) {
                        this.getPolyAreaString(this.addXLinkInfo[n], point, hashMap);
                    }
                    this.addZLinkInfo(n, hashMap);
                }
            }
        }
    }

    public static String escapeFileName(String string) {
        int n = string.length();
        String string2 = string;
        char c = '-';
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c != '\\' && c != '/' && c != ':' && c != '*' && c != '?' && c != '\"' && c != '<' && c != '>' && c != 124) continue;
            string2 = string.replace(c, '-');
        }
        return string2;
    }

    public static String parseXHyperLink(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = stringBuffer.toString().indexOf("@XDIM");
        if (n != -1) {
            stringBuffer.replace(n, n + 5, string2);
        }
        return stringBuffer.toString();
    }

    public static String parseZHyperLink(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = -1;
        n = stringBuffer.toString().indexOf("@ZDIM");
        if (n != -1) {
            stringBuffer.replace(n, n + 5, string2);
        }
        return stringBuffer.toString();
    }

    public static String parseHyperLink(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        n = stringBuffer.toString().indexOf("@OUTER");
        while (n != -1) {
            if (string2 != null) {
                stringBuffer.replace(n, n + 6, string2);
            } else {
                stringBuffer.replace(n, n + 6, string3);
            }
            n = stringBuffer.toString().indexOf("@OUTER", n + 1);
        }
        if (string2 == null) {
            return stringBuffer.toString();
        }
        n = stringBuffer.toString().indexOf("@INNER");
        while (n != -1) {
            stringBuffer.replace(n, n + 6, string3);
            n = stringBuffer.toString().indexOf("@INNER", n + 1);
        }
        return stringBuffer.toString();
    }

    public void getRectAreaString(Shape shape, Point point, HashMap hashMap) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        float[][] fArray2 = new float[2][2];
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        fArray2[0][0] = (float)point.x + f;
        fArray2[0][1] = (float)point.y + f2;
        fArray2[1][0] = (float)point.x + f + f3;
        fArray2[1][1] = (float)point.y + f2 + f4;
        String string = fArray2[0][0] + "," + fArray2[0][1] + "," + fArray2[1][0] + "," + fArray2[1][1];
        hashMap.put(SHAPE, "rect");
        hashMap.put(COORDS, string);
    }

    void getIntRectAreaString(Shape shape, Point point, HashMap hashMap) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        float[][] fArray2 = new float[2][2];
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        float f5 = f3 == 0.0f ? 0.0f : (f3 = f3 < 1.0f ? 1.0f : f3);
        f4 = f4 == 0.0f ? 0.0f : (f4 < 1.0f ? 1.0f : f4);
        fArray2[0][0] = (float)point.x + f;
        fArray2[0][1] = (float)point.y + f2;
        fArray2[1][0] = (float)point.x + f + f3;
        fArray2[1][1] = (float)point.y + f2 + f4;
        String string = fArray2[0][0] + "," + fArray2[0][1] + "," + fArray2[1][0] + "," + fArray2[1][1];
        hashMap.put(SHAPE, "rect");
        hashMap.put(COORDS, string);
    }

    public void getPolyAreaString(Shape shape, Point point, HashMap hashMap) {
        boolean bl = false;
        float[] fArray2 = new float[6];
        if (shape == null) {
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
        String string = "";
        while (!pathIterator.isDone()) {
            bl = true;
            pathIterator.currentSegment(fArray2);
            float f = fArray2[0] + (float)point.x;
            float f2 = fArray2[1] + (float)point.y;
            string = string + f + "," + f2 + ",";
            pathIterator.next();
        }
        int n = string.length();
        if (bl) {
            string = string.substring(0, n - 1);
        }
        hashMap.put(SHAPE, "poly");
        hashMap.put(COORDS, string);
    }

    public void getCircleAreaString(Shape shape, Point point, HashMap hashMap) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        float f = (float)rectangle2D.getCenterX() + (float)point.x;
        float f2 = (float)rectangle2D.getCenterY() + (float)point.y;
        float f3 = (float)rectangle2D.getWidth() / 2.0f;
        String string = f + "," + f2 + "," + f3;
        hashMap.put(SHAPE, "circle");
        hashMap.put(COORDS, string);
    }

    public void getArcAreaString(Shape shape, Point point, HashMap hashMap) {
        this.getPolyAreaString(shape, point, hashMap);
    }

    public String[] getResult() {
        return null;
    }

    public List getResultMap() {
        int n;
        int n2;
        int n3;
        int n4;
        ArrayList arrayList = new ArrayList();
        int n5 = this.axisToHtml.size();
        for (n4 = 0; n4 < n5; ++n4) {
            arrayList.add(this.axisToHtml.get(n4));
        }
        n4 = this.get.size();
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList.add(this.get.get(n3));
        }
        n3 = this.getArcAreaString.size();
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList.add(this.getArcAreaString.get(n2));
        }
        n2 = this.bubbleObjectToHtml.size();
        for (n = 0; n < n2; ++n) {
            arrayList.add(this.bubbleObjectToHtml.get(n));
        }
        n = this.charAt.size();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.charAt.get(i));
        }
        return arrayList;
    }

    public List getCompInfoForDHTML() {
        ArrayList arrayList = new ArrayList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(INSTANCENAME, this.IsShowLabelTips.getProperties().getInstanceName());
        hashMap.put(OBJECTTYPE, PLATFORM);
        this.addLegendLinkInfo(this.IsShowLabelTips, hashMap);
        arrayList.add(hashMap);
        int n = this.IsShowLabelTips.getComponentCount();
        for (int i = 0; i < n; ++i) {
            ChartComponent chartComponent = this.IsShowLabelTips.getComponent(i);
            hashMap = new HashMap();
            this.addLegendLinkInfo(chartComponent, hashMap);
            arrayList.add(hashMap);
            if (chartComponent instanceof ChartCoordinatePaper) {
                hashMap.put(INSTANCENAME, ((ChartCoordinatePaper)chartComponent).getProperties().getInstanceName());
                hashMap.put(OBJECTTYPE, PAPER);
            }
            if (chartComponent instanceof ChartLabel) {
                hashMap.put(INSTANCENAME, ((ChartLabel)chartComponent).getProperties().getInstanceName());
                hashMap.put(OBJECTTYPE, LABEL);
            }
            if (!(chartComponent instanceof ChartLegend)) continue;
            hashMap.put(INSTANCENAME, ((ChartLegend)chartComponent).getProperties().getInstanceName());
            hashMap.put(OBJECTTYPE, LEGEND);
        }
        return arrayList;
    }

    private void addLegendLinkInfo(ChartComponent chartComponent, HashMap hashMap) {
        Rectangle rectangle = chartComponent.getBounds();
        String string = rectangle.x + "," + rectangle.y + "," + (rectangle.width + rectangle.x) + ", " + (rectangle.y + rectangle.height);
        hashMap.put(SHAPE, "rect");
        hashMap.put(COORDS, string);
    }

    int getUnitStep(Rectangle rectangle, int n) {
        int n2 = 1;
        if (rectangle == null) {
            return n2;
        }
        float f = rectangle.width > rectangle.height ? (float)rectangle.width : (float)rectangle.height;
        n2 = f / (float)n >= 1.0f ? 1 : (int)(1.0f / (f / (float)n));
        return n2;
    }

    void addXLinkInfo(int n, HashMap hashMap) {
        ChartShowValueConditionControl chartShowValueConditionControl = this.IsShowLabelTips.getShowValueConditions();
        if (chartShowValueConditionControl != null && chartShowValueConditionControl.getXLink() != null && chartShowValueConditionControl.getXLink().size() > n) {
            ChartDataUsedInfo chartDataUsedInfo = (ChartDataUsedInfo)chartShowValueConditionControl.getXLink().get(n);
            int[] nArray = chartDataUsedInfo.getChartLinkInfo();
            hashMap.put(XLINKINFO, nArray);
        }
    }

    void addZLinkInfo(int n, HashMap hashMap) {
        ChartShowValueConditionControl chartShowValueConditionControl = this.IsShowLabelTips.getShowValueConditions();
        if (chartShowValueConditionControl != null && chartShowValueConditionControl.getZLink() != null && chartShowValueConditionControl.getZLink().size() > n) {
            ChartDataUsedInfo chartDataUsedInfo = (ChartDataUsedInfo)chartShowValueConditionControl.getZLink().get(n);
            int[] nArray = chartDataUsedInfo.getChartLinkInfo();
            hashMap.put(ZLINKINFO, nArray);
        }
    }

    void addGraphLinkInfo(int n, int n2, ChartDataSet chartDataSet, HashMap hashMap) {
        int n3 = ChartTypeInfo.getPrimType(chartDataSet.getChartDataSetInfo().getChartType());
        if (n3 == 11) {
            ChartShowValueCondition chartShowValueCondition = (ChartShowValueCondition)this.IsShowLabelTips.getShowValueConditions().getConditions().get(n);
            if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                int[] nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(0)).get(n2)).getChartLinkInfo();
                hashMap.put(GRAPHLINKINFO, nArray);
            }
        } else if (n3 == 13) {
            ChartShowValueCondition chartShowValueCondition = (ChartShowValueCondition)this.IsShowLabelTips.getShowValueConditions().getConditions().get(n);
            if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                int[] nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(0)).get(n2)).getChartLinkInfo();
                hashMap.put(GRAPHLINKINFO, nArray);
            }
        } else {
            int n4 = chartDataSet.getShowValueBeginIndex();
            int n5 = chartDataSet.getShowValueEndIndex();
            int n6 = n5 - n4;
            int n7 = this.addZLinkInfo / n6;
            ChartShowValueCondition chartShowValueCondition = chartDataSet.getCondition(n, n2);
            int n8 = 0;
            n8 = n + 1 > n7 ? (n7 != 0 ? n - n / n7 * n7 : n) : n;
            if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                int[] nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n8)).get(n2)).getChartLinkInfo();
                hashMap.put(GRAPHLINKINFO, nArray);
            }
        }
    }

    void addLegendLinkInfo(int n, HashMap hashMap) {
        try {
            String string = this.IsShowLabelTips.getDataSetModel().getSeriesN();
            List list = null;
            list = string != null && !string.equals("") ? this.IsShowLabelTips.getShowValueConditions().getZLink() : this.IsShowLabelTips.getShowValueConditions().getXLink();
            int[] nArray = ((ChartDataUsedInfo)list.get(n)).getChartLinkInfo();
            hashMap.put(LEGENDLINKINFO, nArray);
        }
        catch (Exception exception) {
            return;
        }
    }
}

