/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartGradientLabelProperty;
import chart.properties.ChartLegendProperties;
import java.awt.Color;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class ChartMapColorInfo {
    public static final int NONE = 0;
    public static final int SINGLE_COLOR = 1;
    public static final int COLOR_BY_FIELD = 2;
    public static final int COLOR_BY_ONE_SUMMARY = 3;
    public static final int COLOR_BY_GROUP_SUMMARY = 4;
    public static final int COLOR_BY_CONDITIONAL_FILL = 6;
    public static final String NO_COLOR = "No_Color";
    String startClr = "";
    String endClr = "";
    String zeroClr = "0xffffff";
    boolean mapZeroToWhite;
    double startV;
    double endV;
    List labels;
    List fills;
    int type;
    String summName = "";
    List groupNames = new Vector();
    Vector orgGrp = new Vector();
    List groupValues = new Vector();
    boolean inited = false;
    private List SEDU;
    private List abs;
    boolean reverse;
    boolean calculateStartColorFlg = false;
    List colorByGroupList = null;
    Vector originGroupList = null;
    boolean useFilter = false;
    boolean isVaryColor = false;
    Hashtable heatmapGroupNameTable = new Hashtable();

    public void setFills(List list) {
        this.fills = list;
    }

    public List getFills() {
        return this.fills;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setCustomStartColor(String string) {
        this.startClr = string;
    }

    public void setCustomStartColor(Color color) {
        if (color != null) {
            this.startClr = this.calculateStartColorFlg(color);
        }
    }

    public void setCustomEndColor(Color color) {
        if (color != null) {
            this.endClr = this.calculateStartColorFlg(color);
        }
    }

    public String getCustomStartColor() {
        return this.startClr;
    }

    public void setCustomEndColor(String string) {
        this.endClr = string;
    }

    public String getCustomEndColor() {
        return this.endClr;
    }

    public String getCustomZeroColor() {
        return this.zeroClr;
    }

    public void setCustomZeroColor(String string) {
        this.zeroClr = string;
    }

    public void setCustomZeroColor(Color color) {
        if (color != null) {
            this.zeroClr = this.calculateStartColorFlg(color);
        }
    }

    public void setStartValue(double d) {
        this.startV = d;
    }

    public double getStartValue() {
        return this.startV;
    }

    public void setEndValue(double d) {
        this.endV = d;
    }

    public double getEndValue() {
        return this.endV;
    }

    public void setCustomZeroValue(String string) {
        this.zeroClr = string;
    }

    public Color getCustomZeroValue() {
        return this.add(this.zeroClr);
    }

    public String getZeroColor() {
        return this.zeroClr;
    }

    public void setMapZeroToWhite(boolean bl) {
        this.mapZeroToWhite = bl;
    }

    public boolean getMapZeroToWhite() {
        return this.mapZeroToWhite;
    }

    public void setSummaryName(String string) {
        this.summName = string;
    }

    public String getSummaryName() {
        return this.summName;
    }

    public void addNewGroup(List list, double d) {
        if (list != null && list.size() > 0) {
            double[] dArray;
            StringBuffer stringBuffer = new StringBuffer();
            int n = -1;
            this.abs(stringBuffer, list);
            String string = stringBuffer.toString();
            for (int i = 0; i < this.groupNames.size(); ++i) {
                if (!((String)this.groupNames.get(i)).equals(string)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                this.groupNames.add(string);
                this.orgGrp.add(list);
                double[] dArray2 = new double[]{0.0, 0.0};
                dArray2[0] = d;
                dArray2[1] = d;
                this.groupValues.add(dArray2);
                if (this.colorByGroupList == null) {
                    this.colorByGroupList = new Vector();
                }
                this.colorByGroupList.add(list);
            }
            double[] dArray3 = dArray = n < 0 ? (double[])this.groupValues.get(this.groupValues.size() - 1) : (double[])this.groupValues.get(n);
            if (dArray[0] > d) {
                dArray[0] = d;
            }
            if (dArray[1] < d) {
                dArray[1] = d;
            }
        }
    }

    public void addNewGroup(List list, List list2) {
        if (list != null && list.size() > 0 && list2 != null && list2.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            this.abs(stringBuffer, list);
            String string = stringBuffer.toString();
            int n = -1;
            for (int i = 0; i < this.groupNames.size(); ++i) {
                if (!((String)this.groupNames.get(i)).equals(string)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                double[] dArray = new double[2];
                double d = 0.0;
                dArray[0] = dArray[1] = ((Double)list2.get(0)).doubleValue();
                for (int i = 1; i < list2.size(); ++i) {
                    d = (Double)list2.get(i);
                    if (d < dArray[0]) {
                        dArray[0] = d;
                    }
                    if (!(d > dArray[1])) continue;
                    dArray[1] = d;
                }
                this.groupNames.add(string);
                this.orgGrp.add(list);
                this.groupValues.add(dArray);
                if (this.colorByGroupList == null) {
                    this.colorByGroupList = new Vector();
                }
                this.colorByGroupList.add(list);
            } else {
                double[] dArray = (double[])this.groupValues.get(n);
                double d = 0.0;
                for (int i = 1; i < list2.size(); ++i) {
                    d = (Double)list2.get(i);
                    if (d < dArray[0]) {
                        dArray[0] = d;
                    }
                    if (!(d > dArray[1])) continue;
                    dArray[1] = d;
                }
            }
        }
    }

    private Color SEDU(Color color) {
        if (color == null) {
            return new Color(255, 255, 255);
        }
        float f = 0.3f * (float)color.getRed();
        float f2 = 0.3f * (float)color.getGreen();
        float f3 = 0.3f * (float)color.getBlue();
        return new Color((int)(f += 159.0f), (int)(f2 += 159.0f), (int)(f3 += 159.0f));
    }

    private void abs(StringBuffer stringBuffer, List list) {
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append((String)list.get(i));
            if (i == list.size() - 1) continue;
            stringBuffer.append(",");
            stringBuffer.append(" ");
        }
    }

    public static Color getHighColor(Color color) {
        if (color != null) {
            float f = color.getRed();
            float f2 = color.getGreen();
            float f3 = color.getBlue();
            f = (255.0f - f) * 0.1f;
            f2 = (255.0f - f2) * 0.1f;
            f3 = (255.0f - f3) * 0.1f;
            f = 255.0f - f;
            f2 = 255.0f - f2;
            f3 = 255.0f - f3;
            return new Color((int)f, (int)f2, (int)f3);
        }
        return null;
    }

    public static Color getMapColor(double d, double d2, double d3, Color color, Color color2, boolean bl, Color color3) {
        double d4 = d;
        double d5 = d2;
        double d6 = d3;
        d4 = d4 < d5 ? d5 : d4;
        d4 = d4 > d6 ? d6 : d4;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        if (d5 == d6) {
            return color2 == null ? null : new Color(color2.getRGB());
        }
        if (color == null || color2 == null) {
            return new Color(255, 255, 255);
        }
        if (bl) {
            Color color4 = new Color(color3.getRed(), color3.getGreen(), color3.getBlue());
            if (d5 < 0.0 && d6 > 0.0 && d4 == 0.0 && d == 0.0) {
                return color4;
            }
            if (d4 < 0.0 && d5 < 0.0 && d6 > 0.0) {
                Color color5 = new Color(color.getRGB());
                d7 = color4.getRed() - color5.getRed();
                d8 = color4.getGreen() - color5.getGreen();
                d9 = color4.getBlue() - color5.getBlue();
                d7 = d7 * Math.abs(d4 - d5) / Math.abs(d5);
                d8 = d8 * Math.abs(d4 - d5) / Math.abs(d5);
                d9 = d9 * Math.abs(d4 - d5) / Math.abs(d5);
                d7 = (double)color5.getRed() + d7;
                d8 = (double)color5.getGreen() + d8;
                d9 = (double)color5.getBlue() + d9;
                d7 = d7 > 255.0 ? 255.0 : d7;
                d8 = d8 > 255.0 ? 255.0 : d8;
                d9 = d9 > 255.0 ? 255.0 : d9;
                return new Color((int)d7, (int)d8, (int)d9);
            }
            if (d6 > 0.0 && d5 < 0.0 && d4 > 0.0) {
                Color color6 = new Color(color2.getRGB());
                d7 = color6.getRed() - color4.getRed();
                d8 = color6.getGreen() - color4.getGreen();
                d9 = color6.getBlue() - color4.getBlue();
                d7 = d7 * Math.abs(d4) / Math.abs(d6);
                d8 = d8 * Math.abs(d4) / Math.abs(d6);
                d9 = d9 * Math.abs(d4) / Math.abs(d6);
                d7 = (double)color4.getRed() + d7;
                d8 = (double)color4.getGreen() + d8;
                d9 = (double)color4.getBlue() + d9;
                d7 = d7 > 255.0 ? 255.0 : d7;
                d8 = d8 > 255.0 ? 255.0 : d8;
                d9 = d9 > 255.0 ? 255.0 : d9;
                return new Color((int)d7, (int)d8, (int)d9);
            }
            Color color7 = new Color(color.getRGB());
            Color color8 = new Color(color2.getRGB());
            d7 = color8.getRed() - color7.getRed();
            d8 = color8.getGreen() - color7.getGreen();
            d9 = color8.getBlue() - color7.getBlue();
            d7 = d7 * Math.abs(d4 - d5) / Math.abs(d6 - d5);
            d8 = d8 * Math.abs(d4 - d5) / Math.abs(d6 - d5);
            d9 = d9 * Math.abs(d4 - d5) / Math.abs(d6 - d5);
            d7 = (double)color7.getRed() + d7;
            d8 = (double)color7.getGreen() + d8;
            d9 = (double)color7.getBlue() + d9;
            d7 = d7 > 255.0 ? 255.0 : d7;
            d8 = d8 > 255.0 ? 255.0 : d8;
            d9 = d9 > 255.0 ? 255.0 : d9;
            return new Color((int)d7, (int)d8, (int)d9);
        }
        Color color9 = new Color(color.getRGB());
        Color color10 = new Color(color2.getRGB());
        d7 = color10.getRed() - color9.getRed();
        d8 = color10.getGreen() - color9.getGreen();
        d9 = color10.getBlue() - color9.getBlue();
        d7 = d7 * Math.abs(d4 - d5) / Math.abs(d6 - d5);
        d8 = d8 * Math.abs(d4 - d5) / Math.abs(d6 - d5);
        d9 = d9 * Math.abs(d4 - d5) / Math.abs(d6 - d5);
        d7 = (double)color9.getRed() + d7;
        d8 = (double)color9.getGreen() + d8;
        d9 = (double)color9.getBlue() + d9;
        d7 = d7 > 255.0 ? 255.0 : d7;
        d8 = d8 > 255.0 ? 255.0 : d8;
        d9 = d9 > 255.0 ? 255.0 : d9;
        return new Color((int)d7, (int)d8, (int)d9);
    }

    public static Color getMapColor(double d, double[] dArray, Color[] colorArray) {
        Color color = null;
        if (dArray == null || colorArray == null) {
            return color;
        }
        if (dArray.length < 2 || colorArray.length < 2 || dArray.length != colorArray.length) {
            return color;
        }
        int n = dArray.length;
        double d2 = d;
        double d3 = dArray[0];
        double d4 = dArray[n - 1];
        d2 = d2 < d3 ? d3 : d2;
        double d5 = d2 = d2 > d4 ? d4 : d2;
        if (d3 == d4) {
            return colorArray[n - 1];
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        try {
            int n2 = -1;
            for (int i = 0; i < n - 1; ++i) {
                if (!(d2 >= dArray[i]) || !(d2 <= dArray[i])) continue;
                n2 = i;
                break;
            }
            if (n2 < 0) {
                color = (double)n2 < dArray[0] ? new Color(colorArray[0].getRGB()) : new Color(colorArray[n - 1].getRGB());
            } else {
                d6 = colorArray[n2].getRed();
                d7 = colorArray[n2].getGreen();
                d8 = colorArray[n2].getBlue();
                d6 += (d2 - dArray[n2]) * ((double)colorArray[n2 + 1].getRed() - d6) / (dArray[n2 + 1] - dArray[n2]);
                d7 += (d2 - dArray[n2]) * ((double)colorArray[n2 + 1].getGreen() - d7) / (dArray[n2 + 1] - dArray[n2]);
                d8 += (d2 - dArray[n2]) * ((double)colorArray[n2 + 1].getBlue() - d8) / (dArray[n2 + 1] - dArray[n2]);
                d6 = d6 > 255.0 ? 255.0 : d6;
                d7 = d7 > 255.0 ? 255.0 : d7;
                d8 = d8 > 255.0 ? 255.0 : d8;
                d6 = d6 < 0.0 ? 0.0 : d6;
                d7 = d7 < 0.0 ? 0.0 : d7;
                d8 = d8 < 0.0 ? 0.0 : d8;
                color = new Color((int)d6, (int)d7, (int)d8);
            }
            return color;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Color add(String string) {
        try {
            if (string != null) {
                String string2 = string.substring(2);
                int n = Integer.parseInt(string2, 16);
                return new Color(n);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public void setLegendProperty(ChartLegendProperties chartLegendProperties) {
        if (chartLegendProperties == null) {
            return;
        }
        this.init();
        if (this.type == 0) {
            return;
        }
        chartLegendProperties.setInheritShapeFromNode(false);
        if (this.type == 2 || this.type == 1 || this.type == 6) {
            chartLegendProperties.setUseColorByLegend(true);
            chartLegendProperties.getColorByProperty().setCutomizedLiabels(this.doubleValue());
            Vector vector = new Vector();
            if (!this.colorByGroupList()) {
                if (this.fills != null && this.labels != null && this.fills.size() > 0) {
                    for (int i = 0; i < this.labels.size(); ++i) {
                        if (this.type == 2 && !this.isVaryColor || this.type == 1) {
                            vector.add(this.fills.get(0));
                            continue;
                        }
                        vector.add(this.fills.get(i % this.fills.size()));
                    }
                }
            } else if (this.fills != null && this.labels != null && this.fills.size() > 0) {
                int n = 0;
                for (int i = 0; i < this.colorByGroupList.size(); ++i) {
                    if (this.type == 2 && !this.isVaryColor || this.type == 1) {
                        vector.add(this.fills.get(0));
                        continue;
                    }
                    List list = (List)this.colorByGroupList.get(i);
                    n = this.getIndex(list, this.originGroupList);
                    if (n < 0) continue;
                    vector.add(this.fills.get(n % this.fills.size()));
                }
            }
            chartLegendProperties.getColorByProperty().setIconFillPatterns(vector);
            chartLegendProperties.getColorByProperty().setUseGradientLabel(false);
            chartLegendProperties.getColorByProperty().setIsCutomized(true);
            chartLegendProperties.getColorByProperty().setCutomizedLiabels(this.doubleValue());
            return;
        }
        if (this.type == 3) {
            chartLegendProperties.setUseColorByLegend(true);
            chartLegendProperties.getColorByProperty().setUseGradientLabel(true);
            chartLegendProperties.getColorByProperty().setIsCutomized(false);
            Vector vector = new Vector();
            if (this.fills != null && this.fills.size() > 0) {
                for (int i = 0; i < this.labels.size(); ++i) {
                    vector.add(this.fills.get(0));
                }
            }
            chartLegendProperties.getColorByProperty().setIconFillPatterns(vector);
            ChartGradientLabelProperty chartGradientLabelProperty = new ChartGradientLabelProperty();
            if (this.labels != null && this.labels.size() == 1) {
                chartGradientLabelProperty.setStartColor(this.add(this.endClr));
                chartGradientLabelProperty.setEndColor(this.add(this.endClr));
            } else if (!this.reverse) {
                chartGradientLabelProperty.setStartColor(this.add(this.startClr));
                chartGradientLabelProperty.setEndColor(this.add(this.endClr));
            } else {
                chartGradientLabelProperty.setStartColor(this.add(this.endClr));
                chartGradientLabelProperty.setEndColor(this.add(this.startClr));
            }
            chartGradientLabelProperty.setStartValue(this.startV);
            chartGradientLabelProperty.setEndValue(this.endV);
            chartGradientLabelProperty.setLabel(this.summName);
            chartGradientLabelProperty.setLabelStyle((ChartTextStyle)chartLegendProperties.getLabelStyle().getTextStyle().clone());
            chartGradientLabelProperty.setTitleStyle((ChartTextStyle)chartLegendProperties.getLabelStyle().getTextStyle().clone());
            chartGradientLabelProperty.setIconWidth(chartLegendProperties.getLabelStyle().getIcon().getIconWidth());
            chartGradientLabelProperty.setIconHeight(chartLegendProperties.getLabelStyle().getIcon().getIconHeight());
            chartGradientLabelProperty.setMapZeroToWhite(this.mapZeroToWhite);
            chartGradientLabelProperty.setZeroUseColor(this.add(this.zeroClr));
            Vector<ChartGradientLabelProperty> vector2 = new Vector<ChartGradientLabelProperty>();
            vector2.add(chartGradientLabelProperty);
            chartLegendProperties.getColorByProperty().setGradientLabelsProperty(vector2);
            return;
        }
        if (this.type == 4) {
            chartLegendProperties.setUseColorByLegend(true);
            chartLegendProperties.getColorByProperty().setCutomizedLiabels(this.doubleValue());
            chartLegendProperties.getColorByProperty().setUseGradientLabel(false);
            chartLegendProperties.getColorByProperty().setIsCutomized(true);
            chartLegendProperties.getColorByProperty().setIsCutomized(true);
            Vector vector = new Vector();
            if (!this.colorByGroupList()) {
                if (this.fills != null && this.labels != null && this.fills.size() > 0) {
                    for (int i = 0; i < this.labels.size(); ++i) {
                        vector.add(this.fills.get(i % this.fills.size()));
                    }
                }
            } else if (this.fills != null && this.labels != null && this.fills.size() > 0) {
                int n = 0;
                for (int i = 0; i < this.colorByGroupList.size(); ++i) {
                    List list = (List)this.colorByGroupList.get(i);
                    n = this.getIndex(list, this.originGroupList);
                    if (n < 0) continue;
                    vector.add(this.fills.get(n % this.fills.size()));
                }
            }
            chartLegendProperties.getColorByProperty().setIconFillPatterns(vector);
            return;
        }
    }

    public void init() {
        this.labels = new Vector();
        for (int i = 0; i < this.groupNames.size(); ++i) {
            this.labels.add(this.groupNames.get(i));
        }
        this.inited = true;
    }

    private Color append(ChartFillPattern chartFillPattern) {
        if (chartFillPattern instanceof ChartColorPattern) {
            return ((ChartColorPattern)chartFillPattern).getColor();
        }
        if (chartFillPattern instanceof ChartGradientPattern) {
            return ((ChartGradientPattern)chartFillPattern).getStartColor().getColor();
        }
        return null;
    }

    private String calculateStartColorFlg(Color color) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("0x");
        stringBuffer.append(color.getRed() < 16 ? "0" + Integer.toHexString(color.getRed()) : Integer.toHexString(color.getRed()));
        stringBuffer.append(color.getGreen() < 16 ? "0" + Integer.toHexString(color.getGreen()) : Integer.toHexString(color.getGreen()));
        stringBuffer.append(color.getBlue() < 16 ? "0" + Integer.toHexString(color.getBlue()) : Integer.toHexString(color.getBlue()));
        return stringBuffer.toString();
    }

    int getIndex(List list, List list2) {
        if (list != null && list2 != null) {
            boolean bl = true;
            String string = null;
            for (int i = 0; i < list2.size(); ++i) {
                string = (String)list2.get(i);
                if (string == null) continue;
                bl = true;
                for (int j = 0; j < list.size(); ++j) {
                    if (list.get(j) == null || string.indexOf((String)list.get(j)) >= 0) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                return i;
            }
        }
        return -1;
    }

    public List getGroupNameList() {
        return this.groupNames;
    }

    public List getLabelList() {
        return this.labels;
    }

    public void setGroupNameList(List list) {
        this.groupNames = list;
    }

    public List getGroupValues() {
        return this.groupValues;
    }

    public void setGroupValues(List list) {
        this.groupValues = list;
    }

    public void setReverseColor(boolean bl) {
        this.reverse = bl;
    }

    public boolean getReverseColor() {
        return this.reverse;
    }

    private boolean colorByGroupList() {
        return this.useFilter;
    }

    public void setUseFilter(boolean bl) {
        this.useFilter = bl;
    }

    public void setOriginGroupList(Vector vector) {
        this.originGroupList = vector;
    }

    public void setIsVaryColor(boolean bl) {
        this.isVaryColor = bl;
    }

    public void setGroupNameTable(Hashtable hashtable) {
        this.heatmapGroupNameTable = hashtable;
    }

    public Hashtable getGroupNameTable() {
        return this.heatmapGroupNameTable;
    }

    private List doubleValue() {
        Vector<String> vector = new Vector<String>();
        if (this.heatmapGroupNameTable == null) {
            return this.labels;
        }
        if (this.heatmapGroupNameTable.isEmpty()) {
            return this.labels;
        }
        int n = this.orgGrp.size();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            List list = (List)this.orgGrp.get(i);
            if (list == null) {
                vector.add("");
                continue;
            }
            stringBuffer.setLength(0);
            for (int j = 0; j < list.size(); ++j) {
                String string = (String)list.get(j);
                String string2 = (String)this.heatmapGroupNameTable.get(string);
                if (string2 == null) {
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    if (j >= list.size() - 1) continue;
                    stringBuffer.append(" ,");
                    continue;
                }
                stringBuffer.append(string2);
                if (j >= list.size() - 1) continue;
                stringBuffer.append(" ,");
            }
            vector.add(stringBuffer.toString());
        }
        return vector;
    }
}

