/*
 * Decompiled with CFR 0.152.
 */
package com.java4less.rfax;

public class HDLCFrame {
    protected static final int FRAME_DELIMITER = 126;
    protected static final int FRAME_ADDRESSFIELD = 255;
    protected static final int LAST_FRAME = 19;
    protected static final int NO_LAST_FRAME = 3;
    protected static final int TYPE_DIS = 128;
    protected static final int TYPE_CSI = 64;
    protected static final int TYPE_NFS = 32;
    protected static final int TYPE_DTC = 129;
    protected static final int TYPE_CIG = 65;
    protected static final int TYPE_NSC = 33;
    protected static final int TYPE_DCS_REC = 130;
    protected static final int TYPE_DCS_SEND = 131;
    protected static final int TYPE_TSI_REC = 66;
    protected static final int TYPE_TSI_SEND = 67;
    protected static final int TYPE_NSS_REC = 34;
    protected static final int TYPE_NSS_SEND = 35;
    protected static final int TYPE_CFR_REC = 132;
    protected static final int TYPE_CRF_SEND = 133;
    protected static final int TYPE_FTT_REC = 68;
    protected static final int TYPE_FTT_SEND = 69;
    protected static final int TYPE_EOM_REC = 142;
    protected static final int TYPE_EOM_SEND = 143;
    protected static final int TYPE_MPS_REC = 78;
    protected static final int TYPE_MPS_SEND = 79;
    protected static final int TYPE_EOP_REC = 46;
    protected static final int TYPE_EOP_SEND = 47;
    protected static final int TYPE_PRI_EOM_REC = 158;
    protected static final int TYPE_PRI_EOM_SEND = 159;
    protected static final int TYPE_PRI_MPS_REC = 94;
    protected static final int TYPE_PRI_MPS_SEND = 95;
    protected static final int TYPE_PRI_EOP_REC = 62;
    protected static final int TYPE_PRI_EOP_SEND = 63;
    protected static final int TYPE_MCF_REC = 140;
    protected static final int TYPE_MCF_SEND = 141;
    protected static final int TYPE_RTP_REC = 204;
    protected static final int TYPE_RTP_SEND = 205;
    protected static final int TYPE_RTN_REC = 76;
    protected static final int TYPE_RTN_SEND = 77;
    protected static final int TYPE_PIP_REC = 172;
    protected static final int TYPE_PIP_SEND = 173;
    protected static final int TYPE_PIN_REC = 44;
    protected static final int TYPE_PIN_SEND = 45;
    protected static final int TYPE_DCN_REC = 250;
    protected static final int TYPE_DCN_SEND = 251;
    protected static final int TYPE_CRP_REC = 26;
    protected static final int TYPE_CRP_SEND = 27;
    private int SEDU = 0;
    private int I = 0;
    private byte[] Z = null;
    byte[] bytes = new byte[256];
    int bytesCount = 0;

    public HDLCFrame(byte[] byArray, int n) {
        this.bytes = byArray;
        this.bytesCount = n;
    }

    public HDLCFrame() {
        this.bytes[0] = -1;
        ++this.bytesCount;
        this.bytes[1] = 3;
        ++this.bytesCount;
        this.bytes[2] = 0;
        ++this.bytesCount;
    }

    public void addByte(byte by) {
        this.bytes[this.bytesCount++] = by;
    }

    public void setLast(boolean bl) {
        this.bytes[1] = bl ? 19 : 3;
    }

    public int getFrameType() {
        if (this.bytesCount > 2) {
            int n = this.bytes[2];
            if (n < 0) {
                n = 256 + n;
            }
            return n;
        }
        return 0;
    }

    public void setFrameType(byte by) {
        if (this.bytesCount > 2) {
            this.bytes[2] = by;
        }
    }

    public boolean isLast() {
        if (this.bytesCount > 1) {
            return this.bytes[1] == 19;
        }
        return false;
    }

    public byte[] getData() {
        if (this.bytesCount <= 5) {
            return null;
        }
        byte[] byArray = new byte[this.bytesCount - 5];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.bytes[i + 3];
        }
        return byArray;
    }

    public byte[] getRawData() {
        byte[] byArray = new byte[this.bytesCount];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.bytes[i];
        }
        return byArray;
    }
}

