/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt;

import com.jinfonet.awt.ExPolygon;
import com.jinfonet.awt.JGraphics;
import com.jinfonet.awt.JShape;
import com.jinfonet.awt.JShapeIterator;
import java.awt.Graphics;
import java.util.Vector;

public class BezierTool {
    private static final double BezierPoints(int n, double[] dArray, double d) {
        int n2;
        double d2 = 1.0 - d;
        double[] dArray2 = new double[n + 1];
        for (n2 = 0; n2 <= n; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        for (n2 = 1; n2 <= n; ++n2) {
            for (int i = 0; i <= n - n2; ++i) {
                dArray2[i] = d2 * dArray2[i] + d * dArray2[i + 1];
            }
        }
        return dArray2[0];
    }

    static final void BezierPoints(int n, int n2, double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 1.0 / (double)n2;
        for (int i = 0; i < n2; ++i) {
            dArray2[i] = BezierTool.BezierPoints(n, dArray, d);
            d += d2;
        }
    }

    public static final double[][] BezierPoints(int n, int n2, double[] dArray) {
        double[][] dArray2 = new double[2][n2];
        double[] dArray3 = new double[n + 1];
        for (int i = 0; i < 2; ++i) {
            for (int j = i; j < (n + 1) * 2; j += 2) {
                dArray3[(j - i) / 2] = dArray[j];
            }
            BezierTool.BezierPoints(n, n2, dArray3, dArray2[i]);
        }
        return dArray2;
    }

    public static final void draw(int n, int n2, double[] dArray, Graphics graphics) {
        double[][] dArray2 = BezierTool.BezierPoints(n, n2, dArray);
        for (int i = 1; i < n2; ++i) {
            graphics.drawLine((int)Math.round(dArray2[0][i - 1]), (int)Math.round(dArray2[1][i - 1]), (int)Math.round(dArray2[0][i]), (int)Math.round(dArray2[1][i]));
        }
    }

    public static final int testPoints(int n, int n2, double[] dArray) {
        return n2;
    }

    private static final Vector SEDU(Vector vector, boolean bl) {
        return vector;
    }

    public static final ExPolygon getPolygon(JShape jShape, Graphics graphics, int n) {
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        double[] dArray3 = new double[]{-1.7976931348623157E308, -1.7976931348623157E308};
        ExPolygon exPolygon = new ExPolygon();
        ExPolygon.g = graphics instanceof JGraphics ? ((JGraphics)graphics).getImpl() : graphics;
        ExPolygon exPolygon2 = null;
        JShapeIterator jShapeIterator = jShape.getIterator();
        int n2 = jShape.getWindingRule();
        if (n2 == 1) {
            throw new RuntimeException("Cannot support WindingRule WIND_NON_ZERO");
        }
        int n3 = jShapeIterator.currentSegment(dArray2);
        if (jShapeIterator.currentSegment(dArray2) != 0) {
            throw new RuntimeException("First segment type is not SEG_MOVETO but " + n3);
        }
        dArray[0] = -1.7976931348623157E308;
        dArray[1] = -1.7976931348623157E308;
        while (!jShapeIterator.isDone()) {
            n3 = jShapeIterator.currentSegment(dArray2);
            switch (n3) {
                case 0: {
                    if (exPolygon2 != null) {
                        exPolygon.add(exPolygon2);
                        exPolygon2 = null;
                    }
                    dArray3[0] = dArray2[0];
                    dArray3[1] = dArray2[1];
                    dArray[0] = dArray2[0];
                    dArray[1] = dArray2[1];
                    break;
                }
                case 1: {
                    if (exPolygon2 == null) {
                        exPolygon2 = new ExPolygon();
                        exPolygon2.addPoint(dArray3[0], dArray3[1]);
                    }
                    exPolygon2.addPoint(dArray2[0], dArray2[1]);
                    dArray[0] = dArray2[0];
                    dArray[1] = dArray2[1];
                    if (dArray3[0] != dArray[0] || dArray3[1] != dArray[1]) break;
                    exPolygon.add(exPolygon2);
                    exPolygon2 = null;
                    break;
                }
                case 2: {
                    int n4;
                    int n5;
                    if (exPolygon2 == null) {
                        exPolygon2 = new ExPolygon();
                        exPolygon2.addPoint(dArray3[0], dArray3[1]);
                    }
                    for (n5 = 0; n5 < 4; ++n5) {
                        dArray[n5 + 2] = dArray2[n5];
                    }
                    n5 = BezierTool.testPoints(2, n, dArray);
                    double[][] dArray4 = BezierTool.BezierPoints(2, n5, dArray);
                    for (n4 = 0; n4 < n5; ++n4) {
                        exPolygon2.addPoint(dArray4[0][n4], dArray4[1][n4]);
                    }
                    exPolygon2.addPoint(dArray2[2], dArray2[3]);
                    dArray[0] = dArray2[2];
                    dArray[1] = dArray2[3];
                    if (dArray3[0] != dArray[0] || dArray3[1] != dArray[1]) break;
                    exPolygon.add(exPolygon2);
                    exPolygon2 = null;
                    break;
                }
                case 3: {
                    int n4;
                    int n5;
                    if (exPolygon2 == null) {
                        exPolygon2 = new ExPolygon();
                        exPolygon2.addPoint(dArray3[0], dArray3[1]);
                    }
                    for (n5 = 0; n5 < 6; ++n5) {
                        dArray[n5 + 2] = dArray2[n5];
                    }
                    n5 = BezierTool.testPoints(3, n, dArray);
                    double[][] dArray4 = BezierTool.BezierPoints(3, n5, dArray);
                    for (n4 = 0; n4 < n5; ++n4) {
                        exPolygon2.addPoint(dArray4[0][n4], dArray4[1][n4]);
                    }
                    exPolygon2.addPoint(dArray2[4], dArray2[5]);
                    dArray[0] = dArray2[4];
                    dArray[1] = dArray2[5];
                    if (dArray3[0] != dArray[0] || dArray3[1] != dArray[1]) break;
                    exPolygon.add(exPolygon2);
                    exPolygon2 = null;
                    break;
                }
                case 4: {
                    if (exPolygon2 != null) {
                        exPolygon.add(exPolygon2);
                        exPolygon2 = null;
                    }
                    dArray3[0] = -1.7976931348623157E308;
                    dArray3[1] = -1.7976931348623157E308;
                    dArray[0] = -1.7976931348623157E308;
                    dArray[1] = -1.7976931348623157E308;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown segment type " + n3);
                }
            }
            jShapeIterator.next();
        }
        if (exPolygon2 != null) {
            exPolygon.add(exPolygon2);
        }
        exPolygon.unfold();
        return exPolygon;
    }
}

