/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt;

import com.jinfonet.awt.FontStruct;
import guitools.toolkit.JDebug;
import java.awt.Font;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.Env;

class JFontMapping {
    String fontPropFileName = Env.homePath + "lib" + File.separator + "JFont.properties";
    Vector vFontStructs = new Vector(10);
    Hashtable hFontAlias = null;

    JFontMapping() {
        try {
            this.readFontPropertiesFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Error("Can not find the font property file:" + this.fontPropFileName + "!");
        }
        catch (IOException iOException) {
            throw new Error("Read the font property file " + this.fontPropFileName + " error!");
        }
    }

    void readFontPropertiesFile() throws FileNotFoundException, IOException {
        String string;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.fontPropFileName, "r");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while ((string = randomAccessFile.readLine()) != null) {
            if ((string = string.trim()).length() == 0) continue;
            if (string.indexOf("#") != -1) {
                if (string.indexOf("JFont.properties") != -1) {
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                    continue;
                }
                if (string.indexOf("name aliases") != -1) {
                    bl = false;
                    bl2 = true;
                    bl3 = false;
                    continue;
                }
                if (string.indexOf("mapping names") == -1) continue;
                bl = false;
                bl2 = false;
                bl3 = true;
                continue;
            }
            if (bl) {
                this.readOneMapFont(string);
                continue;
            }
            if (bl2) {
                this.readOneFontAlias(string);
                continue;
            }
            if (!bl3) continue;
            this.readOneMapFontFileName(string);
        }
    }

    void readOneMapFont(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = stringTokenizer.nextToken().trim().toLowerCase();
        String string3 = stringTokenizer.nextToken().trim().toLowerCase();
        String string4 = string2;
        int n = 0;
        int n2 = string2.indexOf(".");
        if (n2 != -1) {
            string4 = string2.substring(0, n2);
            object = string2.substring(n2, string2.length());
            if (((String)object).indexOf("bold") != -1) {
                n |= FontStruct.BOLD_FONT;
            }
            if (((String)object).indexOf("italic") != -1) {
                n |= FontStruct.ITALIC_FONT;
            }
        }
        if ((object = this.getFontStruct(string4)) == null) {
            object = new FontStruct(string4);
        }
        ((FontStruct)object).addFont(n, string3);
        this.vFontStructs.addElement(object);
    }

    void readOneFontAlias(String string) {
        if (this.hFontAlias == null) {
            this.hFontAlias = new Hashtable(6);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = stringTokenizer.nextToken().trim().toLowerCase();
        String string3 = stringTokenizer.nextToken().trim().toLowerCase();
        this.hFontAlias.put(string2, string3);
    }

    void readOneMapFontFileName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = stringTokenizer.nextToken().trim().toLowerCase();
        String string3 = stringTokenizer.nextToken().trim().toLowerCase();
        for (int i = 0; i < this.vFontStructs.size(); ++i) {
            FontStruct fontStruct = (FontStruct)this.vFontStructs.elementAt(i);
            fontStruct.replaceMapFontFileName(string2, string3);
        }
    }

    String getMappingFileName(Font font) {
        String string;
        String string2 = "arial.ttf";
        String string3 = font.getName();
        boolean bl = font.isBold();
        boolean bl2 = font.isItalic();
        if (this.hFontAlias.containsKey(string3)) {
            string3 = (String)this.hFontAlias.get(string3);
        }
        boolean bl3 = false;
        FontStruct fontStruct = this.getFontStruct(string3);
        if (fontStruct != null && (string = fontStruct.getMapFontFileName(font.isBold(), font.isItalic())) != null) {
            string2 = string;
            bl3 = true;
        }
        if (!bl3) {
            JDebug.OUTMSG("Trace info", this.getClass().getName(), "Can not find the font:" + font, 1);
        }
        return string2;
    }

    FontStruct getFontStruct(String string) {
        string = string.toLowerCase();
        for (int i = 0; i < this.vFontStructs.size(); ++i) {
            FontStruct fontStruct = (FontStruct)this.vFontStructs.elementAt(i);
            if (!fontStruct.getFontName().equals(string)) continue;
            return fontStruct;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        JFontMapping jFontMapping = new JFontMapping();
        String string = jFontMapping.getMappingFileName(new Font("Serif", 1, 12));
        System.err.println("^^^^^^^^^^^^^^^ get:" + string);
    }
}

