/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt;

import com.jinfonet.awt.JShapeIterator;
import com.jinfonet.awt.JShapeble;

public class JShape
implements JShapeble {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    public static final int SEG_MOVETO = 0;
    public static final int SEG_LINETO = 1;
    public static final int SEG_QUADTO = 2;
    public static final int SEG_CUBICTO = 3;
    public static final int SEG_CLOSE = 4;
    byte[] pointTypes;
    float[] pointCoords;
    int numTypes;
    int numCoords;
    int windingRule;

    public JShape() {
        this(0, 20, 20);
    }

    public JShape(int n) {
        this(n, 20, 20);
    }

    JShape(int n, int n2, int n3) {
        this.setWindingRule(n);
        this.pointTypes = new byte[n2];
        this.pointCoords = new float[n3 * 2];
    }

    private void SEDU(int n, int n2, boolean bl) {
        Object[] objectArray;
        int n3;
        if (bl && this.numTypes == 0) {
            throw new RuntimeException("missing initial moveto in path definition");
        }
        int n4 = this.pointCoords.length;
        if (this.numCoords + n2 > n4) {
            n3 = n4;
            if (n3 > 1000) {
                n3 = 1000;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            objectArray = new float[n4 + n3];
            System.arraycopy(this.pointCoords, 0, objectArray, 0, this.numCoords);
            this.pointCoords = objectArray;
        }
        if (this.numTypes + n > (n4 = this.pointTypes.length)) {
            n3 = n4;
            if (n3 > 500) {
                n3 = 500;
            }
            if (n3 < n) {
                n3 = n;
            }
            objectArray = new byte[n4 + n3];
            System.arraycopy(this.pointTypes, 0, objectArray, 0, this.numTypes);
            this.pointTypes = (byte[])objectArray;
        }
    }

    @Override
    public synchronized void moveTo(float f, float f2) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.pointCoords[this.numCoords - 2] = f;
            this.pointCoords[this.numCoords - 1] = f2;
        } else {
            this.SEDU(1, 2, false);
            this.pointTypes[this.numTypes++] = 0;
            this.pointCoords[this.numCoords++] = f;
            this.pointCoords[this.numCoords++] = f2;
        }
    }

    @Override
    public synchronized void lineTo(float f, float f2) {
        this.SEDU(1, 2, true);
        this.pointTypes[this.numTypes++] = 1;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
    }

    @Override
    public synchronized void quadTo(float f, float f2, float f3, float f4) {
        this.SEDU(1, 4, true);
        this.pointTypes[this.numTypes++] = 2;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
        this.pointCoords[this.numCoords++] = f4;
    }

    @Override
    public synchronized void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.SEDU(1, 6, true);
        this.pointTypes[this.numTypes++] = 3;
        this.pointCoords[this.numCoords++] = f;
        this.pointCoords[this.numCoords++] = f2;
        this.pointCoords[this.numCoords++] = f3;
        this.pointCoords[this.numCoords++] = f4;
        this.pointCoords[this.numCoords++] = f5;
        this.pointCoords[this.numCoords++] = f6;
    }

    @Override
    public synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.SEDU(1, 0, true);
            this.pointTypes[this.numTypes++] = 4;
        }
    }

    @Override
    public synchronized int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n;
    }

    public JShapeIterator getIterator() {
        return new JShapeIterator(this);
    }
}

