/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt.font;

import com.jinfonet.awt.JFont;
import com.jinfonet.awt.JFontEnv;
import com.jinfonet.awt.JFontHeader;
import com.jinfonet.awt.font.truetype.OpenTypeFont;
import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.util.RAFile;
import jet.util.RandomInputable;
import jet.util.RandomOutputable;

public class JMFont
extends Font
implements JFont,
JFontEnv {
    private static Hashtable SEDU = new Hashtable(10);
    private static Vector addElement = new Vector(10);
    JFont impl;
    int resolution;
    JFontEnv env;
    boolean bValid = true;
    float size;

    public JMFont(String string, int n, float f, int n2, JFont jFont) {
        super(string, n2, Math.round(f));
        this.resolution = n;
        this.impl = jFont;
        this.bValid = true;
        this.size = f;
    }

    @Override
    public void unload() {
    }

    public static final void unloadAllFonts() {
        Enumeration enumeration = SEDU.elements();
        while (enumeration.hasMoreElements()) {
            ((JFont)enumeration.nextElement()).unload();
        }
        SEDU.clear();
        addElement.removeAllElements();
    }

    public static final synchronized JFont loadFont(String string, RandomInputable randomInputable) {
        JFont jFont = (JFont)SEDU.get(string);
        if (jFont == null) {
            try {
                jFont = new OpenTypeFont(randomInputable);
                if (!addElement.contains(jFont.getBaseName())) {
                    addElement.addElement(jFont.getBaseName());
                    SEDU.put(string, jFont);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final JFont prepareName(String string) {
        JFont jFont = (JFont)SEDU.get(string);
        if (jFont == null && string.toLowerCase().endsWith(".ttf")) {
            RAFile rAFile = null;
            try {
                rAFile = new RAFile(string, "r");
                jFont = new OpenTypeFont(rAFile, true);
                rAFile.close();
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, iOException);
                }
            }
            finally {
                block15: {
                    if (rAFile != null) {
                        try {
                            rAFile.close();
                        }
                        catch (IOException iOException) {
                            if (!JRLog.isError(2)) break block15;
                            JRLog.error(2, iOException);
                        }
                    }
                }
            }
        }
        return jFont;
    }

    public static final synchronized JFont loadFont(String string) {
        JFont jFont = (JFont)SEDU.get(string);
        if (jFont == null && string.toLowerCase().endsWith(".ttf")) {
            try {
                RAFile rAFile = new RAFile(string, "r");
                jFont = new OpenTypeFont(rAFile);
                if (!addElement.contains(jFont.getBaseName())) {
                    addElement.addElement(jFont.getBaseName());
                    SEDU.put(string, jFont);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return jFont;
    }

    public static final synchronized JMFont make(String string, float f) {
        JFont jFont = JMFont.loadFont(string);
        JMFont jMFont = null;
        if (jFont != null) {
            String string2 = jFont.getMapFontName();
            jMFont = new JMFont(string2, 0, f, jFont.getStyle(), jFont);
        }
        return jMFont;
    }

    public JFont getImplFont() {
        return this.impl;
    }

    public void setImplFont(JFont jFont) {
        this.impl = jFont;
    }

    @Override
    public void draw(Graphics graphics, String string, float f, float f2) {
        this.impl.draw(graphics, string, f, f2);
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.impl.getFontMetrics(this);
    }

    @Override
    public JFontHeader getFontHeader() {
        return this.impl.getFontHeader();
    }

    @Override
    public void setFontEnv(JFontEnv jFontEnv) {
        this.env = jFontEnv;
    }

    @Override
    public FontMetrics getFontMetrics(JFontEnv jFontEnv) {
        return this.impl.getFontMetrics(jFontEnv);
    }

    @Override
    public int[] getWidths() {
        return this.impl.getWidths();
    }

    public boolean isValid() {
        return this.bValid;
    }

    @Override
    public String getMapFontName() {
        return this.impl.getMapFontName();
    }

    @Override
    public boolean isAsiaFont() {
        return this.impl.isAsiaFont();
    }

    @Override
    public String getPSName() {
        return this.impl.getPSName();
    }

    @Override
    public String getBaseName() {
        return this.impl.getBaseName();
    }

    @Override
    public void writeTo(RandomOutputable randomOutputable) throws IOException {
        this.impl.writeTo(randomOutputable);
    }

    @Override
    public int getResolution() {
        if (this.env != null) {
            return this.env.getResolution();
        }
        if (this.resolution == 0) {
            this.resolution = Unit.getResolution();
        }
        return this.resolution;
    }

    @Override
    public float getPoints() {
        double d = 72.0 / (double)this.getResolution();
        return (float)((double)this.size * d);
    }

    static {
        try {
            Class.forName("java.awt.GraphicsEnvironment");
            GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

