/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt.font.truetype;

import com.jinfonet.awt.BezierTool;
import com.jinfonet.awt.ExPolygon;
import com.jinfonet.awt.JFont;
import com.jinfonet.awt.JFontEnv;
import com.jinfonet.awt.JFontHeader;
import com.jinfonet.awt.JGraphics;
import com.jinfonet.awt.JShape;
import com.jinfonet.awt.JShape2D;
import com.jinfonet.awt.JShapeble;
import com.jinfonet.awt.font.truetype.IOTool;
import com.jinfonet.awt.font.truetype.NameRecord;
import com.jinfonet.awt.font.truetype.OS2;
import com.jinfonet.awt.font.truetype.TrueTypeFontMetrics;
import com.jinfonet.awt.font.truetype.cmap;
import com.jinfonet.awt.font.truetype.comGlyf;
import com.jinfonet.awt.font.truetype.glyf;
import com.jinfonet.awt.font.truetype.head;
import com.jinfonet.awt.font.truetype.hhea;
import com.jinfonet.awt.font.truetype.hmtx;
import com.jinfonet.awt.font.truetype.loca;
import com.jinfonet.awt.font.truetype.maxp;
import com.jinfonet.awt.font.truetype.name;
import com.jinfonet.awt.font.truetype.post;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.io.IOException;
import java.util.Locale;
import jet.util.IntKeyHashtable;
import jet.util.RandomInputable;
import jet.util.RandomOutputable;

public class OpenTypeFont
implements JFont {
    protected static final int TAG_CMAP = 1668112752;
    protected static final int TAG_HEAD = 1751474532;
    protected static final int TAG_NAME = 1851878757;
    protected static final int TAG_GLYF = 1735162214;
    protected static final int TAG_MAXP = 1835104368;
    protected static final int TAG_PREP = 1886545264;
    protected static final int TAG_HMTX = 1752003704;
    protected static final int TAG_KERN = 1801810542;
    protected static final int TAG_HDMX = 1751412088;
    protected static final int TAG_LOCA = 1819239265;
    protected static final int TAG_POST = 1886352244;
    protected static final int TAG_OS2 = 1330851634;
    protected static final int TAG_CVT = 1668707360;
    protected static final int TAG_GASP = 1734439792;
    protected static final int TAG_VDMX = 1447316824;
    protected static final int TAG_VMTX = 1986884728;
    protected static final int TAG_VHEA = 1986553185;
    protected static final int TAG_HHEA = 1751672161;
    protected static final int TAG_TYP1 = 1954115633;
    protected static final int TAG_BSLN = 1651731566;
    protected static final int TAG_GSUB = 1196643650;
    protected static final int TAG_DSIG = 1146308935;
    protected static final int TAG_FPGM = 1718642541;
    protected static final int TAG_FVAR = 1719034226;
    protected static final int TAG_GVAR = 1735811442;
    protected static final int TAG_CFF = 1128678944;
    protected static final int TAG_MMSD = 1296913220;
    protected static final int TAG_MMFX = 1296909912;
    protected static final int TAG_BASE = 1111577413;
    protected static final int TAG_GDEF = 1195656518;
    protected static final int TAG_GPOS = 1196445523;
    protected static final int TAG_JSTF = 1246975046;
    protected static final int TAG_EBDT = 0x45424454;
    protected static final int TAG_EBLC = 1161972803;
    protected static final int TAG_EBSC = 1161974595;
    protected static final int TAG_LTSH = 1280594760;
    protected static final int TAG_PCLT = 1346587732;
    protected static final int TAG_ACNT = 1633906292;
    protected static final int TAG_AVAR = 1635148146;
    protected static final int TAG_BDAT = 1650745716;
    protected static final int TAG_BLOC = 1651273571;
    protected static final int TAG_CVAR = 1668702578;
    protected static final int TAG_FEAT = 1717920116;
    protected static final int TAG_FDSC = 1717859171;
    protected static final int TAG_FMTX = 1718449272;
    protected static final int TAG_JUST = 1786082164;
    protected static final int TAG_LCAR = 1818452338;
    protected static final int TAG_MORT = 1836020340;
    protected static final int TAG_OPBD = 1836020340;
    protected static final int TAG_PROP = 1886547824;
    protected static final int TAG_TRAK = 1953653099;
    private RandomInputable Language_ID = null;
    IntKeyHashtable tableEntries = null;
    cmap[] ocmaps;
    head ohead;
    hhea ohhea;
    hmtx ohmtx;
    maxp omaxp;
    name oname;
    OS2 oos2;
    post opost;
    private glyf[] Name_ID;
    loca oloca;
    private boolean Platform_ID = false;
    private IntKeyHashtable S = new IntKeyHashtable();

    public OpenTypeFont(RandomInputable randomInputable) throws IOException {
        this(randomInputable, false);
    }

    public OpenTypeFont(RandomInputable randomInputable, boolean bl) throws IOException {
        this.Language_ID = randomInputable;
        this.Platform_ID = bl;
        this.Language_ID();
    }

    public String getFontName() {
        String string = "";
        if (this.oname != null) {
            int n = OS2.getPlatform(System.getProperty("os.name"));
            int n2 = OS2.getLauguage(n, Locale.getDefault());
            for (int i = 0; i < this.oname.numOfRecords; ++i) {
                NameRecord nameRecord = this.oname.nameRecords[i];
                if (nameRecord.Name_ID != 1 || nameRecord.Platform_ID != n || nameRecord.Language_ID != n2 && string.length() != 0) continue;
                string = nameRecord.name;
                if (nameRecord.Language_ID == n2) break;
            }
        }
        return string;
    }

    public synchronized void outputCondensedForm(RandomOutputable randomOutputable) throws IOException {
        Object[] objectArray;
        int n;
        this.Language_ID.seek(0L);
        randomOutputable.writeInt(this.Language_ID.readInt());
        boolean bl = this.tableEntries.containsKey(1330851634);
        int n2 = bl ? 10 : 9;
        randomOutputable.writeShort(n2);
        randomOutputable.writeShort(128);
        randomOutputable.writeShort(3);
        randomOutputable.writeShort(16 * n2 - 128);
        int[] nArray = null;
        nArray = bl ? new int[]{1751474532, 1751672161, 1752003704, 1835104368, 1851878757, 1886352244, 1330851634, 1668112752, 1735162214, 1819239265} : new int[]{1751474532, 1751672161, 1752003704, 1835104368, 1851878757, 1886352244, 1668112752, 1735162214, 1819239265};
        long l = 12 + 16 * n2;
        for (n = 0; n < n2; ++n) {
            objectArray = (long[])this.tableEntries.get(nArray[n]);
            randomOutputable.writeInt(nArray[n]);
            randomOutputable.writeInt((int)(0xFFFFFFFFFFFFFFFFL & objectArray[2]));
            randomOutputable.writeInt((int)(0xFFFFFFFFFFFFFFFFL & l));
            randomOutputable.writeInt((int)(0xFFFFFFFFFFFFFFFFL & objectArray[1]));
            l += objectArray[1];
        }
        n = 1024;
        objectArray = new byte[n];
        for (int i = 0; i < n2; ++i) {
            long[] lArray = (long[])this.tableEntries.get(nArray[i]);
            this.Language_ID.seek(lArray[0]);
            if (lArray[1] <= (long)n) {
                this.Language_ID.readFully((byte[])objectArray, 0, (int)lArray[1]);
                randomOutputable.write((byte[])objectArray, 0, (int)lArray[1]);
                continue;
            }
            long l2 = 0L;
            for (l2 = 0L; l2 < lArray[1] / (long)n; ++l2) {
                this.Language_ID.read((byte[])objectArray);
                randomOutputable.write((byte[])objectArray, 0, n);
            }
            int n3 = (int)(lArray[1] - (long)n * l2);
            this.Language_ID.read((byte[])objectArray, 0, n3);
            randomOutputable.write((byte[])objectArray, 0, n3);
        }
    }

    private void Language_ID() throws IOException {
        this.Language_ID.seek(4L);
        int n = IOTool.readUSHORT(this.Language_ID);
        int n2 = IOTool.readUSHORT(this.Language_ID);
        int n3 = IOTool.readUSHORT(this.Language_ID);
        int n4 = IOTool.readUSHORT(this.Language_ID);
        boolean bl = false;
        try {
            this.tableEntries = new IntKeyHashtable((int)Math.ceil((double)n / 0.75));
            for (int i = 0; i < n; ++i) {
                int n5 = (int)IOTool.readULONG(this.Language_ID);
                long l = IOTool.readULONG(this.Language_ID);
                long l2 = IOTool.readULONG(this.Language_ID);
                long l3 = IOTool.readULONG(this.Language_ID);
                this.tableEntries.put(n5, new long[]{l2, l3, l});
            }
            if (!this.Platform_ID) {
                this.ocmaps = cmap.make((long[])this.tableEntries.get(1668112752), this.Language_ID);
                this.ohead = new head();
                this.ohead.read(this, this.Language_ID);
                this.ohhea = new hhea();
                this.ohhea.read(this, this.Language_ID);
                this.ohmtx = new hmtx();
                this.ohmtx.read(this, this.Language_ID);
                this.omaxp = new maxp();
                this.omaxp.read(this, this.Language_ID);
            }
            this.oname = new name();
            this.oname.read(this, this.Language_ID);
            if (this.Platform_ID) {
                return;
            }
            this.oloca = new loca();
            this.oloca.read(this, this.Language_ID);
            this.opost = new post();
            this.opost.read(this, this.Language_ID);
            this.Name_ID = glyf.make(this, this.Language_ID);
            if (this.tableEntries.containsKey(1330851634)) {
                this.oos2 = new OS2();
                this.oos2.read(this, this.Language_ID);
            }
        }
        catch (Throwable throwable) {
            bl = true;
        }
        if (bl) {
            throw new IOException("Font file corrupted or bad format.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public glyf getGlyphByIndex(int n) {
        glyf glyf2 = this.Name_ID[n];
        if (glyf2 == null) {
            OpenTypeFont openTypeFont = this;
            synchronized (openTypeFont) {
                try {
                    glyf2 = glyf.readGlyf(this, n, this.Language_ID);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.Name_ID[n] = glyf2;
        }
        return glyf2;
    }

    public JShapeble[] getGlyphs(boolean bl, String string, int n, float f, float f2, float f3) {
        int n2 = string.length();
        JShapeble[] jShapebleArray = null;
        float f4 = this.getScale(n, f);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = this.getGlyphIndex(string.charAt(i));
            JShapeble[] jShapebleArray2 = this.S(bl, n4, f2, f3, f4, f4, null);
            jShapebleArray = OpenTypeFont.Platform_ID(jShapebleArray, jShapebleArray2, i + n3);
            n3 += jShapebleArray2.length - 1;
            f2 += this.Name_ID(n4, f4);
        }
        return jShapebleArray;
    }

    private final float Name_ID(int n, float f) {
        float f2 = this.ohmtx.lsb.length <= n ? (float)this.ohhea.advanceWidthMax * f : (float)this.ohmtx.advanceWidth[n] * f;
        return f2;
    }

    public JShapeble[] getGlyphs(boolean bl, int[] nArray, float f, float f2, float f3) {
        JShapeble[] jShapebleArray = null;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            JShapeble[] jShapebleArray2 = this.S(bl, n2, f2, f3, f, f, null);
            jShapebleArray = OpenTypeFont.Platform_ID(jShapebleArray, jShapebleArray2, i + n);
            n += jShapebleArray2.length - 1;
            f2 += this.Name_ID(n2, f);
        }
        return jShapebleArray;
    }

    private static JShapeble[] Platform_ID(JShapeble[] jShapebleArray, JShapeble[] jShapebleArray2, int n) {
        JShapeble[] jShapebleArray3 = new JShapeble[(jShapebleArray != null ? jShapebleArray.length : 0) + jShapebleArray2.length];
        if (jShapebleArray != null) {
            System.arraycopy(jShapebleArray, 0, jShapebleArray3, 0, n);
        }
        System.arraycopy(jShapebleArray2, 0, jShapebleArray3, n, jShapebleArray2.length);
        return jShapebleArray3;
    }

    public final int getGlyphIndex(char c) {
        int n = -1;
        for (int i = 0; i < this.ocmaps.length && (n = this.ocmaps[i].getGlyphIndex(c)) == 0; ++i) {
        }
        return n;
    }

    public JShapeble[] getGlyph(boolean bl, char c, int n, int n2, float f, float f2) {
        float f3 = this.getScale(n, n2);
        return this.S(bl, this.getGlyphIndex(c), f, f2, f3, f3, null);
    }

    public final float getScale(int n, float f) {
        return f * (float)n / (float)(72 * this.ohead.unitsPerEm);
    }

    private JShapeble[] S(boolean bl, int n, float f, float f2, float f3, float f4, comGlyf comGlyf2) {
        JShapeble[] jShapebleArray = null;
        glyf glyf2 = this.getGlyphByIndex(n);
        if (glyf2.numberOfContours < 0) {
            if (comGlyf2 != null) {
                f3 *= comGlyf2.getXScale();
                f4 *= comGlyf2.getYScale();
            }
            int n2 = glyf2.componentData.size();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                comGlyf comGlyf3 = (comGlyf)glyf2.componentData.elementAt(i);
                JShapeble[] jShapebleArray2 = this.S(bl, comGlyf3.glyphIndex, f, f2, f3, f4, comGlyf3);
                jShapebleArray = OpenTypeFont.Platform_ID(jShapebleArray, jShapebleArray2, i + n3);
                n3 += jShapebleArray2.length - 1;
            }
        } else {
            jShapebleArray = new JShapeble[]{this.SEDU(bl, glyf2, f, f2, f3, f4, comGlyf2)};
        }
        return jShapebleArray;
    }

    private JShapeble SEDU(boolean bl, glyf glyf2, float f, float f2, float f3, float f4, comGlyf comGlyf2) {
        JShapeble jShapeble = null;
        jShapeble = bl ? new JShape2D() : new JShape();
        int n = 0;
        float[] fArray2 = new float[8];
        for (int i = 0; i < glyf2.numberOfContours; ++i) {
            int n2 = glyf2.endPtsOfContours[i] + 1;
            int n3 = 0;
            int n4 = glyf2.flags[n] & 0xFF;
            float f5 = f + (comGlyf2 == null ? (float)glyf2.xCoordinates[n] * f3 : comGlyf2.getX(f3, glyf2.xCoordinates[n], glyf2.yCoordinates[n]));
            float f6 = f2 - (comGlyf2 == null ? (float)glyf2.yCoordinates[n] * f4 : comGlyf2.getY(f4, glyf2.xCoordinates[n], glyf2.yCoordinates[n]));
            jShapeble.moveTo(f5, f6);
            fArray2 = this.advanceWidthMax(fArray2, n3, f5, f6);
            ++n3;
            for (int j = n + 1; j < n2 + 1; ++j) {
                if (j == n2) {
                    n4 = glyf2.flags[n] & 0xFF;
                    f5 = f + (comGlyf2 == null ? (float)glyf2.xCoordinates[n] * f3 : comGlyf2.getX(f3, glyf2.xCoordinates[n], glyf2.yCoordinates[n]));
                    f6 = f2 - (comGlyf2 == null ? (float)glyf2.yCoordinates[n] * f4 : comGlyf2.getY(f4, glyf2.xCoordinates[n], glyf2.yCoordinates[n]));
                } else {
                    n4 = glyf2.flags[j] & 0xFF;
                    f5 = f + (comGlyf2 == null ? (float)glyf2.xCoordinates[j] * f3 : comGlyf2.getX(f3, glyf2.xCoordinates[j], glyf2.yCoordinates[j]));
                    f6 = f2 - (comGlyf2 == null ? (float)glyf2.yCoordinates[j] * f4 : comGlyf2.getY(f4, glyf2.xCoordinates[j], glyf2.yCoordinates[j]));
                }
                if ((n4 & 1) != 0) {
                    if (n3 == 1) {
                        jShapeble.lineTo(f5, f6);
                        n3 = 0;
                    } else if (n3 == 2) {
                        jShapeble.quadTo(fArray2[2], fArray2[3], f5, f6);
                        n3 = 0;
                    } else {
                        int n5;
                        int n6 = n5 * 2;
                        for (n5 = 1; n5 < n3 - 1; ++n5) {
                            n6 = n5 * 2;
                            float[] fArray3 = OpenTypeFont.advanceWidth(fArray2[n6], fArray2[n6 + 1], fArray2[n6 + 2], fArray2[n6 + 3]);
                            jShapeble.quadTo(fArray2[n6], fArray2[n6 + 1], fArray3[0], fArray3[1]);
                        }
                        jShapeble.quadTo(fArray2[n6 + 2], fArray2[n6 + 3], f5, f6);
                        n3 = 0;
                    }
                }
                fArray2 = this.advanceWidthMax(fArray2, n3, f5, f6);
                ++n3;
            }
            n = n2;
        }
        return jShapeble;
    }

    private static float[] advanceWidth(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        float[] fArray2 = new float[]{f + f5 / 2.0f, f2 + f6 / 2.0f};
        return fArray2;
    }

    private float[] advanceWidthMax(float[] fArray2, int n, float f, float f2) {
        float[] fArray3 = fArray2;
        if (fArray2.length < n * 2 + 2) {
            fArray3 = new float[fArray2.length * 2];
            System.arraycopy(fArray2, 0, fArray3, 0, fArray2.length);
        }
        fArray3[n * 2] = f;
        fArray3[n * 2 + 1] = f2;
        return fArray3;
    }

    @Override
    public void draw(Graphics graphics, String string, float f, float f2) {
        JFontEnv jFontEnv = (JFontEnv)((Object)graphics.getFont());
        boolean bl = JGraphics.is2D(graphics);
        if (!bl) {
            int n = string.length();
            float f3 = f;
            float f4 = this.getScale(jFontEnv.getResolution(), jFontEnv.getPoints());
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = this.getGlyphIndex(string.charAt(i));
                ExPolygon[] exPolygonArray = (ExPolygon[])this.S.get(n2);
                if (exPolygonArray == null) {
                    JShapeble[] jShapebleArray = this.S(false, n2, 0.0f, 0.0f, 1.0f, 1.0f, null);
                    exPolygonArray = new ExPolygon[jShapebleArray.length];
                    for (int j = 0; j < jShapebleArray.length; ++j) {
                        exPolygonArray[j] = BezierTool.getPolygon((JShape)jShapebleArray[j], graphics, 3);
                    }
                    this.S.put(n2, exPolygonArray);
                }
                for (int j = 0; j < exPolygonArray.length; ++j) {
                    ExPolygon exPolygon = exPolygonArray[j].dup();
                    exPolygon.zoom(f4);
                    exPolygon.fill(graphics, f3, f2);
                }
                f3 += this.Name_ID(n2, f4);
            }
        }
    }

    @Override
    public FontMetrics getFontMetrics(JFontEnv jFontEnv) {
        return new TrueTypeFontMetrics((Font)((Object)jFontEnv));
    }

    @Override
    public FontMetrics getFontMetrics() {
        throw new Error("Can not access this method");
    }

    @Override
    public JFontHeader getFontHeader() {
        JFontHeader jFontHeader = new JFontHeader(this);
        jFontHeader.setSubType("True Type");
        jFontHeader.setBaseFont(this.oname.getPostName());
        jFontHeader.setFirstChar(this.oos2.usFirstbyteIndex);
        jFontHeader.setLastChar(255);
        jFontHeader.setEncoding(this.oname.nameRecords[0].encoding_ID);
        return jFontHeader;
    }

    @Override
    public void writeTo(RandomOutputable randomOutputable) throws IOException {
        this.outputCondensedForm(randomOutputable);
    }

    @Override
    public int getStyle() {
        int n = 0;
        String string = this.oname.getName(2);
        if (string.indexOf("Italic") != -1) {
            n |= 2;
        }
        if (string.indexOf("Bold") != -1) {
            n |= 1;
        }
        return n;
    }

    @Override
    public int[] getWidths() {
        int[] nArray = new int[256];
        int n = 0;
        boolean bl = this.isAsiaFont();
        for (int i = this.oos2.usFirstbyteIndex; i < 256; ++i) {
            n = this.getGlyphIndex((char)i);
            nArray[i] = bl || n == 0 || this.ohmtx.lsb.length <= n ? (int)((double)((float)this.oos2.xAvgbyteWidth * this.getScale(1, 72.0f)) * 1000.0) : (int)((double)((float)this.ohmtx.advanceWidth[n] * this.getScale(1, 72.0f)) * 1000.0);
        }
        return nArray;
    }

    @Override
    public void setFontEnv(JFontEnv jFontEnv) {
    }

    @Override
    public String getMapFontName() {
        return this.oname.getMapName();
    }

    @Override
    public String getPSName() {
        return this.oname.getPostName();
    }

    @Override
    public boolean isAsiaFont() {
        return this.oname.isAsiaFont();
    }

    @Override
    public String getBaseName() {
        return this.oname.getBasePSName();
    }

    @Override
    public void unload() {
        try {
            this.Language_ID.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

