/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt.font.truetype;

import com.jinfonet.awt.JFontMetrics;
import com.jinfonet.awt.font.JMFont;
import com.jinfonet.awt.font.truetype.OpenTypeFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;

public class TrueTypeFontMetrics
extends FontMetrics
implements JFontMetrics {
    private OpenTypeFont Ascender;
    private JMFont Descender;

    public TrueTypeFontMetrics(Font font) {
        super(font);
        this.Descender = (JMFont)font;
        this.Ascender = (OpenTypeFont)this.Descender.getImplFont();
    }

    @Override
    public int getLeading() {
        return (int)(0.9999 + (double)((float)Math.abs(this.Ascender.ohhea.LineGap) * this.F()));
    }

    @Override
    public int getAscent() {
        return (int)(0.9999 + (double)((float)this.Ascender.ohhea.Ascender * this.F()));
    }

    @Override
    public int getDescent() {
        return (int)(0.9999 + (double)((float)Math.abs(this.Ascender.ohhea.Descender) * this.F()));
    }

    @Override
    public int charsWidth(char[] cArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += this.Descender(cArray[i]);
        }
        return (int)Math.round(d + this.Ascender() + 0.5);
    }

    private final double Ascender() {
        if (this.Ascender.opost != null && this.Ascender.opost.italicAngle != 0.0f) {
            double d = (double)this.getHeight() / 2.0 * Math.tan((double)Math.abs(this.Ascender.opost.italicAngle) / 180.0);
            return d;
        }
        return 0.0;
    }

    @Override
    public int getHeight() {
        return (int)(0.9999 + (double)(Math.abs(this.Ascender.ohhea.LineGap) + this.Ascender.ohhea.Ascender + Math.abs(this.Ascender.ohhea.Descender)) * (double)this.F());
    }

    private final double Descender(char c) {
        int n = this.Ascender.getGlyphIndex(c);
        if (this.Ascender.ohmtx == null || this.Ascender.ohmtx.lsb.length <= n) {
            return (float)this.Ascender.ohhea.advanceWidthMax * this.F();
        }
        return (float)this.Ascender.ohmtx.advanceWidth[n] * this.F();
    }

    @Override
    public int charWidth(char c) {
        return (int)(0.9999 + (this.Descender(c) + this.Ascender()));
    }

    private float F() {
        return this.Ascender.getScale(this.Descender.getResolution(), this.Descender.getPoints());
    }

    @Override
    public float getAvgWidth() {
        float f = this.F();
        return (float)this.Ascender.oos2.xAvgbyteWidth * f;
    }

    @Override
    public int getFlags() {
        int n = 0;
        n |= 0x20;
        if (this.Ascender.opost != null) {
            if (this.Ascender.opost.isMonospaced) {
                n |= 1;
            }
            if (this.Ascender.opost.italicAngle != 0.0f) {
                n |= 0x40;
            }
        }
        if (this.Ascender.oos2 != null) {
            if (this.Ascender.oos2.panose[1] != 0 && this.Ascender.oos2.panose[1] != 1 && this.Ascender.oos2.panose[1] != 11 && this.Ascender.oos2.panose[1] != 12 && this.Ascender.oos2.panose[1] != 13) {
                n |= 2;
            }
            if (this.Ascender.oos2.panose[0] == 3) {
                n |= 8;
            } else {
                n |= 4;
                n &= 0xFFFFFFDF;
            }
        }
        return n;
    }

    @Override
    public int getCapHeight() {
        int n = -1;
        int n2 = this.Ascender.getGlyphIndex('H');
        if (n2 >= 0) {
            n = (int)(0.9999 + (double)((float)this.Ascender.getGlyphByIndex((int)n2).yMax * this.Ascender.getScale(1, 72.0f) * 1000.0f));
        }
        return n;
    }

    @Override
    public int getStemV() {
        int n = -1;
        int n2 = this.Ascender.getGlyphIndex('E');
        if (n2 >= 0) {
            // empty if block
        }
        n = 100;
        return n;
    }

    @Override
    public Rectangle getFontBBox() {
        Rectangle rectangle = null;
        if (this.Ascender.ohead != null) {
            rectangle = new Rectangle((int)(0.9999 + (double)((float)this.Ascender.ohead.xMin * this.Ascender.getScale(1, 72.0f) * 1000.0f)), (int)(0.9999 + (double)((float)this.Ascender.ohead.yMin * this.Ascender.getScale(1, 72.0f) * 1000.0f)), (int)(0.9999 + (double)((float)this.Ascender.ohead.xMax * this.Ascender.getScale(1, 72.0f) * 1000.0f)), (int)(0.9999 + (double)((float)this.Ascender.ohead.yMax * this.Ascender.getScale(1, 72.0f) * 1000.0f)));
        }
        return rectangle;
    }

    @Override
    public int getItalicAngle() {
        int n = 0;
        if (this.Ascender.opost != null) {
            n = Math.round(this.Ascender.opost.italicAngle);
        }
        return n;
    }

    @Override
    public int getPDFAscent() {
        return (int)(0.9999 + (double)((float)this.Ascender.ohhea.Ascender * this.Ascender.getScale(1, 72.0f) * 1000.0f));
    }

    @Override
    public int getPDFDescent() {
        return (int)(0.9999 + (double)((float)this.Ascender.ohhea.Descender * this.Ascender.getScale(1, 72.0f) * 1000.0f));
    }
}

