/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.css.regularlib;

import com.jinfonet.css.regularlib.PropertyKeyWord;
import com.jinfonet.css.regularlib.SelectorKeyWord;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CSSRegulationV8 {
    private static final int SEDU = 2;
    public final int selectorID;
    private Hashtable add;

    CSSRegulationV8(int n) {
        this.selectorID = n;
        this.add = new Hashtable();
    }

    Property appendProperty(int n, int n2) {
        Property property = new Property(n, n2);
        this.add.put(n, property);
        return property;
    }

    Property appendProperty(int n, int n2, boolean bl) {
        Property property = new Property(n, n2, bl);
        this.add.put(n, property);
        return property;
    }

    void appendProperty(Property property) {
        int n = property.getPropertyID();
        this.add.put(n, property);
    }

    public int getSelectorID() {
        return this.selectorID;
    }

    public String getSelectorName() {
        return SelectorKeyWord.getSelectorName(this.selectorID);
    }

    public Property getProperty(int n) {
        return (Property)this.add.get(n);
    }

    public Property getPropertyByName(String string) {
        int n = PropertyKeyWord.getPropertyID(string);
        return (Property)this.add.get(n);
    }

    public Vector getAllProperties() {
        return new Vector(this.add.values());
    }

    public Vector getRecommendProperties() {
        Iterator iterator = this.add.values().iterator();
        Vector<Property> vector = new Vector<Property>(this.add.size());
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.isDeprecated()) continue;
            vector.add(property);
        }
        return vector;
    }

    public static class Property
    implements Comparable {
        private final int SEDU;
        private final int add;
        private final boolean append;
        private List compareTo;

        protected Property(int n, int n2) {
            this(n, n2, false);
        }

        Property(int n, int n2, boolean bl) {
            this.SEDU = n;
            this.add = n2;
            this.append = bl;
        }

        void setAdvanceMappingTo(String ... stringArray) {
            this.compareTo = new Vector(stringArray.length);
            for (String string : stringArray) {
                this.compareTo.add(string);
            }
        }

        public int getPropertyID() {
            return this.SEDU;
        }

        public int getPropertyType() {
            return this.add;
        }

        public boolean isDeprecated() {
            return this.append;
        }

        public String getPropertyName() {
            return PropertyKeyWord.getPropertyName(this.SEDU);
        }

        public List getAdvanceMappingTo() {
            return this.compareTo;
        }

        public boolean equals(Object object) {
            if (object instanceof Property) {
                return this.SEDU == ((Property)object).SEDU;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public int compareTo(Property property) {
            return this.SEDU - property.SEDU;
        }

        public String toString() {
            return PropertyKeyWord.getPropertyName(this.SEDU) + "(type=" + this.add + ",deprecated= " + this.append + ")";
        }
    }
}

