/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.css.util;

import com.jinfonet.css.util.CharsetValidate;
import com.jinfonet.dom.css.JCSSPageRule;
import com.jinfonet.dom.css.JCSSProperty;
import com.jinfonet.dom.css.JCSSRuleFactory;
import com.jinfonet.dom.css.JCSSStyleRule;
import com.jinfonet.util.JRLog;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSFontFaceRule;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSPageRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSDOMWriter {
    static CSSDOMWriter writer = null;

    private String SEDU(String string) {
        return JCSSRuleFactory.escapeCSSText(string);
    }

    public synchronized void writeCSSStyleSheet(Writer writer, CSSStyleSheet cSSStyleSheet) {
        block7: {
            if (cSSStyleSheet == null || writer == null) {
                return;
            }
            CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
            StringBuffer stringBuffer = new StringBuffer("");
            int n = cSSRuleList.getLength();
            if (n > 0) {
                CSSRule cSSRule = cSSRuleList.item(0);
                if (cSSRule.getType() != 2) {
                    stringBuffer.append(JCSSRuleFactory.createCSSCharsetRule(CharsetValidate.getDefaultCharset()).getCssText() + "\r\n");
                }
                for (int i = 0; i < n; ++i) {
                    String string;
                    cSSRule = cSSRuleList.item(i);
                    String string2 = cSSRule.getCssText() + "\r\n";
                    if (string2.startsWith("*") && !(string = string2.substring(1).trim()).startsWith("{")) {
                        string2 = string;
                    }
                    stringBuffer.append(this.SEDU(string2));
                }
            }
            try {
                writer.write(stringBuffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block7;
                JRLog.error(2, 2205017, stringBuffer.toString());
            }
        }
    }

    public synchronized void writeCSSRuleList(Writer writer, CSSRuleList cSSRuleList) {
        block5: {
            if (writer == null || cSSRuleList == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            int n = cSSRuleList.getLength();
            for (int i = 0; i < n; ++i) {
                String string;
                CSSRule cSSRule = cSSRuleList.item(i);
                String string2 = cSSRule.getCssText() + "\r\n";
                if (string2.startsWith("*") && !(string = string2.substring(1).trim()).startsWith("{")) {
                    string2 = string;
                }
                stringBuffer.append(this.SEDU(string2));
            }
            try {
                writer.write(stringBuffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, 2205017, stringBuffer.toString());
            }
        }
    }

    public synchronized void writeCSSRuleListX(Writer writer, CSSRuleList cSSRuleList) {
        int n = cSSRuleList.getLength();
        block8: for (int i = 0; i < n; ++i) {
            CSSRule cSSRule = cSSRuleList.item(i);
            short s = cSSRule.getType();
            switch (s) {
                case 2: {
                    this.writeCharsetRuleX(writer, (CSSCharsetRule)cSSRule);
                    continue block8;
                }
                case 5: {
                    this.writeFontFaceRuleX(writer, (CSSFontFaceRule)cSSRule);
                    continue block8;
                }
                case 3: {
                    this.writeImportRuleX(writer, (CSSImportRule)cSSRule);
                    continue block8;
                }
                case 4: {
                    this.writeMediaRuleX(writer, (CSSMediaRule)cSSRule);
                    continue block8;
                }
                case 6: {
                    this.writePageRuleX(writer, (CSSPageRule)cSSRule);
                    continue block8;
                }
                case 1: {
                    this.writeStyleRuleX(writer, (CSSStyleRule)cSSRule);
                    continue block8;
                }
            }
        }
    }

    protected void writeCharsetRuleX(Writer writer, CSSCharsetRule cSSCharsetRule) {
        block3: {
            if (writer == null || cSSCharsetRule == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("@charset ");
            stringBuffer.append("\"");
            stringBuffer.append(cSSCharsetRule.getEncoding());
            stringBuffer.append("\";\r\n");
            try {
                writer.write(stringBuffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, 2205017, stringBuffer.toString());
            }
        }
    }

    protected void writeFontFaceRuleX(Writer writer, CSSFontFaceRule cSSFontFaceRule) {
        if (JRLog.isError(2)) {
            JRLog.error(2, 2205018, cSSFontFaceRule.toString());
        }
    }

    protected void writeImportRuleX(Writer writer, CSSImportRule cSSImportRule) {
        block3: {
            if (writer == null || cSSImportRule == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("@import ");
            stringBuffer.append("URL(");
            stringBuffer.append(cSSImportRule.getHref());
            stringBuffer.append(") ");
            this.append(stringBuffer, cSSImportRule.getMedia());
            stringBuffer.append(";\r\n");
            try {
                writer.write(stringBuffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, 2205017, stringBuffer.toString());
            }
        }
    }

    protected void writeMediaRuleX(Writer writer, CSSMediaRule cSSMediaRule) {
        block3: {
            if (writer == null || cSSMediaRule == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("@Media ");
            this.append(stringBuffer, cSSMediaRule.getMedia());
            try {
                writer.write(stringBuffer.toString());
                this.writeCSSRuleListX(writer, cSSMediaRule.getCssRules());
                writer.flush();
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, 2205017, stringBuffer.toString());
            }
        }
    }

    protected void writePageRuleX(Writer writer, CSSPageRule cSSPageRule) {
        block3: {
            if (writer == null || cSSPageRule == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("@page ");
            this.error(stringBuffer, ((JCSSPageRule)cSSPageRule).getDeclarations());
            try {
                writer.write(stringBuffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, 2205017, stringBuffer.toString());
            }
        }
    }

    protected void writeStyleRuleX(Writer writer, CSSStyleRule cSSStyleRule) {
        block3: {
            if (writer == null || cSSStyleRule == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("");
            this.createCSSCharsetRule(stringBuffer, ((JCSSStyleRule)cSSStyleRule).getSelectors());
            this.error(stringBuffer, ((JCSSStyleRule)cSSStyleRule).getDeclarations());
            try {
                writer.write(stringBuffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block3;
                JRLog.error(2, 2205017, stringBuffer.toString());
            }
        }
    }

    private void append(StringBuffer stringBuffer, MediaList mediaList) {
        int n = mediaList.getLength();
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                stringBuffer.append(mediaList.item(i));
                stringBuffer.append(",");
            }
            stringBuffer.append(mediaList.item(n - 1));
        }
    }

    private void createCSSCharsetRule(StringBuffer stringBuffer, SelectorList selectorList) {
        int n = selectorList.getLength();
        for (int i = 0; i < n; ++i) {
            this.escapeCSSText(stringBuffer, selectorList.item(i));
        }
    }

    private void error(StringBuffer stringBuffer, Hashtable hashtable) {
        stringBuffer.append("{");
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            JCSSProperty jCSSProperty = (JCSSProperty)hashtable.get(enumeration.nextElement());
            stringBuffer.append(jCSSProperty.getName());
            stringBuffer.append(":");
            stringBuffer.append(this.SEDU(jCSSProperty.getValue().getCssText()));
            if (jCSSProperty.isImportant()) {
                stringBuffer.append(" ! Important");
            }
            stringBuffer.append(";");
        }
        stringBuffer.append("}\r\n");
    }

    private void escapeCSSText(StringBuffer stringBuffer, Selector selector) {
        switch (selector.getSelectorType()) {
            case 10: 
            case 11: {
                DescendantSelector descendantSelector = (DescendantSelector)selector;
                this.escapeCSSText(stringBuffer, descendantSelector.getAncestorSelector());
                this.escapeCSSText(stringBuffer, (Selector)descendantSelector.getSimpleSelector());
                break;
            }
            case 12: {
                SiblingSelector siblingSelector = (SiblingSelector)selector;
                this.escapeCSSText(stringBuffer, siblingSelector.getSelector());
                this.escapeCSSText(stringBuffer, (Selector)siblingSelector.getSiblingSelector());
                break;
            }
            case 0: {
                ConditionalSelector conditionalSelector = (ConditionalSelector)selector;
                this.escapeCSSText(stringBuffer, (Selector)conditionalSelector.getSimpleSelector());
                this.flush(stringBuffer, conditionalSelector.getCondition());
                break;
            }
            case 9: {
                break;
            }
            case 4: {
                ElementSelector elementSelector = (ElementSelector)selector;
                stringBuffer.append(elementSelector.getLocalName() == null ? "*" : elementSelector.getLocalName());
                break;
            }
        }
    }

    private void flush(StringBuffer stringBuffer, Condition condition) {
        switch (condition.getConditionType()) {
            case 8: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                stringBuffer.append("[");
                stringBuffer.append(attributeCondition.getLocalName());
                if (attributeCondition.getValue() != null) {
                    stringBuffer.append("|=\"");
                    stringBuffer.append(this.SEDU(attributeCondition.getValue()));
                }
                stringBuffer.append("\"]");
                break;
            }
            case 4: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                stringBuffer.append("[");
                stringBuffer.append(attributeCondition.getLocalName());
                if (attributeCondition.getValue() != null) {
                    stringBuffer.append("=\"");
                    stringBuffer.append(this.SEDU(attributeCondition.getValue()));
                }
                stringBuffer.append("\"]");
                break;
            }
            case 7: {
                AttributeCondition attributeCondition = (AttributeCondition)condition;
                stringBuffer.append("[");
                stringBuffer.append(attributeCondition.getLocalName());
                if (attributeCondition.getValue() != null) {
                    stringBuffer.append("~=\"");
                    stringBuffer.append(this.SEDU(attributeCondition.getValue()));
                }
                stringBuffer.append("\"]");
                break;
            }
            case 9: {
                stringBuffer.append(".");
                stringBuffer.append(this.SEDU(((AttributeCondition)condition).getValue()));
                break;
            }
            case 5: {
                stringBuffer.append("#");
                stringBuffer.append(this.SEDU(((AttributeCondition)condition).getValue()));
                break;
            }
            case 10: {
                stringBuffer.append(":");
                stringBuffer.append(this.SEDU(((AttributeCondition)condition).getValue()));
                break;
            }
            case 0: {
                CombinatorCondition combinatorCondition = (CombinatorCondition)condition;
                this.flush(stringBuffer, combinatorCondition.getFirstCondition());
                this.flush(stringBuffer, combinatorCondition.getSecondCondition());
                break;
            }
            case 6: {
                stringBuffer.append(":Lang(");
                stringBuffer.append(((LangCondition)condition).getLang());
                stringBuffer.append(")");
                break;
            }
        }
    }

    public static synchronized CSSDOMWriter newInstance() {
        if (writer == null) {
            writer = new CSSDOMWriter();
        }
        return writer;
    }
}

