/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.dataservice.enviroment;

import com.jinfonet.dataservice.enviroment.TaskWork;
import com.jinfonet.dataservice.enviroment.util.TaskQueue;
import java.util.LinkedList;

public class ThreadPool {
    private final int SEDU = 0;
    private final int Z = 1;
    private final int add = 2;
    private final int addProducer = 3;
    private int clear = 0;
    private int hasNext;
    private final TaskQueue isEmpty = new TaskQueue();
    private final LinkedList isRunning = new LinkedList();
    private int iterator = 0;
    private final Object next = new Object();

    public ThreadPool(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.hasNext = n;
        this.isEmpty.addProducer();
        for (int i = 0; i < n; ++i) {
            this.Z();
        }
        this.clear = 1;
    }

    public synchronized void setMaxNumOfThreads(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.SEDU(1);
        this.hasNext = n;
    }

    public synchronized int getMaxNumOfThreads() {
        this.SEDU(1);
        return this.hasNext;
    }

    public synchronized int getCurrentNumOfThreads() {
        return this.isRunning.size();
    }

    public synchronized void execute(TaskWork taskWork) {
        this.SEDU(1);
        if (this.isRunning.size() < this.hasNext) {
            for (int i = this.isRunning.size(); i <= this.hasNext; ++i) {
                this.Z();
            }
        }
        this.isEmpty.produce(taskWork);
    }

    public synchronized void interruptAll() {
        this.SEDU(1);
        this.clear = 2;
        this.isEmpty.stopProduce();
        for (Worker worker : this.isRunning) {
            worker.isRunning = false;
            worker.interrupt();
        }
        this.isEmpty.clear();
        this.clear = 3;
    }

    public synchronized void shutdown() throws InterruptedException {
        this.SEDU(1);
        this.clear = 2;
        this.hasNext = 0;
        for (Worker worker : this.isRunning) {
            worker.isRunning = false;
        }
        this.isEmpty.stopProduce();
        while (!this.isRunning.isEmpty()) {
            this.wait();
        }
        this.clear = 3;
    }

    private void SEDU(int n) {
        if (this.clear != n) {
            throw new IllegalStateException();
        }
    }

    private void Z() {
        Worker worker = new Worker();
        this.isRunning.add(worker);
        worker.start();
    }

    private synchronized boolean add(Worker worker) {
        boolean bl;
        boolean bl2 = bl = this.isRunning.size() > this.hasNext;
        if (bl) {
            this.isRunning.remove(worker);
        }
        this.notify();
        return bl;
    }

    private class Worker
    extends Thread {
        volatile boolean isRunning = false;

        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isRunning = true;
            while (this.isRunning) {
                Object object;
                try {
                    TaskWork taskWork = (TaskWork)ThreadPool.this.isEmpty.consume();
                    if (taskWork == null || !this.isRunning) {
                        return;
                    }
                    object = ThreadPool.this.next;
                    synchronized (object) {
                        ++ThreadPool.this.iterator;
                        while (this.isRunning && !taskWork.haveEnoughResource()) {
                            ThreadPool.this.next.wait();
                        }
                        --ThreadPool.this.iterator;
                    }
                    if (!this.isRunning) {
                        return;
                    }
                    taskWork.run();
                    taskWork.processException();
                    taskWork = null;
                }
                catch (InterruptedException interruptedException) {
                    object = ThreadPool.this.next;
                    synchronized (object) {
                        if (ThreadPool.this.iterator > 0) {
                            ThreadPool.this.next.notify();
                        }
                    }
                    if (!ThreadPool.this.add(this)) continue;
                    return;
                }
                catch (RuntimeException runtimeException) {
                    object = ThreadPool.this.next;
                    synchronized (object) {
                        if (ThreadPool.this.iterator > 0) {
                            ThreadPool.this.next.notify();
                        }
                    }
                    if (!ThreadPool.this.add(this)) continue;
                    return;
                }
                finally {
                    object = ThreadPool.this.next;
                    synchronized (object) {
                        if (ThreadPool.this.iterator > 0) {
                            ThreadPool.this.next.notify();
                        }
                    }
                    if (!ThreadPool.this.add(this)) continue;
                    return;
                }
            }
        }
    }
}

